#include "../include.h"

// format: 8-bit paletted pixel graphics
// image width: 160 pixels
// image height: 18 lines
// image pitch: 160 bytes
const u16 ImgTiles_Pal[256] __attribute__ ((aligned(4))) = {
	0x0000, 0x000A, 0x0015, 0x001F, 0x0120, 0x012A, 0x0135, 0x013F, 0x0240, 0x024A, 0x0255, 0x025F, 0x0360, 0x036A, 0x0375, 0x037F, 
	0x0480, 0x048A, 0x0495, 0x049F, 0x05A0, 0x05AA, 0x05B5, 0x05BF, 0x06C0, 0x06CA, 0x06D5, 0x06DF, 0x07E0, 0x07EA, 0x07F5, 0x07FF, 
	0x2000, 0x200A, 0x2015, 0x201F, 0x2120, 0x212A, 0x2135, 0x213F, 0x2240, 0x224A, 0x2255, 0x225F, 0x2360, 0x236A, 0x2375, 0x237F, 
	0x2480, 0x248A, 0x2495, 0x249F, 0x25A0, 0x25AA, 0x25B5, 0x25BF, 0x26C0, 0x26CA, 0x26D5, 0x26DF, 0x27E0, 0x27EA, 0x27F5, 0x27FF, 
	0x4800, 0x480A, 0x4815, 0x481F, 0x4920, 0x492A, 0x4935, 0x493F, 0x4A40, 0x4A4A, 0x4A55, 0x4A5F, 0x4B60, 0x4B6A, 0x4B75, 0x4B7F, 
	0x4C80, 0x4C8A, 0x4C95, 0x4C9F, 0x4DA0, 0x4DAA, 0x4DB5, 0x4DBF, 0x4EC0, 0x4ECA, 0x4ED5, 0x4EDF, 0x4FE0, 0x4FEA, 0x4FF5, 0x4FFF, 
	0x6800, 0x680A, 0x6815, 0x681F, 0x6920, 0x692A, 0x6935, 0x693F, 0x6A40, 0x6A4A, 0x6A55, 0x6A5F, 0x6B60, 0x6B6A, 0x6B75, 0x6B7F, 
	0x6C80, 0x6C8A, 0x6C95, 0x6C9F, 0x6DA0, 0x6DAA, 0x6DB5, 0x6DBF, 0x6EC0, 0x6ECA, 0x6ED5, 0x6EDF, 0x6FE0, 0x6FEA, 0x6FF5, 0x6FFF, 
	0x9000, 0x900A, 0x9015, 0x901F, 0x9120, 0x912A, 0x9135, 0x913F, 0x9240, 0x924A, 0x9255, 0x925F, 0x9360, 0x936A, 0x9375, 0x937F, 
	0x9480, 0x948A, 0x9495, 0x949F, 0x95A0, 0x95AA, 0x95B5, 0x95BF, 0x96C0, 0x96CA, 0x96D5, 0x96DF, 0x97E0, 0x97EA, 0x97F5, 0x97FF, 
	0xB000, 0xB00A, 0xB015, 0xB01F, 0xB120, 0xB12A, 0xB135, 0xB13F, 0xB240, 0xB24A, 0xB255, 0xB25F, 0xB360, 0xB36A, 0xB375, 0xB37F, 
	0xB480, 0xB48A, 0xB495, 0xB49F, 0xB5A0, 0xB5AA, 0xB5B5, 0xB5BF, 0xB6C0, 0xB6CA, 0xB6D5, 0xB6DF, 0xB7E0, 0xB7EA, 0xB7F5, 0xB7FF, 
	0xD800, 0xD80A, 0xD815, 0xD81F, 0xD920, 0xD92A, 0xD935, 0xD93F, 0xDA40, 0xDA4A, 0xDA55, 0xDA5F, 0xDB60, 0xDB6A, 0xDB75, 0xDB7F, 
	0xDC80, 0xDC8A, 0xDC95, 0xDC9F, 0xDDA0, 0xDDAA, 0xDDB5, 0xDDBF, 0xDEC0, 0xDECA, 0xDED5, 0xDEDF, 0xDFE0, 0xDFEA, 0xDFF5, 0xDFFF, 
	0xF800, 0xF80A, 0xF815, 0xF81F, 0xF920, 0xF92A, 0xF935, 0xF93F, 0xFA40, 0xFA4A, 0xFA55, 0xFA5F, 0xFB60, 0xFB6A, 0xFB75, 0xFB7F, 
	0xFC80, 0xFC8A, 0xFC95, 0xFC9F, 0xFDA0, 0xFDAA, 0xFDB5, 0xFDBF, 0xFEC0, 0xFECA, 0xFED5, 0xFEDF, 0xFFE0, 0xFFEA, 0xFFF5, 0xFFFF, 
};

const u8 ImgTiles[2880] __attribute__ ((aligned(4))) = {
	0x00, 0x00, 0x00, 0x5F, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x5D, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xEB, 0xEB, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x00, 0xFD, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x5D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x49, 0x00, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x5F, 0x5F, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0xFD, 0x00, 0xFD, 0xFD, 0x00, 0xFD, 0x00, 
	0x00, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x5D, 0x00, 0x00, 
	0x00, 0x00, 0x5D, 0x00, 0xE9, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xFD, 0xEB, 0xEB, 0xEB, 0x00, 0x00, 0x00, 0xE9, 0x00, 0xE9, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x5F, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x5D, 0x00, 
	0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x5D, 0xFF, 0xFF, 0xFF, 0x00, 0x5D, 0x00, 
	0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 
	0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 
	0x00, 0x5D, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x5F, 0xFF, 0xFF, 0x5F, 0x5F, 0x4B, 0x00, 0x00, 0xFD, 0x00, 0xFD, 0xFD, 0x00, 0xFD, 0x00, 
	0x00, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 
	0x00, 0x00, 0xE9, 0xE9, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x00, 
	0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xFD, 0xFD, 0xEB, 0xEB, 0xEB, 0x00, 0x00, 0x00, 0xE9, 0x00, 0xE9, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x5F, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 
	0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x5D, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x5D, 
	0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 
	0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x5F, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x5F, 0xFF, 0xFF, 0x5F, 0x5F, 0x4B, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 
	0x00, 0x00, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 
	0x00, 0xE9, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0xE9, 0x00, 
	0x00, 0x00, 0x5F, 0x5F, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 
	0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xEB, 0xEB, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x6D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 
	0x00, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0x5D, 
	0x00, 0x49, 0x49, 0x49, 0x49, 0x49, 0x00, 0x49, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 
	0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0xFF, 0x4B, 0x4B, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x5F, 0x5F, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0xFD, 0xFF, 0xFF, 0xFD, 0xFD, 0xFD, 0x00, 
	0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 
	0x00, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0xFD, 0x00, 0xFD, 0x00, 0x00, 0x00, 
	0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x00, 0x00, 0x49, 0x49, 
	0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x00, 
	0x00, 0x49, 0x00, 0x00, 0x00, 0x49, 0x00, 0x49, 0x00, 0x00, 0x00, 0x5F, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
	0x00, 0x00, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x5F, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 
	0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 
	0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0xE9, 0x00, 
	0x00, 0x00, 0x5F, 0x5F, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x00, 0xFD, 0x00, 0x00, 0x00, 
	0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x49, 0x49, 0x00, 0x00, 0x49, 0x49, 
	0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x5D, 0x5D, 0x5D, 0x5D, 0xFD, 0x00, 
	0x00, 0x49, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x5F, 0x5F, 0x00, 0x00, 0x00, 
	0x00, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0x5D, 0x5D, 0x5D, 0x5D, 0xE9, 0x00, 
	0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 
	0x00, 0x00, 0x49, 0x00, 0xE9, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x49, 
	0x00, 0xE9, 0xE9, 0xE9, 0x00, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x00, 0x00, 
	0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x00, 0xFD, 0xFD, 0x00, 0x00, 
	0x00, 0x00, 0xFD, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0x00, 0x00, 
	0x00, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x00, 0x00, 
	0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 
	0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0xE9, 0xE9, 0x5D, 0x5D, 0x00, 0x5D, 0xE9, 0x00, 
	0x00, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0xE9, 0x5D, 0x5D, 0x5D, 0x5D, 0xE9, 0xE9, 
	0x00, 0x4B, 0x00, 0x00, 0x4B, 0x00, 0x4B, 0x00, 0xE9, 0xE9, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 0x00, 
	0x00, 0x4B, 0x00, 0x4B, 0x00, 0x00, 0x4B, 0x00, 0x00, 0xE9, 0x4B, 0x4B, 0x4B, 0x4B, 0xE9, 0xE9, 
	0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 
	0x00, 0xFD, 0xFD, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0x00, 
	0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 
	0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x5D, 0x00, 0x00, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 
	0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x00, 0x5D, 0x00, 0x5D, 0x00, 0x5D, 0x00, 0x00, 0x00, 0x5D, 0x5D, 0x5D, 0x5D, 0xE9, 0x00, 
	0x00, 0x5D, 0x00, 0x5D, 0x00, 0x5D, 0x00, 0x5D, 0x00, 0xE9, 0x5D, 0x00, 0x5D, 0x5D, 0xE9, 0xE9, 
	0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0xE9, 0x00, 
	0x00, 0x4B, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0xE9, 0x00, 0x00, 0x4B, 0x4B, 0xE9, 0xE9, 
	0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 
	0xFD, 0xFD, 0xFD, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 
	0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x5D, 0x00, 0x00, 0x5D, 0x5D, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 
	0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0xE9, 0xE9, 0x5D, 0x5D, 0x00, 0x5D, 0xE9, 0x00, 
	0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0xE9, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 
	0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0xE9, 0xE9, 0x4B, 0x4B, 0x00, 0x00, 0xE9, 0x00, 
	0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0xE9, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 
	0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0xFD, 0x00, 0xFD, 0xFD, 
	0xFD, 0xFD, 0xFD, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 
	0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 
	0xE9, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0x00, 
	0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0x5D, 0x5D, 0x5D, 0x5D, 0xE9, 0x00, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0x5D, 0x00, 0x5D, 0x5D, 0xE9, 0xE9, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0x4B, 0x4B, 0x4B, 0x4B, 0xE9, 0x00, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x4B, 0xE9, 0xE9, 
	0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 
	0xFD, 0xFD, 0xFD, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 
	0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 
	0xE9, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x5D, 0x00, 0x5D, 0x5D, 0x5D, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 
	0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0x5D, 0x5D, 0x5D, 0x5D, 0xE9, 0xE9, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x49, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0xE9, 0xE9, 
	0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 
	0xFD, 0xFD, 0xFD, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 
	0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x5F, 0x00, 0x00, 0x00, 0x00, 
	0x5D, 0x5D, 0x00, 0x00, 0x5D, 0x5D, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0x00, 0x00, 0xFD, 0xFD, 0x00, 
	0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x4B, 0xE9, 0xE9, 0x00, 0x00, 0x4B, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 
	0xE9, 0xE9, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0x00, 0xFD, 0xFD, 0xE9, 0x00, 0xFD, 0xFD, 0xE9, 0x00, 
	0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xE9, 
	0x00, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x4B, 0xE9, 0xE9, 0xE9, 0xE9, 0x4B, 0x00, 0x4B, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0x4B, 0x00, 
	0x00, 0xE9, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0x00, 0xFD, 0xFD, 0xE9, 0x00, 0xFD, 0x00, 0xE9, 0x00, 
	0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0x00, 0xE9, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x4B, 0xE9, 0xE9, 0xFD, 0xFD, 0x4B, 0x00, 0xE9, 0xE9, 0xFD, 0xFD, 0xFF, 0xFF, 0xE9, 0xE9, 
	0xFD, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFD, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0xE9, 0xE9, 
	0x00, 0x00, 0xE9, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x4B, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFD, 0xE9, 0xE9, 0xE9, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xFD, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x4B, 0xE9, 0xE9, 0xE9, 0xE9, 0x4B, 0x00, 0x00, 0xE9, 0xE9, 0xE9, 0x00, 0xE9, 0x00, 0xE9, 
	0xE9, 0xE9, 0xFD, 0xFD, 0xFD, 0xFD, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 
	0x00, 0x00, 0xE9, 0xE9, 0x00, 0x4B, 0xE9, 0xE9, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x4B, 0xE9, 0xE9, 
	0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 
	0x00, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0xE9, 0x00, 
	0x00, 0x00, 0x00, 0xFD, 0xFD, 0x00, 0xE9, 0x00, 0x00, 0x00, 0xE9, 0x00, 0xE9, 0x00, 0x00, 0x00, 
	0x00, 0xE9, 0xE9, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0x00, 0x00, 0xE9, 0x00, 0x00, 0xE9, 0x00, 
	0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 0x4B, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 
	0x00, 0x4B, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 0x00, 0x4B, 0x00, 0x4B, 0x4B, 0x4B, 0x4B, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};
