
BuffSize EQU       1024                     ; velikost bufferu souboru

;DEBUG    EQU       1                        ; pznak testovacho mdu

DELKOBR  EQU       (16*16/8)*4              ; dlka jednoho obrzku

POCVECI  EQU       20                       ; poet vc

LOK      EQU       1                        ; lokomotiva
LO1      EQU       LOK + 0                  ; lokomotiva VLEVO
LO2      EQU       LOK + 1                  ; lokomotiva NAHORU
LO3      EQU       LOK + 2                  ; lokomotiva VPRAVO
LO4      EQU       LOK + 3                  ; lokomotiva DOL

LO5      EQU       LOK + 4                  ; lokomotiva VLEVO
LO6      EQU       LOK + 5                  ; lokomotiva NAHORU
LO7      EQU       LOK + 6                  ; lokomotiva VPRAVO
LO8      EQU       LOK + 7                  ; lokomotiva DOL

LO9      EQU       LOK + 8                  ; lokomotiva VLEVO
LOA      EQU       LOK + 9                  ; lokomotiva NAHORU
LOB      EQU       LOK + 10                 ; lokomotiva VPRAVO
LOC      EQU       LOK + 11                 ; lokomotiva DOL

SRAZKA   EQU       LOK+12                   ; srka (10 fz)
SR1      EQU       SRAZKA+0
SR2      EQU       SRAZKA+1
SR3      EQU       SRAZKA+2
SR4      EQU       SRAZKA+3
SR5      EQU       SRAZKA+4
SR6      EQU       SRAZKA+5
SR7      EQU       SRAZKA+6
SR8      EQU       SRAZKA+7
SR9      EQU       SRAZKA+8
SRA      EQU       SRAZKA+9

ZED      EQU       SRAZKA+10                ; ze

VRA      EQU       ZED+1                    ; vrata (6 fz)

VAGONY   EQU       VRA+6                    ; vagony (kad vagon 4 smry)

VECI     EQU       VAGONY + 4*POCVECI       ; vci

;KRY      EQU       0  * 3 + VECI            ; 1: krystal
;KOR      EQU       1  * 3 + VECI            ; 2: koruna
;STO      EQU       2  * 3 + VECI            ; 3: strom
;JAB      EQU       3  * 3 + VECI            ; 4: jablko
;KRA      EQU       4  * 3 + VECI            ; 5: krva
;TRE      EQU       5  * 3 + VECI            ; 6: ten
;RYB      EQU       6  * 3 + VECI            ; 7: rybnk
;ZIR      EQU       7  * 3 + VECI            ; 8: irafa
;ZMR      EQU       8  * 3 + VECI            ; 9: zmrzlina
;DOR      EQU       9  * 3 + VECI            ; 10: dort
;POC      EQU       10 * 3 + VECI            ; 11: pota
;AUT      EQU       11 * 3 + VECI            ; 12: auto
;BAL      EQU       12 * 3 + VECI            ; 13: baln
;BUD      EQU       13 * 3 + VECI            ; 14: budk
;SLO      EQU       14 * 3 + VECI            ; 15: slon
;VIN      EQU       15 * 3 + VECI            ; 16: vno
;PEN      EQU       16 * 3 + VECI            ; 17: penze
;LET      EQU       17 * 3 + VECI            ; 18: letadlo
;RZ1      EQU       18 * 3 + VECI            ; 19: ... rezerva 1
;RZ2      EQU       19 * 3 + VECI            ; 20: ... rezerva 2

Code     SEGMENT
         ASSUME    cs:Code,ds:Data

; ------ inicializace registr

Start:   mov       ax,SEG Data
         mov       ds,ax
         mov       ds:[SegmPSP],es          ; segment PSP

; ------ zmenen bloku programu

         mov       bx,ss                    ; segment zsobnku
         add       bx,(2*200h + 100h)/ 16   ; piten velikosti zsobnku
         mov       ax,es
         sub       bx,ax                    ; velikost programu
         mov       ah,4ah
         int       21h                      ; zmenen alokanho bloku

; ------ naten souboru obrzk PCX

         call      ReadPCX                  ; naten souboru obrzk PCX
         mov       dx,offset PCXTxt         ; text - chyba PCX
         jc        Start11                  ; chyba PCX

; ------ naten souboru scn SCN

         call      ReadSCN                  ; naten souboru scn SCN
         mov       dx,offset SCNTxt         ; text - chyba SCN
         jc        Start11                  ; chyba SCN

; ------ inicializace videokarty

         call      InitVMod                 ; inicializace videomdu
         jnc       Start1                   ; inicializace je OK

; ------ chyba - nepovolen videokarta

Start10: mov       dx,offset CardTxt        ; text - nen karta EGA/VGA
Start11: mov       ah,9
         int       21h                      ; zobrazen textu DOS
         mov       ax,4c01h
         int       21h

; ------ inicializace hodin

Start1:  call      CekInit                  ; inicializace hodin

; ------ inicializace adres obrzk

         call      InitObr                  ; inicializace adres obrzk

; ------ obsluha demonstrace

Start2:  call      Demo                     ; obsluha demonstrace

; ------ zruen znaku klvesy

         mov       ah,0
         int       16h

; ------ ESC nebo Ctrl-Break - peruen hry

         or        ax,ax
         jz        Start3
         cmp       al,27
         jne       Start4

; ------ ukonen hry

Start3:  call      SoundOff                 ; vypnut zvuku
         mov       ah,0
         mov       al,ds:[OldVMod]          ; pvodn videomd
         call      Int10                    ; nvrat videomdu

         push      ds
         mov       dx,ds:[UvTxt]            ; adresa vodnho textu
         mov       ax,SEG ScenSegm
         mov       ds,ax
         mov       ah,9
         int       21h                      ; zobrazen vodnho textu
         pop       ds

         mov       ax,4c00h
         int       21h                      ; konec programu

; ------ start scny

Start4:  mov       al,ds:[AktScen]
         call      InitScen                 ; inicializace scny AL (0=DEMO)
         call      DispScen
         call      DispInf                  ; zobrazen informanho dku
Start41: call      FlushKey                 ; vyprzdn bufferu klvesnice
         mov       word ptr ds:[Autom],0    ; nen automat

; ------ ekn na as pro jeden krok

Start5:  call      TestTime                 ; inicializace tae asu
         jc        Start5                   ; nen krok

; ------ test stisku klvesy

         mov       ah,1
         int       16h                      ; je stisk klvesy ?
         jz        Start535                 ; nen stisk klvesy

; ------ F4 zadn hesla

         cmp       ax,3e00h                 ; F4
         jne       Start530
         mov       ah,0
         int       16h
         jmp       Heslo

; ------ ESC nebo Ctrl-Break - peruen hry

Start530:or        ax,ax
         jz        Start531
         cmp       al,27
         jne       Start532
Start531:mov       ah,0
         int       16h
         jmp       Start61

; ------ F1 - automatick reim

Start532:cmp       ax,3b00h                 ; F1
         jne       Start534                 ; nen F1
         cmp       word ptr ds:[Smer],0     ; pohybuje se ji vlak ?
         jne       Start534                 ; pohybuje se ji
         cmp       word ptr ds:[Autom],0    ; je ji automatick reim ?
         jne       Start534                 ; je ji automatick reim
         mov       ah,0
         int       16h                      ; zruen znaku z klvesnice
         call      InitAuto                 ; inicializace automatickho reimu

; ------ F2 - zvuk

Start534:cmp       ax,3c00h                 ; F2
         jne       Start535
         mov       ah,0
         int       16h
         xor       byte ptr ds:[Zvuk],1

; ------ zven fze objekt

Start535:call      IncFaze                  ; zven fze
         call      OpenVrat                 ; oteven vrat

; ------ smr lze zmnit pouze pi fzi 0

         cmp       byte ptr ds:[Faze],0     ; je fze 0 ?
         jne       Start5                   ; ne - dal krok

; ------ zmna smru automatem

         call      GetAuto                  ; smr z automatickho reimu
         jnc       Start652                 ; je automat - posun

; ------ naten dal klvesy

STart60: mov       ah,1
         int       16h
         jz        Start69                  ; nen klvesa
Start603:mov       ah,0
         int       16h                      ; naten klvesy

; ------ F2 - zvuk

         cmp       ax,3c00h                 ; F2
         jne       Start604
         xor       byte ptr ds:[Zvuk],1
         jmp       short Start60

; ------ F4 - zadn hesla

Start604:cmp       ax,3e00h                 ; F4
         jne       Start606
         jmp       Heslo                    ; zadn hesla

; ------ peruen scny ESC nebo Ctrl-Break

Start606:or        ax,ax
         jz        Start61
         cmp       al,27
         jne       Start62
Start61: call      SoundOff
         jmp       Start2

; ------ zmna smru pi stisku klvesy

Start62: cmp       ah,48h
         jne       Start63
         mov       dx,0ff00h                ; nahoru
         jmp       short Start652

Start63: cmp       ah,4bh
         jne       Start64
         mov       dx,0ffh                  ; vlevo
         jmp       short Start652

Start64: cmp       ah,4dh
         jne       Start65
         mov       dx,1                     ; vpravo
         jmp       short Start652

Start65: cmp       ah,50h
         jne       Start60
         mov       dx,1*256                 ; dol

; ------ nastaven novho smru podle DX

Start652:cmp       dx,word ptr ds:[Smer]
         je        Start60                  ; smr je ji nastaven
         mov       ds:[Smer],dx             ; nov smr

; ------ test, zda bude posun vlaku

Start69: mov       dx,ds:[Smer]
         or        dx,dx
         jz        Start6

; ------ test srky na nov pozici pi posunu o DX

         call      TestSraz                 ; test srky vlaku
         jnc       Start6a                  ; nen srka
         jmp       Start8                   ; havrie

; ------ posun vlaku smrem DX

Start6a: call      PosVlak                  ; posun vlaku ve smru DX

; ------ test, zda je vlak ji ve vratech (tj. konec scny)

         mov       dx,word ptr ds:[MapVlak+1]
         cmp       dx,ds:[PozVrat]
         je        Start7                   ; konec hry
Start6:  jmp       Start5

; ------ spn ukonen scny

Start7:  mov       word ptr ds:[CitSound],0 ; vypnut vech zvuk

         mov       bx,2200
         mov       ax,800
         mov       dx,250
         mov       cx,2
Start711:call      SetSound
         xchg      ax,bx
         call      Cekej
         call      SetSound
         xchg      ax,bx
         call      Cekej
         sub       bx,8
         dec       dx
         jnz       Start711
         call      SoundOff

         call      ClosScen                 ; uzaven scny

         cmp       word ptr ds:[Autom],0    ; byl to automat ?
         jne       Start713                 ; byl to automat

         inc       byte ptr ds:[AktScen]    ; zven sla scny

Start713:call      ClearInf                 ; vymazn informanho dku

         mov       ax,ds:[NumScen]          ; poet scn
         cmp       ds:[AktScen],al          ; je to posledn scna ?
         jbe       Start72                  ; nen posledn scna
         mov       byte ptr ds:[AktScen],1  ; posun na 1. scnu
         jmp       Absol                    ; absolutn vtz hry

Start72: call      DispAScn                 ; zobrazen informac aktuln scny

         call      FlushKey                 ; vyprzdn bufferu klvesnice

         mov       ah,0
         int       16h                      ; ekn na stisk libovoln klvesy

         mov       al,ds:[AktScen]          ; aktuln scna
         call      InitScen                 ; inicializace scny AL

         call      OpenScen                 ; oteven scny

         call      DispInf                  ; zobrazen informanho dku

         jmp       Start41                  ; nov start hry

; ------ havrie

Start8:  mov       byte ptr ds:[MapVlak],0  ; pznak srky

         call      DispKec                  ; zobrazen hlen pi srce

         mov       word ptr ds:[CitVyb],120  ; ta vbuchu

         mov       al,SR1                   ; srka
Start80: mov       dx,word ptr ds:[MapVlak+1]
         call      DispObr

Start81:
         cmp       word ptr ds:[CitVyb],0
         je        Start86
         dec       word ptr ds:[CitVyb]
         jnz       Start85
         call      SoundOff
         jmp       short Start86

Start85: push      ax
         mov       bx,ds:[CitVyb]
         mov       ax,420
         sub       ax,ds:[CitVyb]
         shl       ax,1
         shl       ax,1
         shl       ax,1
         shl       ax,1
         mov       bx,word ptr cs:[bx+cs:Start]
         and       bx,0fffh
         add       ax,bx
         call      SetSound
         pop       ax

Start86:
         mov       cx,9
         call      Cekej

         call      TestTime
         jc        Start81

         call      IncFaze

         inc       ax
         cmp       al,SRA+1
         jb        Start80

         mov       al,SR8

         push      ax
         mov       ah,1
         int       16h
         pop       ax
         jz        Start80

         call      SoundOff

Start82: call      FlushKey
Start83: jmp       Start4

; -----------------------------------------------------------------------------
;        demonstrace (ukonen stiskem kterkoliv klvesy)
; -----------------------------------------------------------------------------
;
Demo     PROC      NEAR

; ------ schova aktivn scny

         mov       al,ds:[AktScen]          ; aktivn scna
         push      ax                       ; schova aktivn scny

; ------ slo dal scny

Demo1:   cmp       byte ptr ds:[AktScen],0  ; byla DEMO scna ?
         mov       al,0                     ; bude DEMO scna
         jne       Demo16                   ; nebyla DEMO scna
Demo12:  mov       si,ds:[RndUkaz]          ; ukazatel nhody
         mov       al,cs:[si]               ; nhodn bajt
         push      ds
         xor       bx,bx
         mov       ds,bx
         xor       al,ds:[46ch]
         pop       ds
         inc       si
         cmp       si,1000h
         jb        Demo14
         xor       si,si
Demo14:  mov       ds:[RndUkaz],si
         or        al,al
         jz        Demo12
         cmp       al,byte ptr ds:[NumScen]
         ja        Demo12
Demo16:  mov       ds:[AktScen],al

; ------ inicializace a zobrazen scny AL

         call      InitScn0                 ; inicializace scny AL (0=DEMO)
         call      ClearInf                 ; vymazn informanho dku
         cmp       byte ptr ds:[AktScen],0  ; je DEMO scna ?
         je        Demo18                   ; je DEMO scna
         call      DispInf                  ; zobrazen informanho dku
Demo18:  call      DispScen                 ; zobrazen scny
         mov       byte ptr ds:[CitTit],0   ; ta titulku
         mov       word ptr ds:[AutomCek],0 ; ta ekn po DEMO
         mov       word ptr ds:[Autom],0    ; nen automat
         call      InitAuto                 ; inicializace automatickho reimu

; ------ test stisku klvesy

Demo2:   mov       ah,1
         int       16h                      ; je stisk klvesy ?
         jnz       Demo8                    ; je stisk klvesy

; ------ test, zda bude krok

         call      TestTime                 ; test asu
         jc        Demo2                    ; ekn na as pro jeden krok

; ------ zven fze objekt

         call      IncFaze                  ; zven fze
         call      OpenVrat                 ; oteven vrat

; ------ posun bude pouze pi fzi 0

         cmp       byte ptr ds:[Faze],0     ; bude posun ?
         jne       Demo2                    ; nebude posun

; ------ naten posunu vlaku

         call      GetAuto                  ; dal posun vlaku pro DEMO
         jnc       Demo3                    ; je dal krok
         inc       word ptr ds:[AutomCek]   ; ta ekn
         cmp       word ptr ds:[AutomCek],1*(18/2/3) ; ekn po DEMO
         jb        Demo2                    ; dal ekn
         jmp       Demo1                    ; dal scna

; ------ posun vlaku

Demo3:   mov       ds:[Smer],dx             ; nov smr vlaku
         or        dx,dx                    ; bude posun vlaku ?
         jz        Demo2                    ; nebude posun vlaku
         call      TestSraz                 ; test srky vlaku
         jnc       Demo4                    ; nen srka
Demo32:  xor       ax,ax
         mov       ds:[Smer],ax             ; zastaven vlaku
         mov       ds:[Autom],ax            ; zastaven automatu
         jmp       short Demo2
Demo4:   call      PosVlak                  ; posun vlaku

; ------ posun titulku

         cmp       byte ptr ds:[AktScen],0  ; je DEMO scna ?
         jne       Demo5                    ; nen DEMO scna
         mov       al,ds:[MapVlak+1]        ; pozice vlaku
         shl       al,1                     ; pozice vlaku * 2
         sub       al,2                     ; bez potku
         jbe       Demo5                    ; nepovolen pozice
         cmp       al,34
         ja        Demo5                    ; nepovolen pozice
         cmp       byte ptr ds:[CitTit],34  ; je ji titulek maximln ?
         jae       Demo5                    ; titulek je ji maximln
         mov       ds:[CitTit],al           ; nov dlka titulku
         call      DispTit                  ; zobrazen titulku

; ------ test, zda je vlak ji ve vratech

Demo5:   mov       ax,word ptr ds:[MapVlak+1] ; pozice vlaku
         cmp       ax,ds:[PozVrat]          ; je ji ve vratech ?
         jne       Demo2                    ; nen jet ve vratech
         jmp       short Demo32

; ------ F2 - zvuk

Demo8:   cmp       ax,3c00h                 ; F2
         jne       Demo9
         mov       ah,0
         int       16h
         xor       byte ptr ds:[Zvuk],1
         jmp       Demo2

; ------ nvrat pvodn aktivn scny

Demo9:   pop       ax
         mov       ds:[AktScen],al          ; nvrat pvodn aktivn scny
         ret

Demo     ENDP

; -----------------------------------------------------------------------------
;        inicializace automatickho reimu (NZ=nen)
; -----------------------------------------------------------------------------

InitAuto PROC      NEAR

         push      ds
         mov       ah,0
         mov       al,ds:[AktScen]          ; aktivn scna
         shl       ax,1                     ; AX = offset adresy
         xchg      ax,si                    ; SI <- offset adresy
         mov       si,ds:[si+AdrScen]       ; adresa scny
         mov       ax,SEG ScenSegm          ; AX <- segment scn
         mov       ds,ax                    ; DS <- segment scn
         cld
InitAut2:lodsb                              ; naten znaku
         cmp       al," "                   ; je platn znak ?
         jbe       InitAut2                 ; vyputn neplatnch znak
         cmp       al,"!"                   ; je DEMO ?
         pop       ds
         jne       InitAut4                 ; nen DEMO
         mov       ds:[Autom],si            ; ukazatel pro DEMO
InitAut4:ret

InitAuto ENDP

; -----------------------------------------------------------------------------
;        poskytnut smru pro automatick pohyb -> DX (CY=nen, DX=0 konec)
; -----------------------------------------------------------------------------

GetAuto  PROC      NEAR

; ------ test, zda je automat zapnut

         cmp       word ptr ds:[Autom],1    ; je automat ?
         jb        GetAuto9                 ; nen automat

; ------ naten dalho znaku automatu

GetAuto2:mov       si,ds:[Autom]            ; ukazatel automatickho reimu
GetAuto3:push      ds
         mov       ax,SEG ScenSegm
         mov       ds,ax                    ; segment definice scn
         cld
         lodsb                              ; naten znaku
         pop       ds
         mov       ds:[Autom],si            ; nov ukazatel pro automatick reim

; ------ vyputn komente

         cmp       al,";"
         jne       GetAuto5

         push      ds
         mov       ax,SEG ScenSegm
         mov       ds,ax                    ; segment definice scn
         cld
GetAuto4:lodsb
         cmp       al," "
         jae       GetAuto4
         pop       ds
         jmp       short GetAuto3

; ------ konverze na velk psmeno

GetAuto5:cmp       al,"a"
         jb        GetAuto6
         cmp       al,"z"
         ja        GetAuto6
         sub       al,32

; ------ nahoru

GetAuto6:mov       dx,0ff00h                ; nahoru
         cmp       al,"U"
         je        GetAuto8                 ; nahoru

; ------ vlevo

         mov       dx,00ffh                 ; vlevo
         cmp       al,"L"
         je        GetAuto8                 ; vlevo

; ------ vpravo

         mov       dx,0001h                 ; vpravo
         cmp       al,"R"
         je        GetAuto8                 ; vpravo

; ------ dol

         mov       dx,0100h                 ; dol
         cmp       al,"D"
         je        GetAuto8                 ; dol

; ------ zastaven

         cmp       al,"S"
         je        GetAuto7
         cmp       al,"."
         je        GetAuto7
         cmp       al,"#"                   ; je ji definice scny ?
         jne       GetAuto2
GetAuto7:xor       dx,dx                    ; DX <- 0 zastaven
         mov       ds:[Autom],dx            ; ukonen automatickho reimu

GetAuto8:clc
GetAuto9:ret

GetAuto  ENDP

; -----------------------------------------------------------------------------
;        test srky vlaku pi posunu ve smru DX (CY=bude srka)
; -----------------------------------------------------------------------------

TestSraz PROC      NEAR

; ------ prvek na nov pozici

         push      dx
         add       dl,ds:[MapVlak+1]
         add       dh,ds:[MapVlak+2]
         mov       al,20                    ; poet pozic
         mul       dh                       ; pepoet dku na offset
         add       al,dl
         adc       ah,0
         add       ax,offset Pole
         xchg      ax,si                    ; SI <- adresa v poli
         mov       al,ds:[si]               ; prvek na nov pozici
         pop       dx

; ------ test, zda bude srka

         cmp       al,0                     ; mezera ?
         je        TestSra6                 ; je przdn polko
         cmp       al,VECI                  ; posbr vc ?
         jae       TestSra4                 ; posbr vc
         cmp       al,VRA+1                 ; budou oteven vrata ?
         jb        TestSra2                 ; jsou zaven vrata nebo vlak
         cmp       al,VRA+6                 ; oteven vrata ?
         jb        TestSra6                 ; jsou oteven vrata
TestSra2:stc                                ; havrie
         ret

; ------ bude posbrn vci

TestSra4:mov       word ptr ds:[AdrSound],offset TabSVec
         mov       word ptr ds:[CitSound],offset(TabSVec0-TabSVec) + 1
         jmp       short TestSra8

; ------ bude jen posun lokomotivy

TestSra6:mov       word ptr ds:[AdrSound],offset TabSLok
         mov       word ptr ds:[CitSound],offset(TabSLok0-TabSLok) + 1
TestSra8:clc
         ret

TestSraz ENDP

; -----------------------------------------------------------------------------
;        zobrazen informac aktuln scny (ped otevenm scny)
; -----------------------------------------------------------------------------

DispAScn PROC      NEAR

         mov       di,(24/2-1)*8*40 + (40-10)/2
         mov       si,offset ScenTxt
         mov       ah,10
         call      DispTxt

         mov       al,ds:[AktScen]
         mov       ah,0
         mov       ch,14
         call      DispNum

         mov       al," "
         call      DispChr

         mov       di,(24/2+1)*8*40 + (40-13)/2
         mov       ah,10
         mov       si,offset Hes2Txt
         call      DispTxt

         mov       al,5
         mul       byte ptr ds:[AktScen]
         add       ax,offset TabHesel
         xchg      ax,si
         mov       ah,14
         mov       cx,5
DispASc2:cld
         lodsb
         call      DispChr
         loop      DispASc2

         mov       al," "
         call      DispChr
         ret

DispAScn ENDP

; *****************************************************************************
;
;                          Obsluha soubor
;
; *****************************************************************************

; -----------------------------------------------------------------------------
;        sestaven jmna k domovskmu souboru (ppona DS:BX) -> DS:DX
; -----------------------------------------------------------------------------

HomeFile PROC      NEAR

; ------ nalezen jmna souboru

         push      ds
         push      ds
         pop       es                       ; ES <- datov segment
         mov       ds,ds:[SegmPSP]          ; DS <- segment PSP
         mov       ds,ds:[2ch]              ; segment prosted
;         mov       es:[BlokPlay],ds         ; adresa prosted
         xor       si,si
HomeFil1:inc       si
         cmp       word ptr ds:[si-1],0
         jne       HomeFil1
         inc       si                       ; peskoen koncov 0
         inc       si
         inc       si                       ; peskoen potu etzc

; ------ penesen jmna souboru

         cld
         mov       di,offset FileName       ; buffer jmna souboru
         mov       dx,di                    ; DX <- jmno souboru
         xor       cx,cx                    ; CX <- 0 nen ppona
HomeFil2:lodsb                              ; naten znaku
         cmp       al,"."
         jne       HomeFil3
         mov       cx,di                    ; adresa ppony
HomeFil3:cmp       di,offset FileName+120
         jae       HomeFil4
         stosb
         cmp       al,0
         jne       HomeFil2
         dec       di

; ------ pidn ppony

HomeFil4:jcxz      HomeFil5                 ; nenalezena ppona
         mov       di,cx                    ; DI <- nalezen ppona
HomeFil5:mov       al,"."
         stosb
         pop       ds
         mov       si,bx
         movsw
         movsw
         ret

HomeFile ENDP

; -----------------------------------------------------------------------------
;        naten souboru obrzk PCX (CY=chyba)
; -----------------------------------------------------------------------------

ReadPCX  PROC      NEAR

; ------ oteven souboru PCX

         mov       bx,offset FilePCX        ; jmno souboru PCX
         call      HomeFile                 ; sestaven jmna souboru
         mov       ax,3d00h
         int       21h                      ; oteven souboru
         jc        ReadPCX9                 ; chyba oteven souboru
         xchg      ax,bx                    ; BX <- identifiktor souboru

; ------ pprava k naten souboru

         mov       ax,SEG ObrSegm           ; segment obrzk
         mov       es,ax                    ; ES <- segment obrzk
         mov       ax,100h                  ; AH <- 1 nen dal bajt
         cld
         xor       di,di                    ; ukldac adresa do bufferu

; ------ naten bufferu

         call      ReadBuff                 ; naten bufferu
         jc        ReadPCX8                 ; chyba
         add       si,128                   ; peskoen zhlav
         sub       cx,128                   ; odeten zhlav
         jb        ReadPCX8                 ; chyba

; ------ oven zhlav PCX

         cmp       byte ptr ds:[Buffer],10
         stc
         jne       ReadPCX8

; ------ naten souboru

         mov       dx,40*200*4              ; poet bajt k naten
ReadPCX2:call      ReadByte                 ; naten dalho bajtu
         jc        ReadPCX8                 ; chyba
         stosb                              ; uloen bajtu
         dec       dx                       ; ta bajt
         jnz       ReadPCX2                 ; dal bajt

; ------ uzaven souboru

ReadPCX8:pushf
         mov       ah,3eh
         int       21h                      ; uzaven souboru
         popf
ReadPCX9:ret

ReadPCX  ENDP

; -----------------------------------------------------------------------------
;        naten jednoho bajtu ze vstupnho bufferu (je CLD !)
; -----------------------------------------------------------------------------
; VSTUP: AL=star hodnota bajtu
;        AH=ta opakovn bajtu (1=bude dal bajt)
;        DS:SI=adresa bufferu
;        CX=poet zbylch bajt
;        CLD=smr nahoru
; VSTUP: CY=chyba
; -----------------------------------------------------------------------------

ReadByte PROC      NEAR

; ------ dal opakovn bajtu AL

         dec       ah                       ; ta opakovn bajtu
         jnz       ReadByt6                 ; je dal opakovn bajtu

; ------ naten dalho bajtu z bufferu

ReadByt0:jcxz      ReadByt8                 ; je ji konec bufferu
ReadByt1:lodsb                              ; naten dalho bajtu
         dec       cx                       ; snen tae bajt

; ------ test, zda je opakovn bajtu

         mov       ah,1                     ; bajt se nebude opakovat
         cmp       al,0c0h                  ; je platn datov bajt ?
         jb        ReadByt6                 ; je platn datov bajt

; ------ schova potu opakovn bajtu

         and       al,3fh                   ; poet opakovn bajtu
         mov       ah,al                    ; poet opakovn bajtu

; ------ naten bajtu k opakovn

         jcxz      ReadByt9                 ; je ji konec bufferu
ReadByt2:lodsb                              ; naten bajtu k opakovn
         dec       cx                       ; snen tae bajt
         or        ah,ah                    ; je njak bajt ?
         jz        ReadByt0                 ; nen bajt
ReadByt6:clc                                ; pznak operace OK
ReadByt7:ret

; ------ naten dalch dat ze souboru do bufferu - st 1

ReadByt8:call      ReadBuff                 ; naten dal sti souboru
         jc        ReadByt7                 ; chyba
         stc
         jcxz      ReadByt7                 ; chyba
         jmp       short ReadByt1

; ------ naten dalch dat ze souboru do bufferu - st 2

ReadByt9:call      ReadBuff                 ; naten dal sti souboru
         jc        ReadByt7
         stc
         jcxz      ReadByt7                 ; chyba
         jmp       short ReadByt2

ReadByte ENDP

; -----------------------------------------------------------------------------
;        naten obsahu bufferu ze souboru BX -> SI=adresa, CX=bajt, CY chyba
; -----------------------------------------------------------------------------

ReadBuff PROC      NEAR

         push      ax
         push      dx

         mov       dx,offset Buffer         ; vstupn buffer souboru
         mov       si,dx                    ; ukazatel na zatek bufferu
         mov       ah,3fh
         mov       cx,BuffSize              ; velikost bufferu
         int       21h                      ; naten bufferu
         xchg      ax,cx                    ; CX <- poet bajt
         cld

         pop       dx
         pop       ax
         ret

ReadBuff ENDP

; -----------------------------------------------------------------------------
;        naten souboru scn SCN
; -----------------------------------------------------------------------------
;
ReadSCN  PROC      NEAR

; ------ oteven souboru SCN

         mov       bx,offset FileSCN        ; jmno souboru SCN
         call      HomeFile                 ; sestaven jmna souboru
         mov       ax,3d00h
         int       21h                      ; oteven souboru
         jnc       ReadScn1
         jmp       ReadSCN9                 ; chyba oteven souboru

ReadScn1:xchg      ax,bx                    ; BX <- identifiktor souboru

; ------ naten souboru definice scn

         push      ds
         mov       ax,SEG ScenSegm          ; segment definice scn
         mov       ds,ax                    ; DS <- segment definice scn
         mov       ah,3fh
         xor       dx,dx
         mov       cx,-1                    ; max. velikost souboru
         int       21h                      ; naten souboru
         pop       ds
         jnc       ReadSc12
         jmp       ReadSCN8                 ; chyba
ReadSc12:xchg      ax,cx                    ; CX <- poet natench bajt

; ------ nalezen vodnho textu

         cld
         xor       si,si
         call      ReadScnL                 ; nalezen prvnho platnho dku
         jc        ReadScn7                 ; nen dal dek
         mov       ds:[UvTxt],si            ; adresa vodnho textu
ReadSc14:call      ReadScnC                 ; naten znaku
         jc        ReadScn7
         cmp       al,"$"
         jne       ReadSc14

; ------ inicializace adres scn

         mov       di,offset AdrScen        ; adresy scn
         mov       bx,offset TabHesel       ; tabulka hesel
ReadScn2:call      ReadScnL                 ; nalezen prvnho dku
         jc        ReadScn7                 ; nen dal dek

         mov       dl,5                     ; dlka hesla
ReadSc21:call      ReadScnC                 ; naten znaku
         jc        ReadScn7                 ; nen dal znak
         cmp       al," "
         ja        ReadSc22
         dec       si
         mov       al," "
ReadSc22:cmp       al,"a"
         jb        ReadSc23
         cmp       al,"z"
         ja        ReadSc23
         sub       al,32
ReadSc23:mov       ds:[bx],al
         inc       bx
         dec       dl
         jnz       ReadSc21

ReadSc24:mov       ds:[di],si               ; adresa scny
         inc       di
         inc       di

         mov       dl,12                    ; poet poadovanch dk

ReadScn3:call      ReadScnL                 ; nalezen zatku dku
         jc        ReadScn7                 ; nen dal dek

ReadSc32:call      ReadScnC
         cmp       al," "
         jbe       ReadSc32
         cmp       al,"!"
         jne       ReadSc36
ReadSc34:call      ReadScnC
         jc        ReadScn7
         cmp       al," "
         jae       ReadSc34
         jmp       short ReadScn3

ReadSc36:dec       si
         inc       cx
         mov       dh,20                    ; poet poadovanch pozic
ReadScn4:call      ReadScnC                 ; naten dalho znaku
         jc        ReadScn7                 ; nen dal znak
         cmp       al," "
         jbe       ReadScn4
         dec       dh                       ; ta platnch znak
         jnz       ReadScn4                 ; dal znak

         dec       dl                       ; ta dk
         jnz       ReadScn3                 ; dal dek

         inc       word ptr ds:[NumScen]    ; scna je platn
         jmp       short ReadScn2           ; dal scna

; ------ uzaven souboru

ReadScn7:cmp       byte ptr ds:[NumScen],3  ; minimln 1 DEMO + 1 scna
         dec       word ptr ds:[NumScen]    ; bez DEMO scny
ReadSCN8:pushf
         mov       ah,3eh
         int       21h                      ; uzaven souboru
         popf
ReadSCN9:ret

ReadSCN  ENDP

; -----------------------------------------------------------------------------
;        nalezen zatku platnho dku definice scny -> CY=nen
; -----------------------------------------------------------------------------

ReadScnL:call      ReadScnC                 ; naten znaku
         jc        ReadScL4                 ; nen dal znak
         cmp       al," "
         jbe       ReadScnL
         cmp       al,";"
         jne       ReadScL2

ReadScL1:call      ReadScnC                 ; naten znaku
         jc        ReadScL4                 ; nen dal znak
         cmp       al,10
         jne       ReadScL1                 ; nalezen znaku LF
         jmp       short ReadScnL

ReadScL2:dec       si                       ; nvrat znaku
         inc       cx                       ; nvrat tae znak
         clc                                ; pznak platnosti znaku
ReadScL4:ret

; -----------------------------------------------------------------------------
;        naten znaku z definice scn -> CY chyba
; -----------------------------------------------------------------------------

ReadScnC:stc
         jcxz      ReadScC2

         push      ds

         push      ax
         mov       ax,SEG ScenSegm          ; segment scn
         mov       ds,ax
         pop       ax

         lodsb
         dec       cx
         pop       ds
         clc

ReadScC2:ret

; -----------------------------------------------------------------------------
;        celkov ukonen hry - absolutn vtz
; -----------------------------------------------------------------------------
;
Absol    PROC      NEAR

         mov       di,9*8*40+5
         mov       si,offset Bla1Txt
         mov       ah,14
         call      DispTxt
         mov       di,10*8*40+5
         call      DispTxt
         mov       di,11*8*40+5
         push      si
         mov       si,offset Bla1Txt
         call      DispTxt
         pop       si
         mov       ah,10
         mov       di,12*8*40+5
         call      DispTxt
         mov       di,13*8*40+5
         call      DispTxt
         mov       si,offset Bla1Txt
         mov       di,14*8*40+5
         call      DispTxt

         call      FlushKey
         mov       ah,0
         int       16h
         jmp       Start2                   ; nvrat k demonstraci

Absol    ENDP

; -----------------------------------------------------------------------------
;        zadn hesla
; -----------------------------------------------------------------------------
;
Heslo    PROC      NEAR

         push      ds
         pop       es

; ------ naten aktivnho hesla

         mov       al,5
         mul       byte ptr ds:[AktScen]
         add       ax,offset TabHesel
         xchg      ax,si
         mov       cx,5
         mov       di,offset BuffHes
         cld
         rep       movsb

; ------ zobrazen hesla

         mov       bx,offset BuffHes        ; ukazatel v bufferu hesla

Heslo2:
         mov       di,24*8*40 + 14
         mov       ah,12
         mov       si,offset Hes2Txt
         call      DispTxt

         mov       si,offset BuffHes
         mov       cx,5
Heslo23: mov       ah,14
         cmp       si,bx
         jne       Heslo232

;         mov       ah,9
;         mov       al,""
;         call      DispChr
;         dec       di

         mov       ah,14 + 80h
;         mov       ah,14 XOR 9 + 80h

Heslo232:cld
         lodsb
         call      DispChr
         loop      Heslo23

; ------ ekn na zadn klvesy

Heslo24: call      TestTime                 ; inicializace tae asu
         jc        Heslo25                  ; nen krok
         call      IncFaze                  ; zven fze
         call      OpenVrat                 ; oteven vrat

Heslo25: mov       ah,1
         int       16h
         jz        Heslo24
         mov       ah,0
         int       16h

         cmp       al,13
         je        Heslo5

; ------ peruen zadn ESC (nebo neplatn heslo)

         or        ax,ax
         jz        Heslo27
         cmp       al,27
         jne       Heslo3

Heslo27:
         call      DispInf
         jmp       Start60                  ; peruen bez dal funkce

; ------ kurzor vpravo

Heslo3:  cmp       ax,4d00h
         je        Heslo42

; ------ kurzor vlevo

         cmp       al,8
         je        Heslo31
         cmp       al,7fh
         je        Heslo31
         cmp       ax,5300h
         je        Heslo31
         cmp       ax,4b00h
         jne       Heslo32
Heslo31: cmp       bx,offset BuffHes
         jbe       Heslo43
         dec       bx
         jmp       short Heslo43

; ------ vloen znaku

Heslo32: cmp       al,"a"
         jb        Heslo33
         cmp       al,"z"
         ja        Heslo33
         sub       al,32
Heslo33: cmp       al," "
         jb        Heslo24
;         je        Heslo34
;         cmp       al,"0"
;         jb        Heslo24
;         cmp       al,"9"
;         jbe       Heslo34
;         cmp       al,"A"
;         jb        Heslo24
;         cmp       al,"Z"
;         ja        Heslo24
Heslo34: mov       ds:[bx],al

Heslo42: cmp       bx,offset BuffHes+4
         jae       Heslo43
         inc       bx
Heslo43: jmp       Heslo2

; ------ ukonen zadn hesla ENTER

Heslo5:  mov       si,offset TabHesel+5
         mov       dx,1                     ; ukazatel sla scny
         cld
Heslo52: mov       di,offset BuffHes
         mov       cx,5
         push      si
         repe      cmpsb
         pop       si
         je        Heslo55
         add       si,5
         inc       dx
         cmp       dx,ds:[NumScen]
         jbe       Heslo52
         jmp       short Heslo27

Heslo55: mov       ds:[AktScen],dl
         jmp       Start4

Heslo    ENDP

; -----------------------------------------------------------------------------
;        uzaven scny
; -----------------------------------------------------------------------------

ClosScen PROC      NEAR

         mov       dh,0
         mov       al,ZED
ClosScn1:mov       cx,20
         mov       dl,0
ClosScn2:call      DispObr
         inc       dx
         loop      ClosScn2
         mov       cx,60
         call      Cekej
         inc       dh
         cmp       dh,12
         jne       ClosScn1
         ret

ClosScen ENDP

; -----------------------------------------------------------------------------
;        oteven scny
; -----------------------------------------------------------------------------

OpenScen PROC      NEAR

         mov       si,offset Pole+12*20-20
         mov       dh,11
OpenScn1:mov       cx,20
         mov       dl,0
OpenScn2:cld
         lodsb
         call      DispObr
         inc       dx
         loop      OpenScn2
         sub       si,2*20
         mov       cx,60
         call      Cekej
         dec       dh
         jns       OpenScn1
         ret

OpenScen ENDP

; -----------------------------------------------------------------------------
;        zobrazen scny
; -----------------------------------------------------------------------------

DispScen PROC      NEAR

         mov       si,offset Pole
         mov       dh,0
DispScn1:mov       cx,20
         mov       dl,0
DispScn2:cld
         lodsb
         cmp       al,LO1
         jne       DispScn3
         mov       al,LO3
DispScn3:call      DispObr
         inc       dx
         loop      DispScn2
         inc       dh
         cmp       dh,12
         jne       DispScn1
         ret

DispScen ENDP

; -----------------------------------------------------------------------------
;        vymazn informanho dku
; -----------------------------------------------------------------------------

ClearInf PROC      NEAR

         mov       di,24*8*40
         mov       ax,15*256+" "            ; znak a barva k vymazn
         mov       cx,40                    ;
ClearIn1:call      DispChr
         loop      ClearIn1
         ret

ClearInf ENDP

; -----------------------------------------------------------------------------
;        zobrazen informanho dku
; -----------------------------------------------------------------------------

DispInf  PROC      NEAR

         call      ClearInf                 ; vymazn informanho dku

; ------ vodn text

DispInf1:mov       di,24*8*40
         mov       ah,10
         mov       si,offset SkorTxt
         call      DispTxt

         mov       di,24*8*40 + 40-6-3
         call      DispTxt

         mov       di,24*8*40 + 16
         mov       ah,12
         call      DispTxt

         mov       ch,14
         mov       al,ds:[AktScen]
         mov       ah,0
         mov       di,24*8*40 + 40-2
         call      DispNum

         call      DispSkor                 ; zobrazen skre
         ret

DispInf  ENDP

; -----------------------------------------------------------------------------
;        zobrazen skre
; -----------------------------------------------------------------------------

DispSkor PROC      NEAR

         push      ax
         push      cx
         push      dx
         push      di

         cmp       byte ptr ds:[AktScen],0  ; je DEMO scna ?
         je        DispSko6                 ; je DEMO scna

         mov       di,24*8*40 + 6
         mov       ch,14
         mov       ax,ds:[Skore]
         or        ax,ax
         jz        DispSko4
DispSko3:call      DispNum
DispSko4:mov       al,"0"
         mov       ah,14
         call      DispChr

DispSko6:pop       di
         pop       dx
         pop       cx
         pop       ax
         ret

DispSkor ENDP

; -----------------------------------------------------------------------------
;        oteven vrat
; -----------------------------------------------------------------------------

OpenVrat PROC      NEAR

         push      ax
         push      cx
         push      dx
         push      si

         cmp       word ptr ds:[CitVeci],0
         jne       OpenVr8

         mov       dx,ds:[PozVrat]
         mov       al,20                    ; poet pozic
         mul       dh                       ; pepoet dku na offset
         add       al,dl
         adc       ah,0
         add       ax,offset Pole
         xchg      ax,si                    ; SI <- adresa v poli
         mov       al,ds:[si]
         cmp       al,VRA
         jb        OpenVr8
         cmp       al,VRA+5
         jae       OpenVr8

         inc       ax
         mov       ds:[si],al               ; nov fze vrat
         call      DispObr

OpenVr8: pop       si
         pop       dx
         pop       cx
         pop       ax
         ret

OpenVrat ENDP

; -----------------------------------------------------------------------------
;        zven fze objekt
; -----------------------------------------------------------------------------

IncFaze  PROC      NEAR

; ------ schova registr

         push      ax
         push      cx
         push      dx
         push      si

; ------ obsluha objekt

         mov       dh,0
         mov       si,offset Pole
         inc       byte ptr ds:[Faze]       ; ta fz
         cmp       byte ptr ds:[Faze],3
         jb        IncFaze1
         mov       byte ptr ds:[Faze],0
IncFaze1:mov       dl,0
IncFaze2:cld
         lodsb
         cmp       al,VECI
         jae       IncFaze3
         cmp       al,LO1
         jb        IncFaze5
         cmp       al,LOC
         ja        IncFaze5
         cmp       byte ptr ds:[MapVlak],0
         je        IncFaze5
         sub       al,LO1
         and       al,3
         mov       ah,ds:[Faze]
         shl       ah,1
         shl       ah,1
         add       al,ah
         add       al,LO1
         jmp       short IncFaze4
IncFaze3:inc       ax                       ; zven fze
         cmp       byte ptr ds:[Faze],0
         jne       IncFaze4
         sub       al,3
IncFaze4:mov       ds:[si-1],al
         call      DispObr
IncFaze5:inc       dx
         cmp       dl,20
         jne       IncFaze2
         inc       dh
         cmp       dh,12
         jne       IncFaze1

; ------ nvrat registr

         pop       si
         pop       dx
         pop       cx
         pop       ax
         ret

IncFaze  ENDP

; -----------------------------------------------------------------------------
;        tn asu pro jeden krok (CY=nen krok)
; -----------------------------------------------------------------------------
;
TestTime PROC      NEAR

         sti

         push      cx
         mov       cx,1
         call      Cekej
         pop       cx

         cmp       word ptr ds:[CitSound],0
         je        TestTim1

         dec       word ptr ds:[CitSound]
         jnz       TestTim0
TestT05: call      SoundOff
         jmp       short TestTim1

TestTim0:
         push      ax
         push      si
         mov       si,ds:[AdrSound]
         cld
         lodsw
         mov       ds:[AdrSound],si
         call      SetSound

         pop       si
         pop       ax

TestTim1:

         push      ax
         push      ds
         xor       ax,ax
         mov       ds,ax
         mov       ax,ds:[46ch]
         pop       ds
         sub       ax,ds:[LastTime]

IFDEF    DEBUG
         cmp       ax,3                     ; krok
ELSE
         cmp       ax,2                     ; krok
ENDIF

         jb        TestTim3                 ; nen krok
         add       ds:[LastTime],ax         ; zven tae asu
         clc                                ; pznak kroku
TestTim3:pop       ax
         ret

TestTime ENDP

; -----------------------------------------------------------------------------
;        posun vlaku ve smru DX (DH=0,1,-1, DL=0,1,-1)
; -----------------------------------------------------------------------------
;
PosVlak  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

; ------ pprava registr

         mov       si,offset MapVlak
         add       dl,ds:[si+1]             ; nov souadnice lokomotivy
         add       dh,ds:[si+2]

; ------ posun souadnic objektu

PosVlak2:mov       cx,ds:[si+1]             ; schova starch souadnic
         mov       ds:[si+1],dx             ; nov souadnice objektu

; ------ stanoven nov fze objektu

         mov       al,ds:[si]               ; bze objektu
         cmp       cl,-1                    ; je pozice znm ?
         jne       PosVlk22                 ; pozice je znm
         add       al,bh                    ; posun fze
         jmp       short PosVlak4
PosVlk22:mov       ah,dl                    ; nov pozice
         mov       bh,0                     ; vlevo
         sub       ah,cl                    ; posun pozice
         je        PosVlak3                 ; pozice se nezmnila
         js        PosVlak4                 ; posun vlevo
         mov       bh,2                     ; vpravo
         add       al,2
         jmp       short PosVlak4           ; posun vpravo
PosVlak3:inc       ax                       ; posun nahoru
         mov       bh,1                     ; nahoru
         mov       ah,dh                    ; nov dek
         sub       ah,ch                    ; posun dku
         js        PosVlak4                 ; je posun nahoru
         add       al,2                     ; jinak posun dol
         mov       bh,3                     ; dol

; ------ zobrazen objektu na nov pozici

PosVlak4:call      DispObr                  ; zobrazen obrzku

; ------ uloen objektu do mapy

         push      ax
         mov       al,20                    ; poet pozic
         mul       dh                       ; pepoet dku na offset
         add       al,dl
         adc       ah,0
         add       ax,offset Pole
         xchg      ax,di                    ; DI <- adresa v poli
         pop       ax
         xchg      al,ds:[di]               ; uloen objektu do mapy

; ------ pi zruen vci vytvoen novho vagonu

         sub       al,VECI                  ; byla to vc ?
         jb        PosVlak6                 ; nebyla to vc

         dec       word ptr ds:[CitVeci]    ; tn vc
         cmp       byte ptr ds:[AktScen],0  ; je DEMO scna ?
         je        PosVla42                 ; je DEMO scna
         cmp       word ptr ds:[Skore],-1
         je        PosVla41
         cmp       word ptr ds:[Autom],0    ; je automat ?
         jne       PosVla41                 ; je automat
         inc       word ptr ds:[Skore]
PosVla41:call      DispSkor                 ; zobrazen skre
PosVla42:mov       ah,0
         mov       bl,3
         div       bl                       ; slo vci
         shl       al,1
         shl       al,1                     ; vagon * 4
         add       al,VAGONY                ; slo vagonu
         push      si
PosVlak5:add       si,3
         cmp       byte ptr ds:[si],0
         jne       PosVlak5
         mov       ds:[si],al
         mov       word ptr ds:[si+1],-1
         mov       byte ptr ds:[si+3],0
         pop       si

; ------ pprava pro dal objekt

PosVlak6:add       si,3                     ; adresa dalho objektu
         mov       dx,cx                    ; star pozice pedelho objektu
         mov       al,0
         cmp       ds:[si],al               ; je ji konec vlaku ?
         je        PosVlak7
         jmp       PosVlak2                 ; nen konec - dal vagon

; ------ vymazn poslednho vagonu

PosVlak7:cmp       dl,-1
         je        PosVlak8
         call      DispObr                  ; vymazn poslednho vagonu
         mov       al,20                    ; poet pozic
         mul       dh                       ; pepoet dku na offset
         add       al,dl
         adc       ah,0
         add       ax,offset Pole
         xchg      ax,di                    ; DI <- adresa v poli
         mov       byte ptr ds:[di],0

; ------ nvrat registr

PosVlak8:pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

PosVlak  ENDP

; -----------------------------------------------------------------------------
;        inicializace scny AL pro hru
; -----------------------------------------------------------------------------

InitScen PROC      NEAR

; ------ nov inicializace hodin (kdyby nkdo pepnul TURBO)

         call      CekInit                  ; inicializace hodin

; ------ schova registr

InitScn0:push      ax
         push      cx
         push      dx
         push      si
         push      di
         push      es

; ------ penesen definice scny

         cld
         push      ds
         pop       es                       ; ES <- datov segment

         push      ds
         mov       ah,0
         shl       ax,1                     ; AX = offset adresy
         xchg      ax,si
         mov       si,ds:[si+AdrScen]       ; adresa scny
         mov       ax,SEG ScenSegm          ; AX <- segment scn
         mov       ds,ax                    ; DS <- segment scn
         mov       di,offset Pole           ; zatek pole
         mov       cx,12*20                 ; velikost pole
InitScn1:lodsb
         cmp       al," "
         jbe       InitScn1
         cmp       al,"!"
         je        InitScn2
         cmp       al,";"
         jne       InitScn3
InitScn2:lodsb
         cmp       al,10
         jne       InitScn2
         jmp       short InitScn1

InitScn3:mov       ah,LO1
         cmp       al,"$"
         je        InitSc38
         mov       ah,VRA
         cmp       al,"@"
         je        InitSc38
         mov       ah,ZED
         cmp       al,"#"
         je        InitSc38

         cmp       al,"a"
         jb        InitSc32
         cmp       al,"z"
         ja        InitSc32
         sub       al,32
InitSc32:sub       al,"A"
         jb        InitSc37
         cmp       al,POCVECI
         jae       InitSc37
         mov       ah,3
         mul       ah
         add       al,VECI
         jmp       short InitSc39

InitSc37:mov       ah,0                     ; jinak neplatn

InitSc38:mov       al,ah
InitSc39:stosb
         loop      InitScn1
         pop       ds

; ------ inicializace scny

         mov       word ptr ds:[CitVeci],0  ; ta vc - nen dn vc
         mov       dh,0                     ; ukazatel sla dku
         mov       si,offset Pole           ; definice hracho pole
InitScn4:mov       dl,0                     ; ukazatel sla pozice
InitScn5:lodsb                              ; naten bajtu definice
         cmp       al,VRA                   ; jsou to zaven vrata ?
         jne       InitSc52                 ; nejsou to vrata
         mov       ds:[PozVrat],dx          ; pozice vrat
InitSc52:cmp       al,VECI                  ; je to vc ?
         jb        InitScn6                 ; nen to vc
         inc       word ptr ds:[CitVeci]    ; ta vc
InitScn6:cmp       al,LO1                   ; je to lokomotiva ?
         jne       InitScn7
         mov       ds:[MapVlak],al
         mov       byte ptr ds:[si-1],LO3
         mov       word ptr ds:[MapVlak+1],dx ; souadnice lokomotivy
InitScn7:inc       dx                       ; zven pozice na dku
         cmp       dl,20                    ; je ji konec dku ?
         jne       InitScn5                 ; nen jet konec dku
         inc       dh                       ; zven ukazatele dku
         cmp       dh,12                    ; je ji posledn dek ?
         jne       InitScn4                 ; nen jet posledn dek

         mov       byte ptr ds:[MapVlak+3],0  ; oznaen konce vlaku
         mov       byte ptr ds:[Faze],0     ; ukazatel fze
         mov       word ptr ds:[Smer],0     ; smr pohybu (= stoj)

; ------ nvrat registr

         pop       es
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       ax
         ret

InitScen ENDP

; -----------------------------------------------------------------------------
;        inicializace adres obrzk
; -----------------------------------------------------------------------------
;
InitObr  PROC      NEAR

DELLO    EQU       16*40*4                  ; dlka jednoho dku obrzk

; ------ ukldac adresa do bufferu

         cld
         mov       di,offset AdrObr         ; buffer adres obrzk
         push      ds
         pop       es

; ------ adresa tmy

         mov       ax,7*DELLO + 12*2 + 6*2 + 2 ; tma je za npisem
         stosw

; ------ lokomotiva - fze 1 a 3

         mov       ax,7*DELLO
         mov       cx,3*4                   ; 2 fze po 4 obrzcch
         call      InitObrA                 ; uloen adres

; ------ srka - 10 fz

         mov       ax,8*DELLO
         mov       cl,10
         call      InitObrA                 ; uloen adres

; ------ ze

         mov       ax,7*DELLO + 12*2 + 6*2
         stosw

; ------ vrata - 6 fz

         mov       ax,7*DELLO + 12*2
         mov       cl,6
         call      InitObrA                 ; uloen adres

; ------ vagony

         mov       ax,3*16*4*40
         mov       cx,POCVECI               ; poet vc
InitObr4:push      ax
         stosw
         add       ax,16*4*40
         stosw
         add       ax,16*4*40
         stosw
         add       ax,16*4*40
         stosw
         pop       ax
         inc       ax
         inc       ax
         loop      InitObr4

; ------ vci

         xor       ax,ax
         mov       cx,POCVECI               ; poet vc
InitObr6:push      ax
         stosw
         add       ax,16*4*40
         stosw
         add       ax,16*4*40
         stosw
         pop       ax
         inc       ax
         inc       ax
         loop      InitObr6
         ret

InitObr  ENDP

; ------ uloen CX adres vedle sebe

InitObrA:stosw
         inc       ax
         inc       ax
         loop      InitObrA
         ret

; -----------------------------------------------------------------------------
;        zobrazen obrzku AL na pozici DL, dek DH
; -----------------------------------------------------------------------------
;
DispObr  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di
         push      ds
         push      es

; ------ adresa obrzku -> DS:SI

         mov       es,ds:[SegmVRAM]         ; ES <- adresa ve videopamti
         mov       ah,0
         shl       ax,1                     ; obrzek * 2
         xchg      ax,bx                    ; BX <- offset v tabulce
         mov       si,ds:[bx+AdrObr]        ; adresa obrzku

; ------ adresa k uloen obrzku

         mov       cx,dx                    ; schova DX
         mov       dl,dh
         mov       dh,0
         mov       ax,16*40                 ; offset dku
         mul       dx                       ; pepoet dku na offset
         mov       ch,0
         shl       cx,1                     ; pepoet pozice na offset
         add       ax,cx                    ; adresa ve videopamti
         xchg      ax,di                    ; DI <- adresa ve videopamti
         cld

; ------ rozlien, zda je karta Hercules

         cmp       byte ptr ds:[Hercules],0 ; je to karta Hercules ?
         mov       ax,SEG ObrSegm
         mov       ds,ax                    ; DS <- segment obrzk
         je        DispObr7                 ; nen karta Hercules

; ------ pprava k zobrazen znaku Hercules

         call      KorVRAM                  ; korekce adresy pro Hercules

; ------ zobrazen prvn roviny obrzku

         mov       cx,16                    ; poet linek
         push      si
         push      di
DispObr2:movsw                              ; penos jedn linky
         add       di,2000h-2
         jns       DispObr3
         and       di,7fffh                 ; korekce zpt na zatek
         add       di,80                    ; adresa dal linky znaku
DispObr3:add       si,4*40-2
         loop      DispObr2
         pop       di
         pop       si

; ------ zobrazen dalch rovin obrzku

         mov       ah,3                     ; poet rovin k zobrazen
DispObr4:push      ax

         add       si,40
         mov       cx,16                    ; poet linek
         push      si
         push      di
DispObr5:lodsw                              ; penos jedn linky
         or        es:[di],ax
         add       di,2000h
         jns       DispObr6
         and       di,7fffh                 ; korekce zpt na zatek
         add       di,80                    ; adresa dal linky znaku
DispObr6:add       si,4*40-2
         loop      DispObr5
         pop       di
         pop       si

         pop       ax
         dec       ah
         jnz       DispObr4
         jmp       short DispObrA

; ------ pprava k zobrazen obrzku

DispObr7:mov       dx,3c4h
         mov       al,2
         out       dx,al                    ; volba registru zpisovch rovin
         mov       ah,1                     ; ukazatel zpisov roviny
         inc       dx

; ------ zobrazen jedn roviny obrzku

DispObr8:mov       al,ah
         out       dx,al                    ; volba zpisov roviny
         mov       cx,16                    ; poet linek
         push      si
         push      di
DispObr9:movsw                              ; penos jedn linky
         add       di,40-2
         add       si,4*40-2
         loop      DispObr9
         pop       di
         pop       si

; ------ pprava pro dal rovinu

         add       si,40
         shl       ah,1
         cmp       ah,10h
         jne       DispObr8                 ; dal rovina

; ------ nvrat registr

DispObrA:pop       es
         pop       ds
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

DispObr  ENDP

; -----------------------------------------------------------------------------
;        zobrazen titulku
; -----------------------------------------------------------------------------

DispTit  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di
         push      ds
         push      es

; ------ pprava k zobrazen titulku

         mov       bl,ds:[CitTit]           ; ta titulku
         mov       si,(200-16)*40*4
         mov       di,9*16*40 + 2
         mov       es,ds:[SegmVRAM]         ; segment videopamti
         cld

; ------ rozlien, zda je karta Hercules

         cmp       byte ptr ds:[Hercules],0 ; je to karta Hercules ?
         mov       ax,SEG ObrSegm
         mov       ds,ax
         je        DispTit6                 ; nen karta Hercules

; ------ pprava k zobrazen znaku Hercules

         call      KorVRAM                  ; korekce adresy pro Hercules

; ------ zobrazen prvn roviny

         mov       cx,16                    ; poet linek

         push      di
         push      si

DispTit2:push      cx
         push      si
         push      di

         mov       cl,bl                    ; ta titulku
         rep       movsb                    ; penos jedn linky

         pop       di
         pop       si
         pop       cx
         add       si,40*4

         add       di,2000h                 ; zven adresy videopamti
         jns       DispTit3                 ; nen peteen 4 linek
         and       di,7fffh                 ; korekce zpt na zatek
         add       di,80                    ; adresa dal linky znaku
DispTit3:loop      DispTit2

         pop       si
         pop       di

; ------ zobrazen dalch rovin

         mov       ah,3
DispTit4:add       si,40                    ; dal rovina
         mov       cx,16                    ; poet linek

         push      di
         push      si

DispTit5:push      cx
         push      si
         push      di

         mov       cl,bl                    ; ta titulku
         jcxz      DispTi56
DispTi52:lodsb
         or        es:[di],al
         inc       di
         loop      DispTi52

DispTi56:pop       di
         pop       si
         pop       cx
         add       si,40*4

         add       di,2000h                 ; zven adresy videopamti
         jns       DispTi58                 ; nen peteen 4 linek
         and       di,7fffh                 ; korekce zpt na zatek
         add       di,80                    ; adresa dal linky znaku
DispTi58:loop      DispTit5

         pop       si
         pop       di

         dec       ah
         jnz       DispTit4
         jmp       short DispTit9

; ------ pprava k zobrazen titulku

DispTit6:mov       dx,3c4h
         mov       al,2
         out       dx,al                    ; volba registru zpisovch rovin
         mov       ah,1                     ; ukazatel zpisov roviny
         inc       dx

; ------ zobrazen jedn roviny titulku

DispTit7:mov       al,ah
         out       dx,al                    ; volba zpisov roviny
         mov       cx,16                    ; poet linek

         push      di
         push      si

DispTit8:push      cx
         push      si
         push      di

         mov       cl,bl                    ; ta titulku
         rep       movsb                    ; penos jedn linky

         pop       di
         pop       si
         pop       cx
         add       si,40*4
         add       di,40

         loop      DispTit8

         pop       si
         pop       di

; ------ pprava pro dal rovinu

         add       si,40
         shl       ah,1
         cmp       ah,10h
         jne       DispTit7                 ; dal rovina

; ------ nvrat registr

DispTit9:pop       es
         pop       ds
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

DispTit  ENDP

; -----------------------------------------------------------------------------
;        zobrazen sla AX (adresa DI, barva CH)
; -----------------------------------------------------------------------------

DispNum  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      si

; ------ dekdovn sla do zsobnku

         xor       bx,bx                    ; ta znak
         mov       si,10
DispNum1:xor       dx,dx
         div       si
         push      dx
         inc       bx
         or        ax,ax
         jnz       DispNum1

; ------ zobrazen sla

DispNum3:pop       ax
         add       al,"0"
         mov       ah,ch
         call      DispChr
         dec       bx
         jnz       DispNum3

; ------ nvrat registr

         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

DispNum  ENDP

; -----------------------------------------------------------------------------
;        zobrazen hlen pi srce
; -----------------------------------------------------------------------------
;
DispKec  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

; ------ nhodn slo

         sti
DispKec1:push      ds
         xor       dx,dx
         mov       ds,dx
         mov       dx,ds:[46ch]             ; asova
         pop       ds
         xor       dx,ds:[CitKec]
         rol       dx,1
         mov       ds:[CitKec],dx
         and       dx,3fh                   ; asi tak omezen
         inc       dx

; ------ nalezen textu -> DS:SI, dlka CX

         cld
         mov       di,offset TabKec         ; tabulka text
DispKec2:mov       si,di                    ; SI <- adresa dalho textu
         xor       cx,cx                    ; CX <- 0 ta dlky textu
         cmp       byte ptr ds:[si],0       ; je dal text ?
         je        DispKec1                 ; nen dal text
DispKec3:mov       al,ds:[di]
         inc       di
         inc       cx
         cmp       al,0
         jne       DispKec3
         dec       dx                       ; ta text
         jnz       DispKec2                 ; dal text

; ------ zobrazen textu (CX=dlka textu + 1)

         mov       ax,40-1
         sub       al,cl                    ; zbytek na okraje
         shr       al,1                     ; polovin pozice
         add       ax,4*40
         xchg      ax,di
         mov       ax,10*256 + " "
         call      DispChr                  ; vodn mezera
         call      DispTxt                  ; zobrazen textu hlen
         mov       al," "
         call      DispChr                  ; zvren mezera

; ------ nvrat registr

         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

DispKec  ENDP

; -----------------------------------------------------------------------------
;        zobrazen textu SI (barva AH, uloen DI)
; -----------------------------------------------------------------------------

DispTxt  PROC      NEAR

DispTxt1:cld
         lodsb
         cmp       al,0
         je        DispTxt2
         call      DispChr
         jmp       short DispTxt1

DispTxt2:ret

DispTxt  ENDP

; -----------------------------------------------------------------------------
;        zobrazen znaku AX (AH: bit7=inverze) na adrese DI
; -----------------------------------------------------------------------------
;
DispChr  PROC      NEAR

; ------ schova registr

         push      ax
         push      cx
         push      dx
         push      si
         push      di
         push      es

         mov       ch,ah                    ; barva

; ------ adresa znaku v tabulce font -> DS:SI

         mov       ah,8                     ; poet bajt na znak
         mul       ah                       ; offset znaku ve fontech
         add       ax,offset Font08         ; adresa znaku ve fontech
         xchg      ax,si                    ; SI <- adresa znaku
         cld

; ------ rozlien, zda je karta Hercules

         mov       es,ds:[SegmVRAM]         ; segment videopamti
         cmp       byte ptr ds:[Hercules],0 ; je to karta Hercules ?
         je        DispChr5                 ; nen karta Hercules

; ------ pprava k zobrazen znaku Hercules

         call      KorVRAM                  ; korekce adresy pro Hercules
         or        ch,ch                    ; je inverze ?
         mov       cx,8                     ; poet linek znaku
         js        DispChr3                 ; je inverzn barva

; ------ zobrazen bl barvy

DispChr1:movsb                              ; bajt znaku
         add       di,2000h-1               ; zven adresy videopamti
         jns       DispChr2                 ; nen peteen 4 linek
         and       di,7fffh                 ; korekce zpt na zatek
         add       di,80                    ; adresa dal linky znaku
DispChr2:loop      DispChr1                 ; zobrazen dal linky znaku
         jmp       short DispChr9

; ------ zobrazen ern barvy

DispChr3:lodsb                              ; bajt znaku
         not       al
         stosb
         add       di,2000h-1               ; zven adresy videopamti
         jns       DispChr4                 ; nen peteen 4 linek
         and       di,7fffh                 ; korekce zpt na zatek
         add       di,80                    ; adresa dal linky znaku
DispChr4:loop      DispChr3                 ; zobrazen dal linky znaku
         jmp       short DispChr9

; ------ nastaven zpisu do vech rovin

DispChr5:mov       dx,3c4h
         mov       al,2
         out       dx,al                    ; volba registru 2
         inc       dx
         mov       al,0fh                   ; zpis do vech rovin
         out       dx,al                    ; nastaven vech rovin

; ------ nastaven barvy znaku

         mov       dx,3ceh
         mov       al,0                     ; registr 0
         out       dx,al                    ; volba registru 0
         inc       dx
         mov       al,0                     ; ern barva
         out       dx,al                    ; nastaven barvy znaku
         dec       dx

; ------ nastaven volby rovin

         mov       al,1                     ; registr 1
         out       dx,al                    ; volba registru 1
         mov       al,ch                    ; poadovan barva znaku
         not       al                       ; bity 0 budou podle registru 0 ern
         inc       dx
         out       dx,al                    ; volba rovin
         dec       dx

; ------ registr bitov masky

         mov       al,8                     ; registr 8
         out       dx,al                    ; volba registru 8
         inc       dx
         mov       al,0ffh
         out       dx,al                    ; vechny bity

; ------ zobrazen znaku

         mov       ah,ch
         mov       cx,8                     ; poet linek znaku
DispChr6:lodsb                              ; bajt znaku
         or        ah,ah
         jns       DispCh62
         not       al
DispCh62:xchg      al,es:[di]               ; zpis znaku
DispCh64:add       di,40                    ; adresa dal linky znaku
         loop      DispChr6                 ; zobrazen dal linky znaku

; ------ nvrat videoregistr

         dec       dx
         mov       al,1                     ; registr 1
         out       dx,al                    ; volba registru 1
         mov       al,0                     ; vechny roviny podle dat
         inc       dx
         out       dx,al                    ; volba rovin

; ------ nvrat registr

DispChr9:pop       es
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       ax
         inc       di                       ; zven ukldac adresy
         ret

DispChr  ENDP

; -----------------------------------------------------------------------------
;        nastaven zvukovho genertoru na AX
; -----------------------------------------------------------------------------

SetSound PROC      NEAR

         push      ax
         cmp       byte ptr ds:[Zvuk],0
         je        SetSnd9
         cli
         mov       al,0b6h
         out       [43h],al
         pop       ax
         push      ax
         out       [42h],al                 ; LOW
         xchg      ah,al
         out       [42h],al                 ; HIGH
         in        al,[61h]
         or        al,3
         out       [61h],al
         sti
SetSnd9: pop       ax
         ret

SetSound ENDP

; -----------------------------------------------------------------------------
;        vypnut zvukovho genertoru
; -----------------------------------------------------------------------------

SoundOff PROC      NEAR

         push      ax
         in        al,[61h]
         and       al,not 3
         out       [61h],al
         pop       ax
         ret

SoundOff ENDP

; -----------------------------------------------------------------------------
;        cejchovn hodin
; -----------------------------------------------------------------------------
; VSTUP: DS=datov segment
; -----------------------------------------------------------------------------

CekInit  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      dx
         push      di

         push      ds

; ------ pprava registr

         sti
         xor       ax,ax                    ; AX <- 0
         mov       ds,ax                    ; DS <- 0
         xor       dx,dx                    ; DX <- 0
         mov       di,46ch                  ; adresa asovae BIOS

; ------ ekn na zatek impulsu hodin

         mov       bx,ds:[di]               ; aktuln stav hodin
CekInit1:cmp       bx,ds:[di]               ; zmnily se hodiny ?
         je        CekInit1                 ; ekn na zatek hodin

; ------ men asu

         mov       bx,ds:[di]               ; nov aktuln stav hodin
         EVEN                               ; zarovnn na sudou adresu
CekInit2:add       ax,1                     ; ta niho slova asu
         adc       dx,0                     ; penos do vyho slova
         cmp       bx,ds:[di]               ; byla zmna ?
         je        CekInit2                 ; ekn na zmnu hodin

; ------ vpoet konstanty

         mov       bx,55                    ; dlitel
         cmp       dx,bx                    ; peteen sla ?
         jb        CekInit3                 ; nen peteen sla
         mov       dx,54                    ; omezen sla
CekInit3:div       bx                       ; vpoet konstanty

; ------ uloen konstanty pro 1 ms

         or        ax,ax                    ; je = 0 ?
         jnz       CekInit4                 ; nen = 0
         inc       ax                       ; korekce na 1
CekInit4:pop       ds
         mov       ds:[Cit1ms],ax           ; konstanta hodin pro 1 ms

; ------ nvrat registr

         pop       di
         pop       dx
         pop       bx
         pop       ax
         ret

CekInit  ENDP

; -----------------------------------------------------------------------------
;        ekn na uplynut zadanho asu
; -----------------------------------------------------------------------------
; VSTUP: CX=poadovan doba v milisekundch
;        DS=datov segment
; -----------------------------------------------------------------------------

Cekej    PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      di

; ------ ekn po zadanou dobu

         jcxz      Cekej9                   ; nen dn ekn
         mov       di,offset Cit1ms         ; konstanta hodin
Cekej1:  xor       ax,ax                    ; AX <- 0 ni slovo tae hodin
         xor       dx,dx                    ; DX <- 0 vy slovo tae hodin

; ------ tn doby 1 ms

         EVEN                               ; zarovnn na sudou adresu
Cekej2:  add       ax,1                     ; ta niho slova asu
         adc       dx,0                     ; penos do vyho slova
         cmp       ax,ds:[di]               ; dosaeno doby 1 ms ?
         jne       Cekej2                   ; tn doby 1 ms

         loop      Cekej1                   ; ekn na dal 1 ms

; ------ nvrat registr

Cekej9:  pop       di
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

Cekej    ENDP

; -----------------------------------------------------------------------------
;        vyprzdnn bufferu klvesnice
; -----------------------------------------------------------------------------

FlushKey PROC      NEAR

         push      ax
FlushKe2:mov       ah,1
         int       16h
         jz        FlushKe3
         mov       ah,0
         int       16h
         jmp       short FlushKe2
FlushKe3:pop       ax
         ret

FlushKey ENDP

; -----------------------------------------------------------------------------
;        korekce adresy ve videopamti DI pro HERCULES
; -----------------------------------------------------------------------------

KorVRAM  PROC      NEAR

         push      bx
         push      dx
         push      ax

         xor       dx,dx                    ; DX <- 0
         xchg      ax,di                    ; AX <- adresa ve videopamti
         mov       bx,40                    ; poet bajt na videolinku
         div       bx                       ; AX <- slo videolinky
         mov       di,dx                    ; DI <- offset na videolince

         xor       dx,dx                    ; DX <- 0
         mov       bx,4
         div       bx                       ; AX <- slo linky / 4, DX <- zbytek

         mov       bx,dx                    ; BX <- slo linky 0 a 3
         mov       dx,80                    ; poet bajt na linku
         mul       dx                       ; pepoet na adresu
         add       di,ax                    ; DI <- adresa ve videopamti

         mov       ax,bx                    ; AX <- slo sekce po 2000h
         mov       dx,2000h                 ; poet bajt na sekci
         mul       dx
         add       ax,(((350-200)/2)/4)*80+20
         add       di,ax                    ; DI <- adresa sekce

         pop       ax
         pop       dx
         pop       bx
         ret

KorVRAM  ENDP

; -----------------------------------------------------------------------------
;        inicializace videomdu (CY=chyba, nepodporovan videokarta)
; -----------------------------------------------------------------------------

InitVMod PROC      NEAR

; ------ schova aktivnho videomdu

         mov       ah,0fh
         call      Int10                    ; poskytnut aktivnho videomdu
         mov       ds:[OldVMod],al          ; schova videomdu

; ------ test, zda je grafick karta EGA/VGA

         mov       ah,12h                   ; funkce poskytnut informac EGA
         mov       bx,5810h                 ; podsluba informac o EGA
         call      Int10                    ; poskytnut informac o EGA
         cmp       bh,2
         ja        InitVMd2                 ; nen karta EGA/VGA
         cmp       bl,5
         ja        InitVMd2                 ; nen karta EGA/VGA

; ------ nastaven grafickho mdu pro EGA a VGA

         mov       ax,13                    ; poadovan videomd 13
         call      Int10                    ; nastaven videomdu 13
         mov       ah,0fh
         call      Int10                    ; poskytnut aktivnho videomdu
         cmp       al,13                    ; je poadovan videomd ?
         je        InitVMd7                 ; videomd nastaven OK

; ------ nastaven videomdu pro Hercules

InitVMd2:cmp       byte ptr ds:[OldVMod],7  ; je videomd 7 ?
         je        InitVMd4                 ; je videomd 7

         push      ds
         xor       ax,ax
         mov       ds,ax
         cmp       word ptr ds:[463h],3b4h  ; je emultor CGA pro Hercules ?
         pop       ds
         jne       InitVMd8                 ; chyba - je asi karta CGA

InitVMd4:mov       ax,7
         call      Int10                    ; nastaven MONO videomdu
         mov       ah,0fh
         call      Int10                    ; poskytnut videomdu
         cmp       al,7                     ; nastaven videomd 7 ?
         jne       InitVMd8                 ; chyba - videomd nenastaven

; ------ nastaven grafickho videomdu Hercules

         inc       byte ptr ds:[Hercules]   ; pznak videokarty Hercules
         call      InitHerc                 ; inicializace videomdu Hercules
InitVMd7:clc
         ret

InitVMd8:stc
InitVMd9:ret

InitVMod ENDP

; -----------------------------------------------------------------------------
;        inicializace videokarty HERCULES (neuchovv registry, jen DS !)
; -----------------------------------------------------------------------------

InitHerc PROC      NEAR

         cli                                ; zkaz peruen

; ------ povolen pepnut adresy pamti, adresa je 0b000h

         mov       al,3
         mov       dx,3bfh
         out       dx,al                    ; nastaven registru kompatibility

; ------ nastaven grafickho mdu, videosignl blokovn

         mov       al,2
         mov       dl,0b8h
         out       dx,al                    ; nastaven dicho registru mdu

; ------ nastaven dicch registr CRT

         mov       dl,0b4h
         mov       si,offset ITabHerc       ; inicializan tabulka pro Hercules
         xor       ah,ah                    ; ukazatel sla registru
         cld
InitHrc2:mov       al,ah                    ; slo registru
         out       dx,al                    ; nastaven sla registru
         lodsb
         inc       dx
         out       dx,al                    ; data pro nastaven registru
         dec       dx
         inc       ah
         cmp       ah,12
         jb        InitHrc2                 ; dal registr

; ------ povolen videosignlu, nastaven grafickho mdu

         mov       al,0ah
         mov       dx,3b8h
         out       dx,al                    ; nastaven dicho registru mdu

; ------ vymazn videopamti (je CLD !)

         sti
         mov       cx,4000h                 ; dlka videopamti (ve slovech)
         mov       ax,0b000h                ; segment videopamti
         mov       ds:[SegmVRAM],ax         ; segment videopamti
         mov       es,ax
         xor       ax,ax                    ; mazac slovo
         xor       di,di
         rep       stosw                    ; vymazn videopamti
         ret

InitHerc ENDP

; -----------------------------------------------------------------------------
;        obsluha INT 10h s schovou registr
; -----------------------------------------------------------------------------

Int10    PROC      NEAR

         pushf
         push      si
         push      di
         push      bp
         push      ds
         push      es

         int       10h

         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         popf
         ret

Int10    ENDP

Code     ENDS

; *****************************************************************************
;
;                               Data
;
; *****************************************************************************
;
Data     SEGMENT
Font08   label     byte
INCLUDE  FONT08.ASM

CardTxt  db        'Lituji, program vyzaduje grafikou kartu EGA, VGA nebo Hercules !',13,10,'$'
PCXTxt   db        'CHYBA - nenalezen (nebo poskozen) soubor .PCX !',13,10,'$'
SCNTxt   db        'CHYBA - nenalezen (nebo poskozen) soubor .SCN !',13,10,'$'

UvTxt    dw        0                        ; adresa vodnho textu

; ------ tabulka pro nastaven dicch registr CRT karty Hercules

ITabHerc LABEL     BYTE
         db        53                       ; 0:celkov poet znak na dek-1
         db        40                       ; 1:poet vidit. znak na dek
         db        44                       ; 2:potek horiz. zatemnn
         db        7                        ; 3:poet znak na synchronizaci

         db        91                       ; 4:celk. poet vert. dk-1 (363)
         db        1                        ; 5:poet linek + k potu dk
         db        88                       ; 6:poet viditelnch dk (300)
         db        88                       ; 7:dka zptnho bhu (345)
         db        2                        ; 8:1=prokldn, 2=normal
         db        3                        ; 9:poet linek na znak - 1 (3)

         db        0                        ; 0a:prvn linka kurzoru
         db        3                        ; 0b:koncov linka kurzoru

SegmVRAM dw        0a000h                   ; segment videopamti
OldVMod  db        3                        ; uschovan pvodn videomd
Hercules db        0                        ; 0 <> pznak videokarty Hercules

BuffHes  db        '     '                  ; buffer hesla

                                            ; posun pi demonstraci
DemoPos  db        19 dup(1,0)
         db        8 dup(0,-1)
         db        3 dup( 19 dup(-1,0), 0,1, 19 dup(1,0), 0,1)
         db        19 dup(-1,0)
         db        0,1, 0,1, 0,1
         db        9 dup(1,0), 0,1
         db        0,0                      ; ukonen

SkorTxt  db        'SKORE',0
ScenTxt  db        ' SCENA ',0
HeslTxt  db        'F4 HESLO',0
Hes2Txt  db        ' heslo ',0

Bla1Txt  db        '                              ',0
Bla2Txt  db        '  B L A H O P  E J E M E  !  ',0
         db        '   Stal jste se absolutnm    ',0
         db        '      vtzem tto hry !      ',0

; ------ hlen pi srce

TabKec   label     byte                     ; max. 34 znak !
         db        'Kdo jinmu jmu kop...',0
         db        'A zase vedle...',0
         db        'Tak u to konen vzdejte!',0
         db        'U moc nechyblo!',0
         db        'A u zase?',0
         db        'To snad dlte schvln?',0
         db        'Co takhle se trochu soustedit?',0
         db        'Dejte si radji pauzu.',0
         db        'Nezoufejte, to se stane.',0
         db        'Netlute pota, neme za to!',0
         db        'Nevolal nkdo o pomoc?',0
         db        'Piznejte si, e na to ji nemte!',0
         db        'I vyvalily se vlny zdola...',0
         db        'ivot je ivot...',0
         db        'To vte, je to jako v ivot.',0
         db        'Nebrete, mohlo to bt i hor!',0
         db        'HA, HA, HA. DOSTAL JSEM T!',0
         db        'A m co sis zaslouil!',0
         db        'Na to jsem se ji dlouho til!',0
         db        'Nem tady nkdo nplast?',0
         db        'A l a r m  !   H O    !',0
         db        'Takhle to asi nemlo bt, e?',0
         db        'Tak kudy to asi bude?',0
         db        'Tudy tedy cesta nevede.',0
         db        'Chtlo to jen o kousek vedle.',0
         db        'Nen to k zblznn?',0
         db        'Mn nenadvejte, j za to nemohu.',0
         db        'Snad pt.',0
         db        'Co takhle to zkusit trochu jinak?',0
         db        'Nen koda ve takhle niit?',0
         db        'Zkuste si nechat zmit vae IQ!',0
         db        'Pozor na krevn tlak!',0
         db        'A nedte si pokoj a nedte!',0
         db        'Nectte kou?',0
         db        'Zkuste pout tlatko RESET!',0
         db        'To byla ale rna!',0
         db        'Snad to nevzdvte?',0
         db        'Pres eny kej tu kontinj...',0
         db        'Chyba lvky, zase nic.',0
         db        'A co jinak doma, vichni zdrvi?',0
         db        'Pozvte si odbornho poradce.',0
         db        'Tak dost legrcek a te ji vn!',0
         db        'Tak kolik to bylo dnes rumk?',0
         db        'Chybami se lovk u.',0
         db        0

CitKec   dw        2356h                    ; ta nhody pro hlen

; ------ asova

         EVEN                               ; zan na sud adrese jako 0:46ch
Cit1ms   dw        0                        ; konstanta pro dobu 1 ms

Zvuk     db        1                        ; pznak zapnut zvuku
AdrSound dw        0                        ; adresa zvuku
CitSound dw        0                        ; ta dlky zvuku (0=nen)

CitVyb   dw        0                        ; ta vbuchu

TabSLok  dw        166,254,365              ; zvuk lokomotivy
TabSLok0 label     byte

TabSVec  dw        400,600,800,1000,1200,1400,1600,1800,2000,1800,1600,1400,1200,1000,800,600,400,200 ; zvuk vci
TabSVec0 label     byte

FileName db        128 dup(0)               ; buffer jmna souboru
FilePCX  db        'PCX',0                  ; jmno souboru obrzk PCX
FileSCN  db        'SCN',0                  ; jmno souboru definice scn SCN

;FilePlay db        '_PLAYSCR.COM',0         ; jmno programu GDEMO ke sputn
;
;BlokPlay dw        0                        ; adresa segmentu prosted
;         dd        BlokPlCm                 ; adresa pkazovho dku
;         dw        5ch                      ; adresa FCB1
;         dw        SEG Code - 1             ; adresa PSP
;         dw        6ch                      ; adresa FCB2
;         dw        SEG Code - 1             ; adresa PSP

BlokPlCm db        0                        ; pkazov dek (przdn)
         db        13

SegmPSP  dw        0                        ; segment PSP

Smer     dw        0                        ; smr pohybu

;Demon    db        0                        ; 1=pznak demonstrace
Autom    dw        0                        ; ukazatel adresy automatu (0=nen)
AutomCek dw        0                        ; ta ekn po DEMO

CitTit   db        0                        ; ta ky titulku
CitVeci  dw        0                        ; ta vc
PozVrat  dw        0                        ; pozice vrat
Skore    dw        0                        ; ta skre

LastTime dw        0                        ; uschovan posledn as

Faze     db        0                        ; ta fze

NumScen  dw        0                        ; poet definovanch scn (s DEMO)
AktScen  db        1                        ; aktivn scna

RndUkaz  dw        0                        ; ukazatel pro nhodn slo

TabHesel db        5*256 dup(?)             ; tabulka hesel

MapVlak  db        3 * 12*20 dup(?)         ; mapa celho vlaku
                                            ;  0: (1) bze objektu (0=konec)
                                            ;  1: (1) souadnice X
                                            ;  2: (1) souadnice Y

Pole     db        12*20 dup(?)             ; hrac pole

Buffer   db        BuffSize dup(?)          ; vstupn buffer souboru

AdrObr   dw        256 dup(?)               ; adresy obrzk

AdrScen  dw        256 dup(?)               ; adresy scn

Data     ENDS

; *****************************************************************************
;
;                               Buffer scn
;
; *****************************************************************************

ScenSegm SEGMENT   PARA
         db        0ffffh dup(?)            ; buffer definice scn
ScenSegm ENDS

; *****************************************************************************
;
;                          Buffer obrzk
;
; *****************************************************************************

ObrSegm  SEGMENT   PARA
         db        (320/8)*200*4 dup(?)     ; buffer obrzk
ObrSegm  ENDS

; *****************************************************************************
;
;                              Zsobnk
;
; *****************************************************************************

Zasob    SEGMENT   'STACK' stack
         dw        200h dup(?)
Zasob    ENDS
         END       Start
