
; Doplnit rozbor FCB (sluba 2901h) !
; Doplnit konverzi podle aktivnho PSP !

MAXFILES EQU       1024                     ; maximln poet otevench soubor
INPBSIZE EQU       1024                     ; velikost techo bufferu souboru
OUTBSIZE EQU       4400h                    ; velikost vstupnho bufferu

; ------ definice kdovac tabulky

MAXLENX  EQU       25                       ; min. dlka dlouhho etzce
MAXLEN   EQU       MAXLENX+254              ; maximln dlka etzce
SUBSTLEN EQU       7                        ; dlka nahrazen dlouhm kdem

Code     SEGMENT
         ASSUME    cs:Code,ds:Code
         ORG       100h

; ------ kontrola pamti

Start:   cmp       sp,offset Zasob          ; je zsobnk OK ?
         jae       Start1                   ; pam je OK

; ------ chyba - zobrazen vodnho textu

         mov       dx,offset MemTxt         ; text - nedostatek pamti
Chyba:   push      dx                       ; schova textu chyby
         mov       dx,offset UvTxt          ; vodn text
         mov       ah,9
         int       21h                      ; zobrazen vodnho textu
         pop       dx

; ------ zobrazen textu chybovho hlen

         mov       ah,9
         int       21h                      ; zobrazen chybovho hlen
         mov       ax,4cffh
         int       21h                      ; nvrat s chybou

; ------ pedefinovn zsobnku

Start1:  mov       sp,offset Zasob          ; pedefinovn zsobnku

; ------ zmenen bloku programu na minimum

         mov       bx,(offset(Zasob-Start)+10fh)/16 ; velikost bloku programu
         mov       ah,4ah
         int       21h                      ; zmenen bloku programu

; ------ pprava k dekdovn pkazovho dku

         mov       si,81h                   ; zatek pkazovho dku
         mov       cl,ds:[si-1]             ; dlka pkazovho dku
         mov       ch,0

; ------ nalezen zatku jmna programu

         cld
         mov       dx,offset HelpTxt        ; text npovdy
Start2:  jcxz      Chyba                    ; chyba - nic nezadno
         lodsb                              ; naten znaku
         dec       cx                       ; snen tae znak
         cmp       al," "                   ; mezera ?
         je        Start2                   ; mezera se pesko
         cmp       al,9                     ; tabultor ?
         je        Start2                   ; tabultor se pesko

; ------ penesen jmna programu (ES=DS !)

         mov       di,offset ProgName       ; buffer jmna programu
Start3:  stosb                              ; uloen znaku
         jcxz      Start34                  ; nen dal znak
         lodsb                              ; naten dalho znaku
         dec       cx                       ; snen tae zbylch znak
         cmp       al," "                   ; je konec jmna programu ?
         je        Start32                  ; konec jmna programu
         cmp       al,9
         je        Start32                  ; konec jmna programu
         cmp       al,"/"
         jne       Start3                   ; nen konec - dal znak
Start32: dec       si                       ; nvrat ukazatele znak
         inc       cx                       ; nvrat tae zbylch znak
Start34: mov       al,0
         stosb                              ; ukonovac 0 jmna programu

; ------ penesen parametr programu

         mov       di,offset ProgComL       ; buffer pkazovho dku programu
         mov       al,cl                    ; AL <- dlka pkaz. dku
         stosb                              ; dlka pkazovho dku
         rep       movsb                    ; penesen pkazovho dku
         mov       al,13
         stosb                              ; ukonovac CR

;; ------ kontrola kompatibility systmu
;
;         xor       bx,bx                    ; pednastaven BX <- 0
;         mov       ah,51h
;         int       21h                      ; poskytnut aktivnho PSP
;         mov       ax,ds                    ; AX <- segment PSP
;         cmp       ax,bx                    ; je to platn adresa PSP ?
;         je        Start4                   ; je to kompatibiln systm OK
;         and       byte ptr ds:[Param],not 1; pznak nekompatibilnho systmu

; ------ pprava bloku parametr programu

Start4:  mov       ax,ds:[2ch]              ; segment prosted
         mov       ds:[ProgEnv],ax          ; segment prosted programu
         mov       word ptr ds:[ProgComm+2],ds ; segment pkazovho dku
         mov       word ptr ds:[ProgFCB1+2],ds ; segment FCB1
         mov       word ptr ds:[ProgFCB2+2],ds ; segment FCB2

; ------ schova adresy INT 21h

         push      es
         mov       ax,3521h
         int       21h                      ; poskytnut adresy INT 21h
         mov       word ptr ds:[Old21],bx   ; schova adresy INT 21h
         mov       word ptr ds:[Old21+2],es
         pop       es

; ------ pedefinovn adresy INT 23h (peruen programu)

         mov       ax,2523h
         mov       dx,offset Int23
         int       21h                      ; pedefinovn adresy INT 23h

; ------ pedefinovn adresy INT 21h

         mov       ax,2521h
         mov       dx,offset Int21
         int       21h                      ; pedefinovn adresy INT 21h

; ------ sputn zadanho programu

         mov       ds:[SegmSS],ss           ; schova segmentu SS
         mov       ax,4b00h
         mov       dx,offset ProgName       ; jmno programu
         mov       bx,offset ProgPack       ; blok parametr programu
         int       21h                      ; sputn programu

; ------ inicializace registr

Start6:  mov       ss,cs:[SegmSS]           ; nvrat segmentu SS
         mov       sp,offset Zasob          ; nvrat ukazatele zsobnku

; ------ nvrat adresy INT 21h

         pushf
         lds       dx,cs:[Old21]            ; pvodn adresa INT 21h
         mov       ax,2521h
         int       21h                      ; nvrat adresy INT 21h
         popf
         push      cs
         pop       ds                       ; DS <- CS

; ------ rozlien typu chyby

         jnc       Start8                   ; operace OK
         mov       dx,offset FndTxt         ; text - program nenalezen
         cmp       al,3
         jbe       Start7                   ; program nebo cesta nenalezena
         mov       dx,offset MemTxt         ; text - chyba pamti
         cmp       al,8
         je        Start7                   ; nedostatek pamti
         mov       dx,offset RunTxt         ; text - program nelze spusti
Start7:  jmp       Chyba                    ; chyba operace

; ------ nvratov kd programu

Start8:  mov       ah,4dh
         int       21h                      ; poskytnut nvratovho kdu

; ------ konec programu

         mov       ah,4ch
         int       21h

; -----------------------------------------------------------------------------
;        obsluha INT 23h
; -----------------------------------------------------------------------------

Int23:   clc                                ; pznak operace OK
         jmp       short Start6

; -----------------------------------------------------------------------------
;        obsluha INT 21h
; -----------------------------------------------------------------------------
;
Int21    PROC      FAR

         cmp       ah,1ah
         je        Int2108
         cmp       ah,25h
         je        Int2108
         cmp       ah,35h
         je        Int2108
         cmp       ah,30h
         jne       Int2109


Int2108:
         jmp       dword ptr cs:[Old21]     ; pvodn obsluha INT 21h


Int2109:





; ------ test, zda je oteven souboru

         pushf
         cmp       ah,6ch                   ; oteven souboru ?
         je        Int2116                  ; je oteven souboru 6ch
         cmp       ah,3dh                   ; oteven souboru ?
         jne       Int212                   ; nen oteven souboru 3Dh

; ------ proveden funkce oteven souboru (v zsobnku je F !)

Int2116: call      dword ptr cs:[Old21]     ; funkce oteven souboru
         jc        Int2119                  ; chyba operace
         call      OpenHlp                  ; test, zda je AX soubor HLP
Int2119: jmp       Int21R                   ; nvrat z obsluhy

; ------ test, zda je uzaven souboru

Int212:  cmp       ah,3eh                   ; uzaven souboru ?
         jne       Int213                   ; nen uzaven souboru
         call      ClosHlp                  ; uzaven souboru BX
         jmp       short Int218             ; uzaven souboru

; ------ test, zda je oteven soubor HLP

Int213:  call      TestHlp                  ; test, zda je soubor HLP
         jc        Int218                   ; nen soubor HLP

; ------ test, zda je zpis do souboru

         cmp       ah,40h                   ; je zpis do souboru ?
         jne       Int214                   ; nen zpis do souboru
         popf                               ; nvrat registru pznak
         stc                                ; pznak chyby zpisu
         mov       ax,5                     ; pznak odmtnut poadavku
         jmp       short Int21R             ; nvrat z funkce

; ------ test, zda je ten ze souboru

Int214:  cmp       ah,3fh                   ; je ten ze souboru ?
         jne       Int215                   ; nen ten ze souboru

; ------ naten dat s dekomprimac

         popf                               ; nvrat registru pznak
         call      ReadHlp                  ; naten dat ze souboru BX
         jmp       short Int21R

; ------ posun ukazatele od konce souboru

Int215:  cmp       ax,4202h                 ; je posun od konce ?
         jne       Int218                   ; nen posun od konce

         popf
         call      EndUHlp                  ; posun ukazatele od konce
         jmp       short Int21R

; ------ pokraovn pvodn funkc

Int218:  popf                               ; nvrat registru pznak
         jmp       dword ptr cs:[Old21]     ; pvodn obsluha INT 21h

; ------ nvrat z operace INT 21h s navrcenm registru pznak

Int21R:                                     ; SS:[BP+8]=Flag
                                            ; SS:[BP+6]=CS
                                            ; SS:[BP+4]=IP
         push      bp                       ; SS:[BP+2]=BP
         push      ax                       ; SS:[BP+0]=AX
         mov       bp,sp                    ; ukazatel dat v zsobnku
         pushf                              ; navrcen registr pznak
         pop       ax                       ; AX <- Flag
         mov       ss:[bp+8],al             ; navrcen pznaky
         pop       ax
         pop       bp
         iret

Int21    ENDP

; -----------------------------------------------------------------------------
;        voln obsluhy INT 21h
; -----------------------------------------------------------------------------

Call21   PROC      NEAR

         pushf
         call      dword ptr cs:[Old21]
         ret

Call21   ENDP

; -----------------------------------------------------------------------------
;        test, zda je AX soubor HLP (a pp. uloen identifiktoru)
; -----------------------------------------------------------------------------

OpenHlp  PROC      NEAR

; ------ schova registr

         pushf
         push      ax
         push      bx
         push      cx
         push      dx
         push      ds

; ------ kontrola identifiktoru souboru

         cmp       ax,MAXFILES              ; je slo souboru OK ?
         jae       OpenHlp9                 ; chybn slo souboru

; ------ schova ukazatele v souboru

         xchg      ax,bx                    ; BX <- identifiktor souboru
         call      PushUk                   ; schova ukazatele v souboru

; ------ nastaven ukazatele v souboru na zatek

         xor       dx,dx                    ; offset LOW
         xor       cx,cx                    ; offset HIGH
         mov       ax,4200h
         call      call21                   ; nastaven ukazatele v souboru

; ------ naten zhlav souboru

         push      cs
         pop       ds                       ; DS <- CS
         mov       dx,offset BuffZahl       ; buffer zhlav souboru
         mov       cx,6                     ; poet bajt k naten
         mov       ah,3fh
         call      call21                   ; naten zhlav souboru
         jc        OpenHlp8                 ; chyba ten
         cmp       ax,6                     ; nateno dost dat ?
         jne       OpenHlp8                 ; nateno mlo dat

; ------ test, zda to je soubor XCD

         cmp       word ptr ds:[BuffZahl],"X"*256 + 27 ; 1. a 2. bajt zhlav
         jne       OpenHlp8                 ; nen HLP
         cmp       word ptr ds:[BuffZahl+2],"DC" ; 3. a 4. bajt zhlav
         jne       OpenHlp8                 ; nen HLP
         cmp       byte ptr ds:[BuffZahl+5],0 ; parametry HIGH
         jne       OpenHlp8

; ------ je soubor HLP - nastaven pznaku souboru

         push      bx
         mov       cl,bl                    ; CL <- identifiktor
         and       cl,7                     ; ni 3 bity
         mov       al,1                     ; nastavovac bit
         shl       al,cl                    ; rotace bitu na pozici
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; identifiktor / 8
         or        ds:[JeHlp+bx],al         ; nastaven pznaku HLP
         pop       bx

; ------ nvrat ukazatele v souboru

OpenHlp8:call      PopUk                    ; nvrat ukazatele v souboru

; ------ nvrat registr

OpenHlp9:pop       ds
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         popf
         ret

OpenHlp  ENDP

; -----------------------------------------------------------------------------
;        uzaven souboru BX
; -----------------------------------------------------------------------------

ClosHlp  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx

; ------ kontrola identifiktoru souboru

         cmp       bx,MAXFILES              ; je slo souboru OK ?
         jae       ClosHlp9                 ; chybn slo souboru

; ------ nulovn aktivnho souboru

         cmp       bx,cs:[InpIdent]         ; je to aktivn oteven soubor ?
         jne       ClosHlp2                 ; nen to aktivn oteven soubor
         mov       word ptr cs:[InpIdent],-1 ; aktivn soubor je neplatn
         mov       word ptr cs:[FileSize],-1 ; velikost souboru neznm
         mov       word ptr cs:[FileSize+2],-1

; ------ nulovn pznaku oteven souboru

ClosHlp2:mov       cl,bl                    ; CL <- identifiktor
         and       cl,7                     ; ni 3 bity
         mov       al,not 1                 ; nulovac bit
         rol       al,cl                    ; rotace bitu na pozici
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; identifiktor / 8
         and       cs:[JeHlp+bx],al         ; nulovn pznaku HLP

; ------ nvrat registr

ClosHlp9:pop       cx
         pop       bx
         pop       ax
         ret

ClosHlp  ENDP

; -----------------------------------------------------------------------------
;        test, zda je BX soubor HLP (-> CY=nen)
; -----------------------------------------------------------------------------

TestHlp  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx

; ------ kontrola identifiktoru souboru

         cmp       bx,MAXFILES              ; je slo souboru OK ?
         jae       TestHlp8                 ; chybn slo souboru

; ------ test pznaku souboru HLP

         mov       cl,bl                    ; CL <- identifiktor
         and       cl,7                     ; ni 3 bity
         mov       al,1                     ; testovac bit
         shl       al,cl                    ; rotace bitu na pozici
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; identifiktor / 8
         test      cs:[JeHlp+bx],al         ; test pznaku HLP
         jnz       TestHlp9                 ; je soubor HLP
TestHlp8:stc                                ; pznak - nen soubor HLP

; ------ nvrat registr

TestHlp9:pop       cx
         pop       bx
         pop       ax
         ret

TestHlp  ENDP

; -----------------------------------------------------------------------------
;        naten CX bajt ze souboru BX (HLP) na adresu DS:DX
; -----------------------------------------------------------------------------
;
ReadHlp  PROC      NEAR

; ------ schova registr

         push      cx
         push      dx
         push      si
         push      di
         push      bp
         push      ds
         push      es
         call      PushUk                   ; schova ukazatele v souboru

; ------ pprava registr

         push      ds
         pop       es                       ; ES <- segment k naten dat
         mov       di,dx                    ; DI <- offset k naten dat
         mov       bp,cx                    ; BP <- poet bajt k naten
         push      cs
         pop       ds                       ; DS <- segment programu

; ------ pprava ukazatel pro soubor BX

         call      InitHlp                  ; pprava ukazatel

; ------ offset ve vstupnm bufferu

ReadHlp3:mov       ax,word ptr ds:[OldUk]   ; poadovan offset dat
         mov       cx,word ptr ds:[OldUk+2]
         sub       ax,word ptr ds:[OutBOffs] ; offset dat v bufferu
         sbb       cx,word ptr ds:[OutBOffs+2]
         jnz       ReadHlp4                 ; nen jet dosaeno potku
         cmp       ax,ds:[OutBNum]          ; je ukazatel OK ?
         jb        ReadHlp5                 ; ukazatel je OK

; ------ naten dalch dat do bufferu

ReadHlp4:call      DeKomp                   ; naten dalch dat
         jc        ReadHlp9                 ; chyba
         cmp       word ptr ds:[OutBNum],0  ; je nco v bufferu ?
         je        ReadHlp8                 ; konec souboru
         jmp       short ReadHlp3           ; test ukazatele

; ------ penesen sti dat do bufferu

ReadHlp5:xchg      si,ax                    ; SI <- offset v bufferu
         mov       cx,ds:[OutBNum]          ; poet bajt v bufferu
         sub       cx,si                    ; poet zbylch bajt dat
         add       si,offset OutBuff        ; vstupn buffer
         cmp       cx,bp                    ; poaduje se mn ?
         jbe       ReadHlp6
         mov       cx,bp                    ; omezen potu bajt
ReadHlp6:sub       bp,cx                    ; snen tae dat
         cld
         add       word ptr ds:[OldUk],cx   ; zven ukazatele v souboru
         adc       word ptr ds:[OldUk+2],0
         rep       movsb                    ; penesen dat

; ------ test, zda se poaduj dal data

         or        bp,bp                    ; poaduj se dal data ?
         jnz       ReadHlp3                 ; poaduj se dal data

; ------ operace OK - poet natench bajt dat -> AX

ReadHlp8:mov       ax,di                    ; konec ukldac adresy
         sub       ax,dx
         clc                                ; pznak operace OK

; ------ nvrat registr

ReadHlp9:call      PopUk                    ; nvrat ukazatele v souboru
         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         pop       dx
         pop       cx
         ret

ReadHlp  ENDP

; -----------------------------------------------------------------------------
;        naten dalch komprimovanch dat (DS=datov segment) -> CY=chyba
; -----------------------------------------------------------------------------

DeKomp   PROC      NEAR

; ------ schova registr

         push      bx
         push      cx
         push      dx
         push      si
         push      di
         push      es

; ------ psun rezervovanch dat v bufferu

         push      ds
         pop       es                       ; ES <- DS
         mov       si,ds:[OutBNum]          ; poet bajt v bufferu
         mov       cx,2200h                 ; omezen dat k ponechn
         cmp       si,2200h                 ; zbv dost dat ?
         ja        DeKomp0                  ; zbv dost dat
         xor       cx,cx                    ; nic se neponech
DeKomp0: sub       si,cx                    ; data k psunu
         add       word ptr ds:[OutBOffs],si ; posun offsetu bufferu
         adc       word ptr ds:[OutBOffs+2],0
         mov       di,offset OutBuff        ; vstupn buffer
         add       si,di                    ; konec dat v bufferu
         mov       ds:[OutBNum],cx          ; nov poet bajt v bufferu
         cld
         rep       movsb                    ; psun zbytku dat

; ------ pprava registr

         mov       dx,ds:[WordBuff]         ; uschovan pznakov slovo
         mov       si,ds:[InpBRead]         ; tec offset ze vstupnho bufferu

; ------ test, zda je vstupn buffer ji pln

DeKomp1: cmp       di,offset OutBuff0       ; je buffer ji pln ?
         jae       DeKomp19                 ; buffer je ji pln

; ------ pesun jednoho bajtu dat bez komprese

         call      ReadBit                  ; naten prvnho bitu
         jc        DeKomp2                  ; je komprese etzce
         call      ReadByte                 ; naten dalho bajtu
         jc        DeKomp19                 ; chyba
         jz        DeKomp19                 ; konec souboru
         stosb                              ; uloen bajtu dat
         jmp       short DeKomp1            ; dal data

DeKomp19:jmp       DeKomp9

; ------ pprava k opakovn etzce

DeKomp2: xor       bx,bx                    ; BX <- 0 offset etzce
         xor       cx,cx                    ; CX <- 0 dlka etzce

; -----------------------------------
;        stanoven dlky etzce
; -----------------------------------

; ------ prvn bit dlky etzce -> CX

         call      ReadBit                  ; naten bitu dlky
         rcl       cx,1                     ; rotace bitu do registru CX

; ------ zven tae dlky

DeKomp3: inc       cx
         inc       cx

; ------ naten pznaku konce kdu

         call      ReadBit                  ; pznakov bit
         jnc       DeKomp4                  ; konec kdu

; ------ ppadn pokraovn kdu

         cmp       cl,MAXLENX-4+1           ; je ji maximln dlka ?
         jb        DeKomp3                  ; pokraovn kdu
         inc       cx
         inc       cx                       ; korekce poslednch 2 kd

; ------ korekce pro nhradn kd

DeKomp4: cmp       cl,SUBSTLEN              ; je nhradn dlka ?
         jb        DeKomp7                  ; dlka je OK
         ja        DeKomp6                  ; je dlouh dlka

; ------ dlouh opakovn

         call      ReadByte                 ; naten bajtu
DeKomp5: jc        DeKomp19                 ; chyba
         jz        DeKomp19                 ; konec souboru
         mov       cl,al                    ; dlka (stav 0 a 255)
         cmp       cl,255                   ; konec dekdovn ?
         je        DeKomp19                 ; je konec
         add       cx,MAXLENX+1             ; zven dlky

; ------ korekce dlky pro dlouh kd

DeKomp6: dec       cx

; ------------------------------------
;        stanoven offsetu etzce
; ------------------------------------

; ------ dlka 2 nem offset HIGH

DeKomp7: cmp       cx,2                     ; je dlka 2 ?
         je        DeKomp74                 ; je dlka 2

; ------ prvn pznakov bit - pznak offsetu HIGH=0

         call      ReadBit                  ; ten pznakovho bitu
         jc        DeKomp74                 ; offset HIGH = 0

; ------ 3 bity offsetu HIGH

         call      ReadBit                  ; naten bitu
         rcl       bh,1                     ; rotace bitu do registru BH
         call      ReadBit                  ; naten bitu
         rcl       bh,1                     ; rotace bitu do registru BH
         call      ReadBit                  ; naten bitu
         rcl       bh,1                     ; rotace bitu do registru BH

; ------ stav 0,1: offset HIGH = 1,2

         cmp       bh,1                     ; je stav 0,1 ?
         jbe       DeKomp72                 ; offset HIGH = 1,2

; ------ tvrt bit offsetu

         call      ReadBit                  ; naten bitu
         rcl       bh,1                     ; rotace bitu do registru BH

; ------ stav 4,7: offset HIGH=3 a 6

         dec       bh                       ; stav 3 a 14
         cmp       bh,6                     ; je stav 3 a 6 ?
         jbe       DeKomp74                 ; je offset 3 a 6
                                            ; jinak stav 7 a 14
; ------ pt bit offsetu

         call      ReadBit                  ; naten bitu
         rcl       bh,1                     ; rotace bitu do registru BH

; ------ stav 14 a 23: offset HIGH=7 a 13

         sub       bh,7                     ; stav 7 a 22
         cmp       bh,13
         jbe       DeKomp74                 ; je offset 7 a 13
                                            ; jinak stav 14 a 22
; ------ est bit offsetu: offset HIGH=14 a 31

         call      ReadBit                  ; naten bitu
         rcl       bh,1                     ; rotace bitu do registru BH
         sub       bh,15                    ; stav 13 a 30

; ------ offset etzce LOW

DeKomp72:inc       bh                       ; korekce BH
DeKomp74:call      ReadByte                 ; naten offsetu dlky LOW
DeKomp76:jc        DeKomp9                  ; chyba
         jz        DeKomp9                  ; konec souboru
         mov       bl,al                    ; offset dlky LOW

; ------ penos etzce

         push      si                       ; schova SI
         mov       si,di                    ; souasn ukazatel
         sub       si,bx                    ; posun zatku etzce
         rep       movsb                    ; penos etzce
         pop       si
         jmp       DeKomp1                  ; dal dekdovn

; ------ uloen novho stavu registr
; sem se ske z procedury ReadBit pi chyb nebo konci souboru

DeKomp9: pushf
         mov       ds:[InpBRead],si         ; tec offset ze vstupnho bufferu
         mov       ds:[WordBuff],dx         ; pznakov slovo
         sub       di,offset OutBuff        ; nov poet bajt v bufferu
         mov       ds:[OutBNum],di          ; poet bajt ve vstupnm bufferu
         popf

; ------ nvrat registr

         pop       es
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         ret

DeKomp   ENDP

; ------ naten bitu ze stavovho slova -> CF (pi chyb skok na DeKomp9)

ReadBit: shr       dx,1                     ; poskytnut bitu ze stavovho slova
         jnz       ReadBit2                 ; nen jet konec slova
         call      ReadByte                 ; naten dalho bajtu
         jc        ReadBit9                 ; chyba
         jz        ReadBit9                 ; konec souboru
         mov       dl,al                    ; ni bajt stavovho slova
         call      ReadByte                 ; naten dalho bajtu
         jc        ReadBit9                 ; chyba
         jz        ReadBit9                 ; konec souboru
         mov       dh,al                    ; vy bajt stavovho slova
         stc                                ; pznak konce
         rcr       dx,1                     ; prvn bit stavovho slova
ReadBit2:ret

; ------ peruen operace

ReadBit9:pop       cx                       ; zruen nvratov adresy
         jmp       short DeKomp9

; -----------------------------------------------------------------------------
;     ten bajtu ze souboru (offset v bufferu DS:SI) -> AL, ZY=konec, CY=chyba
; -----------------------------------------------------------------------------

ReadByte PROC      NEAR

; ------ kontrola, zda jsou dal data v bufferu

         cmp       si,ds:[InpBNum]          ; jsou dal data ?
         jae       ReadByt2                 ; je konec bufferu

; ------ naten bajtu z bufferu

ReadByt1:clc
         mov       al,ds:[si+InpBuff]       ; naten dalho znaku
         inc       si                       ; zven ukazatele v bufferu
         ret                                ; zde je NC a NZ !

; ------ naten dalho bloku dat

ReadByt2:xor       si,si                    ; ukazatel dat na zatek bufferu
         call      ReadBuff                 ; naten dalho bloku dat
         jc        ReadByt3                 ; chyba (pznak CY)

; ------ test, zda je ji konec souboru

         cmp       si,ds:[InpBNum]          ; jsou ji dal data ?
         jb        ReadByt1                 ; jsou dal data OK
         or        si,si                    ; pznaky ZY a NC
ReadByt3:ret

ReadByte ENDP

; -----------------------------------------------------------------------------
;        naten dalho bloku dat ze souboru do vstupnho bufferu DS -> CY chyba
; -----------------------------------------------------------------------------

ReadBuff PROC      NEAR

; ------ schova registr

         push      bx
         push      ax
         push      cx
         push      dx

; ------ posun ukazatele dat

         mov       ax,ds:[InpBNum]          ; poet bajt v bufferu
         add       word ptr ds:[InpBOffs],ax ; posun ukazatele v souboru
         adc       word ptr ds:[InpBOffs+2],0
         mov       word ptr ds:[InpBNum],0

; ------ nastaven ukazatele v souboru

         mov       ax,4200h
         mov       bx,ds:[InpIdent]         ; identifiktor souboru
         mov       dx,word ptr ds:[InpBOffs] ; offset potku bufferu v souboru
         mov       cx,word ptr ds:[InpBOffs+2]
         call      call21                   ; nastaven ukazatele v souboru

; ------ naten dalho bloku dat

         mov       ah,3fh
         mov       dx,offset InpBuff        ; vstupn buffer
         mov       cx,INPBSIZE              ; velikost vstupnho bufferu
         call      call21                   ; naten vstupnho bufferu
         jc        ReadBuf8                 ; chyba operace
         mov       ds:[InpBNum],ax          ; poet bajt ve vstupnm bufferu
         clc                                ; pznak operace OK

; ------ operace OK - nvrat registr

         pop       dx
         pop       cx
         pop       ax
         pop       bx
         cld
         ret

; ------ chyba operace - nvrat registr (AX=chybov kd)

ReadBuf8:pop       dx
         pop       cx
         pop       bx
         pop       bx
         cld
         ret

ReadBuff ENDP

; -----------------------------------------------------------------------------
;        posun ukazatele BX od konce souboru
; -----------------------------------------------------------------------------

EndUHlp  PROC      NEAR

; ------ schova registr

         push      bx
         push      cx
         push      ds

; ------ inicializace ukazatel souboru

         push      cs
         pop       ds
         call      InitHlp                  ; inicializace ukazatel

; ------ test, zda je velikost souboru ji znm

         cmp       word ptr ds:[FileSize],-1
         jne       EndUHlp4
         cmp       word ptr ds:[FileSize+2],-1
         jne       EndUHlp4

; ------ zjitn velikosti souboru

         mov       word ptr ds:[OldUk],-1
         mov       word ptr ds:[OldUk+2],-1
EndUHlp2:call      DeKomp                   ; naten dalch dat
         jc        EndUHlp3                 ; chyba
         cmp       word ptr ds:[OutBNum],0  ; je nco v bufferu ?
         jne       EndUHlp2                 ; konec souboru
EndUHlp3:mov       ax,word ptr ds:[OutBOffs] ; ukazatel v souboru
         mov       word ptr ds:[FileSize],ax
         mov       ax,word ptr ds:[OutBOffs+2]
         mov       word ptr ds:[FileSize+2],ax

; ------ nastaven ukazatele v souboru

EndUHlp4:mov       ax,word ptr ds:[FileSize] ; velikost LOW
         sub       ax,dx                    ; offset LOW
         xchg      ax,dx                    ; DX <- offset LOW
         mov       ax,word ptr ds:[FileSize+2] ; velikost HIGH
         sbb       ax,cx                    ; offset HIGH
         xchg      ax,cx                    ; CX <- offset HIGH
         mov       ax,4200h
         call      call21                   ; nastaven ukazatele v souboru

; ------ nvrat registr

         pop       ds
         pop       cx
         pop       bx
         ret

EndUHlp  ENDP

; -----------------------------------------------------------------------------
;        inicializace aktulnho souboru BX (DS=datov segment)
; -----------------------------------------------------------------------------

InitHlp  PROC      NEAR

; ------ schova registr

         push      ax

; ------ test, zda to je aktuln soubor v bufferu

         cmp       bx,ds:[InpIdent]         ; je to aktuln soubor ?
         mov       ds:[InpIdent],bx         ; nov aktuln soubor
         jne       InitHlp5                 ; nen aktuln soubor - nulovn

; ------ test, zda je poadovan ukazatel za daty v bufferu

         mov       ax,word ptr ds:[OldUk+2] ; ukazatel dat HIGH
         cmp       ax,word ptr ds:[OutBOffs+2] ; je za potkem bufferu ?
         jne       InitHlp4
         mov       ax,word ptr ds:[OldUk]   ; ukazatel dat LOW
         cmp       ax,word ptr ds:[OutBOffs]
InitHlp4:jae       InitHlp8                 ; ukazatel je za potkem bufferu
         jmp       short InitHlp6           ; nulovn ukazatel na zatek

; ------ pi jinm souboru velikost souboru neznm

InitHlp5:mov       word ptr ds:[FileSize],-1 ; velikost souboru neznm
         mov       word ptr ds:[FileSize+2],-1

; ------ inicializace ukazatel na zatek souboru

InitHlp6:xor       ax,ax                    ; AX <- 0
         mov       word ptr ds:[InpBOffs],6 ; offset potku vstupnho bufferu
         mov       word ptr ds:[InpBOffs+2],ax
         mov       word ptr ds:[InpBNum],ax ; nejsou data ve vstupnm bufferu
         mov       word ptr ds:[InpBRead],ax ; tec offset ze vstupnho bufferu
         mov       word ptr ds:[OutBOffs],ax ; offset potku vstupnho bufferu
         mov       word ptr ds:[OutBOffs+2],ax
         mov       word ptr ds:[OutBNum],ax ; nejsou data ve vstupnm bufferu
         inc       ax                       ; AX <- 1
         mov       word ptr ds:[WordBuff],ax ; uschovan pznakov slovo

; ------ nvrat registr

InitHlp8:pop       ax
         ret

InitHlp  ENDP

; -----------------------------------------------------------------------------
;        schova ukazatele v souboru BX
; -----------------------------------------------------------------------------

PushUk   PROC      NEAR

; ------ schova registr

         push      ax
         push      cx
         push      dx

; ------ poskytnut ukazatele v souboru

         xor       dx,dx                    ; offset LOW
         xor       cx,cx                    ; offset HIGH
         mov       ax,4201h
         call      call21                   ; poskytnut ukazatele v souboru

; ------ schova ukazatele v souboru

         mov       word ptr cs:[OldUk],ax   ; aktuln ukazatel LOW
         mov       word ptr cs:[OldUk+2],dx ; aktuln ukazatel HIGH

; ------ nvrat registr

         pop       dx
         pop       cx
         pop       ax
         ret

PushUk   ENDP

; -----------------------------------------------------------------------------
;        nvrat ukazatele v souboru BX (uchovv registr pznak)
; -----------------------------------------------------------------------------

PopUk    PROC      NEAR

; ------ schova registr

         pushf
         push      ax
         push      cx
         push      dx

; ------ nvrat ukazatele v souboru

         mov       dx,word ptr cs:[OldUk]   ; ukazatel LOW
         mov       cx,word ptr cs:[OldUk+2] ; ukazatel HIGH
         mov       ax,4200h
         call      call21                   ; nvrat ukazatele v souboru

; ------ nvrat registr

         pop       dx
         pop       cx
         pop       ax
         popf
         ret

PopUk    ENDP

; -----------------------------------------------------------------------------
;        dat
; -----------------------------------------------------------------------------

UvTxt    db        'HLPRUN v1.0 - rezidentni dekomprimace HLP; (c) Miroslav Nemecek',13,10,'$'
HelpTxt  db        'Zadejte jako parametr specifikaci programu ke spusteni !',13,10,'$'
MemTxt   db        'CHYBA - nedostatek pameti ke spusteni programu !',13,10,'$'
FndTxt   db        'CHYBA - zadany program nenalezen !',13,10,'$'
RunTxt   db        'CHYBA - program nelze spustit !',13,10,'$'

BuffZahl db        6 dup(0)                 ; buffer zhlav souboru XCD

Old21    dd        0                        ; uschovan pvodn adresa INT 21h
OldUk    dd        0                        ; uschovan ukazatel v souboru

; ------ buffer aktivnho souboru

InpIdent dw        -1                       ; identifiktor souboru v bufferu
InpBOffs dd        0                        ; offset potku vstupnho bufferu
InpBNum  dw        0                        ; poet bajt ve vstupnm bufferu
InpBRead dw        0                        ; tec offset ze vstupnho bufferu
OutBOffs dd        0                        ; offset potku vstupnho bufferu
OutBNum  dw        0                        ; poet bajt ve vstupnm bufferu
FileSize dd        -1                       ; detekovan velikost souboru
WordBuff dw        1                        ; uschovan pznakov slovo

;Param    db        1                        ; parametry
;                                            ;   bit 0: 1=kompatibiln systm

ProgPack label     byte                     ; blok parametr programu
ProgEnv  dw        0                        ; segment prosted programu
ProgComm dd        offset ProgComL          ; adresa pkazovho dku programu
ProgFCB1 dd        5ch                      ; adresa prvnho FCB programu
ProgFCB2 dd        6ch                      ; adresa druhho FCB programu

JeHLP    db        (MAXFILES+7)/8 dup(0)    ; buffer pznak soubor

SegmSS   dw        ?                        ; uschovan segment SS

ProgComL db        128 dup(?)               ; pkazov dek programu
ProgName db        128 dup(?)               ; jmno programu ke sputn

InpBuff  db        INPBSIZE dup(?)          ; vstupn buffer souboru
OutBuff  db        OUTBSIZE dup(?)          ; vstupn buffer
OutBuff0 db        MAXLEN+10 dup(?)         ; rezerva za vstupnm bufferem

         dw        200h dup(?)
Zasob    label     byte                     ; zsobnk

Code     ENDS
         END       Start
