
; 
;
;                          Komprese soubor npovdy
;
; 

INSTRJMP EQU       0e9h                     ; kd instrukce JMP NEAR

MAXOFFS  EQU       1fffh                    ; maximln offset etzce
MAXLENX  EQU       25                       ; min. dlka dlouhho etzce
MAXLEN   EQU       MAXLENX+254              ; maximln dlka etzce

SUBSTLEN EQU       7                        ; dlka nahrazen dlouhm kdem

Code     SEGMENT
         ASSUME    cs:Code,ds:Code

; ------ pprava pkazovho dku

Start:   mov       bl,ds:[80h]              ; dlka pkazovho dku
         mov       bh,0
         mov       byte ptr ds:[bx+81h],0   ; oznaen konce pkazovho dku

; ------ inicializace segmentovch registr

         sti                                ; peruen povoleno
         mov       ax,cs                    ; datov segment
         mov       ds,ax                    ; DS <- datov segment
         mov       ds:[SegPSP],es           ; segment PSP
         mov       es,ax                    ; ES <- datov segment

; ------ zobrazen vodnho textu

         mov       si,offset UvTxt          ; vodn text
         call      DispTxt                  ; zobrazen vodnho textu

; ------ rozbor zadn jmen soubor

         mov       si,81h                   ; zatek pkazovho dku
         call      RozbPar                  ; rozbor parametr
         jc        Zebrik                   ; chyba zadn   JAK
         mov       di,offset Soub1          ; buffer jmna vstupnho souboru
         call      RozbFil                  ; rozbor jmna souboru
         jc        Zebrik                   ; jmno souboru nezadno   JAK

         push      di                       ; T1 = ofset konce jmna 1

         call      RozbPar                  ; rozbor parametr
         jc        Zebrik                   ; chyba zadn
         mov       di,offset Soub2          ; buffer jmna vstupnho souboru
         call      RozbFil                  ; rozbor jmna souboru
         jc        Zebrik                   ; chyba zadn

         push      di                       ; T2 = ofset konce jmna 2

         call      RozbPar                  ; rozbor parametr

Zebrik:  jc        Start2                   ; chyba zadn

;* oeten povolen '*' msto jmna vstupnho souboru

         pop       di                       ; DI = konec jmna 2
         pop       si                       ; SI = konec jmna 1
         mov       bx,di                    ; BX = konec jmna 2

                                          ;* hledn znaku '*' ve 2
HleHve:  dec       di                       ; pedchzejc znak
         cmp       di,offset Soub2 - 1      ; cel jmno prohledno ?
         jz        Start4                   ; ano, znak '*' nezadn
         cmp       byte ptr [di],'\'        ; znak je '\' ?
         jz        Start4                   ; znak '*' nezadn
         cmp       byte ptr [di],':'        ; znak je ':' ?
         jz        Start4                   ; znak '*' nezadn
         cmp       byte ptr [di],'*'        ; znak je '*' ?
         jnz       HleHve                   ; nen, test dalho znaku

                                          ;* '*' nalezena, je ve jmnu ? !!!
HveNal:  mov       dx,di                    ; DX = ofset znaku '*'

HveNa1:  cmp       byte ptr [di],'.'        ; znak je '.' ?
         jz        Start4                   ; '*' zadna v ppon
         dec       di                       ; pedchzejc znak
         cmp       di,offset Soub2 - 1      ; cel jmno 2 prohledno ?
         jz        HleJme                   ; ano, '*' je zadna ve jmnu
         cmp       byte ptr [di],'\'        ; znak je '\' ?
         jz        HleJme                   ; ano, '*' je zadna ve jmnu
         cmp       byte ptr [di],':'        ; znak je ':' ?
         jnz       HveNa1                   ; nen, test dalho znaku

HleJme:  mov       di,dx                    ; DI = ofset znaku '*'

                                          ;* hledn zatku jmna 1
         mov       dx,0ffffh                ; inicializace itae zn. jmna 1

HleJm1:  inc       dx                       ; +1 ita znak jmna 1
         dec       si                       ; pedchzejc znak
         cmp       si,offset Soub1 - 1      ; cel jmno 1 prohledno ?
         jz        xxx                      ; ano
         cmp       byte ptr [si],'\'        ; pedchzejc znak je '\' ?
         jz        xxx                      ; zatek jmna nalezen
         cmp       byte ptr [si],':'        ; pedchzejc znak je ':' ?
         jz        xxx                      ; zatek jmna nalezen
         cmp       byte ptr [si],'.'        ; pedchzejc znak je '.' ?
         jnz       HleJm1                   ; ne
         mov       dx,0ffffh                ; inicializace itae zn. jmna 1
         jmp       short HleJm1             ; test pedchzejcho znaku

xxx:     inc       si                       ; SI = zatek jmna 1
                                            ; DX = poet znak jmna 1
                                            ; DI = hvzdika, BX = konec 2

         mov       cx,dx                    ; CX = poet znak jmna 1
         mov       dx,bx                    ;
         sub       dx,di                    ; DX = poet znak ppony 2
         jmp       short zzzzzz             ;

                                          ;* posun ppony o jeden znak
zz:      push      bx                       ;
         push      cx                       ;
         mov       cx,dx                    ;
zzzz:    mov       al,[bx]                  ;
         mov       [bx + 1],al              ;
         dec       bx                       ;
         loop      zzzz                     ;
         pop       cx                       ;
         pop       bx                       ;
         inc       bx                       ;

                                          ;* pemstn jednoho znaku jmna
zzzzzz:  cld                                ;
         movsb                              ;
         loop      zz                       ;

         jmp       short Start4             ; konec modifikace JAK

; ------ chyba zadn - zobrazen npovdy

Start2:  mov       si,offset HelpTxt        ; text npovdy
Start3:  call      DispTxt                  ; zobrazen textu npovdy

; ------ chybov nvrat

Start31: mov       ax,4c01h
         int       21h

; ------ zadn hesla pro zakdovn souboru

Start4:  call      ZadHesl                  ; zadn hesla

; ------ oteven vstupnho souboru

         mov       dx,offset Soub1          ; jmno vstupnho souboru
         mov       ax,3d00h
         int       21h                      ; oteven vstupnho souboru
         mov       si,offset Soub1Txt       ; text - chybn zadn
         jc        Start3                   ; chybn zadn vstupnho souboru
         mov       ds:[Soub1I],ax           ; identifiktor vstupnho souboru
         mov       bx,ax

; ------ atributy souboru

         mov       ax,4300h
         int       21h                      ; poskytnut atribut souboru
         mov       ds:[FilAtr],cx           ; atributy souboru

; ------ datum a as souboru

         mov       ax,5700h
         int       21h
         mov       ds:[FilDate],dx          ; datum
         mov       ds:[FilTime],cx          ; as

; ------ stanoven velikosti souboru

         xor       cx,cx
         xor       dx,dx
         mov       ax,4202h
         int       21h                      ; vystaven ukazatele na konec
         mov       word ptr ds:[Soub1S],ax
         mov       word ptr ds:[Soub1S+2],dx ; velikost souboru
         xor       cx,cx
         xor       dx,dx
         mov       ax,4200h
         int       21h                      ; resetovn ukazatele souboru

; ------ test, zda vstupn soubor existuje

         mov       dx,offset BitBuff+2
         mov       ah,1ah
         int       21h                      ; nastaven adresy DTA
         mov       dx,offset Soub2
         mov       ax,3d02h
         int       21h                      ; test, zda soubor existuje
         jc        Start41

; ------ vstupn soubor existuje

         mov       bx,ax
         mov       ah,3eh
         int       21h
         mov       si,offset ExisTxt1
         call      DispTxt
         mov       si,offset Soub2
         call      DispTxt0
         mov       si,offset ExisTxt2
         call      DispTxt

         mov       ah,1
         int       21h
         call      UpCase
         mov       si,offset CRTxt
         call      DispTxt

         cmp       al,"A"
         je        Start41
         jmp       Start31

; ------ oteven vstupnho souboru

Start41: mov       dx,offset Soub2          ; jmno vstupnho souboru
         mov       ah,3ch
         xor       cx,cx
         int       21h                      ; vytvoen vstupnho souboru
         mov       si,offset Soub2Txt       ; text - chybn zadn
         jnc       Start42
         jmp       Start3                   ; chybn zadn vstupnho souboru
Start42: mov       ds:[Soub2I],ax           ; identifiktor vstupnho souboru

; ------ obsluha peruen

         push      ds
         push      cs
         pop       ds
         mov       dx,offset Navrat0
         mov       ax,2523h
         int       21h
         pop       ds

; ------ zobrazen hlen o komprimaci souboru

         mov       si,offset TextComp
         call      DispTxt

         mov       si,offset Soub1
         call      DispTxt0

Start54: mov       dl," "
         mov       ah,2
         int       21h

; ------ komprimace dat souboru

         call      Komprim                  ; komprimace dat souboru

         mov       si,offset TextSpc
         call      DispTxt                  ; vymazn procent

; ------ zpis zkomprimovanho souboru na disk

         call      Zakod                    ; zakdovn bufferu

         push      ds
         mov       bx,ds:[Soub2I]
         mov       cx,ds:[OutNum]
         add       word ptr ds:[Soub2S],cx
         adc       word ptr ds:[Soub2S+2],0
         xor       dx,dx
         mov       ds,ds:[OutSegm]
         mov       ah,40h
         int       21h                      ; uloen souboru na disk
         pop       ds
         mov       si,offset WritTxt        ; text - chyba zpisu
         jc        Chyba
         cmp       ax,cx                    ; bylo uloeno ve ?
         mov       al,0
         je        Navrat                   ; ve OK

; ------ chyba

Chyba:   call      DispTxt
Navrat0: mov       al,1                     ; pznak chyby

; ------ uzaven soubor

Navrat:  push      ax
         push      cs
         pop       ds
         mov       bx,ds:[Soub1I]           ; identifiktor vstupnho souboru
         mov       ah,3eh
         int       21h                      ; uzaven vstupnho souboru

         mov       bx,ds:[Soub2I]           ; identifiktor vstupnho souboru
         mov       ax,4202h
         xor       cx,cx
         xor       dx,dx
         int       21h                      ; velikost souboru
         push      ax

         mov       cx,ds:[FilTime]
         mov       dx,ds:[FilDate]
         mov       ax,5701h
         int       21h                      ; nastaven data a asu souboru

         mov       ah,3eh
         int       21h                      ; uzaven vstupnho souboru

         mov       dx,offset Soub2          ; jmno vstupnho souboru
         mov       cx,ds:[FilAtr]           ; atributy souboru
         mov       ax,4301h
         int       21h                      ; nastaven atribut souboru

         pop       ax
         or        ax,ax
         jnz       Navrat3

         mov       dx,offset Soub2
         mov       ah,41h
         int       21h                      ; zruen souboru
Navrat3:
         pop       ax

; ------ konec programu

         mov       ah,4ch
         int       21h

; *****************************************************************************
;
;                          Komprimace dat souboru
;
; *****************************************************************************

; -----------------------------------------------------------------------------
; Diagram kdovn          (1 bit)
; ----------------         Ŀ
;                           0  1 
;                                          DIAGRAM DLKY NESOUHLAS !!!
;       (1 bajt)   (2 bity)Ŀ
;Ŀ      Ĵ
; penos bajtu    Ŀ                  (1 bit) (stav 1,2,3)
;  beze zmny     stav 0            Ŀ
;         Ŀ      stav 6,7    Ŀ
;                Ŀ   stav 2,3,4      (1 bit)       stav 5   
;                 dlka = 2       Ŀ
;                 Ŀ dlka = 6 a 9     
;                              dlka = 3,4,5    (1 bajt)
;                                          Ŀ
;                                                         dlka 10 a 265 
;      dlka = 265                                        
;   < 
;                                      
;          
;                 (1 bit)  Ŀ
;                             (3 bity)
;                Ŀ        Ŀ
;                 1  0   Ŀ   (1 bit)
;                  stav 0, 1       Ŀ
;                      Ŀ  
;                           Ŀ stav 4 a 7   
;                           HIGH = 1,2  
;             Ŀ   Ŀ  
;              HIGH = 0               HIGH = 3 a 6(1 bit)
;                             Ŀ
;    Ŀ                              Ŀ 
;     dlka = 2                               stav 10h a 16h 
;     HIGH  = 0                                
;                                  Ŀ 
;                                              HIGH = 7 a 0dh 
;                                               
;                                                            (1 bit)
;                                                               
;                                                       Ŀ
;                                                       HIGH=0eh a 1fh
;                                                       
;          
;                               
;                     (1 bajt) = offset LOW
;                               
;                     Ŀ
;                      opakovn etzce 
;                     
; konec
;
; -----------------------------------------------------------------------------
;
Komprim  PROC      NEAR

; ------ inicializace tabulky odkaz

         push      es
         mov       es,ds:[Inx0Segm]
         xor       di,di
         mov       ax,-1                    ; inicializan slovo
         mov       cx,8000h                 ; dlka tabulky (slov)
         cld
         rep       stosw                    ; vymazn tabulky
         pop       es

; ------ zpis identifiktoru souboru do bufferu

         mov       si,offset LCOMBeg
         mov       cx,offset(LCOMEnd-LCOMBeg)
         push      es
         push      ds
         mov       ds:[OutNum],cx
         mov       es,ds:[OutSegm]
         push      cs
         pop       ds
         xor       di,di
         cld
         rep       movsb
         pop       ds
         pop       es

; ------ inicializace ukazatel

         xor       si,si                    ; ukazatel dat v bufferu

; ------ inicializace buffer pro dal blok

Kompr1:  push      si
         mov       si,ds:[BuffOld]          ; star konec v bufferu
         mov       cx,4000h                 ; dlka dat k inicializaci
         call      InitInd                  ; inicializace buffer komprese
         add       ds:[BuffOld],cx          ; posun adresy bufferu
         cmp       cx,4000h                 ; byl cel blok ?
         jb        Kompr13                  ; nebyl cel blok
         sub       cx,1f0h                  ; rezerva v bufferu
Kompr13: add       si,cx                    ; konec dat v bufferu
         mov       ds:[BuffEnd],si          ; konec dat v bufferu
         pop       si

; ------ nalezen shodnho etzce

Kompr2:
         cmp       word ptr ds:[soub0s],4
         jne       kompr23t
         cmp       si,0cb70h
         jb        kompr23t
tst:     nop
kompr23t:


         cmp       si,ds:[BuffOld]
         js        Kompr24
         jmp       Kompr7

Kompr24:
Kompr23: call      FindStr                  ; nalezen etzce

; ------ test, zda se bude hledat vhodnj etzec

Kompr232:cmp       cx,2                     ; dlka 2 znaky ?
         jb        Kompr25                  ; etzec nenalezen

; ------ pokus o nalezen vhodnjho etzce

Kompr242:mov       bx,cx                    ; schova dlky
         mov       dx,ax                    ; schova offsetu
         inc       si                       ; zven adresy

Kompr24a:call      FindStr                  ; pokus o nalezen dalho etzce

         cmp       cx,bx                    ; je del ?
         jbe       Kompr247                 ; nen del
         inc       bx                       ; star etzec + 1
         cmp       cx,bx                    ; je del o 1 bajt ?
         ja        Kompr243                 ; je del o vce ne 1 bajt

         cmp       dx,128                   ; je bli ne 128 znak ?
         jbe       Kompr246                 ; byl bli - nevyplat se

; ------ zpis rozdlnho znaku

Kompr243:push      ax
         push      cx

         push      ds
         mov       ds,ds:[InpSegm]
         mov       al,ds:[si-1]             ; rozdln znak
         pop       ds
         mov       cx,1                     ; zpis 1 znaku
         call      WritStr

         pop       cx
         pop       ax

         cmp       si,ds:[BuffEnd]
         jns       Kompr26
         jmp       short Kompr232

; ------ nvrat pvodnho nalezenho etzce

Kompr246:dec       bx
Kompr247:mov       cx,bx
         mov       ax,dx
         dec       si

; ------ vysln etzce

Kompr25: add       si,cx                    ; zven adresy v bufferu
         jnc       Kompr252
         inc       word ptr ds:[Soub0S]     ; citac dat HIGH
Kompr252:call      WritStr                  ; vysln etzce


         sub       ds:[DispCit],cx          ; ta k zobrazen
         jnc       Kompr255

         call      DispProc                 ; zobrazeni procent


         mov       word ptr ds:[DispCit],800h


Kompr255:
         cmp       si,ds:[BuffEnd]
         jns       Kompr26

         jmp       Kompr2

Kompr26:
         cmp       si,ds:[BuffOld]
         jns       Kompr7                   ; je konec souboru

         jmp       Kompr1

; ------ vysln kdu pro ukonen souboru

Kompr7:
         mov       ax,ds:[MAXLKOD]          ; data kdu
         mov       cl,ds:[MAXLLEN]          ; dlka kdu
         call      WritBit                  ; vysln kdu pro ukonen
         mov       al,0ffh                  ; kd pro ukonen
         mov       bx,ds:[BitNum]           ; poet bajt v bufferu
         mov       ds:[bx+BitBuff],al       ; uloen kdu do bufferu
         inc       word ptr ds:[BitNum]     ; zven tae bajt v bufferu

; ------ vyprzdnn vyrovnvacho bufferu

         call      WritBBuf                 ; vyprzdnn vyrovnvacho bufferu

Komp9:
         ret

Komprim  ENDP

; -----------------------------------------------------------------------------
;        zobrazeni procent operace
; -----------------------------------------------------------------------------

DispProc PROC      NEAR

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

         mov       ax,si
         mov       dx,ds:[Soub0S]           ; velikost zpracovane casti

         mov       bx,word ptr ds:[Soub1S+2]
         mov       cx,word ptr ds:[Soub1S]  ; velikost souboru

DispPrc1:mov       si,dx
         or        bx,bx
         jz        DispPrc2
         shr       dx,1
         rcr       ax,1
         shr       bx,1
         rcr       cx,1
         jmp       short DispPrc1

DispPrc2:mov       bx,100
         mul       bx
         jcxz      Kompr253
         div       cx
         mov       cl,10
         div       cl
         add       ax,"00"
         mov       word ptr ds:[TextNum+1],ax

Kompr253:mov       si,offset TextNum
         call      DispTxt
         sti
         mov       ah,0bh
         int       21h

         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

DispProc ENDP

; -----------------------------------------------------------------------------
;         Zalenn seku vstupnho bufferu do tabulky index
; -----------------------------------------------------------------------------
; VSTUP: SI=zatek dat v kruhovm bufferu (buffer nesmi presahnout prelom)
;        CX=poet bajt v kruhovm bufferu k naten a inicializaci
;        DS=datov segment
; VSTUP:CX=poet natench bajt ze souboru (CX=0 konec souboru)
; -----------------------------------------------------------------------------

InitInd  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      dx
         push      si
         push      di
         push      bp
         push      ds
         push      es

; ------ vyjmut starch etzc z tabulky inicializanch index

         mov       es,ds:[Inx0Segm]         ; tabulka inicializanch index
         xor       di,di                    ; offset v tabulce index
         mov       bx,-1                    ; nulovac slovo
InitIn01:mov       ax,es:[di]               ; index z tabulky
         sub       ax,si                    ; offset od etzce
         cmp       ax,cx                    ; je v nov tabulce ?
         jae       InitIn02                 ; nen v tabulce
         mov       es:[di],bx               ; zruen indexu
InitIn02:inc       di
         inc       di                       ; zven ukazatele v tabulce
         jnz       InitIn01                 ; dal index v tabulce

;; ------ vyjmut starch etzc z tabulky index
;
;         mov       es,ds:[InxSegm]          ; tabulka index
;InitIn05:mov       ax,es:[di]               ; index z tabulky
;         sub       ax,si                    ; offset od etzce
;         cmp       ax,cx                    ; je v nov tabulce ?
;         jae       InitIn06                 ; nen v tabulce
;         mov       es:[di],bx               ; zruen indexu
;InitIn06:inc       di
;         inc       di                       ; zven ukazatele v tabulce
;         jnz       InitIn05                 ; dal index v tabulce

; ------ naten bloku dat ze souboru

         mov       bx,ds:[Soub1I]           ; identifiktor souboru
         mov       ds,ds:[InpSegm]          ; DS <- vstupn buffer
         mov       dx,si                    ; adresa k naten dat
         mov       ah,3fh
         int       21h                      ; naten bloku dat ze souboru
         jnc       InitInd0                 ; operace OK
         xor       ax,ax                    ; nenatena dn data
InitInd0:add       dx,cx                    ; adresa za natenmi daty
         mov       cx,ax                    ; poet natench bajt dat
         jcxz      InitInd3                 ; nejsou ji dal data

; ------ naten nsledujcho bajtu ze souboru

         push      cx
         mov       cx,1                     ; 1 bajt k naten
         mov       ah,3fh
         int       21h                      ; naten ptho bajtu
         jc        InitIn03                 ; chyba
         cmp       ax,cx                    ; byl bajt naten ?
         jne       InitIn03                 ; nebyl naten dn bajt
         mov       dx,0ffffh                ; offset LOW = - 1
         mov       cx,dx                    ; offset HIGH = -1
         mov       ax,4201h
         int       21h                      ; ukazatel o 1 bajt zpt
InitIn03:pop       cx

; ------ zalenn etzc do tabulky

         mov       dx,cs:[Inx0Segm]         ; segment inicializanch index
         mov       bp,cs:[InxSegm]          ; segment index
         cld
         mov       di,si                    ; adresa ve vstupnm bufferu
         shl       di,1                     ; ukazatel v tabulce index

         push      cx

InitInd1:mov       ax,si                    ; adresa etzce
         mov       es,dx                    ; segment inicializanch index

         mov       bl,ds:[si]               ; 1. bajt dat
         inc       si                       ; zven ukazatele v bufferu
         mov       bh,ds:[si]               ; 2.bajt dat
         shl       bx,1                     ; offset v inicial. tabulce index
         or        si,si                    ; je pelom bufferu ?
         jz        InitInd5                 ; je pelom bufferu

         xchg      ax,es:[bx]               ; uloen adresy

InitInd2:mov       es,bp                    ; segment index
         stosw                              ; adresa dalho etzce
         loop      InitInd1                 ; dal bajt

         pop       cx

; ------ nvrat registr

InitInd3:pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         pop       dx
         pop       bx
         pop       ax
         ret

InitInd  ENDP

; ------ je adresa 0ffffh - obejt tto adresy

InitInd5:mov       ax,es:[bx]               ; plat star adresa
         jmp       short InitInd2

; -----------------------------------------------------------------------------
;        hledn etzce v kruhovm bufferu
; -----------------------------------------------------------------------------
; VSTUP: SI=adresa hledanho etzce v bufferu
;        DS=datov segment
; VSTUP:CX=dlka shody (1=nenalezen)
;        AX=zporn offset od hledanho etzce (nebo AL=znak, nen-li nalezen)
; -----------------------------------------------------------------------------

FindStr  PROC      NEAR

; ------ schova registr

         push      bx
         push      dx
         push      si
         push      di
         push      bp
         push      ds
         push      es

; ------ pprava registr

;         mov       ds:[AdrStr],si           ; pednastaven adresy etzce
         mov       ds,ds:[InpSegm]          ; adresa vstupnho bufferu
         mov       bp,1                     ; pednastaven dlky

; ------ pprava dlky etzce

         mov       cx,cs:[BuffOld]          ; konec natench dat v bufferu
         sub       cx,si                    ; dlka zbytku dat
         cmp       cx,cs:[MaxDel]           ; je dlka etzce OK ?
         jae       FindSt01                 ; dlka etzce je OK
         mov       cs:[MaxDel],cx           ; omezen dlky etzce
         sub       cx,1
         jnc       FindSt02
         xor       cx,cx
FindSt02:mov       cs:[MaxDel0],cx
FindSt01:cld

; ------ stanoven adresy navazujcho etzce

         lodsb                              ; 1. bajt se nekontroluje
         mov       di,si                    ; vchoz adresa pro hledn
FindStr1:shl       di,1                     ; offset v tabulce index
         mov       es,cs:[InxSegm]          ; segment index
         mov       di,es:[di-2]             ; adresa nsledujcho etzce
         inc       di                       ; je konec ?
         jz        FindStr9                 ; je konec
         mov       dx,si                    ; adresa etzce + 1
         sub       dx,di                    ; offset od etzce
         cmp       dx,MAXOFFS               ; je ji konec ?
         ja        FindStr9                 ; je ji konec

; ------ porovnn etzce

         mov       ah,ds:[si+bp-2]
         cmp       ah,ds:[di+bp-2]
         jne       FindStr1

         push      si
         push      di
         push      ds
         pop       es
         mov       cx,cs:[MaxDel0]          ; dlka k porovnn

;         inc       cx
;         dec       si
;         dec       di

         repe      cmpsb                    ; porovnn etzc
         pop       di
         pop       si

; ------ vyhodnocen vsledku porovnn

         je        FindStr4                 ; etzce jsou cel shodn
         sub       cx,cs:[MaxDel0]          ; dlka shody etzce
         neg       cx
         cmp       cx,bp                    ; je del etzec ?
         jbe       FindStr1                 ; nen del - dal
         dec       di                       ; adresa etzce
         mov       cs:[AdrStr],di           ; adresa etzce
         mov       bp,cx                    ; dlka etzce
         inc       di
         jmp       short FindStr1           ; hledn dalho etzce

; ------ etzce jsou cel shodn - nen dal hledn

FindStr4:mov       bp,cs:[MaxDel]           ; dlka shody etzce
         dec       di                       ; adresa zatku etzce
         mov       cs:[AdrStr],di           ; schova adresy etzce
         jmp       short FindStr9           ; konec hledn

; ------ nvrat registr

FindStr9:dec       si                       ; nvrat adresy etzce
         mov       cx,bp                    ; dlka nalezenho etzce
         cmp       cx,2                     ; etzec nalezen ?
         jb        FindStrC                 ; dlka = 1
         ja        FindStrB

; ------ dlka 2 - offset >= 100h se ji nevyplat

         mov       ax,si
         sub       ax,cs:[AdrStr]
         cmp       ax,100h
         jb        FindStrA

; ------ etzec nenalezen

FindStrC:mov       cx,1
         mov       al,ds:[si]               ; prvn znak etzce
         jmp       short FindStrA

; ------ offset nalezenho etzce

FindStrB:mov       ax,si                    ; adresa hledanho etzce
         sub       ax,cs:[AdrStr]

FindStrA:
         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         pop       dx
         pop       bx
         ret

FindStr  ENDP

; -----------------------------------------------------------------------------
;        zpis etzce do vyrovnvacho bufferu
; -----------------------------------------------------------------------------
; VSTUP: AX=offset etzce nebo AL=znak (offset je zporn 0e000h a 0ffffh)
;        CX=dlka etzce (bajt)
; -----------------------------------------------------------------------------

WritStr  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      si

         mov       dx,ax                    ; offset etzce nebo znak k zpisu
         mov       si,cx                    ; dlka etzce

; ------ zpis bajtu beze zmny

         xor       ax,ax                    ; zape se bit "0"
         cmp       cx,1                     ; dlka etzce 1 bajt ?
         je        WritStr7                 ; zpis bajtu beze zmny
         mov       bx,cx                    ; schova dlky etzce

; ------ zpis kdu pro dlouh etzec

         cmp       bx,MAXLENX               ; je dlouh etzec ?
         jb        WritStr2                 ; nen dlouh etzec
         mov       ax,ds:[MAXLKOD]          ; kd etzce
         mov       cl,ds:[MAXLLEN]          ; dlka kdu
         call      WritBit                  ; vysln kdu pro nastaven dlky
         mov       al,bl                    ; dlka etzce
         sub       al,MAXLENX               ; offset od maximln dlky
         mov       bx,ds:[BitNum]           ; poet bajt v bufferu
         mov       ds:[bx+BitBuff],al       ; uloen dlky do bufferu
         inc       word ptr ds:[BitNum]     ; zven tae bajt v bufferu
         jmp       short WritStr5

; ------ zpis kdu dlky

WritStr2:mov       cl,ds:[bx+TabLKod-2]     ; poet bit k vysln
         shl       bx,1                     ; dlka * 2
         mov       ax,ds:[bx+TabDKod-4]     ; data k vysln
         call      WritBit                  ; vysln kdu pro nastaven dlky

; ------ zpis offsetu etzce HIGH

WritStr5:cmp       si,2                     ; byla dlka 2 ?
         je        WritStr9                 ; je dlka 2 bajty (2 bity)
         mov       bh,0
         mov       bl,dh                    ; offset etzce HIGH
         mov       al,ds:[bx+TabODKod]      ; bity k zpisu
         mov       cl,ds:[bx+TabOLKod]      ; poet bit k zpisu
         mov       ah,0
WritStr7:call      WritBit                  ; zpis kdu do stavovho slova

; ------ uloen offsetu etzce LOW nebo znaku do bufferu

WritStr9:mov       bx,ds:[BitNum]           ; poet bajt v bufferu
         mov       ds:[bx+BitBuff],dl       ; uloen offsetu LOW nebo znaku
         inc       word ptr ds:[BitNum]     ; zven tae bajt v bufferu

; ------ nvrat registr

         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

WritStr  ENDP

; -----------------------------------------------------------------------------
;        zpis skupiny bit do pznakovho slova
; -----------------------------------------------------------------------------
; VSTUP: AX=data k zpisu
;        CL=poet bit k zpisu
; -----------------------------------------------------------------------------

WritBit  PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx

; ------ pprava registr

         mov       bx,ax                    ; schova dat k zpisu
         mov       ch,cl                    ; schova potu bit k zpisu

; ------ uloen ni sti bit do stavovho slova

         mov       cl,ds:[BitBit]           ; poet bit ve stavovm slov
         shl       ax,cl                    ; rotace dat na pozici
         or        word ptr ds:[BitBuff],ax ; zpis bit do bufferu
         add       cl,ch                    ; zven potu bit ve slov

; ------ test, zda byly zapsny vechny bity

         cmp       cl,16                    ; je peteen potu bit ?
         jbe       WritBit7                 ; poet bit je OK

; ------ vyprzdnn vyrovnvacho bufferu

         call      WritBBuf                 ; vyprzdnn vyrovnvacho bufferu

; ------ zpis zbylch bit dat

         sub       cl,16                    ; poet neuloench bit
         xchg      ch,cl
         sub       cl,ch                    ; poet ji uloench bit
         shr       bx,cl                    ; vyputn ji uloench bit
         mov       word ptr ds:[BitBuff],bx ; uloen zbylch bit
         mov       cl,ch                    ; CL <- poet zbylch bit

; ------ nov poet bit v bufferu

WritBit7:mov       ds:[BitBit],cl           ; nov poet bit v bufferu

; ------ nvrat registr

         pop       cx
         pop       bx
         pop       ax
         ret

WritBit  ENDP

; -----------------------------------------------------------------------------
;        zakdovn vstupnho bufferu ped zpisem do souboru
; -----------------------------------------------------------------------------

Zakod    PROC      NEAR

; ------ schova registr

         push      ax
         push      bx
         push      cx
         push      dx
         push      di
         push      es

; ------ test, zda se m buffer zakdovat

         test      byte ptr ds:[LCOMPrep],4 ; je zadno heslo ?
         jz        Zakod9                   ; nen zadno heslo
         mov       dx,ds:[OutNum]           ; poet bajt v bufferu
         or        dx,dx
         jz        Zakod9                   ; nejsou dn data

; ------ ukazatel v kdovacm kli

         mov       ax,word ptr ds:[Soub2S]
         xor       bx,bx
         mov       bl,al                    ; fze v kdovac tabulce
         mov       es,ds:[OutSegm]          ; vstupn buffer
         xor       di,di                    ; ukazatel dat v bufferu
         cld

; ------ korekce pro potek souboru

         cmp       word ptr ds:[Soub2S+2],0
         jne       Zakod2                   ; nen zatek souboru
         or        ax,ax
         jnz       Zakod2
         mov       di,offset(LCOMEnd-LCOMBeg)
         sub       dx,offset(LCOMEnd-LCOMBeg)
         jbe       Zakod9
         mov       bl,offset(LCOMEnd-LCOMBeg)

; ------ zakdovn dat

Zakod2:  mov       cx,word ptr ds:[bx+Klic]
         mov       al,es:[di]               ; bajt k zakdovn
         and       cl,7
         rol       al,cl
         xor       al,ch                    ; zakdovn bajtu
         stosb
         inc       bl
         dec       dx
         jnz       Zakod2                   ; dal bajt dat

; ------ nvrat registr

Zakod9:  pop       es
         pop       di
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

Zakod    ENDP

; -----------------------------------------------------------------------------
;        vyprzdnn vyrovnvacho bitovho bufferu
; -----------------------------------------------------------------------------

WritBBuf PROC      NEAR

; ------ schova registr

         push      cx
         push      si
         push      di
         push      es

; ------ vyprazdneni bufferu

         mov       cx,ds:[OutNum]
         cmp       cx,0fe00h
         jb        WritBBf2

         call      Zakod                    ; zakdovn bufferu ped zpisem

         push      ax
         push      bx
         push      dx
         push      ds

         add       word ptr ds:[Soub2S],cx
         adc       word ptr ds:[Soub2S+2],0

         xor       dx,dx
         mov       bx,ds:[Soub2I]
         mov       ds,ds:[OutSegm]
         mov       ah,40h
         int       21h

         jnc       WritBBf1
         cmp       ax,cx
WritBBf1:pop       ds
         pop       dx
         pop       bx
         pop       ax
         mov       word ptr ds:[OutNum],0
         jnc       WritBBf2

         mov       si,offset WritTxt
         jmp       Chyba

; ------ zven potu bajt ve vstupnm bufferu, kontrola peteen

WritBBf2:mov       cx,ds:[BitNum]           ; poet bajt ve vyrovnvacm buff.
         mov       di,ds:[OutNum]           ; poet bajt ve vstupnm bufferu
         add       word ptr ds:[OutNum],cx  ; zven potu bajt ve vstup.buf.
         jc        WritBBf9                 ; chyba - peteen bufferu

; ------ pesun dat do bufferu

         cld
         mov       si,offset BitBuff        ; vyrovnvac buffer
         mov       es,ds:[OutSegm]          ; vstupn buffer
         shr       cx,1                     ; pevod dlky na slova
         rep       movsw                    ; pesun dat do bufferu
         adc       cx,cx                    ; lich bit
         rep       movsb                    ; penos lichho bitu

; ------ inicializace vyrovnvacho bufferu

         mov       word ptr ds:[BitNum],2   ; poet slov v bufferu

; ------ nvrat registr

WritBBf3:pop       es
         pop       di
         pop       si
         pop       cx
         ret

WritBBuf ENDP

WritBBf9:mov       si,offset ConvTxt
         jmp       Chyba                     ; chyba - nelze zkomprimovat

; -----------------------------------------------------------------------------
;        zobrazen textu SI
; -----------------------------------------------------------------------------

DispTxt  PROC      NEAR

         push      ax
         push      dx

         mov       dx,si
         mov       ah,9
         int       21h

         pop       dx
         pop       ax
         ret

DispTxt  ENDP

; -----------------------------------------------------------------------------
;        zobrazen textu ASCIIZ
; -----------------------------------------------------------------------------

DispTxt0 PROC      NEAR

         push      ax
         push      dx
         push      si

DispTx01:cld
         lodsb
         cmp       al,0
         je        DispTx02
         mov       dl,al
         mov       ah,2
         int       21h
         jmp       short DispTx01

DispTx02:pop       si
         pop       dx
         pop       ax
         ret

DispTxt0 ENDP

; -----------------------------------------------------------------------------
;        zobrazen znaku DOS
; -----------------------------------------------------------------------------

DispCh   PROC      NEAR

         push      ax
         push      dx
         mov       dl,al
         mov       ah,2
         int       21h
         pop       dx
         pop       ax
         ret

DispCh   ENDP

; -----------------------------------------------------------------------------
;        zadn hesla
; -----------------------------------------------------------------------------

ZadHesl  PROC      NEAR

; ------ test, zda m bt heslo zadno

         test      byte ptr ds:[LCOMPrep],4 ; m bt heslo zadno ?
         jz        ZadHesl9                 ; nem bt zadno
         cmp       byte ptr ds:[HesloN],0   ; je ji heslo zadno ?
         jnz       ZadHesl2                 ; heslo je ji zadno

; ------ zobrazen vzvy k zadn hesla

         mov       si,offset HesloTxt
         call      DispTxt                  ; vzva k zadn hesla

; ------ zadn textu hesla

         mov       dx,offset HesloBuf       ; buffer k zadn hesla
         mov       ah,0ah
         int       21h                      ; zadn textu hesla

; ------ vymazn dku s heslem

         mov       al,13
         call      DispCh                   ; nvrat na zatek dku
         mov       cx,78                    ; poet znak k vymazn
         mov       al," "
ZadHesl1:call      DispCh                   ; vymazn znaku
         loop      ZadHesl1
         mov       al,13
         call      DispCh

; ------ stanoven dlky textu a konverze na velk psmena

ZadHesl2:xor       bx,bx                    ; ukazatel v bufferu
ZadHesl3:cmp       bl,ds:[HesloN]           ; jsou ji vechny znaky ?
         jae       ZadHesl4                 ; jsou ji vechny znaky
         mov       al,ds:[bx+Heslo]         ; znak z bufferu
         cmp       al,13
         je        ZadHesl4                 ; konec textu
         call      UpCase                   ; konverze na velk psmeno
         mov       ds:[bx+Heslo],al         ; uloen znaku
         inc       bx                       ; zven ukazatele znak
         jmp       short ZadHesl3           ; dal znak hesla
ZadHesl4:mov       ds:[HesloN],bl           ; skuten dlka hesla

; ------ oprava, je-li dlka hesla = 0

ZadHesl5:or        bx,bx                    ; je nco zadno ?
         jnz       ZadHesl6                 ; je nco zadno OK
         and       byte ptr ds:[LCOMPrep],not 4 ; zruen pznaku zadn hesla
         jmp       short ZadHesl9

; ------ sestaven kdovacho kle

ZadHesl6:mov       cx,bx                    ; dlka textu hesla
         mov       di,offset Klic           ; kdovac kl
         mov       bx,257                   ; dlka kdovacho kle
         mov       dx,-1                    ; vchoz hodnota kdu

; ------ vpoet kdovacho kle

ZadHesl7:mov       si,offset Heslo          ; buffer s textem hesla
         call      CheckSum                 ; kontroln souet kle
         mov       ds:[di],dl               ; ni bajt kontrolnho soutu
         inc       di                       ; zven ukldac adresy v kli
         dec       bx                       ; ta dlky kle
         jnz       ZadHesl7                 ; dal znak kle

ZadHesl9:
         ret

ZadHesl  ENDP

; -----------------------------------------------------------------------------
;        rozbor zadn parametr (CY=chyba zadn)
; -----------------------------------------------------------------------------

RozbPar  PROC      NEAR

; ------ vstup znaku pznaku pepnae "/"

         call      RozbSpc                  ; vyputn mezer
         jc        RozbPar8                 ; nen nic zadno - OK
         cmp       al,"/"                   ; je pepna ?
         jne       RozbPar8                 ; nen pepna
         call      RozbChr                  ; vstup znaku "/"

; ------ vstup druhho znaku parametru

         call      RozbChr                  ; naten znaku pepnae
         jc        RozbPar9                 ; nen znak - chyba
         call      UpCase                   ; pevod na velk psmeno

; ------ parametr "/K" - kd Kamenickch

         mov       ah,0                     ; kd Kamenickch
         cmp       al,"K"                   ; je kd Kamenickch ?
         je        RozbPar2                 ; je kd Kamenickch

; ------ parametr "/L" - kd Latin 2

         mov       ah,1                     ; kd Latin 2
         cmp       al,"L"                   ; je kd Latin 2 ?
         je        RozbPar2                 ; je kd Latin 2

; ------ parametr "/I" - kd KOI 8

         mov       ah,2                     ; kd KOI 8
         cmp       al,"I"                   ; je kd KOI 8 ?
         je        RozbPar2                 ; je kd KOI 8

; ------ parametr "/B" - kd IBM, nen nrodn kd

         cmp       al,"B"                   ; je kd IBM ?
         jne       RozbPar3                 ; nen kd IBM
         mov       ah,3
RozbPar2:and       byte ptr ds:[LCOMPrep],not 3 ; nulovn bit
         or        byte ptr ds:[LCOMPrep],ah ; pznak kdu
         jmp       short RozbPar            ; dal parametr

; ------ parametr "/G" - uzamen souboru heslem

RozbPar3:cmp       al,"G"                   ; uzamen heslem ?
         jne       RozbPar4                 ; nen heslo
         or        byte ptr ds:[LCOMPrep],4 ; pznak zadn hesla
         call      RozbSpc                  ; vyputn mezer
         jc        RozbPar8                 ; nen heslo zadno
         cmp       al,'"'                   ; je text hesla ?
         jne       RozbPar                  ; nen heslo - dal parametr
         call      RozbChr                  ; zruen znaku "
         xor       bx,bx                    ; ukazatel
RozbPr32:call      RozbChr                  ; naten dalho znaku
         jc        RozbPar8                 ; konec textu
         cmp       al,'"'                   ; konec hesla ?
         je        RozbPar8                 ; konec hesla
         call      UpCase                   ; konverze na velk psmeno
         cmp       bl,40                    ; max. dlka hesla
         jae       RozbPr33                 ; buffer pln
         mov       ds:[bx+Heslo],al         ; uloen znaku do bufferu
         inc       bx                       ; zven tae znak
         mov       ds:[HesloN],bl           ; nov dlka hesla
RozbPr33:jmp       short RozbPr32


RozbPar4:

RozbPar7:stc                                ; pznak chybnho parametru
         ret

RozbPar8:clc
RozbPar9:ret

RozbPar  ENDP

; -----------------------------------------------------------------------------
;        dekdovn zadanho jmna souboru (ES:DI=buffer, CY=nezadn)
; -----------------------------------------------------------------------------

RozbFil  PROC      NEAR

; ------ nalezen zatku zadn souboru

         call      RozbSpc                  ; vyputn mezer ped jmnem
         jc        RozbFil9                 ; nen nic zadno

; ------ penesen textu a po konec jmna

RozbFil2:call      RozbChr                  ; naten dalho znaku
         jbe       RozbFil5                 ; konec dku nebo mezera
         call      UpCase                   ; pevod znaku na velk psmeno
         cld
         stosb                              ; uloen znaku do bufferu
         jmp       short RozbFil2           ; dekdovn dalho znaku

; ------ oznaen konce textu

RozbFil5:mov       byte ptr es:[di],0       ; ukonovac 0
         clc                                ; pznak operace OK

RozbFil9:ret

RozbFil  ENDP

; -----------------------------------------------------------------------------
;        vyputn mezer z pkazovho dku SI (CY=konec, AL=pipraven znak)
; -----------------------------------------------------------------------------

RozbSpc  PROC      NEAR

         call      RozbChr                  ; naten znaku z pkazovho dku
         jc        RozbSpc3                 ; je konec pkazovho dku
         je        RozbSpc                  ; je mezera - dal znak
         dec       si                       ; jinak nvrat poslednho znaku
RozbSpc3:ret

RozbSpc  ENDP

; -----------------------------------------------------------------------------
;        vstup znaku z pkazovho dku SI (CY=nen dal, AL=znak)
; -----------------------------------------------------------------------------

RozbChr  PROC      NEAR

         push      ds

; ------ vstup znaku z pkazovho dku

         mov       ds,ds:[SegPSP]           ; segment PSP
         cld
         lodsb                              ; naten znaku z pkazovho dku

; ------ nhrada tabeltoru mezerou

         cmp       al,9                     ; je tabeltor ?
         jne       RozbChr2                 ; nen tabeltor
         mov       al," "                   ; nhrada tabeltoru mezerou

; ------ test, zda je platn znak

RozbChr2:cmp       al," "                   ; je platn znak ?
         jae       RozbChr3                 ; je platn znak
         dec       si                       ; nvrat ukazatele pi konci dku

RozbChr3:pop       ds
         ret

RozbChr  ENDP

; -----------------------------------------------------------------------------
;        pevod znaku na velk psmeno
; -----------------------------------------------------------------------------

UpCase   PROC      NEAR

         cmp       al,"a"
         jb        UpCase2
         cmp       al,"z"
         ja        UpCase2
         sub       al,32
UpCase2: ret

UpCase   ENDP

; -----------------------------------------------------------------------------
;        Kontroln souet CRC bloku dat
; -----------------------------------------------------------------------------
; VSTUP: DS:SI=zatek bloku dat
;        CX=poet bajt
;        DX=vstupn hodnota kontrolnho soutu
; VSTUP:DX=vstupn hodnota kontrolnho soutu
; -----------------------------------------------------------------------------

CheckSum PROC      NEAR

         push      ax
         push      cx
         push      di
         jcxz      CheckSm2                 ; nejsou dn data
         mov       di,cx                    ; poet bajt pro kontroln souet
         cld                                ; smr nahoru

CheckSm1:lodsb                              ; a = fgetc(fp);
         xor       al,dh                    ; d = a ^= d;
         mov       dh,al
         mov       cl,4
         shr       al,cl                    ; a >>= 4;
         xor       al,dh                    ; d = a ^= d;
         mov       dh,al
         mov       cl,3
         ror       al,cl                    ; a = (a >> 3) | (a << 5);
         mov       ch,al                    ; f = a;
         and       al,1fh                   ; a &= 0x1f;
         xor       al,dl                    ; e = a ^= e;
         mov       dl,al
         mov       al,ch                    ; a = f;
         ror       al,1                     ; a = (a >> 1) | (a << 7);
         and       al,0f0h                  ; a &= 0xf0;
         xor       al,dl                    ; e = a ^= e;
         mov       dl,al
         mov       al,ch                    ; a = f & 0xe0;
         and       al,0e0h
         xor       al,dh                    ; a ^= d;
         mov       dh,dl                    ; d = e;
         mov       dl,al                    ; e = a;

         dec       di
         jnz       CheckSm1                 ; dal bajt

CheckSm2:pop       di
         pop       cx
         pop       ax
         ret

CheckSum ENDP


; 
;
;                              Identifiktor souboru
;
; 

         EVEN

LCOMBeg  LABEL     NEAR

         db        27,'XCD'                 ; identifiktor souboru
LCOMPrep dw        0                        ; pepnae
                                            ;  bit 0,1: 0=kd Kamenickych
                                            ;           1=kd Latin 2
                                            ;           2=kd KOI 8
                                            ;           3=kd IBM
                                            ;  bit 2: 1=zadno heslo

         EVEN                               ; sud dlka !

LCOMEnd  LABEL     NEAR


; 
;
;                                  Data
;
; 

; ------ hlen programu

UvTxt    db        'HLPGEN V1.50 - generovani souboru napovedy HLP; (c) Miroslav Nemecek',13,10,'$'
HelpTxt  db        'Zadejte jmeno vstupniho i vystupniho souboru !',13,10
         db        'Prepinace: /K ... soubor v kodu Kamenickych (implicitne)',13,10
         db        '           /L ... soubor v kodu Latin 2',13,10
         db        '           /I ... soubor v kodu KOI 8',13,10
         db        '           /B ... soubor v kodu IBM (=neni narodni kod)',13,10
         db        '           /G ["heslo"] ... uzamceni souboru heslem',13,10
         db        '$'

Soub1Txt db        'Chybne zadani vstupniho souboru !',13,10,'$'
Soub2Txt db        'Chybne zadani vystupniho souboru !',13,10,'$'

ReadTxt  db        'Chyba cteni ze vstupniho souboru !',13,10,'$'
WritTxt  db        'Chyba zapisu do vystupniho souboru !',13,10,'$'

CRTxt    db        13,10,'$'

ConvTxt  db        'Soubor nelze zkonvertovat !',13,10,'$'

ExisTxt1 db        'Soubor $'
ExisTxt2 db        ' jiz existuje !',13,10,'Chete jej prepsat (A=ano) ? $'

TextSpc  db        '     ',8,8,8,8,8,'$'
TextNum  db        '(00%)',8,8,8,8,8,'$'

TextComp db        'Konvertuji soubor $'

HesloBuf db        41                       ; buffer pro zadn textu hesla
HesloN   db        0                        ; dlka hesla
Heslo    db        41 dup(0)                ; text hesla

HesloTxt db        'Zadejte text hesla (max. 40 znaku): $'

; ------ tabulky pro vysln dlek etzce

                                          ;* tabulka dlek kd
TabLKod  db        3,3                      ; 2,3
         db        4,4                      ; 4,5
         db        5                        ; 6
         db        6,6                      ; 7,8
         db        7,7                      ; 9,10
         db        8,8                      ; 11,12
         db        9,9                      ; 13,14
         db        10,10                    ; 15,16
         db        11,11                    ; 17,18
         db        12,12                    ; 19,20
         db        13,13,13,13              ; 21,22,23,24

MAXLLEN  db        5                        ; 25 a vce

                                          ;* tabulka dat kd
TabDKod  dw        001,011b                   ; 2,3
         dw        0101b,0111b                ; 4,5
         dw        01101b                     ; 6
         dw        011101b,011111b            ; 7,8
         dw        0111101b,0111111b          ; 9,10
         dw        01111101b,01111111b        ; 11,12
         dw        011111101b,011111111b      ; 13,14
         dw        0111111101b,0111111111b    ; 15,16
         dw        01111111101b,01111111111b  ; 17,18
         dw        011111111101b,011111111111b ; 19,20
         dw        0111111111101b,0111111111111b,1111111111101b,1111111111111b ; 21,22,23,24

MAXLKOD  dw        01111b                   ; 25 a vce

; ------ tabulky pro vysln offsetu etzce

                                          ;* tabulka potu bit k zpisu
TabOLKod            db     1                ; 0
                    db     4,4              ; 1,2
                    db     5,5,5,5          ; 3,4,5,6
                    db     6,6,6,6,6,6,6    ; 7,8,9,0ah,0bh,0ch,0dh
                    db     7,7,7,7,7,7      ; 0eh a 1fh
                    db     7,7,7,7,7,7
                    db     7,7,7,7,7,7

                                          ;* tabulka bit k zpisu
TabODKod            db     1                ; 0
                    db     0,8              ; 1,2
                    db     4,14h,0ch,1ch    ; 3,4,5,6
                    db     2,22h,12h,32h,0ah,2ah,1ah ; 7,8,9,0ah,0bh,0ch,0dh
                    db     3ah,7ah,6,46h,26h,66h ; 0eh a 1fh
                    db     16h,56h,36h,76h,0eh,4eh
                    db     2eh,6eh,1eh,5eh,3eh,7eh


SegPSP   dw        0                        ; adresa PSP

FilDate  dw        0                        ; datum souboru
FilTime  dw        0                        ; as souboru
FilAtr   dw        0                        ; atributy souboru

InxSegm  dw        SEG InxSeg               ; segment indexov tabulky
Inx0Segm dw        SEG Inx0Seg              ; segment inicializanch index

InpSegm  dw        SEG InpSeg               ; vstupn segment
;InpNum   dw        0                        ; poet bajt ve vstupnm bufferu

OutSegm  dw        SEG OutSeg               ; vstupn segment
OutNum   dw        3                        ; poet bajt ve vstupnm bufferu

; ------ komprimace

BitBit   db        0                        ; poet bit ve stavovm slov
BitNum   dw        2                        ; poet bajt ve vyrovnvacm buff.
BitBuff  db        100 dup(0)               ; vyrovnvac vstupn buffer

AdrStr   dw        0                        ; adresa nalezenho etzce
MaxDel0  dw        MAXLEN-1                 ; max. dlka etzce - 1
MaxDel   dw        MAXLEN                   ; max. dlka etzce

BuffEnd  dw        0                        ; adresa konce dat v bufferu
BuffOld  dw        0                        ; star zatek bufferu

DispCit  dw        0                        ; ta k zobrazen procent

Soub1S   dd        0                        ; velikost vstupnho souboru
Soub0S   dw        0                        ; citac zpracovane casti HIGH

Soub2S   dd        0                        ; velikost vstupnho souboru

Klic     db        257 dup(?)               ; kdovac kl hesla

; ------ soubory

Soub1    db        128 dup(?)               ; jmno vstupnho souboru
Soub1I   dw        ?                        ; identifiktor vstupnho souboru

Soub2    db        128 dup(?)               ; jmno vstupnho souboru
Soub2I   dw        ?                        ; identifiktor vstupnho souboru

Code     ENDS

; 
;
;                   Tabulka inicializanch index
;
; 

Inx0Seg  SEGMENT
         db        0ffffh dup(?)            ; tabulka inicializanch index
Inx0Seg  ENDS


; 
;
;                       Tabulka index nvaznosti
;
; 

InxSeg   SEGMENT
         db        0ffffh dup(?)            ; tabulka adres nvaznosti
InxSeg   ENDS


; 
;
;                           Vstupn buffer
;
; 

InpSeg   SEGMENT
         db        0ffffh dup(?)            ; vstupn buffer
InpSeg   ENDS


; 
;
;                           Vstupn buffer
;
; 

OutSeg   SEGMENT
         db        0ffffh dup(?)            ; vstupn buffer
OutSeg   ENDS


; 
;
;                            Zsobnk
;
; 

Zasob    SEGMENT   STACK
         dw        1000h dup(?)             ; zsobnk
Zasob    ENDS

         END       Start
