
; *****************************************************************************
;
;                              A N I M V I E W
;
;                    Prohle snmk displeje formtu SCR
;
; *****************************************************************************

BuffSize EQU       2000h                    ; velikost diskovho bufferu

code     segment
         assume    cs:code,ds:code
         org       100h

                                          ;* zobrazen vodnho textu
start:   mov       dx,offset UvTxt
         mov       ah,9
         int       21h

         mov       ah,0fh
         call      Int10P
         mov       ds:[OldVMod],al

                                          ;* detekce parametr displeje
         call      DetectCard               ; detekce grafick karty
         call      DetTyp                   ; uren typu karty
         call      DetMono                  ; detekce monochromatickho displeje

                                          ;* nalezen zatku textu souboru
         mov       si,81h                   ; zatek pkazovho dku
         mov       ch,0                     ; CH <- 0
         mov       cl,ds:[80h]              ; poet znak
Start1:  jcxz      Start33                  ; chyba - nen nic zadno
         lodsb
         dec       cx
         cmp       al," "                   ; je platn znak ?
         jbe       Start1                   ; nen platn znak - dal znak
         mov       dx,si                    ; schova zatku textu
         dec       dx

                                          ;* nalezen konce textu
Start2:  jcxz      Start3                   ; konec textu
         lodsb
         dec       cx
         cmp       al," "
         ja        Start2                   ; nalezen konce textu
         dec       si                       ; nvrat poslednho znaku
Start3:  mov       byte ptr ds:[si],0       ; oznaen konce textu

                                          ;* oteven souboru
         mov       ax,3d00h                 ; funkce oteven pro ten
         int       21h                      ; oteven souboru pro ten
         jnc       Start4

Start33: jmp       Chyba                    ; chyba - soubor nenalezen

Start4:  mov       ds:[Idents],ax           ; identifiktor souboru
         mov       bx,ax                    ; identifiktor souboru

                                          ;* naten zhlav souboru
         mov       dx,offset Zahlavi        ; zhlav souboru
         mov       cx,offset(KonHl-Zahlavi) ; dlka zhlav
         mov       ah,3fh
         int       21h                      ; naten zhlav souboru
         jc        Start33                  ; chyba ten
         cmp       ax,cx                    ; souhlas poet bajt ?
         jne       Start33                  ; chyba

                                          ;* naten definice palet
         mov       dx,offset KonHl          ; buffer palet
         mov       cx,ds:[Palety]           ; poet bajt palet
         mov       ah,3fh
         int       21h                      ; naten definice palet
         jc        Start33
         cmp       ax,cx
         jne       Start33

                                          ;* kontrola sprvnosti zhlav
         cmp       word ptr ds:[Ident],"CS" ; prvn 2 znaky - SC
         jne       Start33                  ; chybn soubor
         cmp       word ptr ds:[Ident+2],1*256+"R" ; tet znak a slo verze 1
         jne       Start33                  ; chybn soubor
         cmp       byte ptr ds:[Mod],19     ; maximln videomd
         ja        Start33                  ; chybn soubor
         cmp       word ptr ds:[Rovin],8    ; poet rovin
         ja        Start33                  ; chybn soubor
         cmp       word ptr ds:[Vyska],480  ; maximln vka
         ja        Start33                  ; chybn soubor
         cmp       word ptr ds:[Sirka],640  ; maximln ka
         ja        Start33                  ; chybn soubor


         call      SetVMod                  ; nastaven poadovanho videomdu
         jc        Chyba2                   ; chyba - chybn grafick karta

                                          ;* nastaven palet VGA
         cmp       byte ptr ds:[Mod],19     ; je videomd VGA ?
         jne       Start5
         test      byte ptr ds:[Param],10h
         jz        Start5

         mov       ax,1012h
         xor       bx,bx
         mov       cx,100h
         mov       dx,offset KonHl
         push      ds
         pop       es
         int       10h                      ; nastaven palet displeje

Start5:
         call      GetMod                   ; poskytnut parametr videomdu


                                          ;* zde je ES = segment videopamti
         call      Zobraz                   ; zobrazen snmku

         mov       dl,0
         mov       dh,byte ptr ds:[MaxVys]
         mov       ah,2
         call      Int10P                   ; nastaven kurzoru mimo displej

         xor       ax,ax
         int       16h                      ; ekn na stisk klvesy

         mov       al,ds:[OldVMod]
         mov       ah,0
         call      Int10P                   ; nvrat videomdu

         cmp       byte ptr ds:[EgaVga],0   ; byla karta EGA/VGA ?
         je        Navrat                   ; nebyla karta EGA/VGA

         push      ds
         xor       ax,ax
         mov       ds,ax
         and       byte ptr ds:[487h],not 81h ; zru. pznaku hustho dkovn
         pop       ds
         mov       ah,1
         mov       cx,607h
         call      Int10P                   ; nastaven rozmr kurzoru

Navrat:  mov       ax,4c00h
         int       21h

chyba:   mov       dx,offset ErTxt
         mov       ah,9
         int       21h
chyba2:  mov       ax,4c01h
         int       21h


; *****************************************************************************
;                    Nastaven videomdu
; -----------------------------------------------------------------------------
; *****************************************************************************

SetVMod: mov       bl,ds:[TypCard]          ; typ grafick karty
         mov       al,ds:[Mod]              ; videomd displeje

                                          ;* m bt textov videomd CGA
         cmp       al,3                     ; je textov videomd CGA ?
         ja        SetVMod2                 ; nen textov videomd CGA
         or        bl,bl                    ; je grafick karta CGA ?
         jz        SetVMod8                 ; je grafick karta CGA
         cmp       bl,2                     ; je grafick karta EGA color ?
         je        SetVMod8                 ; je grafick karta EGA color
         cmp       bl,4                     ; je grafick karta VGA ?
         je        SetVMod8                 ; je grafick karta VGA
         mov       al,7                     ; nhradn videomd 7
         jmp       short SetVMod8           ; nastaven videomdu 7

                                          ;* m bt textov videomd MDA
SetVMod2:cmp       al,7                     ; je textov videomd 7 ?
         jne       SetVmod3                 ; nen textov videomd 7
         cmp       bl,1                     ; je karta MDA ?
         je        SetVMod8                 ; je karta MDA - OK
         cmp       bl,3                     ; je karta EGA mono ?
         je        SetVMod8                 ; je karta EGA - OK
         cmp       bl,4                     ; je karta VGA ?
         je        SetVMod8                 ; je karta VGA - OK
         mov       al,3                     ; nhradn videomd 3
         cmp       byte ptr ds:[Monochr],0  ; je monochromatick displej ?
         je        SetVMod8                 ; nen monochromatick displej
         mov       al,2                     ; nhradn videomd 2
         jmp       short SetVMod8           ; nastaven videomdu

                                          ;* m bt grafick videomd CGA
SetVMod3:cmp       al,7                     ; je grafick videomd CGA ?
         ja        SetVMod4                 ; nen grafick videomd CGA
         cmp       bl,1                     ; je grafick karta MDA ?
         jne       SetVMod8                 ; nen grafick karta MDA
         jmp       short SetVModa           ; videomd nelze nastavit

                                          ;* m bt grafick videomd EGA
SetVMod4:cmp       bl,2                     ; je grafick karta EGA nebo VGA ?
         jb        SetVModa                 ; nen EGA/VGA - chyba

                                          ;* nastaven videomdu AL
SetVMod8:push      ax
         mov       ah,0
         call      Int10P                   ; nastaven videomdu displeje
         mov       ah,0fh
         call      Int10P
         mov       ds:[VMod],al             ; skuten videomd
         pop       ax
         cmp       al,ds:[VMod]             ; videomd nastaven ?
         jne       SetVModa                 ; chyba nastaven videomdu

                                          ;* nastaven hustho dkovn textu
         cmp       al,7                     ; je videomd EGA ?
         ja        SetVMod9                 ; nen textov videomd
         je        SetVModb                 ; je textov videomd
         cmp       al,3                     ; je textov videomd CGA ?
         ja        SetVMod9                 ; je grafick videomd
SetVModb:cmp       byte ptr ds:[EgaVga],0   ; je grafick karta EGA/VGA ?
         je        SetVMod9                 ; nen grafick karta EGA/VGA

         cmp       word ptr ds:[Vyska],26   ; je vt poet dk ?
         cmc
         jnc       SetVMod9                 ; poet dk je OK

         mov       ax,1112h                 ; funkce naten font 8x8
         mov       bl,0                     ; fonty 0
         call      Int10P                   ; nastaven hustho dkovn

         push      ds
         xor       ax,ax
         mov       ds,ax                    ; DS <- 0
         or        byte ptr ds:[487h],1     ; pznak hustho dkovn
         pop       ds

         mov       ah,1
         mov       cx,607h
         call      Int10P                   ; nastaven standardnho kurzoru

;         push      ds
;         xor       ax,ax
;         mov       ds,ax                    ; DS <- 0
;         or        byte ptr ds:[487h],1     ; pznak hustho dkovn
;         pop       ds

         jmp       short SetVMod9

                                          ;* chyba - chybn grafick karta
SetVModa:mov       dx,offset KartTxt        ; text - chybn karta
         mov       ah,9
         int       21h                      ; zobrazen chybovho textu
         stc                                ; pznak chyby

SetVMod9:ret

; *****************************************************************************
;                Poskytnut parametr videomdu
; -----------------------------------------------------------------------------
;
; *****************************************************************************

GetMod:
                                          ;* uren segmentu videopamti
         mov       bl,ds:[Vmod]             ; nastaven videomd
         mov       ax,0b800h                ; segment CGA
         cmp       bl,7                     ; je videomd CGA ?
         jb        GetMod1                  ; je videomd CGA
         mov       ax,0b000h                ; segment MDA
         cmp       bl,13                    ; je videomd MDA ?
         jb        GetMod1                  ; je videomd MDA
         mov       ax,0a000h                ; jinak segment EGA
GetMod1: mov       es,ax                    ; segment videopamti

                                          ;* uren rozmr displeje
         mov       bh,0
         shl       bx,1
         shl       bx,1                     ; videomd * 4
         mov       ax,ds:[bx+TabMod]        ; ka displeje
         mov       ds:[MaxSir],ax           ; ka displeje
         mov       ax,ds:[bx+TabMod+2]      ; vka displeje
         mov       ds:[MaxVys],ax           ; vka displeje

         ret

; *****************************************************************************
;                  Zobrazen snmku
; -----------------------------------------------------------------------------
; *****************************************************************************

Zobraz:
         cld

; ------ zjitn dlky videostrnky

         push      ds
         xor       ax,ax
         mov       ds,ax
         mov       cx,ds:[44ch]             ; dlka videostrnky
         shr       cx,1                     ; pevod na dlku ve slovech
         pop       ds
         mov       bx,ds:[Pozadi]           ; barva pozad
         xor       di,di                    ; poten adresa
         cld


         mov       al,ds:[VMod]             ; aktuln videomd

                                          ;* rozlien textovho videomdu
         cmp       al,7
         je        Zobraz1                  ; videomd MDA
         cmp       al,3
         ja        Zobraz2                  ; nen textov videomd
Zobraz1: jmp       ZobrTxt                  ; zobrazen v textovm mdu

                                          ;* zobrazen v grafickm mdu CGA
Zobraz2: cmp       al,17                    ; grafick videomd MCGA ?
         je        Zobraz3                  ; je MCGA mono
         cmp       al,7                     ; je grafick videomd CGA ?
         jae       Zobraz4                  ; nen grafick videomd CGA
Zobraz3: jmp       ZobrCGA                  ; zobrazen grafickho mdu CGA

                                          ;* zobrazen v grafickm mdu MCGA
Zobraz4: cmp       al,19                    ; grafick videomd MCGA ?
         jne       Zobraz5                  ; nen md MCGA
         jmp       ZobrMCG                  ; zobrazen v mdu MCGA

Zobraz5: jmp       ZobrEGA                  ; zobrazen grafickho mdu EGA

; -----------------------------------------------------------------------------
;        Zobrazen snmku v textovm mdu
; -----------------------------------------------------------------------------

                                          ;* uren skutenho potu dk
ZobrTxt:
         cmp       byte ptr ds:[EgaVga],0   ; je karta EGA/VGA ?
         je        ZobrTxt1                 ; nen karta EGA/VGA

; ------ vymazn displeje

         mov       ah,bl                    ; barva
         mov       al," "                   ; mazac znak
         cld
         rep       stosw                    ; vymazn displeje

; ------ peskoen strnky masky

         push      ds
         xor       ax,ax
         mov       ds,ax                    ; DS <- 0
         mov       al,ds:[484h]             ; slo poslednho dku
         inc       ax                       ; poet dk
         pop       ds
         mov       ds:[MaxVys],ax           ; maximln vka displeje

; ------ peskoen masky

ZobrTxt1:test      byte ptr ds:[Param],8    ; je maska ?
         jz        ZobrTx6                  ; nen maska

ZobrTx1: mov       cx,ds:[Vyska]
ZobrTx2: push      cx
         mov       cx,ds:[Sirka]
ZobrTx3: call      ReadByte
         jc        ZobrTx4
         loop      ZobrTx3
ZobrTx4: pop       cx

; ------ zobrazen roviny 0 (znaky)

ZobrTx6: xor       di,di
         mov       cx,ds:[Vyska]
ZobrTxt2:push      cx
         mov       cx,ds:[Sirka]
         push      di
ZobrTxt3:call      ReadByte
         jc        ZobrTxt6
         stosb
         inc       di
         loop      ZobrTxt3
ZobrTxt6:pop       di
         pop       cx
         jc        ZobrTxt8
         add       di,ds:[MaxSir]
         add       di,ds:[MaxSir]
         loop      ZobrTxt2

; ------ zobrazen roviny 1 (atributy)

         mov       di,1
         mov       cx,ds:[Vyska]
ZobrTxt4:push      cx
         mov       cx,ds:[Sirka]
         push      di
ZobrTxt5:call      ReadByte
         jc        ZobrTxt7
         stosb
         inc       di
         loop      ZobrTxt5
ZobrTxt7:pop       di
         pop       cx
         jc        ZobrTxt8
         add       di,ds:[MaxSir]
         add       di,ds:[MaxSir]
         loop      ZobrTxt4
ZobrTxt8:
         ret

; -----------------------------------------------------------------------------
;        Zobrazen grafickho mdu CGA
; -----------------------------------------------------------------------------

ZobrCGA:

; ------- peskoen masky

ZobrCG1: test      byte ptr ds:[Param],8    ; je maska ?
         jz        ZobrCGA1                 ; nen maska

; ------ vymazn displeje

         cld
         mov       al,bl                    ; barva
         mov       ah,bl                    ; barva
         and       ah,3
         shl       al,1
         shl       al,1
         or        al,ah
         shl       al,1
         shl       al,1
         or        al,ah
         shl       al,1
         shl       al,1
         or        al,ah                    ; barva
         cmp       byte ptr ds:[Mod],6
         jb        ZobrCG11
         test      al,1
         mov       al,0
         jz        ZobrCG11
         mov       al,0ffh
ZobrCG11:mov       ah,al                    ; barva
         rep       stosw


         cld
         mov       cx,ds:[Vyska]
ZobrCG2: push      cx
         mov       cx,ds:[Sirka]
         add       cx,3
         shr       cx,1
         shr       cx,1
         cmp       byte ptr ds:[VMod],6
         jb        ZobrCG3
         inc       cx
         shr       cx,1
ZobrCG3: call      ReadByte
         jc        ZobrCG6
         loop      ZobrCG3
ZobrCG6: pop       cx
         loop      ZobrCG2


                                          ;* zobrazen roviny 0
ZobrCGA1:cld
         xor       di,di                    ; ukldac adresa
         xor       bx,bx                    ; ukazatel linek
         mov       cx,ds:[Vyska]

                                          ;* cyklus zobrazen jedn linky
ZobrCGA2:push      cx
         push      di
         mov       cx,ds:[Sirka]
         add       cx,3
         shr       cx,1
         shr       cx,1
         cmp       byte ptr ds:[VMod],6
         jb        ZobrCGA3
         inc       cx
         shr       cx,1

                                          ;* cyklus zobrazen jednoho bajtu
ZobrCGA3:call      ReadByte
         jc        ZobrCGA6
         stosb                              ; uloen bajtu
         loop      ZobrCGA3


ZobrCGA6:pop       di
         pop       cx
         jc        ZobrCGA8                 ; chyba
         xor       di,2000h                 ; zmna linky
         test      bx,1                     ; je lich linka ?
         jz        ZobrCG63                 ; je sud linka
         add       di,50h
ZobrCG63:inc       bx
         loop      ZobrCGA2

ZobrCGA8:ret


; -----------------------------------------------------------------------------
;        Zobrazen grafickho mdu MCGA
; -----------------------------------------------------------------------------

ZobrMCG:

                                          ;* zobrazen roviny 0
         cld

ZobrMCG1:xor       di,di                    ; ukldac adresa
         mov       cx,ds:[Vyska]            ; poet linek

                                          ;* cyklus zobrazen jedn linky
ZobrMCG2:push      cx
         push      di
         mov       cx,ds:[Sirka]
                                          ;* cyklus zobrazen jednoho bajtu
ZobrMCG3:call      ReadByte
         jc        ZobrMCG6
         stosb
ZobrMCG4:loop      ZobrMCG3

ZobrMCG6:pop       di
         pop       cx
         jc        ZobrMCG8                 ; chyba

         add       di,320
         loop      ZobrMCG2

ZobrMCG8:ret


; -----------------------------------------------------------------------------
;        Zobrazen grafickho mdu EGA
; -----------------------------------------------------------------------------

ZobrEGA:

; ------ peskoen masky

         cld
         test      byte ptr ds:[Param],8    ; je maska ?
         jz        ZobrEG6                  ; nen maska

; ------ vymazn displeje

         mov       dx,3c4h
         mov       al,2
         out       dx,al                    ; registr 0 - volba barevn roviny
         inc       dx
         mov       al,bl                    ; barva
         out       dx,al                    ; volba barevn roviny

         mov       ax,0ffffh
         rep       stosw



         mov       cx,ds:[Vyska]
ZobrEG2: push      cx
         mov       cx,ds:[Sirka]
         add       cx,7
         shr       cx,1
         shr       cx,1
         shr       cx,1
ZobrEG3: call      ReadByte
         jc        ZobrEG4
         loop      ZobrEG3
ZobrEG4: pop       cx
         loop      ZobrEG2




ZobrEG6: xor       si,si                    ; ukazatel roviny
         mov       bl,1                     ; maska roviny

                                          ;* zobrazen jedn roviny
ZobrEGA1:mov       dx,3c4h
         mov       al,2
         out       dx,al                    ; registr 0 - volba barevn roviny
         inc       dx
         mov       al,bl                    ; maska roviny
         out       dx,al                    ; volba barevn roviny

         xor       di,di
         mov       cx,ds:[Vyska]
ZobrEGA2:push      cx
         mov       cx,ds:[Sirka]
         add       cx,7
         shr       cx,1
         shr       cx,1
         shr       cx,1
         push      di
ZobrEGA3:call      ReadByte
         jc        ZobrEGA6
         stosb
         loop      ZobrEGA3
ZobrEGA6:pop       di
         pop       cx
         jc        ZobrEGA8
         add       di,40
         cmp       byte ptr ds:[VMod],13
         je        ZobrEGA5
         add       di,40
ZobrEGA5:loop      ZobrEGA2

         inc       si                       ; zven tae rovin
         shl       bl,1                     ; posun masky rovin
         cmp       si,ds:[Rovin]            ; jsou ji vechny roviny ?
         jb        ZobrEGA1                 ; zobrazen dal roviny

ZobrEGA8:
         ret

; *****************************************************************************
;                     ten bajtu ze souboru
; -----------------------------------------------------------------------------
; *****************************************************************************

; -----------------------------------------------------------------------------
;        ten jednoho bajtu ze souboru
; -----------------------------------------------------------------------------

ReadByte PROC      NEAR

         test      byte ptr ds:[Param],1    ; je komprese ?
         jz        ReadB                    ; nen komprese

; ------ naten bajtu potu dat komprese

         cmp       byte ptr ds:[KompCit],0  ; je ta platn ?
         jne       ReadByt4                 ; ta je dosud platn
ReadByt1:call      ReadB                    ; naten bajtu tae
         jc        ReadByt5                 ; chyba ten dat
         mov       byte ptr ds:[KompCit],al ; poet nsledujcch bajt

; ------ pepna mdu komprese

         or        al,al                    ; je to jen pepna ?
         jnz       ReadByt2                 ; nen to pepna
         xor       byte ptr ds:[Param0],8   ; zmna pznaku komprese
         jmp       short ReadByt1           ; nov ten bajtu

; ------ naten bajtu k opakovn

ReadByt2:and       byte ptr ds:[Param0],not 10h ; zruen pznaku komprese
         test      byte ptr ds:[Param0],8    ; je md komprese ?
         jz        ReadByt3                 ; nen md komprese
         or        byte ptr ds:[Param0],10h  ; pznak komprese
         call      ReadB                    ; naten bajtu k opakovn
         jc        ReadByt5                 ; chyba ten dat
         mov       ds:[KompChr],al          ; bajt k opakovn

; ------ zmna pznaku mdu komprese

ReadByt3:cmp       byte ptr ds:[KompCit],255 ; je zmna mdu komprese ?
         je        ReadByt4                 ; nen zmna mdu komprese
         xor       byte ptr ds:[Param0],8    ; zmna pznaku komprese

; ------ naten dalho bajtu

ReadByt4:mov       al,ds:[KompChr]          ; bajt pi opakovn dat
         test      byte ptr ds:[Param0],10h  ; je opakovn dat ?
         jnz       ReadByt5                 ; je opakovn dat
         call      ReadB                    ; naten bnho bajtu dat

; ------ snen tae bajt

ReadByt5:dec       byte ptr ds:[KompCit]    ; snen tae komprese
         ret

ReadByte ENDP

; -----------------------------------------------------------------------------
; -----------------------------------------------------------------------------

ReadB:   push      si
         mov       si,ds:[ReadBuf]          ; ukazatel tench dat z bufferu
         cmp       si,ds:[NumBuf]           ; je ji konec bufferu ?
         jb        ReadB3                   ; jsou jet njak data v bufferu

                                          ;* naten dalho bloku dat
         mov       word ptr ds:[ReadBuf],0  ; vynulovn ukazatele dat

         push      ax
         push      bx
         push      cx
         push      dx

         mov       ah,3fh
         mov       bx,ds:[Idents]
         mov       cx,BuffSize
         mov       dx,offset buffer
         int       21h                      ; naten bloku dat z buferu
         jc        ReadB2
         mov       ds:[NumBuf],ax           ; nov poet bajt v bufferu
         or        ax,ax
         jnz       ReadB2
         stc                                ; pznak konce souboru

Readb2:  pop       dx
         pop       cx
         pop       bx
         pop       ax

         mov       si,0
         jc        ReadB4                   ; byla chyba ten

ReadB3:  mov       al,ds:[si+buffer]        ; peten bajtu z bufferu
         inc       word ptr ds:[ReadBuf]    ; zven ukazatele dat v bufferu
         clc

ReadB4:  pop        si
         ret


; *****************************************************************************
;                   Detekce monochromatickho displeje
; -----------------------------------------------------------------------------
;
; *****************************************************************************

DetMono: mov       ah,0fh
         call      Int10P
         xor       bl,bl                    ; pznak - nen monochrom. videomd
         cmp       al,15                    ; je videomd EGA 640x350/2 ?
         je        AktParD2                 ; je videomd EGA 640x350/2 (mono)
         cmp       al,12                    ; je intern videomd EGA - mono ?
         je        AktParD2                 ; je videomd EGA 640x350/2 (mono)
         cmp       al,7                     ; je barevn grafick videomd ?
         ja        AktParD3                 ; nen monochromatick videomd
         mov       bl,al                    ; schova videomdu
         cmp       bl,4                     ; je videomd 4 a vy ?
         jae       AktParD3                 ; nen textov videomd CGA
AktParD2:xor       bl,1                     ; zmna pznakovho bitu 0
AktParD3:and       bl,1                     ; ponech pznakov bit 0
         mov       ds:[Monochr],bl          ; nastaven pznaku monochrom. mdu
         ret

; *****************************************************************************
;                      Detekce typu grafick karty
;        0 = CGA; 1 = MDA; 2 = EGA color; 3 = EGA mono; 4 = VGA
; *****************************************************************************

DetTyp:  mov       al,ds:[VideoCard]        ; typ grafick karty
         cmp       byte ptr ds:[EgaVga],0   ; je grafick karta EGA/VGA ?
         je        DetTyp5                  ; nen grafick karta EGA/VGA

         mov       bl,4                     ; pednastaven - karta VGA
         cmp       al,9
         je        DetTyp9                  ; je karta VGA
         mov       bl,3                     ; pednastaven - EGA mono
         cmp       al,5
         je        DetTyp9                  ; je EGA mono
         cmp       al,15
         je        DetTyp9                  ; je EGA mono
         mov       bl,2                     ; pednastaven - EGA color
         jmp       short DetTyp9            ; jinak EGA color

DetTyp5: mov       bl,1                     ; pednastaven - MDA
         cmp       al,7
         je        DetTyp9                  ; je MDA
         cmp       al,15
         je        DetTyp9                  ; je MDA
         mov       bl,0                     ; jinak CGA

DetTyp9: mov       ds:[TypCard],bl          ; typ grafick karty
         ret


; *****************************************************************************
;                               DetectCard
;              Detekce videokarty - rozpoznn typu videokarty
; -----------------------------------------------------------------------------
; VSTUP:  DS=datov segment
;
; VSTUP: AX=1: CGA
;            2: MCGA
;            3: EGA
;            4: EGA 64kB
;            5: EGA Mono
;           (6: IBM8514)
;            7: Hercules
;           (8: ATT400)
;            9: VGA
;           10: PC3270
; *****************************************************************************

DetectCard PROC    NEAR

         push      bx
         push      cx
         push      dx
         push      si
         push      di
         push      es
         call      DetCard0                 ; detekce videokarty
         xor       ax,ax
         mov       al,ds:[VideoCard]        ; detekovan videokarta
         pop       es
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         ret

DetectCard ENDP

; -----------------------------------------------------------------------------
DetCard0:
         mov       ah,0fh
         call      Int10P                   ; dotaz na videomd
         cmp       al,7                     ; je monochromatick videomd ?
         je        DetCard5                 ; je monochromatick videomd

; ------ je barevn reim - rozpoznn EGA/VGA

         call      DetCard8                 ; test karet EGA/VGA
         jc        DetCard2                 ; nen karta EGA/VGA
DetCard1:call      DetCardA                 ; rozlien karet EGA/VGA
         ret
DetCard2:                                 ;* rozpoznn karty PC3270
         call      DetCardP                 ; detekce karty PC3270
         jc        DetCard3                 ; nen karta PC3270
         mov       byte ptr ds:[VideoCard],10; je videokarta PC3270
         ret

DetCard3:                                 ;* rozpoznn karet CGA/MCGA
         mov       byte ptr ds:[VideoCard],1; pednastaven karty CGA
         call      DetCardG                 ; test karty MCGA
         jc        DetCard4                 ; nen karta MCGA
         mov       byte ptr ds:[VideoCard],2; je karta MCGA
DetCard4:ret

; ------ monochromatick reim (videomd 7)

DetCard5:                                 ;* monochrom. reim - test EGA/VGA
         call      DetCard8                 ; test karty EGA/VGA
         jnc       DetCard1                 ; je EGA/VGA - rozlien EGA a VGA
                                          ;* test karty Hercules/MDA
         call      DetCardJ                 ; test karty Hercules
         jc        DetCard6                 ; nen karta Hercules
         mov       byte ptr ds:[VideoCard],7; je karta Hercules
         ret
DetCard6:                                 ;* test karty CGA (test pamti)
         mov       si,0b800h                ; segment videopamti CGA
         mov       es,si                    ; segment videopamti CGA
         xor       si,si                    ; poten adresa videopamti CGA
         mov       ax,es:[si]               ; pvodn slovo z videopamti
         not       ax                       ; inverze
         not       word ptr es:[si]         ; inverze i pvodnho slova
         nop
         nop
         cmp       ax,es:[si]               ; je tam pam RAM ?
         jne       DetCard7                 ; nen pam VRAM
         mov       byte ptr ds:[VideoCard],1; je karta CGA
DetCard7:ret
; -----------------------------------------------------------------------------
DetCard8:                                 ;* test karty EGA/VGA
         mov       ax,1200h
         mov       bl,10h                   ; podsluba poskytnut parametr
         mov       bh,0ffh                  ; pednastaven
         mov       cl,0fh                   ; pednastaven
         call      Int10P                   ; dotaz na EGA kartu
         cmp       cl,0ch
         jge       DetCard9                 ; nen karta EGA
         cmp       bh,1
         jg        DetCard9                 ; nen karta EGA
         cmp       bl,3
         jg        DetCard9                 ; nen karta EGA

                                          ;* je karta EGA/VGA
         mov       byte ptr ds:[EgaVga],1   ; pznak, e je karta EGA/VGA
         clc                                ; pznak - je karta EGA
         ret

                                          ;* nen karta EGA/VGA
DetCard9:mov       byte ptr ds:[EgaVga],0   ; zruen pznaku EGA/VGA
         stc                                ; pznak - nen karta EGA
         ret
; -----------------------------------------------------------------------------
DetCardA:                                 ;* rozlien karet EGA/VGA
         mov       byte ptr ds:[VideoCard],4; pednastaven karty EGA64
         cmp       bh,1                     ; je monochromatick md ?
         je        DetCardD                 ; je monochromatick md
         call      DetCardE                 ; test karty EGA 64
         jnc       DetCardC                 ; je karta EGA 64
         or        bl,bl                    ; je EGA 64 ?
         jz        DetCardC                 ; je EGA 64
         mov       byte ptr ds:[VideoCard],3; pednastaven karty EGA
         call      DetCardG                 ; test karty VGA
         jnc       DetCardB                 ; je karta VGA
         mov       bx,0c000h                ; segment s ROM VGA
         mov       es,bx                    ; segment s ROM VGA
         mov       bx,39h                   ; adresa textu "Z449"
         cmp       word ptr es:[bx],"Z4"    ; je text "Z4" ?
         jne       DetCardC                 ; nen karta VGA
         cmp       word ptr es:[bx+2],"49"  ; je text "49" ?
         jne       DetCardC                 ; nen karta VGA
DetCardB:mov       byte ptr ds:[VideoCard],9; je karta VGA
DetCardC:ret
DetCardD:mov       byte ptr ds:[VideoCard],5; je karta EGA Mono
         ret

DetCardE:                                 ;* test karty EGA 64
         cmp       cl,2
         jb        DetCardT                 ; je karta EGA 64
         cmp       cl,6
         jb        DetCardF                 ; nen karta EGA 64
         cmp       cl,8
DetCardT:cmc
DetCardF:ret
; -----------------------------------------------------------------------------
DetCardG:                                 ;* test karty VGA
         mov       ax,1a00h
         call      Int10P                   ; dotaz na poet linek na znak
         cmp       al,1ah                   ; je funkce obsluhovan ?
         jne       DetCardI                 ; funkce nen obsluhovan
         cmp       bl,7                     ; je 7 linek na znak ?
         je        DetCardH                 ; je karta OK
         cmp       bl,8
         je        DetCardH                 ; je karta OK
         cmp       bl,11
         jb        DetCardI                 ; nen karta
         cmp       bl,12
         ja        DetCardI                 ; nen karta
DetCardH:clc                                ; pznak - je karta
         ret
DetCardI:stc                                ; pznak - nen karta
         ret
; -----------------------------------------------------------------------------
DetCardJ:                                 ;* test karty Hercules
         mov       dx,03bah                 ; stavov port karty
         xor       bl,bl                    ; ta doby impulsu
         in        al,dx                    ; poten stav
         and       al,80h                   ; signl zptnho bhu
         mov       ah,al                    ; schova stavu registru
         mov       cx,8000h                 ; maximln doba testu
DetCardK:                                 ;* ekn na zmnu stavu bitu 7
         in        al,dx                    ; ten stavovho registru
         and       al,80h                   ; signl zptnho bhu
         cmp       al,ah                    ; byla zmna stavu signlu ?
         je        DetCardL                 ; nebyla zmna stavu signlu
         inc       bl                       ; ta dlky impulsu
         cmp       bl,10                    ; je minimln doba impulsu ?
         jae       DetCardM                 ; impuls je dostaten dlouh
DetCardL:loop      DetCardK                 ; dal test impulsu
         stc                                ; pznak - nen karta Hercules
         ret

DetCardM:                                 ;* ekn na bity 5,4 -> 01
         mov       cx,8000h                 ; maximln doba testu
DetCardN:in        al,dx                    ; ten stavovho registru
         and       al,30h
         cmp       al,10h
         jne       DetCardO                 ; je pouze karta MDA
         loop      DetCardN                 ; dal test
         mov       al,2                     ; pznak - je karta Hercules
         clc
         ret
DetCardO:mov       al,1                     ; pznak - je karta MDA
         clc
         ret
; -----------------------------------------------------------------------------
DetCardP:                                 ;* test videokarty PC3270
         mov       al,6
         xor       cx,cx                    ; CX <- 0
         xor       dx,dx
         mov       ah,30h
         call      Int10P
         mov       ax,cx
         or        ax,dx
         jz        DetCardR                 ; nen karta PC3270
         push      ds
         mov       ds,cx                    ; segment
         mov       bx,dx                    ; offset
         mov       al,ds:[bx+2]
         pop       ds
         or        al,al
         jz        DetCardQ                 ; je karta PC3270
         cmp       al,2
         jne       DetCardR                 ; nen karta PC3270
DetCardQ:mov       dx,188h
         in        al,dx
         test      al,4
         jz        DetCardR                 ; nen karta PC3270
         clc                                ; pznak - je karta PC3270
         ret
DetCardR:stc                                ; pznak - nen karta PC3270
         ret

; *****************************************************************************
;                              Int10P
;                Voln INT 10h s schovou registr
; -----------------------------------------------------------------------------
;
; *****************************************************************************

Int10P   PROC      NEAR

         pushf
         push      si
         push      di
         push      bp
         push      ds
         push      es
         int       10h
         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         popf
         ret

Int10P   ENDP

; -----------------------------------------------------------------------------
;        Data
; -----------------------------------------------------------------------------

UvTxt    db        'ANIMVIEW V1.0 - prohlizec SCR; (c) Miroslav Nemecek',13,10,'$'

ErTxt    db        'Chybne zadani souboru nebo neplatny format SCR !',13,10,'$'

KartTxt  db        'Chybna graficka karta - videomod nelze nastavit !',13,10,'$'

Idents   dw        0                        ; identifiktor souboru

; -----------------------------------------------------------------------------
                                          ;* tabulka parametr videomd
TabMod   dw        40,25                    ; 0
         dw        40,25                    ; 1
         dw        80,25                    ; 2
         dw        80,25                    ; 3
         dw        320,200                  ; 4
         dw        320,200                  ; 5
         dw        640,200                  ; 6
         dw        80,25                    ; 7
         dw        160,200                  ; 8
         dw        320,200                  ; 9
         dw        640,200                  ; 10
         dw        40,200                   ; 11
         dw        40,200                   ; 12
         dw        320,200                  ; 13
         dw        640,200                  ; 14
         dw        640,350                  ; 15
         dw        640,350                  ; 16
         dw        640,480                  ; 17
         dw        640,480                  ; 18
         dw        320,200                  ; 19

; -----------------------------------------------------------------------------
Zahlavi  label     byte                   ;* zhlav souboru SCREEN (dlka 16 B)
Ident    db        'SCR'                    ; identifikace souboru displeje
Verze    db        1                        ; verze souboru
Sirka    dw        0                        ; ka vezu (pozic)
Vyska    dw        0                        ; vka vezu (linek)
Rovin    dw        0                        ; poet barevnch rovin
Pozadi   dw        0                        ; barva pozad
Palety   dw        0                        ; poet bajt palet
Mod      db        0                        ; videomd displeje
Param    db        0                        ; parametry
                                            ;  bit 0: 1=komprese
                                            ;  bit 1: 1=textov videomd
                                            ;  bit 2: 1=paraleln barvy
                                            ;  bit 3: 1=je maska
                                            ;  bit 4: 1=jsou palety
KonHl    label     byte                     ; konec zhlav

         db        3*256 dup(0)             ; buffer pro palety

; -----------------------------------------------------------------------------
                                          ;* aktuln parametry
MaxSir   dw        80                       ; maximln ka (znak)
MaxVys   dw        25                       ; maximln vka (linek)
VMod     db        0                        ; skuten videomd
OldVMod  db        0                        ; pvodn videomd

; -----------------------------------------------------------------------------
                                          ;* parametry displeje
VideoCard db       0                        ; typ videokarty
                                            ;     0=neznm typ
                                            ;     1=CGA
                                            ;     2=Multi CGA
                                            ;     3=EGA
                                            ;     4=EGA 64kB
                                            ;     5=EGA Mono
                                            ;    (6=IBM8514)
                                            ;     7=Hercules
                                            ;    (8=ATT400)
                                            ;     9=VGA
                                            ;    10=PC3270

TypCard  db        0                        ; typ karty
                                            ;  0 = CGA
                                            ;  1 = MDA
                                            ;  2 = EGA color
                                            ;  3 = EGA mono
                                            ;  4 = VGA

EgaVga   db        0                        ; pznak, e je karta EGA/VGA
Monochr  db        0                        ; pznak monochromatickho displeje
; -----------------------------------------------------------------------------

ReadBuf  dw        0                        ; ukazatel tench dat z bufferu
NumBuf   dw        0                        ; poet bajt v bufferu

Param0   db        8                        ; parametry
                                            ;   bit 3: 1=bude stav komprese dat
                                            ;   bit 4: 1=nyn je komprese dat

KompCit  dw        0                        ; ta pro kompresi
KompChr  db        0                        ; uschovan opakovan bajt komprese


buffer   label     byte                     ; diskov buffer

code     ends
         end       start
