
; *****************************************************************************
;
;                              A N I M S C R
;
;                            Snmn obrazovky
;
; *****************************************************************************

BufSize  equ       1000h                    ; velikost diskovho bufferu

code     SEGMENT
         ASSUME    cs:code,ds:code
         org       100h

start:   jmp       instal                   ; instalace programu

AktScr   db        0                        ; pznak aktivity operace SCREEN
AktAsk   db        0                        ; poadavek operace SCREEN

Aktiv21  dd        0                        ; adresa pznaku aktivity DOS

old08    dd        0                        ; adresa pvodn obsluhy INT 08h
old09    dd        0                        ; adresa pvodn obsluhy INT 09h
old28    dd        0                        ; adresa pvodn obsluhy INT 28h


; -----------------------------------------------------------------------------
Zahlavi  label     byte                   ;* zhlav souboru SCREEN (dlka 16 B)
Ident    db        'SCR'                    ; identifikace souboru displeje
Verze    db        1                        ; verze souboru
Sirka    dw        0                        ; ka vezu (pozic)
Vyska    dw        0                        ; vka vezu (linek)
Rovin    dw        0                        ; poet barevnch rovin
Pozadi   dw        0                        ; barva pozad
Palet    dw        0                        ; poet bajt palet
VMod     db        0                        ; videomd displeje
Param    db        0                        ; parametry
                                            ;  bit 0: 1=komprese
                                            ;  bit 1: 1=textov videomd
                                            ;  bit 2: 1=paraleln uloen barev
                                            ;  bit 3: 1=obsahuje masku
                                            ;  bit 4: 1=jsou palety
KonHl    label     byte                     ; konec zhlav

         db        3*256 dup(0)             ; buffer pro palety

; -----------------------------------------------------------------------------
MaxSir   dw        0                        ; maximln ka (znak)
MaxVys   dw        0                        ; maximln vka (linek)

                                          ;* definice kurzoru
X1       dw        0                        ; lev pozice kurzoru
X2       dw        0ffffh                   ; prav pozice kurzoru
Y1       dw        0                        ; horn dek kurzoru
Y2       dw        0ffffh                   ; doln dek kurzoru

; -----------------------------------------------------------------------------

ParEGA   db        0                        ; pznak videokarty EGA/VGA

NumBuff  dw        0                        ; poet bajt v diskovm bufferu

                                          ;* jmno souboru
Soubor   db        'A:\',64+14 dup(0)       ; buffer pro adres a soubor
AdrSoub  dw        0                        ; adresa sla souboru

Idents   dw        0                        ; identifikace vstupnho souboru

Keys     dw        0                        ; uschovan kd klvesy
Citac    db        0                        ; ta blikn kurzoru
AktKur   db        0                        ; pznak zapnut kurzoru

; -----------------------------------------------------------------------------
;        Obsluha INT 08h
; -----------------------------------------------------------------------------

int08    PROC      FAR

         pushf
         call      dword ptr cs:[Old08]     ; pvodn obsluha INT 08h
         call      Screen                   ; obsluha akce SCREEN
         iret

Int08    ENDP

; -----------------------------------------------------------------------------
;        Obsluha INT 28h
; -----------------------------------------------------------------------------

int28    PROC      FAR

         pushf
         call      dword ptr cs:[Old28]     ; pvodn obsluha INT 28h
         call      Screen                   ; obsluha akce SCREEN
         iret

Int28    ENDP

; -----------------------------------------------------------------------------
;        Obsluha INT 09h
; -----------------------------------------------------------------------------

int09    PROC      far

         push      ax
         push      bx
         push      ds

         mov       bx,40h
         mov       ds,bx
         mov       bx,ds:[1ch]              ; ukldac adresa do bufferu

         in        al,[60h]                 ; orientan kd klvesy
         cmp       al,37h                   ; je klvesa <Print Screen> ?
         jne       Int091                   ; nen <Print Screen>
         test      byte ptr ds:[17h],4      ; je Ctrl ?
         jz        Int091                   ; nen Ctrl

         mov       byte ptr cs:[AktAsk],1   ; pznak poadavku funkce

         mov       byte ptr ds:[100h],1     ; pznak obsluhy PRINT SCREEN

         pushf
         call      dword ptr cs:[Old09]
         jmp       short Int093

Int091:  pushf
         call      dword ptr cs:[old09]     ; obsluha INT 09h

         cmp       bx,ds:[1ch]              ; je njak znak ?
         je        Int095                   ; nen dn klvesa

         cmp       byte ptr cs:[AktScr],0   ; je funkce aktivn ?
         je        Int095                   ; funkce nen aktivn

                                          ;* pjem kdu klvesy
         mov       ax,ds:[bx]               ; pijat klvesa
         mov       cs:[Keys],ax             ; schova kdu klvesy
Int093:  mov       ds:[1ch],bx              ; zruen znaku z bufferu

Int095:  pop       ds
         pop       bx
         pop       ax

         iret

Int09    ENDP

; -----------------------------------------------------------------------------
;        Obsluha akce SCREEN
; -----------------------------------------------------------------------------

Screen0: ret

Screen:  cmp       byte ptr cs:[AktScr],0   ; probh ji akce ?
         jne       Screen0                  ; akce ji probh
         cmp       byte ptr cs:[AktAsk],0   ; poaduje se akce ?
         je        Screen0                  ; akce se nepoaduje

         push      ds
         push      bx
         lds       bx,cs:[Aktiv21]          ; adresa pznaku aktivity DOS
         cmp       byte ptr ds:[bx],0       ; je DOS aktivn ?
         pop       bx
         pop       ds
         jne       Screen0                  ; DOS je aktivn

                                          ;* akce se provede
         mov       byte ptr cs:[AktScr],1   ; pznak aktivity akce SCREEN
         sti                                ; peruen povoleno

         pushf
         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di
         push      bp
         push      ds
         push      es

                                          ;* uren segmentu videopamti a
                                          ;* test oprvnnosti videomdu
         xor       ax,ax
         mov       ds,ax                    ; segment dat BIOS
         mov       bx,0b800h                ; segment CGA
         mov       si,ds:[44eh]             ; adresa displeje
         mov       al,ds:[449h]             ; aktivn videomd
         cmp       al,7
         jb        Screen1                  ; povolen videomd CGA
         mov       bx,0b000h                ; segment MDA
         je        Screen1                  ; povolen videomd MDA
         mov       bx,0a000h                ; jinak segment EGA
         cmp       al,12
         jbe       Screen88                 ; zakzan videomd
         cmp       al,19                    ; maximln videomd
         jbe       Screen1                  ; videomd OK
Screen88:jmp       Screen8                  ; neobsluhovan videomd
Screen1: mov       es,bx                    ; segment videopamti

                                          ;* zvukov singalizace
         mov       cx,10
Screen2: push      cx
         in        al,[61h]
         or        al,3
         out       [61h],al
         mov       cx,7000
         loop      $
         and       al,0fch
         out       [61h],al
         mov       cx,5000
Screen3: loop      $
         pop       cx
         loop      Screen2

                                          ;* nalezen nepouitho souboru
         push      cs
         pop       ds
Screen4: mov       dx,offset Soubor
         mov       ax,3d02h                 ; funkce oteven souboru
         int       21h                      ; pokus o oteven souboru
         jc        Screen5                  ; soubor asi neexistuje - OK
         mov       bx,ax
         mov       ah,3eh
         int       21h                      ; uzaven souboru
         call      ZvysSoub                 ; zven sla souboru
         jmp       short Screen4            ; nov pokus s dalm souborem

                                          ;* vytvoen novho souboru
Screen5: mov       ah,3ch
         xor       cx,cx                    ; atributy
         int       21h                      ; vytvoen novho souboru
         jc        Screen8                  ; chyba - soubor nelze vytvoit
         mov       ds:[Idents],ax           ; schova identifiktoru souboru

                                          ;* nalezen popisu videomdu v tabulce
         push      ds
         xor       ax,ax
         mov       ds,ax
         mov       bl,ds:[449h]             ; aktivn videomd
         pop       ds
         mov       ds:[VMod],bl             ; aktivn videomd
         mov       bh,0
         mov       ax,12                    ; dlka poloky tabulky
         mul       bx                       ; vpoet offsetu v tabulce
         add       ax,offset TabMod         ; adresa v tabulce
         mov       bp,ax                    ; adresa poloky v tabulce

                                          ;* stanoven parametr podle tabulky
         mov       ax,ds:[bp]               ; maximln ka
         mov       ds:[MaxSir],ax           ; maximln ka
         mov       ax,ds:[bp+2]             ; maximln vka
         mov       ds:[MaxVys],ax           ; maximln vka
         mov       al,ds:[bp+4]             ; poet rovin
         mov       byte ptr ds:[Rovin],al   ; poet rovin
         mov       al,ds:[bp+5]             ; typ
         mov       byte ptr ds:[Param],al   ; parametry

                                          ;* upesnn dk v textovm mdu
         cmp       byte ptr ds:[ParEGA],0   ; je karta EGA/VGA ?
         je        Screen60                 ; nen karta EGA/VGA
         test      byte ptr ds:[Param],2    ; je textov videomd ?
         jz        Screen60                 ; nen textov videomd
         push      ds
         xor       ax,ax
         mov       ds,ax                    ; segment dat BIOS
         mov       al,ds:[484h]             ; slo poslednho dku
         inc       ax                       ; poet dk na obrazovku
         pop       ds
         mov       ds:[MaxVys],ax           ; opraven vka displeje

                                          ;* funkce snmn obrazovky
Screen60:call      Anims                    ; snmn obrazovky
         jc        Screen9                  ; peruen operace

         call      WritBuff                 ; zpis bufferu na disk
         mov       ah,3eh
         mov       bx,ds:[Idents]           ; identifiktor vstupnho souboru
         int       21h                      ; uzaven souboru
         jmp       short Screen8

Screen9: mov       ah,3eh
         mov       bx,ds:[Idents]           ; identifiktor vstupnho souboru
         int       21h                      ; uzaven souboru

         mov       dx,offset Soubor
         mov       ah,41h                   ; funkce zruen souboru
         int       21h                      ; zruen soubor pi chyb

Screen8: cli
         mov       ax,40h
         mov       ds,ax
         mov       byte ptr ds:[100h],0     ; zruen pznaku PRINT SCREEN

         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         popf

         cli                                ; opt zkaz peruen

         mov       byte ptr cs:[AktScr],0   ; zruen pznaku aktivity SCREEN
         mov       byte ptr cs:[AktAsk],0   ; zruen poadavku na funkci

         ret

; -----------------------------------------------------------------------------
;        Zven sla souboru
; -----------------------------------------------------------------------------

ZvysSoub:push      si
         mov       si,ds:[AdrSoub]
ZvysSou1:inc       byte ptr ds:[si]
         cmp       byte ptr ds:[si],"9"+1
         jne       ZvysSou2
         mov       byte ptr ds:[si],"0"
         dec       si
         jmp       short ZvysSou1
ZvysSou2:pop       si
         ret

; -----------------------------------------------------------------------------
;        Zpis bajtu do diskovho bufferu
; -----------------------------------------------------------------------------

WritB:   cmp       word ptr ds:[NumBuff],BufSize ; buffer je ji zaplnn ?
         jb        WritB2                   ; buffer jet nen zaplnn
         call      WritBuff                 ; zpis bufferu na disk
         jc        WritB3                   ; byla chyba zpisu
WritB2:  push      si
         mov       si,ds:[NumBuff]          ; poet bajt v bufferu
         mov       ds:[si+Buffer],al        ; zpis novho bajtu do bufferu
         inc       word ptr ds:[NumBuff]    ; zven tae bajt v bufferu
         pop       si
WritB3:  ret

; -----------------------------------------------------------------------------
;        Zpis diskovho bufferu do souboru (CY=chyba)
; -----------------------------------------------------------------------------

WritBuff:push      ax
         push      bx
         push      cx
         push      dx

         mov       dx,offset buffer
         mov       cx,ds:[NumBuff]          ; poet bajt v diskovm bufferu
         jcxz      WritBff2                 ; nen dn bajt k zpisu
         mov       ah,40h
         mov       bx,ds:[Idents]           ; identifiktor souboru
         int       21h                      ; zpis souboru
         mov       word ptr ds:[NumBuff],0  ; vynulovn bufferu
         jc        WritBff2                 ; byla chyba
         cmp       ax,cx                    ; souhlas poet bajt ?
         je        WritBff2                 ; poet bajt souhlas
         stc                                ; chyba - pln disk

WritBff2:pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret







; -----------------------------------------------------------------------------
;        Vlastn funkce snmn obsahu obrazovky
; -----------------------------------------------------------------------------

Anims:
         call      Edit                     ; editace kurzoru
         jc        Anims9                   ; peruen operace

         call      WritHl                   ; zpis zhlav souboru
         jc        Anims9                   ; chyba zpisu

         xor       ax,ax                    ; poten rovina k zpisu
         mov       bx,ds:[X1]               ; poten pozice
         mov       cx,ds:[X2]               ; koncov pozice
         sub       cx,bx                    ; ka - 1
         inc       cx                       ; ka okna
Anims1:  mov       dx,ds:[Y1]               ; poten dek
Anims2:  call      word ptr ds:[bp+10]      ; zpis dku okna
         inc       dx                       ; zven dku
         cmp       dx,ds:[Y2]               ; dosaeno poslednho dku ?
         jbe       Anims2                   ; nen pekroen posledn dek
         inc       ax                       ; zven sla roviny
         test      byte ptr ds:[Param],4    ; je paraleln uloen barev ?
         jnz       Anims9                   ; je paraleln uloen barev
         cmp       ax,ds:[Rovin]            ; jsou ji vechny roviny ?
         jb        Anims1                   ; nejsou jet vechny roviny
         clc
Anims9:  ret

; -----------------------------------------------------------------------------
;        Editace kurzoru (ES:SI=adresa videopamti)
; -----------------------------------------------------------------------------

Edit:
         call      Omez                     ; omezen rozmr kurzoru
         call      Kurzor                   ; zapnut kurzoru

Edit1:   push      ds
         xor       ax,ax
         mov       ds,ax                    ; DS <- 0
         mov       bx,ds:[46ch]             ; souasn stav asovae
         mov       byte ptr cs:[Citac],15   ; kurzor zapnut

Edit11:  cmp       ds:[46ch],bx             ; je zmna hodin ?
         je        Edit12                   ; nen zmna hodin
         mov       bx,ds:[46ch]             ; nov hodnota hodin
         dec       byte ptr cs:[Citac]      ; snen tae hodin
         jnz       Edit12                   ; nen jet pln as
         call      Kurzor                   ; inverze kurzoru
         mov       byte ptr cs:[Citac],15   ; as pro zapnut kurzor
         cmp       byte ptr cs:[AktKur],0   ; je kurzor aktivn ?
         jne       Edit12                   ; kurzor je aktivn
         mov       byte ptr cs:[Citac],4    ; doba pro vypnut
Edit12:  xor       ax,ax
         xchg      ax,cs:[Keys]             ; vyjmut znaku z bufferu
         or        ax,ax                    ; byl njak znak ?
         jz        Edit11                   ; nebyl dn znak

         cmp       byte ptr cs:[AktKur],0   ; je kurzor aktivn ?
         jne       Edit13                   ; kurzor je aktivn
         call      Kurzor                   ; zapnut kurzoru
Edit13:  pop       ds


                                          ;* rozlien ukonen editace
         cmp       al,13                    ; je Enter ?
         je        Edit9                    ; dn ukonen editace
         cmp       al,27                    ; peruen ESC ?
         stc                                ; pznak peruen editace Esc
         je        Edit9                    ; peruen editace ESC

                                          ;* zjitn stavu pesmyka
         push      ds
         mov       bx,40h
         mov       ds,bx                    ; DS <- 40h
         mov       al,ds:[17h]              ; stav pesmyka
         and       al,0fh                   ; pouze pesmykae Ctrl, Shift, Alt
         test      al,3                     ; pesmykae SHIFT ?
         jz        Edit2                    ; nejsou pesmykae SHIFT
         or        al,3                     ; pesmykae SHIFT
Edit2:   pop       ds

                                          ;* vyvoln funkce podle klvesy
         mov       bx,offset TabKey         ; tabulka klves pro editaci
         mov       cx,offset(TabKey0-TabKey)/6 ; poet klves v tabulce
Edit3:   cmp       ax,ds:[bx]               ; je to hledan klvesa ?
         je        Edit4                    ; klvesa nalezena
         add       bx,6                     ; adresa dal klvesy
         loop      Edit3                    ; test dal klvesy v tabulce
Edit16:  jmp       short Edit1              ; vstup dal klvesy

Edit4:   mov       cx,ds:[bx+2]             ; posun kurzoru
         call      word ptr ds:[bx+4]       ; vyvoln obsluhy klvesy
         jmp       short Edit16             ; vstup dal klvesy

Edit9:   call      Kurzor                   ; vypnut kurzoru
         ret


; -----------------------------------------------------------------------------

TabKey   label     word                   ;* tabulka obsluh funkc editoru

                                          ;* posuny kurzoru
         dw        4b00h,1,offset EdLeft      ; LEFT - kurzor 1 pozici vlevo
         dw        4d00h,1,offset EdRight     ; RIGHT - kurzor 1 pozici vpravo
         dw        4800h,1,offset EdUp        ; UP - kurzor 1 pozici nahoru
         dw        5000h,1,offset EdDown      ; DOWN - kurzor 1 pozici dol
         dw        7304h,8,offset EdLeft     ; ^LEFT - kurzor 10 znak vlevo
         dw        7404h,8,offset EdRight    ; ^RIGHT - kurzor 10 znak vpravo
         dw        8d04h,8,offset EdUp       ; ^UP - kurzor 10 linek nahoru
         dw        9104h,8,offset EdDown     ; ^DOWN -kurzor 10 linek dol
         dw        0f03h,48,offset EdLeft     ; STAB - kurzor 50 pozic vlevo
         dw        0f00h,48,offset EdRight    ; TAB - kurzor 50 pozic vpravo
         dw        4900h,48,offset EdUp       ; PAGEUP - kurzor 50 linek nahoru
         dw        5100h,48,offset EdDown     ; PAGEDOWN - kurzor 50 linek dol
         dw        4700h,-2,offset EdLeft     ; HOME - kurzor k levmu okraji
         dw        4f00h,-2,offset EdRight    ; END - kurzor k pravmu okraji
         dw        7704h,-2,offset EdUp       ; ^HOME - kurzor k hornmu okraji
         dw        7504h,-2,offset EdDown     ; ^END - kurzor k spodnmu okraji
         dw        8404h,-2,offset EdUp       ; ^PAGEUP - k hornmu okraji
         dw        7604h,-2,offset EdDown     ; ^PAGEDOWN - k spodnmu okraji

                                          ;* pesmyka SHIFT - okraje
         dw        4b03h,1,offset EdSLeft     ; LEFT - vlevo
         dw        4d03h,1,offset EdSRight    ; RIGH - vpravo
         dw        4803h,1,offset EdSUp       ; UP - nahoru
         dw        5003h,1,offset EdSDown     ; DOWN - dol
         dw        7307h,8,offset EdSLeft    ; ^LEFT - 10 znak vlevo
         dw        7407h,8,offset EdSRight   ; ^RIGHT - 10 znak vpravo
         dw        8d07h,8,offset EdSUp      ; ^UP - 10 linek nahoru
         dw        9107h,8,offset EdSDown    ; ^DOWN - 10 linek dol
         dw        4903h,48,offset EdSUp      ; PAGEUP - 50 znak nahoru
         dw        5103h,48,offset EdSDown    ; PAGEDOWN - 50 znak dol
         dw        4703h,-2,offset EdSLeft    ; HOME - max. vlevo
         dw        4f03h,-2,offset EdSRight   ; END - max. vpravo
         dw        7707h,-2,offset EdSUp      ; ^HOME - max. nahoru
         dw        7507h,-2,offset EdSDown    ; ^END - max. dol
         dw        8407h,-2,offset EdSUp      ; ^PageUp - max. nahoru
         dw        7607h,-2,offset EdSDown    ; ^PageDown - max. dol

TabKey0  label     word
; -----------------------------------------------------------------------------
                                          ;* kurzor vlevo
EdLeft:  cmp       word ptr ds:[X1],0       ; je ji lev okraj ?
         je        EdLeft2                  ; je ji lev okraj
         call      Kurzor                   ; vypnut kurzoru
         cmp       cx,ds:[X1]               ; je mn pozic ne CX ?
         jbe       EdLeft1                  ; nen mn pozic ne CX
         mov       cx,ds:[X1]               ; omezen poet pozic
EdLeft1: sub       word ptr ds:[X1],cx      ; posun vlevo
         sub       word ptr ds:[X2],cx      ; posun i pravho okraje
         call      Kurzor                   ; zapnut kurzoru
EdLeft2: ret
; -----------------------------------------------------------------------------
                                          ;* kurzor vpravo
EdRight: mov       ax,ds:[MaxSir]           ; maximln prav okraj
         dec       ax                       ; maximln prav pozice
         sub       ax,ds:[X2]               ; zbyl poet pozic
         jz        EdRight2                 ; nen dn dal pozice
         call      Kurzor                   ; vypnut kurzoru
         cmp       ax,cx                    ; je vt rozdl ne CX ?
         jbe       EdRight1                 ; nen vt rozdl ne CX
         mov       ax,cx                    ; omezen na CX pozic
EdRight1:add       ds:[X2],ax               ; zven pravho okraje
         add       ds:[X1],ax               ; zven levho okraje
         call      Kurzor                   ; zapnut kurzoru
EdRight2:ret
; -----------------------------------------------------------------------------
                                          ;* kurzor nahoru
EdUp:    cmp       word ptr ds:[Y1],0       ; je ji horn okraj ?
         je        EdUp2                    ; je ji horn okraj
         call      Kurzor                   ; vypnut kurzoru
         cmp       cx,ds:[Y1]               ; je mn pozic ne CX ?
         jbe       EdUp1                    ; nen mn pozic ne CX
         mov       cx,ds:[Y1]               ; omezen poet pozic
EdUp1:   sub       word ptr ds:[Y1],cx      ; posun nahoru
         sub       word ptr ds:[Y2],cx      ; posun i spodnho okraje
         call      Kurzor                   ; zapnut kurzoru
EdUp2:   ret
; -----------------------------------------------------------------------------
                                          ;* kurzor dol
EdDown:  mov       ax,ds:[MaxVys]           ; maximln spodn okraj
         dec       ax                       ; maximln spodn pozice
         sub       ax,ds:[Y2]               ; zbyl poet pozic
         jz        EdDown2                  ; nen dn dal pozice
         call      Kurzor                   ; vypnut kurzoru
         cmp       ax,cx                    ; je vt rozdl ne CX ?
         jbe       EdDown1                  ; nen vt rozdl ne CX
         mov       ax,cx                    ; omezen na CX pozic
EdDown1: add       ds:[Y2],ax               ; posun spodnho okraje
         add       ds:[Y1],ax               ; posun hornho okraje
         call      Kurzor                   ; zapnut kurzoru
EdDown2: ret
; -----------------------------------------------------------------------------
                                          ;* prav okraj vlevo
EdSLeft: mov       ax,ds:[X2]               ; prav okraj
         sub       ax,ds:[X1]               ; souasn ka
         je        EdSLeft2                 ; je ji lev okraj
         call      Kurzor                   ; vypnut kurzoru
         cmp       ax,cx                    ; je ka men ne poadovan ?
         jbe       EdSLeft1                 ; ka je men
         mov       ax,cx                    ; omezen na poadovan posun
EdSLeft1:sub       word ptr ds:[X2],ax      ; posun vlevo
         call      Kurzor                   ; zapnut kurzoru
EdSLeft2:ret
; -----------------------------------------------------------------------------
                                          ;* prav okraj vpravo
EdSRight:mov       ax,ds:[MaxSir]           ; maximln prav okraj
         dec       ax                       ; maximln prav pozice
         sub       ax,ds:[X2]               ; zbytek k pravmu okraji
         je        EdSRght2                 ; je ji prav okraj
         call      Kurzor                   ; vypnut kurzoru
         cmp       ax,cx                    ; je ka men ne poadovan ?
         jbe       EdSRght1                 ; ka je men
         mov       ax,cx                    ; omezen na poadovan posun
EdSRght1:add       word ptr ds:[X2],ax      ; posun pravho okraje vpravo
         call      Kurzor                   ; zapnut kurzoru
EdSRght2:ret
         ret
; -----------------------------------------------------------------------------
                                          ;* spodn okraj nahoru
EdSUp:   mov       ax,ds:[Y2]               ; spodn okraj
         sub       ax,ds:[Y1]               ; souasn ka
         je        EdSUp2                   ; je ji horn okraj
         call      Kurzor                   ; vypnut kurzoru
         cmp       ax,cx                    ; je ka men ne poadovan ?
         jbe       EdSUp1                   ; ka je men
         mov       ax,cx                    ; omezen na poadovan posun
EdSUp1:  sub       word ptr ds:[Y2],ax      ; posun vlevo
         call      Kurzor                   ; zapnut kurzoru
EdSUp2:  ret
; -----------------------------------------------------------------------------
                                          ;* spodn okraj dol
EdSDown: mov       ax,ds:[MaxVys]           ; maximln spodn okraj
         dec       ax                       ; maximln prav pozice
         sub       ax,ds:[Y2]               ; zbytek ke spodnmu okraji
         je        EdSDown2                 ; je ji spodn okraj
         call      Kurzor                   ; vypnut kurzoru
         cmp       ax,cx                    ; je ka men ne poadovan ?
         jbe       EdSDown1                 ; ka je men
         mov       ax,cx                    ; omezen na poadovan posun
EdSDown1:add       word ptr ds:[Y2],ax      ; posun spodnho okraje dol
         call      Kurzor                   ; zapnut kurzoru
EdSDown2:ret
         ret

; -----------------------------------------------------------------------------
;        Zpis hlaviky souboru
; -----------------------------------------------------------------------------

WritHl:  push      ax
         push      bx
         push      cx
         push      dx

         and       byte ptr ds:[Param],not 10h ; zruen pznaku palet
         mov       word ptr ds:[Palet],0    ; zruen pznaku palet
         cmp       byte ptr ds:[VMod],19
         jne       WritHl2                  ; nen VGA

         push      es
         push      cs
         pop       es
         mov       word ptr ds:[Palet],3*256; poet bajt palet
         or        byte ptr ds:[Param],10h  ; pznak palet
         mov       cx,256                   ; poet paletovch registr
         mov       dx,offset KonHl          ; buffer k naten palet
         xor       bx,bx                    ; poten registr palet
         mov       ax,1017h                 ; funkce ten palet
         int       10h                      ; ten palet
         pop       es

WritHl2:
         mov       ax,ds:[X2]               ; prav okraj
         sub       ax,ds:[X1]               ; ka - 1
         inc       ax                       ; ka
         mov       ds:[sirka],ax            ; ka vezu

         mov       ax,ds:[Y2]               ; spodn okraj
         sub       ax,ds:[Y1]               ; vka - 1
         inc       ax                       ; vka
         mov       ds:[vyska],ax            ; vka vezu

         mov       dx,offset Zahlavi        ; zhlav souboru
         mov       cx,offset(KonHl-Zahlavi) ; dlka zhlav souboru
         add       cx,ds:[Palet]            ; piten dlky palet
         mov       bx,ds:[Idents]           ; identifiktor souboru
         mov       ah,40h                   ; funkce zpisu do souboru
         int       21h                      ; zpis zhlav do souboru

         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

; -----------------------------------------------------------------------------
;        Omezen rozmr kurzoru
; -----------------------------------------------------------------------------

Omez:    push      ax

         mov       ax,ds:[MaxSir]           ; maximln ka
         dec       ax                       ; posledn pozice

         cmp       ax,ds:[X1]               ; pekroena pozice X ?
         jae       Omez2                    ; nen pekroeno
         mov       ds:[X1],ax               ; omezen na posledn pozici

Omez2:   cmp       ax,ds:[X2]               ; pekroena pozice X2 ?
         jae       Omez4                    ; nen pekroena
         mov       ds:[X2],ax               ; omezen na posledn pozici

Omez4:   mov       ax,ds:[MaxVys]           ; maximln vka
         dec       ax                       ; posledn linka

         cmp       ax,ds:[Y1]               ; pekroen dek Y ?
         jae       Omez5                    ; nen pekroen
         mov       ds:[Y1],ax               ; omezen na posledn dek

Omez5:   cmp       ax,ds:[Y2]               ; pekroen dek Y2 ?
         jae       Omez7                    ; nen pekroen
         mov       ds:[Y2],ax               ; omezen na posledn dek

Omez7:   pop       ax
         ret


; -----------------------------------------------------------------------------
;        Zobrazen kurzoru (ES:SI=adresa videopamti)
; -----------------------------------------------------------------------------

Kurzor:  pushf
         push      ax
         push      bx
         push      cx
         push      dx
         push      ds
         push      cs
         pop       ds

         xor       byte ptr ds:[AktKur],1   ; zmna pznaku aktivity kurzoru

                                          ;* horn linka
         mov       bx,ds:[X1]               ; lev pozice
         mov       dx,ds:[Y1]               ; horn dek
         mov       cx,ds:[X2]               ; prav pozice
         sub       cx,bx                    ; dlka horn linky - 1
         inc       cx                       ; dlka horn linky
         call      word ptr ds:[bp+6]       ; zobrazen horn linky

                                          ;* lev okraj
         mov       cx,ds:[Y2]               ; spodn okraj
         sub       cx,dx                    ; dlka levho okraje - 1
         inc       dx                       ; a 2. dek
         call      word ptr ds:[bp+8]       ; zobrazen levho okraje

                                          ;* prav okraj
         mov       bx,ds:[X2]               ; prav pozice
         cmp       bx,ds:[X1]               ; je shodn s levm okrajem ?
         je        Kurzor1                  ; je shodn s levm okrajem
         call      word ptr ds:[bp+8]       ; zobrazen pravho okraje

                                          ;* spodn okraj
         mov       dx,ds:[Y2]               ; spodn okraj
         cmp       dx,ds:[Y1]               ; splv s hornm okrajem ?
         je        Kurzor1                  ; splv s hornm okrajem - nic
         mov       bx,ds:[X1]               ; lev okraj
         inc       bx
         mov       cx,ds:[X2]               ; prav okraj
         sub       cx,bx                    ; ka - 1
         call      word ptr ds:[bp+6]       ; zobrazen spodnho okraje

Kurzor1: pop       ds
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         popf
         ret



; -----------------------------------------------------------------------------
;                 Inverze dku znak textovho mdu
;         (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak)
; -----------------------------------------------------------------------------

                                          ;* inverze vertiklnho sloupce
InvTxtV: push      di
         mov       di,ds:[MaxSir]
         shl       di,1
         jmp       short InvTxt0

                                          ;* inverze horizontlnho dku
InvTxtH: push      di
         mov       di,2

InvTxt0: push      ax
         push      cx
         push      dx
         push      si

         jcxz      InvTxtH2                 ; nen dn znak

         mov       ax,ds:[MaxSir]           ; poet bajt na dek
         mul       dx                       ; pepoet dk na pozice
         add       ax,bx                    ; piten pozic
         shl       ax,1                     ; pevod na offset ve VRAM
         add       si,ax                    ; adresa ve videopamti
InvTxtH1:xor       byte ptr es:[si+1],77h   ; inverze znaku kurzoru
         add       si,di                    ; adresa dalho znaku
         loop      InvTxtH1                 ; dal znak

InvTxtH2:pop       si
         pop       dx
         pop       cx
         pop       ax
         pop       di
         ret

; -----------------------------------------------------------------------------
;            Inverze bodu kurzoru mdu CGA
;     (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak, AX=prustek)
; -----------------------------------------------------------------------------


InvCGAH:
         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di


                                          ;* bitov pozice v bajtu
         mov       di,bx                    ; pozice
         and       di,7                     ; bitov pozice v bajtu
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; pepoet na bajty


                                          ;* vpoet adresy linky ve VRAM
         cmp       byte ptr ds:[Vmod],17
         je        InvCGAH1
         shr       dx,1                     ; poet linek / 2
         jnc       InvCGAH1                 ; je sud linka
         xor       si,2000h                 ; korekce adresy
InvCGAH1:mov       ax,80                    ; poet bajt na dek
         mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; piten adresy linky
         add       si,bx                    ; piten pozic
         cmp       byte ptr ds:[Vmod],6
         jae       InvCGAH2                 ; je videomd 6 nebo 17
         add       si,bx

InvCGAH2:push      cx
         mov       cx,di                    ; bitov pozice
         mov       ax,0ffh                  ; maska pro videomd 6
         shr       ax,cl                    ; rotace masky na pozici
         pop       cx

         cmp       byte ptr ds:[Vmod],6
         jae       InvCGAH3                  ; je videomd 6 nebo 17

         push      cx
         mov       cx,di                    ; bitov pozice
         mov       ax,0ffffh                ; maska pro ostatn videomdy
         shr       ax,cl
         shr       ax,cl                    ; rotace masky na pozici
         pop       cx
         xchg      ah,al

                                          ;* zobrazen sti z prvnho bajtu
InvCGAH3:jcxz      InvCGAH9                 ; nen dn bod

         xor       word ptr es:[si],ax      ; inverze prvnho bajtu kurzoru
         add       cx,di                    ; piten prvn osmice
         sub       cx,8                     ; odeten bit z prvnho bajtu
         jc        InvCGAH5                 ; nen dal bajt

                                          ;* stanoven masky vnitnch bajt
         mov       ax,0ffh                  ; maska pro videmdy 6 a 17
         mov       bx,1                     ; prustek pro videomdy 6 a 17
         cmp       byte ptr ds:[Vmod],6
         jae       InvCGH33                 ; je videomd 6
         mov       ax,0ffffh                ; maska pro ostatn videomdy
         inc       bx                       ; ostatn videomdy prustek 2

InvCGH33:add       si,bx
                                          ;* zobrazen vnitnch bajt kurzoru
InvCGAH4:xor       word ptr es:[si],ax      ; inverze bit v bajtu
         sub       cx,8                     ; odeten osmice bit
         jc        InvCGAH5                 ; je ji peteen
         add       si,bx                    ; adresa dalho znaku
         jmp       short InvCGAH4           ; je dal bajt

                                          ;* vymazn pebytench bit
InvCGAH5:add       cx,8                     ; nvrat potu zbylch bit
         mov       ax,0ffh                  ; maska pro videomd 6
         shr       ax,cl                    ; rotace masky na pozici

         cmp       byte ptr ds:[Vmod],6
         jae       InvCGAH6                  ; je videomd 6

         mov       ax,0ffffh                ; maska pro ostatn videomdy
         shr       ax,cl
         shr       ax,cl                    ; rotace masky na pozici
         xchg      ah,al

InvCGAH6:xor       word ptr es:[si],ax

InvCGAH9:pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

; -----------------------------------------------------------------------------
;                Inverze sloupce bod kurzoru mdu CGA
;        (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak)
; -----------------------------------------------------------------------------

InvCGAV: push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

         jcxz      InvCGAV5                  ; nen dn znak

                                          ;* bitov pozice v bajtu
         mov       di,bx                    ; pozice
         and       di,7                     ; bitov pozice v bajtu
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; pepoet na bajty

                                          ;* vpoet adresy linky ve VRAM
         push      dx
         cmp       byte ptr ds:[Vmod],17
         je        InvCGAV1
         shr       dx,1                     ; poet linek / 2
         jnc       InvCGAV1                 ; je sud linka
         xor       si,2000h                 ; korekce adresy
InvCGAV1:mov       ax,80                    ; poet bajt na dek
         mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; piten adresy linky
         add       si,bx                    ; piten pozic
         cmp       byte ptr ds:[Vmod],6
         jae       InvCGAV4                 ; je videomd 6 nebo 17
         add       si,bx
InvCGAV4:pop       dx

         push      cx
         mov       cx,di                    ; bitov pozice
         mov       ax,80h                   ; maska pro videomd 6
         shr       ax,cl                    ; rotace masky na pozici
         pop       cx

         cmp       byte ptr ds:[Vmod],6
         jae       InvCGAV2                 ; je videomd 6 nebo 17

         push      cx
         mov       cx,di                    ; bitov pozice
         mov       ax,0c000h                ; maska pro ostatn videomdy
         shr       ax,cl
         shr       ax,cl                    ; rotace masky na pozici
         xchg      ah,al                    ; nastaven bajt na sprvnou pozici
         pop       cx

InvCGAV2:xor       word ptr es:[si],ax      ; inverze bajtu kurzoru
         cmp       byte ptr ds:[Vmod],17
         je        InvCGAV6
         xor       si,2000h
         test      dx,1                     ; je sud linka ?
         jz        InvCGAV3                 ; je sud linka
InvCGAV6:add       si,80                    ; zven adresy bitu
InvCGAV3:inc       dx                       ; zven sla linky
         loop      InvCGAV2                 ; dal znak

InvCGAV5:pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret


; -----------------------------------------------------------------------------
;            Inverze linky kurzoru mdu MCGH
;     (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak, AX=prustek)
; -----------------------------------------------------------------------------

InvMCGV: push      di
         mov       di,ds:[MaxSir]           ; prustek
         jmp       short InvMCG0

InvMCGH: push      di
         mov       di,1                     ; prustek

InvMCG0: push      ax
         push      cx
         push      dx
         push      si

         jcxz      InvMCG5                  ; nen dn znak

                                          ;* vpoet adresy linky ve VRAM
         mov       ax,ds:[MaxSir]           ; poet bajt na dek
         mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; piten adresy linky
         add       si,bx                    ; piten pozic

         mov       al,0fh                   ; maska pro inverzi

InvMCG2: xor       byte ptr es:[si],al      ; inverze bajtu kurzoru
         add       si,di
         loop      InvMCG2                  ; dal znak

InvMCG5: pop       si
         pop       dx
         pop       cx
         pop       ax
         pop       di
         ret

; -----------------------------------------------------------------------------
;            Inverze bajtu kurzoru mdu EGA horizontln
;          (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak)
; -----------------------------------------------------------------------------

InvEGAH: push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

         cli                                ; zkaz peruen
         push      dx
                                          ;* volba zpisovch rovin
         mov       dx,03c4h
         mov       al,2
         out       dx,al
         inc       dx
         mov       al,0ffh
         out       dx,al

                                          ;* nastaven zpisovho mdu 2
         mov       dx,03ceh
         mov       al,5
         out       dx,al                    ; registr mdu ten a zpisu
         inc       dx
         mov       al,2
         out       dx,al                    ; zpisov md 2
         dec       dx

                                          ;* nastaven reimu XOR
         mov       al,3
         out       dx,al
         inc       dx
         mov       al,18h
         out       dx,al                    ; nastaven reimu XOR
         dec       dx

                                          ;* volba rovin pro zpis
         mov       al,0
         out       dx,al                    ; registr 0
         inc       dx
         mov       al,0ffh                  ; vechny roviny
         out       dx,al                    ; volba rovin pro zpis
         dec       dx

                                         ;* volba rovin pro XOR
         mov       al,1
         out       dx,al                    ; registr 1
         inc       dx
         mov       al,0ffh
         out       dx,al                    ; vechny roviny XOR

         pop       dx
         sti                                ; povolen peruen

                                          ;* bitov pozice v bajtu
         mov       di,bx                    ; pozice
         and       di,7                     ; bitov pozice v bajtu
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; pepoet na bajty

                                          ;* vpoet adresy linky ve VRAM
         mov       ax,80                    ; poet bajt na dek
         cmp       byte ptr ds:[Vmod],13    ; videomd 13 ?
         jne       InvEGAH0                 ; nen 13
         mov       al,40                    ; 40 bajt na dek
InvEGAH0:mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; piten adresy linky
         add       si,bx                    ; piten pozic

                                          ;* bitov maska pro zpis
         mov       dx,03ceh
         mov       al,8
         out       dx,al                    ; registr masky rovin
         inc       dx

         push      cx
         mov       cx,di                    ; bitov pozice
         mov       al,0ffh                  ; maska
         shr       al,cl                    ; rotace masky na pozici
         pop       cx
         out       dx,al                    ; maska pro zpis

                                          ;* zobrazen sti z prvnho bajtu
         jcxz      InvEGAH5                 ; nen dn bod

         mov       al,0ffh
         xchg      al,es:[si]               ; inverze prvnho bajtu kurzoru
         mov       al,0ffh
         out       dx,al                    ; vechny bity

         add       cx,di                    ; piten prvn osmice
         sub       cx,8                     ; odeten bit z prvnho bajtu
         jc        InvEGAH2                 ; nen dal bajt

         inc       si                       ; zven adresy

                                          ;* zobrazen vnitnch bajt kurzoru
InvEGAH1:mov       al,0ffh                  ; maska
         xchg      al,es:[si]               ; inverze bit v bajtu
         sub       cx,8                     ; odeten osmice bit
         jc        InvEGAH2                 ; je ji peteen
         inc       si                       ; adresa dalho znaku
         jmp       short InvEGAH1           ; je dal bajt

                                          ;* vymazn pebytench bit
InvEGAH2:add       cx,8                     ; nvrat potu zbylch bit
         mov       al,0ffh                  ; maska
         shr       al,cl                    ; rotace masky na pozici
         out       dx,al
         mov       al,0ffh
         xchg      al,es:[si]
         mov       al,0ffh
         out       dx,al

InvEGAH5:
         cli                                ; zkaz peruen

                                          ;* nastaven zpisovho mdu
         mov       dx,03ceh
         mov       al,5
         out       dx,al                    ; registr mdu ten a zpisu
         inc       dx
         mov       al,0
         cmp       byte ptr ds:[Vmod],15
         jne       InvEGAH3
         add       al,10h
InvEGAH3:out       dx,al                    ; zpisov md 0
         dec       dx

                                          ;* nastaven normlnho reimu
         mov       al,3
         out       dx,al
         inc       dx
         mov       al,0
         out       dx,al                    ; nastaven normlnho reimu
         dec       dx

                                         ;* volba rovin pro XOR
         mov       al,1
         out       dx,al                    ; registr 1
         inc       dx
         mov       al,0
         out       dx,al                    ; dn rovina XOR
         dec       dx

         sti                                ; povolen peruen

         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

; -----------------------------------------------------------------------------
;             Inverze bajtu kurzoru mdu EGA vertikln
;          (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak)
; -----------------------------------------------------------------------------

InvEGAV: push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

         cli                                ; zkaz peruen
         push      dx
                                          ;* volba zpisovch rovin
         mov       dx,03c4h
         mov       al,2
         out       dx,al
         inc       dx
         mov       al,0ffh
         out       dx,al

                                          ;* nastaven zpisovho mdu 2
         mov       dx,03ceh
         mov       al,5
         out       dx,al                    ; registr mdu ten a zpisu
         inc       dx
         mov       al,2
         out       dx,al                    ; zpisov md 2
         dec       dx

                                          ;* nastaven reimu XOR
         mov       al,3
         out       dx,al
         inc       dx
         mov       al,18h
         out       dx,al                    ; nastaven reimu XOR
         dec       dx

                                          ;* volba rovin pro zpis
         mov       al,0
         out       dx,al                    ; registr 0
         inc       dx
         mov       al,0ffh                  ; vechny roviny
         out       dx,al                    ; volba rovin pro zpis
         dec       dx

                                         ;* volba rovin pro XOR
         mov       al,1
         out       dx,al                    ; registr 1
         inc       dx
         mov       al,0ffh
         out       dx,al                    ; vechny roviny XOR
         dec       dx

         mov       al,8
         out       dx,al                    ; volba registru 8
         inc       dx

         push      cx
         mov       cl,bl
         and       cl,7                     ; bitov pozice
         mov       al,80h
         shr       al,cl
         pop       cx
         out       dx,al                    ; nastaven bitov masky

         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; pepoet na bajty

         pop       dx
         sti                                ; povolen peruen

         jcxz      InvEGAV5                 ; nen dn linka


                                          ;* vpoet adresy linky ve VRAM
         mov       ax,80                    ; poet bajt na dek
         cmp       byte ptr ds:[Vmod],13    ; videomd 13 ?
         jne       InvEGAV0                 ; nen 13
         mov       al,40                    ; 40 bajt na dek
InvEGAV0:mov       di,ax                    ; prustek adresy
         mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; piten adresy linky
         add       si,bx                    ; piten pozic

                                          ;* zobrazen kurzoru
InvEGAV1:mov       al,0ffh                  ; maska
         xchg      al,es:[si]               ; inverze bit v bajtu
         add       si,di                    ; adresa dalho znaku
         loop      InvEGAV1                 ; dal linka

InvEGAV5:
         cli                                ; zkaz peruen

                                          ;* nastaven zpisovho mdu
         mov       dx,03ceh
         mov       al,5
         out       dx,al                    ; registr mdu ten a zpisu
         inc       dx
         mov       al,0
         cmp       byte ptr ds:[Vmod],15
         jne       InvEGAV3
         add       al,10h
InvEGAV3:out       dx,al                    ; zpisov md 0
         dec       dx

                                          ;* nastaven normlnho reimu
         mov       al,3
         out       dx,al
         inc       dx
         mov       al,0
         out       dx,al                    ; nastaven normlnho reimu
         dec       dx

                                         ;* volba rovin pro XOR
         mov       al,1
         out       dx,al                    ; registr 1
         inc       dx
         mov       al,0
         out       dx,al                    ; dn rovina XOR
         dec       dx

         sti                                ; povolen peruen

         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret


; -----------------------------------------------------------------------------
; -----------------------------------------------------------------------------

InvPCJH:  clc
         ret

InvPCJV:
         clc
         RET

ReadPCJ:
         clc
         ret


; -----------------------------------------------------------------------------
;        ten skupiny bajt z videopamti do vstupnho bufferu
;     (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak, AX=rovina)
; -----------------------------------------------------------------------------
                                          ;* ten v textovm mdu
ReadTxt: push      ax
         push      cx
         push      dx
         push      si
         push      di

         jcxz      ReadTxt2                 ; nen dn znak
         mov       di,ax                    ; rovina

         mov       ax,ds:[MaxSir]           ; poet bajt na dek
         mul       dx                       ; pepoet dk na pozice
         add       ax,bx                    ; piten pozic
         shl       ax,1                     ; pevod na offset ve VRAM
         add       si,ax                    ; adresa ve videopamti
         add       si,di                    ; posun na pslunou rovinu
ReadTxt1:mov       al,es:[si]               ; bajt z poadovan roviny
         call      WritB                    ; zpis bajtu do bufferu
         add       si,2                     ; adresa dalho znaku
         loop      ReadTxt1                 ; dal znak

ReadTxt2:pop       di
         pop       si
         pop       dx
         pop       cx
         pop       ax
         ret

; -----------------------------------------------------------------------------
;        ten skupiny bajt z videopamti CGA do vstupnho bufferu
;           (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak)
; -----------------------------------------------------------------------------

ReadCGA:
         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

         jcxz      ReadCGA6                 ; nen dn bod

                                          ;* korekce pro videomdy 320x200
         cmp       byte ptr ds:[VMod],6
         jae       ReadCGAx
         add       bx,bx                    ; pozice * 2 pro videomdy 320x200
         add       cx,cx                    ; poet znak -> poet bajt

                                          ;* adresa pro lichou/sudou linku
ReadCGAx:cmp       byte ptr ds:[VMod],17     ; je videomd 17 ?
         je        ReadCGA0                 ; je md 17 - nen posun o 2000h
         shr       dx,1                     ; je to lich linka ?
         jnc       ReadCGA0                 ; je to sud linka
         xor       si,2000h                 ; druh st videopamti

                                          ;* stanoven bitov pozice
ReadCGA0:mov       di,bx                    ; poten bod
         and       di,7                     ; offset potenho bodu
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; pepoet na bajty

                                          ;* vpoet adresy ve videpamti
         mov       ax,80                    ; poet bajt na dek
         mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; adresa ve videopamti
         add       si,bx                    ; piten pozic

                                          ;* ten jednotlivch bajt
ReadCGA1:mov       ax,es:[si]               ; slovo z poadovan roviny
         xchg      ah,al

         push      cx
         mov       cx,di
         shl       ax,cl
         pop       cx
         mov       al,ah

         sub       cx,8
         jc        ReadCGA3

         call      WritB                    ; zpis bajtu do bufferu
         inc       si                       ; adresa dalho bajtu
         jmp       short ReadCGA1

ReadCGA3:add       cl,8
         jz        ReadCGA6
         mov       ah,0ffh
         shr       ah,cl
         not       ah
         and       al,ah                    ; maskovn poslednho bajtu

         call      WritB                    ; zpis poslednho bajtu

ReadCGA6:pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

; -----------------------------------------------------------------------------
;        ten skupiny bajt z videopamti MCG do vstupnho bufferu
;            (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak)
; -----------------------------------------------------------------------------

ReadMCG: push      ax
         push      cx
         push      dx
         push      si

         jcxz      ReadMCG6                 ; nen dn znak

         mov       ax,320                   ; poet bajt na dek
         mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; adresa ve videopamti
         add       si,bx                    ; piten pozice

ReadMCG1:mov       al,es:[si]               ; bajt z displeje
         inc       si                       ; zven adresy ve videopamti
         call      WritB                    ; zpis bajtu do bufferu
         loop      ReadMCG1                 ; dal znak

ReadMCG6:pop       si
         pop       dx
         pop       cx
         pop       ax
         ret

; -----------------------------------------------------------------------------
;        ten skupiny bajt z videopamti EGA do vstupnho bufferu
;   (BX=pozice, DX=dek, ES:SI=VRAM, CX=poet znak, AX=rovina)
; -----------------------------------------------------------------------------

ReadEGA:

         push      ax
         push      bx
         push      cx
         push      dx
         push      si
         push      di

         jcxz      ReadEGA6                 ; nen dn znak

         mov       di,ax                    ; rovina

                                          ;* nastaven techo mdu
         push      dx

         mov       dx,03ceh
         mov       al,5
         out       dx,al                    ; registr mdu
         inc       dx
         mov       al,0
         out       dx,al                    ; md ten 0
         dec       dx

                                          ;* nastaven tec roviny
         mov       al,4
         out       dx,al                    ; registr tec mapy
         inc       dx
         mov       ax,di                    ; rovina ke ten
         out       dx,al

         pop       dx


                                          ;* stanoven bitov pozice
         mov       di,bx                    ; poten bod
         and       di,7                     ; offset potenho bodu
         shr       bx,1
         shr       bx,1
         shr       bx,1                     ; pepoet na bajty

                                          ;* vpoet adresy linky ve VRAM
         mov       ax,80                    ; poet bajt na dek
         cmp       byte ptr ds:[Vmod],13     ; videomd 13 ?
         jne       ReadEGA1                 ; nen 13
         mov       al,40                    ; 40 bajt na dek
ReadEGA1:mul       dx                       ; pepoet dk na pozice
         add       si,ax                    ; adresa ve videopamti
         add       si,bx                    ; piten pozic

                                          ;* ten jednotlivch bajt
ReadEGA2:mov       ax,es:[si]               ; slovo z poadovan roviny
         xchg      ah,al

         push      cx
         mov       cx,di
         shl       ax,cl
         pop       cx
         mov       al,ah

         sub       cx,8
         jc        ReadEGA3

         call      WritB                    ; zpis bajtu do bufferu
         inc       si                       ; adresa dalho bajtu
         jmp       short ReadEGA2

ReadEGA3:add       cl,8
         jz        ReadEGA6
         mov       ah,0ffh
         shr       ah,cl
         not       ah
         and       al,ah                    ; maskovn poslednho bajtu

         call      WritB                    ; zpis poslednho bajtu

ReadEGA6:
         mov       dx,3ceh
         mov       al,1
         out       dx,al
         inc       dx
         mov       al,0
         out       dx,al

         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         pop       ax
         ret

; -----------------------------------------------------------------------------


;
;writek:                                     ; zpis bajtu v kompresnm mdu
;                                            ; VSTUP: AL=bajt (pokud CN)
;                                            ;        CY=nen dal bajt
;
;         jc        writek0                  ; vyprzdnn buffer
;         test      byte ptr cs:[verze],1    ; je kompresn md ?
;         jnz       writek1                  ; je kompresn md
;         jmp       writeb                   ; zpis bajtu bez komprese
;
;writek0: test      byte ptr cs:[verze],1    ; je kompresn md ?
;         stc
;         jnz       writek1                  ; je kompresn md
;         jmp       writeb                   ; zpis bajtu bez komprese
;writek1: push      ax
;         push      bx
;         push      cx
;         push      dx
;         push      di
;         push      ds
;         push      es
;         push      cs
;         pop       ds
;         push      cs
;         pop       es
;         jnc       writek5                  ; nen vyprzdnn bufferu
;                                           ;* vypprzdnn buffer
;         call      flush                    ; vyprzdnn obou buffer
;         stc                                ; pznak nulovn buffer
;         call      writeb                   ; nulovn bufferu
;         jmp       writek8                  ; nvrat z obsluhy
;
;writek5: cmp       byte ptr ds:[citeq],0    ; je njak shodn bajt ?
;         jne       writek2                  ; v bufferu je ji njak bajt
;         mov       byte ptr ds:[byteeq],al  ; uloen shodnho bajtu
;         inc       byte ptr ds:[citeq]      ; zven tae shodnch bajt
;         jmp       writek8                  ; nvrat
;
;writek2: cmp       byte ptr ds:[byteeq],al  ; je shoda bajtu ?
;         jne       writek3                  ; nen shodn bajt
;         inc       byte ptr ds:[citeq]      ; zven potu shodnch bajt
;         cmp       byte ptr ds:[citeq],255  ; je dosaeno plnho potu bajt ?
;         jnz       writek8                  ; nen jet dosaeno potu bajt
;         call      flush                    ; vyprzdnn obou buffer
;         jmp       short writek8            ; nvrat
;
;writek3: cmp       byte ptr ds:[citeq],3    ; je dostaten poet bajt ?
;         jb        writek30                 ; nen dostaten poet bajt
;         call      flush                    ; vyprzdnn obou buffer
;         jmp       short writek32           ; uloen novho bajtu
;writek30:call      transeq                  ; vyprzdnn bufferu shodnch dat
;writek32:mov       ds:[byteeq],al           ; uloen novho bajtu
;         inc       byte ptr ds:[citeq]      ; zven tae shodnch bajt
;writek8: pop       es
;         pop       ds
;         pop       di
;         pop       dx
;         pop       cx
;         pop       bx
;         pop       ax
;         ret
;
;transeq:                                    ; pevod shodnch bajt do bufferu
;         push      ax
;         push      di
;         push      cx
;         xor       cx,cx
;         mov       cl,byte ptr ds:[citeq]   ; poet shodnch bajt
;         jcxz      transe3                  ; nen dn bajt v bufferu
;         mov       al,ds:[byteeq]           ; shodn bajt
;transe0: call      storb                    ; uloen bajtu AL do bufferu
;         loop      transe0                  ; dal bajt
;         mov       byte ptr ds:[citeq],cl   ; nulovn potu shodnch bajt
;transe3: pop       cx
;         pop       di
;         pop       ax
;         ret
;
;storb:                                      ; uloen bajtu AL do bufferu
;         push      di
;         mov       di,word ptr ds:[kompc]   ; poet bajt v bufferu
;         and       di,0ffh
;         add       di,offset kompb          ; adresa k uloen bajtu
;         stosb                              ; uloen bajtu do bufferu
;         inc       byte ptr ds:[kompc]      ; zven tae bajt v bufferu
;         cmp       byte ptr ds:[kompc],255  ; dosaeno plnho bufferu ?
;         jne       storb0                   ; nen jet pln buffer
;         call      flushb                   ; vyprzdnn bufferu
;storb0:  pop       di
;         ret
;
;flush:                                      ; vyprzdnn obou buffer
;         call      flushb                   ; vyprzdnn normlnho bufferu
;                                            ; nsleduje vyprzdnn bufferu
;                                            ; shodnch bajt
;
;flusheq:                                    ; vyprzdnn bufferu shodnch bajt
;         push      ax
;         cmp       byte ptr ds:[citeq],0    ; je njak bajt v bufferu ?
;         je        flushe2                  ; v bufferu nen dn bajt
;         cmp       byte ptr ds:[pareq],1    ; je kompresn md ?
;         je        flushe0                  ; je kompresn md
;         xor       al,al
;         call      writeb                   ; zpis bajtu pro pepnut mdu
;flushe0: mov       al,ds:[citeq]            ; poet shodnch bajt
;         mov       byte ptr ds:[pareq],1    ; pznak - je kompresn md
;         cmp       al,255                   ; je trval md ?
;         je        flushe1                  ; je trval md
;         dec       byte ptr ds:[pareq]      ; pznak - je normln md
;flushe1: clc
;         call      writeb                   ; zpis potu bajt
;         mov       al,ds:[byteeq]           ; shodn bajt
;         clc
;         call      writeb                   ; zpis shodnho bajtu
;         mov       byte ptr ds:[citeq],0    ; vynulovn bufferu shodnch bajt
;flushe2: pop       ax
;         ret
;
;flushb:                                     ; vyprzdnn bufferu bajt
;         push      ax
;         push      si
;         push      cx
;         xor       cx,cx
;         mov       cl,ds:[kompc]            ; poet bajt v bufferu
;         jcxz      flushb3                  ; v bufferu nen dn bajt
;         cmp       byte ptr ds:[pareq],0    ; je normln md ?
;         je        flushb0                  ; je normln md
;         xor       al,al
;         call      writeb                   ; zpis bajtu pro pepnut mdu
;flushb0: mov       byte ptr ds:[pareq],0    ; pznak - je normln md
;         cmp       cl,255                   ; je trval md ?
;         je        flushb1                  ; nen trval md
;         inc       byte ptr ds:[pareq]      ; pznak - je kompresn md
;flushb1: mov       si,offset kompc          ; poet bajt + buffer bajt dat
;         inc       cx                       ; + poet bajt
;flushb2: lodsb                              ; bajt k vstupu
;         clc
;         call      writeb                   ; zpis bajtu do souboru
;         loop      flushb2                  ; zpis dalho bajtu
;         mov       byte ptr ds:[kompc],0    ; vynulovn bufferu shodnch bajt
;flushb3: pop       cx
;         pop       si
;         pop       ax
;         ret
;
;
;citeq    db        0                        ; ta shodnch bajt
;byteeq   db        0                        ; uschovan shodn bajt
;
;pareq    db        0                        ; parametr 1=je kompresn md
;
;kompc    db        0                        ; ta rozdlnch bajt v bufferu
;                                            ; 0 = zmna mdu - nen dn bajt
;                                            ; 1 a 254 = zmna mdu s daty
;                                            ;  - v norm. mdu poet nsl. bajt
;                                            ;  - v kompr. mdu poet opakovn
;                                            ;    nsledujcho bajtu
;                                            ; 255 = nsleduje 255 bajt beze
;                                            ;  zmny stavu (jinak jako 1 a 255)
;                                            ; (data zanaj normlnm stavem)
;
;kompb    db        255 dup(0)               ; buffer rozdlnch bajt dat
;                                            ; (mus nsledovat za KOMPC)
;
;writeb:                                     ; zpis bajtu do souboru
;                                            ; VSTUP: AL=bajt (pokud CN)
;                                            ;        CY=nen dal bajt
;
;         push      ax
;         push      bx
;         push      cx
;         push      dx
;         push      di
;         push      ds
;         push      es
;         push      cs
;         pop       ds
;         push      cs
;         pop       es
;         mov       di,ds:[adrbyte]          ; adresa k uloen bajtu
;         jc        writeb1                  ; je konec dat - uloen
;         inc       word ptr ds:[adrbyte]    ; zven adresy k uloen bajtu
;         stosb                              ; uloen bajtu
;         cmp       di,offset sektor0        ; je konec bufferu ?
;         jb        writeb3                  ; nen jet konec bufferu - nvrat
;writeb1: sub       di,offset sektor         ; poten adresa bufferu
;         jz        writeb3                  ; nen dn bajt k uloen
;         mov       cx,di                    ; poet bajt k zpisu
;         mov       bx,ds:[idents]           ; identifikace souboru
;         mov       dx,offset sektor         ; adresa bufferu s daty
;         mov       ah,40h                   ; funkce zpisu do souboru
;         int       21h                      ; zpis sektoru do souboru
;         mov       di,offset sektor         ; zatek bufferu dat
;         mov       ds:[adrbyte],di          ; nov adresa k ukldn dat
;writeb3: pop       es
;         pop       ds
;         pop       di
;         pop       dx
;         pop       cx
;         pop       bx
;         pop       ax
;         ret
;

TabMod   label     word                   ;* tabulka videomd

                                          ;* 0: 40x25 text
         dw        40,25                    ; ka, vka
         db        2,2                      ; poet rovin, typ
         dw        offset InvTxtH           ; inverze skupiny bod horizontln
         dw        offset InvTxtV           ; inverze skupiny bod vertikln
         dw        offset ReadTxt           ; uloen linky do souboru

                                          ;* 1: 40x25 text
         dw        40,25
         db        2,2
         dw        offset InvTxtH
         dw        offset InvTxtV
         dw        offset ReadTxt

                                          ;* 2: 80x25 text
         dw        80,25
         db        2,2
         dw        offset InvTxtH
         dw        offset InvTxtV
         dw        offset ReadTxt

                                          ;* 3: 80x25 text
         dw        80,25
         db        2,2
         dw        offset InvTxtH
         dw        offset InvTxtV
         dw        offset ReadTxt

                                          ;* 4: 320x200/4 graf
         dw        320,200
         db        2,4
         dw        offset InvCGAH
         dw        offset InvCGAV
         dw        offset ReadCGA

                                          ;* 5: 320x200/4 graf
         dw        320,200
         db        2,4
         dw        offset InvCGAH
         dw        offset InvCGAV
         dw        offset ReadCGA

                                          ;* 6: 640x200/2 graf
         dw        640,200
         db        1,4
         dw        offset InvCGAH
         dw        offset InvCGAV
         dw        offset ReadCGA

                                          ;* 7: 80x25 text
         dw        80,25
         db        2,2
         dw        offset InvTXTH
         dw        offset InvTXTV
         dw        offset ReadTXT

                                          ;* 8: 160x200/16 graf.
         dw        160,200
         db        4,4
         dw        offset InvPCJH
         dw        offset InvPCJV
         dw        offset ReadPCJ

                                          ;* 9: 320x200/16 graf.
         dw        320,200
         db        4,4
         dw        offset InvPCJH
         dw        offset InvPCJV
         dw        offset ReadPCJ

                                          ;* 10: 640x200/4 graf.
         dw        640,200
         db        2,4
         dw        offset InvPCJH
         dw        offset InvPCJV
         dw        offset ReadPCJ

                                          ;* 11: intern
         dw        80,25
         db        2,2
         dw        offset InvTxtH
         dw        offset InvTXTV
         dw        offset ReadTxt

                                          ;* 12: intern
         dw        80,25
         db        2,2
         dw        offset InvTxtH
         dw        offset InvTXTV
         dw        offset ReadTxt

                                          ;* 13: 320x200/16 graf
         dw        320,200
         db        4,0
         dw        offset InvEGAH
         dw        offset InvEGAV
         dw        offset ReadEGA

                                          ;* 14: 640x200/16 graf
         dw        640,200
         db        4,0
         dw        offset InvEGAH
         dw        offset InvEGAV
         dw        offset ReadEGA

                                          ;* 15: 640x350/2 graf
         dw        640,350
         db        1,0
         dw        offset InvEGAH
         dw        offset InvEGAV
         dw        offset ReadEGA

                                          ;* 16: 640x350/16 graf
         dw        640,350
         db        4,0
         dw        offset InvEGAH
         dw        offset InvEGAV
         dw        offset ReadEGA

                                          ;* 17: 640x480/2 graf
         dw        640,480
         db        1,4
         dw        offset InvCGAH
         dw        offset InvCGAV
         dw        offset ReadCGA

                                          ;* 18: 640x480/16 graf
         dw        640,480
         db        4,0
         dw        offset InvEGAH
         dw        offset InvEGAV
         dw        offset ReadEGA

                                          ;* 19: 320x200/256 graf
         dw        320,200
         db        8,4
         dw        offset InvMCGH
         dw        offset InvMCGV
         dw        offset ReadMCG


         EVEN                               ; zaokrouhlen na sudou adresu

buffer   label     byte                     ; diskov buffer

; *****************************************************************************
;
;                         Instalace programu
;
; *****************************************************************************

Instal:
                                          ;* zobrazen vodnho textu
         mov       dx,offset UvTxt          ; vodn text
         mov       ah,9
         int       21h                      ; zobrazen vodnho textu

                                          ;* rozlien, zda je karta EGA/VGA
         mov       ah,12h                   ; funkce poskytnut informac EGA
         mov       bx,05e10h                ; podfunkce informac
         int       10h                      ; poskytnut informac EGA/VGA
         cmp       bh,2                     ; md displeje 0 nebo 1
         jae       Inst1                    ; chyba - neplatn obsah registru
         cmp       bl,5                     ; maximln velikost pamti 1 MB
         ja        Inst1                    ; chybn velikost pamti

         inc       byte ptr ds:[ParEGA]     ; pznak videokarty EGA/VGA

Inst1:   cli
                                          ;* instalace peruen INT 08h
         mov       ax,3508h                 ; funkce poskytnut adresy INT 08h
         int       21h                      ; poskytnut adresy INT 08h
         mov       word ptr [old08],bx      ; uloen offsetu adresy
         mov       word ptr [old08+2],es    ; uloen segmentu adresy
         mov       dx,offset int08          ; vlastn obsluha INT 08h
         mov       ax,2508h                 ; funkce nastaven adresy INT 08h
         int       21h                      ; nastaven adresy INT 08h

                                          ;* instalace peruen INT 09h
         mov       ax,3509h                 ; funkce poskytnut adresy INT 09h
         int       21h                      ; poskytnut adresy INT 09h
         mov       word ptr [old09],bx      ; uloen offsetu adresy
         mov       word ptr [old09+2],es    ; uloen segmentu adresy
         mov       dx,offset int09          ; vlastn obsluha INT 09h
         mov       ax,2509h                 ; funkce nastaven adresy INT 09h
         int       21h                      ; nastaven adresy INT 09h

                                          ;* instalace peruen INT 28h
         mov       ax,3528h                 ; funkce poskytnut adresy INT 28h
         int       21h                      ; poskytnut adresy INT 28h
         mov       word ptr [old28],bx      ; uloen offsetu adresy
         mov       word ptr [old28+2],es    ; uloen segmentu adresy
         mov       dx,offset int28          ; vlastn obsluha INT 28h
         mov       ax,2528h                 ; funkce nastaven adresy INT 28h
         int       21h                      ; nastaven adresy INT 28h

                                          ;* instalace pznaku aktivity DOS
         mov       ah,34h
         int       21h                      ; poskytnut pznaku aktivity DOS
         mov       word ptr [aktiv21],bx    ; adresa pznaku aktivity DOS
         mov       word ptr [aktiv21+2],es  ; segment pznaku aktivity DOS

         sti                                ; povolen peruen

         push      cs
         pop       es

                                          ;* schova aktivnho adrese a disku
         mov       ah,19h                   ; funkce poskytnut disku
         int       21h                      ; poskytnut aktivnho disku
         add       byte ptr ds:[Soubor],al  ; oznaen aktivnho disku
         mov       ah,47h                   ; funkce poskytnut adrese
         mov       dl,0                     ; aktivn disk
         mov       si,offset Soubor + 3     ; buffer k naten adrese
         int       21h                      ; poskytnut aktivnho adrese
         dec       si
Inst3:   inc       si                       ; zven ukazatele adrese
         cmp       byte ptr ds:[si],0       ; je konec jmna adrese ?
         jne       Inst3                    ; nalezen konce adrese
         cmp       byte ptr ds:[si-1],"\"   ; je to zkladn adres ?
         je        Inst4                    ; je to zkladn adres
         mov       byte ptr ds:[si],"\"     ; oznaen konce adrese
         inc       si                       ; peskoen znaku "\"
Inst4:   mov       di,si                    ; adresa k uloen jmna souboru
         mov       si,offset Soubor0        ; jmno souboru
         mov       cx,offset(Soubor1-Soubor0)
         cld
         rep       movsb                    ; penos jmna souboru
         sub       di,6                     ; adresa konce sla
         mov       ds:[AdrSoub],di          ; adresa sla souboru

         mov       dx,offset(Instal+BufSize) ; konec programu
         int       27h                      ; instalace jako rezidentn


Soubor0  db        'ANIM0001.SCR',0         ; jmno souboru
Soubor1  label     byte




UvTxt    db        'ANIMSCR V1.0 - snimani obrazovky; (c) Miroslav Nemecek',13,10
         db        '======================================================',13,10
         db        '   <Ctrl>-<Print Screen> = ulozeni vyrezu obrazovky',13,10
         db        '$'

code     ENDS
         END       start                    ; startovac adresa
