
; 
;
;                     Ovlada displeje pro KONTEXT
;
; 

; Po pekladu od adresy 0 m jmno SCREEN.OVL

bit0     EQU       1
bit1     EQU       2
bit2     EQU       4
bit3     EQU       8
bit4     EQU       10h
bit5     EQU       20h
bit6     EQU       40h
bit7     EQU       80h
HI       EQU       256

Code     SEGMENT
         ASSUME    cs:code,ds:code

; *****************************************************************************
;
;                         vstupn bod do ovladae
;
; *****************************************************************************

Screen   PROC      FAR                      ; vstupn bod do ovladae
                                            ; - slo funkce je v BX
         push      ds

         push      cs
         pop       ds                       ; DS <- segment programu
         shl       bx,1                     ; slo funkce BX * 2
         call      word ptr ds:[bx+AdrSub]  ; vyvoln podprogramu podle tabulky

         pop       ds
         ret                                ; nvrat z driveru RET FAR

Screen   ENDP

AdrSub   dw        Fnc00                    ; funkce 00 - vstup znaku
         dw        Fnc01                    ; funkce 01 - kurzor, mazn
         dw        Fnc02                    ; funkce 02 - rolovn nahoru
         dw        Fnc03                    ; funkce 03 - rolovn dol
         dw        Fnc04                    ; funkce 04 - prav okraj (ra)
         dw        Fnc05                    ; funkce 05 - inicializace parametr
         dw        Fnc06                    ; funkce 06 - nastaven text. mdu
         dw        Fnc07                    ; funkce 07 - adr. npovdy (ES:SI)
         dw        Fnc08                    ; funkce 08 - adr. chybovch hlen
         dw        Fnc09                    ; funkce 09 - rozdlovn slov
         dw        Fnc10                    ; funkce 10 - dekdovn kdu klves
         dw        Fnc11                    ; funkce 11 - vpis kdu klvesy

; *****************************************************************************
;
;                                  data
;
; *****************************************************************************
;
TypCard  db        0                        ; typ videokarty
                                            ;   0=neinicializovno
                                            ;   1=HGC (Hercules)
                                            ;   2=CGA
                                            ;   3=EGA
                                            ;   4=VGA

Karta    db        'TXT',0
         db        'HGC',0
         db        'CGA',0
         db        'EGA',0
         db        'VGA',0

OldVMod  db        3                        ; uschovan pvodn videomd
AktVMod  db        6                        ; grafick videomd
TxtVMod  db        3                        ; textov videomd

AdrVRAM  dw        0b800h                   ; segment videopamti
Pozic    dw        80                       ; poet pozic na dek
Radku    dw        25                       ; poet dk displeje
Vyska    db        8                        ; poet linek na textov dek

AdrLFont dw        Fnt6x8                   ; font pro zmenen psmo
VyskaL   db        6                        ; poet linek na zmenen font
AdrFont  dw        Fnt8x8                   ; adresa fontu

ChrBuf   db        0,0,0,0,0,0,0,0,0,0      ; buffer pro vstup znaku
         db        0,0,0,0,0,0,0,0,0
ChrBuf2  db        0,0,0,0,0,0,0,0,0,0      ; prav polovina irokho znaku
         db        0,0,0,0,0,0,0,0,0

Whide    db        0                        ; 80h=dvojnsobn ka znaku
Mode     db        0                        ; reim obrazovky (1,2,3)

; ------ definice barevnch rovin pro md EGA a VGA

InvMsk   db        0                        ; maska znak (pro inverzi)
PlanNg   db        0                        ; roviny pro negaci znaku (kurzor)
Planes   db        0                        ; roviny EGA pro vstup znaku

; ------ barvy psma pro textov videomd

Normal   db        0                        ; barva normlnho textu
Invert   db        0                        ; barva textu menu
Cara     db        0                        ; barva okraje (hnd)
Zvyraz   db        0                        ; zvraznn psmo (lut)
Sikme    db        0                        ; ikm psmo (zelen)
Podtrz   db        0                        ; podtren psmo (fialov)
Jine     db        0                        ; jin kombinace typ (bl)

AdrRow   dw        61 DUP (0)               ; tabulka adres dk na displeji

; *****************************************************************************
;
;                       Funkce 00: Vstup znaku
;
; -----------------------------------------------------------------------------
; VSTUP: SS:[BP+4] (2) dek (0...)
;        SS:[BP+6] (2) pozice (1...)
;        SS:[BP+8] (2) znak k zobrazen
;        AH=md zobrazen znaku
;                       bit 0: 1=nadsazen
;                       bit 1: 1=podsazen
;                       bit 2: 1=kurzva
;                       bit 3: 1=podtren
;                       bit 4: 1=zvraznn
;                       bit 5: 1=inverze
;                       bit 6: 1=rozdlen
;                       bit 7: 1=irok psmo
; *****************************************************************************
;
Fnc00    PROC      NEAR

; ------ kontrola, zda je povolen pozice znaku

         xor       cx,cx                    ; CX <- 0
         mov       dx,[bp+6]                ; pozice znaku na dku
         dec       dx
         js        Fnc001                   ; nepovolen pozice
         cmp       dx,ds:[Pozic]            ; je povolen pozice ?
         jae       Fnc001                   ; nen povolen pozice

; ------ pznak dvojnsobn ky znaku

         mov       al,ss:[bp+8]             ; znak k vstupu
         cmp       al,0ffh                  ; je znak pro dvojnsobnou ku ?
         jne       Fnc0013                  ; nen dvojnsobn ka
         cmp       byte ptr ds:[Mode],1     ; je textov md ?
         je        Fnc0012                  ; je textov md
         mov       cl,80h                   ; nastaven pznaku dvojit ky
Fnc001:  mov       [Whide],cl               ; pznak dvojnsobnho znaku
         ret                                

; ------ v textovm mdu se zobraz nhradn znak "_"

Fnc0012: mov       al,"_"                   ; nhradn znak (nebo me bt 22)

; ------ zobrazen znaku v textovm reimu

Fnc0013: cmp       byte ptr ds:[Mode],1     ; je textov md ?
         jne       Fnc002                   ; nen textov md

         cld
         mov       di,[bp+4]                ; dek znaku
         shl       di,1                     ; DI = poet linek * 2
         mov       di,[di+AdrRow]           ; peten adresy linky
         dec       di
         dec       di
         add       di,[bp+6]
         add       di,[bp+6]                ; pozice znaku na dku
         mov       es,ds:[AdrVRAM]          ; adresa videopamti
         stosb                              ; uloen znaku

         mov       al,ds:[Normal]           ; bn barva
         test      ah,bit0+bit1+bit2+bit3+bit4+bit5 ; jsou njak atributy ?
         jz        Fnc0016                  ; je normln barva

         mov       al,ds:[Invert]           ; inverzn psmo
         test      ah,bit5                  ; je inverzn psmo ?
         jnz       Fnc0016                  ; je inverzn psmo

         mov       al,ds:[Zvyraz]           ; zvraznn
         test      ah,bit4
         jnz       Fnc0016                  ; je zvraznn psmo

         mov       al,ds:[Sikme]            ; kurzva
         test      ah,bit2
         jnz       Fnc0016                  ; je kurzva

         mov       al,ds:[Podtrz]           ; podtren
         test      ah,bit3                  ; je podtren ?
         jnz       Fnc0016                  ; je podtren

         mov       al,ds:[Jine]             ; jin psmo
Fnc0016: stosb                              ; uloen barvy znaku
         ret

; ------ pprava k dekdovn znaku

Fnc002:  push      cs
         pop       es                       ; ES = DS
         cld                                ; smr penosu dat nahoru
         mov       di,offset ChrBuf         ; buffer k dekdovn znaku
         test      ah,bit0+bit1             ; je nadsazen nebo podsazen ?
         jnz       Fnc003                   ; je nadsazen nebo podsazen

; ------ pprava znaku v bnm fontu

         mov       cl,ds:[Vyska]            ; poet bajt na znak
         push      ax
         mul       cl                       ; offset v tabulce fontu
         add       ax,ds:[AdrFont]          ; adresa znaku v tabulce font
         xchg      ax,si                    ; SI <- adresa fontu
         rep       movsb                    ; penos znaku do bufferu
         pop       ax
         jmp       short Fnc005

; ------ adresa zmenenho fontu

Fnc003:  mov       cl,ds:[VyskaL]           ; poet bajt na zmenen font
         push      ax
         mul       cl                       ; offset zmenenho znaku
         add       ax,ds:[ADrLFont]         ; adresa zmenenho fontu
         xchg      ax,si                    ; SI <- adresa fontu
         pop       ax

; ------ dekdovn nadsazen

         mov       al,0                     ; nulovac bajt
         test      ah,bit0                  ; je nadsazen ?
         jz        Fnc004                   ; nen nadsazen
         rep       movsb                    ; penos zmenenho znaku
         mov       cl,ds:[Vyska]            ; vka znaku
         sub       cl,ds:[VyskaL]           ; zbvajc poet linek
         rep       stosb                    ; vymazn zbytku znaku
         jmp       short Fnc005

; ------ dekdovn podsazen

Fnc004:  mov       cl,ds:[Vyska]            ; vka znaku
         sub       cl,ds:[VyskaL]           ; zbvajc poet linek
         rep       stosb                    ; vymazn zbytku znaku
         mov       cl,ds:[VyskaL]           ; vka zmenenho znaku
         rep       movsb                    ; penos zmenenho znaku

; ------ kurzva

Fnc005:  mov       si,offset ChrBuf         ; buffer znaku
         mov       cl,ds:[Vyska]            ; vka znaku
         test      ah,bit2                  ; je kurzva ?
         jz        Fnc006                   ; nen kurzva
         push      cx
         mov       cl,2
Fnc005K: call      Kurziv8                  ; proveden kurzvy
         pop       cx

; ------ zvraznn

Fnc006:  test      ah,bit4
         jz        Fnc0062

         push      cx
         push      si                       ; adresa znaku v bufferu

Fnc0061: lodsb                              ; 1 linka znaku
         shr       al,1
         or        [si-1],al                ; zvraznn znaku
         loop      Fnc0061                  ; dal linka znaku

         pop       si
         pop       cx

; ------ podtren

Fnc0062: test      ah,bit3
         jz        Fnc0063

         push      si
         add       si,cx
         mov       byte ptr ds:[si-1],-1
         mov       byte ptr ds:[si-1+ChrBuf2-ChrBuf],-1
         pop       si

; ------ dvojnsobn ka psma

Fnc0063: or        ah,[Whide]               ; pznak dvojnsobnho znaku
         jns       Fnc0066                  ; nen dvojnsobn ka znaku

         push      cx
         push      si                       ; adresa znaku v bufferu

Fnc0064: mov       bh,8                     ; poet bit znaku = 8
         lodsb                              ; linka znaku
Fnc0065: shr       al,1                     ; rotace linky vpravo, kopie do CF
         rcr       dx,1                     ; rotace bitu CF do reg. DX
         sar       dx,1                     ; rotace vpravo ze znamnkovho bitu
         dec       bh                       ; ta bit k rotaci
         jnz       Fnc0065                  ; dal bit k rotaci
         mov       [si-1],dh                ; lev polovina znaku
         mov       [si+ChrBuf2-ChrBuf-1],dl ; prav polovina znaku
         loop      Fnc0064
         dec       word ptr ss:[bp+6]       ; snen pozice znaku na displeji
         mov       [Whide],cl               ; pznak dvojnsobnho znaku = 0

         pop       si
         pop       cx

; ------ rozdlen znaku

Fnc0066: test      ah,bit6                  ; je rozdlovac znamnko ?
         jz        Fnc007                   ; nen rozdlovac znamnko

         push      cx
         push      si                       ; adresa znaku v bufferu

         mov       al,1
Fnc0067: or        ds:[si],al               ; oznaen rozdlen znaku
         inc       si
         loop      Fnc0067                  ; dal linka znaku

         pop       si
         pop       cx

; ------ pprava adresy na displeji

Fnc007:  mov       di,[bp+4]                ; dek znaku
         shl       di,1                     ; DI = poet linek * 2
         mov       di,[di+adrrow]           ; peten adresy linky
         add       di,[bp+6]                ; pozice znaku na dku
         mov       es,ds:[AdrVRAM]          ; adresa videopamti
         mov       bh,[InvMsk]              ; maska pro vstup (pro inverzi)

; ------ rozlien, zda je videomd EGA/VGA

         push      cx
         test      ah,bit5                  ; pznak inverznho znaku
         jz        Fnc0071
         not       bh                       ; inverzn znak
Fnc0071: cmp       byte ptr ds:[TypCard],2
         jbe       Fnc008                   ; je CGA nebo HGC

; ------ zobrazen znaku v mdu EGA/VGA

Fnc0072: lodsb                              ; peten bajtu k vstupu DS:SI
         xor       al,bh                    ; filtrace barvy (inverze)
         stosb                              ; uloen sudho bajtu do VRAM ES:DI
         add       di,80-1                  ; dal dek (zven o 80)
         loop      Fnc0072                  ; dal dva bajty znaku

; ------ test, zda nsleduje druh polovina irokho znaku

Fnc0074: pop       cx

         xor       ah,80h
         jns       Fnc0075                  ; je irok psmo-penos prav sti
         ret

Fnc0075: inc       word ptr [BP+6]          ; zven pozice
         mov       si,offset ChrBuf2        ; adresa prav poloviny znaku
         jmp       short Fnc0066

; ------ zobrazen znaku v mdu CGA

Fnc008:  jb        Fnc009                   ; je HGC
         shr       cx,1                     ; poet slov k penosu
Fnc0082: lodsb                              ; peten bajtu k vstupu DS:SI
         xor       al,bh                    ; filtrace barvy (inverze)
         stosb                              ; uloen sudho bajtu do VRAM ES:DI
         add       di,2000h-1               ; dal dek
         lodsb                              ; peten druhho bajtu k vstupu
         xor       al,bh                    ; filtrace barvy
         stosb                              ; uloen lichho bajtu do VRAM
         add       di,80 - 2000h - 1        ; dal dek
         loop      Fnc0082                  ; dal dva bajty znaku
         jmp       short Fnc0074

; ------ HGC

Fnc009:  lodsb                              ; peten bajtu k vstupu DS:SI
         xor       al,bh                    ; filtrace barvy (inverze)
         stosb                              ; uloen sudho bajtu do VRAM ES:DI
         dec       cx                       ; snen tae bajt
         jz        Fnc0074
         add       di,2000h-1               ; dal dek
         jns       Fnc009
         add       di,90 - 4*2000h          ; adresa dalho dku
         jmp       short Fnc009             ; dal dva bajty znaku

Fnc00    ENDP

; -----------------------------------------------------------------------------
;        kurzva 6 linek
; -----------------------------------------------------------------------------

Kurziv6  PROC      NEAR

         shr       byte ptr [si],1          ; >> 1
         shr       byte ptr [si+1],1        ; >> 1
                                            ;    0
                                            ;    0
         shl       byte ptr [si+4],1        ; << 1
         shl       byte ptr [si+5],1        ; << 1
         ret

Kurziv6  ENDP

; -----------------------------------------------------------------------------
;        kurzva 8 linek
; -----------------------------------------------------------------------------

Kurziv8  PROC      NEAR

         shr       byte ptr [si],cl         ; >> 2
         shr       byte ptr [si+1],1        ; >> 1
         shr       byte ptr [si+2],1        ; >> 1
                                            ;    0
                                            ;    0
         shl       byte ptr [si+5],1        ; << 1
         shl       byte ptr [si+6],1        ; << 1
         shl       byte ptr [si+7],cl       ; << 2
         ret

Kurziv8  ENDP

; -----------------------------------------------------------------------------
;        kurzva 14 linek
; -----------------------------------------------------------------------------

Kurziv14 PROC      NEAR

         shr       byte ptr [si],cl         ; >> 2
         shr       byte ptr [si+1],cl       ; >> 2
         shr       byte ptr [si+2],cl       ; >> 2
         shr       byte ptr [si+3],1        ; >> 1
         shr       byte ptr [si+4],1        ; >> 1
         shr       byte ptr [si+5],1        ; >> 1
                                            ;    0
                                            ;    0
         shl       byte ptr [si+8],1        ; >> 1
         shl       byte ptr [si+9],1        ; << 1
         shl       byte ptr [si+10],1       ; << 1
         shl       byte ptr [si+11],cl      ; << 2
         shl       byte ptr [si+12],cl      ; << 2
         shl       byte ptr [si+13],cl      ; << 2
         ret

Kurziv14 ENDP

; -----------------------------------------------------------------------------
;        kurzva 19 linek
; -----------------------------------------------------------------------------

Kurziv19 PROC      NEAR

         shr       byte ptr [si],cl         ; >> 2
         shr       byte ptr [si+1],cl       ; >> 2
         shr       byte ptr [si+2],cl       ; >> 2
         shr       byte ptr [si+3],cl       ; >> 2
         shr       byte ptr [si+4],1        ; >> 1
         shr       byte ptr [si+5],1        ; >> 1
         shr       byte ptr [si+6],1        ; >> 1
         shr       byte ptr [si+7],1        ; >> 1
                                            ;    0
                                            ;    0
                                            ;    0
                                            ;    0
         shl       byte ptr [si+12],1       ; << 1
         shl       byte ptr [si+13],1       ; << 1
         shl       byte ptr [si+14],1       ; << 1
         shl       byte ptr [si+15],1       ; << 1
         shl       byte ptr [si+16],cl      ; << 2
         shl       byte ptr [si+17],cl      ; << 2
         shl       byte ptr [si+18],cl      ; << 2
         ret

Kurziv19 ENDP

; *****************************************************************************
;
;                         Funkce 01: Kurzor a mazn
;
; -----------------------------------------------------------------------------
; VSTUP: SS:[BP+4] typ operace
;                       0 = normln okno
;                       1 = inverzn okno
;                       2 = kurzor
;        SS:[BP+6] koncov linka
;        SS:[BP+8] koncov pozice
;        SS:[BP+10] poten linka
;        SS:[BP+12] poten pozice
; *****************************************************************************
;
Fnc01    PROC      NEAR

; ------ poten a koncov dek

         mov       ax,ss:[bp+10]            ; poten dek
         mov       bx,ss:[bp+6]             ; koncov dek
         cmp       ax,bx
         jbe       Fnc011
         cmp       byte ptr ss:[bp+4],2
         jne       Fnc011
         dec       ax
         mov       bx,ax
Fnc011:  sub       bx,ax
         inc       bx                       ; vka okna (dk)

; ------ adresa dku na obrazovce

         mov       di,80                    ; poet znak na dek
         cmp       byte ptr ds:[Mode],1     ; je textov md ?
         je        Fnc0112                  ; je textov md
         cmp       byte ptr ds:[TypCard],3  ; je md EGA/VGA ?
         jae       Fnc0112                  ; je md EGA/VGA
         mov       di,40                    ; prustek adresy pro CGA a HGC
Fnc0112: mul       di                       ; poten adresa
         xchg      ax,di                    ; poten adresa
         mov       es,ds:[AdrVRAM]          ; adresa videopamti

; ------ poten pozice

         mov       ax,ss:[bp+12]            ; poten pozice
         dec       ax                       ; korekce pozice
         jns       Fnc012                   ; pozice je OK
         xor       ax,ax                    ; omezen poten pozice

; ------ ka okna

Fnc012:  mov       cx,ss:[bp+8]             ; koncov pozice
         cmp       cx,ds:[Pozic]            ; je pozice OK ?
         jbe       Fnc013                   ; pozice je OK
         mov       cx,ds:[Pozic]            ; omezen koncov pozice
Fnc013:  sub       cx,ax                    ; ka okna
         jbe       Fnc0149                  ; nen okno
         add       di,ax                    ; poten adresa okna

; ------ test, zda je textov md

         cld
         cmp       byte ptr ds:[Mode],1     ; je textov md ?
         jne       Fnc015                   ; nen textov md

; ------ normln a inverzn okno

         shl       di,1
         cmp       byte ptr ss:[bp+4],1     ; parametr
         ja        Fnc0143                  ; je kurzor
         mov       ah,ds:[Normal]           ; je normln text
         jb        Fnc0141                  ; je inverzn text
         mov       ah,ds:[Invert]           ; inverzn text
Fnc0141: mov       al," "
Fnc0142: push      di
         push      cx
         rep       stosw
         pop       cx
         pop       di

         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         dec       bx
         jnz       Fnc0142
         jmp       short Fnc0149

; ------ zobrazen kurzoru

Fnc0143: push      di
         push      cx                       ; ta znak na dek

Fnc0144: inc       di
         mov       al,es:[di]               ; nastaven atribut
         not       al
         cmp       byte ptr ds:[TypCard],1  ; je MDA ?
         jne       Fnc0145
         not       al
         ror       al,1
         ror       al,1
         ror       al,1
         ror       al,1
Fnc0145: stosb
         loop      Fnc0144

         pop       cx
         pop       di

         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         dec       bx                       ; ta dk
         jnz       Fnc0143                  ; dal dek
Fnc0149: jmp       short Fnc019

; ------ test, zda je md EGA/VGA


Fnc015:  cmp       byte ptr ds:[TypCard],2  ; je karta EGA/VGA ?
         ja        Fnc0152                  ; je karta EGA/VGA
         je        Fnc0151                  ; je karta CGA
         jmp       Fnc015H                  ; je karta HGC
Fnc0151: jmp       Fnc015C                  ; CGA

; ------ nastaven registr pro md EGA

Fnc0152: mov       dx,03CEh                 ; adresov registr grafiky EGA
         mov       al,1                     ; nastaven registru slo 1
         out       dx,al
         inc       dx                       ; adresa dat registru
         mov       al,0fh                   ; nastaven bit pro set/reset
         out       dx,al
         dec       dx                       ; adresov registr grafiky EGA
         mov       al,0
         out       dx,al                    ; nastaven registru slo 0
         inc       dx                       ; adresa dat registru
         mov       ah,[InvMsk]              ; maska znak pro vstup
         cmp       byte ptr [bp+4],1        ; parametr pro zpis okna
         jnc       fnc016                   ; je vymazn okna
         not       ah                       ; negace masky pro vstup
         jmp       short fnc017

Fnc016:  mov       al,0ffh                  ; mazn vech rovin
         jne       fnc018
fnc017:  mov       al,[Planes]              ; roviny pro vstup znaku
         or        ah,ah                    ; negovan maska znak pro vstup
         jnz       fnc018                   ; je negace zpt
         mov       al,[PlanNg]              ; roviny pro negaci znaku (kurzor)
fnc018:  out       dx,al                    ; vbr rovin pro vstup

         push      ds
         mov       es,ds:[AdrVRAM]
         mov       ds,ds:[AdrVRAM]          ; nastaven segmentovch registr
         cld                                ; smr penosu dat vzhru
         inc       al                       ; roviny pro zpis
         jnz       fnc01A                   ; nejsou vechny roviny (tj. mazn)
         dec       dx                       ; adresov registr grafiky EGA
         mov       al,3
         out       dx,al                    ; nastaven registru 3
         inc       dx                       ; datov registr
         mov       al,18h                   ; zpisov md XOR
         out       dx,al

fnc0182: mov       si,di
         push      cx                       ; ka okna k vymazn
         push      di                       ; ukazatel okna
         repnz     movsb                    ; vymazn bajt obrazovky
         pop       di
         pop       cx
         add       di,80                    ; dal linka
         dec       bx                       ; ta linek okna
         jnz       fnc0182                  ; dal linka okna
         jmp       short fnc01B             ; konec

fnc01A:  push      cx
         push      di
         repnz     stosb                    ; uloen negovacho bajtu
         pop       di
         pop       cx
         add       di,80                    ; dal linka
         dec       bx                       ; ta linek
         jnz       fnc01A                   ; dal linka k negaci

fnc01B:  pop       ds
         call      iniega                   ; inicializace displeje
fnc019:  ret

; ------ CGA

Fnc015C: cmp       byte ptr [bp+4],1        ; parametr pro zpis okna
         jbe       fnc015C5                 ; je vymazn okna

fnc015C2:push      cx
         push      di
fnc015C3:not       byte ptr es:[di]         ; invereze kurzoru
         inc       di
         loop      fnc015C3
         pop       di
         pop       cx
         sub       di,1fb0h
         jns       fnc015C4
         add       di,3fb0h
fnc015C4:dec       bx
         jnz       fnc015C2
         jmp       fnc015C9


fnc015C5:mov       al,ds:[invmsk]
         jnz       fnc015C6
         not       al
fnc015C6:push      cx
         push      di
         repnz     stosb                    ; uloen negovacho bajtu
         pop       di
         pop       cx
         sub       di,1fb0h                 ; dal linka
         jns       fnc015C7                 ; dal linka k negaci
         add       di,3fb0h
fnc015C7:dec       bx
         jnz       fnc015C6
fnc015C9:ret

; ------ HGC

Fnc015H: mov       ax,[bp+10]               ; poten linka
         mov       di,ax                    ; DI <- poten linka
         mov       dx,ax                    ; DX <- poten linka
         and       dx,3                     ; slo podlinky
         ror       dx,1
         ror       dx,1
         ror       dx,1                     ; adresa linky 0,2000h,4000h,6000h
         shr       ax,1
         shr       ax,1                     ; slo dku
         mov       cl,90                    ; poet bajt na dek
         mul       cl                       ; adresa dku
         add       ax,dx                    ; poten adresa linky

         mov       dx,[bp+6]                ; koncov linka
         sub       dx,di                    ; vka okna - 1
         inc       dx                       ; vka okna
         mov       di,ax                    ; DI <- poten adresa linky

         mov       ax,[bp+12]               ; poten pozice
         or        ax,ax                    ; je pozice OK ?
         jg        fnc015h1                 ; pozice je OK
         mov       ax,1                     ; omezen poten pozice

fnc015h1:mov       cx,[bp+8]                ; koncov pozice
         cmp       cx,90                    ; kontrola ky okna
         jng       fnc015h2
         mov       cx,90                    ; omezen na max. poet znak 90

fnc015h2:dec       ax
         sub       cx,ax                    ; ka okna
         jng       fnc015h24                ; nen dn okno

         add       di,ax                    ; poten adresa okna
         mov       es,ds:[AdrVRAM]          ; adresa videopamti
         cld
         cmp       byte ptr [bp+4],1
         jna       fnc015h23                ; je normln nebo inverzn okno

; ------ zobrazen kurzoru HGC

fnc015h20:push      cx
         push      di
fnc015h21:not       byte ptr es:[di]
         inc       di
         loop      fnc015h21
         pop       di
         pop       cx
         add       di,2000h
         jns       fnc015h22
         sub       di,7fa6h
fnc015h22:dec       dx
         jnz       fnc015h20
         jmp       short fnc015h24

; ------ zobrazen normlnho nebo inverznho okna HGC

fnc015h23:mov       al,[invmsk]
         jnz       fnc015h25
         not       al
fnc015h25:push      cx
         push      di
         repnz     stosb
         pop       di
         pop       cx
         add       di,2000h
         jns       fnc015h26
         sub       di,7fa6h
fnc015h26:dec       dx
         jnz       fnc015h25
fnc015h24:ret

Fnc01    ENDP

; *****************************************************************************
;
;                    Funkce 02: rolovn okna nahoru
;
; *****************************************************************************
;
                                            ; FUNKCE 02 - rolovn okna nahoru

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = ka okna (pozic)
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna

fnc02:   cmp       byte ptr ds:[Mode],1
         jne       Fnc020                   ; nen textov md

         mov       ax,[bp+4]                ; konen dek k rolovn
         sub       ax,[bp+8]                ; poten dek k rol.-poet dk
         jz        fnc0219                  ; nen dn dek - konec
         mov       bx,ax                    ; poet dk k rolovn
         mov       ax,[bp+8]                ; poten dek k rolovn
         mov       cx,ds:[Pozic]
         add       cx,cx
         mul       cx                       ; poten adresa pot. dku
         mov       si,ax                    ; poten adresa pot. dku
         mov       di,ax                    ; adresa nsledujcho dku
         add       si,ds:[Pozic]
         add       si,ds:[Pozic]
         mov       ax,[bp+10]               ; poten pozice okna
         dec       ax
         add       di,ax                    ; poten adresa
         add       di,ax
         add       si,ax
         add       si,ax
         mov       cx,[bp+6]                ; konen pozice
         sub       cx,ax                    ; poet pozic okna k rolovn
         add       cx,cx
         push      es
         push      ds
;         add       si,word ptr ds:[AdrVRAM]
;         add       di,word ptr ds:[AdrVRAM]
         mov       ax,ds:[AdrVRAM] ; segment displeje
         mov       es,ax
         mov       ds,ax
         cld                                ; penos nahoru
fnc0212: push      si
         push      di
         push      cx
         repnz     movsb
         pop       cx
         pop       di
         pop       si
         add       di,cs:[Pozic]
         add       di,cs:[Pozic]
         add       si,cs:[Pozic]
         add       si,cs:[Pozic]
         dec       bx
         jnz       fnc0212
         pop       ds
         pop       es
fnc0219: ret


fnc020:  cmp       byte ptr ds:[TypCard],2
         jbe       fnc023

         mov       ax,[bp+4]                ; konen dek k rolovn
         mov       si,[bp+8]                ; poten dek k rolovn
         sub       ax,si                    ; poet dk k rolovn
         jz        fnc022                   ; nen dn dek k rolovn
         mul       byte ptr [vyska]         ; vynsoben potem linek na dek
         mov       bx,ax                    ; celkov poet linek k rolovn
         mov       dx,03ceh                 ; adresov registr grafiky EGA
         mov       al,8
         out       dx,al                    ; nastaven registru 08
         inc       dx                       ; datov registr grafiky EGA
         mov       al,0
         out       dx,al                    ; nastaven masky pro vechny roviny
         shl       si,1                     ; poten dek k rolovn
         add       si,offset adrrow         ; tabulka adres dk na displeji
         mov       di,[si]                  ; peten adresy dku
         inc       si
         inc       si
         mov       si,[si]                  ; adresa nsledujcho dku
         mov       ax,[bp+10]               ; poten pozice okna k rolovn
         add       di,ax                    ; koncov adresy okna
         add       si,ax
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,ax
         inc       cx                       ; - konen pozice okna
         push      ds
         mov       ax,0a000h                ; segment pamti EGA
         mov       es,ax                    ; nastaven segment pamti EGA
         mov       ds,ax
         cld                                ; smr penosu dat nahoru
fnc021:  push      si
         push      di
         push      cx                       ; poet bajt k penosu
         repnz     movsb                    ; penos jedn linky okna
         pop       cx
         pop       di
         pop       si
         add       di,80                    ; dal linka
         add       si,80
         dec       bx                       ; ta linek
         jnz       fnc021
         pop       ds
         call      iniega                   ; inicializace displeje EGA
fnc022:  ret

fnc023:  jb        fnc024                   ; je MDA

         mov       ax,[bp+4]                ; konen dek k rolovn
         mov       si,[bp+8]                ; poten dek k rolovn
         sub       ax,si                    ; poet dk k rolovn
         jbe       fnc0232                  ; nen dn dek k rolovn
         mul       byte ptr [vyska]         ; vynsoben potem linek na dek
         shr       ax,1
         shl       si,1                     ; poten dek k rolovn
         add       si,offset adrrow         ; tabulka adres dk na displeji
         mov       di,[si]                  ; peten adresy dku
         inc       si
         inc       si
         mov       si,[si]                  ; adresa nsledujcho dku
         mov       bx,[bp+10]               ; poten pozice okna k rolovn
         add       si,bx
         add       di,bx                    ; koncov adresy okna
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,bx
         inc       cx                       ; - konen pozice okna
         mov       bx,0b800h                ; segment pamti EGA
         mov       es,bx                    ; nastaven segment pamti EGA
         mov       ds,bx
         cld                                ; smr penosu dat nahoru
fnc0231: push      si
         push      di
         push      cx                       ; poet bajt k penosu
         repnz     movsb                    ; penos jedn linky okna
         pop       cx
         pop       di
         pop       si
         add       di,2000h                 ; dal linka
         add       si,2000h
         push      si
         push      di
         push      cx                       ; poet bajt k penosu
         repnz     movsb                    ; penos jedn linky okna
         pop       cx
         pop       di
         pop       si
         sub       di,1fb0h
         sub       si,1fb0h
         dec       ax                       ; ta linek
         jnz       fnc0231
fnc0232: ret

fnc024:  mov       ax,[bp+4]                ; konen dek k rolovn
         mov       si,[bp+8]                ; poten dek k rolovn
         sub       ax,si                    ; poet dk k rolovn
         jz        fnc0242                  ; nen dn dek k rolovn
         mul       byte ptr [vyska]         ; vynsoben potem linek na dek
         mov       bx,ax                    ; celkov poet linek k rolovn
         shl       si,1
         add       si,offset adrrow         ; tabulka adres dk na displeji
         mov       di,[si]                  ; peten adresy dku
         inc       si
         inc       si
         mov       si,[si]                  ; adresa nsledujcho dku
         mov       ax,[bp+10]               ; poten pozice okna k rolovn
         add       di,ax                    ; koncov adresy okna
         add       si,ax
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,ax
         inc       cx                       ; - konen pozice okna
         mov       ax,0b000h                ; segment pamti HGC
         mov       es,ax                    ; nastaven segment pamti EGA
         mov       ds,ax
         cld                                ; smr penosu dat nahoru
fnc0241: push      si
         push      di
         push      cx                       ; poet bajt k penosu
         repnz     movsb                    ; penos jedn linky okna
         pop       cx
         pop       di
         pop       si
         add       di,2000h                 ; dal linka
         jns       fnc02417
         sub       di,7fa6h
fnc02417:add       si,2000h
         jns       fnc02418
         sub       si,7fa6h
fnc02418:
         dec       bx                       ; ta linek
         jnz       fnc0241
fnc0242: ret

; *****************************************************************************
;
;                    Funkce 03: rolovn okna dol
;
; *****************************************************************************
;
                                            ; FUNKCE 03 - rolovn okna dol

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = ka okna (pozic)
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna


fnc03:   cmp       byte ptr ds:[Mode],1
         jne       Fnc032                   ; nen textov md

         mov       ax,[bp+4]                ; konen dek k rolovn
         sub       ax,[bp+8]                ; poten dek k rol.-poet dk
         jz        fnc0319                   ; nen dn dek - konec
         mov       bx,ax                    ; poet dk k rolovn
         mov       ax,[bp+4]                ; konen dek k rolovn
         mov       cx,ds:[Pozic]
         add       cx,cx
         mul       cx                       ; poten adresa konenho dku
         mov       si,ax                    ; poten adresa konenho dku
         mov       di,ax                    ; adresa nsledujcho dku
         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         mov       ax,[bp+10]               ; poten pozice okna
         dec       ax
         add       di,ax                    ; poten adresa
         add       di,ax
         add       si,ax
         add       si,ax
         mov       cx,[bp+6]                ; konen pozice
         sub       cx,ax                    ; poet pozic okna k rolovn
         add       cx,cx
         push      es
         push      ds
         mov       ax,word ptr ds:[AdrVRAM] ; segment displeje
         mov       es,ax
         mov       ds,ax
         cld                                ; penos nahoru
fnc0312:
         sub       di,cs:[Pozic]
         sub       di,cs:[Pozic]
         sub       si,cs:[Pozic]
         sub       si,cs:[Pozic]
         push      si
         push      di
         push      cx
         repnz     movsb
         pop       cx
         pop       di
         pop       si
         dec       bx
         jnz       fnc0312
         pop       ds
         pop       es
fnc0319:  ret


fnc032:  cmp       byte ptr ds:[TypCard],2
         jbe       fnc033

         mov       ax,[bp+4]                ; konen dek k rolovn
         mov       di,ax
         sub       ax,[bp+8]                ; poten dek k rolovn
         jz        fnc0322                   ; je nulov poet dk k rolovn
         mul       byte ptr [vyska]         ; vypoten potu linek k rolovn
         mov       bx,ax                    ; poet linek k rolovn
         mov       dx,03ceh                 ; adresov registr grafiky EGA
         mov       al,8
         out       dx,al                    ; nastaven registru 08
         inc       dx
         mov       al,0
         out       dx,al                    ; nastaven bitov masky vech rovin
         shl       di,1                     ; konen dek k rolovn * 2
         add       di,offset adrrow         ; tabulka adres dk na displeji
         mov       si,[di]                  ; adresa konenho dku k rolovn
         inc       di
         inc       di
         mov       di,[di]                  ; adresa potenho dku k rol.
         mov       ax,[bp+10]               ; poten pozice okna
         add       di,ax                    ; adresa pravho dolnho rohu
         add       si,ax                    ; adresa pravho hornho rohu
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,ax
         inc       cx                       ; - konen pozice okna
         push      ds
         mov       ax,0a000h                ; poten adresa pamti EGA
         mov       es,ax                    ; nastaven segmentu pro EGA
         mov       ds,ax
         cld                                ; smr penosu dat nahoru
fnc0321:  sub       di,80
         sub       si,80
         push      si
         push      di
         push      cx
         repnz     movsb                    ; penos jedn linky
         pop       cx
         pop       di
         pop       si
         dec       bx
         jnz       fnc0321                   ; dal linka k penosu
         pop       ds
         call      iniega                   ; inicializace displeje EGA
fnc0322:  ret

fnc033: jb        fnc034                   ; je MDA

         mov       ax,[bp+4]                ; konen dek k rolovn
         mov       di,ax
         sub       ax,[bp+8]                ; poet dk k rolovn
         jbe       fnc0332                   ; nen dn dek k rolovn
         mul       byte ptr [vyska]         ; vynsoben potem linek na dek
         shr       ax,1
         shl       di,1                     ; poten dek k rolovn
         add       di,offset adrrow         ; tabulka adres dk na displeji
         mov       si,[di]                  ; peten adresy dku
         inc       di
         inc       di
         mov       di,[di]                  ; adresa nsledujcho dku
         mov       bx,[bp+10]               ; poten pozice okna k rolovn
         add       di,bx                    ; koncov adresy okna
         add       si,bx
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,bx
         inc       cx                       ; - konen pozice okna
         mov       bx,0b800h                ; segment pamti EGA
         mov       es,bx                    ; nastaven segment pamti EGA
         mov       ds,bx
         cld                                ; smr penosu dat nahoru
fnc0331:
         add       di,1fb0h
         add       si,1fb0h
         push      si
         push      di
         push      cx                       ; poet bajt k penosu
         repnz     movsb                    ; penos jedn linky okna
         pop       cx
         pop       di
         pop       si
         sub       di,2000h                 ; dal linka
         sub       si,2000h
         push      si
         push      di
         push      cx                       ; poet bajt k penosu
         repnz     movsb                    ; penos jedn linky okna
         pop       cx
         pop       di
         pop       si
         dec       ax                       ; ta linek
         jnz       fnc0331
fnc0332:  ret

fnc034:   mov       ax,[bp+4]                ; konen dek k rolovn
         mov       di,ax
         sub       ax,[bp+8]                ; poten dek k rolovn
         jna       fnc0342                   ; je nulov poet dk k rolovn
         mul       byte ptr [vyska]         ; vypoten potu linek k rolovn
         mov       bx,ax                    ; poet linek k rolovn
         shl       di,1                     ; konen dek k rolovn * 2
         add       di,offset adrrow         ; tabulka adres dk na displeji
         mov       si,[di]                  ; adresa konenho dku k rolovn
         inc       di
         inc       di
         mov       di,[di]                  ; adresa potenho dku k rol.
         mov       ax,[bp+10]               ; poten pozice okna
         add       di,ax                    ; adresa pravho dolnho rohu
         add       si,ax                    ; adresa pravho hornho rohu
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,ax
         inc       cx                       ; - konen pozice okna
         mov       ax,0b000h                ; poten adresa pamti EGA
         mov       es,ax                    ; nastaven segmentu pro EGA
         mov       ds,ax
         cld                                ; smr penosu dat nahoru
fnc0341:  sub       di,2000h
         jns       fnc03415
         add       di,7fa6h
fnc03415: sub       si,2000h
         jns       fnc03416
         add       si,7fa6h
fnc03416: push      si
         push      di
         push      cx
         repnz     movsb                    ; penos jedn linky
         pop       cx
         pop       di
         pop       si
         dec       bx
         jnz       fnc0341                   ; dal linka k penosu
fnc0342:  ret

; *****************************************************************************
;
;                        Funkce 04: prav okraj (ra)
;
; *****************************************************************************
;
                                            ; FUNKCE 04 - prav okraj (ra)

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = kd ry
                                            ;    + 6 = konen dek
                                            ;    + 8 = poten dek
                                            ;    +10 = pozice ry

fnc04:   cmp       byte ptr ds:[Mode],1
         jne       Fnc042                   ; nen textov md

         cld
         mov       si,[bp+10]               ; pozice ry
         dec       si
         jl        fnc0412                   ; zporn pozice
         cmp       si,ds:[Pozic]
         jae       fnc0412
         mov       ax,[bp+6]                ; konen dek
         mov       di,[bp+8]                ; poten dek
         sub       ax,di
         inc       ax                       ; poet dk
         mov       cx,ax                    ; poet dk
         mov       ax,ds:[Pozic]
         mul       di
         mov       di,ax
         add       di,si
         add       di,di
         push      es
         mov       ax,word ptr ds:[AdrVRAM]
         mov       es,ax
         mov       dl,ds:[cara]             ; barva okraje
         mov       dh,ds:[normal]           ; barva normlnho textu
fnc0411:  mov       al,es:[di+1]

         xor       al,dl
         xor       al,dh
;         cmp       al,dl
;         mov       al,dl
;         jnz       fnc0413
;         mov       al,dh
fnc0413:  mov       es:[di+1],al
         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         loop      fnc0411
         pop       es
fnc0412: ret


Fnc042:  cmp       byte ptr ds:[TypCard],2
         jbe       fnc043

         mov       si,[bp+10]               ; pozice ry
         or        si,si
         jng       fnc0422                   ; zporn pozice
         cmp       si,word ptr 80           ; kontrola pekroen 80 znak
         ja        fnc0422                   ; pekroen poet znak 80
         mov       ax,[bp+6]                ; konen dek
         mov       di,[bp+8]                ; poten dek
         sub       ax,di
         inc       ax                       ; poet dk okna
         mul       byte ptr [vyska]         ; poet linek na dek
         mov       cx,ax                    ; ta linek
         shl       di,1                     ; poten dek * 2
         mov       di,[di+adrrow]           ; adresa dku (v bajtech)
         add       di,si                    ; adresa zatku okna (v bajtech)
         mov       dx,03ceh                 ; adresov registr grafiky EGA
         mov       al,1
         out       dx,al                    ; nastaven registru 01
         inc       dx                       ; datov registr grafiky EGA
         mov       al,0                     ; nastaven bod
         out       dx,al
         dec       dx                       ; adresov registr grafiky EGA
         mov       al,3
         out       dx,al                    ; nastaven registru 03
         inc       dx                       ; datov registr grafiky EGA
         mov       al,18h                   ; nastaven reimu pro zpis XOR
         out       dx,al
         mov       al,[bp+04]               ; znak ry
         push      ds
         mov       dx,0a000h                ; adresa pamti EGA
         mov       ds,dx                    ; datov segment na pam EGA
fnc0421:  mov       ah,[di]                  ; peten bajtu
         mov       [di],al                  ; zpis znaku ry
         add       di,80
         loop      fnc0421                   ; dal linka
         pop       ds
         call      iniega                   ; inicializace displeje EGA
fnc0422:  ret

fnc043:  jb        fnc044                   ; je MDA

         mov       si,[bp+10]               ; pozice ry
         or        si,si
         jng       fnc0432                   ; zporn pozice
         cmp       si,word ptr 80           ; kontrola pekroen 80 znak
         ja        fnc0432                   ; pekroen poet znak 80
         mov       ax,[bp+6]                ; konen dek
         mov       di,[bp+8]                ; poten dek
         sub       ax,di
         inc       ax                       ; poet dk okna
         mul       byte ptr [vyska]         ; poet linek na dek
         mov       cx,ax                    ; ta linek
         shr       cx,1
         shl       di,1                     ; poten dek * 2
         add       si,[di+adrrow]           ; adresa dku (v bajtech)
         mov       al,[bp+04]               ; znak ry
         mov       dx,0b800h                ; adresa pamti CGA
         mov       ds,dx                    ; datov segment na pam CGA
fnc0431:  xor       ds:[si],al
         add       si,2000h
         xor       ds:[si],al
         sub       si,1fb0h
         loop      fnc0431                   ; dal linka
fnc0432:  ret

fnc044:   mov       si,[bp+10]               ; pozice ry
         or        si,si
         jng       fnc0442                   ; zporn pozice
         cmp       si,word ptr 90           ; kontrola pekroen 90 znak
         ja        fnc0442                   ; pekroen poet znak 90
         mov       ax,[bp+6]                ; konen dek
         mov       di,[bp+8]                ; poten dek
         sub       ax,di
         inc       ax                       ; poet dk okna
         mul       byte ptr [vyska]         ; poet linek na dek
         mov       cx,ax                    ; ta linek
         shl       di,1                     ; poten dek * 2
         mov       di,[di+adrrow]           ; adresa dku (v bajtech)
         add       di,si                    ; adresa zatku okna (v bajtech)
         mov       ax,0b000h                ; adresa pamti HGC
         mov       ds,ax                    ; datov segment na pam HGC
fnc0441:  mov       al,[bp+4]                ; peten bajtu
         xor       [di],al                  ; zpis znaku ry
         add       di,2000h
         jns       fnc04415
         sub       di,7fa6h
fnc04415: loop      fnc0441                   ; dal linka
fnc0442:  ret

; *****************************************************************************
;
;                    Funkce 05: inicializace displeje
;
; *****************************************************************************
;
; -----------------------------------------------------------------------------
;        Funkce 5: Inicializace parametr
; -----------------------------------------------------------------------------
; VSTUP: SS:[BP+4] (1) barva podkladu
;        SS:[BP+6] (1) barva psma
;        SS:[BP+8] (1) reim obrazovky
;                         1=textov md
;                         2=normln reim
;                         3=hust reim (PREVIEW)
; VSTUP: AX=poet pozic na dek
;         BX=poet linek na dek
;         CX=slo poslednho dku (=poet dk - 1)
;         ES:SI=jmno karty (3 znaky ASCII)
; -----------------------------------------------------------------------------

Fnc05    PROC      NEAR

         mov       al,[bp+8]                ; reim obrazovky (dkovn)
         mov       ds:[Mode],al             ; reim obrazovky (1,2,3)

; ------ detekce typu videokarty

         push      bp
         call      DetCard                  ; detekce typu videokarty
         pop       bp

; ------ inicializace videomdu

         mov       al,ds:[AktVMod]          ; videomd pro grafick reim
         cmp       byte ptr ds:[Mode],1     ; je textov videomd ?
         jne       Fnc051                   ; nen textov videomd
         mov       al,ds:[TxtVMod]          ; videomd pro textov reim
Fnc051:  mov       ah,0
         call      Int10                    ; nastaven videomdu

; ------ inicializace pro grafick videomd HGC

         cmp       byte ptr ds:[Mode],1     ; je textov videomd ?
         je        Fnc052                   ; je textov videomd
         cmp       byte ptr ds:[TypCard],1  ; je karta HGC ?
         jne       Fnc052                   ; nen karta HGC
         call      InitHGC                  ; inicializace grafickho mdu HGC

         mov       ax,0b000h
         mov       es,ax
         xor       ax,ax
         xor       di,di
         mov       cx,8000h/2
         rep       stosw

; ------ pprava adresy videopamti

Fnc052:  mov       word ptr ds:[AdrVRAM],0b000h ; adresa karty HGC
         cmp       byte ptr ds:[TypCard],2  ; je karta CGA ?
         jb        Fnc053                   ; je karta HGC
         mov       word ptr ds:[AdrVRAM],0b800h ; textov videomdy a md CGA
         je        Fnc053                   ; je karta CGA
         cmp       byte ptr ds:[Mode],1     ; je textov videomd ?
         je        Fnc053                   ; je textov videomd
         mov       word ptr ds:[AdrVRAM],0a000h ; adresa pro EGA/VGA graf. md

; ------ pprava barev displeje

Fnc053:  mov       al,[bp+6]                ; barva psma
         mov       bl,[bp+4]                ; barva podkladu
         call      InitCols                 ; inicializace barev displeje

; ------ pprava potu dk a vky znaku

         call      InitRows                 ; inicializace potu dk

; ------ vypnut kurzoru v textovm mdu

         cmp       byte ptr ds:[Mode],1     ; je textov videomd ?
         jne       Fnc056                   ; nen textov videomd
         mov       dx,25*HI
         mov       ah,2
         mov       bh,0
         call      Int10                    ; nastaven kurzoru za roh

; ------ vymazn displeje

Fnc056:

;         call      InitClr                  ; inicializan vymazn displeje
;                                        ;* vymazn spodnch linek
;        push      di
;        mov       di,476*80
;        mov       cx,0a000h                ; videopam EGA
;        mov       es,cx                    ; nastaven segmentu ES
;        mov       al,[invmsk]              ; maska pro vstup (pro inverzi)
;        mov       cx,4*80
;        cld
;        rep       stosb                    ; vymazn linek
;        pop       di
;
;        pop       cx                       ;

; ------ adresa textu karty

Fnc058:  mov       al,ds:[TypCard]          ; typ karty
         mov       ah,0
         shl       ax,1
         shl       ax,1
         add       ax,offset Karta          ; adresa textu karty
         xchg      ax,si                    ; SI <- adresa textu karty

; ------ parametry displeje

Fnc059:  mov       ax,ds:[Pozic]            ; poet pozic na dek
         mov       bh,0
         mov       bl,ds:[Vyska]            ; poet linek na dek
         mov       cx,ds:[Radku]            ; poet dk displeje celkem
         dec       cx                       ; slo poslednho dku
         push      cs
         pop       es                       ; ES <- segment ovladae
         ret

Fnc05    ENDP

; -----------------------------------------------------------------------------
;        pprava parametr dk
; -----------------------------------------------------------------------------

InitRows PROC      NEAR

; ------ poet dk displeje celkem

         mov       al,ds:[TypCard]          ; typ karty (1 a 4)
         mov       ah,al
         shl       al,1
         add       al,ah                    ; offset karty
         add       al,ds:[Mode]             ; offset v tabulce
         mov       ah,0
         xchg      ax,bx                    ; BX <- offset v tabulce
         mov       al,ds:[bx+TabRows-3-1]   ; poet dk displeje
         mov       byte ptr ds:[Radku],al   ; poet dk displeje

; ------ poet linek na dek

         mov       al,ds:[bx+TabLines-3-1]  ; poet linek na dek
         mov       [Vyska],al               ; poet linek na dek

; ------ poet pozic na dek

         mov       al,80                    ; poet znak na dek
         cmp       byte ptr ds:[TypCard],1  ; je karta HGC ?
         jne       InitRws2                 ; nen karta HGC
         cmp       byte ptr ds:[Mode],1     ; je textov reim MDA ?
         je        InitRws2                 ; je textov reim MDA
         mov       al,90                    ; jinak 90 znak na dek
InitRws2:mov       byte ptr ds:[Pozic],al   ; poet pozic na dek

; ------ inicializace adres dk

         cld
         push      cs
         pop       es
         mov       cx,ds:[Radku]            ; poet dk displeje
         inc       cx                       ; dek + 1
         mov       di,offset AdrRow         ; tabulka adres dk na displeji

         xor       ax,ax                    ; poten adresa
         mov       dx,160                   ; poet bajt na dek pro text. md
         cmp       byte ptr ds:[Mode],1     ; je to textov md ?
         je        InitRws4                 ; je to textov md

         mov       al,80                    ; poet bajt na linku EGA/VGA
         mul       byte ptr ds:[Vyska]      ; poet bajt na dek pro EGA/VGA
         xchg      ax,dx                    ; DX <- prustek adresy
         cmp       byte ptr ds:[TypCard],3  ; je karta EGA/VGA ?
         jae       initRws3                 ; je karta EGA/VGA
         shr       dx,1                     ; pro CGA je polovin poet
         cmp       byte ptr ds:[TypCard],2  ; je to karta CGA ?
         jb        InitRws5                 ; je to karta HGC

; ------ adresy dk pro textov mdy a pro mdy CGA, EGA a VGA

InitRws3:mov       ax,-1                    ; ukazatel adresy dku
InitRws4:stosw                              ; uloen adresy dku
         add       ax,dx                    ; zven adresy dku
         loop      InitRws4
         jmp       short InitRws8

; ------ adresy dk pro grafick md HGC

InitRws5:mov       ax,-1
         mov       dx,90                    ; poet bajt na dek
         mov       bl,ds:[Vyska]            ; vka dku
InitRws6:mov       al,dh                    ; ukazatel sla dku
         mul       bl                       ; slo linky absolutn
         mov       si,ax                    ; SI <- absolutn slo linky
         and       si,3                     ; slo linky relativn v dku
         ror       si,1
         ror       si,1
         ror       si,1                     ; adresa 0, 2000h, 4000h
         shr       ax,1
         shr       ax,1                     ; slo dku
         mul       dl                       ; poten adresa dku
         add       ax,si                    ; piten korekce pro podlinku
         dec       ax                       ; pednastaven - 1
         stosw                              ; uloen adresy linky
         inc       dh                       ; zven ukazatele sla linky
         loop      InitRws6                 ; dal dek

; ------ adresa fontu

InitRws8:mov       al,ds:[Vyska]            ; vka dku
         mov       ah,6                     ; vka zmenenho fontu
         mov       bx,offset Fnt6x8         ; zmenen font 6x8
         mov       si,offset Fnt6x8         ; hlavn font
         mov       word ptr ds:[Fnc005K+1],offset(Kurziv6-Fnc005K-3)
         cmp       al,6
         jbe       InitRws9
         mov       si,offset Fnt8x8
         mov       word ptr ds:[Fnc005K+1],offset(Kurziv8-Fnc005K-3)
         cmp       al,8
         jbe       InitRws9
         mov       ah,8                     ; vka zmenenho fontu
         mov       bx,si                    ; zmenen font 8x8
         mov       si,offset Fnt14x8        ; 14x8
         mov       word ptr ds:[Fnc005K+1],offset(Kurziv14-Fnc005K-3)
         cmp       al,14
         jbe       InitRws9
         mov       si,offset Fnt19x8        ; 19x8
         mov       word ptr ds:[Fnc005K+1],offset(Kurziv19-Fnc005K-3)

InitRws9:mov       ds:[AdrLFont],bx         ; zmenen font
         mov       ds:[AdrFont],si          ; hlavn font
         mov       ds:[VyskaL],ah           ; poet bajt na zmenen font
         ret

InitRows ENDP

; ------ poet dk displeje

TabRows  db        25,25,43                 ; MDA
         db        25,25,33                 ; CGA
         db        25,25,43                 ; EGA
         db        25,25,60                 ; VGA

; ------ poty linek na dek

TabLines db        1,14,8                   ; MDA
         db        1,8,6                    ; CGA
         db        1,14,8                   ; EGA
         db        1,19,8                   ; VGA

; -----------------------------------------------------------------------------
;        inicializace barev displeje
; -----------------------------------------------------------------------------
; VSTUP: AL=barva psma
;        BL=barva podkladu
; -----------------------------------------------------------------------------

InitCols PROC      NEAR

; ------ inicializace pro textov md

         cmp       byte ptr ds:[Mode],1     ; je textov md ?
         jne       InitCls3                 ; nen textov md

; ------ barvy pro MDA reim

         cmp       byte ptr ds:[TypCard],1  ; je karta HGC ?
         jne       InitCls1                 ; nen karta HGC

         mov       byte ptr ds:[Normal],7
         mov       byte ptr ds:[Cara],70h
         mov       byte ptr ds:[Invert],0f0h
         mov       byte ptr ds:[Zvyraz],0fh
         mov       byte ptr ds:[Sikme],70h
         mov       byte ptr ds:[Podtrz],70h
         mov       byte ptr ds:[Jine],70h

;         cmp       al,7
;         mov       al,7
;         je        IniCls12
;         mov       al,0
;         jb        IniCls12
;         mov       al,15
;
;IniCls12:cmp       bl,7
;         mov       bl,7
;         je        InitCls1
;         mov       bl,0
;         jb        InitCls1
;         mov       bl,15
         jmp       short InitCls8

InitCls1:mov       cl,4
         shl       bl,cl                    ; pprava barvy podkladu
         and       al,0fh                   ; barva psma
         or        al,bl                    ; zadan barva textu
         mov       bl,al                    ; schova barvy textu
         mov       [Normal],al              ; barva normlnho textu

         push      ax
         xor       al,77h                   ; negace barvy
         mov       [Cara],al                ; barva ry okraje
         pop       ax

         ror       al,cl
         mov       [Invert],al              ; barva invertovanho textu

;         cmp       byte ptr ds:[TypCard],1  ; je karta HGC ?
;         jne       InitCls2                 ; nen karta HGC
;
;         or        al,8
;         mov       ds:[Zvyraz],al
;         mov       ds:[Sikme],al
;         mov       ds:[Podtrz],al
;         jmp       short IniCls24
;
;InitCls2:
         and       bl,0f0h                  ; barva podkladu
         mov       al,bl
         or        al,14                    ; lut barva
         mov       [Zvyraz],al              ; zvraznn psmo
         mov       al,bl
         or        al,10                    ; zelen barva
         mov       [Sikme],al               ; ikm psmo
         mov       al,bl
         or        al,13                    ; fialov psmo
         mov       [Podtrz],al              ; podtren psmo
         mov       al,bl
         or        al,15                    ; bl psmo
         mov       [Jine],al                ; jin psmo
         shr       bl,cl                    ; barva podkladu
         jmp       short InitCls8

; ------ inicializace pro grafick reim EGA/VGA

InitCls3:cmp       byte ptr ds:[TypCard],2  ; je karta EGA nebo VGA ?
         jbe       InitCls5                 ; nen karta EGA/VGA
         mov       bh,bl                    ; barva podkladu
         mov       ah,0                     ; maska pro inverzi - nedl se
         or        bh,al                    ; pidn rovin barvy psma
         cmp       bh,bl                    ; je psmo podmnoinou pozad ?
         jne       InitCls4                 ; nen podmnoinou pozad
         mov       ah,-1                    ; maska pro inverzi - dl se
         xchg      al,bl                    ; zmna pozad a poped
InitCls4:or        al,bl                    ; spolen barvy pro psmo
         mov       [PlanNg],al              ; roviny pro negaci znaku (kurzor)
         mov       [Planes],bl              ; roviny EGA pro vstup znaku
         mov       [InvMsk],ah              ; maska znak pro inverzi
         call      IniEga                   ; inicializace displeje EGA/VGA
IniCls44:jmp       short InitCls9

; ------ inicializace pro grafick reim CGA a HGC

InitCls5:mov       byte ptr ds:[InvMsk],0ffh ; provd se inverze psma
         cmp       al,bl                    ; je barva psma vy ne pozad ?
         jbe       InitCls8                 ; provd se inverze
         mov       byte ptr ds:[InvMsk],0   ; inverze psma se neprovd
         mov       bl,al                    ; jinak plat barva psma

; ------ nastaven barvy okol

InitCls8:;cmp       byte ptr ds:[TypCard],1  ; je karta HGC ?
         ;je        InitCls9                 ; okol se pro HGC nenastavuje
         mov       ah,0bh
         mov       bh,0
         call      Int10                    ; nastaven barvy okol

         cmp       byte ptr ds:[Mode],1     ; je textov reim ?
         jne       InitCls9                 ; nen textov reim

IniCls82:mov       ax,1003h
         mov       bl,0                     ; pznak - intezivn podklad
         call      Int10                    ; nastaven atributu s jasem

         xor       ax,ax
         mov       es,ax
         mov       dx,es:[463h]             ; port CRT
         add       dl,4                     ; dic port
         mov       al,bit0 + bit3
         out       dx,al                    ; vypnut blikn

InitCls9:ret

InitCols ENDP

; -----------------------------------------------------------------------------
;        Inicializace displeje EGA v grafickm mdu
; -----------------------------------------------------------------------------

IniEga   PROC      NEAR

         cmp       byte ptr ds:[TypCard],3  ; je karta EGA/VGA ?
         jb        IniEga9                  ; nen karta EGA/VGA

         cli
         mov       dx,03ceh                 ; adresov registr EGA
         mov       al,0
         out       dx,al                    ; nastaven registru 0
         inc       dx                       ; datov registr
         mov       al,[planes]              ; roviny EGA pro vstup
         mov       bl,al
         out       dx,al                    ; nastaven rovin EGA pro vstup
         dec       dx                       ; adresov registr EGA
         mov       al,1
         out       dx,al                    ; nastaven registru 1
         inc       dx                       ; datov registr
         mov       al,[planng]              ; roviny pro negaci znaku
         xor       al,bl
         not       al
         out       dx,al                    ; nastaven rovin EGA pro negaci
         dec       dx                       ; adresov registr EGA
         mov       al,3                     ; registr 3
         out       dx,al                    ; nastaven registru 3
         inc       dx                       ; datov registr EGA
         mov       al,0
         out       dx,al                    ; nastaven reimu zpisu bez zmny
         dec       dx                       ; adresov registr
         mov       al,8                     ; registr 8
         out       dx,al                    ; nastaven registru 8
         inc       dx                       ; datov registr
         mov       al,0ffh
         out       dx,al                    ; nastaven masky bit vech rovin
         sti

IniEga9: ret

IniEga   ENDP

; -----------------------------------------------------------------------------
;        Detekce videokarty
; -----------------------------------------------------------------------------

DetCard  PROC      NEAR

; ------ test, zda ji probhla detekce

         cmp       byte ptr ds:[TypCard],0  ; byl ji typ karty detekovn ?
         je        DetCard1                 ; typ karty jet nebyl detekovn
         ret

; ------ schova videomdu

DetCard1:mov       ah,0fh
         call      Int10                    ; poskytnut aktivnho videomdu
         mov       ds:[OldVMod],al          ; schova videomdu

; ------ test, zda je videokarta EGA/VGA

         mov       ah,12h
         mov       bx,0ff10h
         call      Int10                    ; test, zda je karta EGA/VGA
         cmp       bh,1
         ja        DetCard3                 ; nen karta EGA/VGA
         cmp       bl,5
         ja        DetCard3                 ; nen karta EGA/VGA

; ------ test, zda je videokarta VGA

         mov       byte ptr ds:[TypCard],3  ; pednastaven - karta EGA
         mov       ax,1a00h
         call      Int10                    ; dotaz na instalaci videokarty
         cmp       al,1ah                   ; je funkce obsluhovan ?
         jne       DetCard4                 ; funkce nen obsluhovan
         cmp       bl,7
         je        DetCard2                 ; je karta VGA
         cmp       bl,8
         je        DetCard2                 ; je karta VGA
         cmp       bl,11
         je        DetCard2                 ; je karta VGA
         cmp       bl,12
         jne       DetCard4                 ; nen karta VGA
DetCard2:mov       byte ptr ds:[TypCard],4  ; je karta VGA
         jmp       short DetCard4

; ------ test, zda je videokarta HGC

DetCard3:mov       byte ptr ds:[TypCard],1  ; je karta HGC
         cmp       byte ptr ds:[OldVMod],7  ; je videomd 7 (=HGC) ?
         je        DetCard4                 ; je karta HGC
         mov       byte ptr ds:[TypCard],2  ; jinak je karta CGA

; ------ pprava sla videomdu

DetCard4:mov       bl,ds:[TypCard]          ; typ videokarty
         mov       bh,0
         dec       bx
         mov       al,ds:[bx+TabTVMod]      ; videomd pro textov reim
         mov       ds:[TxtVMod],al          ; textov videomd
         mov       al,ds:[bx+TabGVMod]      ; videomd pro grafick reim
         mov       ds:[AktVMod],al          ; grafick videomd
         ret

DetCard  ENDP

TabTVMod db        7,3,3,3                  ; videomdy pro textov reim
TabGVMod db        7,6,16,18                ; videomdy pro grafick reim

; -----------------------------------------------------------------------------
;        inicializace grafickho reimu karty HGC
; -----------------------------------------------------------------------------

InitHGC  PROC      NEAR

         cli

; ------ nastaven registru mdu karty HGC

         mov       dx,3b8h
         mov       al,2
         out       dx,al                    ; grafick md

; ------ inicializace registr HGC

         mov       ah,0
         mov       si,offset HGCTabR        ; tabulka registr karty HGC
         mov       dx,3b4h                  ; adresa portu karty HGC
         cld
InitHGC2:mov       al,ah                    ; slo registru
         out       dx,al                    ; nastaven sla registru
         inc       dx
         lodsb                              ; volba sla registru
         out       dx,al                    ; nastaven registru
         dec       dx
         inc       ah                       ; zven ukazatele registr
         cmp       ah,16
         jb        InitHGC2                 ; dal registr

; ------ povolen druh strnky videopamti (od adresy B800h)

         mov       dx,3bfh
         mov       al,1
         out       dx,al

; ------ zapnut videosignlu

         mov       dx,03b8h
         mov       al,1010b                 ; grafick md, videosignl zapnut
         out       dx,al
         sti
         ret

InitHgc  ENDP

; ------ registry pro inicializaci grafickho reimu karty HGC

HGCTabR  db        53 ;56 ;53                 ; 0: horizontln celkem
         db        45                       ; 1: horizontln zobrazeno
         db        47 ;46                       ; 2: pozice HSYNC
         db        7                        ; 3: ka HSYNC
         db        91                       ; 4: vertikln celkem
         db        2                        ; 5: vertikln korekce
         db        88                       ; 6: vertikln zobrazeno
         db        88                       ; 7: vertikln pozice
         db        2                        ; 8: md prokldn
         db        3                        ; 9: poet linek na dek
         db        0                        ; 10: potek kurzoru
         db        0                        ; 11: konec kurzoru
         db        0                        ; 12: adresa potku HIGH
         db        0                        ; 13: adresa potku LOW
         db        0                        ; 14: kurzor HIGH
         db        0                        ; 15: kurzor LOW

; -----------------------------------------------------------------------------
;        obsluha INT 10h s schovou registr
; -----------------------------------------------------------------------------

Int10    PROC      NEAR

         pushf
         push      si
         push      di
         push      bp
         push      ds
         push      es

         int       10h

         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         popf
         ret

Int10    ENDP

; *****************************************************************************
;
;                   Funkce 06: nvrat textovho videomdu
;
; *****************************************************************************
;
                                            ; FUNKCE 06 - nastaven text. mdu
fnc06:   mov       al,ds:[OldVMod]
         mov       ah,0
         call      Int10                    ; nastaven textovho mdu 80x25
         ret

                                            ; slovnk 1
slov1    db        'ANA ANI ABE ALTR EINI DEST GEI INI INS '
         db        'NACHT UNIV ZEITEN ZEITU ',0ffh

                                            ; slovnk 2
slov2    db        'AB AN AUF AUS NACH UN VER VOR ',0ffh

                                            ; slovnk 3
slov3    db        'ALT ALP BETT BERG DES EIN ERD ERNST FETT FEST '
         db        'GELD HAUS KREUZ LANG LEIT MACHT MAUS MENSCH NORD '
         db        'NCHST NETZ OBER OST REIT RCK SCHUL SPIEL SD '
         db        'TEST TIEF VOLL WACHS WASCH WEIT WETT WEG WEST ',0ffh

                                            ; slovnk 4
slov4    db        'DURCH LETZTEND SPORT TRANS ',0ffh

                                            ; slovnk 5
slov5    db        'DORT HOCH ZEIT BER ',0ffh

                                            ; slovnk 6
slov6    db        'CHA CURS DAR EMPF ENT HIN HER KOMP MIT SYN ',0ffh

                                            ; slovnk 7
slov7    db        'ABL ABR ALLEIN ANEI ANER ANORD ANS AT BEEH BEEI '
         db        'BEEN BEERD BEIRR BEOB BEUN BEUR ER GE IN KOOR '
         db        'OKT UM UR ZUGABE ',0ffh

                                            ; slovnk 8
slov8    db        'AI AU AY EI EU EY U ',0ffh

                                            ; slovnk 9
slov9    db        'EA E E E II I I I OA OE UE UI UU ',0ffh

                                            ; slovnk 10
slov10   db        'BL BR CH DR FL FR GL GR KL KN KR PFL PH PF '
         db        'PL PR SCHL SCHM SCHN SCHR SCHW STR SPR SCH '
         db        'SP ST TH TR ZW ',0ffh

                                            ; slovnk 11
slov11   db        'BS B CHTS CHS CHT CKT CH CK D FF FS F GS G '
         db        'HRS HL HM HN HR HT H KT K LBST LSCH LCH LFS '
         db        'LKS LTS LB LD LF LG LK LL LP LS LT L '
         db        'MPF MTS MM MP MT M NSCH NGS NDS NST ND NN NF '
         db        'NG NK NS NT NZ N PF PP PT P '
         db        'RSCH RCH RKT RST RB RD RF RG RK RM RN RS RT '
         db        'RZ R SCH ST S TSCH TZT TS TT TZ T XT Z '
         db        ' ',0ffh

                                            ; slovnk 12
slov12   db        'EITS IONS LLGE NSGE UNGS ',0ffh

                                            ; slovnk 13
slov13   db        'HAUS HEIT LICH LADE LAND LER LIG LOS PHA PREIS '
         db        'PUNKT RAND RAUM RECHT RECHN REICH RIG ROUT '
         db        'RUF ',0ffh

                                            ; slovnk 14
slov14   db        'AUS AUF AUGE AUTO AMT ART AB ARZT ARBEIT AKT '
         db        'ALGO ANALY ANDER ANF ANGAB ANGEB ANL ANOR '
         db        'ANSA ANTEIL ANWA ANWEN ANZAHL ANZEIG ANTW '
         db        'APFEL AFRI AMERI ADR APP ARGU EBENE ECK EDITO '
         db        'EIN EFF EURO ELEM ENERG ENTW EIMER ERDA '
         db        'ERGEBN ERFA ERLEB ERFO ERHAL ERKENN ETW EXP '
         db        'INDU INF INH INS IMP OBER ORDN ORDEN OPER ORGA '
         db        'ORIENT ORT UHR UMBRU UNFALL UNTER UMSATZ '
         db        'URLAUB URSACH URTEIL RZT NDER MT FFN '
         db        'KO B ',0ffh

b0aa4    db        0                        ; povolen dlka dku
b0aa5    dw        0                        ; adresa pevodn tabulky znak
w0aa7    dw        0
                                            ; test, zda jde o oddlovac znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je oddlovac znak

tst04:   mov       ah,4
         jmp       short tst401

                                            ; test, zda jde o dc znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je dc znak

tst40:   mov       ah,40h
tst401:  mov       al,[bx+di]               ; znak z textu k otestovn
         push      bx
         mov       bx,cs:[b0aa5]            ; adresa tabulky oddlovacch znak
         db        26h
         xlat                               ; transformace podle tab. ES:BX
         test      ah,al
         pop       bx
         ret

                                            ; nalezen zatku slova v textu
                                            ; vstup:  DS:[BX+DI] = ukaz.textu

endwrd:  dec       bx                       ; ukazatel textu
endwrd1: inc       bx
         call      tst40                    ; test, zda jde o dc znak
         jnz       endwrd2                  ; je dc znak - konec
         test      al,4                     ; jde o oddlovac znak slova ?
         jnz       endwrd1                  ; je oddlovac znak slova - dal
endwrd2: ret

                                            ; nalezen slova ve slovnku

                                            ; vstup:  CS:[SI] = ukazatel tabulky
                                            ;         DS:[BX+DI] = ukaz. textu
                                            ; vstup: AX = dlka shodnho slova
                                            ;         (AX = 0,ZF = 0 nenalezeno)

srcwrd:  mov       ah,32                    ; oddlovac znak slov (mezera)
srcwrd1: mov       al,cs:[si]               ; prvn znak slova z tabulky
         cmp       al,[bx+di]               ; porovnn se znakem v textu
         ja        srcwrd5                  ; znak v tabulce vt - nenalezeno
         jc        srcwrd3                  ; znak v tabulce men - dal slovo
         push      bx                       ; (shoda prvnho znaku) ukaz. textu
srcwrd2: inc       bx                       ; ukazatel zkoumanho textu
         inc       si                       ; ukazatel slovnku
         mov       al,cs:[si]               ; dal znak ze slovnku
         cmp       al,ah                    ; je mezera (konec slova) ?
         jz        srcwrd4                  ; je mezera = konec slova
         cmp       al,[bx+di]               ; porovnn dalho znaku slova
         jz        srcwrd2                  ; shoda - dal znak
         pop       bx                       ; (nen shoda) ukazatel textu
srcwrd3: inc       si                       ; nalezen dalho slova v tabulce
         cmp       ah,cs:[si]               ; je oddlovac mezera ?
         jnz       srcwrd3                  ; jet ne - dal znak v tabulce
         inc       si
         jmp       short srcwrd1            ; test dalho slova
srcwrd4: mov       ax,bx                    ; slova se shoduj
         pop       bx                       ; adresa slova ve slovnku
         sub       ax,bx                    ; dlka nalezenho slova
         ret
srcwrd5: xor       ax,ax                    ; slovo nenalezeno - konec (dlka 0)
         ret


lab0af5: push      bx                       ; adresa textu
         add       bx,ax                    ; adresa konce slabiky (rozdlit)
         push      bx                       ; adresa konce slabiky
         call      endwrd                   ; nalezen konce slova v textu
         mov       ax,bx                    ; konec slova v textu
         pop       bx                       ; adresa konce slabiky
         jz        lab0af51                 ; je ji konec dku
         sub       ax,bx                    ; poet znak do konec slova
         cmp       al,1                     ; dlka zbyl sti slova
         jna       lab0af52                 ; nen ji dn znak
         push      ax                       ; dlka zbyl sti slova
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       si                       ; dlka zbyl sti slova
         cmp       ax,si                    ; nalezeno stejn dlouh slovo ?
         jz        lab0af52                 ; je cel slovo
         xor       ax,ax                    
lab0af51:pop       bx                       
         ret                                
lab0af52:pop       si                       
lab0af53:cmp       bl,cs:[b0aa4]             ; povolen dlka dku
         jnc       lab0af55                  ; pekroen okraj dku
         inc       dx                       
         cmp       dx,bx                    
         mov       dx,bx                    
         jz        lab0af54                 
         mov       cs:[w0aa7],bx
lab0af54:ret                                
lab0af55:jmp       fnc097

                                            ;
lab0b2f: mov       si,offset slov1          ; slovnk 1 - nelze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0b2f5                 ; slovo nalezeno - konec
lab0b2f1:mov       si,offset slov2          ; slovnk 2 - lze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f2                 ; slovo nenalezeno - slovnk 3
         call      lab0af5                 
         jnz       lab0b2f1                
lab0b2f2:mov       si,offset slov3          ; slovnk 3
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f3                
         mov       si,di                   
         add       si,ax                   
         cmp       byte ptr [bx+si],"E"     ; je znak "E" ?
         jnz       lab0b2f4                
lab0b2f3:mov       si,offset slov4          ; slovnk 4
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,5                    
         jnz       lab0b2f4                
         mov       si,offset slov5          ; slovnk 5
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,4                    
         jnz       lab0b2f4                
         mov       si,offset slov6          ; slovnk 6
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,3                    
         jnz       lab0b2f4                
         mov       si,offset slov7          ; slovnk 7
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,2                    
         jz        lab0b2f5                
lab0b2f4:call      lab0af5                 
lab0b2f5:ret

lab0b85: mov       ax,bx                   
         sub       ax,cx                   
         cmp       ax,2                    
         xchg      bx,cx                   
         jc        lab0b853                
         jz        lab0b851                
         mov       si,offset slov8          ; slovnk 8
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b851                
         inc       bx                      
         jmp       short lab0b852          
lab0b851:mov       si,offset slov9          ; slovnk 9
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b853                
         cmp       byte ptr [bx+di-1],"Q"   ; je znak "Q" ?
         jz        lab0b853                
lab0b852:inc       bx                      
         call      lab0af53                
lab0b853:xchg      bx,cx                   
         ret       

lab0bb2: cmp       bx,cx
         jz        lab0bb27
         push      bx
         push      dx
         mov       dx,bx
         dec       dx
         mov       bx,cx
         dec       bx
lab0bb21:inc       bx
         cmp       bx,dx
         jz        lab0bb22
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0bb21
         add       ax,bx
         dec       ax
         cmp       ax,dx
         jnz       lab0bb21
         cmp       byte ptr [bx+di-1],"C"   ; byl pedchoz znak "C" ?
         jz        lab0bb21
lab0bb22:xchg      bx,cx
         mov       si,offset slov11         ; slovnk 11
         call      srcwrd                   ; nalezen slova ve slovnku
         add       bx,ax
         xchg      bx,cx
         cmp       bx,cx
         jnc       lab0bb26
         mov       dx,bx
lab0bb23:mov       si,offset slov12         ; slovnk 12
         push      bx
         sub       bx,4
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       bx
         jz        lab0bb24
         cmp       byte ptr cs:[w0aa7],0
         jnz       lab0bb26
lab0bb24:call      tst40                    ; test, zda jde o dc znak
         mov       si,offset slov14         ; slovnk 14
         jnz       lab0bb25
         mov       si,offset slov13         ; slovnk 13
lab0bb25:call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0bb26
         inc       bx
         cmp       bx,cx
         jna       lab0bb23
         mov       bx,dx
lab0bb26:pop       dx
         call      lab0af53
         pop       bx
lab0bb27:ret

; *****************************************************************************
;
;                        Funkce 09: rozdlovn slov
;
; *****************************************************************************
;
                                            ; FUNKCE 09 - rozdlovn slov
                                            ; vstup:  DS = datov segment textu
                                            ;         CX = pozice v dku

fnc09:   mov       [w0aa7],0
         mov       [b0aa4],al               ; povolen dlka dku
         mov       [b0aa5],si               ; adresa transforman tabulky znak
         pop       dx                       ; nvratov adresa programu
         pop       ds                       ; datov segment textu
         push      ds                       ; datov segment textu
         push      dx                       ; nvratov adresa programu
         push      bp                       
         mov       bp,sp                    
fnc091:  mov       bx,cx                    ; aktuln pozice v dku
         dec       bx                       
fnc092:  inc       bx                       ; dal znak
         cmp       bl,cs:[b0aa4]            ; povolen dlka dku
         jnc       fnc097                   ; pekroen okraj dku - konec
         call      tst04                    ; test, zda jde o oddlovac znak
         jz        fnc092                   ; nenalezeno - dal
         mov       cx,bx                    ; nov pozice rozdlen slova
         dec       bx                       
fnc093:  inc       bx                       
         call      tst04                    ; test, zda jde o oddlovac znak
         jnz       fnc093                   ; nalezeno - dal pokus
         xchg      bx,cx                    
         mov       ax,cx                    
         sub       ax,bx                    
         cmp       ax,4                     
         jc        fnc091                   
         mov       dx,bx                    
         call      lab0b2f                  
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc091                   
         push      cx                       
fnc094:  mov       cx,bx                    
         dec       bx                       
fnc095:  inc       bx                       
         call      tst40                    ; test, zda jde o dc znak
         jnz       fnc095                   
         call      lab0b85                  
         mov       cx,bx                    
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc096                   
         call      lab0bb2                  
         jmp       short fnc094             
fnc096:  pop       cx                       
         jmp       short fnc091             
fnc097:  mov       ax,cs:[w0aa7]            
         mov       sp,bp                    
         pop       bp                       
         ret                                


                                            ; tabulka pro pekdovn klves

tabkey   db        0c1h,1eh                 ; ALT A
         db        0c2h,30h                 ; ALT B
         db        0c3h,2eh                 ; ALT C
         db        0c4h,20h                 ; ALT D
         db        0c5h,12h                 ; ALT E
         db        0c6h,21h                 ; ALT F
         db        0c7h,22h                 ; ALT G
         db        0c8h,23h                 ; ALT H
         db        0c9h,17h                 ; ALT I
         db        0cah,24h                 ; ALT J
         db        0cbh,25h                 ; ALT K
         db        0cch,26h                 ; ALT L
         db        0cdh,32h                 ; ALT M
         db        0ceh,31h                 ; ALT N
         db        0cfh,18h                 ; ALT O
         db        0d0h,19h                 ; ALT P
         db        0d1h,10h                 ; ALT Q
         db        0d2h,13h                 ; ALT R
         db        0d3h,1fh                 ; ALT S
         db        0d4h,14h                 ; ALT T
         db        0d5h,16h                 ; ALT U
         db        0d6h,2fh                 ; ALT V
         db        0d7h,11h                 ; ALT W
         db        0d8h,2dh                 ; ALT X
         db        0d9h,15h                 ; ALT Y
         db        0dah,2ch                 ; ALT Z
         db        0f0h,81h                 ; ALT 0
         db        0f1h,78h                 ; ALT 1
         db        0f2h,79h                 ; ALT 2
         db        0f3h,7ah                 ; ALT 3
         db        0f4h,7bh                 ; ALT 4
         db        0f5h,7ch                 ; ALT 5
         db        0f6h,7dh                 ; ALT 6
         db        0f7h,7eh                 ; ALT 7
         db        0f8h,7fh                 ; ALT 8
         db        0f9h,80h                 ; ALT 9
         db        1bh,3bh                  ; F1
         db        1ch,3ch                  ; F2
         db        1dh,3dh                  ; F3
         db        1eh,3eh                  ; F4
         db        1fh,3fh                  ; F5
         db        20h,40h                  ; F6
         db        21h,41h                  ; F7
         db        22h,42h                  ; F8
         db        23h,43h                  ; F9
         db        24h,44h                  ; F10
         db        5bh,54h                  ; SHIFT F1
         db        5ch,55h                  ; SHIFT F2
         db        5dh,56h                  ; SHIFT F3
         db        5eh,57h                  ; SHIFT F4
         db        5fh,58h                  ; SHIFT F5
         db        60h,59h                  ; SHIFT F6
         db        61h,5ah                  ; SHIFT F7
         db        62h,5bh                  ; SHIFT F8
         db        63h,5ch                  ; SHIFT F9
         db        64h,5dh                  ; SHIFT F10
         db        9bh,5eh                  ; CTRL F1
         db        9ch,5fh                  ; CTRL F2
         db        9dh,60h                  ; CTRL F3
         db        9eh,61h                  ; CTRL F4
         db        9fh,62h                  ; CTRL F5
         db        0a0h,63h                 ; CTRL F6
         db        0a1h,64h                 ; CTRL F7
         db        0a2h,65h                 ; CTRL F8
         db        0a3h,66h                 ; CTRL F9
         db        0a4h,67h                 ; CTRL F10
         db        0dbh,68h                 ; ALT F1
         db        0dch,69h                 ; ALT F2
         db        0ddh,6ah                 ; ALT F3
         db        0deh,6bh                 ; ALT F4
         db        0dfh,6ch                 ; ALT F5
         db        0e0h,6dh                 ; ALT F6
         db        0e1h,6eh                 ; ALT F7
         db        0e2h,6fh                 ; ALT F8
         db        0e3h,70h                 ; ALT F9
         db        0e4h,71h                 ; ALT F10
         db        0a5h,73h                 ; CTRL <-
         db        0a6h,74h                 ; CTRL ->
         db        0a7h,77h                 ; CTRL HOME
         db        0a8h,75h                 ; CTRL END
         db        0a9h,84h                 ; CTRL PGUP
         db        0aah,76h                 ; CTRL PGDN
         db        6bh,0fh                  ; SHIFT TAB
         db        0,0                      


tabshf   db        6                        ; dlka jedn poloky
         db        0,'     '                ; 00h
         db        5,'SHIFT'                ; 40h
         db        4,'CTRL '                ; 80h
         db        3,'ALT  '                ; C0h
         db        0ffh                     

tabhome  db        5                        ; dlka jedn poloky
         db        2,'<-  '                 ; 25h
         db        2,'->  '                 ; 26h
         db        4,'HOME'                 ; 27h
         db        3,'END '                 ; 28h
         db        4,'PGUP'                 ; 29h
         db        4,'PGDN'                 ; 2Ah
         db        3,'TAB '                 ; 2Bh
         db        0ffh                     

tabfn    db        4                        ; dlka jedn poloky
         db        2,'F1 '                  ; 1Bh
         db        2,'F2 '                  ; 1Ch
         db        2,'F3 '                  ; 1Dh
         db        2,'F4 '                  ; 1Eh
         db        2,'F5 '                  ; 1Fh
         db        2,'F6 '                  ; 20h
         db        2,'F7 '                  ; 21h
         db        2,'F8 '                  ; 22h
         db        2,'F9 '                  ; 23h
         db        3,'F10'                  ; 24h
         db        0ffh                     

                                            ; pevod textu na velk psmena

                                            ; vstup:  ES:SI = ukazatel na text
                                            ;         BL = nejmen znak
                                            ; vstup: ES:[BX+SI] = zatek textu
                                            ;         CX = poet znak textu
                                            ;         CF=0,ZF=0 je konec textu
                                            ;         CF=0,ZF=1 nen jet konec

upper:   xor       cx,cx                    ; vynulovn tae znak
upper1:  cmp       bl,es:[si]               ; porovnn znaku s BL
         ja        upper6                   ; znak je men ne BL - konec
         cmp       byte ptr es:[bx+si]," "  ; je mezera ?
         jnz       upper2                   ; nen - konec hledn
         inc       bx                       ; dal pozice
         jmp       short upper1             ; dal znak
upper2:  push      bx                       
upper3:  cmp       bl,es:[si]               ; kontrola koncovho znaku
         ja        upper5                   ; znak je men ne BL - konec
         mov       al,es:[bx+si]            ; peten znaku k pekdovn
         cmp       al," "                   ; je mezera ?
         jz        upper5                   ; je mezera - konec
         cmp       al,"|"                   ; "|"
         jz        upper5                   ; je znak "|" - konec
         cmp       al,"a"                   ; "a"
         jc        upper4                   ; je znak men ne "a"
         and       al,0dfh                  ; pevod na velk psmeno
         mov       es:[bx+si],al            ; uloen pevedenho znaku
upper4:  inc       bx                       ; dal znak
         inc       cx                       ; zven tae nalezench znak
         jmp       upper3                   ; pevod dalho znaku na velk
upper5:  pop       bx                       
upper6:  ret                                

                                            ; nalezen textov poloky v tabulce

                                            ; vstup:  ES:[BX+SI] ukazatel textu
                                            ;         DS:DI = ukazatel tabulky
                                            ;         CX = dlka hled. textu
                                            ; vstup: ES:[BX+SI] nov pozice
                                            ;         DL = poad. slo poloky
                                            ;         AX = dlka poloky tabulky

srctab:  mov       al,[di]                  ; peten dlky jedn poloky
         mov       ah,0                     
         inc       di                       ; ukazatel tabulky - prvn poloka
         xor       dl,dl                    ; ta poloek
srctab1: inc       dx                       ; zven tae poloek
         cmp       cl,[di]                  ; porovnn dlky textu
         jnz       srctab4                  ; nesouhlas - dal poloka
         push      ax                       ; dlka jedn poloky
         push      bx                       ; ukazatel textu
         push      cx                       ; dlka textu
         push      di                       ; ukazatel tabulky
         inc       di                       ; prvn znak poloky
srctab2: mov       al,es:[bx+si]            ; zkouman znak
         cmp       al,[di]                  ; porovnn se znakem z tabulky
         jnz       srctab3                  ; nesouhlas - dal poloka
         inc       bx                       ; zven ukazatele textu
         inc       di                       ; zven ukazatele tabulky
         loop      srctab2                  ; dal znak k testu
         pop       di                       ; ukazatel tabulky - nalezeno
         pop       cx                       ; dlka textu
         pop       ax                       ; zruen pvodn pozice textu BX
         pop       ax                       ; dlka jedn poloky
         or        dl,dl                    ; poadov slo poloky
         ret                                
srctab3: pop       di                       ; ukazatel tabulky
         pop       cx                       ; dlka textu
         pop       bx                       ; ukazatel zkoumanho textu
         pop       ax                       ; dlka jedn poloky
srctab4: add       di,ax                    ; adresa dal poloky
         cmp       byte ptr [di],0ffh       ; je koncov znak tabulky ?
         jnz       srctab1                  ; nen jet konec
         xor       dl,dl                    ; nenalezen - slo poloky = 0
         ret                                

; *****************************************************************************
;
;                     Funkce 10: dekdovn klvesy
;
; *****************************************************************************
;
                                            ; FUNKCE 10 - dekdovn klvesy

                                            ; vstup:  ES:SI = ukazatel textu
                                            ; vstup: ES:SI = nov pozice
                                            ;         AX = kd klvesy

fnc10:   mov       bx,1                     ; koncov znak = 00
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         mov       di,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      srctab                   ; nalezen textov poloky v tabulce
         mov       dh,dl                    ; poadov slo poloky - schova
         jz        fnc103                   ; text nebyl nalezen
         dec       dh                       ; poad. slo poloky - 1
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         cmp       cx,1                     ; je pouze jeden znak ?
         jnz       fnc102                   ; nen prv jeden znak
         mov       al,es:[bx+si]            ; znak k pekdovn
         cmp       al,"@"                   ; = "@"
         jc        fnc101                   ; men ne "@"
         cmp       al,"Z"                   ; = "Z"
         ja        fnc106                   ; vt ne "Z"
         sub       al,40h                   ; pevod na dc znak
fnc101:  mov       dl,al                    ; pekdovan znak
         jmp       short fnc104             
fnc102:  mov       di,offset tabhome        ; tabulka dcch klves HOME,...
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc103                   ; poloka nenalezena
         add       dl,24h                   ; korekce
         jmp       short fnc104
fnc103:  mov       di,offset tabfn          ; tabulka funknch klves Fn
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc106                   ; nenalezena
         add       dl,1ah                   ; korekce
fnc104:  ror       dh,1                     
         ror       dh,1                     
         or        dl,dh                    ; klvesy SHIFT,.. jako bity 6 a 7
         mov       di,offset tabkey         ; tabulka pro dekdovn kd klves
fnc105:  mov       al,[di]                  ; kd klvesy
         inc       di                       
         inc       di                       
         or        al,al                    ; je posledn kd ?
         jz        fnc106                   ; kd klvesy nenalezen
         cmp       al,dl                    ; porovnn s hledanm kdem
         jnz       fnc105                   ; dal pokus
         dec       di                       
         mov       al,[di]                  ; pekdovn kdu klvesy
         mov       ah,0                     
         ret                                
fnc106:  xor       ax,ax                    ; kd klvesy nenalezen
         ret                                

                                            ; vpis kdu klvesy

                                            ; vstup:  CS:SI tabulka klves
                                            ;         DL = poad. slo klvesy
                                            ;         DS:[BX+DI] = vst. buffer
                                            ;         CH = 0
                                            ; vstup: DS:[BX+DI] = nov pozice

outkey:  push      ax                       
         mov       al,cs:[si]               ; dlka jedn poloky v tabulce
         mul       dl                       ; rel. adresa poloky v tabulce
         add       si,ax                    ; adresa poloky v tabulce
         inc       si                       
         mov       cl,cs:[si]               ; dlka textu v poloce
         jcxz      outkey2                  
outkey1: inc       si                       ; znak poloky textu klvesy
         inc       bx                       ; ukazatel vstupnho textu
         mov       al,cs:[si]               ; peten znaku poloky
         mov       [bx+di],al               ; uloen do bufferu
         loop      outkey1                  ; dal znak
         inc       bx                       ; nsledujc pozice
         mov       byte ptr [bx+di]," "     ; oddlovac mezera
outkey2: pop       ax                       
         ret                                

adrtab   dw        offset tabkey            ; ukazatel dekdovac tabulky klves

; *****************************************************************************
;
;                   Funkce 11: vpis kdu klvesy
;
; *****************************************************************************
;
                                            ; FUNKCE 11 - vpis kdu klvesy

                                            ; vstup:  DS:[BX+DI] = vst. buffer
                                            ;         AX = kd klvesy
                                            ; vstup: DS:[BX+DI] = nov adresa

fnc11:   mov       dx,ax                    ; kd klvesy
         xor       cx,cx                    ; ta znak
         mov       bx,[adrtab]              ; ukazatel dekdovac tabulky klves
         inc       bx                       ; dal klvesa
fnc111:  mov       al,[bx]                  ; kd klvesy
         or        al,al                    ; je ukonovac znak 00 ?
         jnz       fnc112                   ; nen jet konec
         mov       [adrtab],offset tabkey   ; nastav. za. dekd. tabulky klves
         mov       es,dx
         mov       es:[di],ch               ;
         ret       
fnc112:  push      si                       ; ukazatel tabulky klves
fnc113:  mov       ah,es:[si]               ; kd klvesy
         or        ah,ah
         jz        fnc114                   ; je ji posledn
         cmp       al,ah                    ; porovnn s hledanou klvesou
         jz        fnc115                   ; je nalezen kd klvesy
         inc       si                       ; dal klvesa
         mov       cl,es:[si]               ;
         inc       cx
         add       si,cx                    ; adresa nsledujcho textu
         jmp       short fnc113             ; nov pokus
fnc114:  pop       si
         inc       bx
         inc       bx
         jmp       short fnc111
fnc115:  inc       bx
         mov       [adrtab],bx              ; nov adresa ukazatele tabulky
         mov       al,[bx-2]                ; kd klvesy
         inc       si
         pop       bx
         push      si
         push      dx
         pop       ds
         xor       bx,bx
         mov       dl,al
         and       dl,0c0h
         rol       dl,1
         rol       dl,1
         mov       si,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      outkey                   ; vpis kdu klvesy
         mov       dl,al
         and       dl,3fh
         cmp       dl,1ah
         ja        fnc116
         add       dl,40h
         inc       bx
         mov       [bx+di],dl
         jmp       short fnc119
fnc116:  cmp       dl,24h
         ja        fnc117
         sub       dl,1bh
         mov       si,offset tabfn          ; tabulka funknch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc117:  cmp       dl,2bh                   ; znak "+"
         ja        fnc118
         sub       dl,25h
         mov       si,offset tabhome        ; tabulka dcch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc118:  inc       bx
         mov       [bx+di],dl
fnc119:  cmp       bx,9
         ja        fnc11a
         inc       bx
         mov       byte ptr [bx+di]," "     ; oddlovac znak mezery
         jmp       short fnc119
fnc11a:  inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         pop       si
         mov       cl,es:[si]
fnc11b:  inc       si
         mov       al,es:[si]               ; peten znaku k vytitn
         inc       bx
         cmp       al," "
         jnc       fnc11c                   ; nen dc znak
         mov       byte ptr [bx+di],"^"     ; uloen znaku "^" (znak s CTRL-)
         inc       bx                       ; zven ukazatele
         or        al,40h                   ; pevod znaku na tisknuteln znak
fnc11c:  mov       [bx+di],al               ; uloen znaku
         loop      fnc11b                   ; pevod dalho znaku
         inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         mov       [di],bl
         ret       

; *****************************************************************************
;
;                   Funkce 07: poskytnut adresy definice okna
;
; *****************************************************************************
;
; -----------------------------------------------------------------------------
;        Poskytnut adresy definice okna menu
; -----------------------------------------------------------------------------
; VSTUP: SS:[BP+4] (2) slo poadovanho okna
; VSTUP: ES:SI=adresa definice okna
; -----------------------------------------------------------------------------

Fnc07    PROC      NEAR

         mov       bx,[bp+4]
         shl       bx,1
         mov       si,[bx+TabHlp]
         push      ds
         pop       es
         ret

Fnc07    ENDP

INCLUDE  SCREENWN.ASM                       ; definice oken

; *****************************************************************************
;
;                   Funkce 08: poskytnut adresy textu hlen
;
; *****************************************************************************
;
; -----------------------------------------------------------------------------
;        Poskytnut adresy tabulky chybovch hlen
; -----------------------------------------------------------------------------
; VSTUP: ES:SI=adresa tabulky chybovch hlen
; -----------------------------------------------------------------------------

Fnc08    PROC      NEAR

         mov       si,offset TabErr         ; tabulka hlen
         push      ds                       ; nastaven ES = DS
         pop       es
         ret

Fnc08    ENDP

TabErr   LABEL     BYTE
         db        1,'Soubor nebyl nalezen',0
         db        2,'ten souboru nen mon',0
         db        3,'Zpis do souboru nen mon',0
         db        4,'Poadovan adres nenalezen',0
         db        5,'Nedostatek msta v pamti',0
         db        6,'Pekroen maximln poet dk',0
         db        7,'" nebyl nalezen',0
         db        8,'dek je moc dlouh',0
         db        9,'Nepovolen zadn',0
         db        10,'Nen oznaen dn blok',0
         db        11,'Pam makroklves je pln',0
         db        12,'Tiskrna nen v provozu',0
         db        13,'Chybn formt dat',0
         db        15,'Soubor s tmto jmnem ji existuje',0
         db        16,'Zdrojov a clov soubor jsou identick',0
         db        17,'Prostor @ nen dosud vytistn.',0
         db        18,'Sloupcov blok neme bt zapsn do souboru',0
         db        19,'Nen oznaen dn sloupcov blok',0
         db        20,'Kurzor se mus nachzet vpravo od pravho okraje',0
         db        21,'Mus bt zadn soubor EXE nebo COM',0
         db        50,'Nepovolen matematick vraz',0
         db        51,'Peteen desetinn teky',0
         db        52,'Dlen nulou',0
         db        53,'Chybn argument',0
         db        54,'Chyba argumentu',0
         db        99,'Intern chyba',0
         db        100,'Disketov mechanika nepracuje',0
         db        153,'Neoekvan konec souboru',0
         db        196,'Peteen sla Integer',0
         db        240,'Disk je pln',0
         db        241,'Nepovolen jmno souboru',0
         db        0,'Ble neuriteln chyba',0

; *****************************************************************************
;
;                                Fonty
;
; *****************************************************************************
;
; Pro grafick md CGA a HGC mus bt sud poet linek na znak !

INCLUDE  SCREEN06.ASM                       ; fonty 8x6
INCLUDE  SCREEN08.ASM                       ; fonty 8x8
INCLUDE  SCREEN14.ASM                       ; fonty 8x14
INCLUDE  SCREEN19.ASM                       ; fonty 8x19

Code     ENDS
         END       Screen
