program KonVen;
uses Crt;

{Pevod textu v kdu Kamenickch z textovho editoru Kontext do
 Ventura Publishing.
 
 Transformace textu probhaj podle schematu:

 Kontext - Vznam               Ventura Publishing
 ____________________________________________________________________
  0        nadsazen on/off          <^>    akce eeny pkazem case
  1        podsazen on/off          <v>    pro kdy 0-6
  2        kursiva on/off            <I>
  3        podtren on/off          <U>
  4        zvraznn tisk on/off    <B>
  5        inversn psmo (int.)     ign. ''
  6x6      rozdlen x-              x<->
  6-       pohyb. rozdlovac znak   <->
  7        pech. rozdlen pro - jako zadan znak na konci dku.
           Tento znak se kopruje na vstup. Mezery na dalm dku
           se ignoruj.
  8,9      bez vznamu               ign. ''
  10       LF, ve skupin CR LF      ign. vznam VP: konec paragrafu
  11,12    bez vznamu               ign. ''
  13       CR, ve skupin CR LF      ign. vznam VP: konec paragrafu
  14,15    bez vznamu               ign. ''
  16       zatek odstavce          ign. ''
  17       konec odstavce            ign. ''
  18,19,20 bez vznamu               ign. ''
  21,173   znak paragraf             VP etz <185>
  26       EOF konec souboru         chr(26)
  27..30   bez vznamu               ign. ''
  31       za. neform. odstavce     ign. '' mezery se neru do <17>
  60       <                         <<
  62       >                         >>
  250      pevn mezera              <N> non-breaking space
  255      nsl. znak s dvoj. kou ign. ''
  158                               <158>
  169                               <169>
  250      pevn mezera              <N>

 Jin znaky se pevdj na vstup beze zmny. Ukonen urit
 funkce se pro VP vyzna <D> (vechny funkce) nebo funkci ukon-
  jin volba. Volby se mohou v <...> sdruovat.

 Program dle pevd v tabulkch (mezi znaky zatku a konce ta-
 bulky) grafick znaky , ,  atd. na tabeltory a dky tabulky
 kon jako odstavce VP (CRLFCRLF). Z toho lze ve VP tabulku zre-
 konstruovat po vhodnm nastaven tabeltor, protoe tabulky jsou
 oznaeny (volitelnmi) jmny. V textu me bt na uritch dcch
 jen jedna tabulka a ped n zleva ani za n vpravo nesm bt u
 dal text, jak to ukazuje schema:

           Ŀ
      bez  Ĵ bez
    textu    jen jedna tabulka na dku             textu
           Ĵ
                                                   
                                                   
           

 To nen omezenm obecnosti: Je-li v seku vce tabulek nebo text,
 uprav se tento obsah prost na jednu tabulku a podle vloench 
 tabeltor se zsk ve VP potebn uspodn. Rozum se, e for-
 mt vech dk v tabulce mus bt stejn; pi zmn formtu je 
 teba definovat novou tabulku.
 
 V s t u p e m  pro program je jen specifikace vstupnho (pev-
 dnho) souboru a specifikace vstupnho souboru. Tyto parametry
 lze zadat jako extern; nejsou-li zadny jako extern, budou vy-
 dny v prbhu programu.

 Autor: S. Dvok, OVS Tesla Ronov
 Datum: 9/90, zpracovn tabulky doplnno 10/7/91.
 Jazyk: Turbo Pascal 5.5                                }

var
  Fin,Fout: file;
  inspec,outspec: string[80];
  inbuf: array [1..8192] of byte;
  outbuf: array[0..16384] of byte;
  inblk,outblk,rest,i,j,k: word;
  S: string;
  Str4: string[4];
  errpos: integer;
  cc,c,dc,len: byte;
  ch: char;
  IgnSpc,Expnt,Index,Ital,UndLn,Bold: boolean; {pepnae typu psma}
  Use: array[0..255] of byte;
  InTab: boolean;                     {pepna vn - uvnit tabulky}
  TrS,TabStr: string[10];
  TabInd: word;
  TabindC: string[4];
  TabLen: byte;

label NewCh;

const
  igsize=20;
  IgnVal: array[1..igsize] of byte =
    (8,9,11,12,13,14,15,16,18,19,20,22,23,24,25,27,28,29,30,255);
  VertCh: array[1..30] of byte=
        (179,180,181,182,183, 184,185,186,187,191,
         192,193,194,195,197, 198,199,200,202,203,
         204,206,207,208,209, 210,211,212,215,216);
  TabBg:  array[1..4] of byte=(201,213,214,218);
  TabEnd: array[1..4] of byte=(188,189,190,217);
  LF=10;
  Space=32;
  SoftBreak: string[3]='<->';
  Less: string[2]='<<';
  Greater: string[2]='>>';
  BigR: string[5]='<158>';              { v etin Kamenickch}
  DelSym: string[3]='<D>';
  ParSym: string[4]=chr(13)+chr(10)+chr(13)+chr(10);
  FxSpace: string[3]='<N>';
  Parag: string[5]='<185>';             {znak paragrafu pro 21 a 173}

{ ------------------------------------------------------------------- }
procedure GetChar;
{Procedura te dal znak do c jako byte.}
begin
  if i<inblk then begin Inc(i); c:=inbuf[i] end
  else Blockread(Fin,c,1,rest)
end;

procedure GetSym;
begin
 while inbuf[k]=Space do Inc(k);
 S:=''; while inbuf[k]<>Space do begin S:=S+chr(inbuf[k]); Inc(k) end
end;

{$V- R- A+}
procedure UpCon(var S: string);
var sx: byte;
begin
 for sx:=1 to length(S) do S[sx]:=UpCase(S[sx])
end;

procedure Vent;
{Procedura vytv znakov etz pro zen VP. Uvaj se
 indiktory  zapnutch funkc. Nen-li dn funkce Ital, Bold,...
 aktivn, vytvo se etz <D>. Ten vznikne i po LF, je-li
 nkter funkce aktivn.}

begin
 S:='<';
 if Expnt then S:=S+'^';
 if Index then S:=S+'V';
 if Ital then S:=S+'I';
 if UndLn then S:=S+'U';
 if Bold then S:=S+'B';
 if length(S)=1 then S:=S+'D';
 S:=S+'>';
 Move(S[1],outbuf[j],length(S)); Inc(j,ord(S[0]));
end;

procedure AppOff;      {Vypnut Appearance pznak}
begin
 if Expnt or Index or Ital or UndLn or Bold then
   begin
     Move(DelSym[1],outbuf[j],3); Inc(j,3);
     Expnt:=false; Index:=false; Ital:=false; UndLn:=false; Bold:=false
   end
end;

begin
  TabInd:=0; IgnSpc:=true;
  for i:=0 to 255 do Use[i]:=1;
  for i:=1 to igsize do begin c:=IgnVal[i]; Use[c]:=0 end;
  for i:=1 to 30     do begin c:=VertCh[i]; Use[c]:=2 end;
  for i:=1 to 4      do begin c:=TabBg[i];  Use[c]:=3 end;
  for i:=1 to 4      do begin c:=TabEnd[i]; Use[c]:=4 end;

  TextColor(LightGreen); TextBackGround(Black);
  writeln; writeln;
  writeln('P  E V O D   K O N T E X T --> V E N T U R A');
  writeln('_____________________________________________');
  TextColor(LightGray);
  if ParamCount>0 then
  begin
    inspec:=ParamStr(1); outspec:=ParamStr(2)
  end
  else
  begin
    writeln;
    writeln('Program nyn vyd plnou  specifikaci vstupnho a vstup-');
    writeln('nho (pevedenho) souboru. Pokud se v pevdnm textu na-');
    writeln('jde znak zatku tabulky, zadte jej jmno. Zadejte pesn');
    writeln('jmno, kter odpovd formtu tabulky (nap. jsou-li v tex-');
    writeln('tu tyi tabulky 1, 2, 2, 1 dvou formt 1,2, zadejte nap.');
    writeln('jmna T1,T2,T2,T1, jak o n program pod. Pedpokld se,');
    writeln('e grafick znaky  (kter Ventura v kdu Kam. ignoruje) ne-');
    writeln('jsou v pevdnm textu pouity mimo tabulky. Pokud se zad');
    writeln('pi  poadavku na  jmno jen <Enter>, pouije se jako jmno');
    writeln('tabulky TBp, kde p je poad tabulky v textu. Jmna se pe-');
    writeln('vedou do velkch psmen, tj. mal a velk psmena se v nich');
    writeln('nerozliuj. Jmno zan psmenem angl. abecedy, v dalch');
    writeln('mstech mohou bt psmena nebo slice. Jmna uijte krtk.');
    writeln;
    write('Specifikace vstupnho souboru:  ');
    TextAttr:=$0A; Readln(inspec); TextAttr:=7;
    write('Specifikace vstupnho souboru: ');
    TextAttr:=$0A; Readln(outspec);
  end;
  TextAttr:=7;

 {$I-}
   Assign(Fin,inspec); Reset(Fin,1);
   while IOResult<>0 do
   begin
     TextAttr:=12; writeln('Soubor ',inspec,' nelze otevt.');
     TextAttr:=7;
     writeln('Zadejte specifikaci znovu nebo <Enter> pro ukonen.');
     write('Specifikace vstup. souboru: ');
     TextAttr:=$0A; Readln(inspec); TextAttr:=7;
     if inspec='' then Halt(1);
     Assign(Fin,inspec); Reset(Fin,1);
   end;
 {$I+}

 {Vstupn soubor pipraven ke zpracovn.}

 {$I-}
   Assign(Fout,outspec); Rewrite(Fout,1);
   while IOResult<>0 do
   begin
     TextAttr:=12; writeln('Soubor ',outspec,' nelze otevt.');
     TextAttr:=7;
     writeln('Zadejte specifikaci znovu nebo <Enter> pro ukonen.');
     write('Specifikace vst. souboru: ');
     TextAttr:=$0A; Readln(outspec); TextAttr:=7;
     if outspec='' then Halt(1);
     Assign(Fout,outspec); Rewrite(Fout,1);
   end;
 {$I+}

 {Vstupn soubor pipraven ke zpracovn. te se zhlav
  CONTEXT left_mg right_mg heading footing pgsize}

  {$R+} BlockRead(Fin,inbuf[1],8192,inblk); {$R-}
  k:=1; Getsym;
  if S='CONTEXT' then
  begin
    GetSym; GetSym; GetSym; Val(S,i,errpos);
    GetSym; Val(S,j,errpos);
    Inc(i,j+1);     {tolik LF najt na likvidaci pat a zhlav}
    for j:=1 to i do
    begin while inbuf[k]<>10 do Inc(k); Inc(k) end
  end
  else k:=1;  {k ukazuje na prvn znak, co se m st}

 {Transformace souboru zan....}

 Expnt:=false; Index:=false; Ital:=false;
 UndLn:=false; Bold:=false;  Intab:=false;
 i:=k-1; outbuf[0]:=0;   {i..ukazatel na posledn ten znak}

 repeat
   j:=1;
   {j..voln pozice ve vstupu, i..posl. ten pozice vstupu}
   while i<inblk do   {i..posledn ten znak z Inbuf}
   begin
     Inc(i); c:=inbuf[i];
NewCh:
     case c of
      32: if IgnSpc then
	  begin
	    if outbuf[j-1]<>Space then
	    begin outbuf[j]:=c; Inc(j) end
	  end
	  else begin outbuf[j]:=c; Inc(j) end;
       0..4: begin
         repeat
           case c of
             0: Expnt:=not Expnt;     {nadsazen}
             1: Index:=not Index;     {podsazen}
             2: Ital:=not Ital;       {kursiva}
             3: UndLn:=not UndLn;     {podtren}
             4: Bold:=not Bold;       {tun psmo}
           end;
           GetChar;
         until c>4;
         Vent; goto NewCh
         end;
       6:begin
	   GetChar;
	   if c=ord('-') then  {rozdlen na konci dku}
           begin
             GetChar; GetChar; {pro 6 ignor. CR LF za - na konci dku}
             repeat GetChar until c<>Space; {ignorovn pp. mezer}
             Move(SoftBreak[1],outbuf[j],3); Inc(j,3); AppOff;
             goto NewCh
           end;
	   outbuf[j]:=c; Inc(j); GetChar; {vnitn dlen se sledem 6X6}
	   Move(SoftBreak[1],outbuf[j],3); Inc(j,3)
	 end;
      7: begin  {zadan - uvnit slova na konci dku}
           GetChar; Outbuf[j]:=c; Inc(j);    {- na vstup}
           GetChar; GetChar; {pro 6 ignor. CR LF za - na konci dku}
           repeat GetChar until c<>Space; {ignorovn pp. mezer}
           goto NewCh
         end;
     10: begin
           AppOff;  {pi LF vypneme vechny atributy textu}
           if InTab then   {Line Feed - konec dku a jsme v tabulce}
	   begin
             Move(ParSym[1],outbuf[j],4); Inc(j,4); {konec odstavce}
             Move(TabStr[1],outbuf[j],TabLen); Inc(j,TabLen) {nov dek tab.}
           end
           else  {musme nahradit LF mezerou, aby byla slova oddlena}
           begin
             cc:=outbuf[j-1];
             if (cc<>Space) and (cc<>LF) then
	     begin
               outbuf[j]:=Space; Inc(j)
             end
           end
         end;
     17: begin                    {konec odstavce}
	   AppOff; Move(ParSym[1],outbuf[j],4); Inc(j,4);
	   IgnSpc:=true;
	 end;
    158: begin Move(BigR[1],outbuf[j],5); Inc(j,5) end;
    169..172:
      begin
        Str(c:3,TrS); TrS:='<'+TrS+'>';
        Move(TrS[1],outbuf[j],5); Inc(j,5)
      end;
    250: begin Move(FxSpace[1],outbuf[j],3); Inc(j,3) end;
    21,173: begin Move(Parag[1],outbuf[j],5); Inc(j,5) end;
     26: begin outbuf[j]:=26; Inc(j) end;
     31: begin IgnSpc:=false; end;     {neform. odstavec}
     60: begin Move(Less[1],outbuf[j],2); Inc(j,2) end;
     62: begin Move(Greater[1],outbuf[j],2); Inc(j,2) end
    else
    case Use[c] of
     {0: ignorovn znaku}
     1: begin outbuf[j]:=c; Inc(j) end; {koprovn znaku na vstup}
     2: if InTab then                   {vechny svisl tabulkov znaky}
        begin
          outbuf[j]:=9; Inc(j)          {se zmn na tabeltory}
	end;
     3: begin
          InTab:=true;                  {poten znak tabulky}
          Inc(TabInd);
          write('Jmno ',TabInd,'. tabulky v textu: ');
          TextAttr:=$0A; readln(TabStr); TextAttr:=7;
          if TabStr='' then
          begin
            Str(TabInd,TabIndC);
            TabStr:='@TB'+TabIndC+' = '
          end
          else TabStr:='@'+TabStr+' = ';
          TabLen:=Length(TabStr); UpCon(TabStr);
          
          if (j>4) then
          begin
            Move(outbuf[j-4],Str4,4);
            if Str4<>ParSym then
            begin
              AppOff; Move(ParSym[1],outbuf[j],4); Inc(j,4);
            end          {doplnme konec odstavce, kdy nepedchz}
          end
          else AppOff;
          Move(TabStr[1],outbuf[j],TabLen);
          Inc(j,TabLen);                      {nov dek tabulky}
          outbuf[j]:=9; Inc(j)   {po. znak se zmn na tabeltor}
        end;
     4: begin
          InTab:=false;                 {koncov znak tabulky}
          outbuf[j]:=9; Inc(j);         {se zmn na tabeltor}
          Move(ParSym[1],outbuf[j],4); Inc(j,4);
        end
      end                               {of inner case}
    end;                                {of outer case}
  end;                                  {of while loop}
  Dec(j); outbuf[0]:=outbuf[j];
  BlockWrite(Fout,outbuf[1],j,outblk);
  if not eof(Fin) then
  begin
   {$R+} BlockRead(Fin,inbuf[1],8192,Inblk); {$R-} i:=0
  end
  else Inblk:=0;
 until Inblk=0;
 Close(Fin);
 Close(Fout);
 writeln('KonVen: Pevod dokonen. <Enter>.'); readln
end.
