

; ****************************************************************************
;              Textov driver displeje pro program kontext.com
;              po pekladu od adresy 0 m soubor jmno txt.ovl
; ****************************************************************************

code     SEGMENT   page
         ASSUME    cs:code,ds:code

         ORG       0

start:                                      ; vstup do driveru

displej  proc      far
                                            ; vyvoln podprogramu,
                                            ;  jeho slo je v BX
         push      ds
         mov       dx,cs
         mov       ds,dx                    ; datov segment = program. segment
         shl       bx,1
         call      word ptr ds:[bx+adrsub]  ; vyvoln podprogramu podle tabulky
         pop       ds
         ret
displej  endp


tabtxt   db        0
         db        3                        ; poet font
         db        6
         dw        konectxt
         db        8
         dw        konectxt
         db        14
         dw        konectxt

karta    db        'TXT'

invmsk   db        0                        ; maska znak (pro inverzi)
whide    db        0                        ; pznak dvojnsobnho znaku
mode     db        0                        ; reim obrazovky (1,2,3)
vyska    db        0                        ; poet linek na dek

; -----------------------------------------------------------------------------
;                         Parametry displeje
; -----------------------------------------------------------------------------
public   VideoCard,CheckSnow,AktVmod,TextVMOD,Monochr,AktPage,AdrVRAM,MaxRow
public   MaxCol,PortCRT

VideoCard db       ?                        ; typ videokarty
                                            ;     0=neznm typ
                                            ;     1=CGA
                                            ;     2=Mono CGA
                                            ;     3=EGA
                                            ;     4=EGA 64kB
                                            ;     5=EGA Mono
                                            ;    (6=IBM8514)
                                            ;     7=Hercules
                                            ;    (8=ATT400)
                                            ;     9=VGA
                                            ;   (10=PC3270)
CheckSnow db       ?                        ; pznak, e se kontroluje snen
AktVmod  db        ?                        ; aktuln videomd
TextVMOD db        ?                        ; pznak textovho videomdu
Monochr  db        ?                        ; pznak monochromatickho displeje
AktPage  db        ?                        ; aktuln videostrnka
AdrVRAM  dd        ?                        ; adresa videostrnky displeje
MaxCol   db        ?                        ; maximln pozice na dku
Pozic    dw        ?                        ; poet pozic na dek
MaxRow   db        ?                        ; maximln dek na displeji
PortCRT  dw        ?                        ; bzov adresa portu adie CRT



normal   db        0 ;(1*16+11)             ; barva normlnho textu

invert   db        0 ;(11*16+1)             ; barva textu menu

cara     db        0 ;(6*16+11)             ; barva okraje (hnd)
zvyraz   db        0 ;(16+14)               ; zvraznn psmo (lut)
sikme    db        0 ;(16+10)               ; ikm psmo (zelen)
podtrz   db        0 ;(16+13)               ; podtren psmo (fialov)
jine     db        0 ;(16+15)               ; jin kombinace typ (bl)


                                            ; ADRESY PODPROGRAM
adrsub   dw        offset fnc00             ; funkce 00 - vstup znaku
         dw        offset fnc01             ; funkce 01 - kurzor, mazn
         dw        offset fnc02             ; funkce 02 - rolovn nahoru
         dw        offset fnc03             ; funkce 03 - rolovn dol
         dw        offset fnc04             ; funkce 04 - prav okraj (ra)
         dw        offset fnc05             ; funkce 05 - inicializace parametr
         dw        offset fnc06             ; funkce 06 - nastaven text. mdu
         dw        offset fnc07             ; funkce 07 - adr. npovdy (ES:SI)
         dw        offset fnc08             ; funkce 08 - adr. chybovch hlen
         dw        offset fnc09             ; funkce 09 - rozdlovn slov
         dw        offset fnc10             ; funkce 10 - dekdovn kdu klves
         dw        offset fnc11             ; funkce 11 - vpis kdu klvesy



                                            ; FUNKCE 00 - vstup znaku

                                            ; SS:BP = ukazatel parametr znaku
                                            ;   +4 = dek znaku
                                            ;   +6 = pozice znaku na dku
                                            ;   +8 = znak k vstupu
                                            ; AH = md znaku
                                            ;   01 = nadsazen psmo
                                            ;   02 = podsazen psmo
                                            ;   04 = ikm psmo
                                            ;   08 = podtren text
                                            ;   10 = zvraznn psmo
                                            ;   20 = inverzn psmo
                                            ;   40 = rozdlovac znamnko
                                            ;   80 = dvojnsobn ka znaku

fnc00:
         cld
         mov       ch,ah                    ; md znaku
         mov       ax,[bp+4]                ; dek znaku
         mov       bx,ds:[Pozic]            ; poet pozic na dek
         mul       bx                       ; offset zatku dku
         mov       bx,[bp+6]                ; pozice znaku na dku
         dec       bx
         cmp       bx,0
         jl        fnc009                   ; je zporn pozice
         cmp       bx,ds:[Pozic]
         jnc       fnc009                   ; je velk pozice
         add       ax,bx                    ; poet znak od zatku obrazovky
         add       ax,ax                    ; offset znaku ve VRAM
         mov       di,ax
         add       di,word ptr ds:[AdrVRAM] ; offset potku strnky
         push      es
         mov       es,word ptr ds:[AdrVRAM+2] ; segment VRAM
         mov       ax,[bp+8]                ; znak k vstupu
         cmp       al,255                   ; je znak dvojnsobn ky ?
         jnz       fnc003                   ; nen
         mov       al,22                    ; znak silnho podtrhovtka
fnc003:  stosb                              ; uloen znaku k vstupu
         mov       al,ds:[invert]           ; inverzn psmo
         test      ch,20h                   ; inverzn psmo ?
         jnz       fnc001                   ; je inverzn psmo
fnc002:  mov       al,ds:[zvyraz]           ; zvraznn psmo
         test      ch,10h
         jnz       fnc001                   ; je zvraznn psmo
         mov       al,ds:[sikme]            ; ikm psmo
         test      ch,4
         jnz       fnc001
         mov       al,ds:[podtrz]           ; podtren text
         test      ch,8
         jnz       fnc001
         mov       al,ds:[jine]
         or        ch,ch
         jnz       fnc001                   ; jsou njak atributy
         mov       al,ds:[normal]           ; barva normlnho textu
fnc001:  stosb                              ; nastaven atributu znaku
         pop       es
fnc009:  ret

                                            ; FUNKCE 01 - kurzor a mazn

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = parametr pro zpis okna
                                            ;          = 0 normln okno
                                            ;          = 1 invertovan okno
                                            ;          = 2 kurzor
                                            ;    + 6 = konen dek
                                            ;    + 8 = konen pozice
                                            ;    +10 = poten dek
                                            ;    +12 = poten pozice

fnc01:
         cld
         mov       ax,[bp+10]               ; poten dek okna
         mov       bx,[bp+6]                ; konen dek
         cmp       ax,bx                    ; konen dek
         jbe       fnc01d1
         cmp       byte ptr [bp+4],2
         jnz       fnc01d1
         dec       ax
         mov       bx,ax
fnc01d1: mov       di,ax
         add       di,word ptr ds:[AdrVRAM]
         shl       di,1
         shl       di,1
         add       di,ax                    ; DI = AX * 5
         shl       di,1
         shl       di,1
         shl       di,1
         shl       di,1                     ; DI = offset zatku dku
         sub       bx,ax
         inc       bx
         mov       ax,[bp+12]               ; poten pozice
         or        ax,ax
         jg        fnc01a1                  ; je kladn pozice
         mov       ax,1
fnc01a1: mov       cx,[bp+8]                ; konen pozice na dku
         cmp       cx,ds:[Pozic]
         jng       fnc010r
         mov       cx,ds:[Pozic]
fnc010r: dec       ax                       ; poten pozice
         sub       cx,ax                    ; ka okna (pozic)
         jng       fnc011                   ; ka okna nen kladn
         add       di,ax                    ; offset zatku okna
         add       di,di                    ; adresa zatku okna ve VRAM
fnc0103: push      es
         mov       es,word ptr ds:[AdrVRAM+2]; segment VRAM
         cmp       byte ptr [bp+4],1        ; parametr
         ja        fnc0107                  ; je kurzor
         mov       ah,ds:[normal]           ; je normln text
         jc        fnc010a                  ; je inverzn text
         mov       ah,ds:[invert]           ; inverzn text
fnc010a: mov       al,32
fnc0104: push      di
         push      cx
         cld
         rep       stosw
         pop       cx
         pop       di
         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         dec       bx
         jnz       fnc0104
         pop       es
         ret

fnc0107:
fnc010:  push      di
         push      cx                       ; ta znak na dek
fnc0102: inc       di
         mov       al,es:[di]               ; nastaven atribut
         not       al
         call      TestEga
         jnc       fnc0106
         cmp       byte ptr ds:[Monochr],0
         je        fnc01e1
         not       al
         ror       al,1
         ror       al,1
         ror       al,1
         ror       al,1
fnc01e1: and       al,7fh
fnc0106: stosb
         dec       cx
         jnz       fnc0102
         pop       cx
         pop       di
         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         dec       bx                       ; ta dk
         jnz       fnc010                   ; dal dek
         pop       es
fnc011:  ret

                                            ; FUNKCE 02 - rolovn okna nahoru

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = konen pozice
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna

fnc02:   ; ret

         mov       ax,[bp+4]                ; konen dek k rolovn
         sub       ax,[bp+8]                ; poten dek k rol.-poet dk
         jz        fnc029                   ; nen dn dek - konec
         mov       bx,ax                    ; poet dk k rolovn
         mov       ax,[bp+8]                ; poten dek k rolovn
         mov       cx,ds:[Pozic]
         add       cx,cx
         mul       cx                       ; poten adresa pot. dku
         mov       si,ax                    ; poten adresa pot. dku
         mov       di,ax                    ; adresa nsledujcho dku
         add       si,ds:[Pozic]
         add       si,ds:[Pozic]
         mov       ax,[bp+10]               ; poten pozice okna
         dec       ax
         add       di,ax                    ; poten adresa
         add       di,ax
         add       si,ax
         add       si,ax
         mov       cx,[bp+6]                ; konen pozice
         sub       cx,ax                    ; poet pozic okna k rolovn
         add       cx,cx
         push      es
         push      ds
         add       si,word ptr ds:[AdrVRAM]
         add       di,word ptr ds:[AdrVRAM]
         mov       ax,word ptr ds:[AdrVRAM+2] ; segment displeje
         mov       es,ax
         mov       ds,ax
         cld                                ; penos nahoru
fnc022:  push      si
         push      di
         push      cx
         repnz     movsb
         pop       cx
         pop       di
         pop       si
         add       di,cs:[Pozic]
         add       di,cs:[Pozic]
         add       si,cs:[Pozic]
         add       si,cs:[Pozic]
         dec       bx
         jnz       fnc022
         pop       ds
         pop       es
fnc029:  ret






                                            ; FUNKCE 03 - rolovn okna dol

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = konen pozice okna
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna


fnc03:   ; ret

         mov       ax,[bp+4]                ; konen dek k rolovn
         sub       ax,[bp+8]                ; poten dek k rol.-poet dk
         jz        fnc039                   ; nen dn dek - konec
         mov       bx,ax                    ; poet dk k rolovn
         mov       ax,[bp+4]                ; konen dek k rolovn
         mov       cx,ds:[Pozic]
         add       cx,cx
         mul       cx                       ; poten adresa konenho dku
         mov       si,ax                    ; poten adresa konenho dku
         mov       di,ax                    ; adresa nsledujcho dku
         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         mov       ax,[bp+10]               ; poten pozice okna
         dec       ax
         add       di,ax                    ; poten adresa
         add       di,ax
         add       si,ax
         add       si,ax
         mov       cx,[bp+6]                ; konen pozice
         sub       cx,ax                    ; poet pozic okna k rolovn
         add       cx,cx
         push      es
         push      ds
         add       si,word ptr ds:[AdrVRAM]
         add       di,word ptr ds:[AdrVRAM]
         mov       ax,word ptr ds:[AdrVRAM+2] ; segment displeje
         mov       es,ax
         mov       ds,ax
         cld                                ; penos nahoru
fnc032:
         sub       di,cs:[Pozic]
         sub       di,cs:[Pozic]
         sub       si,cs:[Pozic]
         sub       si,cs:[Pozic]
         push      si
         push      di
         push      cx
         repnz     movsb
         pop       cx
         pop       di
         pop       si
         dec       bx
         jnz       fnc032
         pop       ds
         pop       es
fnc039:  ret





                                            ; FUNKCE 04 - prav okraj (ra)

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = kd ry
                                            ;    + 6 = konen dek
                                            ;    + 8 = poten dek
                                            ;    +10 = pozice ry

fnc04:
         cld
         mov       si,[bp+10]               ; pozice ry
         dec       si
         jl        fnc042                   ; zporn pozice
         cmp       si,ds:[Pozic]
         jae       fnc042
         mov       ax,[bp+6]                ; konen dek
         mov       di,[bp+8]                ; poten dek
         sub       ax,di
         inc       ax                       ; poet dk
         mov       cx,ax                    ; poet dk
         mov       ax,ds:[Pozic]
         mul       di
         mov       di,ax
         add       di,si
         add       di,di
         push      es
         mov       ax,word ptr ds:[AdrVRAM+2]
         mov       es,ax
         add       di,word ptr ds:[AdrVRAM]
         mov       dl,ds:[cara]             ; barva okraje
         mov       dh,ds:[normal]           ; barva normlnho textu
fnc041:  mov       al,es:[di+1]
         cmp       al,dl
         mov       al,dl
         jnz       fnc043
         mov       al,dh
fnc043:  mov       es:[di+1],al
         add       di,ds:[Pozic]
         add       di,ds:[Pozic]
         loop      fnc041
         pop       es
fnc042:  ret


                                            ; FUNKCE 05 - inicializace parametr

                                            ; SS:BP = ukazatel parametr znaku
                                            ;   +4 = barva podkladu
                                            ;   +6 = barva psma
                                            ;   +8 = reim obrazovky (dkovn)

fnc05:
         cmp       byte ptr ds:[VideoCard],0 ; je karta ji rozpoznna ?
         jnz       fnc0501                  ; karta je ji rozpoznna
         call      DetectCard               ; detekce videokarty
fnc0501:
         call      SetTextVMode             ; nastaven textovho videomdu

         mov       al,[bp+8]
         mov       [mode],al                ; poadovan md
         cld
                                          ;* nastaven normln barvy textu
         mov       ax,[bp+4]                ; barva podkladu
         mov       bx,[bp+6]                ; barva psma
         shl       al,1
         shl       al,1
         shl       al,1
         shl       al,1                     ; pprava barvy podkladu
         and       bl,0fh                   ; barva psma
         or        al,bl                    ; zadan barva textu
         mov       bl,al
         push      ax
         call      TestEga                  ; je karta EGA ?
         jnc       fnc0502                  ; je karta EGA
         and       al,7fh                   ; zruen pznaku blikn
fnc0502: mov       [normal],al              ; nastaven barvy normlnho textu
         pop       ax
                                          ;* nastaven invertovan barvy
         ror       al,1
         ror       al,1
         ror       al,1
         ror       al,1
         call      TestEga                  ; je karta EGA ?
         jnc       fnc0503                  ; je karta EGA
         and       al,7fh                   ; zruen pznaku blikn
fnc0503: mov       [invert],al

                                          ;* nastaven ostatnch barev
         mov       [zvyraz],al
         mov       [sikme],al
         mov       [podtrz],al
         mov       [jine],al
         cmp       byte ptr ds:[Monochr],0  ; je monochromatick displej ?
         jne       fnc051                   ; je monochromatick displej
         and       bl,0f0h
         mov       al,bl
         or        al,14
         mov       [zvyraz],al              ; zvraznn psmo
         mov       al,bl
         or        al,10
         mov       [sikme],al               ; ikm psmo
         mov       al,bl
         or        al,13
         mov       [podtrz],al              ; podtren psmo
         mov       al,bl
         or        al,15
         mov       [jine],al                ; jin psmo

                                          ;* nastaven barvy ry
fnc051:  mov       al,ds:[normal]
         xor       al,77h                   ; negace barvy
         mov       [cara],al                ; barva ry okraje
                                          ;* nastaven videomdu
         call      TestEga                  ; je karta EGA ?
         jc        fnc05a                   ; nen karta EGA

                                          ;* nastaven mdu EGA/VGA
fnc052:  mov       ax,1111h
         cmp       byte ptr ds:[mode],2
         je        fnc058
         mov       al,12h
         cmp       byte ptr ds:[mode],3
         jne       fnc059
fnc058:  xor       bx,bx
         int       10h                      ; nastaven hustho dkovn
fnc059:  mov       ax,1003h
         mov       bl,0                     ; pznak - intezivn podklad
         int       10h                      ; nastaven atributu s jasem
         mov       bh,[bp+4]                ; barva podkladu
         mov       ax,1001h
         int       10h                      ; nastaven okol obrazovky

fnc05a:                                   ;* nastaven parametr displeje
         call      AktParDisp               ; aktualizace parametr displeje
         call      KurzOff                  ; vypnut zobrazen kurzoru
         xor       cx,cx
         mov       cl,ds:[MaxRow]           ; maximln dek na displeji
         xor       ax,ax
         mov       al,ds:[MaxCol]           ; posledn znak na dku
         inc       ax                       ; poet znak na dek
         mov       ds:[Pozic],ax
         mov       si,offset karta          ; identifikan text karty
         mov       bx,1                     ; poet linek na dek
         ret


                                            ; FUNKCE 06 - nastaven tex. mdu
fnc06:   jmp       SetTextVMode             ; nastaven textovho mdu

                                            ; slovnk 1
slov1    db        'ANA ANI ABE ALTR EINI DEST GEI INI INS '
         db        'NACHT UNIV ZEITEN ZEITU ',0ffh

                                            ; slovnk 2
slov2    db        'AB AN AUF AUS NACH UN VER VOR ',0ffh

                                            ; slovnk 3
slov3    db        'ALT ALP BETT BERG DES EIN ERD ERNST FETT FEST '
         db        'GELD HAUS KREUZ LANG LEIT MACHT MAUS MENSCH NORD '
         db        'NCHST NETZ OBER OST REIT RCK SCHUL SPIEL SD '
         db        'TEST TIEF VOLL WACHS WASCH WEIT WETT WEG WEST ',0ffh

                                            ; slovnk 4
slov4    db        'DURCH LETZTEND SPORT TRANS ',0ffh

                                            ; slovnk 5
slov5    db        'DORT HOCH ZEIT BER ',0ffh

                                            ; slovnk 6
slov6    db        'CHA CURS DAR EMPF ENT HIN HER KOMP MIT SYN ',0ffh

                                            ; slovnk 7
slov7    db        'ABL ABR ALLEIN ANEI ANER ANORD ANS AT BEEH BEEI '
         db        'BEEN BEERD BEIRR BEOB BEUN BEUR ER GE IN KOOR '
         db        'OKT UM UR ZUGABE ',0ffh

                                            ; slovnk 8
slov8    db        'AI AU AY EI EU EY U ',0ffh

                                            ; slovnk 9
slov9    db        'EA E E E II I I I OA OE UE UI UU ',0ffh

                                            ; slovnk 10
slov10   db        'BL BR CH DR FL FR GL GR KL KN KR PFL PH PF '
         db        'PL PR SCHL SCHM SCHN SCHR SCHW STR SPR SCH '
         db        'SP ST TH TR ZW ',0ffh

                                            ; slovnk 11
slov11   db        'BS B CHTS CHS CHT CKT CH CK D FF FS F GS G '
         db        'HRS HL HM HN HR HT H KT K LBST LSCH LCH LFS '
         db        'LKS LTS LB LD LF LG LK LL LP LS LT L '
         db        'MPF MTS MM MP MT M NSCH NGS NDS NST ND NN NF '
         db        'NG NK NS NT NZ N PF PP PT P '
         db        'RSCH RCH RKT RST RB RD RF RG RK RM RN RS RT '
         db        'RZ R SCH ST S TSCH TZT TS TT TZ T XT Z '
         db        ' ',0ffh

                                            ; slovnk 12
slov12   db        'EITS IONS LLGE NSGE UNGS ',0ffh

                                            ; slovnk 13
slov13   db        'HAUS HEIT LICH LADE LAND LER LIG LOS PHA PREIS '
         db        'PUNKT RAND RAUM RECHT RECHN REICH RIG ROUT '
         db        'RUF ',0ffh

                                            ; slovnk 14
slov14   db        'AUS AUF AUGE AUTO AMT ART AB ARZT ARBEIT AKT '
         db        'ALGO ANALY ANDER ANF ANGAB ANGEB ANL ANOR '
         db        'ANSA ANTEIL ANWA ANWEN ANZAHL ANZEIG ANTW '
         db        'APFEL AFRI AMERI ADR APP ARGU EBENE ECK EDITO '
         db        'EIN EFF EURO ELEM ENERG ENTW EIMER ERDA '
         db        'ERGEBN ERFA ERLEB ERFO ERHAL ERKENN ETW EXP '
         db        'INDU INF INH INS IMP OBER ORDN ORDEN OPER ORGA '
         db        'ORIENT ORT UHR UMBRU UNFALL UNTER UMSATZ '
         db        'URLAUB URSACH URTEIL RZT NDER MT FFN '
         db        'KO B ',0ffh

b0aa4    db        0                        ; povolen dlka dku
b0aa5    dw        0                        ; adresa pevodn tabulky znak
w0aa7    dw        0
                                            ; test, zda jde o oddlovac znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je oddlovac znak

tst04:   mov       ah,4
         jmp       short tst401

                                            ; test, zda jde o dc znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je dc znak

tst40:   mov       ah,40h
tst401:  mov       al,[bx+di]               ; znak z textu k otestovn
         push      bx
         mov       bx,cs:[b0aa5]            ; adresa tabulky oddlovacch znak
         db        26h
         xlat                               ; transformace podle tab. ES:BX
         test      ah,al
         pop       bx
         ret

                                            ; nalezen zatku slova v textu
                                            ; vstup:  DS:[BX+DI] = ukaz.textu

endwrd:  dec       bx                       ; ukazatel textu
endwrd1: inc       bx
         call      tst40                    ; test, zda jde o dc znak
         jnz       endwrd2                  ; je dc znak - konec
         test      al,4                     ; jde o oddlovac znak slova ?
         jnz       endwrd1                  ; je oddlovac znak slova - dal
endwrd2: ret

                                            ; nalezen slova ve slovnku

                                            ; vstup:  CS:[SI] = ukazatel tabulky
                                            ;         DS:[BX+DI] = ukaz. textu
                                            ; vstup: AX = dlka shodnho slova
                                            ;         (AX = 0,ZF = 0 nenalezeno)

srcwrd:  mov       ah,32                    ; oddlovac znak slov (mezera)
srcwrd1: mov       al,cs:[si]               ; prvn znak slova z tabulky
         cmp       al,[bx+di]               ; porovnn se znakem v textu
         ja        srcwrd5                  ; znak v tabulce vt - nenalezeno
         jc        srcwrd3                  ; znak v tabulce men - dal slovo
         push      bx                       ; (shoda prvnho znaku) ukaz. textu
srcwrd2: inc       bx                       ; ukazatel zkoumanho textu
         inc       si                       ; ukazatel slovnku
         mov       al,cs:[si]               ; dal znak ze slovnku
         cmp       al,ah                    ; je mezera (konec slova) ?
         jz        srcwrd4                  ; je mezera = konec slova
         cmp       al,[bx+di]               ; porovnn dalho znaku slova
         jz        srcwrd2                  ; shoda - dal znak
         pop       bx                       ; (nen shoda) ukazatel textu
srcwrd3: inc       si                       ; nalezen dalho slova v tabulce
         cmp       ah,cs:[si]               ; je oddlovac mezera ?
         jnz       srcwrd3                  ; jet ne - dal znak v tabulce
         inc       si
         jmp       short srcwrd1            ; test dalho slova
srcwrd4: mov       ax,bx                    ; slova se shoduj
         pop       bx                       ; adresa slova ve slovnku
         sub       ax,bx                    ; dlka nalezenho slova
         ret
srcwrd5: xor       ax,ax                    ; slovo nenalezeno - konec (dlka 0)
         ret


lab0af5: push      bx                       ; adresa textu
         add       bx,ax                    ; adresa konce slabiky (rozdlit)
         push      bx                       ; adresa konce slabiky
         call      endwrd                   ; nalezen konce slova v textu
         mov       ax,bx                    ; konec slova v textu
         pop       bx                       ; adresa konce slabiky
         jz        lab0af51                 ; je ji konec dku
         sub       ax,bx                    ; poet znak do konec slova
         cmp       al,1                     ; dlka zbyl sti slova
         jna       lab0af52                 ; nen ji dn znak
         push      ax                       ; dlka zbyl sti slova
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       si                       ; dlka zbyl sti slova
         cmp       ax,si                    ; nalezeno stejn dlouh slovo ?
         jz        lab0af52                 ; je cel slovo
         xor       ax,ax                    
lab0af51:pop       bx                       
         ret                                
lab0af52:pop       si                       
lab0af53:cmp       bl,cs:[b0aa4]             ; povolen dlka dku
         jnc       lab0af55                  ; pekroen okraj dku
         inc       dx                       
         cmp       dx,bx                    
         mov       dx,bx                    
         jz        lab0af54                 
         mov       cs:[w0aa7],bx
lab0af54:ret                                
lab0af55:jmp       fnc097

                                            ;
lab0b2f: mov       si,offset slov1          ; slovnk 1 - nelze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0b2f5                 ; slovo nalezeno - konec
lab0b2f1:mov       si,offset slov2          ; slovnk 2 - lze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f2                 ; slovo nenalezeno - slovnk 3
         call      lab0af5                 
         jnz       lab0b2f1                
lab0b2f2:mov       si,offset slov3          ; slovnk 3
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f3                
         mov       si,di                   
         add       si,ax                   
         cmp       byte ptr [bx+si],"E"     ; je znak "E" ?
         jnz       lab0b2f4                
lab0b2f3:mov       si,offset slov4          ; slovnk 4
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,5                    
         jnz       lab0b2f4                
         mov       si,offset slov5          ; slovnk 5
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,4                    
         jnz       lab0b2f4                
         mov       si,offset slov6          ; slovnk 6
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,3                    
         jnz       lab0b2f4                
         mov       si,offset slov7          ; slovnk 7
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,2                    
         jz        lab0b2f5                
lab0b2f4:call      lab0af5                 
lab0b2f5:ret

lab0b85: mov       ax,bx                   
         sub       ax,cx                   
         cmp       ax,2                    
         xchg      bx,cx                   
         jc        lab0b853                
         jz        lab0b851                
         mov       si,offset slov8          ; slovnk 8
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b851                
         inc       bx                      
         jmp       short lab0b852          
lab0b851:mov       si,offset slov9          ; slovnk 9
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b853                
         cmp       byte ptr [bx+di-1],"Q"   ; je znak "Q" ?
         jz        lab0b853                
lab0b852:inc       bx                      
         call      lab0af53                
lab0b853:xchg      bx,cx                   
         ret       

lab0bb2: cmp       bx,cx
         jz        lab0bb27
         push      bx
         push      dx
         mov       dx,bx
         dec       dx
         mov       bx,cx
         dec       bx
lab0bb21:inc       bx
         cmp       bx,dx
         jz        lab0bb22
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0bb21
         add       ax,bx
         dec       ax
         cmp       ax,dx
         jnz       lab0bb21
         cmp       byte ptr [bx+di-1],"C"   ; byl pedchoz znak "C" ?
         jz        lab0bb21
lab0bb22:xchg      bx,cx
         mov       si,offset slov11         ; slovnk 11
         call      srcwrd                   ; nalezen slova ve slovnku
         add       bx,ax
         xchg      bx,cx
         cmp       bx,cx
         jnc       lab0bb26
         mov       dx,bx
lab0bb23:mov       si,offset slov12         ; slovnk 12
         push      bx
         sub       bx,4
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       bx
         jz        lab0bb24
         cmp       byte ptr cs:[w0aa7],0
         jnz       lab0bb26
lab0bb24:call      tst40                    ; test, zda jde o dc znak
         mov       si,offset slov14         ; slovnk 14
         jnz       lab0bb25
         mov       si,offset slov13         ; slovnk 13
lab0bb25:call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0bb26
         inc       bx
         cmp       bx,cx
         jna       lab0bb23
         mov       bx,dx
lab0bb26:pop       dx
         call      lab0af53
         pop       bx
lab0bb27:ret

                                            ; FUNKCE 09 - rozdlovn slov
                                            ; vstup:  DS = datov segment textu
                                            ;         CX = pozice v dku

fnc09:   mov       [w0aa7],0
         mov       [b0aa4],al               ; povolen dlka dku
         mov       [b0aa5],si               ; adresa transforman tabulky znak
         pop       dx                       ; nvratov adresa programu
         pop       ds                       ; datov segment textu
         push      ds                       ; datov segment textu
         push      dx                       ; nvratov adresa programu
         push      bp                       
         mov       bp,sp                    
fnc091:  mov       bx,cx                    ; aktuln pozice v dku
         dec       bx                       
fnc092:  inc       bx                       ; dal znak
         cmp       bl,cs:[b0aa4]            ; povolen dlka dku
         jnc       fnc097                   ; pekroen okraj dku - konec
         call      tst04                    ; test, zda jde o oddlovac znak
         jz        fnc092                   ; nenalezeno - dal
         mov       cx,bx                    ; nov pozice rozdlen slova
         dec       bx                       
fnc093:  inc       bx                       
         call      tst04                    ; test, zda jde o oddlovac znak
         jnz       fnc093                   ; nalezeno - dal pokus
         xchg      bx,cx                    
         mov       ax,cx                    
         sub       ax,bx                    
         cmp       ax,4                     
         jc        fnc091                   
         mov       dx,bx                    
         call      lab0b2f                  
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc091                   
         push      cx                       
fnc094:  mov       cx,bx                    
         dec       bx                       
fnc095:  inc       bx                       
         call      tst40                    ; test, zda jde o dc znak
         jnz       fnc095                   
         call      lab0b85                  
         mov       cx,bx                    
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc096                   
         call      lab0bb2                  
         jmp       short fnc094             
fnc096:  pop       cx                       
         jmp       short fnc091             
fnc097:  mov       ax,cs:[w0aa7]            
         mov       sp,bp                    
         pop       bp                       
         ret                                


                                            ; tabulka pro pekdovn klves

tabkey   db        0c1h,1eh                 ; ALT A
         db        0c2h,30h                 ; ALT B
         db        0c3h,2eh                 ; ALT C
         db        0c4h,20h                 ; ALT D
         db        0c5h,12h                 ; ALT E
         db        0c6h,21h                 ; ALT F
         db        0c7h,22h                 ; ALT G
         db        0c8h,23h                 ; ALT H
         db        0c9h,17h                 ; ALT I
         db        0cah,24h                 ; ALT J
         db        0cbh,25h                 ; ALT K
         db        0cch,26h                 ; ALT L
         db        0cdh,32h                 ; ALT M
         db        0ceh,31h                 ; ALT N
         db        0cfh,18h                 ; ALT O
         db        0d0h,19h                 ; ALT P
         db        0d1h,10h                 ; ALT Q
         db        0d2h,13h                 ; ALT R
         db        0d3h,1fh                 ; ALT S
         db        0d4h,14h                 ; ALT T
         db        0d5h,16h                 ; ALT U
         db        0d6h,2fh                 ; ALT V
         db        0d7h,11h                 ; ALT W
         db        0d8h,2dh                 ; ALT X
         db        0d9h,15h                 ; ALT Y
         db        0dah,2ch                 ; ALT Z
         db        0f0h,81h                 ; ALT 0
         db        0f1h,78h                 ; ALT 1
         db        0f2h,79h                 ; ALT 2
         db        0f3h,7ah                 ; ALT 3
         db        0f4h,7bh                 ; ALT 4
         db        0f5h,7ch                 ; ALT 5
         db        0f6h,7dh                 ; ALT 6
         db        0f7h,7eh                 ; ALT 7
         db        0f8h,7fh                 ; ALT 8
         db        0f9h,80h                 ; ALT 9
         db        1bh,3bh                  ; F1
         db        1ch,3ch                  ; F2
         db        1dh,3dh                  ; F3
         db        1eh,3eh                  ; F4
         db        1fh,3fh                  ; F5
         db        20h,40h                  ; F6
         db        21h,41h                  ; F7
         db        22h,42h                  ; F8
         db        23h,43h                  ; F9
         db        24h,44h                  ; F10
         db        5bh,54h                  ; SHIFT F1
         db        5ch,55h                  ; SHIFT F2
         db        5dh,56h                  ; SHIFT F3
         db        5eh,57h                  ; SHIFT F4
         db        5fh,58h                  ; SHIFT F5
         db        60h,59h                  ; SHIFT F6
         db        61h,5ah                  ; SHIFT F7
         db        62h,5bh                  ; SHIFT F8
         db        63h,5ch                  ; SHIFT F9
         db        64h,5dh                  ; SHIFT F10
         db        9bh,5eh                  ; CTRL F1
         db        9ch,5fh                  ; CTRL F2
         db        9dh,60h                  ; CTRL F3
         db        9eh,61h                  ; CTRL F4
         db        9fh,62h                  ; CTRL F5
         db        0a0h,63h                 ; CTRL F6
         db        0a1h,64h                 ; CTRL F7
         db        0a2h,65h                 ; CTRL F8
         db        0a3h,66h                 ; CTRL F9
         db        0a4h,67h                 ; CTRL F10
         db        0dbh,68h                 ; ALT F1
         db        0dch,69h                 ; ALT F2
         db        0ddh,6ah                 ; ALT F3
         db        0deh,6bh                 ; ALT F4
         db        0dfh,6ch                 ; ALT F5
         db        0e0h,6dh                 ; ALT F6
         db        0e1h,6eh                 ; ALT F7
         db        0e2h,6fh                 ; ALT F8
         db        0e3h,70h                 ; ALT F9
         db        0e4h,71h                 ; ALT F10
         db        0a5h,73h                 ; CTRL <-
         db        0a6h,74h                 ; CTRL ->
         db        0a7h,77h                 ; CTRL HOME
         db        0a8h,75h                 ; CTRL END
         db        0a9h,84h                 ; CTRL PGUP
         db        0aah,76h                 ; CTRL PGDN
         db        6bh,0fh                  ; SHIFT TAB
         db        0,0                      


tabshf   db        6                        ; dlka jedn poloky
         db        0,'     '                ; 00h
         db        5,'SHIFT'                ; 40h
         db        4,'CTRL '                ; 80h
         db        3,'ALT  '                ; C0h
         db        0ffh                     

tabhome  db        5                        ; dlka jedn poloky
         db        2,'<-  '                 ; 25h
         db        2,'->  '                 ; 26h
         db        4,'HOME'                 ; 27h
         db        3,'END '                 ; 28h
         db        4,'PGUP'                 ; 29h
         db        4,'PGDN'                 ; 2Ah
         db        3,'TAB '                 ; 2Bh
         db        0ffh                     

tabfn    db        4                        ; dlka jedn poloky
         db        2,'F1 '                  ; 1Bh
         db        2,'F2 '                  ; 1Ch
         db        2,'F3 '                  ; 1Dh
         db        2,'F4 '                  ; 1Eh
         db        2,'F5 '                  ; 1Fh
         db        2,'F6 '                  ; 20h
         db        2,'F7 '                  ; 21h
         db        2,'F8 '                  ; 22h
         db        2,'F9 '                  ; 23h
         db        3,'F10'                  ; 24h
         db        0ffh                     

                                            ; pevod textu na velk psmena

                                            ; vstup:  ES:SI = ukazatel na text
                                            ;         BL = nejmen znak
                                            ; vstup: ES:[BX+SI] = zatek textu
                                            ;         CX = poet znak textu
                                            ;         CF=0,ZF=0 je konec textu
                                            ;         CF=0,ZF=1 nen jet konec

upper:   xor       cx,cx                    ; vynulovn tae znak
upper1:  cmp       bl,es:[si]               ; porovnn znaku s BL
         ja        upper6                   ; znak je men ne BL - konec
         cmp       byte ptr es:[bx+si]," "  ; je mezera ?
         jnz       upper2                   ; nen - konec hledn
         inc       bx                       ; dal pozice
         jmp       short upper1             ; dal znak
upper2:  push      bx                       
upper3:  cmp       bl,es:[si]               ; kontrola koncovho znaku
         ja        upper5                   ; znak je men ne BL - konec
         mov       al,es:[bx+si]            ; peten znaku k pekdovn
         cmp       al," "                   ; je mezera ?
         jz        upper5                   ; je mezera - konec
         cmp       al,"|"                   ; "|"
         jz        upper5                   ; je znak "|" - konec
         cmp       al,"a"                   ; "a"
         jc        upper4                   ; je znak men ne "a"
         and       al,0dfh                  ; pevod na velk psmeno
         mov       es:[bx+si],al            ; uloen pevedenho znaku
upper4:  inc       bx                       ; dal znak
         inc       cx                       ; zven tae nalezench znak
         jmp       upper3                   ; pevod dalho znaku na velk
upper5:  pop       bx                       
upper6:  ret                                

                                            ; nalezen textov poloky v tabulce

                                            ; vstup:  ES:[BX+SI] ukazatel textu
                                            ;         DS:DI = ukazatel tabulky
                                            ;         CX = dlka hled. textu
                                            ; vstup: ES:[BX+SI] nov pozice
                                            ;         DL = poad. slo poloky
                                            ;         AX = dlka poloky tabulky

srctab:  mov       al,[di]                  ; peten dlky jedn poloky
         mov       ah,0                     
         inc       di                       ; ukazatel tabulky - prvn poloka
         xor       dl,dl                    ; ta poloek
srctab1: inc       dx                       ; zven tae poloek
         cmp       cl,[di]                  ; porovnn dlky textu
         jnz       srctab4                  ; nesouhlas - dal poloka
         push      ax                       ; dlka jedn poloky
         push      bx                       ; ukazatel textu
         push      cx                       ; dlka textu
         push      di                       ; ukazatel tabulky
         inc       di                       ; prvn znak poloky
srctab2: mov       al,es:[bx+si]            ; zkouman znak
         cmp       al,[di]                  ; porovnn se znakem z tabulky
         jnz       srctab3                  ; nesouhlas - dal poloka
         inc       bx                       ; zven ukazatele textu
         inc       di                       ; zven ukazatele tabulky
         loop      srctab2                  ; dal znak k testu
         pop       di                       ; ukazatel tabulky - nalezeno
         pop       cx                       ; dlka textu
         pop       ax                       ; zruen pvodn pozice textu BX
         pop       ax                       ; dlka jedn poloky
         or        dl,dl                    ; poadov slo poloky
         ret                                
srctab3: pop       di                       ; ukazatel tabulky
         pop       cx                       ; dlka textu
         pop       bx                       ; ukazatel zkoumanho textu
         pop       ax                       ; dlka jedn poloky
srctab4: add       di,ax                    ; adresa dal poloky
         cmp       byte ptr [di],0ffh       ; je koncov znak tabulky ?
         jnz       srctab1                  ; nen jet konec
         xor       dl,dl                    ; nenalezen - slo poloky = 0
         ret                                


                                            ; FUNKCE 10 - dekdovn klvesy

                                            ; vstup:  ES:SI = ukazatel textu
                                            ; vstup: ES:SI = nov pozice
                                            ;         AX = kd klvesy

fnc10:   mov       bx,1                     ; koncov znak = 00
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         mov       di,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      srctab                   ; nalezen textov poloky v tabulce
         mov       dh,dl                    ; poadov slo poloky - schova
         jz        fnc103                   ; text nebyl nalezen
         dec       dh                       ; poad. slo poloky - 1
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         cmp       cx,1                     ; je pouze jeden znak ?
         jnz       fnc102                   ; nen prv jeden znak
         mov       al,es:[bx+si]            ; znak k pekdovn
         cmp       al,"@"                   ; = "@"
         jc        fnc101                   ; men ne "@"
         cmp       al,"Z"                   ; = "Z"
         ja        fnc106                   ; vt ne "Z"
         sub       al,40h                   ; pevod na dc znak
fnc101:  mov       dl,al                    ; pekdovan znak
         jmp       short fnc104             
fnc102:  mov       di,offset tabhome        ; tabulka dcch klves HOME,...
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc103                   ; poloka nenalezena
         add       dl,24h                   ; korekce
         jmp       short fnc104
fnc103:  mov       di,offset tabfn          ; tabulka funknch klves Fn
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc106                   ; nenalezena
         add       dl,1ah                   ; korekce
fnc104:  ror       dh,1                     
         ror       dh,1                     
         or        dl,dh                    ; klvesy SHIFT,.. jako bity 6 a 7
         mov       di,offset tabkey         ; tabulka pro dekdovn kd klves
fnc105:  mov       al,[di]                  ; kd klvesy
         inc       di                       
         inc       di                       
         or        al,al                    ; je posledn kd ?
         jz        fnc106                   ; kd klvesy nenalezen
         cmp       al,dl                    ; porovnn s hledanm kdem
         jnz       fnc105                   ; dal pokus
         dec       di                       
         mov       al,[di]                  ; pekdovn kdu klvesy
         mov       ah,0                     
         ret                                
fnc106:  xor       ax,ax                    ; kd klvesy nenalezen
         ret                                

                                            ; vpis kdu klvesy

                                            ; vstup:  CS:SI tabulka klves
                                            ;         DL = poad. slo klvesy
                                            ;         DS:[BX+DI] = vst. buffer
                                            ;         CH = 0
                                            ; vstup: DS:[BX+DI] = nov pozice

outkey:  push      ax                       
         mov       al,cs:[si]               ; dlka jedn poloky v tabulce
         mul       dl                       ; rel. adresa poloky v tabulce
         add       si,ax                    ; adresa poloky v tabulce
         inc       si                       
         mov       cl,cs:[si]               ; dlka textu v poloce
         jcxz      outkey2                  
outkey1: inc       si                       ; znak poloky textu klvesy
         inc       bx                       ; ukazatel vstupnho textu
         mov       al,cs:[si]               ; peten znaku poloky
         mov       [bx+di],al               ; uloen do bufferu
         loop      outkey1                  ; dal znak
         inc       bx                       ; nsledujc pozice
         mov       byte ptr [bx+di]," "     ; oddlovac mezera
outkey2: pop       ax                       
         ret                                

adrtab   dw        offset tabkey            ; ukazatel dekdovac tabulky klves


                                            ; FUNKCE 11 - vpis kdu klvesy

                                            ; vstup:  DS:[BX+DI] = vst. buffer
                                            ;         AX = kd klvesy
                                            ; vstup: DS:[BX+DI] = nov adresa

fnc11:   mov       dx,ax                    ; kd klvesy
         xor       cx,cx                    ; ta znak
         mov       bx,[adrtab]              ; ukazatel dekdovac tabulky klves
         inc       bx                       ; dal klvesa
fnc111:  mov       al,[bx]                  ; kd klvesy
         or        al,al                    ; je ukonovac znak 00 ?
         jnz       fnc112                   ; nen jet konec
         mov       [adrtab],offset tabkey   ; nastav. za. dekd. tabulky klves
         mov       es,dx
         mov       es:[di],ch               ;
         ret       
fnc112:  push      si                       ; ukazatel tabulky klves
fnc113:  mov       ah,es:[si]               ; kd klvesy
         or        ah,ah
         jz        fnc114                   ; je ji posledn
         cmp       al,ah                    ; porovnn s hledanou klvesou
         jz        fnc115                   ; je nalezen kd klvesy
         inc       si                       ; dal klvesa
         mov       cl,es:[si]               ;
         inc       cx
         add       si,cx                    ; adresa nsledujcho textu
         jmp       short fnc113             ; nov pokus
fnc114:  pop       si
         inc       bx
         inc       bx
         jmp       short fnc111
fnc115:  inc       bx
         mov       [adrtab],bx              ; nov adresa ukazatele tabulky
         mov       al,[bx-2]                ; kd klvesy
         inc       si
         pop       bx
         push      si
         push      dx
         pop       ds
         xor       bx,bx
         mov       dl,al
         and       dl,0c0h
         rol       dl,1
         rol       dl,1
         mov       si,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      outkey                   ; vpis kdu klvesy
         mov       dl,al
         and       dl,3fh
         cmp       dl,1ah
         ja        fnc116
         add       dl,40h
         inc       bx
         mov       [bx+di],dl
         jmp       short fnc119
fnc116:  cmp       dl,24h
         ja        fnc117
         sub       dl,1bh
         mov       si,offset tabfn          ; tabulka funknch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc117:  cmp       dl,2bh                   ; znak "+"
         ja        fnc118
         sub       dl,25h
         mov       si,offset tabhome        ; tabulka dcch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc118:  inc       bx
         mov       [bx+di],dl
fnc119:  cmp       bx,9
         ja        fnc11a
         inc       bx
         mov       byte ptr [bx+di]," "     ; oddlovac znak mezery
         jmp       short fnc119
fnc11a:  inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         pop       si
         mov       cl,es:[si]
fnc11b:  inc       si
         mov       al,es:[si]               ; peten znaku k vytitn
         inc       bx
         cmp       al," "
         jnc       fnc11c                   ; nen dc znak
         mov       byte ptr [bx+di],"^"     ; uloen znaku "^" (znak s CTRL-)
         inc       bx                       ; zven ukazatele
         or        al,40h                   ; pevod znaku na tisknuteln znak
fnc11c:  mov       [bx+di],al               ; uloen znaku
         loop      fnc11b                   ; pevod dalho znaku
         inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         mov       [di],bl
         ret       

tab01:                                      ; povely s CTRL-
         db        1
         db        27
         db        1
         db        80
         db        18
         db        17,'$$',15
         db        ' Povely s CTRL- ',31
         db        2,'$Kurzor...$ '
         db        4,'$Obrazovka...$'
         db        5,'$Zvltn...$',31
         db        ' S vlevo',2,'(',0fbh,')'
         db        4,'C strnka dol'
         db        5,'B formtuj',31
         db        ' X dol',3,'(',0f9h,')'
         db        6,'(PgDn)',13,'odstavec',31
         db        ' D vpravo (',0fah,')'
         db        4,'R strnka nahoru'
         db        3,'L pokrauj',31
         db        ' E nahoru (',0f8h,')'
         db        6,'(PgUp)',13,'v hledn',31
         db        ' A slovo vlevo'
         db        3,'Z dek dol'
         db        7,'M konec odstavce',31
         db        ' F slovo vpravo'
         db        2,'W dek nahoru'
         db        7,'<Enter>',31
         db        ' I na dal'
         db        25,'N vloen',31
         db        3,'tabeltor'
         db        6,'$Podmenu...$'
         db        8,'dku',31
         db        17,'J info/displej'
         db        5,'V vkldn',31
         db        2,'$Mazn...$'
         db        4,'K blok/soubor'
         db        8,'zap/vyp',31
         db        ' G znaku nad'
         db        5,'O formtovn/'
         db        7,'<Insert>',31
         db        3,'kurzorem'
         db        8,'nastavovn'
         db        6,'\ zvltn znaky',31
         db        ' H znaku vlevo'
         db        3,'P typy psma'
         db        7,'- zmna znak',31
         db        ' T slova vpravo'
         db        2,'Q pesuny kurzoru/'
         db        1,'] text do buff.',31
         db        ' Y dku'
         db        11,'hledn/zmna'
         db        3,'^ text z buff.'
         db        0

tab02:                                      ; ^J
         db        0
         db        58
         db        1
         db        80
         db        16
         db        11,' CTRL J ',31
         db        ' B',2,'dky displeje',31
         db        ' C',2,'barvy displeje',31
         db        ' F',2,'blikn zap/vyp',31
         db        ' H',2,'pomoc zap/vyp',31
         db        ' -------------------',31
         db        ' G',2,'graf.editor',31
         db        ' I',2,'pracovn prostor',31
         db        ' D',2,'zpis data',31
         db        ' T',2,'zpis asu',31
         db        ' K',2,'kalend/hodiny',31
         db        ' -------------------',31
         db        ' R',2,'vpoty v textu',31
         db        ' S',2,'sloupcov souty',31
         db        ' M',2,'sloupcov prmr'
         db        0

tab03:                                      ; ^K
         db        0
         db        35
         db        1
         db        80
         db        14
         db        14,'$$'
         db        17,' CTRL K ',31
         db        17,'$Blok....$',31
         db        ' B',2,'oznaen zatku'
         db        6,'C',2,'koprovn ',31
         db        ' K',2,'oznaen konce'
         db        8,'V',2,'pesunut',31
         db        ' N',2,'sloupcov blok'
         db        8,'Y',2,'mazn',31
         db        ' H',2,'zobrazen zap/vyp'
         db        5,'R',2,'ten',31
         db        ' T',2,'zmna psma'
         db        11,'W',2,'uloen',31
         db        ' G',2,'penos z'
         db        ' jinho pracovnho prostoru',31
         db        ' ------------------------------------------',31
         db        ' D',2,'menu souboru'
         db        10,'E',2,'mazn textu',31
         db        ' P',2,'menu tisku'
         db        12,'L',2,'ten textu',31
         db        '1-5 zmna prac. prostoru'
         db        2,'S',2,'uloen textu',31
         db        ' Q',2,'ukonen KonTextu'
         db        5,'X',2,'start programu'
         db        0

tab04:                                      ; ^O
         db        0
         db        23
         db        1
         db        80
         db        15
         db        24,'$$'
         db        20,' CTRL O ',31
         db        3,'$Pepnae zap/vyp'
         db        8,'Formtovn$',31
         db        ' J',2,'zarovnvn'
         db        11,'B',2,'formt. po konec textu',31
         db        ' H',2,'dlen slov'
         db        11,'C',2,'centrovn dku',31
         db        ' Q',2,'dlen s dotazem'
         db        6,'Z',2,'dvousloupcov formtovn',31
         db        ' V',2,'automat.tabeltor',31
         db        ' M',2,'<Enter>=kon.odst.'
         db        7,'$Nastaven strnky$',31
         db        ' P',2,'zobrazen strnky'
         db        5,'I',2,'menu linelu dku',31
         db        ' T',2,'zobrazen linelu'
         db        5,'F',2,'prav okraj=konec dku',31
         db        ' N',2,'nedokumentn md'
         db        6,'L',2,'lev okraj=pozice kurzoru',31
         db        26,'R',2,'prav okraj=pozice kurzoru',31
         db        26,'S',2,'poet dk na strnku',31
         db        ' A',2,'zatek odstavce',2,0f0h
         db        3,'E',2,'zobrazen zhlav/paty',31
         db        ' U',2,'neformtovat',6,0ffh
         db        3,'O',2,'blok jako zhlav/pata'
         db        0

tab05:                                      ; ^P
         db        0
         db        59
         db        1
         db        80
         db        9
         db        10,' CTRL P ',31
         db        ' N=normln',31
         db        ' F=zvraznn',31
         db        ' U=podtren',31
         db        ' K=kurzva',31
         db        ' B=irok',31
         db        ' H=nadsazen',31
         db        ' T=podsazen'
         db        0,0,0,0,0,0,0,0

tab06:                                      ; ^Q
         db        0
         db        39
         db        1
         db        80
         db        13
         db        30,' CTRL Q ',31
         db        ' A',2,'hledn/zmna'
         db        5,'F',2,'hledn',31
         db        ' M',2,'nastaven znaky'
         db        3,'T',2,'makroklvesy',31
         db        ' L',2,'navrcen poslednch zmn   ',31
         db        10,'$Pozice kurzoru...$',31
         db        ' S',2,'zatek dku'
         db        6,'D',2,'konec dku',31
         db        ' E',2,'horn okraj'
         db        8,'X',2,'doln okraj',31
         db        ' R',2,'zatek textu'
         db        6,'C',2,'konec textu',31
         db        ' B',2,'zatek bloku'
         db        6,'K',2,'konec bloku',31
         db        ' P',2,'na znaku'
         db        10,'Z',2,'pozice',31
         db        14,'$Mazn...$',31
         db        ' H',2,'po zatek dku'
         db        3,'Y',2,'po konec dku'
         db        0,0

tab07:                                      ; ^JC
         db        1
         db        52
         db        1
         db        80
         db        10
         db        16,' CTRL JC ',31,31
         db        2,'--- Nastaven barev ---',31
         db        ' Zadejte slo barvy nebo',31
         db        ' zvolte <Enter>=beze zmny',31,31
         db        ' Barva psma (0..15):',31
         db        ' Barva okol (0..15):'
         db        0

tab08:                                      ; ^JI
         db        1
         db        54
         db        1
         db        80
         db        13
         db        13,' CTRL JI ',31,31
         db        ' - Pracovn prostor : - ',31
         db        '$   obsah          dk$',31
         db        31,31,31,31,31,31
         db        ' text :'
         db        7,'B volnch',31
         db        ' makra:'
         db        7,'B volnch'
         db        0

tab09:                                      ; ^JK
         db        1
         db        49
         db        1
         db        80
         db        16
         db        19,' CTRL JK ',31
         db        31,31,31
         db        2,'PO',2,'T',2,'ST',2,'T',2,'P',2,'SO',2,'NE',31
         db        ' ============================',31
         db        31,31,31,31,31,31
         db        ' ============================',31
         db        1,0fbh,2,'pedch.'
         db        2,0fah,' nsled.  msc',31
         db        1,0f9h,2,'pedch.',2,0f8h,' nsled.  rok '
         db        0

tab10:                                      ; ^KD
         db        1
         db        61
         db        1
         db        80
         db        17
         db        8,' CTRL KD ',31
         db        ' ti text',31
         db        ' ulo text',31
         db        ' ti blok',31
         db        ' ulo blok',31
         db        ' zru soubor',31
         db        ' pejmenuj soubor',31
         db        ' kopruj soubor',31
         db        ' start programu',31
         db        ' ulo nastaven',31
         db        ' konec KonTextu',31
         db        ' ----------------',31
         db        ' formt KonText',31
         db        ' formt Layout',31
         db        ' formt ASCII',31
         db        ' zloha BAK'
         db        0

tab11:
         db        0
         db        52
         db        1
         db        80
         db        3
         db        'a'
         db        0

tab12:                                      ; zadn strnek k tisku
         db        1
         db        52
         db        1
         db        80
         db        11
         db        31
         db        4,'-- tisk textu   --',31
         db        2,'  Zadejte sla nebo     ',31
         db        '   <Enter> = dn zmna ',31,31
         db        ' prvn strnka:  ',5,'1',31
         db        ' konen strnka:',31
         db        ' prvn slo strany:',2,'1',31
         db        ' exempl:',11,'1'
         db        0

tab13:                                      ; ^KP
         db        1
         db        55
         db        1
         db        80
         db        7
         db        13,' CTRL KP ',31,31
         db        ' - probh tisk textu -',31,31
         db        9,'dle',31
         db        9,'peruen'
         db        0

tab14:                                      ; ^KQ
         db        1
         db        25
         db        6
         db        54
         db        14
         db        16,' CTRL KQ ',31,31
         db        3,'Tmto povelem ukonte',31
         db        ' KonText a navrtte se zpt',31
         db        2,'do operanho systmu !!!',31,31
         db        2,'Stisknte <Enter> = konec',31
         db        3,'nebo <Esc> = pokrauj'
         db        0

tab15:                                      ; ^OE
         db        0
         db        58
         db        1
         db        80
         db        7
         db        10,' CTRL OE ',31
         db        31
         db        'Jako blok se zobraz:',31,31
         db        4,'K = zhlav',31
         db        4,'F = pata '
         db        0

tab16:                                      ; ^OI
         db        0
         db        53
         db        1
         db        80
         db        15
         db        14,' CTRL OI ',31
         db        2,'-- Tabeltory/okraje --',31,31
         db        2,0fah,3,'kurzor vpravo',31
         db        2,0fbh,3,'kurzor vlevo',31
         db        ' End',2,'...k pravmu okraji',31
         db        ' Home ...k levmu okraji',31
         db        2,'L',3,'lev okraj',31
         db        2,'R',3,'prav okraj',31
         db        ' Tab',2,'nastav/zru tabel.',31
         db        2,'#',3,'dekadick tabeltor',31
         db        ' Del',2,'ruen/nvrat tabel.',31
         db        ' Ret',2,'ukonen volby',31
         db        ' Esc',2,'peruen volby'
         db        0

tab17:                                      ; ^OO
         db        0
         db        58
         db        1
         db        80
         db        7
         db        10,' CTRL OO ',31,31
         db        ' Blok se ulo jako: ',31,31
         db        4,'K = zhlav ',31
         db        4,'F = pata'
         db        0

tab18:                                      ; ^OS
         db        1
         db        46
         db        1
         db        80
         db        11
         db        22,' CTRL OS ',31,31
         db        '   Zadejte nov nastaven nebo',31
         db        2,'stisknte <Enter>=beze zmny: ',31,31
         db        ' dk na strnku (4..99):',31
         db        ' z toho: zhlav  (0..10):',31
         db        7,'  pata   ',2,'(0..10):',31,31
         db        ' rozte dk :',9,'cm'
         db        0

tab19:                                      ; ^OZ
         db        1
         db        25
         db        4
         db        54
         db        14
         db        17,' CTRL OZ ',31,31
         db        3,'Tento povel zformtuje',31
         db        4,'text na tto stran',31
         db        4,'dvousloupcov. Nov',31
         db        3,'formtovn ji nadle',31
         db        7,'nebude mon !',31
         db        10,'Zvolte:',31
         db        5,'<Enter> = potvrzen',31
         db        2,'<Esc> = peruen povelu'
         db        0

tab20:                                      ; volby pro hledn
         db        0
         db        58
         db        1
         db        80
         db        9
         db        10,' VOLBY ',31
         db        ' B',2,'zptn smr',31
         db        ' G',2,'v celm textu',31
         db        ' L',2,'v celm bloku',31
         db        ' W',2,'pouze cel slovo',31
         db        ' U',2,'nerozliuje velk',31
         db        4,'a mal psmena'
         db        0

tab21:                                      ; hlen - Text nebude uloen
         db        1
         db        27
         db        7
         db        54
         db        13
         db        31
         db        2,' Text v prac.prost.',31
         db        2,'nebude uloen na disk !',31,31
         db        3,'<Enter>=pokraovn',31
         db        5,'<Esc>=peruen'
         db        0

tab22:                                      ; zvltn znaky
         db        1
         db        34
         db        1
         db        80
         db        15
         db        28,' Zvltn znaky '
         db        0

tab23:                                      ; hlen SETUP
         db        1
         db        25
         db        4
         db        54
         db        13
         db        19,' SETUP ',31,31
         db        ' Tato volba zpsob, e pi',31
         db        2,'dalm sputn KonTextu',31
         db        2,'bude opt pouito stejn',31
         db        3,'nastaven parametr.',31,31
         db        3,'Zvolte <Enter>=uloen',31
         db        4,'nebo <Esc>=peruen.'
         db        0

tab24:                                      ; CTRL-KN
         db        0
         db        50
         db        1
         db        80
         db        8
         db        18,' CTRL KN ',31,31
         db        3,'Nastaven sloupc.bloku:',31,31
         db        ' B',2,'zatek (lev horn roh)',31
         db        ' K',2,'konec (prav doln roh) '
         db        0

tab25:                                      ; sriov tisk
         db        1
         db        50
         db        1
         db        80
         db        10
         db        31
         db        5,'--- Sriov tisk --',31
         db        ' Prosm, zadejte novou volbu',31
         db        2,'nebo <Enter> = beze zmny:',31,31
         db        ' Datov prostor',2,'(1..5):',31
         db        ' Peformtovn ',2,'(J/N):',31
         db        0

tab26:                                      ; pauza sriovho tisku
         db        1
         db        30
         db        7
         db        51
         db        13
         db        31
         db        ' Sriov tisk-pauza',31
         db        ' pro',2,'vmnu papru',31,31
         db        ' pokraovn = <Enter> ,',31
         db        4,'peruen = <ESC>'
         db        0

tab27:                                      ; volba KURZOR
         db        1
         db        1
         db        1
         db        21
         db        12
         db        31
         db        ' zatek textu',31
         db        ' konec textu',31
         db        ' zatek bloku',31
         db        ' konec bloku',31
         db        ' na znaku',31
         db        ' nastaven znaky',31
         db        ' na danou pozici',31
         db        ' vyhledn textu',31
         db        ' hledn/zmna',31
         db        ' dal hledn'
         db        0

tab28:                                      ; volba MAZN
         db        1
         db        3
         db        1
         db        21
         db        9
         db        31
         db        ' slovo vpravo',31
         db        ' po kurzor',31
         db        ' od kurzoru',31
         db        ' cel dek',31
         db        ' cel blok',31
         db        ' obnoven zmn',31
         db        ' cel text'
         db        0

tab29:                                      ; volba BLOK
         db        1
         db        12
         db        1
         db        29
         db        14
         db        31
         db        ' zatek bloku',31
         db        ' konec bloku',31
         db        ' sloupc.blok ',0dah,0c4h,31
         db        ' sloupc.blok',2,0c4h,0d9h,31
         db        ' mazn',31
         db        ' pemstn',31
         db        ' koprovn',31
         db        ' penos z prost.',31
         db        ' ten z disku',31
         db        ' uloen na disk',31
         db        ' zmna psma',31
         db        ' oznaen bloku'
         db        0

tab30:                                      ; volba PSMO
         db        1
         db        19
         db        1
         db        37
         db        9
         db        31
         db        ' normln',31
         db        ' zvraznn',31
         db        ' podtren',31
         db        ' kurzva',31
         db        ' irok',31
         db        ' nadsazen',31
         db        ' podsazen'
         db        0

tab31:                                      ; volba FORMT.
         db        1
         db        26
         db        1
         db        46
         db        14
         db        31
         db        ' po konec odstav.',31
         db        ' po konec textu',31
         db        ' dvousloupcov',31
         db        ' centruj dek',31
         db        ' zarovnvn',31
         db        ' rozdlovn',31
         db        ' s dotazem',31
         db        ' auto-tabeltor',31
         db        ' <Enter>=odstavec',31
         db        ' zat. odstavce ',0f0h,31
         db        ' konec odstavce',2,0f1h,31
         db        ' neformtovat',4,0ffh
         db        0

tab32:                                      ; volba STRNKA
         db        1
         db        32
         db        1
         db        56
         db        14
         db        31
         db        ' dk na strnku',31
         db        ' menu linelu dk',31
         db        ' lev okraj=kurzor',31
         db        ' prav okraj=kurzor',31
         db        ' prav okraj=konec d.',31
         db        ' zobrazen zhlav',31
         db        ' zobrazen paty',31
         db        ' blok jako zhlav',31
         db        ' blok jako pata',31
         db        ' zobraz. strnkovn',31
         db        ' zobr. linelu dku',31
         db        ' nedokumentn md'
         db        0

tab33:                                      ; volba DISPLEJ
         db        1
         db        43
         db        1
         db        61
         db        8
         db        31
         db        ' 25 dk',31
         db        ' 28 dk (VGA)',31
         db        ' 43/50 dk',31
         db        ' zmna barev',31
         db        ' npovda',31
         db        ' blikn kurz.'
         db        0

tab34:                                      ; volba EXTRA
         db        1
         db        51
         db        1
         db        69
         db        14
         db        31
         db        ' prac. prostor',31
         db        ' text do bufferu',31
         db        ' text z bufferu',31
         db        ' zpis asu',31
         db        ' zpis data',31
         db        ' kalend',31
         db        ' grafick editor',31
         db        ' zvltn znaky',31
         db        ' makroklvesy',31
         db        ' kalkultor',31
         db        ' sloupc. souet',31
         db        ' sloupc. prmr'
         db        0

tab35:                                      ; volba TISK, ^KP
         db        1
         db        59
         db        1
         db        77
         db        15
         db        6,' CTRL KP ',31
         db        ' tisk textu',31
         db        ' sriov tisk',31
         db        ' ten instalace',31
         db        ' zmna instalace',31
         db        ' ---------------',31
         db        ' vy kvalita',31
         db        ' psmo Elite',31
         db        ' zk psmo',31
         db        ' proporcionl.',31
         db        ' dvoj. petisk',31
         db        ' hust dkov.',31
         db        ' samostat.list',31
         db        ' vmna papru'
         db        0


tabhlp   dw        offset tab01
         dw        offset tab02
         dw        offset tab03
         dw        offset tab04
         dw        offset tab05
         dw        offset tab06
         dw        offset tab07
         dw        offset tab08
         dw        offset tab09
         dw        offset tab10
         dw        offset tab11
         dw        offset tab12
         dw        offset tab13
         dw        offset tab14
         dw        offset tab15
         dw        offset tab16
         dw        offset tab17
         dw        offset tab18
         dw        offset tab19
         dw        offset tab20
         dw        offset tab21
         dw        offset tab22
         dw        offset tab23
         dw        offset tab24
         dw        offset tab25
         dw        offset tab26
         dw        offset tab27
         dw        offset tab28
         dw        offset tab29
         dw        offset tab30
         dw        offset tab31
         dw        offset tab32
         dw        offset tab33
         dw        offset tab34
         dw        offset tab35

                                            ; funkce 07 - adresa npovdy ES:SI
fnc07:   mov       bx,[bp+4]
         shl       bx,1
         mov       si,[bx+tabhlp]
         push      ds
         pop       es
         ret

taberr:                                     ; tabulka chybovch hlen
         db        1,'Soubor nebyl nalezen',0
         db        2,'ten souboru nen mon',0
         db        3,'Zpis do souboru nen mon',0
         db        4,'Poadovan adres nenalezen',0
         db        5,'Nedostatek msta v pamti',0
         db        6,'Pekroen maximln poet dk',0
         db        7,'" nebyl nalezen',0
         db        8,'dek je moc dlouh',0
         db        9,'Nepovolen zadn',0
         db        10,'Nen oznaen dn blok',0
         db        11,'Pam makroklves je pln',0
         db        12,'Tiskrna nen v provozu',0
         db        13,'Chybn formt dat',0
         db        15,'Soubor s tmto jmnem ji existuje',0
         db        16,'Zdrojov a clov soubor jsou identick',0
         db        17,'Prostor @ nen dosud vytistn.',0
         db        18,'Sloupcov blok neme bt zapsn do souboru',0
         db        19,'Nen oznaen dn sloupcov blok',0
         db        20,'Kurzor se mus nachzet vpravo od pravho okraje',0
         db        21,'Mus bt zadn soubor EXE nebo COM',0
         db        50,'Nepovolen matematick vraz',0
         db        51,'Peteen desetinn teky',0
         db        52,'Dlen nulou',0
         db        53,'Chybn argument',0
         db        54,'Chyba argumentu',0
         db        99,'Intern chyba',0
         db        100,'Disketov mechanika nepracuje',0
         db        153,'Neoekvan konec souboru',0
         db        196,'Peteen sla Integer',0
         db        240,'Disk je pln',0
         db        241,'Nepovolen jmno souboru',0
         db        0,'Ble neuriteln chyba',0

                                            ; FUNKCE 08 - adresa chybovch hlen

fnc08:   mov       si,offset taberr         ; tabulka hlen
         push      ds                       ; nastaven ES = DS
         pop       es
         ret


; *****************************************************************************
;                              ClearWind
;                            Vymazn okna
; -----------------------------------------------------------------------------
; VSTUP:  AX=mazac znak
;         DL=poten pozice okna
;         DH=poten dek okna
;         CL=ka okna (v pozicch)
;         CH=vka okna (v dcch)
;         DS=datov segment
; *****************************************************************************

PUBLIC   ClearWind
ClearWind PROC     NEAR

         or        cl,cl                    ; je ka = 0 ?
         jz        ClrWind3                 ; ka = 0 (nezobraz se nic)
         or        ch,ch                    ; je vka okna = 0 ?
         jz        ClrWind3                 ; vka = 0 (nezobraz se nic)

; ------ Cyklus zobrazen jednoho dku

         push      cx                       ; schova rozmr okna
         push      dx                       ; schova poten pozice okna
ClrWind1:push      cx                       ; schova tae dk
         push      dx                       ; schova poten pozice dku
         xor       ch,ch                    ; CX = poet znak na dek okna
         call      OutChar                  ; zobrazen dku okna
         pop       dx                       ; nvrat poten pozice dku
         pop       cx                       ; nvrat tae dk
         inc       dh                       ; zven sla dku
         dec       ch                       ; snen tae dk
         jnz       ClrWind1                 ; zobrazen dalho dku
         pop       dx                       ; nvrat poten pozice okna
         pop       cx                       ; nvrat rozmr okna

ClrWind3:ret

ClearWind ENDP

; *****************************************************************************
;                              KurzOff
;             Vypnut kurzoru (nastaven pozice mimo displej)
; -----------------------------------------------------------------------------
; VSTUP:  DS=datov segment
; *****************************************************************************

PUBLIC   KurzOff
KurzOff  PROC    NEAR

         push      dx
         xor       dx,dx
         mov       dh,ds:[MaxRow]           ; maximln dek
         inc       dh                       ; dek o 1 vy
         call      SetKurzPos               ; nastaven pozice kurzoru
         pop       dx
         ret

KurzOff  ENDP



; *****************************************************************************
;                              SetKurzPos
;                       Nastaven pozice kurzoru
; -----------------------------------------------------------------------------
; VSTUP:  DH=dek
;         DL=pozice
;         DS=datov segment
; *****************************************************************************

PUBLIC   SetKurzPos
SetKurzPos PROC    NEAR

         push      ax
         push      bx
         mov       ah,2
         mov       bh,ds:[AktPage]          ; aktivn videostrnka
         call      Int10P                   ; nastaven pozice kurzoru
         pop       bx
         pop       ax
         ret

SetKurzPos ENDP


; *****************************************************************************
;                              Out1Char
;                  Zobrazen jednoho znaku na obrazovce
; -----------------------------------------------------------------------------
; VSTUP:  AX=znak k zobrazen
;         DH=dek
;         DL=pozice
;         DS=datov segment
; *****************************************************************************

PUBLIC   Out1Char
Out1Char PROC      NEAR

         push      cx
         mov       cx,1
         call      OutChar                  ; zobrazen znaku
         pop       cx
         ret

Out1Char ENDP


; *****************************************************************************
;                              OutChar
;                     Zobrazen znaku na obrazovce
; -----------------------------------------------------------------------------
; VSTUP:  AX=znak k zobrazen
;         CX=poet znak k zobrazen
;         DH=dek
;         DL=pozice
;         DS=datov segment
; VSTUP: DL=nov pozice
; *****************************************************************************

PUBLIC   OutChar
OutChar  PROC      NEAR
         cmp       dl,ds:[MaxCol]           ; kontrola maximln pozice
         ja        outchar2                 ; pozice pekroena
         cmp       dh,ds:[MaxRow]           ; kontrola maximlnho dku
         ja        outchar2                 ; dek pekroen

         push      cx
         push      dx
         push      di
         push      es

         les       di,ds:[AdrVRAM]          ; adresa zatku VRAM
         push      ax
         xor       ax,ax
         mov       al,ds:[MaxCol]           ; maximln pozice na dku
         inc       al                       ; poet pozic na dku
                                          ;* omezen potu znak
         push      ax                       ; schova potu pozic na dku
         sub       al,dl                    ; zbyl poet monch pozic
         cmp       ax,cx                    ; pekroen poet znak ?
         jae       OutChar1                 ; nen pekroen poet znak
         mov       cx,ax                    ; omezen potu znak
OutChar1:pop       ax
                                          ;* vpoet adresy ve videopamti
         mul       dh                       ; pepoet dk na pozice
         xor       dh,dh
         add       ax,dx
         add       ax,ax
         add       di,ax
         pop       ax

         call      WriteScreen              ; zpis znak na obrazovku
         pop       es
         pop       di
         pop       dx
         add       dl,cl                    ; zven pozice
         pop       cx

OutChar2:ret

OutChar  ENDP


; *****************************************************************************
;                             ReadScreen
;                      ten znaku z obrazovky
; -----------------------------------------------------------------------------
; VSTUP:  ES:SI=tec adresa z videopamti
;         DS=datov segment
; VSTUP: AX=naten znak
;         ES:SI=nov tec adresa
; *****************************************************************************

PUBLIC   ReadScreen
ReadScreen PROC    NEAR

         pushf
         cld                                ; smr nahoru
         push      dx
         mov       dx,ds:[PortCRT]          ; bzov adresa adie displeje
         add       dx,6                     ; stavov registr
         test      byte ptr ds:[CheckSnow],1 ; provd se kontrola snen ?
         push      ds
         push      es
         push      es
         pop       ds
         jz        ReadScr6                 ; neprovd se kontrola snen

; ------ ten znaku s kontrolou snen

ReadScr2:in        al,dx                    ; ten stavu videoadie 6845
         rcr       al,1                     ; test horizontlnho zptnho bhu
         jc        ReadScr2                 ; je horiz. zptn bh - ekn
         cli                                ; zkaz peruen
ReadScr4:in        al,dx                    ; ten stavu videoadie 6845
         rcr       al,1                     ; test horiz. zptnho bhu
         jnc       ReadScr4                 ; ekn na horiz. zptn bh

ReadScr6:lodsw                              ; ten znaku z videopamti
         sti                                ; povolen peruen
         pop       es
         pop       ds
         pop       dx
         popf
         ret

ReadScreen ENDP



; *****************************************************************************
;                            WriteScreen
;                      Zpis znaku na obrazovku
; -----------------------------------------------------------------------------
; VSTUP:  CX=poet znak k zpisu
;         AX=znak k zpisu
;         ES:DI=ukldac adresa ve videopamti
;         DS=datov segment
; VSTUP: ES:DI=nov ukldac adresa
; *****************************************************************************

PUBLIC   WriteScreen
WriteScreen PROC   NEAR

         pushf
         push      cx
         cld                                ; smr nahoru
         test      byte ptr ds:[CheckSnow],1 ; provd se kontrola snen ?
         jz        WritScr6                 ; neprovd se kontrola snen
         jcxz      WritScr6                ; nen dn znak k zpisu

; ------ Zpis znaku s kontrolou snen

         push      ax
         push      bx
         push      dx
         mov       bx,ax                    ; znak k zpisu
         mov       dx,ds:[PortCRT]          ; bzov adresa adie displeje
         add       dx,6                     ; stavov registr
WritScr2:in        al,dx                    ; ten stavu videoadie 6845
         rcr       al,1                     ; test horizontlnho zptnho bhu
         jc        WritScr2                 ; je horiz. zptn bh - ekn
         cli                                ; zkaz peruen
WritScr4:in        al,dx                    ; ten stavu videoadie 6845
         rcr       al,1                     ; test horiz. zptnho bhu
         jnc       WritScr4                 ; ekn na horiz. zptn bh
         mov       ax,bx                    ; znak k zpisu
         stosw                              ; zpis jednoho znaku
         sti                                ; povolen peruen
         loop      WritScr2                 ; penos dalho znaku
         pop       dx
         pop       bx
         pop       ax

WritScr6:rep      stosw                    ; zpis znaku bez kontroly snen
         pop       cx
         popf
         ret

WriteScreen ENDP



; *****************************************************************************
;                             MoveScreen
;                    Penos etzce z/do obrazovky
; -----------------------------------------------------------------------------
; VSTUP:  CX=poet znak k penesen
;         DF=smr penosu nastaven dol nebo nahoru
;         BX:SI=zdrojov adresa etzce
;         DX:DI=clov adresa etzce
;         DS=datov segment
; *****************************************************************************

PUBLIC   MoveScreen
MoveScreen PROC    NEAR

         pushf
         push      ax
         push      cx
         push      dx
         push      si
         push      di
         push      ds                       ; schova DS
         push      es
         jcxz      MoveScr6                 ; nen dn znak k penosu

; ------ pprava dat; zjitn, zda se kontroluje snen

         mov       es,dx                    ; segment clov adresy
         mov       dx,ds:[PortCRT]          ; bzov adresa adie displeje
         add       dx,6                     ; stavov registr
         test      byte ptr ds:[CheckSnow],1 ; provd se kontrola snen ?
         mov       ds,bx                    ; segment zdrojov adresy
         je        MoveScr5                 ; neprovd se kontrola snen

; ------ penos dat s obsluhou snen

MoveScr2:in        al,dx                    ; ten stavu videoadie 6845
         rcr       al,1                     ; test horizontlnho zptnho bhu
         jc        MoveScr2                 ; je horiz. zptn bh - ekn
         cli                                ; zkaz peruen
MoveScr4:in        al,dx                    ; ten stavu videoadie 6845
         rcr       al,1                     ; test horiz. zptnho bhu
         jnc       MoveScr4                 ; ekn na horiz. zptn bh
         movsw                              ; penos jednoho znaku
         sti                                ; povolen peruen
         loop      MoveScr2                 ; penos dalho znaku

; ------ penos dat bez kontroly snen

MoveScr5:rep       movsw                    ; penos dat bez kontroly snen

MoveScr6:pop       es
         pop       ds
         pop       si
         pop       dx
         pop       cx
         pop       ax
         popf
         ret

MoveScreen ENDP


; *****************************************************************************
;                             TestTextVMode
;                      Test, zda je textov videomd
;                    (vyaduje rozpoznn videokarty)
; -----------------------------------------------------------------------------
; VSTUP:  DS=datov segment
; VSTUP: AL=aktuln videomd
;         CY=nen textov videomd
;
; Znien registry: AH
; *****************************************************************************

PUBLIC   TestTextVMode
TestTextVMode PROC NEAR
; ------ Test, zda je textov videomd ji nastaven

         call      AktParDisp               ; aktualizace parametr displeje
         cmp       al,7                     ; videomd MDA
         je        TestTxt2                 ; je nastaven textov videomd MDA
         cmp       al,4
         cmc
TestTxt2:ret
TestTextVMode ENDP

; *****************************************************************************
;                             SetTextVMode
;                      Nastaven textovho videomdu
;                    (vyaduje rozpoznn videokarty)
; -----------------------------------------------------------------------------
; VSTUP:  DS=datov segment
; VSTUP: AL=nov aktuln videomd
;         CY=videomd nen mon nastavit
;
; Znien registry: AH
; *****************************************************************************

PUBLIC   SetTextVmode
SetTextVmode PROC NEAR

; ------ Zjitn poadovanho videomdu

;         call      TestTextVMode
;         jc        SetText0                 ; nen textov videomd
;         cmp       al,7
;         je        SetText4
;         cmp       al,3
;         je        SetText4
;         cmp       al,2
;         je        SetText4

SetText0:int       11h                      ; poskytnut tabulky vybaven
         and       al,30h                   ; inicializan videomd
         mov       ah,7                     ; videomd MDA
         cmp       al,30h                   ; videomd 80x25 monochrom. ?
         je        SetText2                 ; inic. videomd 80x25 monochrom.
         mov       ah,3                     ; videomd CGA 80x25
         cmp       al,20h                   ; videomd 80x25 barevn ?
         je        SetText1                 ; inic. videomd 80x25 barevn
         mov       ah,1                     ; videomd 40x25 barevn
SetText1:xor       ah,ds:[Monochr]          ; zmna pro monochrom. displeje
SetText2:mov       al,ah                    ; poadovan videomd

; ------ Nastaven videomdu

SetText4:call      SetVideoMode             ; nastaven poadovanho videomdu
SetText3:ret

SetTextVmode ENDP


; *****************************************************************************
;                             SetVideoMode
;                          Nastaven videomdu
;                    (vyaduje rozpoznn videokarty)
; -----------------------------------------------------------------------------
; VSTUP:  AL=poadovan videomd
;         DS=datov segment
; VSTUP: AL=nov aktuln videomd
;         CY=videomd nenastaven
;
; Znien registry: AH
; *****************************************************************************

PUBLIC   SetVideoMode
SetVideoMode PROC  NEAR

         push      bx
         push      ax                       ; schova poadovanho videomdu
         xor       ah,ah                    ; funkce nastaven videomdu
         call      Int10P                   ; nastaven videomdu
         call      AktParDisp               ; poskytnut aktivnho videomdu
         mov       bl,al                    ; schova aktulnho videomdu
         pop       ax                       ; nvrat poadovanho videomdu
         xchg      al,bl                    ; AL <- nov videomd
         cmp       al,bl                    ; souhlas videomd s poadovanm ?
         je        SetVMod1                 ; videomd nastaven OK
         stc                                ; pznak chyby nastaven videomdu
SetVMod1:pop       bx
         ret

SetVideoMode ENDP

; *****************************************************************************
;                               AktParDisp
;            Atualizace parametr displeje, poskytnut videomdu
;                    (vyaduje rozpoznn karty EGA/VGA)
; -----------------------------------------------------------------------------
; VSTUP:  DS=datov segment
; VSTUP: AL=aktuln videomd
;
; Znien registry: AH
; *****************************************************************************

PUBLIC   AktParDisp
AktParDisp PROC NEAR

         push      es
         push      bx
         push      dx

         mov       ax,40h
         mov       es,ax                    ; ES <- 40h segment dat BIOS

; ------ Zjitn videomdu

         mov       al,es:[49h]              ; aktuln videomd
         and       al,7fh                   ; zruen pznaku nemazn displeje
         mov       ds:[AktVmod],al          ; aktuln videomd

; ------ Zjitn adresy videopamti a detekce pznaku obsluhy snen

         mov       byte ptr ds:[CheckSnow],0 ; zruen pznaku obsluhy snen
         mov       bx,0A000h                ; segment videopamti pro EGA/VGA
         cmp       al,11                    ; je grafick videomd EGA/VGA ?
         jae       AktParD1                 ; je grafick videomd EGA/VGA
         mov       bx,0B000h                ; segment videopamti pro MDA a PCjr
         cmp       al,7                     ; je videomd MDA nebo PCjr ?
         jae       AktParD1                 ; je videomd MDA nebo PCjr
         mov       bx,0B800h                ; segment videopamti pro mdy CGA
         mov       byte ptr ds:[CheckSnow],1 ; nastav. pznaku obsluhy snen
AktParD1:mov       word ptr ds:[AdrVRAM+2],bx ; adresa segmentu videopamti
         mov       bx,es:[4eh]              ; poten adresa videopamti
         mov       word ptr ds:[AdrVRAM],bx ; poten adresa videopamti

; ------ Detekce monochromatickho videomdu

         xor       bl,bl                    ; pznak - nen monochrom. videomd
         cmp       al,15                    ; je videomd EGA 640x350/2 ?
         je        AktParD2                 ; je videomd EGA 640x350/2 (mono)
         cmp       al,7                     ; je barevn grafick videomd ?
         ja        AktParD3                 ; nen monochromatick videomd
         mov       bl,al                    ; schova videomdu
         cmp       bl,4                     ; je videomd 4 a vy ?
         jae       AktParD3                 ; nen textov videomd CGA
AktParD2:xor       bl,1                     ; zmna pznakovho bitu 0
AktParD3:and       bl,1                     ; ponech pznakov bit 0
         mov       ds:[Monochr],bl          ; nastaven pznaku monochrom. mdu

; ------ Detekce textovho videomdu

         mov       bl,1                     ; pznak textovho videomdu
         cmp       al,7                     ; je textov videomd MDA ?
         je        AktParD4                 ; je textov videomd MDA
         cmp       al,3                     ; je textov videomd CGA ?
         jbe       AktParD4                 ; je textov videomd CGA
         xor       bl,bl                    ; pznak grafickho vidoemdu
AktParD4:mov       ds:[TextVMOD],bl         ; nastaven pznaku textovho mdu

; ------ Zjitn aktuln videostrnky

         mov       bl,es:[62h]              ; aktivn strnka displeje
         mov       ds:[AktPage],bl          ; aktivn strnka displeje

; ------ Zjitn posledn pozice na dku

         mov       bl,es:[4ah]              ; poet pozic na dek
         dec       bl                       ; posledn pozice na dku
         mov       ds:[MaxCol],bl           ; posledn pozice na dku

; ------ Zjitn poslednho dku na displeji a upesnn pznaku snen

         mov       bx,24                    ; pednastaven na 25 dk
         mov       dl,ds:[VideoCard]        ; videokarta
         cmp       dl,9                     ; je karta VGA ?
         je        AktParD5                 ; je karta VGA
         cmp       dl,5
         ja        AktParD6                 ; nen karta EGA
         cmp       dl,3
         jb        AktParD6                 ; nen karta EGA
AktParD5:mov       bl,es:[84h]              ; poet dk displeje - 1
         mov       dl,es:[87h]              ; pznak kontroly snen
         shr       dl,1
         shr       dl,1
         and       dl,1
         mov       ds:[CheckSnow],dl        ; nastaven pznaku kontroly sn.
AktParD6:mov       ds:[MaxRow],bl           ; maximln dek na displeji

; ------ Zjitn bzov dic adresy displeje CRT

         mov       bx,es:[63h]              ; bzov adresa portu adie CRT
         mov       ds:[PortCRT],bx          ; bzov adresa portu adie CRT

         pop       dx
         pop       bx
         pop       es
         ret

AktParDisp ENDP


; *****************************************************************************
;                               DetectCard
;              Detekce videokarty - rozpoznn typu videokarty
; -----------------------------------------------------------------------------
; VSTUP:  DS=datov segment
;
; VSTUP: AX=1: CGA
;            2: MCGA
;            3: EGA
;            4: EGA 64kB
;            5: EGA Mono
;           (6: IBM8514)
;            7: Hercules
;           (8: ATT400)
;            9: VGA
;           10: PC3270
; *****************************************************************************

PUBLIC   DetectCard
DetectCard PROC NEAR

         push      bx
         push      cx
         push      dx
         push      si
         push      di
         push      bp
         push      ds
         push      es
         call      DetCard0                 ; detekce videokarty
         xor       ax,ax
         mov       al,ds:[VideoCard]        ; detekovan videokarta
         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         pop       dx
         pop       cx
         pop       bx
         ret
DetectCard ENDP

; -----------------------------------------------------------------------------
DetCard0:
         mov       ah,0fh
         call      Int10P                   ; dotaz na videomd
         cmp       al,7                     ; je monochromatick videomd ?
         je        DetCard5                 ; je monochromatick videomd

; ------ je barevn reim - rozpoznn EGA/VGA

         call      DetCard8                 ; test karet EGA/VGA
         jc        DetCard2                 ; nen karta EGA/VGA
DetCard1:call      DetCardA                 ; rozlien karet EGA/VGA
         ret
DetCard2:                                 ;* rozpoznn karty PC3270
         call      DetCardP                 ; detekce karty PC3270
         jc        DetCard3                 ; nen karta PC3270
         mov       byte ptr ds:[VideoCard],10; je videokarta PC3270
         ret

DetCard3:                                 ;* rozpoznn karet CGA/MCGA
         mov       byte ptr ds:[VideoCard],1; pednastaven karty CGA
         call      DetCardG                 ; test karty MCGA
         jc        DetCard4                 ; nen karta MCGA
         mov       byte ptr ds:[VideoCard],2; je karta MCGA
DetCard4:ret

DetCard5:                                 ;* monochrom. reim - test EGA/VGA
         call      DetCard8                 ; test karty EGA/VGA
         jnc       DetCard1                 ; je EGA/VGA - rozlien EGA a VGA
                                          ;* test karty Hercules/MDA
         call      DetCardJ                 ; test karty Hercules
         jc        DetCard6                 ; nen karta Hercules
         mov       byte ptr ds:[VideoCard],7; je karta Hercules
         ret
DetCard6:                                 ;* test karty CGA (test pamti)
         mov       si,0b800h                ; segment videopamti CGA
         mov       es,si                    ; segment videopamti CGA
         xor       si,si                    ; poten adresa videopamti CGA
         mov       ax,es:[si]               ; pvodn slovo z videopamti
         not       ax                       ; inverze
         not       word ptr es:[si]         ; inverze i pvodnho slova
         nop
         nop
         cmp       ax,es:[si]               ; je tam pam RAM ?
         jne       DetCard7                 ; nen pam VRAM
         mov       byte ptr ds:[VideoCard],1; je karta CGA
DetCard7:ret
; -----------------------------------------------------------------------------
DetCard8:                                 ;* test karty EGA/VGA
         mov       ax,1200h
         mov       bl,10h                   ; podsluba poskytnut parametr
         mov       bh,0ffh                  ; pednastaven
         mov       cl,0fh                   ; pednastaven
         call      Int10P                   ; dotaz na EGA kartu
         cmp       cl,0ch
         jge       DetCard9                 ; nen karta EGA
         cmp       bh,1
         jg        DetCard9                 ; nen karta EGA
         cmp       bl,3
         jg        DetCard9                 ; nen karta EGA
         clc                                ; pznak - je karta EGA
         ret
DetCard9:stc                                ; pznak - nen karta EGA
         ret
; -----------------------------------------------------------------------------
DetCardA:                                 ;* rozlien karet EGA/VGA
         mov       byte ptr ds:[VideoCard],4; pednastaven karty EGA64
         cmp       bh,1                     ; je monochromatick md ?
         je        DetCardD                 ; je monochromatick md
         call      DetCardE                 ; test karty EGA 64
         jnc       DetCardC                 ; je karta EGA 64
         or        bl,bl                    ; je EGA 64 ?
         jz        DetCardC                 ; je EGA 64
         mov       byte ptr ds:[VideoCard],3; pednastaven karty EGA
         call      DetCardG                 ; test karty VGA
         jnc       DetCardB                 ; je karta VGA
         mov       bx,0c000h                ; segment s ROM VGA
         mov       es,bx                    ; segment s ROM VGA
         mov       bx,39h                   ; adresa textu "Z449"
         cmp       word ptr es:[bx],"Z4"    ; je text "Z4" ?
         jne       DetCardC                 ; nen karta VGA
         cmp       word ptr es:[bx+2],"49"  ; je text "49" ?
         jne       DetCardC                 ; nen karta VGA
DetCardB:mov       byte ptr ds:[VideoCard],9; je karta VGA
DetCardC:ret
DetCardD:mov       byte ptr ds:[VideoCard],5; je karta EGA Mono
         ret

DetCardE:                                 ;* test karty EGA 64
         cmp       cl,2
         jb        DetCardT                 ; je karta EGA 64
         cmp       cl,6
         jb        DetCardF                 ; nen karta EGA 64
         cmp       cl,8
DetCardT:cmc
DetCardF:ret
; -----------------------------------------------------------------------------
DetCardG:                                 ;* test karty VGA
         mov       ax,1a00h
         call      Int10P                   ; dotaz na poet linek na znak
         cmp       al,1ah                   ; je funkce obsluhovan ?
         jne       DetCardI                 ; funkce nen obsluhovan
         cmp       bl,7                     ; je 7 linek na znak ?
         je        DetCardH                 ; je karta OK
         cmp       bl,8
         je        DetCardH                 ; je karta OK
         cmp       bl,11
         jb        DetCardI                 ; nen karta
         cmp       bl,12
         ja        DetCardI                 ; nen karta
DetCardH:clc                                ; pznak - je karta
         ret
DetCardI:stc                                ; pznak - nen karta
         ret
; -----------------------------------------------------------------------------
DetCardJ:                                 ;* test karty Hercules
         mov       dx,03bah                 ; stavov port karty
         xor       bl,bl                    ; ta doby impulsu
         in        al,dx                    ; poten stav
         and       al,80h                   ; signl zptnho bhu
         mov       ah,al                    ; schova stavu registru
         mov       cx,8000h                 ; maximln doba testu
DetCardK:                                 ;* ekn na zmnu stavu bitu 7
         in        al,dx                    ; ten stavovho registru
         and       al,80h                   ; signl zptnho bhu
         cmp       al,ah                    ; byla zmna stavu signlu ?
         je        DetCardL                 ; nebyla zmna stavu signlu
         inc       bl                       ; ta dlky impulsu
         cmp       bl,10                    ; je minimln doba impulsu ?
         jae       DetCardM                 ; impuls je dostaten dlouh
DetCardL:loop      DetCardK                 ; dal test impulsu
         stc                                ; pznak - nen karta Hercules
         ret

DetCardM:                                 ;* ekn na bity 5,4 -> 01
         mov       cx,8000h                 ; maximln doba testu
DetCardN:in        al,dx                    ; ten stavovho registru
         and       al,30h
         cmp       al,10h
         jne       DetCardO                 ; je pouze karta MDA
         loop      DetCardN                 ; dal test
         mov       al,2                     ; pznak - je karta Hercules
         clc
         ret
DetCardO:mov       al,1                     ; pznak - je karta MDA
         clc
         ret
; -----------------------------------------------------------------------------
DetCardP:                                 ;* test videokarty PC3270
         mov       al,6
         xor       cx,cx                    ; CX <- 0
         xor       dx,dx
         mov       ah,30h
         call      Int10P
         mov       ax,cx
         or        ax,dx
         jz        DetCardR                 ; nen karta PC3270
         push      ds
         mov       ds,cx                    ; segment
         mov       bx,dx                    ; offset
         mov       al,ds:[bx+2]
         pop       ds
         or        al,al
         jz        DetCardQ                 ; je karta PC3270
         cmp       al,2
         jne       DetCardR                 ; nen karta PC3270
DetCardQ:mov       dx,188h
         in        al,dx
         test      al,4
         jz        DetCardR                 ; nen karta PC3270
         clc                                ; pznak - je karta PC3270
         ret
DetCardR:stc                                ; pznak - nen karta PC3270
         ret

; -----------------------------------------------------------------------------
;        Test, zda je karta EGA
; -----------------------------------------------------------------------------
TestEga:
         push      ax
         mov       al,cs:[VideoCard]
         cmp       al,9
         je        TestEga2
         cmp       al,5
         je        TestEga2
         cmp       al,4
         je        TestEga2
         cmp       al,3
         je        TestEga2
         stc
TestEga2:pop       ax
         ret

; -----------------------------------------------------------------------------
;            Voln INT 10h s schovou registr SI,DI,BP,DS a ES
; -----------------------------------------------------------------------------
Int10P PROC NEAR
         push      si
         push      di
         push      bp
         push      ds
         push      es
         int       10h
         pop       es
         pop       ds
         pop       bp
         pop       di
         pop       si
         ret
Int10P ENDP
; -----------------------------------------------------------------------------




konectxt label     near

code     ENDS

         end       start
