

; ****************************************************************************
;             Grafick driver karty EGA pro program KONTEXT.COM
;              po pekladu od adresy 0 m soubor jmno EGA.OVL
; ****************************************************************************

code     SEGMENT   page
         ASSUME    cs:code,ds:code

         ORG       0                        ; poten adresa driveru

start:                                      ; vstup do driveru

ega      PROC      FAR                      ; vstupn bod do driveru
                                            ; - slo funkce je v BX
         push      ds
         mov       dx,cs
         mov       ds,dx                    ; datov segment = program. segment
         shl       bx,1                     ; slo funkce BX * 2
         call      word ptr ds:[bx+adrsub]  ; vyvoln podprogramu podle tabulky
         pop       ds
         ret                                ; nvrat z driveru RET FAR

ega      ENDP

tabega   db        0
         db        3                        ; poet font
         db        6                        ; font 6x8
         dw        fnt6x8
         db        8                        ; font 8x8
         dw        fnt8x8
         db        14                       ; font 14x8
         dw        fnt14x8

karta    db        'EGA'                    ; identifikace karty EGA

chrbuf   db        0,0,0,0,0,0,0            ; buffer pro vstup znaku
         db        0,0,0,0,0,0,0
         db        0,0,0,0,0,0,0            ; prav polovina irokho znaku
         db        0,0,0,0,0,0,0

invmsk   db        0                        ; maska znak (pro inverzi)
whide    db        0                        ; pznak dvojnsobn ky znaku
mode     db        0                        ; reim obrazovky (1,2,3)
vyska    db        0                        ; poet linek na textov dek

planng   db        0                        ; roviny pro negaci znaku (kurzor)
planes   db        0                        ; roviny EGA pro vstup znaku

adrrow   dw        59 DUP (0)               ; tabulka adres dk na displeji

                                            ; ADRESY PODPROGRAM
adrsub   dw        offset fnc00             ; funkce 00 - vstup znaku
         dw        offset fnc01             ; funkce 01 - kurzor, mazn
         dw        offset fnc02             ; funkce 02 - rolovn nahoru
         dw        offset fnc03             ; funkce 03 - rolovn dol
         dw        offset fnc04             ; funkce 04 - prav okraj (ra)
         dw        offset fnc05             ; funkce 05 - inicializace parametr
         dw        offset fnc06             ; funkce 06 - nastaven text. mdu
         dw        offset fnc07             ; funkce 07 - adr. npovdy (ES:SI)
         dw        offset fnc08             ; funkce 08 - adr. chybovch hlen
         dw        offset fnc09             ; funkce 09 - rozdlovn slov
         dw        offset fnc10             ; funkce 10 - dekdovn kdu klves
         dw        offset fnc11             ; funkce 11 - vpis kdu klvesy



                                            ; zdvojnsoben ky znaku
                                            ; VSTUP SI=adresa, CX=poet linek
widchr:  push      si                       ; adresa znaku v bufferu
widch1:  mov       bh,8                     ; poet bit znaku = 8
         mov       al,[si]                  ; linka znaku
widch2:  shr       al,1                     ; rotace linky vpravo, kopie do CF
         rcr       dx,1                     ; rotace bitu CF do reg. DX
         sar       dx,1                     ; rotace vpravo ze znamnkovho bitu
         dec       bh                       ; ta bit k rotaci
         jnz       widch2                   ; dal bit k rotaci
         mov       [si],dh                  ; lev polovina znaku
         mov       [si+14],dl               ; prav polovina znaku
         inc       si                       ; dal linka znaku
         loop      widch1
         dec       word ptr [bp+6]          ; snen pozice znaku na displeji
         mov       [whide],cl               ; pznak dvojnsobnho znaku = 0
         pop       si                       ; adresa znaku v bufferu
         ret

                                            ; VSTUP SI=adresa, CX=poet linek
rozdelchr:push      si                      ; adresa znaku v bufferu
rozdch1: or        byte ptr [si],1          ; oznaen rozdlen znaku
         inc       si
         loop      rozdch1                  ; dal linka znaku
         pop       si
         ret


                                            ; zvraznn znaku
                                            ; VSTUP SI=adresa, CX=poet linek
fetchr:  push      si                       ; adresa znaku v bufferu
fetch1:  mov       al,[si]                  ; 1 linka znaku
         shr       al,1
         or        [si],al                  ; zvraznn znaku
         inc       si
         loop      fetch1                   ; dal linka znaku
         pop       si
         ret

                                            ; inicializace displeje EGA

iniega:  mov       dx,03ceh                 ; adresov registr EGA
         mov       al,0
         out       dx,al                    ; nastaven registru 0
         inc       dx                       ; datov registr
         mov       al,[planes]              ; roviny EGA pro vstup
         mov       bl,al
         out       dx,al                    ; nastaven rovin EGA pro vstup
         dec       dx                       ; adresov registr EGA
         mov       al,1
         out       dx,al                    ; nastaven registru 1
         inc       dx                       ; datov registr
         mov       al,[planng]              ; roviny pro negaci znaku
         xor       al,bl
         not       al
         out       dx,al                    ; nastaven rovin EGA pro negaci
         dec       dx                       ; adresov registr EGA
         mov       al,3                     ; registr 3
         out       dx,al                    ; nastaven registru 3
         inc       dx                       ; datov registr EGA
         mov       al,0
         out       dx,al                    ; nastaven reimu zpisu bez zmny
         dec       dx                       ; adresov registr
         mov       al,8                     ; registr 8
         out       dx,al                    ; nastaven registru 8
         inc       dx                       ; datov registr
         mov       al,0ffh
         out       dx,al                    ; nastaven masky bit vech rovin
         ret       

                                            ; FUNKCE 00 - vstup znaku

                                            ; SS:BP = ukazatel parametr znaku
                                            ;   +4 = pozice znaku (v linkch)
                                            ;   +6 = pozice znaku na dku
                                            ;   +8 = znak k vstupu
                                            ; AH = md znaku
                                            ;   01 = nadsazen psmo
                                            ;   02 = podsazen psmo
                                            ;   04 = ikm psmo
                                            ;   08 = podtren text
                                            ;   10 = zvraznn psmo
                                            ;   20 = inverzn psmo
                                            ;   40 = rozdlovac znamnko
                                            ;   80 = dvojnsobn ka znaku

fnc00:   xor       cx,cx                    ; zruen pznaku dvojit ky
         mov       dx,[bp+6]                ; pozice znaku na dku
         or        dx,dx                    
         jng       fnc001                   ; pozice zporn
         cmp       dx,word ptr 80
         ja        fnc001                   ; pekroen potu znak (>80)
         mov       bl,[bp+8]                ; znak k vstupu
         cmp       bl,0ffh                  ; je znak pro dvojnsobnou ku
         jnz       fnc002                   ; nen dvojnsobn ka
         mov       cl,80h                   ; nastaven pznaku dvojit ky
fnc001:  mov       [whide],cl               ; pznak dvojnsobnho znaku
         ret                                
fnc002:  mov       dx,ds                    
         mov       es,dx                    ; ES = DS
         cld                                ; smr penosu dat nahoru
         mov       bh,0                     
         mov       si,bx                    ; BL = znak k vstupu
         shl       si,1                     
         shl       si,1                     
         shl       si,1                     ; SI = znak * 8
         cmp       [mode],2                 ; reim obrazovky (1,2,3)
         jz        out8x8                   ; reim 8x8 bod
         jnc       out6x8                   ; reim 6x8 bod
         jmp       out14x8                  ; reim 14x8 bod

                                            ; nastaven reim 3 (6x8)
out6x8:  sub       si,bx                    
         sub       si,bx                    ; SI = znak * 6
         add       si,offset fnt6x8         ; adresa znaku v tabulce font 6x8
         mov       di,offset chrbuf         ; buffer pro vstup znaku
         mov       cl,3                     
         repnz     movsw                    ; penos fontu znaku
         mov       si,offset chrbuf         ; buffer pro vstup znaku
         test      ah,4                     ; je ikm psmo
         jz        out6x81                  
         mov       cl,2                     ; vytvoen ikmho znaku
         shr       byte ptr [si],cl         ; >> 2
         shr       byte ptr [si+1],1        ; >> 1
                                            ;    0
                                            ;    0
         shl       byte ptr [si+4],1        ; << 1
         shl       byte ptr [si+5],cl       ; << 2
out6x81: test      ah,10h
         jz        out6x82
         mov       cl,6                     ; poet bajt znaku
         call      fetchr                   ; zvraznn znaku
out6x82: or        ah,[whide]               ; pznak dvojnsobnho znaku
         jns       out6x83                  ; nen dvojnsobn ka znaku
         mov       cl,6                     ; poet bajt znaku
         call      widchr                   ; zdvojnsoben ky znaku
out6x83: test      ah,40h                   ; je rozdlovac znamnko ?
         jz        out6x89
         mov       cl,6                     ; poet bajt znaku
         call      rozdelchr                ; rozdlen znaku
out6x89: mov       cl,3                     ; poet bajt k penosu = 6
         jmp       outx8                    ; vykreslen znaku

                                            ; nastaven reim 2 (8x8 bod)
out8x8:  mov       di,offset chrbuf + 3     ; buffer pro vstup znaku
         test      ah,3
         jnz       out8x81                  ; je nadsazen nebo podsazen
         add       si,offset fnt8x8         ; tabulka font 8x8 bod
         mov       cl,4                     ; penos znaku do bufferu
         repnz     movsw                    ; penos fontu znaku
         jmp       short out8x82            ; dal korekce znaku
out8x81: sub       si,bx                    ; zde je nadsazen nebo podsazen
         sub       si,bx                    ; vpoet SI = znak * 6
         add       si,offset fnt6x8         ; adresa znaku v tabulce 6x8 bod
         mov       al,0
         stosb                              ; uloen przdn dky 00
         mov       cl,3
         repnz     movsw                    ; penos fontu znaku
         stosb                              ; uloen przdn dky 00
out8x82: mov       si,offset chrbuf + 3     ; buffer pro vstup znaku
         test      ah,4                     ; ikm psmo
         jz        out8x83
         mov       cl,2                     ; vytvoen ikmho znaku
         shr       byte ptr [si],cl         ; >> 2
         shr       byte ptr [si+1],1        ; >> 1
         shr       byte ptr [si+2],1        ; >> 1
                                            ;    0
                                            ;    0
         shl       byte ptr [si+5],1        ; << 1
         shl       byte ptr [si+06],1       ; << 1
         shl       byte ptr [si+07],cl      ; << 2
out8x83: test      ah,10h                   ; zvraznn psmo
         jz        out8x84
         mov       cl,8                     ; poet bajt znaku
         call      fetchr                   ; zvraznn znaku
out8x84: or        ah,[whide]               ; pznak dvojnsobnho znaku
         jns       out8x85                  ; nen dvojnsobn ka znaku
         mov       cl,8                     ; poet bajt znaku
         call      widchr                   ; zdvojnsoben ky znaku
out8x85: dec       si
         xor       dx,dx
         cmp       bl,0b0h                  ; znak k vstupu - je znak grafiky ?
         jc        out8x86
         cmp       bl,0e0h
         jnc       out8x86
         mov       dl,[si+1]                ; jsou znaky blokov grafiky
         mov       dh,[si+8]                ;  - spoj se ry mezi dky
         cmp       bl,0b2h
         ja        out8x86                  ; jsou znaky rmek
         xchg      dh,dl                    ; znaky ploch
out8x86: mov       [si],dl                  ; pemostn przdnch linek
         mov       [si+9],dh
         test      ah,1                     ; nadsazen psmo
         jz        out8x87                  ; nen nadsazen psmo
         inc       si
         inc       si                       ; posuv ukazatele dol
out8x87: test      ah,2                     ; podsazen psmo
         jz        out8x88                  ; nen podsazen psmo
         dec       si                       ; posuv ukazatele nahoru
         dec       si
out8x88: test      ah,40h                   ; je rozdlovac znamnko ?
         jz        out8x89
         mov       cl,10                    ; poet bajt znaku
         call      rozdelchr                ; rozdlen znaku
out8x89:
         mov       cl,5                     ; poet bajt k penosu = 10
         jmp       outx8
                                            ; nastaven reim 1  (14x8)
out14x8: mov       di,offset chrbuf         ; buffer pro vstup znaku
         test      ah,3                     ; nadsazen nebo podsazen
         jz        out4x82                  ; nen
         add       si,offset fnt8x8         ; tabulka font 8x8 bod
         mov       al,0                     ; nulovac bajt
         test      ah,2                     ; podsazen
         jnz       out4x81                  ; je podsazen
         mov       cl,4                     ; poet bajt = 8
         repnz     movsw                    ; penos fontu znaku
         mov       cl,6                     ; vynulovn 6 bajt mezery
         repnz     stosb
         jmp       short out4x83
out4x81: mov       cl,6                     ; vynulovn 6 bajt mezery
         repnz     stosb
         mov       cl,4                     ; poet bajt znaku = 8
         repnz     movsw                    ; penos fontu znaku
         jmp       short out4x83
out4x82: sub       si,bx                    ; vpoet SI = znak * 7
         shl       si,1                     ;         SI = znak * 14
         add       si,offset fnt14x8        ; adresa znaku v tabulce 14x8 bod
         mov       cl,7                     ; poet bajt k penosu = 14
         repnz     movsw                    ; penos fontu znaku
out4x83: mov       si,offset chrbuf         ; buffer pro vstup znaku
         test      ah,4
         jz        out4x84                  ; nen ikm psmo
         mov       cl,2                     ; vytvoen ikmho znaku
         shr       byte ptr [si],cl         ; >> 2
         shr       byte ptr [si+1],cl       ; >> 2
         shr       byte ptr [si+2],cl       ; >> 2
         shr       byte ptr [si+3],1        ; >> 1
         shr       byte ptr [si+4],1        ; >> 1
         shr       byte ptr [si+5],1        ; >> 1
                                            ;    0
                                            ;    0
         shl       byte ptr [si+8],1        ; << 1
         shl       byte ptr [si+9],1        ; << 1
         shl       byte ptr [si+10],1       ; << 1
         shl       byte ptr [si+11],cl      ; << 2
         shl       byte ptr [si+12],cl      ; << 2
         shl       byte ptr [si+13],cl      ; << 2
out4x84: test      ah,10h
         jz        out4x85                  ; nen zvraznn psmo
         mov       cl,14
         call      fetchr                   ; zvraznn znaku
out4x85: or        ah,[whide]               ; pznak dvojnsobnho znaku
         jns       out4x86                  ; nen dvojnsobn ka znaku
         mov       cl,14                    ; poet bajt znaku
         call      widchr                   ; zdvojnsoben ky znaku
out4x86: test      ah,40h                   ; je rozdlovac znamnko ?
         jz        out4x89
         mov       cl,14                    ; poet bajt znaku
         call      rozdelchr                ; rozdlen znaku
out4x89: mov       cl,7
                                            ; vykreslen znaku na displej
outx8:   mov       di,[bp+4]                ; pozice znaku (v linkch)
         shl       di,1                     ; DI = poet linek * 2
         mov       di,[di+adrrow]           ; peten adresy linky
         add       di,[bp+6]                ; pozice znaku na dku
         mov       dx,0a000h                ; videopam EGA
         mov       es,dx                    ; nastaven segmentu ES
         mov       bh,[invmsk]              ; maska pro vstup (pro inverzi)
         test      ah,20H                   ; pznak inverznho znaku
         jz        outx81
         not       bh                       ; inverzn znak
outx81:  lodsb                              ; peten bajtu k vstupu DS:SI
         xor       al,bh                    ; filtrace barvy (inverze)
         stosb                              ; uloen sudho bajtu do VRAM ES:DI
         add       di,79                    ; dal dek (zven o 80)
         lodsb                              ; peten druhho bajtu k vstupu
         xor       al,bh                    ; filtrace barvy
         stosb                              ; uloen lichho bajtu do VRAM
         add       di,79                    ; dal dek (zven o 80)
         loop      outx81                   ; dal dva bajty znaku
         test      ah,8                     ; pznak podtrenho znaku
         jz        outx82                   ; nen podtren text
         sub       di,80                    ; pedchoz dek
         mov       al,bh                    ; barva znak
         not       al                       ; negace bajtu
         stosb                              ; uloen pln linky (ra)(XOR)
outx82:  xor       ah,80h
         jns       outx83                   ; je irok psmo-penos prav sti
         ret
outx83:  inc       word ptr [BP+6]          ; zven pozice
         cmp       [mode],2                 ; reim obrazovky (1,2,3)
         jc        out4x86                  ; reim 1 (14x8 bod)
         mov       si,offset chrbuf + 17    ; adresa prav poloviny znaku
         jnz       outx84
         jmp       out8x85                  ; reim 2 (8x8 bod)
outx84:  mov       si,offset chrbuf + 14    ; adresa prav poloviny znaku
         jmp       out6x83                  ; reim 3 (6x8 bod)


                                            ; FUNKCE 01 - kurzor a mazn

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = parametr pro zpis okna
                                            ;          = 0 negace okna
                                            ;          = 1 vymazn okna
                                            ;    + 6 = poten pozice (pozice)
                                            ;    + 8 = ka okna (pozic)
                                            ;    +10 = poten pozice (linka)
                                            ;    +12 = vka okna (v bajtech)

fnc01:   mov       ax,[bp+10]               ; pot. pozice (linka)
         mov       di,ax
         shl       di,1
         shl       di,1
         add       di,ax                    ; DI = AX * 5
         mov       cl,4                     ; poet rotac
         shl       di,cl                    ; DI = AX * 80 - pot. linka
         mov       bx,[bp+6]                ; poten pozice (pozic)
         sub       bx,ax
         inc       bx                       ; - poten pozice (v bajtech)
         mov       ax,[bp+12]               ; vka okna (linek)
         or        ax,ax
         jg        fnc011                   ; kladn
         mov       ax,1                     ; zporn - dn okno
fnc011:  mov       cx,[bp+8]                ; ka okna (pozic)
         cmp       cx,word ptr 80           ; kontrola ky okna
         jng       fnc012
         mov       cx,word ptr 80           ; omezen na max. poet znak 80
fnc012:  dec       ax                       ; vka okna (v bajtech)
         sub       cx,ax                    ; zatek posledn linky
         jng       fnc019                   ; nen dn okno
         add       di,ax                    ; konen linka (v bajtech)
         mov       dx,03CEh                 ; adresov registr grafiky EGA
         mov       al,1                     ; nastaven registru slo 1
         out       dx,al
         inc       dx                       ; adresa dat registru
         mov       al,0fh                   ; nastaven bit pro set/reset
         out       dx,al
         dec       dx                       ; adresov registr grafiky EGA
         mov       al,0
         out       dx,al                    ; nastaven registru slo 0
         inc       dx                       ; adresa dat registru
         mov       ah,[invmsk]              ; maska znak pro vstup
         cmp       byte ptr [bp+4],1        ; parametr pro zpis okna
         jnc       fnc013                   ; je vymazn okna
         not       ah                       ; negace masky pro vstup
         jmp       short fnc014
fnc013:  mov       al,0ffh                  ; mazn vech rovin
         jnz       fnc015
fnc014:  mov       al,[planes]              ; roviny pro vstup znaku
         or        ah,ah                    ; negovan maska znak pro vstup
         jnz       fnc015                   ; je negace zpt
         mov       al,[planng]              ; roviny pro negaci znaku (kurzor)
fnc015:  out       dx,al                    ; vbr rovin pro vstup
         push      ds
         mov       si,0a000h                ; adresa VRAM karty EGA
         mov       es,si
         mov       ds,si                    ; nastaven segmentovch registr
         cld                                ; smr penosu dat vzhru
         inc       al                       ; roviny pro zpis
         jnz       fnc017                   ; nejsou vechny roviny (tj. mazn)
         dec       dx                       ; adresov registr grafiky EGA
         mov       al,3
         out       dx,al                    ; nastaven registru 3
         inc       dx                       ; datov registr
         mov       al,18h                   ; zpisov md XOR
         out       dx,al
fnc016:  mov       si,di
         push      cx                       ; ka okna k vymazn
         push      di                       ; ukazatel okna
         repnz     movsb                    ; vymazn bajt obrazovky
         pop       di
         pop       cx
         add       di,80                    ; dal linka
         dec       bx                       ; ta linek okna
         jnz       fnc016                   ; dal linka okna
         jmp       short fnc018             ; konec
fnc017:  push      cx
         push      di
         repnz     stosb                    ; uloen negovacho bajtu
         pop       di
         pop       cx
         add       di,80                    ; dal linka
         dec       bx                       ; ta linek
         jnz       fnc017                   ; dal linka k negaci
fnc018:  pop       ds
         call      iniega                   ; inicializace displeje
fnc019:  ret


                                            ; FUNKCE 02 - rolovn okna nahoru

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = ka okna (pozic)
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna

fnc02:   mov       ax,[bp+4]                ; konen dek k rolovn
         mov       si,[bp+8]                ; poten dek k rolovn
         sub       ax,si                    ; poet dk k rolovn
         jz        fnc022                   ; nen dn dek k rolovn
         mul       byte ptr [vyska]         ; vynsoben potem linek na dek
         mov       bx,ax                    ; celkov poet linek k rolovn
         mov       dx,03ceh                 ; adresov registr grafiky EGA
         mov       al,8
         out       dx,al                    ; nastaven registru 08
         inc       dx                       ; datov registr grafiky EGA
         mov       al,0
         out       dx,al                    ; nastaven masky pro vechny roviny
         shl       si,1                     ; poten dek k rolovn
         add       si,offset adrrow         ; tabulka adres dk na displeji
         mov       di,[si]                  ; peten adresy dku
         inc       si
         inc       si
         mov       si,[si]                  ; adresa nsledujcho dku
         mov       ax,[bp+10]               ; poten pozice okna k rolovn
         add       di,ax                    ; koncov adresy okna
         add       si,ax
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,ax
         inc       cx                       ; - konen pozice okna
         push      ds
         mov       ax,0a000h                ; segment pamti EGA
         mov       es,ax                    ; nastaven segment pamti EGA
         mov       ds,ax
         cld                                ; smr penosu dat nahoru
fnc021:  push      si
         push      di
         push      cx                       ; poet bajt k penosu
         repnz     movsb                    ; penos jedn linky okna
         pop       cx
         pop       di
         pop       si
         add       di,80                    ; dal linka
         add       si,80
         dec       bx                       ; ta linek
         jnz       fnc021
         pop       ds
         call      iniega                   ; inicializace displeje EGA
fnc022:  ret





                                            ; FUNKCE 03 - rolovn okna dol

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = ka okna (pozic)
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna


fnc03:   mov       ax,[bp+4]                ; konen dek k rolovn
         mov       di,ax
         sub       ax,[bp+8]                ; poten dek k rolovn
         jz        fnc032                   ; je nulov poet dk k rolovn
         mul       byte ptr [vyska]         ; vypoten potu linek k rolovn
         mov       bx,ax                    ; poet linek k rolovn
         mov       dx,03ceh                 ; adresov registr grafiky EGA
         mov       al,8
         out       dx,al                    ; nastaven registru 08
         inc       dx
         mov       al,0
         out       dx,al                    ; nastaven bitov masky vech rovin
         shl       di,1                     ; konen dek k rolovn * 2
         add       di,offset adrrow         ; tabulka adres dk na displeji
         mov       si,[di]                  ; adresa konenho dku k rolovn
         inc       di
         inc       di
         mov       di,[di]                  ; adresa potenho dku k rol.
         mov       ax,[bp+10]               ; poten pozice okna
         add       di,ax                    ; adresa pravho dolnho rohu
         add       si,ax                    ; adresa pravho hornho rohu
         mov       cx,[bp+6]                ; ka okna (pozic)
         sub       cx,ax
         inc       cx                       ; - konen pozice okna
         push      ds
         mov       ax,0a000h                ; poten adresa pamti EGA
         mov       es,ax                    ; nastaven segmentu pro EGA
         mov       ds,ax
         cld                                ; smr penosu dat nahoru
fnc031:  sub       di,80
         sub       si,80
         push      si
         push      di
         push      cx
         repnz     movsb                    ; penos jedn linky
         pop       cx
         pop       di
         pop       si
         dec       bx
         jnz       fnc031                   ; dal linka k penosu
         pop       ds
         call      iniega                   ; inicializace displeje EGA
fnc032:  ret


                                            ; FUNKCE 04 - prav okraj (ra)

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = kd ry
                                            ;    + 6 = konen dek
                                            ;    + 8 = poten dek
                                            ;    +10 = pozice ry

fnc04:   mov       si,[bp+10]               ; pozice ry
         or        si,si
         jng       fnc042                   ; zporn pozice
         cmp       si,word ptr 80           ; kontrola pekroen 80 znak
         ja        fnc042                   ; pekroen poet znak 80
         mov       ax,[bp+6]                ; konen dek
         mov       di,[bp+8]                ; poten dek
         sub       ax,di
         inc       ax                       ; poet dk okna
         mul       byte ptr [vyska]         ; poet linek na dek
         mov       cx,ax                    ; ta linek
         shl       di,1                     ; poten dek * 2
         mov       di,[di+adrrow]           ; adresa dku (v bajtech)
         add       di,si                    ; adresa zatku okna (v bajtech)
         mov       dx,03ceh                 ; adresov registr grafiky EGA
         mov       al,1
         out       dx,al                    ; nastaven registru 01
         inc       dx                       ; datov registr grafiky EGA
         mov       al,0                     ; nastaven bod
         out       dx,al
         dec       dx                       ; adresov registr grafiky EGA
         mov       al,3
         out       dx,al                    ; nastaven registru 03
         inc       dx                       ; datov registr grafiky EGA
         mov       al,18h                   ; nastaven reimu pro zpis XOR
         out       dx,al
         mov       al,[bp+04]               ; znak ry
         push      ds
         mov       dx,0a000h                ; adresa pamti EGA
         mov       ds,dx                    ; datov segment na pam EGA
fnc041:  mov       ah,[di]                  ; peten bajtu
         mov       [di],al                  ; zpis znaku ry
         add       di,80
         loop      fnc041                   ; dal linka
         pop       ds
         call      iniega                   ; inicializace displeje EGA
fnc042:  ret

                                            ; FUNKCE 05 - inicializace parametr

                                            ; SS:BP = ukazatel parametr znaku
                                            ;   +4 = barva okol (borderu)
                                            ;   +6 = pozice znaku na dku
                                            ;   +8 = reim obrazovky (dkovn)

fnc05:   mov       ax,ds
         mov       es,ax                    ; nastaven segmentu ES = DS
         mov       di,offset chrbuf         ; buffer pro vstup znaku
         mov       cx,30                    ; poet bajt bufferu
         mov       al,0                     ; nulovac bajt
         cld                                ; smr nahoru
         repnz     stosb                    ; vynulovn bufferu pro vstup
         mov       ax,16                    ; nastaven grafickho mdu 640x350
         int       10h
         mov       al,[bp+6]
         mov       bl,[bp+4]                ; barva okol (borderu)
         mov       bh,bl
         mov       ah,0
         or        bh,al
         cmp       bh,bl
         jnz       fnc051
         not       ah
         xchg      al,bl
fnc051:  or        al,bl
         mov       [planng],al              ; roviny pro negaci znaku (kurzor)
         mov       [planes],bl              ; roviny EGA pro vstup znaku
         mov       [invmsk],ah              ; maska znak pro inverzi
         mov       ax,1001h                 ; povel pro nastaven barvy borderu
         mov       bh,bl                    ; barva borderu
         int       10h                      ; nastaven barvy borderu
         call      iniega                   ; inicializace displeje EGA
         mov       al,[bp+8]                ; reim obrazovky (dkovn)
         mov       [mode],al                ; reim obrazovky (1,2,3)
         cmp       al,2
         mov       bx,14                    ; vka dku 14 bod
         mov       cx,24                    ; posledn slo dku 24
         jc        fnc052                   ; je reim 1
         mov       bx,10                    ; vka dku 10 bod
         mov       cx,34                    ; posledn slo dku 34
         jz        fnc052                   ; je reim 2
         mov       bx,6                     ; vka dku 6 bod
         mov       cx,57                    ; posledn slo dku 57
fnc052:  push      cx                       ; slo poslednho dku
         mov       di,offset adrrow         ; tabulka adres dk na displeji
         mov       al,80                    ; poet znak na dek
         mul       bl                       ; poet bajt na dek
         mov       dx,0ffffh                ; adresa 0. dku
         inc       cx
fnc053:  mov       [di],dx                  ; uloen adresy dku
         inc       di
         inc       di                       ; zven ukazatele pro ukldn
         add       dx,ax                    ; zven adresy
         dec       cx                       ; ta dk
         jns       fnc053                   ; dal dek
         pop       cx                       ;
         mov       [vyska],bl               ; poet linek na dek
         mov       ax,80                    ; poet znak na dek
         mov       si,offset karta          ; adresa oznaen displeje
         ret

                                            ; FUNKCE 06 - nastaven text. mdu
fnc06:   mov       ax,3
         int       10h                      ; nastaven textovho mdu 80x25
         ret

                                            ; slovnk 1
slov1    db        'ANA ANI ABE ALTR EINI DEST GEI INI INS '
         db        'NACHT UNIV ZEITEN ZEITU ',0ffh

                                            ; slovnk 2
slov2    db        'AB AN AUF AUS NACH UN VER VOR ',0ffh

                                            ; slovnk 3
slov3    db        'ALT ALP BETT BERG DES EIN ERD ERNST FETT FEST '
         db        'GELD HAUS KREUZ LANG LEIT MACHT MAUS MENSCH NORD '
         db        'NCHST NETZ OBER OST REIT RCK SCHUL SPIEL SD '
         db        'TEST TIEF VOLL WACHS WASCH WEIT WETT WEG WEST ',0ffh

                                            ; slovnk 4
slov4    db        'DURCH LETZTEND SPORT TRANS ',0ffh

                                            ; slovnk 5
slov5    db        'DORT HOCH ZEIT BER ',0ffh

                                            ; slovnk 6
slov6    db        'CHA CURS DAR EMPF ENT HIN HER KOMP MIT SYN ',0ffh

                                            ; slovnk 7
slov7    db        'ABL ABR ALLEIN ANEI ANER ANORD ANS AT BEEH BEEI '
         db        'BEEN BEERD BEIRR BEOB BEUN BEUR ER GE IN KOOR '
         db        'OKT UM UR ZUGABE ',0ffh

                                            ; slovnk 8
slov8    db        'AI AU AY EI EU EY U ',0ffh

                                            ; slovnk 9
slov9    db        'EA E E E II I I I OA OE UE UI UU ',0ffh

                                            ; slovnk 10
slov10   db        'BL BR CH DR FL FR GL GR KL KN KR PFL PH PF '
         db        'PL PR SCHL SCHM SCHN SCHR SCHW STR SPR SCH '
         db        'SP ST TH TR ZW ',0ffh

                                            ; slovnk 11
slov11   db        'BS B CHTS CHS CHT CKT CH CK D FF FS F GS G '
         db        'HRS HL HM HN HR HT H KT K LBST LSCH LCH LFS '
         db        'LKS LTS LB LD LF LG LK LL LP LS LT L '
         db        'MPF MTS MM MP MT M NSCH NGS NDS NST ND NN NF '
         db        'NG NK NS NT NZ N PF PP PT P '
         db        'RSCH RCH RKT RST RB RD RF RG RK RM RN RS RT '
         db        'RZ R SCH ST S TSCH TZT TS TT TZ T XT Z '
         db        ' ',0ffh

                                            ; slovnk 12
slov12   db        'EITS IONS LLGE NSGE UNGS ',0ffh

                                            ; slovnk 13
slov13   db        'HAUS HEIT LICH LADE LAND LER LIG LOS PHA PREIS '
         db        'PUNKT RAND RAUM RECHT RECHN REICH RIG ROUT '
         db        'RUF ',0ffh

                                            ; slovnk 14
slov14   db        'AUS AUF AUGE AUTO AMT ART AB ARZT ARBEIT AKT '
         db        'ALGO ANALY ANDER ANF ANGAB ANGEB ANL ANOR '
         db        'ANSA ANTEIL ANWA ANWEN ANZAHL ANZEIG ANTW '
         db        'APFEL AFRI AMERI ADR APP ARGU EBENE ECK EDITO '
         db        'EIN EFF EURO ELEM ENERG ENTW EIMER ERDA '
         db        'ERGEBN ERFA ERLEB ERFO ERHAL ERKENN ETW EXP '
         db        'INDU INF INH INS IMP OBER ORDN ORDEN OPER ORGA '
         db        'ORIENT ORT UHR UMBRU UNFALL UNTER UMSATZ '
         db        'URLAUB URSACH URTEIL RZT NDER MT FFN '
         db        'KO B ',0ffh

b0aa4    db        0                        ; povolen dlka dku
b0aa5    dw        0                        ; adresa pevodn tabulky znak
w0aa7    dw        0
                                            ; test, zda jde o oddlovac znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je oddlovac znak

tst04:   mov       ah,4
         jmp       short tst401

                                            ; test, zda jde o dc znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je dc znak

tst40:   mov       ah,40h
tst401:  mov       al,[bx+di]               ; znak z textu k otestovn
         push      bx
         mov       bx,cs:[b0aa5]            ; adresa tabulky oddlovacch znak
         db        26h
         xlat                               ; transformace podle tab. ES:BX
         test      ah,al
         pop       bx
         ret

                                            ; nalezen zatku slova v textu
                                            ; vstup:  DS:[BX+DI] = ukaz.textu

endwrd:  dec       bx                       ; ukazatel textu
endwrd1: inc       bx
         call      tst40                    ; test, zda jde o dc znak
         jnz       endwrd2                  ; je dc znak - konec
         test      al,4                     ; jde o oddlovac znak slova ?
         jnz       endwrd1                  ; je oddlovac znak slova - dal
endwrd2: ret

                                            ; nalezen slova ve slovnku

                                            ; vstup:  CS:[SI] = ukazatel tabulky
                                            ;         DS:[BX+DI] = ukaz. textu
                                            ; vstup: AX = dlka shodnho slova
                                            ;         (AX = 0,ZF = 0 nenalezeno)

srcwrd:  mov       ah,32                    ; oddlovac znak slov (mezera)
srcwrd1: mov       al,cs:[si]               ; prvn znak slova z tabulky
         cmp       al,[bx+di]               ; porovnn se znakem v textu
         ja        srcwrd5                  ; znak v tabulce vt - nenalezeno
         jc        srcwrd3                  ; znak v tabulce men - dal slovo
         push      bx                       ; (shoda prvnho znaku) ukaz. textu
srcwrd2: inc       bx                       ; ukazatel zkoumanho textu
         inc       si                       ; ukazatel slovnku
         mov       al,cs:[si]               ; dal znak ze slovnku
         cmp       al,ah                    ; je mezera (konec slova) ?
         jz        srcwrd4                  ; je mezera = konec slova
         cmp       al,[bx+di]               ; porovnn dalho znaku slova
         jz        srcwrd2                  ; shoda - dal znak
         pop       bx                       ; (nen shoda) ukazatel textu
srcwrd3: inc       si                       ; nalezen dalho slova v tabulce
         cmp       ah,cs:[si]               ; je oddlovac mezera ?
         jnz       srcwrd3                  ; jet ne - dal znak v tabulce
         inc       si
         jmp       short srcwrd1            ; test dalho slova
srcwrd4: mov       ax,bx                    ; slova se shoduj
         pop       bx                       ; adresa slova ve slovnku
         sub       ax,bx                    ; dlka nalezenho slova
         ret
srcwrd5: xor       ax,ax                    ; slovo nenalezeno - konec (dlka 0)
         ret


lab0af5: push      bx                       ; adresa textu
         add       bx,ax                    ; adresa konce slabiky (rozdlit)
         push      bx                       ; adresa konce slabiky
         call      endwrd                   ; nalezen konce slova v textu
         mov       ax,bx                    ; konec slova v textu
         pop       bx                       ; adresa konce slabiky
         jz        lab0af51                 ; je ji konec dku
         sub       ax,bx                    ; poet znak do konec slova
         cmp       al,1                     ; dlka zbyl sti slova
         jna       lab0af52                 ; nen ji dn znak
         push      ax                       ; dlka zbyl sti slova
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       si                       ; dlka zbyl sti slova
         cmp       ax,si                    ; nalezeno stejn dlouh slovo ?
         jz        lab0af52                 ; je cel slovo
         xor       ax,ax                    
lab0af51:pop       bx                       
         ret                                
lab0af52:pop       si                       
lab0af53:cmp       bl,cs:[b0aa4]             ; povolen dlka dku
         jnc       lab0af55                  ; pekroen okraj dku
         inc       dx                       
         cmp       dx,bx                    
         mov       dx,bx                    
         jz        lab0af54                 
         mov       cs:[w0aa7],bx
lab0af54:ret                                
lab0af55:jmp       fnc097

                                            ;
lab0b2f: mov       si,offset slov1          ; slovnk 1 - nelze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0b2f5                 ; slovo nalezeno - konec
lab0b2f1:mov       si,offset slov2          ; slovnk 2 - lze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f2                 ; slovo nenalezeno - slovnk 3
         call      lab0af5                 
         jnz       lab0b2f1                
lab0b2f2:mov       si,offset slov3          ; slovnk 3
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f3                
         mov       si,di                   
         add       si,ax                   
         cmp       byte ptr [bx+si],"E"     ; je znak "E" ?
         jnz       lab0b2f4                
lab0b2f3:mov       si,offset slov4          ; slovnk 4
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,5                    
         jnz       lab0b2f4                
         mov       si,offset slov5          ; slovnk 5
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,4                    
         jnz       lab0b2f4                
         mov       si,offset slov6          ; slovnk 6
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,3                    
         jnz       lab0b2f4                
         mov       si,offset slov7          ; slovnk 7
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,2                    
         jz        lab0b2f5                
lab0b2f4:call      lab0af5                 
lab0b2f5:ret

lab0b85: mov       ax,bx                   
         sub       ax,cx                   
         cmp       ax,2                    
         xchg      bx,cx                   
         jc        lab0b853                
         jz        lab0b851                
         mov       si,offset slov8          ; slovnk 8
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b851                
         inc       bx                      
         jmp       short lab0b852          
lab0b851:mov       si,offset slov9          ; slovnk 9
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b853                
         cmp       byte ptr [bx+di-1],"Q"   ; je znak "Q" ?
         jz        lab0b853                
lab0b852:inc       bx                      
         call      lab0af53                
lab0b853:xchg      bx,cx                   
         ret       

lab0bb2: cmp       bx,cx
         jz        lab0bb27
         push      bx
         push      dx
         mov       dx,bx
         dec       dx
         mov       bx,cx
         dec       bx
lab0bb21:inc       bx
         cmp       bx,dx
         jz        lab0bb22
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0bb21
         add       ax,bx
         dec       ax
         cmp       ax,dx
         jnz       lab0bb21
         cmp       byte ptr [bx+di-1],"C"   ; byl pedchoz znak "C" ?
         jz        lab0bb21
lab0bb22:xchg      bx,cx
         mov       si,offset slov11         ; slovnk 11
         call      srcwrd                   ; nalezen slova ve slovnku
         add       bx,ax
         xchg      bx,cx
         cmp       bx,cx
         jnc       lab0bb26
         mov       dx,bx
lab0bb23:mov       si,offset slov12         ; slovnk 12
         push      bx
         sub       bx,4
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       bx
         jz        lab0bb24
         cmp       byte ptr cs:[w0aa7],0
         jnz       lab0bb26
lab0bb24:call      tst40                    ; test, zda jde o dc znak
         mov       si,offset slov14         ; slovnk 14
         jnz       lab0bb25
         mov       si,offset slov13         ; slovnk 13
lab0bb25:call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0bb26
         inc       bx
         cmp       bx,cx
         jna       lab0bb23
         mov       bx,dx
lab0bb26:pop       dx
         call      lab0af53
         pop       bx
lab0bb27:ret

                                            ; FUNKCE 09 - rozdlovn slov
                                            ; vstup:  DS = datov segment textu
                                            ;         CX = pozice v dku

fnc09:   mov       [w0aa7],0
         mov       [b0aa4],al               ; povolen dlka dku
         mov       [b0aa5],si               ; adresa transforman tabulky znak
         pop       dx                       ; nvratov adresa programu
         pop       ds                       ; datov segment textu
         push      ds                       ; datov segment textu
         push      dx                       ; nvratov adresa programu
         push      bp                       
         mov       bp,sp                    
fnc091:  mov       bx,cx                    ; aktuln pozice v dku
         dec       bx                       
fnc092:  inc       bx                       ; dal znak
         cmp       bl,cs:[b0aa4]            ; povolen dlka dku
         jnc       fnc097                   ; pekroen okraj dku - konec
         call      tst04                    ; test, zda jde o oddlovac znak
         jz        fnc092                   ; nenalezeno - dal
         mov       cx,bx                    ; nov pozice rozdlen slova
         dec       bx                       
fnc093:  inc       bx                       
         call      tst04                    ; test, zda jde o oddlovac znak
         jnz       fnc093                   ; nalezeno - dal pokus
         xchg      bx,cx                    
         mov       ax,cx                    
         sub       ax,bx                    
         cmp       ax,4                     
         jc        fnc091                   
         mov       dx,bx                    
         call      lab0b2f                  
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc091                   
         push      cx                       
fnc094:  mov       cx,bx                    
         dec       bx                       
fnc095:  inc       bx                       
         call      tst40                    ; test, zda jde o dc znak
         jnz       fnc095                   
         call      lab0b85                  
         mov       cx,bx                    
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc096                   
         call      lab0bb2                  
         jmp       short fnc094             
fnc096:  pop       cx                       
         jmp       short fnc091             
fnc097:  mov       ax,cs:[w0aa7]            
         mov       sp,bp                    
         pop       bp                       
         ret                                


                                            ; tabulka pro pekdovn klves

tabkey   db        0c1h,1eh                 ; ALT A
         db        0c2h,30h                 ; ALT B
         db        0c3h,2eh                 ; ALT C
         db        0c4h,20h                 ; ALT D
         db        0c5h,12h                 ; ALT E
         db        0c6h,21h                 ; ALT F
         db        0c7h,22h                 ; ALT G
         db        0c8h,23h                 ; ALT H
         db        0c9h,17h                 ; ALT I
         db        0cah,24h                 ; ALT J
         db        0cbh,25h                 ; ALT K
         db        0cch,26h                 ; ALT L
         db        0cdh,32h                 ; ALT M
         db        0ceh,31h                 ; ALT N
         db        0cfh,18h                 ; ALT O
         db        0d0h,19h                 ; ALT P
         db        0d1h,10h                 ; ALT Q
         db        0d2h,13h                 ; ALT R
         db        0d3h,1fh                 ; ALT S
         db        0d4h,14h                 ; ALT T
         db        0d5h,16h                 ; ALT U
         db        0d6h,2fh                 ; ALT V
         db        0d7h,11h                 ; ALT W
         db        0d8h,2dh                 ; ALT X
         db        0d9h,15h                 ; ALT Y
         db        0dah,2ch                 ; ALT Z
         db        0f0h,81h                 ; ALT 0
         db        0f1h,78h                 ; ALT 1
         db        0f2h,79h                 ; ALT 2
         db        0f3h,7ah                 ; ALT 3
         db        0f4h,7bh                 ; ALT 4
         db        0f5h,7ch                 ; ALT 5
         db        0f6h,7dh                 ; ALT 6
         db        0f7h,7eh                 ; ALT 7
         db        0f8h,7fh                 ; ALT 8
         db        0f9h,80h                 ; ALT 9
         db        1bh,3bh                  ; F1
         db        1ch,3ch                  ; F2
         db        1dh,3dh                  ; F3
         db        1eh,3eh                  ; F4
         db        1fh,3fh                  ; F5
         db        20h,40h                  ; F6
         db        21h,41h                  ; F7
         db        22h,42h                  ; F8
         db        23h,43h                  ; F9
         db        24h,44h                  ; F10
         db        5bh,54h                  ; SHIFT F1
         db        5ch,55h                  ; SHIFT F2
         db        5dh,56h                  ; SHIFT F3
         db        5eh,57h                  ; SHIFT F4
         db        5fh,58h                  ; SHIFT F5
         db        60h,59h                  ; SHIFT F6
         db        61h,5ah                  ; SHIFT F7
         db        62h,5bh                  ; SHIFT F8
         db        63h,5ch                  ; SHIFT F9
         db        64h,5dh                  ; SHIFT F10
         db        9bh,5eh                  ; CTRL F1
         db        9ch,5fh                  ; CTRL F2
         db        9dh,60h                  ; CTRL F3
         db        9eh,61h                  ; CTRL F4
         db        9fh,62h                  ; CTRL F5
         db        0a0h,63h                 ; CTRL F6
         db        0a1h,64h                 ; CTRL F7
         db        0a2h,65h                 ; CTRL F8
         db        0a3h,66h                 ; CTRL F9
         db        0a4h,67h                 ; CTRL F10
         db        0dbh,68h                 ; ALT F1
         db        0dch,69h                 ; ALT F2
         db        0ddh,6ah                 ; ALT F3
         db        0deh,6bh                 ; ALT F4
         db        0dfh,6ch                 ; ALT F5
         db        0e0h,6dh                 ; ALT F6
         db        0e1h,6eh                 ; ALT F7
         db        0e2h,6fh                 ; ALT F8
         db        0e3h,70h                 ; ALT F9
         db        0e4h,71h                 ; ALT F10
         db        0a5h,73h                 ; CTRL <-
         db        0a6h,74h                 ; CTRL ->
         db        0a7h,77h                 ; CTRL HOME
         db        0a8h,75h                 ; CTRL END
         db        0a9h,84h                 ; CTRL PGUP
         db        0aah,76h                 ; CTRL PGDN
         db        6bh,0fh                  ; SHIFT TAB
         db        0,0                      


tabshf   db        6                        ; dlka jedn poloky
         db        0,'     '                ; 00h
         db        5,'SHIFT'                ; 40h
         db        4,'CTRL '                ; 80h
         db        3,'ALT  '                ; C0h
         db        0ffh                     

tabhome  db        5                        ; dlka jedn poloky
         db        2,'<-  '                 ; 25h
         db        2,'->  '                 ; 26h
         db        4,'HOME'                 ; 27h
         db        3,'END '                 ; 28h
         db        4,'PGUP'                 ; 29h
         db        4,'PGDN'                 ; 2Ah
         db        3,'TAB '                 ; 2Bh
         db        0ffh                     

tabfn    db        4                        ; dlka jedn poloky
         db        2,'F1 '                  ; 1Bh
         db        2,'F2 '                  ; 1Ch
         db        2,'F3 '                  ; 1Dh
         db        2,'F4 '                  ; 1Eh
         db        2,'F5 '                  ; 1Fh
         db        2,'F6 '                  ; 20h
         db        2,'F7 '                  ; 21h
         db        2,'F8 '                  ; 22h
         db        2,'F9 '                  ; 23h
         db        3,'F10'                  ; 24h
         db        0ffh                     

                                            ; pevod textu na velk psmena

                                            ; vstup:  ES:SI = ukazatel na text
                                            ;         BL = nejmen znak
                                            ; vstup: ES:[BX+SI] = zatek textu
                                            ;         CX = poet znak textu
                                            ;         CF=0,ZF=0 je konec textu
                                            ;         CF=0,ZF=1 nen jet konec

upper:   xor       cx,cx                    ; vynulovn tae znak
upper1:  cmp       bl,es:[si]               ; porovnn znaku s BL
         ja        upper6                   ; znak je men ne BL - konec
         cmp       byte ptr es:[bx+si]," "  ; je mezera ?
         jnz       upper2                   ; nen - konec hledn
         inc       bx                       ; dal pozice
         jmp       short upper1             ; dal znak
upper2:  push      bx                       
upper3:  cmp       bl,es:[si]               ; kontrola koncovho znaku
         ja        upper5                   ; znak je men ne BL - konec
         mov       al,es:[bx+si]            ; peten znaku k pekdovn
         cmp       al," "                   ; je mezera ?
         jz        upper5                   ; je mezera - konec
         cmp       al,"|"                   ; "|"
         jz        upper5                   ; je znak "|" - konec
         cmp       al,"a"                   ; "a"
         jc        upper4                   ; je znak men ne "a"
         and       al,0dfh                  ; pevod na velk psmeno
         mov       es:[bx+si],al            ; uloen pevedenho znaku
upper4:  inc       bx                       ; dal znak
         inc       cx                       ; zven tae nalezench znak
         jmp       upper3                   ; pevod dalho znaku na velk
upper5:  pop       bx                       
upper6:  ret                                

                                            ; nalezen textov poloky v tabulce

                                            ; vstup:  ES:[BX+SI] ukazatel textu
                                            ;         DS:DI = ukazatel tabulky
                                            ;         CX = dlka hled. textu
                                            ; vstup: ES:[BX+SI] nov pozice
                                            ;         DL = poad. slo poloky
                                            ;         AX = dlka poloky tabulky

srctab:  mov       al,[di]                  ; peten dlky jedn poloky
         mov       ah,0                     
         inc       di                       ; ukazatel tabulky - prvn poloka
         xor       dl,dl                    ; ta poloek
srctab1: inc       dx                       ; zven tae poloek
         cmp       cl,[di]                  ; porovnn dlky textu
         jnz       srctab4                  ; nesouhlas - dal poloka
         push      ax                       ; dlka jedn poloky
         push      bx                       ; ukazatel textu
         push      cx                       ; dlka textu
         push      di                       ; ukazatel tabulky
         inc       di                       ; prvn znak poloky
srctab2: mov       al,es:[bx+si]            ; zkouman znak
         cmp       al,[di]                  ; porovnn se znakem z tabulky
         jnz       srctab3                  ; nesouhlas - dal poloka
         inc       bx                       ; zven ukazatele textu
         inc       di                       ; zven ukazatele tabulky
         loop      srctab2                  ; dal znak k testu
         pop       di                       ; ukazatel tabulky - nalezeno
         pop       cx                       ; dlka textu
         pop       ax                       ; zruen pvodn pozice textu BX
         pop       ax                       ; dlka jedn poloky
         or        dl,dl                    ; poadov slo poloky
         ret                                
srctab3: pop       di                       ; ukazatel tabulky
         pop       cx                       ; dlka textu
         pop       bx                       ; ukazatel zkoumanho textu
         pop       ax                       ; dlka jedn poloky
srctab4: add       di,ax                    ; adresa dal poloky
         cmp       byte ptr [di],0ffh       ; je koncov znak tabulky ?
         jnz       srctab1                  ; nen jet konec
         xor       dl,dl                    ; nenalezen - slo poloky = 0
         ret                                


                                            ; FUNKCE 10 - dekdovn klvesy

                                            ; vstup:  ES:SI = ukazatel textu
                                            ; vstup: ES:SI = nov pozice
                                            ;         AX = kd klvesy

fnc10:   mov       bx,1                     ; koncov znak = 00
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         mov       di,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      srctab                   ; nalezen textov poloky v tabulce
         mov       dh,dl                    ; poadov slo poloky - schova
         jz        fnc103                   ; text nebyl nalezen
         dec       dh                       ; poad. slo poloky - 1
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         cmp       cx,1                     ; je pouze jeden znak ?
         jnz       fnc102                   ; nen prv jeden znak
         mov       al,es:[bx+si]            ; znak k pekdovn
         cmp       al,"@"                   ; = "@"
         jc        fnc101                   ; men ne "@"
         cmp       al,"Z"                   ; = "Z"
         ja        fnc106                   ; vt ne "Z"
         sub       al,40h                   ; pevod na dc znak
fnc101:  mov       dl,al                    ; pekdovan znak
         jmp       short fnc104             
fnc102:  mov       di,offset tabhome        ; tabulka dcch klves HOME,...
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc103                   ; poloka nenalezena
         add       dl,24h                   ; korekce
         jmp       short fnc104
fnc103:  mov       di,offset tabfn          ; tabulka funknch klves Fn
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc106                   ; nenalezena
         add       dl,1ah                   ; korekce
fnc104:  ror       dh,1                     
         ror       dh,1                     
         or        dl,dh                    ; klvesy SHIFT,.. jako bity 6 a 7
         mov       di,offset tabkey         ; tabulka pro dekdovn kd klves
fnc105:  mov       al,[di]                  ; kd klvesy
         inc       di                       
         inc       di                       
         or        al,al                    ; je posledn kd ?
         jz        fnc106                   ; kd klvesy nenalezen
         cmp       al,dl                    ; porovnn s hledanm kdem
         jnz       fnc105                   ; dal pokus
         dec       di                       
         mov       al,[di]                  ; pekdovn kdu klvesy
         mov       ah,0                     
         ret                                
fnc106:  xor       ax,ax                    ; kd klvesy nenalezen
         ret                                

                                            ; vpis kdu klvesy

                                            ; vstup:  CS:SI tabulka klves
                                            ;         DL = poad. slo klvesy
                                            ;         DS:[BX+DI] = vst. buffer
                                            ;         CH = 0
                                            ; vstup: DS:[BX+DI] = nov pozice

outkey:  push      ax                       
         mov       al,cs:[si]               ; dlka jedn poloky v tabulce
         mul       dl                       ; rel. adresa poloky v tabulce
         add       si,ax                    ; adresa poloky v tabulce
         inc       si                       
         mov       cl,cs:[si]               ; dlka textu v poloce
         jcxz      outkey2                  
outkey1: inc       si                       ; znak poloky textu klvesy
         inc       bx                       ; ukazatel vstupnho textu
         mov       al,cs:[si]               ; peten znaku poloky
         mov       [bx+di],al               ; uloen do bufferu
         loop      outkey1                  ; dal znak
         inc       bx                       ; nsledujc pozice
         mov       byte ptr [bx+di]," "     ; oddlovac mezera
outkey2: pop       ax                       
         ret                                

adrtab   dw        offset tabkey            ; ukazatel dekdovac tabulky klves


                                            ; FUNKCE 11 - vpis kdu klvesy

                                            ; vstup:  DS:[BX+DI] = vst. buffer
                                            ;         AX = kd klvesy
                                            ; vstup: DS:[BX+DI] = nov adresa

fnc11:   mov       dx,ax                    ; kd klvesy
         xor       cx,cx                    ; ta znak
         mov       bx,[adrtab]              ; ukazatel dekdovac tabulky klves
         inc       bx                       ; dal klvesa
fnc111:  mov       al,[bx]                  ; kd klvesy
         or        al,al                    ; je ukonovac znak 00 ?
         jnz       fnc112                   ; nen jet konec
         mov       [adrtab],offset tabkey   ; nastav. za. dekd. tabulky klves
         mov       es,dx
         mov       es:[di],ch               ;
         ret       
fnc112:  push      si                       ; ukazatel tabulky klves
fnc113:  mov       ah,es:[si]               ; kd klvesy
         or        ah,ah
         jz        fnc114                   ; je ji posledn
         cmp       al,ah                    ; porovnn s hledanou klvesou
         jz        fnc115                   ; je nalezen kd klvesy
         inc       si                       ; dal klvesa
         mov       cl,es:[si]               ;
         inc       cx
         add       si,cx                    ; adresa nsledujcho textu
         jmp       short fnc113             ; nov pokus
fnc114:  pop       si
         inc       bx
         inc       bx
         jmp       short fnc111
fnc115:  inc       bx
         mov       [adrtab],bx              ; nov adresa ukazatele tabulky
         mov       al,[bx-2]                ; kd klvesy
         inc       si
         pop       bx
         push      si
         push      dx
         pop       ds
         xor       bx,bx
         mov       dl,al
         and       dl,0c0h
         rol       dl,1
         rol       dl,1
         mov       si,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      outkey                   ; vpis kdu klvesy
         mov       dl,al
         and       dl,3fh
         cmp       dl,1ah
         ja        fnc116
         add       dl,40h
         inc       bx
         mov       [bx+di],dl
         jmp       short fnc119
fnc116:  cmp       dl,24h
         ja        fnc117
         sub       dl,1bh
         mov       si,offset tabfn          ; tabulka funknch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc117:  cmp       dl,2bh                   ; znak "+"
         ja        fnc118
         sub       dl,25h
         mov       si,offset tabhome        ; tabulka dcch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc118:  inc       bx
         mov       [bx+di],dl
fnc119:  cmp       bx,9
         ja        fnc11a
         inc       bx
         mov       byte ptr [bx+di]," "     ; oddlovac znak mezery
         jmp       short fnc119
fnc11a:  inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         pop       si
         mov       cl,es:[si]
fnc11b:  inc       si
         mov       al,es:[si]               ; peten znaku k vytitn
         inc       bx
         cmp       al," "
         jnc       fnc11c                   ; nen dc znak
         mov       byte ptr [bx+di],"^"     ; uloen znaku "^" (znak s CTRL-)
         inc       bx                       ; zven ukazatele
         or        al,40h                   ; pevod znaku na tisknuteln znak
fnc11c:  mov       [bx+di],al               ; uloen znaku
         loop      fnc11b                   ; pevod dalho znaku
         inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         mov       [di],bl
         ret       

tab01:                                      ; povely s CTRL-
         db        1
         db        27
         db        1
         db        80
         db        18
         db        17,'$$',15
         db        ' Povely s CTRL- ',31
         db        2,'$Kurzor...$ '
         db        4,'$Obrazovka...$'
         db        5,'$Zvltn...$',31
         db        ' S vlevo',2,'(',0fbh,')'
         db        4,'C strnka dol'
         db        5,'B formtuj',31
         db        ' X dol',3,'(',0f9h,')'
         db        6,'(PgDn)',13,'odstavec',31
         db        ' D vpravo (',0fah,')'
         db        4,'R strnka nahoru'
         db        3,'L pokrauj',31
         db        ' E nahoru (',0f8h,')'
         db        6,'(PgUp)',13,'v hledn',31
         db        ' A slovo vlevo'
         db        3,'Z dek dol'
         db        7,'M konec odstavce',31
         db        ' F slovo vpravo'
         db        2,'W dek nahoru'
         db        7,'<Enter>',31
         db        ' I na dal'
         db        25,'N vloen',31
         db        3,'tabeltor'
         db        6,'$Podmenu...$'
         db        8,'dku',31
         db        17,'J info/displej'
         db        5,'V vkldn',31
         db        2,'$Mazn...$'
         db        4,'K blok/soubor'
         db        8,'zap/vyp',31
         db        ' G znaku nad'
         db        5,'O formtovn/'
         db        7,'<Insert>',31
         db        3,'kurzorem'
         db        8,'nastavovn'
         db        6,'\ zvltn znaky',31
         db        ' H znaku vlevo'
         db        3,'P typy psma'
         db        7,'- zmna znak',31
         db        ' T slova vpravo'
         db        2,'Q pesuny kurzoru/'
         db        1,'] text do buff.',31
         db        ' Y dku'
         db        11,'hledn/zmna'
         db        3,'^ text z buff.'
         db        0

tab02:                                      ; ^J
         db        0
         db        58
         db        1
         db        80
         db        16
         db        11,' CTRL J ',31
         db        ' B',2,'dky displeje',31
         db        ' C',2,'barvy displeje',31
         db        ' F',2,'blikn zap/vyp',31
         db        ' H',2,'pomoc zap/vyp',31
         db        ' -------------------',31
         db        ' G',2,'graf.editor',31
         db        ' I',2,'pracovn prostor',31
         db        ' D',2,'zpis data',31
         db        ' T',2,'zpis asu',31
         db        ' K',2,'kalend/hodiny',31
         db        ' -------------------',31
         db        ' R',2,'vpoty v textu',31
         db        ' S',2,'sloupcov souty',31
         db        ' M',2,'sloupcov prmr'
         db        0

tab03:                                      ; ^K
         db        0
         db        35
         db        1
         db        80
         db        14
         db        14,'$$'
         db        17,' CTRL K ',31
         db        17,'$Blok....$',31
         db        ' B',2,'oznaen zatku'
         db        6,'C',2,'koprovn ',31
         db        ' K',2,'oznaen konce'
         db        8,'V',2,'pesunut',31
         db        ' N',2,'sloupcov blok'
         db        8,'Y',2,'mazn',31
         db        ' H',2,'zobrazen zap/vyp'
         db        5,'R',2,'ten',31
         db        ' T',2,'zmna psma'
         db        11,'W',2,'uloen',31
         db        ' G',2,'penos z'
         db        ' jinho pracovnho prostoru',31
         db        ' ------------------------------------------',31
         db        ' D',2,'menu souboru'
         db        10,'E',2,'mazn textu',31
         db        ' P',2,'menu tisku'
         db        12,'L',2,'ten textu',31
         db        '1-5 zmna prac. prostoru'
         db        2,'S',2,'uloen textu',31
         db        ' Q',2,'ukonen KonTextu'
         db        5,'X',2,'start programu'
         db        0

tab04:                                      ; ^O
         db        0
         db        23
         db        1
         db        80
         db        15
         db        24,'$$'
         db        20,' CTRL O ',31
         db        3,'$Pepnae zap/vyp'
         db        8,'Formtovn$',31
         db        ' J',2,'zarovnvn'
         db        11,'B',2,'formt. po konec textu',31
         db        ' H',2,'dlen slov'
         db        11,'C',2,'centrovn dku',31
         db        ' Q',2,'dlen s dotazem'
         db        6,'Z',2,'dvousloupcov formtovn',31
         db        ' V',2,'automat.tabeltor',31
         db        ' M',2,'<Enter>=kon.odst.'
         db        7,'$Nastaven strnky$',31
         db        ' P',2,'zobrazen strnky'
         db        5,'I',2,'menu linelu dku',31
         db        ' T',2,'zobrazen linelu'
         db        5,'F',2,'prav okraj=konec dku',31
         db        ' N',2,'nedokumentn md'
         db        6,'L',2,'lev okraj=pozice kurzoru',31
         db        26,'R',2,'prav okraj=pozice kurzoru',31
         db        26,'S',2,'poet dk na strnku',31
         db        ' A',2,'zatek odstavce',2,0f0h
         db        3,'E',2,'zobrazen zhlav/paty',31
         db        ' U',2,'neformtovat',6,0ffh
         db        3,'O',2,'blok jako zhlav/pata'
         db        0

tab05:                                      ; ^P
         db        0
         db        59
         db        1
         db        80
         db        9
         db        10,' CTRL P ',31
         db        ' N=normln',31
         db        ' F=zvraznn',31
         db        ' U=podtren',31
         db        ' K=kurzva',31
         db        ' B=irok',31
         db        ' H=nadsazen',31
         db        ' T=podsazen'
         db        0,0,0,0,0,0,0,0

tab06:                                      ; ^Q
         db        0
         db        39
         db        1
         db        80
         db        13
         db        30,' CTRL Q ',31
         db        ' A',2,'hledn/zmna'
         db        5,'F',2,'hledn',31
         db        ' M',2,'nastaven znaky'
         db        3,'T',2,'makroklvesy',31
         db        ' L',2,'navrcen poslednch zmn   ',31
         db        10,'$Pozice kurzoru...$',31
         db        ' S',2,'zatek dku'
         db        6,'D',2,'konec dku',31
         db        ' E',2,'horn okraj'
         db        8,'X',2,'doln okraj',31
         db        ' R',2,'zatek textu'
         db        6,'C',2,'konec textu',31
         db        ' B',2,'zatek bloku'
         db        6,'K',2,'konec bloku',31
         db        ' P',2,'na znaku'
         db        10,'Z',2,'pozice',31
         db        14,'$Mazn...$',31
         db        ' H',2,'po zatek dku'
         db        3,'Y',2,'po konec dku'
         db        0,0

tab07:                                      ; ^JC
         db        1
         db        52
         db        1
         db        80
         db        10
         db        16,' CTRL JC ',31,31
         db        2,'--- Nastaven barev ---',31
         db        ' Zadejte slo barvy nebo',31
         db        ' zvolte <Enter>=beze zmny',31,31
         db        ' Barva psma (0..15):',31
         db        ' Barva okol (0..15):'
         db        0

tab08:                                      ; ^JI
         db        1
         db        54
         db        1
         db        80
         db        13
         db        13,' CTRL JI ',31,31
         db        ' - Pracovn prostor : - ',31
         db        '$   obsah          dk$',31
         db        31,31,31,31,31,31
         db        ' text :'
         db        7,'B volnch',31
         db        ' makra:'
         db        7,'B volnch'
         db        0

tab09:                                      ; ^JK
         db        1
         db        49
         db        1
         db        80
         db        16
         db        19,' CTRL JK ',31
         db        31,31,31
         db        2,'PO',2,'T',2,'ST',2,'T',2,'P',2,'SO',2,'NE',31
         db        ' ============================',31
         db        31,31,31,31,31,31
         db        ' ============================',31
         db        1,0fbh,2,'pedch.'
         db        2,0fah,' nsled.  msc',31
         db        1,0f9h,2,'pedch.',2,0f8h,' nsled.  rok '
         db        0

tab10:                                      ; ^KD
         db        1
         db        61
         db        1
         db        80
         db        17
         db        8,' CTRL KD ',31
         db        ' ti text',31
         db        ' ulo text',31
         db        ' ti blok',31
         db        ' ulo blok',31
         db        ' zru soubor',31
         db        ' pejmenuj soubor',31
         db        ' kopruj soubor',31
         db        ' start programu',31
         db        ' ulo nastaven',31
         db        ' konec KonTextu',31
         db        ' ----------------',31
         db        ' formt KonText',31
         db        ' formt Layout',31
         db        ' formt ASCII',31
         db        ' zloha BAK'
         db        0

tab11:
         db        0
         db        52
         db        1
         db        80
         db        3
         db        'a'
         db        0

tab12:                                      ; zadn strnek k tisku
         db        1
         db        52
         db        1
         db        80
         db        11
         db        31
         db        4,'-- tisk textu   --',31
         db        2,'  Zadejte sla nebo     ',31
         db        '   <Enter> = dn zmna ',31,31
         db        ' prvn strnka:  ',5,'1',31
         db        ' konen strnka:',31
         db        ' prvn slo strany:',2,'1',31
         db        ' exempl:',11,'1'
         db        0

tab13:                                      ; ^KP
         db        1
         db        55
         db        1
         db        80
         db        7
         db        13,' CTRL KP ',31,31
         db        ' - probh tisk textu -',31,31
         db        9,'dle',31
         db        9,'peruen'
         db        0

tab14:                                      ; ^KQ
         db        1
         db        25
         db        6
         db        54
         db        14
         db        16,' CTRL KQ ',31,31
         db        3,'Tmto povelem ukonte',31
         db        ' KonText a navrtte se zpt',31
         db        2,'do operanho systmu !!!',31,31
         db        2,'Stisknte <Enter> = konec',31
         db        3,'nebo <Esc> = pokrauj'
         db        0

tab15:                                      ; ^OE
         db        0
         db        58
         db        1
         db        80
         db        7
         db        10,' CTRL OE ',31
         db        31
         db        'Jako blok se zobraz:',31,31
         db        4,'K = zhlav',31
         db        4,'F = pata '
         db        0

tab16:                                      ; ^OI
         db        0
         db        53
         db        1
         db        80
         db        15
         db        14,' CTRL OI ',31
         db        2,'-- Tabeltory/okraje --',31,31
         db        2,0fah,3,'kurzor vpravo',31
         db        2,0fbh,3,'kurzor vlevo',31
         db        ' End',2,'...k pravmu okraji',31
         db        ' Home ...k levmu okraji',31
         db        2,'L',3,'lev okraj',31
         db        2,'R',3,'prav okraj',31
         db        ' Tab',2,'nastav/zru tabel.',31
         db        2,'#',3,'dekadick tabeltor',31
         db        ' Del',2,'ruen/nvrat tabel.',31
         db        ' Ret',2,'ukonen volby',31
         db        ' Esc',2,'peruen volby'
         db        0

tab17:                                      ; ^OO
         db        0
         db        58
         db        1
         db        80
         db        7
         db        10,' CTRL OO ',31,31
         db        ' Blok se ulo jako: ',31,31
         db        4,'K = zhlav ',31
         db        4,'F = pata'
         db        0

tab18:                                      ; ^OS
         db        1
         db        46
         db        1
         db        80
         db        11
         db        22,' CTRL OS ',31,31
         db        '   Zadejte nov nastaven nebo',31
         db        2,'stisknte <Enter>=beze zmny: ',31,31
         db        ' dk na strnku (4..99):',31
         db        ' z toho: zhlav  (0..10):',31
         db        7,'  pata   ',2,'(0..10):',31,31
         db        ' rozte dk :',9,'cm'
         db        0

tab19:                                      ; ^OZ
         db        1
         db        25
         db        4
         db        54
         db        14
         db        17,' CTRL OZ ',31,31
         db        3,'Tento povel zformtuje',31
         db        4,'text na tto stran',31
         db        4,'dvousloupcov. Nov',31
         db        3,'formtovn ji nadle',31
         db        7,'nebude mon !',31
         db        10,'Zvolte:',31
         db        5,'<Enter> = potvrzen',31
         db        2,'<Esc> = peruen povelu'
         db        0

tab20:                                      ; volby pro hledn
         db        0
         db        58
         db        1
         db        80
         db        9
         db        10,' VOLBY ',31
         db        ' B',2,'zptn smr',31
         db        ' G',2,'v celm textu',31
         db        ' L',2,'v celm bloku',31
         db        ' W',2,'pouze cel slovo',31
         db        ' U',2,'nerozliuje velk',31
         db        4,'a mal psmena'
         db        0

tab21:                                      ; hlen - Text nebude uloen
         db        1
         db        27
         db        7
         db        54
         db        13
         db        31
         db        2,' Text v prac.prost.',31
         db        2,'nebude uloen na disk !',31,31
         db        3,'<Enter>=pokraovn',31
         db        5,'<Esc>=peruen'
         db        0

tab22:                                      ; zvltn znaky
         db        1
         db        34
         db        1
         db        80
         db        15
         db        28,' Zvltn znaky '
         db        0

tab23:                                      ; hlen SETUP
         db        1
         db        25
         db        4
         db        54
         db        13
         db        19,' SETUP ',31,31
         db        ' Tato volba zpsob, e pi',31
         db        2,'dalm sputn KonTextu',31
         db        2,'bude opt pouito stejn',31
         db        3,'nastaven parametr.',31,31
         db        3,'Zvolte <Enter>=uloen',31
         db        4,'nebo <Esc>=peruen.'
         db        0

tab24:                                      ; CTRL-KN
         db        0
         db        50
         db        1
         db        80
         db        8
         db        18,' CTRL KN ',31,31
         db        3,'Nastaven sloupc.bloku:',31,31
         db        ' B',2,'zatek (lev horn roh)',31
         db        ' K',2,'konec (prav doln roh) '
         db        0

tab25:                                      ; sriov tisk
         db        1
         db        50
         db        1
         db        80
         db        10
         db        31
         db        5,'--- Sriov tisk --',31
         db        ' Prosm, zadejte novou volbu',31
         db        2,'nebo <Enter> = beze zmny:',31,31
         db        ' Datov prostor',2,'(1..5):',31
         db        ' Peformtovn ',2,'(J/N):',31
         db        0

tab26:                                      ; pauza sriovho tisku
         db        1
         db        30
         db        7
         db        51
         db        13
         db        31
         db        ' Sriov tisk-pauza',31
         db        ' pro',2,'vmnu papru',31,31
         db        ' pokraovn = <Enter> ,',31
         db        4,'peruen = <ESC>'
         db        0

tab27:                                      ; volba KURZOR
         db        1
         db        1
         db        1
         db        21
         db        12
         db        31
         db        ' zatek textu',31
         db        ' konec textu',31
         db        ' zatek bloku',31
         db        ' konec bloku',31
         db        ' na znaku',31
         db        ' nastaven znaky',31
         db        ' na danou pozici',31
         db        ' vyhledn textu',31
         db        ' hledn/zmna',31
         db        ' dal hledn'
         db        0

tab28:                                      ; volba MAZN
         db        1
         db        3
         db        1
         db        21
         db        9
         db        31
         db        ' slovo vpravo',31
         db        ' po kurzor',31
         db        ' od kurzoru',31
         db        ' cel dek',31
         db        ' cel blok',31
         db        ' obnoven zmn',31
         db        ' cel text'
         db        0

tab29:                                      ; volba BLOK
         db        1
         db        12
         db        1
         db        29
         db        14
         db        31
         db        ' zatek bloku',31
         db        ' konec bloku',31
         db        ' sloupc.blok ',0dah,0c4h,31
         db        ' sloupc.blok',2,0c4h,0d9h,31
         db        ' mazn',31
         db        ' pemstn',31
         db        ' koprovn',31
         db        ' penos z prost.',31
         db        ' ten z disku',31
         db        ' uloen na disk',31
         db        ' zmna psma',31
         db        ' oznaen bloku'
         db        0

tab30:                                      ; volba PSMO
         db        1
         db        19
         db        1
         db        37
         db        9
         db        31
         db        ' normln',31
         db        ' zvraznn',31
         db        ' podtren',31
         db        ' kurzva',31
         db        ' irok',31
         db        ' nadsazen',31
         db        ' podsazen'
         db        0

tab31:                                      ; volba FORMT.
         db        1
         db        26
         db        1
         db        46
         db        14
         db        31
         db        ' po konec odstav.',31
         db        ' po konec textu',31
         db        ' dvousloupcov',31
         db        ' centruj dek',31
         db        ' zarovnvn',31
         db        ' rozdlovn',31
         db        ' s dotazem',31
         db        ' auto-tabeltor',31
         db        ' <Enter>=odstavec',31
         db        ' zat. odstavce ',0f0h,31
         db        ' konec odstavce',2,0f1h,31
         db        ' neformtovat',4,0ffh
         db        0

tab32:                                      ; volba STRNKA
         db        1
         db        32
         db        1
         db        56
         db        14
         db        31
         db        ' dk na strnku',31
         db        ' menu linelu dk',31
         db        ' lev okraj=kurzor',31
         db        ' prav okraj=kurzor',31
         db        ' prav okraj=konec d.',31
         db        ' zobrazen zhlav',31
         db        ' zobrazen paty',31
         db        ' blok jako zhlav',31
         db        ' blok jako pata',31
         db        ' zobraz. strnkovn',31
         db        ' zobr. linelu dku',31
         db        ' nedokumentn md'
         db        0

tab33:                                      ; volba DISPLEJ
         db        1
         db        43
         db        1
         db        61
         db        8
         db        31
         db        ' 25 dk',31
         db        ' 35 dk',31
         db        ' 58 dk',31
         db        ' zmna barev',31
         db        ' npovda',31
         db        ' blikn kurz.'
         db        0

tab34:                                      ; volba EXTRA
         db        1
         db        51
         db        1
         db        69
         db        14
         db        31
         db        ' prac. prostor',31
         db        ' text do bufferu',31
         db        ' text z bufferu',31
         db        ' zpis asu',31
         db        ' zpis data',31
         db        ' kalend',31
         db        ' grafick editor',31
         db        ' zvltn znaky',31
         db        ' makroklvesy',31
         db        ' kalkultor',31
         db        ' sloupc. souet',31
         db        ' sloupc. prmr'
         db        0

tab35:                                      ; volba TISK, ^KP
         db        1
         db        59
         db        1
         db        77
         db        15
         db        6,' CTRL KP ',31
         db        ' tisk textu',31
         db        ' sriov tisk',31
         db        ' ten instalace',31
         db        ' zmna instalace',31
         db        ' ---------------',31
         db        ' vy kvalita',31
         db        ' psmo Elite',31
         db        ' zk psmo',31
         db        ' proporcionl.',31
         db        ' dvoj. petisk',31
         db        ' hust dkov.',31
         db        ' samostat.list',31
         db        ' vmna papru'
         db        0


tabhlp   dw        offset tab01
         dw        offset tab02
         dw        offset tab03
         dw        offset tab04
         dw        offset tab05
         dw        offset tab06
         dw        offset tab07
         dw        offset tab08
         dw        offset tab09
         dw        offset tab10
         dw        offset tab11
         dw        offset tab12
         dw        offset tab13
         dw        offset tab14
         dw        offset tab15
         dw        offset tab16
         dw        offset tab17
         dw        offset tab18
         dw        offset tab19
         dw        offset tab20
         dw        offset tab21
         dw        offset tab22
         dw        offset tab23
         dw        offset tab24
         dw        offset tab25
         dw        offset tab26
         dw        offset tab27
         dw        offset tab28
         dw        offset tab29
         dw        offset tab30
         dw        offset tab31
         dw        offset tab32
         dw        offset tab33
         dw        offset tab34
         dw        offset tab35

                                            ; funkce 07 - adresa npovdy ES:SI
fnc07:   mov       bx,[bp+4]
         shl       bx,1
         mov       si,[bx+tabhlp]
         push      ds
         pop       es
         ret

taberr:                                     ; tabulka chybovch hlen
         db        1,'Soubor nebyl nalezen',0
         db        2,'ten souboru nen mon',0
         db        3,'Zpis do souboru nen mon',0
         db        4,'Poadovan adres nenalezen',0
         db        5,'Nedostatek msta v pamti',0
         db        6,'Pekroen maximln poet dk',0
         db        7,'" nebyl nalezen',0
         db        8,'dek je moc dlouh',0
         db        9,'Nepovolen zadn',0
         db        10,'Nen oznaen dn blok',0
         db        11,'Pam makroklves je pln',0
         db        12,'Tiskrna nen v provozu',0
         db        13,'Chybn formt dat',0
         db        15,'Soubor s tmto jmnem ji existuje',0
         db        16,'Zdrojov a clov soubor jsou identick',0
         db        17,'Prostor @ nen dosud vytistn.',0
         db        18,'Sloupcov blok neme bt zapsn do souboru',0
         db        19,'Nen oznaen dn sloupcov blok',0
         db        20,'Kurzor se mus nachzet vpravo od pravho okraje',0
         db        21,'Mus bt zadn soubor EXE nebo COM',0
         db        50,'Nepovolen matematick vraz',0
         db        51,'Peteen desetinn teky',0
         db        52,'Dlen nulou',0
         db        53,'Chybn argument',0
         db        54,'Chyba argumentu',0
         db        99,'Intern chyba',0
         db        100,'Disketov mechanika nepracuje',0
         db        153,'Neoekvan konec souboru',0
         db        196,'Peteen sla Integer',0
         db        240,'Disk je pln',0
         db        241,'Nepovolen jmno souboru',0
         db        0,'Ble neuriteln chyba',0


                                            ; FUNKCE 08 - adresa chybovch hlen

fnc08:   mov       si,offset taberr         ; tabulka hlen
         push      ds                       ; nastaven ES = DS
         pop       es
         ret

                                            ; fonty 6x8 bod

fnt6x8   db        0,0,0,0,0,0                      ; 0
         db        0c3h,0a5h,81h,0a5h,99h,0c3h      ; 1
         db        0ffh,0dbh,0ffh,0dbh,0e7h,0ffh    ; 2
         db        6ch,0feh,0feh,7ch,38h,10h        ; 3
         db        10h,38h,7ch,0feh,7ch,38h         ; 4
         db        38h,38h,0d6h,0feh,0d6h,10h       ; 5
         db        10h,38h,7ch,0feh,0d6h,10h        ; 6
         db        0,18h,3ch,3ch,18h,0              ; 7
         db        0ffh,0e7h,0c3h,0c3h,0e7h,0ffh    ; 8
         db        3ch,66h,42h,42h,66h,3ch          ; 9
         db        0c3h,99h,0bdh,0bdh,99h,0c3h      ; 10
         db        7h,0fh,7dh,0cch,0cch,0cch        ; 11
         db        66h,66h,66h,3ch,18h,7eh          ; 12
         db        38h,3ch,34h,30h,0d0h,0f0h        ; 13
         db        33h,3fh,33h,33h,0ddh,0ffh        ; 14
         db        5ah,24h,0c3h,0c3h,24h,5ah        ; 15
         db        70h,7ch,7eh,7ch,70h,40h          ; 16
         db        0eh,3eh,7eh,3eh,0eh,2            ; 17
         db        3ch,7eh,18h,18h,7eh,3ch          ; 18
         db        6ch,6ch,6ch,6ch,0,6ch            ; 19
         db        0f4h,0f4h,74h,34h,34h,34h        ; 20
         db        60h,38h,6ch,6ch,38h,0ch          ; 21  ""
         db        0,0,0,7eh,7eh,7eh                ; 22  
         db        3ch,7eh,18h,7eh,3ch,18h          ; 23  
         db        3ch,7eh,18h,18h,18h,18h          ; 24  
         db        18h,18h,18h,18h,7eh,3ch          ; 25  
         db        4h,6,0ffh,0ffh,6,4               ; 26  
         db        20h,60h,0ffh,0ffh,60h,20h        ; 27  
         db        60h,60h,60h,60h,7eh,0            ; 28  
         db        24h,66h,0ffh,0ffh,66h,24h        ; 29  
         db        8h,1ch,3eh,7fh,7fh,7fh           ; 30  
         db        7fh,7fh,7fh,3eh,1ch,8            ; 31  
         db        0,0,0,0,0,0                      ; 32  " "
         db        18h,18h,18h,0,18h,0              ; 33  "!"
         db        6ch,6ch,0,0,0,0                  ; 34  "
         db        6ch,0feh,6ch,0feh,6ch,0          ; 35  "#"
         db        3eh,58h,3ch,1ah,7ch,0            ; 36  "$"
         db        66h,6ch,18h,36h,66h,0            ; 37  "%"
         db        38h,38h,76h,0dch,76h,0           ; 38  "&"
         db        18h,30h,0,0,0,0                  ; 39  "'"
         db        18h,30h,30h,30h,18h,0            ; 40  "("
         db        18h,0ch,0ch,0ch,18h,0            ; 41  ")"
         db        66h,3ch,0ffh,3ch,66h,0           ; 42  "*"
         db        18h,18h,7eh,18h,18h,0            ; 43  "+"
         db        0,0,0,0,18h,30h                  ; 44  ","
         db        0,0,7eh,0,0,0                    ; 45  "-"
         db        0,0,0,0,18h,0                    ; 46  "."
         db        6h,0ch,18h,30h,60h,0             ; 47  "/"
         db        3ch,66h,66h,66h,3ch,0            ; 48  "0"
         db        18h,38h,18h,18h,18h,0            ; 49  "1"
         db        3ch,66h,0ch,38h,7eh,0            ; 50  "2"
         db        3ch,66h,0ch,66h,3ch,0            ; 51  "3"
         db        1ch,3ch,6ch,7eh,0ch,0            ; 52  "4"
         db        7eh,60h,7ch,6,7ch,0              ; 53  "5"
         db        3ch,60h,7ch,66h,7ch,0            ; 54  "6"
         db        7ch,0ch,18h,30h,30h,0            ; 55  "7"
         db        3ch,66h,3ch,66h,3ch,0            ; 56  "8"
         db        3ch,66h,3eh,0ch,18h,0            ; 57  "9"
         db        0,18h,0,18h,0,0                  ; 58  ":"
         db        0,0,18h,0,18h,30h                ; 59  ";"
         db        0ch,18h,30h,18h,0ch,0            ; 60  "<"
         db        0,7eh,0,7eh,0,0                  ; 61  "="
         db        30h,18h,0ch,18h,30h,0            ; 62  ">"
         db        3ch,66h,0ch,0,18h,0              ; 63  "?"
         db        7ch,0c6h,0deh,0c0h,7ch,0         ; 64  "@"
         db        3ch,66h,7eh,66h,66h,0            ; 65  "A"
         db        7ch,66h,7ch,66h,7ch,0            ; 66  "B"
         db        3ch,66h,60h,66h,3ch,0            ; 67  "C"
         db        7ch,66h,66h,66h,7ch,0            ; 68  "D"
         db        7eh,60h,78h,60h,7eh,0            ; 69  "E"
         db        7eh,60h,7ch,60h,60h,0            ; 70  "F"
         db        3eh,60h,6eh,66h,3ch,0            ; 71  "G"
         db        66h,66h,7eh,66h,66h,0            ; 72  "H"
         db        3ch,18h,18h,18h,3ch,0            ; 73  "I"
         db        6h,6,66h,66h,3ch,0               ; 74  "J"
         db        66h,6ch,70h,6ch,66h,0            ; 75  "K"
         db        60h,60h,60h,60h,7eh,0            ; 76  "L"
         db        0c6h,0eeh,0feh,0d6h,0c6h,0       ; 77  "M"
         db        66h,76h,7eh,6eh,66h,0            ; 78  "N"
         db        3ch,66h,66h,66h,3ch,0            ; 79  "O"
         db        7ch,66h,7ch,60h,60h,0            ; 80  "P"
         db        3ch,66h,66h,6ch,36h,0            ; 81  "Q"
         db        7ch,66h,7ch,6ch,66h,0            ; 82  "R"
         db        3eh,60h,3ch,6,7ch,0              ; 83  "S"
         db        7eh,18h,18h,18h,18h,0            ; 84  "T"
         db        66h,66h,66h,66h,3ch,0            ; 85  "U"
         db        0c6h,0c6h,0c6h,6ch,38h,0         ; 86  "V"
         db        0c6h,0d6h,0feh,0eeh,0c6h,0       ; 87  "W"
         db        66h,3ch,18h,3ch,66h,0            ; 88  "X"
         db        66h,66h,3ch,18h,18h,0            ; 89  "Y"
         db        7eh,0ch,18h,30h,7eh,0            ; 90  "Z"
         db        3ch,30h,30h,30h,3ch,0            ; 91  "["
         db        60h,30h,18h,0ch,6,0              ; 92  "\"
         db        3ch,0ch,0ch,0ch,3ch,0            ; 93  "]"
         db        10h,38h,6ch,0,0,0                ; 94  "^"
         db        0,0,0,0,0,0                      ; 95  "_"
         db        18h,0ch,0,0,0,0                  ; 96  "`"
         db        0,3eh,66h,66h,3eh,0              ; 97  "a"
         db        60h,7ch,66h,66h,7ch,0            ; 98  "b"
         db        0,3ch,60h,60h,3ch,0              ; 99  "c"
         db        6h,3eh,66h,66h,3eh,0             ; 100 "d"
         db        0,38h,7ch,60h,3ch,0              ; 101 "e"
         db        1ch,36h,78h,30h,30h,0            ; 102 "f"
         db        0,3eh,66h,3eh,6,7ch              ; 103 "g"
         db        60h,7ch,66h,66h,66h,0            ; 104 "h"
         db        18h,0,18h,18h,18h,0              ; 105 "i"
         db        6h,0,6,36h,3eh,0                 ; 106 "j"
         db        60h,66h,7ch,7ch,66h,0            ; 107 "k"
         db        18h,18h,18h,18h,18h,0            ; 108 "l"
         db        0,6ch,0feh,0d6h,0c6h,0           ; 109 "m"
         db        0,7ch,66h,66h,66h,0              ; 110 "n"
         db        0,3ch,66h,66h,3ch,0              ; 111 "o"
         db        0,7ch,66h,66h,7ch,60h            ; 112 "p"
         db        0,3eh,66h,66h,3eh,6              ; 113 "q"
         db        0,7ch,66h,60h,60h,0              ; 114 "r"
         db        0,3ch,70h,0ch,78h,0              ; 115 "s"
         db        30h,7eh,30h,36h,1ch,0            ; 116 "t"
         db        0,66h,66h,66h,3eh,0              ; 117 "u"
         db        0,66h,66h,3ch,18h,0              ; 118 "v"
         db        0,0c6h,0d6h,0feh,6ch,0           ; 119 "w"
         db        0,66h,3ch,3ch,66h,0              ; 120 "x"
         db        0,66h,66h,3eh,6,7ch              ; 121 "y"
         db        0,7ch,18h,30h,7ch,0              ; 122 "z"
         db        1eh,18h,70h,18h,1eh,0            ; 123 "{"
         db        18h,18h,0,18h,18h,0              ; 124 "|"
         db        38h,18h,0eh,18h,38h,0            ; 125 "}"
         db        32h,4ch,0,0,0,0                  ; 126 "~"
         db        0,18h,3ch,66h,7eh,0              ; 127 ""
         db        24h,3ch,60h,60h,3ch,0            ; 128 ""
         db        66h,0,66h,66h,3eh,0              ; 129 ""
         db        18h,3ch,7eh,60h,3ch,0            ; 130 ""
         db        56h,26h,3eh,66h,3eh,0            ; 131 ""
         db        66h,3ch,66h,66h,3eh,0            ; 132 ""
         db        24h,7ch,66h,66h,7ch,0            ; 133 ""
         db        24h,7eh,18h,18h,18h,0            ; 134 ""
         db        24h,18h,3ch,60h,3ch,0            ; 135 ""
         db        24h,3ch,7eh,60h,3ch,0            ; 136 ""
         db        24h,7eh,78h,60h,7eh,0            ; 137 ""
         db        64h,64h,60h,60h,7eh,0            ; 138 ""
         db        7ah,32h,30h,30h,78h,0            ; 139 ""
         db        6ah,64h,60h,60h,60h,0            ; 140 ""
         db        62h,62h,60h,60h,60h,0            ; 141 ""
         db        0c6h,38h,6ch,7ch,6ch,0           ; 142 ""
         db        1ah,3eh,66h,7eh,66h,0            ; 143 ""
         db        0ch,7eh,78h,60h,7eh,0            ; 144 ""
         db        24h,18h,7eh,3ch,7eh,0            ; 145 ""
         db        24h,7eh,1ch,38h,7eh,0            ; 146 ""
         db        3ch,0,3ch,66h,3ch,0              ; 147 ""
         db        66h,0,3ch,66h,3ch,0              ; 148 ""
         db        0ch,3ch,66h,66h,3ch,0            ; 149 ""
         db        18h,18h,66h,66h,3eh,0            ; 150 ""
         db        0ch,66h,66h,66h,3ch,0            ; 151 ""
         db        0ch,0ch,66h,3eh,6,7ch            ; 152 ""
         db        66h,3ch,66h,66h,3ch,0            ; 153 ""
         db        66h,0,66h,66h,7eh,0              ; 154 ""
         db        24h,7eh,3ch,6,7ch,0              ; 155 ""
         db        6ah,64h,60h,60h,7eh,0            ; 156 ""
         db        0ch,66h,3ch,18h,18h,0            ; 157 ""
         db        24h,7ch,66h,7ch,66h,0            ; 158 ""
         db        6ah,64h,78h,60h,3ch,0            ; 159 ""
         db        18h,0,3eh,66h,3eh,0              ; 160 ""
         db        0ch,18h,0,18h,18h,0              ; 161 ""
         db        18h,0,3ch,66h,3ch,0              ; 162 ""
         db        18h,0,66h,66h,3eh,0              ; 163 ""
         db        24h,18h,7ch,66h,66h,0            ; 164 ""
         db        24h,18h,76h,7eh,6eh,0            ; 165 ""
         db        18h,66h,66h,66h,3ch,0            ; 166 ""
         db        3ch,42h,3ch,66h,3ch,0            ; 167 ""
         db        12h,0ch,3eh,3ch,7ch,0            ; 168 ""
         db        24h,18h,7ch,62h,60h,0            ; 169 ""
         db        0ch,18h,7ch,62h,60h,0            ; 170 ""
         db        0ch,7ch,66h,7ch,66h,0            ; 171 ""
         db        20h,60h,2ah,0eh,2,0              ; 172 ""
         db        60h,38h,6ch,6ch,38h,0ch          ; 173 ""
         db        0,36h,6ch,36h,0,0                ; 174 ""
         db        0,6ch,36h,6ch,0,0                ; 175 ""
         db        88h,22h,88h,22h,88h,22h          ; 176 ""
         db        0aah,55h,0aah,55h,0aah,55h       ; 177 ""
         db        77h,0ddh,77h,0ddh,77h,0ddh       ; 178 ""
         db        18h,18h,18h,18h,18h,18h          ; 179 ""
         db        18h,18h,18h,0f8h,18h,18h         ; 180 ""
         db        18h,0f8h,18h,0f8h,18h,18h        ; 181 ""
         db        66h,66h,66h,0e6h,66h,66h         ; 182 ""
         db        0,0,0,0feh,66h,66h               ; 183 ""
         db        0,0f8h,18h,0f8h,18h,18h          ; 184 ""
         db        66h,0e6h,6,0e6h,66h,66h          ; 185 ""
         db        66h,66h,66h,66h,66h,66h          ; 186 ""
         db        0,0feh,6,0e6h,66h,66h            ; 187 ""
         db        66h,0e6h,6,0feh,0,0              ; 188 ""
         db        66h,66h,66h,0feh,0,0             ; 189 ""
         db        18h,0f8h,18h,0f8h,0,0            ; 190 ""
         db        0,0,0,0f8h,18h,18h               ; 191 ""
         db        18h,18h,18h,1fh,0,0              ; 192 ""
         db        18h,18h,18h,0ffh,0,0             ; 193 ""
         db        0,0,0,0ffh,18h,18h               ; 194 ""
         db        18h,18h,18h,1fh,18h,18h          ; 195 ""
         db        0,0,0,0ffh,0,0                   ; 196 ""
         db        18h,18h,18h,0ffh,18h,18h         ; 197 ""
         db        18h,1fh,18h,1fh,18h,18h          ; 198 ""
         db        66h,66h,66h,67h,66h,66h          ; 199 ""
         db        66h,67h,60h,7fh,0,0              ; 200 ""
         db        0,7fh,60h,67h,66h,66h            ; 201 ""
         db        66h,0e7h,0,0ffh,0,0              ; 202 ""
         db        0,0ffh,0,0e7h,66h,66h            ; 203 ""
         db        66h,67h,60h,67h,66h,66h          ; 204 ""
         db        0,0ffh,0,0ffh,0,0                ; 205 ""
         db        66h,0e7h,0,0e7h,66h,66h          ; 206 ""
         db        18h,0ffh,0,0ffh,0,0              ; 207 ""
         db        66h,66h,66h,0ffh,0,0             ; 208 ""
         db        0,0ffh,0,0ffh,18h,18h            ; 209 ""
         db        0,0,0,0ffh,66h,66h               ; 210 ""
         db        66h,66h,66h,7fh,0,0              ; 211 ""
         db        18h,1fh,18h,1fh,0,0              ; 212 ""
         db        0,1fh,18h,1fh,18h,18h            ; 213 ""
         db        0,0,0,7fh,66h,66h                ; 214 ""
         db        66h,66h,66h,0ffh,66h,66h         ; 215 ""
         db        18h,0ffh,18h,0ffh,18h,18h        ; 216 ""
         db        18h,18h,18h,0f8h,0,0             ; 217 ""
         db        0,0,0,1fh,18h,18h                ; 218 ""
         db        0ffh,0ffh,0ffh,0ffh,0ffh,0ffh    ; 219 ""
         db        0,0,0,0ffh,0ffh,0ffh             ; 220 ""
         db        0f0h,0f0h,0f0h,0f0h,0f0h,0f0h    ; 221 ""
         db        0fh,0fh,0fh,0fh,0fh,0fh          ; 222 ""
         db        0ffh,0ffh,0ffh,0,0,0             ; 223 ""
         db        0,76h,0dch,0dch,76h,0            ; 224 ""
         db        3ch,66h,7ch,66h,7ch,60h          ; 225 ""
         db        7eh,66h,60h,60h,60h,0            ; 226 ""
         db        0,0feh,6ch,6ch,66h,0             ; 227 ""
         db        7eh,66h,30h,66h,7eh,0            ; 228 ""
         db        0,7eh,0d8h,0d8h,70h,0            ; 229 ""
         db        0,66h,66h,7ch,60h,0c0h           ; 230 ""
         db        0,7eh,18h,18h,0ch,0              ; 231 ""
         db        7eh,18h,66h,66h,18h,7eh          ; 232 ""
         db        3ch,66h,7eh,66h,3ch,0            ; 233 ""
         db        7ch,0c6h,0c6h,6ch,0eeh,0         ; 234 ""
         db        3ch,60h,3ch,66h,3ch,0            ; 235 ""
         db        0,66h,0dbh,0dbh,66h,0            ; 236 ""
         db        7h,3ch,66h,66h,3ch,0e0h          ; 237 ""
         db        1eh,30h,7eh,30h,1eh,0            ; 238 ""
         db        3ch,66h,66h,66h,66h,0            ; 239 ""
         db        7eh,0,7eh,0,7eh,0                ; 240 ""
         db        18h,7eh,18h,0,7eh,0              ; 241 ""
         db        18h,0ch,18h,0,3ch,0              ; 242 ""
         db        18h,30h,18h,0,3ch,0              ; 243 ""
         db        1ch,36h,30h,30h,30h,30h          ; 244 ""
         db        0ch,0ch,0ch,0ch,6ch,38h          ; 245 ""
         db        18h,0,7eh,0,18h,0                ; 246 ""
         db        72h,9ch,0,72h,9ch,0              ; 247 ""
         db        0,3ch,66h,66h,3ch,0              ; 248 ""
         db        0,0,0,18h,18h,0                  ; 249 ""
         db        0,0,0,0,18h,0                    ; 250 ""
         db        7h,0ch,0ch,98h,0d8h,70h          ; 251 ""
         db        78h,6ch,6ch,0,0,0                ; 252 ""
         db        38h,0ch,3eh,0,0,0                ; 253 ""
         db        0,38h,38h,38h,0,0                ; 254 ""
         db        0,0,0,0,0,0                      ; 255 

                                            ; fonty 8x8 bod
fnt8x8   db        0,0,0,0,0,0,0,0                         ; 0
         db        7eh,0c3h,0a5h,81h,0a5h,99h,0c3h,7eh     ; 1
         db        7eh,0ffh,0dbh,0ffh,0dbh,0e7h,0ffh,7eh   ; 2
         db        0,6ch,0feh,0feh,7ch,38h,10h,0           ; 3
         db        0,10h,38h,7ch,0feh,7ch,38h,10h          ; 4
         db        0,38h,38h,0d6h,0feh,0d6h,10h,38h        ; 5
         db        0,10h,38h,7ch,0feh,0d6h,10h,38h         ; 6
         db        0,0,18h,3ch,3ch,18h,0,0                 ; 7
         db        0ffh,0ffh,0e7h,0c3h,0c3h,0e7h,0ffh,0ffh ; 8
         db        0,3ch,66h,42h,42h,66h,3ch,0             ; 9
         db        0ffh,0c3h,99h,0bdh,0bdh,99h,0c3h,0ffh   ; 10
         db        0fh,7,0fh,7dh,0cch,0cch,0cch,78h        ; 11
         db        3ch,66h,66h,66h,3ch,18h,7eh,18h         ; 12
         db        30h,38h,3ch,34h,30h,0d0h,0f0h,60h       ; 13
         db        3fh,33h,3fh,33h,33h,0ddh,0ffh,66h       ; 14
         db        99h,5ah,24h,0c3h,0c3h,24h,5ah,99h       ; 15
         db        40h,70h,7ch,7eh,7ch,70h,40h,0           ; 16
         db        2h,0eh,3eh,7eh,3eh,0eh,2,0              ; 17
         db        18h,3ch,7eh,18h,18h,7eh,3ch,18h         ; 18
         db        6ch,6ch,6ch,6ch,6ch,0,6ch,0             ; 19
         db        7eh,0f4h,0f4h,74h,34h,34h,34h,0         ; 20
         db        3ch,60h,38h,6ch,6ch,38h,0ch,78h         ; 21  " "
         db        0,0,0,0,7eh,7eh,7eh,0                   ; 22
         db        18h,3ch,7eh,18h,7eh,3ch,18h,7eh         ; 23
         db        18h,3ch,7eh,18h,18h,18h,18h,18h         ; 24
         db        18h,18h,18h,18h,18h,7eh,3ch,18h         ; 25
         db        0,4,6,0ffh,0ffh,6,4,0                   ; 26
         db        0,20h,60h,0ffh,0ffh,60h,20h,0           ; 27
         db        0,60h,60h,60h,60h,7eh,0,0               ; 28
         db        0,24h,66h,0ffh,0ffh,66h,24h,0           ; 29
         db        0,8,1ch,3eh,7fh,7fh,7fh,0               ; 30
         db        0,7fh,7fh,7fh,3eh,1ch,8,0               ; 31
         db        0,0,0,0,0,0,0,0                         ; 32  " "
         db        18h,18h,18h,18h,18h,0,18h,0             ; 33  "!"
         db        6ch,6ch,6ch,0,0,0,0,0                   ; 34  "
         db        6ch,6ch,0feh,6ch,0feh,6ch,6ch,0         ; 35  "#"
         db        18h,3eh,58h,3ch,1ah,7ch,18h,0           ; 36  "$"
         db        0,63h,66h,0ch,18h,33h,63h,0             ; 37  "%"
         db        1ch,36h,1ch,3bh,6eh,66h,3bh,0           ; 38  "&"
         db        18h,18h,30h,0,0,0,0,0                   ; 39  "'"
         db        0ch,18h,30h,30h,30h,18h,0ch,0           ; 40  "("
         db        30h,18h,0ch,0ch,0ch,18h,30h,0           ; 41  ")"
         db        0,66h,3ch,0ffh,3ch,66h,0,0              ; 42  "*"
         db        0,18h,18h,7eh,18h,18h,0,0               ; 43  "+"
         db        0,0,0,0,0,18h,18h,30h                   ; 44  ","
         db        0,0,0,7eh,0,0,0,0                       ; 45  "-"
         db        0,0,0,0,0,18h,18h,0                     ; 46  "."
         db        6h,0ch,18h,30h,60h,0c0h,80h,0           ; 47  "/"
         db        7ch,0c6h,0ceh,0d6h,0e6h,0c6h,7ch,0      ; 48  "0"
         db        18h,38h,18h,18h,18h,18h,18h,0           ; 49  "1"
         db        3ch,66h,6,0ch,18h,30h,7eh,0             ; 50  "2"
         db        3ch,66h,6,1ch,6,66h,3ch,0               ; 51  "3"
         db        1ch,3ch,6ch,0cch,0feh,0ch,0ch,0         ; 52  "4"
         db        7eh,60h,7ch,6,6,66h,3ch,0               ; 53  "5"
         db        3ch,66h,60h,7ch,66h,66h,3ch,0           ; 54  "6"
         db        7eh,6,6,0ch,18h,18h,18h,0               ; 55  "7"
         db        3ch,66h,66h,3ch,66h,66h,3ch,0           ; 56  "8"
         db        3ch,66h,66h,3eh,0ch,18h,30h,0           ; 57  "9"
         db        0,0,18h,18h,0,18h,18h,0                 ; 58  ":"
         db        0,0,18h,18h,0,18h,18h,30h               ; 59  ";"
         db        0ch,18h,30h,60h,30h,18h,0ch,0           ; 60  "<"
         db        0,0,7eh,0,0,7eh,0,0                     ; 61  "="
         db        60h,30h,18h,0ch,18h,30h,60h,0           ; 62  ">"
         db        3ch,66h,6,0ch,18h,0,18h,0               ; 63  "?"
         db        7ch,0c6h,0deh,0deh,0deh,0c0h,7ch,0      ; 64  "@"
         db        38h,6ch,0c6h,0c6h,0feh,0c6h,0c6h,0      ; 65  "A"
         db        0fch,0c6h,0c6h,0fch,0c6h,0c6h,0fch,0    ; 66  "B"
         db        3ch,66h,0c0h,0c0h,0c0h,66h,3ch,0        ; 67  "C"
         db        0f8h,0cch,0c6h,0c6h,0c6h,0cch,0f8h,0    ; 68  "D"
         db        0feh,0c0h,0c0h,0f8h,0c0h,0c0h,0feh,0    ; 69  "E"
         db        0feh,0c0h,0c0h,0f8h,0c0h,0c0h,0c0h,0    ; 70  "F"
         db        3ch,66h,0c0h,0c0h,0ceh,66h,3eh,0        ; 71  "G"
         db        0c6h,0c6h,0c6h,0feh,0c6h,0c6h,0c6h,0    ; 72  "H"
         db        78h,30h,30h,30h,30h,30h,78h,0           ; 73  "I"
         db        6h,6,6,6,0c6h,0c6h,7ch,0                ; 74  "J"
         db        0c6h,0cch,0d8h,0f0h,0d8h,0cch,0c6h,0    ; 75  "K"
         db        0c0h,0c0h,0c0h,0c0h,0c0h,0c0h,0feh,0    ; 76  "L"
         db        0c6h,0eeh,0feh,0d6h,0c6h,0c6h,0c6h,0    ; 77  "M"
         db        0c6h,0e6h,0f6h,0deh,0ceh,0c6h,0c6h,0    ; 78  "N"
         db        38h,6ch,0c6h,0c6h,0c6h,6ch,38h,0        ; 79  "O"
         db        0fch,0c6h,0c6h,0fch,0c0h,0c0h,0c0h,0    ; 80  "P"
         db        38h,6ch,0c6h,0c6h,0dah,6ch,36h,0        ; 81  "Q"
         db        0fch,0c6h,0c6h,0fch,0cch,0c6h,0c6h,0    ; 82  "R"
         db        7ch,0c6h,0c0h,7ch,6,0c6h,7ch,0          ; 83  "S"
         db        0fch,30h,30h,30h,30h,30h,30h,0          ; 84  "T"
         db        0c6h,0c6h,0c6h,0c6h,0c6h,0c6h,7ch,0     ; 85  "U"
         db        0c6h,0c6h,0c6h,0c6h,0c6h,6ch,38h,0      ; 86  "V"
         db        0c6h,0c6h,0c6h,0d6h,0feh,0eeh,0c6h,0    ; 87  "W"
         db        0c6h,0c6h,6ch,38h,6ch,0c6h,0c6h,0       ; 88  "X"
         db        66h,66h,66h,3ch,18h,18h,18h,0           ; 89  "Y"
         db        0feh,6,0ch,18h,30h,60h,0feh,0           ; 90  "Z"
         db        3ch,30h,30h,30h,30h,30h,3ch,0           ; 91  "["
         db        0c0h,60h,30h,18h,0ch,6,2,0              ; 92  "\"
         db        3ch,0ch,0ch,0ch,0ch,0ch,3ch,0           ; 93  "]"
         db        8h,1ch,36h,63h,0,0,0,0                  ; 94  "^"
         db        0,0,0,0,0,0,0,0ffh                      ; 95  "_"
         db        30h,18h,0ch,0,0,0,0,0                   ; 96  "`"
         db        0,0,7ch,6,7eh,0c6h,7eh,0                ; 97  "a"
         db        0c0h,0c0h,0fch,0c6h,0c6h,0c6h,0fch,0    ; 98  "b"
         db        0,0,7ch,0c6h,0c0h,0c6h,7ch,0            ; 99  "c"
         db        6h,6,7eh,0c6h,0c6h,0c6h,7eh,0           ; 100 "d"
         db        0,0,7ch,0c6h,0feh,0c0h,7ch,0            ; 101 "e"
         db        3ch,66h,60h,0f8h,60h,60h,60h,0          ; 102 "f"
         db        0,0,7eh,0c6h,0c6h,7eh,6,0fch            ; 103 "g"
         db        0c0h,0c0h,0fch,0c6h,0c6h,0c6h,0c6h,0    ; 104 "h"
         db        18h,0,18h,18h,18h,18h,18h,0             ; 105 "i"
         db        0ch,0,0ch,0ch,0ch,0ch,0cch,78h          ; 106 "j"
         db        0c0h,0c0h,0c6h,0cch,0f8h,0cch,0c6h,0    ; 107 "k"
         db        18h,18h,18h,18h,18h,18h,18h,0           ; 108 "l"
         db        0,0,6ch,0feh,0d6h,0c6h,0c6h,0           ; 109 "m"
         db        0,0,0fch,0c6h,0c6h,0c6h,0c6h,0          ; 110 "n"
         db        0,0,7ch,0c6h,0c6h,0c6h,7ch,0            ; 111 "o"
         db        0,0,0fch,0c6h,0c6h,0fch,0c0h,0c0h       ; 112 "p"
         db        0,0,7eh,0c6h,0c6h,7eh,6,6               ; 113 "q"
         db        0,0,0fch,0c6h,0c0h,0c0h,0c0h,0          ; 114 "r"
         db        0,0,7ch,0c0h,7ch,6,0fch,0               ; 115 "s"
         db        60h,60h,0fch,60h,60h,66h,3ch,0          ; 116 "t"
         db        0,0,0c6h,0c6h,0c6h,0c6h,7eh,0           ; 117 "u"
         db        0,0,0c6h,0c6h,0c6h,6ch,38h,0            ; 118 "v"
         db        0,0,0c6h,0c6h,0d6h,0feh,6ch,0           ; 119 "w"
         db        0,0,0c6h,6ch,38h,6ch,0c6h,0             ; 120 "x"
         db        0,0,0c6h,0c6h,0c6h,7eh,6,0fch           ; 121 "y"
         db        0,0,7eh,0ch,18h,30h,7eh,0               ; 122 "z"
         db        0eh,18h,18h,70h,18h,18h,0eh,0           ; 123 "{"
         db        18h,18h,18h,0,18h,18h,18h,0             ; 124 "|"
         db        70h,18h,18h,0eh,18h,18h,70h,0           ; 125 "}"
         db        32h,4ch,0,0,0,0,0,0                     ; 126 "~"
         db        0,18h,3ch,66h,0c3h,0c3h,0ffh,0          ; 127 ""
         db        66h,3ch,66h,0c0h,0c0h,66h,3ch,0         ; 128 ""
         db        66h,0,0c6h,0c6h,0c6h,0c6h,7eh,0         ; 129 ""
         db        0ch,18h,7ch,0c6h,0feh,0c0h,7ch,0        ; 130 ""
         db        96h,66h,6,7eh,0c6h,0c6h,7eh,0           ; 131 ""
         db        66h,0,7ch,6,7eh,0c6h,7eh,0              ; 132 ""
         db        0cch,78h,0f8h,0cch,0c6h,0cch,0f8h,0     ; 133 ""
         db        66h,3ch,7eh,18h,18h,18h,18h,0           ; 134 ""
         db        66h,3ch,7ch,0c6h,0c0h,0c6h,7ch,0        ; 135 ""
         db        66h,3ch,7ch,0c6h,0feh,0c0h,7ch,0        ; 136 ""
         db        0cch,78h,0fch,0c0h,0f0h,0c0h,0fch,0     ; 137 ""
         db        0cch,0cch,0d8h,0c0h,0c0h,0c0h,0feh,0    ; 138 ""
         db        0ch,18h,3ch,18h,18h,18h,3ch,0           ; 139 ""
         db        35h,32h,30h,30h,30h,30h,30h,0           ; 140 ""
         db        1bh,1bh,18h,18h,18h,18h,18h,0           ; 141 ""
         db        0c6h,38h,6ch,0c6h,0feh,0c6h,0c6h,0      ; 142 ""
         db        13h,3bh,6ch,0c6h,0feh,0c6h,0c6h,0       ; 143 ""
         db        0ch,18h,7eh,60h,78h,60h,7eh,0           ; 144 ""
         db        66h,3ch,7eh,0ch,18h,30h,7eh,0           ; 145 ""
         db        6ch,0feh,0ch,18h,30h,60h,0feh,0         ; 146 ""
         db        3ch,66h,0,7ch,0c6h,0c6h,7ch,0           ; 147 ""
         db        66h,0,7ch,0c6h,0c6h,0c6h,7ch,0          ; 148 ""
         db        3h,3bh,6ch,0c6h,0c6h,6ch,38h,0          ; 149 ""
         db        3ch,66h,3ch,0c6h,0c6h,0c6h,7eh,0        ; 150 ""
         db        0ch,0dah,0c6h,0c6h,0c6h,0c6h,7ch,0      ; 151 ""
         db        0ch,18h,0c6h,0c6h,0c6h,7eh,6,0fch       ; 152 ""
         db        0c6h,38h,6ch,0c6h,0c6h,6ch,38h,0        ; 153 ""
         db        66h,0,0c6h,0c6h,0c6h,0c6h,7ch,0         ; 154 ""
         db        24h,7eh,0c0h,7ch,6,0c6h,7ch,0           ; 155 ""
         db        0dbh,0ceh,0c0h,0c0h,0c0h,0c0h,0feh,0    ; 156 ""
         db        0ch,5ah,66h,3ch,18h,18h,18h,0           ; 157 ""
         db        0cch,78h,0fch,0c6h,0fch,0c6h,0c6h,0     ; 158 ""
         db        66h,66h,0f4h,60h,60h,66h,3ch,0          ; 159 ""
         db        0ch,18h,7ch,6,7eh,0c6h,7eh,0            ; 160 ""
         db        0ch,18h,0,18h,18h,18h,18h,0             ; 161 ""
         db        0ch,18h,0,7ch,0c6h,0c6h,7ch,0           ; 162 ""
         db        18h,30h,0,0c6h,0c6h,0c6h,7eh,0          ; 163 ""
         db        6ch,38h,0fch,0c6h,0c6h,0c6h,0c6h,0      ; 164 ""
         db        66h,3ch,0e6h,0f6h,0deh,0ceh,0c6h,0      ; 165 ""
         db        18h,0a4h,0dah,0c6h,0c6h,0c6h,7ch,0      ; 166 ""
         db        7ch,82h,38h,6ch,0c6h,6ch,38h,0          ; 167 ""
         db        66h,3ch,7eh,0c0h,7ch,6,0fch,0           ; 168 ""
         db        0cch,78h,0fch,0c6h,0c0h,0c0h,0c0h,0     ; 169 ""
         db        18h,30h,0dch,0e6h,0c0h,0c0h,0c0h,0      ; 170 ""
         db        18h,30h,0fch,0c6h,0fch,0c6h,0c6h,0      ; 171 ""
         db        40h,0c0h,44h,4ch,54h,1eh,4,0            ; 172 ""
         db        3ch,60h,38h,6ch,6ch,38h,0ch,78h         ; 173 ""
         db        0,36h,6ch,0d8h,6ch,36h,0,0              ; 174 ""
         db        0,0d8h,6ch,36h,6ch,0d8h,0,0             ; 175 ""
         db        22h,88h,22h,88h,22h,88h,22h,88h         ; 176 ""
         db        55h,0aah,55h,0aah,55h,0aah,55h,0aah     ; 177 ""
         db        0ddh,77h,0ddh,77h,0ddh,77h,0ddh,77h     ; 178 ""
         db        18h,18h,18h,18h,18h,18h,18h,18h         ; 179 ""
         db        18h,18h,18h,18h,0f8h,18h,18h,18h        ; 180 ""
         db        18h,18h,0f8h,18h,0f8h,18h,18h,18h       ; 181 ""
         db        66h,66h,66h,66h,0e6h,66h,66h,66h        ; 182 ""
         db        0,0,0,0,0feh,66h,66h,66h                ; 183 ""
         db        0,0,0f8h,18h,0f8h,18h,18h,18h           ; 184 ""
         db        66h,66h,0e6h,6,0e6h,66h,66h,66h         ; 185 ""
         db        66h,66h,66h,66h,66h,66h,66h,66h         ; 186 ""
         db        0,0,0feh,6,0e6h,66h,66h,66h             ; 187 ""
         db        66h,66h,0e6h,6,0feh,0,0,0               ; 188 ""
         db        66h,66h,66h,66h,0feh,0,0,0              ; 189 ""
         db        18h,18h,0f8h,18h,0f8h,0,0,0             ; 190 ""
         db        0,0,0,0,0f8h,18h,18h,18h                ; 191 ""
         db        18h,18h,18h,18h,1fh,0,0,0               ; 192 ""
         db        18h,18h,18h,18h,0ffh,0,0,0              ; 193 ""
         db        0,0,0,0,0ffh,18h,18h,18h                ; 194 ""
         db        18h,18h,18h,18h,1fh,18h,18h,18h         ; 195 ""
         db        0,0,0,0,0ffh,0,0,0                      ; 196 ""
         db        18h,18h,18h,18h,0ffh,18h,18h,18h        ; 197 ""
         db        18h,18h,1fh,18h,1fh,18h,18h,18h         ; 198 ""
         db        66h,66h,66h,66h,67h,66h,66h,66h         ; 199 ""
         db        66h,66h,67h,60h,7fh,0,0,0               ; 200 ""
         db        0,0,7fh,60h,67h,66h,66h,66h             ; 201 ""
         db        66h,66h,0e7h,0,0ffh,0,0,0               ; 202 ""
         db        0,0,0ffh,0,0e7h,66h,66h,66h             ; 203 ""
         db        66h,66h,67h,60h,67h,66h,66h,66h         ; 204 ""
         db        0,0,0ffh,0,0ffh,0,0,0                   ; 205 ""
         db        66h,66h,0e7h,0,0e7h,66h,66h,66h         ; 206 ""
         db        18h,18h,0ffh,0,0ffh,0,0,0               ; 207 ""
         db        66h,66h,66h,66h,0ffh,0,0,0              ; 208 ""
         db        0,0,0ffh,0,0ffh,18h,18h,18h             ; 209 ""
         db        0,0,0,0,0ffh,66h,66h,66h                ; 210 ""
         db        66h,66h,66h,66h,7fh,0,0,0               ; 211 ""
         db        18h,18h,1fh,18h,1fh,0,0,0               ; 212 ""
         db        0,0,1fh,18h,1fh,18h,18h,18h             ; 213 ""
         db        0,0,0,0,7fh,66h,66h,66h                 ; 214 ""
         db        66h,66h,66h,66h,0ffh,66h,66h,66h        ; 215 ""
         db        18h,18h,0ffh,18h,0ffh,18h,18h,18h       ; 216 ""
         db        18h,18h,18h,18h,0f8h,0,0,0              ; 217 ""
         db        0,0,0,0,1fh,18h,18h,18h                 ; 218 ""
         db        0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,0ffh ; 219 ""
         db        0,0,0,0,0ffh,0ffh,0ffh,0ffh             ; 220 ""
         db        0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h ; 221 ""
         db        0fh,0fh,0fh,0fh,0fh,0fh,0fh,0fh         ; 222 ""
         db        0ffh,0ffh,0ffh,0ffh,0,0,0,0             ; 223 ""
         db        0,0,76h,0dch,0cch,0dch,76h,0            ; 224 ""
         db        3ch,66h,7ch,66h,66h,7ch,60h,60h         ; 225 ""
         db        7eh,66h,60h,60h,60h,60h,60h,0           ; 226 ""
         db        0,0,0feh,6ch,6ch,6ch,66h,0              ; 227 ""
         db        0feh,0c6h,60h,30h,60h,0c6h,0feh,0       ; 228 ""
         db        0,0,0,7eh,0d8h,0d8h,70h,0               ; 229 ""
         db        0,0,66h,66h,66h,7ch,60h,0c0h            ; 230 ""
         db        0,0,7eh,18h,18h,18h,0ch,0               ; 231 ""
         db        7eh,18h,3ch,66h,66h,3ch,18h,7eh         ; 232 ""
         db        38h,6ch,0c6h,0feh,0c6h,6ch,38h,0        ; 233 ""
         db        7ch,0c6h,0c6h,0c6h,0c6h,6ch,0eeh,0      ; 234 ""
         db        3ch,66h,30h,7ch,0c6h,0c6h,7ch,0         ; 235 ""
         db        0,0,66h,0dbh,0dbh,0dbh,66h,0            ; 236 ""
         db        3h,6,3ch,66h,66h,3ch,60h,0c0h           ; 237 ""
         db        1eh,30h,60h,7eh,60h,30h,1eh,0           ; 238 ""
         db        3ch,66h,66h,66h,66h,66h,66h,0           ; 239 ""
         db        0,7eh,0,7eh,0,7eh,0,0                   ; 240 ""
         db        18h,18h,7eh,18h,18h,0,7eh,0             ; 241 ""
         db        30h,18h,0ch,18h,30h,0,7eh,0             ; 242 ""
         db        0ch,18h,30h,18h,0ch,0,7eh,0             ; 243 ""
         db        0eh,1bh,18h,18h,18h,18h,18h,18h         ; 244 ""
         db        18h,18h,18h,18h,18h,18h,0d8h,70h        ; 245 ""
         db        0,18h,0,7eh,0,18h,0,0                   ; 246 ""
         db        0,72h,9ch,0,72h,9ch,0,0                 ; 247 ""
         db        0,3ch,66h,66h,3ch,0,0,0                 ; 248 ""
         db        0,0,0,18h,18h,0,0,0                     ; 249 ""
         db        0,0,0,0,18h,0,0,0                       ; 250 ""
         db        7h,7,0ch,0ch,98h,0d8h,70h,30h           ; 251 ""
         db        78h,6ch,6ch,6ch,6ch,0,0,0               ; 252 ""
         db        38h,6ch,18h,30h,7ch,0,0,0               ; 253 ""
         db        0,0,78h,78h,78h,78h,0,0                 ; 254 ""
         db        0,0,0,0,0,0,0,0                         ; 255

                                            ; fonty 14x8 bod

fnt14x8  db        0,0,0,0,0,0,0                           ; 0
         db        0,0,0,0,0,0,0                      
         db        0,0,7eh,81h,0a5h,81h,81h                ; 1
         db        0bdh,99h,81h,7eh,0,0,0             
         db        0,0,7eh,0ffh,0dbh,0ffh,0ffh             ; 2
         db        0c3h,0e7h,0ffh,7eh,0,0,0           
         db        0,0,0,6ch,0feh,0feh,0feh                ; 3
         db        0feh,7ch,38h,10h,0,0,0             
         db        0,0,0,10h,38h,7ch,0feh                  ; 4
         db        7ch,38h,10h,0,0,0,0                
         db        0,0,18h,3ch,3ch,0e7h,0e7h               ; 5
         db        0e7h,18h,18h,3ch,0,0,0             
         db        0,0,18h,3ch,7eh,0ffh,0ffh               ; 6
         db        7eh,18h,18h,3ch,0,0,0              
         db        0,0,0,0,0,18h,3ch                       ; 7
         db        3ch,18h,0,0,0,0,0                  
         db        0ffh,0ffh,0ffh,0ffh,0ffh,0e7h,0c3h      ; 8
         db        0c3h,0e7h,0ffh,0ffh,0ffh,0ffh,0ffh 
         db        0,0,0,0,3ch,66h,42h                     ; 9
         db        42h,66h,3ch,0,0,0,0                
         db        0ffh,0ffh,0ffh,0ffh,0c3h,99h,0bdh       ; 10
         db        0bdh,99h,0c3h,0ffh,0ffh,0ffh,0ffh  
         db        0,0,1eh,0eh,1ah,32h,78h                 ; 11
         db        0cch,0cch,0cch,78h,0,0,0           
         db        0,0,3ch,66h,66h,66h,3ch                 ; 12
         db        18h,7eh,18h,18h,0,0,0              
         db        0,0,3fh,33h,3fh,30h,30h                 ; 13
         db        30h,70h,0f0h,0e0h,0,0,0            
         db        0,0,7fh,63h,7fh,63h,63h                 ; 14
         db        63h,67h,0e7h,0e6h,0c0h,0,0         
         db        0,0,18h,18h,0dbh,3ch,0e7h               ; 15
         db        3ch,0dbh,18h,18h,0,0,0             
         db        0,0,80h,0c0h,0e0h,0f8h,0feh             ; 16
         db        0f8h,0e0h,0c0h,80h,0,0,0           
         db        0,0,2,6,0eh,3eh,0feh                    ; 17
         db        3eh,0eh,6,2,0,0,0                  
         db        0,0,18h,3ch,7eh,18h,18h                 ; 18
         db        18h,7eh,3ch,18h,0,0,0              
         db        0,0,66h,66h,66h,66h,66h                 ; 19
         db        66h,0,66h,66h,0,0,0                
         db        0,0,7fh,0dbh,0dbh,0dbh,7bh              ; 20
         db        1bh,1bh,1bh,1bh,0,0,0              
         db        0,7ch,0c6h,60h,38h,6ch,0c6h             ; 21  " "
         db        0c6h,6ch,38h,0ch,0c6h,7ch,0        
         db        0,0,0,0,0,0,0                           ; 22
         db        0,0feh,0feh,0feh,0,0,0             
         db        0,0,18h,3ch,7eh,18h,18h                 ; 23
         db        18h,7eh,3ch,18h,7eh,0,0            
         db        0,0,18h,3ch,7eh,18h,18h                 ; 24
         db        18h,18h,18h,18h,0,0,0              
         db        0,0,18h,18h,18h,18h,18h                 ; 25
         db        18h,7eh,3ch,18h,0,0,0              
         db        0,0,0,0,18h,0ch,0feh                    ; 26
         db        0ch,18h,0,0,0,0,0                  
         db        0,0,0,0,30h,60h                         ; 27
         db        0feh,60h,30h,0,0,0,0,0             
         db        0,0,0,0,0,0c0h,0c0h                     ; 28
         db        0c0h,0feh,0,0,0,0,0                
         db        0,0,0,0,28h,6ch,0feh                    ; 29
         db        6ch,28h,0,0,0,0,0                  
         db        0,0,0,10h,38h,38h,7ch                   ; 30
         db        7ch,0feh,0feh,0,0,0,0              
         db        0,0,0,0feh,0feh,7ch,7ch                 ; 31
         db        38h,38h,10h,0,0,0,0                
         db        0,0,0,0,0,0,0                           ; 32  " "
         db        0,0,0,0,0,0,0                      
         db        0,0,18h,3ch,3ch,3ch,18h                 ; 33  "!"
         db        18h,0,18h,18h,0,0,0                
         db        0,66h,66h,66h,24h,0,0                   ; 34  "
         db        0,0,0,0,0,0,0                      
         db        0,0,6ch,6ch,0feh,6ch,6ch                ; 35  "#"
         db        6ch,0feh,6ch,6ch,0,0,0             
         db        18h,18h,7ch,0c6h,0c2h,0c0h,7ch          ; 36  "$"
         db        6,86h,0c6h,7ch,18h,18h,0           
         db        0,0,0,0,0c2h,0c6h,0ch                   ; 37  "%"
         db        18h,30h,66h,0c6h,0,0,0             
         db        0,0,38h,6ch,6ch,38h,76h                 ; 38  "&"
         db        0dch,0cch,0cch,76h,0,0,0           
         db        0,30h,30h,30h,60h,0,0                   ; 39  "'"
         db        0,0,0,0,0,0,0                      
         db        0,0,0ch,18h,30h,30h,30h                 ; 40  "("
         db        30h,30h,18h,0ch,0,0,0              
         db        0,0,30h,18h,0ch,0ch,0ch                 ; 41  ")"
         db        0ch,0ch,18h,30h,0,0,0              
         db        0,0,0,0,66h,3ch,0ffh                    ; 42  "*"
         db        3ch,66h,0,0,0,0,0                  
         db        0,0,0,0,18h,18h,7eh                     ; 43  "+"
         db        18h,18h,0,0,0,0,0                  
         db        0,0,0,0,0,0,0                           ; 44  ","
         db        0,18h,18h,18h,30h,0,0              
         db        0,0,0,0,0,0                             ; 45  "-"
         db        0feh,0,0,0,0,0,0,0                 
         db        0,0,0,0,0,0,0                           ; 46  "."
         db        0,0,18h,18h,0,0,0                  
         db        0,0,2,6,0ch,18h,30h                     ; 47  "/"
         db        60h,0c0h,80h,0,0,0,0               
         db        0,0,7ch,0c6h,0ceh,0deh,0f6h             ; 48  "0"
         db        0e6h,0c6h,0c6h,7ch,0,0,0           
         db        0,0,18h,38h,78h,18h,18h                 ; 49  "1"
         db        18h,18h,18h,7eh,0,0,0              
         db        0,0,7ch,0c6h,6,0ch,18h                  ; 50  "2"
         db        30h,60h,0c6h,0feh,0,0,0            
         db        0,0,7ch,0c6h,6,6,3ch                    ; 51  "3"
         db        6,6,0c6h,7ch,0,0,0                 
         db        0,0,0ch,1ch,3ch,6ch,0cch                ; 52  "4"
         db        0feh,0ch,0ch,1eh,0,0,0             
         db        0,0,0feh,0c0h,0c0h,0c0h,0fch            ; 53  "5"
         db        6,6,0c6h,7ch,0,0,0                 
         db        0,0,38h,60h,0c0h,0c0h,0fch              ; 54  "6"
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0,0,0feh,0c6h,6,0ch,18h                 ; 55  "7"
         db        30h,30h,30h,30h,0,0,0              
         db        0,0,7ch,0c6h,0c6h,0c6h,7ch              ; 56  "8"
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0,0,7ch,0c6h,0c6h,0c6h,7eh              ; 57  "9"
         db        6,6,0ch,78h,0,0,0                  
         db        0,0,0,18h,18h,0,0                       ; 58  ":"
         db        0,18h,18h,0,0,0,0                  
         db        0,0,0,18h,18h,0,0                       ; 59  ";"
         db        0,18h,18h,30h,0,0,0                
         db        0,0,6,0ch,18h,30h,60h                   ; 60  "<"
         db        30h,18h,0ch,6,0,0,0                
         db        0,0,0,0,0,7eh,0                         ; 61  "="
         db        0,7eh,0,0,0,0,0                    
         db        0,0,60h,30h,18h,0ch,6                   ; 62  ">"
         db        0ch,18h,30h,60h,0,0,0              
         db        0,0,7ch,0c6h,0c6h,0ch,18h               ; 63  "?"
         db        18h,0,18h,18h,0,0,0                
         db        0,0,7ch,0c6h,0c6h,0deh,0deh             ; 64  "@"
         db        0deh,0dch,0c0h,7ch,0,0,0           
         db        0,0,10h,38h,6ch,0c6h,0c6h               ; 65  "A"
         db        0feh,0c6h,0c6h,0c6h,0,0,0          
         db        0,0,0fch,66h,66h,66h,7ch                ; 66  "B"
         db        66h,66h,66h,0fch,0,0,0             
         db        0,0,3ch,66h,0c2h,0c0h,0c0h              ; 67  "C"
         db        0c0h,0c2h,66h,3ch,0,0,0            
         db        0,0,0f8h,6ch,66h,66h,66h                ; 68  "D"
         db        66h,66h,6ch,0f8h,0,0,0             
         db        0,0,0feh,66h,62h,68h,78h                ; 69  "E"
         db        68h,62h,66h,0feh,0,0,0             
         db        0,0,0feh,66h,62h,68h,78h                ; 70  "F"
         db        68h,60h,60h,0f0h,0,0,0             
         db        0,0,3ch,66h,0c2h,0c0h,0c0h              ; 71  "G"
         db        0deh,0c6h,66h,3ah,0,0,0            
         db        0,0,0c6h,0c6h,0c6h,0c6h,0feh            ; 72  "H"
         db        0c6h,0c6h,0c6h,0c6h,0,0,0          
         db        0,0,3ch,18h,18h,18h,18h                 ; 73  "I"
         db        18h,18h,18h,3ch,0,0,0              
         db        0,0,1eh,0ch,0ch,0ch,0ch                 ; 74  "J"
         db        0ch,0cch,0cch,78h,0,0,0            
         db        0,0,0e6h,66h,6ch,6ch,78h                ; 75  "K"
         db        6ch,6ch,66h,0e6h,0,0,0             
         db        0,0,0f0h,60h,60h,60h,60h                ; 76  "L"
         db        60h,62h,66h,0feh,0,0,0             
         db        0,0,0c6h,0eeh,0feh,0feh,0d6h            ; 77  "M"
         db        0c6h,0c6h,0c6h,0c6h,0,0,0          
         db        0,0,0c6h,0e6h,0f6h,0feh,0deh            ; 78  "N"
         db        0ceh,0c6h,0c6h,0c6h,0,0,0          
         db        0,0,38h,6ch,0c6h,0c6h,0c6h              ; 79  "O"
         db        0c6h,0c6h,6ch,38h,0,0,0            
         db        0,0,0fch,66h,66h,66h,7ch                ; 80  "P"
         db        60h,60h,60h,0f0h,0,0,0             
         db        0,0,7ch,0c6h,0c6h,0c6h,0c6h             ; 81  "Q"
         db        0d6h,0deh,7ch,0ch,0eh,0,0          
         db        0,0,0fch,66h,66h,66h,7ch                ; 82  "R"
         db        6ch,66h,66h,0e6h,0,0,0             
         db        0,0,7ch,0c6h,0c6h,60h,38h               ; 83  "S"
         db        0ch,0c6h,0c6h,7ch,0,0,0            
         db        0,0,7eh,7eh,5ah,18h,18h                 ; 84  "T"
         db        18h,18h,18h,3ch,0,0,0              
         db        0,0,0c6h,0c6h,0c6h,0c6h,0c6h            ; 85  "U"
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0,0,0c6h,0c6h,0c6h,0c6h,0c6h            ; 86  "V"
         db        0c6h,6ch,38h,10h,0,0,0             
         db        0,0,0c6h,0c6h,0c6h,0c6h,0d6h            ; 87  "W"
         db        0d6h,0feh,7ch,6ch,0,0,0            
         db        0,0,0c6h,0c6h,6ch,38h,38h               ; 88  "X"
         db        38h,6ch,0c6h,0c6h,0,0,0            
         db        0,0,66h,66h,66h,66h,3ch                 ; 89  "Y"
         db        18h,18h,18h,3ch,0,0,0              
         db        0,0,0feh,0c6h,8ch,18h,30h               ; 90  "Z"
         db        60h,0c2h,0c6h,0feh,0,0,0           
         db        0,0,3ch,30h,30h,30h,30h                 ; 91  "["
         db        30h,30h,30h,3ch,0,0,0              
         db        0,0,80h,0c0h,0e0h,70h,38h               ; 92  "\"
         db        1ch,0eh,6,2,0,0,0                  
         db        0,0,3ch,0ch,0ch,0ch,0ch                 ; 93  "]"
         db        0ch,0ch,0ch,3ch,0,0,0              
         db        10h,38h,6ch,0c6h,0,0,0                  ; 94  "^"
         db        0,0,0,0,0,0,0                      
         db        0,0,0,0,0,0,0                           ; 95  "_"
         db        0,0,0,0,0,0ffh,0                   
         db        30h,30h,18h,0,0,0,0                     ; 96  "`"
         db        0,0,0,0,0,0,0                      
         db        0,0,0,0,0,78h,0ch                       ; 97  "a"
         db        7ch,0cch,0cch,76h,0,0,0            
         db        0,0,0e0h,60h,60h,78h,6ch                ; 98  "b"
         db        66h,66h,66h,7ch,0,0,0              
         db        0,0,0,0,0,7ch,0c6h                      ; 99  "c"
         db        0c0h,0c0h,0c6h,7ch,0,0,0           
         db        0,0,1ch,0ch,0ch,3ch,6ch                 ; 100 "d"
         db        0cch,0cch,0cch,76h,0,0,0           
         db        0,0,0,0,0,7ch,0c6h                      ; 101 "e"
         db        0feh,0c0h,0c6h,7ch,0,0,0           
         db        0,0,38h,6ch,64h,60h,0f0h                ; 102 "f"
         db        60h,60h,60h,0f0h,0,0,0             
         db        0,0,0,0,0,76h,0cch                      ; 103 "g"
         db        0cch,0cch,7ch,0ch,0cch,78h,0       
         db        0,0,0e0h,60h,60h,6ch,76h                ; 104 "h"
         db        66h,66h,66h,0e6h,0,0,0             
         db        0,0,18h,18h,0,38h,18h                   ; 105 "i"
         db        18h,18h,18h,3ch,0,0,0              
         db        0,0,6,6,0,0eh,6                         ; 106 "j"
         db        6,6,6,66h,66h,3ch,0                
         db        0,0,0e0h,60h,60h,66h,6ch                ; 107 "k"
         db        78h,6ch,66h,0e6h,0,0,0             
         db        0,0,38h,18h,18h,18h,18h                 ; 108 "l"
         db        18h,18h,18h,3ch,0,0,0              
         db        0,0,0,0,0,0ech,0feh                     ; 109 "m"
         db        0d6h,0d6h,0d6h,0c6h,0,0,0          
         db        0,0,0,0,0,0dch,66h                      ; 110 "n"
         db        66h,66h,66h,66h,0,0,0              
         db        0,0,0,0,0,7ch,0c6h                      ; 111 "o"
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0,0,0,0,0,0dch,66h                      ; 112 "p"
         db        66h,66h,7ch,60h,60h,0f0h,0         
         db        0,0,0,0,0,76h,0cch                      ; 113 "q"
         db        0cch,0cch,7ch,0ch,0ch,1eh,0        
         db        0,0,0,0,0,0dch,76h                      ; 114 "r"
         db        66h,60h,60h,0f0h,0,0,0             
         db        0,0,0,0,0,7ch,0c6h                      ; 115 "s"
         db        70h,1ch,0c6h,7ch,0,0,0             
         db        0,0,10h,30h,30h,0fch,30h                ; 116 "t"
         db        30h,30h,36h,1ch,0,0,0              
         db        0,0,0,0,0,0cch,0cch                     ; 117 "u"
         db        0cch,0cch,0cch,76h,0,0,0           
         db        0,0,0,0,0,66h,66h                       ; 118 "v"
         db        66h,66h,3ch,18h,0,0,0              
         db        0,0,0,0,0,0c6h,0c6h                     ; 119 "w"
         db        0d6h,0d6h,0feh,6ch,0,0,0           
         db        0,0,0,0,0,0c6h,6ch                      ; 120 "x"
         db        38h,38h,6ch,0c6h,0,0,0             
         db        0,0,0,0,0,0c6h,0c6h                     ; 121 "y"
         db        0c6h,0c6h,7eh,6,0ch,0f8h,0         
         db        0,0,0,0,0,0feh,0cch                     ; 122 "z"
         db        18h,30h,66h,0feh,0,0,0             
         db        0,0,0eh,18h,18h,18h,70h                 ; 123 "{"
         db        18h,18h,18h,0eh,0,0,0              
         db        0,0,18h,18h,18h,18h,0                   ; 124 "|"
         db        18h,18h,18h,18h,0,0,0              
         db        0,0,70h,18h,18h,18h,0eh                 ; 125 "}"
         db        18h,18h,18h,70h,0,0,0              
         db        0,0,76h,0dch,0,0,0                      ; 126 "~"
         db        0,0,0,0,0,0,0                      
         db        0,0,0,0,10h,38h,6ch                     ; 127 ""
         db        0c6h,0c6h,0feh,0,0,0,0             
         db        66h,3ch,3ch,66h,0c2h,0c0h,0c0h          ; 128 ""
         db        0c0h,0c2h,66h,3ch,0,0,0            
         db        0,0,0cch,0cch,0,0cch,0cch               ; 129 ""
         db        0cch,0cch,0cch,76h,0,0,0           
         db        0,0ch,18h,30h,0,7ch,0c6h                ; 130 ""
         db        0feh,0c0h,0c6h,7ch,0,0,0           
         db        68h,30h,1ch,0ch,0ch,3ch,6ch             ; 131 ""
         db        0cch,0cch,0cch,7eh,0,0,0           
         db        0,0,0cch,0cch,0,78h,0ch                 ; 132 ""
         db        7ch,0cch,0cch,76h,0,0,0            
         db        0cch,78h,0f8h,6ch,66h,66h,66h           ; 133 ""
         db        66h,66h,6ch,0f8h,0,0,0             
         db        66h,3ch,7eh,7eh,5ah,18h,18h             ; 134 ""
         db        18h,18h,18h,3ch,0,0,0              
         db        0,0,66h,3ch,0,7ch,0c6h                  ; 135 ""
         db        0c0h,0c0h,0c6h,7ch,0,0,0           
         db        0,0,66h,3ch,0,7ch,0c6h                  ; 136 ""
         db        0feh,0c0h,0c6h,7ch,0,0,0           
         db        66h,3ch,0feh,66h,62h,68h,78h            ; 137 ""
         db        68h,62h,66h,0feh,0,0,0             
         db        0,6,0f6h,64h,60h,60h,60h                ; 138 ""
         db        60h,62h,66h,0feh,0,0,0             
         db        0ch,18h,3ch,18h,18h,18h,18h             ; 139 ""
         db        18h,18h,18h,3ch,0,0,0              
         db        36h,1ch,70h,30h,30h,30h,30h             ; 140 ""
         db        30h,30h,30h,78h,0,0,0              
         db        6h,6,74h,30h,30h,30h,30h                ; 141 ""
         db        30h,30h,30h,78h,0,0,0              
         db        0,0c6h,0c6h,10h,38h,6ch,0c6h            ; 142 ""
         db        0c6h,0feh,0c6h,0c6h,0,0,0          
         db        6h,0ch,10h,38h,6ch,0c6h,0c6h            ; 143 ""
         db        0feh,0c6h,0c6h,0c6h,0,0,0          
         db        18h,30h,60h,0,0feh,66h,60h              ; 144 ""
         db        7ch,60h,66h,0feh,0,0,0             
         db        0,0,0cch,78h,0,0feh,0cch                ; 145 ""
         db        18h,30h,66h,0feh,0,0,0             
         db        66h,3ch,0feh,0c6h,8ch,18h,30h           ; 146 ""
         db        60h,0c2h,0c6h,0feh,0,0,0           
         db        0,10h,38h,6ch,0,7ch,0c6h                ; 147 ""
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0,0,0c6h,0c6h,0,7ch,0c6h                ; 148 ""
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0ch,18h,38h,6ch,0c6h,0c6h,0c6h          ; 149 ""
         db        0c6h,0c6h,6ch,38h,0,0,0            
         db        0,38h,6ch,38h,0,0cch,0cch               ; 150 ""
         db        0cch,0cch,0cch,76h,0,0,0           
         db        0ch,18h,0c6h,0c6h,0c6h,0c6h,0c6h        ; 151 ""
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0,0,0ch,18h,0,0c6h,0c6h                 ; 152 ""
         db        0c6h,0c6h,7eh,6,0ch,0f8h,0         
         db        0,0c6h,0c6h,38h,6ch,0c6h,0c6h           ; 153 ""
         db        0c6h,0c6h,6ch,38h,0,0,0            
         db        0,0c6h,0c6h,0,0c6h,0c6h,0c6h            ; 154 ""
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        66h,3ch,7ch,0c6h,0c6h,60h,38h           ; 155 ""
         db        0ch,0c6h,0c6h,7ch,0,0,0            
         db        36h,1ch,0f0h,60h,60h,60h,60h            ; 156 ""
         db        60h,62h,66h,0feh,0,0,0             
         db        6h,0ch,66h,66h,66h,66h,3ch              ; 157 ""
         db        18h,18h,18h,3ch,0,0,0              
         db        66h,3ch,0fch,66h,66h,66h,7ch            ; 158 ""
         db        6ch,66h,66h,0f6h,0,0,0             
         db        36h,1ch,10h,30h,30h,0fch,30h            ; 159 ""
         db        30h,30h,36h,1ch,0,0,0              
         db        0,18h,30h,60h,0,78h,0ch                 ; 160 ""
         db        7ch,0cch,0cch,76h,0,0,0            
         db        0,0ch,18h,30h,0,38h,18h                 ; 161 ""
         db        18h,18h,18h,3ch,0,0,0              
         db        0,18h,30h,60h,0,7ch,0c6h                ; 162 ""
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        0,18h,30h,60h,0,0cch,0cch               ; 163 ""
         db        0cch,0cch,0cch,76h,0,0,0           
         db        0,0,66h,3ch,0,0dch,66h                  ; 164 ""
         db        66h,66h,66h,66h,0,0,0              
         db        66h,3ch,0c6h,0e6h,0f6h,0feh,0deh        ; 165 ""
         db        0ceh,0c6h,0c6h,0c6h,0,0,0          
         db        3ch,66h,3ch,0c6h,0c6h,0c6h,0c6h         ; 166 ""
         db        0c6h,0c6h,0c6h,7ch,0,0,0           
         db        7ch,0c6h,38h,6ch,0c6h,0c6h,0c6h         ; 167 ""
         db        0c6h,0c6h,6ch,38h,0,0,0            
         db        0,0,66h,3ch,0,7ch,0c6h                  ; 168 ""
         db        70h,1ch,0c6h,7ch,0,0,0             
         db        0,0,0cch,78h,0,0dch,76h                 ; 169 ""
         db        66h,60h,60h,0f0h,0,0,0             
         db        0,0,0ch,18h,0,0dch,76h                  ; 170 ""
         db        66h,60h,60h,0f0h,0,0,0             
         db        0ch,18h,0fch,66h,66h,66h,7ch            ; 171 ""
         db        6ch,66h,66h,0e6h,0,0,0             
         db        0,0c0h,0c0h,0c6h,0cch,0d8h,30h          ; 172 ""
         db        66h,0ceh,9eh,3eh,6,6,0             
         db        0,0,7ch,0c6h,60h,38h,6ch                ; 173 ""
         db        0c6h,6ch,38h,0ch,0c6h,7ch,0        
         db        0,0,0,0,36h,6ch,0d8h                    ; 174 ""
         db        6ch,36h,0,0,0,0,0                  
         db        0,0,0,0,0d8h,6ch,36h                    ; 175 ""
         db        6ch,0d8h,0,0,0,0,0                 
         db        11h,44h,11h,44h,11h,44h,11h             ; 176 ""
         db        44h,11h,44h,11h,44h,11h,44h        
         db        55h,0aah,55h,0aah,55h,0aah,55h          ; 177 ""
         db        0aah,55h,0aah,55h,0aah,55h,0aah    
         db        0ddh,77h,0ddh,77h,0ddh,77h,0ddh         ; 178 ""
         db        77h,0ddh,77h,0ddh,77h,0ddh,77h     
         db        18h,18h,18h,18h,18h,18h,18h             ; 179 ""
         db        18h,18h,18h,18h,18h,18h,18h        
         db        18h,18h,18h,18h,18h,18h,18h             ; 180 ""
         db        0f8h,18h,18h,18h,18h,18h,18h       
         db        18h,18h,18h,18h,18h,0f8h,18h            ; 181 ""
         db        0f8h,18h,18h,18h,18h,18h,18h       
         db        36h,36h,36h,36h,36h,36h,36h             ; 182 ""
         db        0f6h,36h,36h,36h,36h,36h,36h       
         db        0,0,0,0,0,0,0                           ; 183 ""
         db        0feh,36h,36h,36h,36h,36h,36h       
         db        0,0,0,0,0,0f8h,18h                      ; 184 ""
         db        0f8h,18h,18h,18h,18h,18h,18h       
         db        36h,36h,36h,36h,36h,0f6h,6              ; 185 ""
         db        0f6h,36h,36h,36h,36h,36h,36h       
         db        36h,36h,36h,36h,36h,36h,36h             ; 186 ""
         db        36h,36h,36h,36h,36h,36h,36h        
         db        0,0,0,0,0,0feh,6                        ; 187 ""
         db        0f6h,36h,36h,36h,36h,36h,36h       
         db        36h,36h,36h,36h,36h,0f6h,6              ; 188 ""
         db        0feh,0,0,0,0,0,0                   
         db        36h,36h,36h,36h,36h,36h,36h             ; 189 ""
         db        0feh,0,0,0,0,0,0                   
         db        18h,18h,18h,18h,18h,0f8h,18h            ; 190 ""
         db        0f8h,0,0,0,0,0,0                   
         db        0,0,0,0,0,0,0                           ; 191 ""
         db        0f8h,18h,18h,18h,18h,18h,18h       
         db        18h,18h,18h,18h,18h,18h,18h             ; 192 ""
         db        1fh,0,0,0,0,0,0                    
         db        18h,18h,18h,18h,18h,18h,18h             ; 193 ""
         db        0ffh,0,0,0,0,0,0                   
         db        0,0,0,0,0,0,0                           ; 194 ""
         db        0ffh,18h,18h,18h,18h,18h,18h       
         db        18h,18h,18h,18h,18h,18h,18h             ; 195 ""
         db        1fh,18h,18h,18h,18h,18h,18h        
         db        0,0,0,0,0,0,0                           ; 196 ""
         db        0ffh,0,0,0,0,0,0                   
         db        18h,18h,18h,18h,18h,18h,18h             ; 197 ""
         db        0ffh,18h,18h,18h,18h,18h,18h       
         db        18h,18h,18h,18h,18h,1fh,18h             ; 198 ""
         db        1fh,18h,18h,18h,18h,18h,18h        
         db        36h,36h,36h,36h,36h,36h,36h             ; 199 ""
         db        37h,36h,36h,36h,36h,36h,36h        
         db        36h,36h,36h,36h,36h,37h,30h             ; 200 ""
         db        3fh,0,0,0,0,0,0                    
         db        0,0,0,0,0,3fh,30h                       ; 201 ""
         db        37h,36h,36h,36h,36h,36h,36h        
         db        36h,36h,36h,36h,36h,0f7h,0              ; 202 ""
         db        0ffh,0,0,0,0,0,0                   
         db        0,0,0,0,0,0ffh,0                        ; 203 ""
         db        0f7h,36h,36h,36h,36h,36h,36h       
         db        36h,36h,36h,36h,36h,37h,30h             ; 204 ""
         db        37h,36h,36h,36h,36h,36h,36h        
         db        0,0,0,0,0,0ffh,0                        ; 205 ""
         db        0ffh,0,0,0,0,0,0                   
         db        36h,36h,36h,36h,36h,0f7h,0              ; 206 ""
         db        0f7h,36h,36h,36h,36h,36h,36h       
         db        18h,18h,18h,18h,18h,0ffh,0              ; 207 ""
         db        0ffh,0,0,0,0,0,0                   
         db        36h,36h,36h,36h,36h,36h,36h             ; 208 ""
         db        0ffh,0,0,0,0,0,0                   
         db        0,0,0,0,0,0ffh,0                        ; 209 ""
         db        0ffh,18h,18h,18h,18h,18h,18h       
         db        0,0,0,0,0,0,0                           ; 210 ""
         db        0ffh,36h,36h,36h,36h,36h,36h       
         db        36h,36h,36h,36h,36h,36h,36h             ; 211 ""
         db        3fh,0,0,0,0,0,0                    
         db        18h,18h,18h,18h,18h,1fh,18h             ; 212 ""
         db        1fh,0,0,0,0,0,0                    
         db        0,0,0,0,0,1fh,18h                       ; 213 ""
         db        1fh,18h,18h,18h,18h,18h,18h        
         db        0,0,0,0,0,0,0                           ; 214 ""
         db        3fh,36h,36h,36h,36h,36h,36h        
         db        36h,36h,36h,36h,36h,36h,36h             ; 215 ""
         db        0ffh,36h,36h,36h,36h,36h,36h       
         db        18h,18h,18h,18h,18h,0ffh,18h            ; 216 ""
         db        0ffh,18h,18h,18h,18h,18h,18h       
         db        18h,18h,18h,18h,18h,18h,18h             ; 217 ""
         db        0f8h,0,0,0,0,0,0                   
         db        0,0,0,0,0,0,0                           ; 218 ""
         db        1fh,18h,18h,18h,18h,18h,18h        
         db        0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,0ffh      ; 219 ""
         db        0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,0ffh 
         db        0,0,0,0,0,0,0                           ; 220 ""
         db        0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,0ffh 
         db        0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h      ; 221 ""
         db        0f0h,0f0h,0f0h,0f0h,0f0h,0f0h,0f0h 
         db        0fh,0fh,0fh,0fh,0fh,0fh,0fh             ; 222 ""
         db        0fh,0fh,0fh,0fh,0fh,0fh,0fh        
         db        0ffh,0ffh,0ffh,0ffh,0ffh,0ffh,0ffh      ; 223 ""
         db        0,0,0,0,0,0,0                      
         db        0,0,0,0,0,76h,0dch                      ; 224 ""
         db        0d8h,0d8h,0dch,76h,0,0,0           
         db        0,0,0,0,7ch,0c6h,0fch                   ; 225 ""
         db        0c6h,0c6h,0fch,0c0h,0c0h,40h,0     
         db        0,0,0feh,0c6h,0c6h,0c0h,0c0h            ; 226 ""
         db        0c0h,0c0h,0c0h,0c0h,0,0,0          
         db        0,0,0,0,0feh,6ch,6ch                    ; 227 ""
         db        6ch,6ch,6ch,6ch,0,0,0              
         db        0,0,0feh,0c6h,60h,30h,18h               ; 228 ""
         db        30h,60h,0c6h,0feh,0,0,0            
         db        0,0,0,0,0,7eh,0d8h                      ; 229 ""
         db        0d8h,0d8h,0d8h,70h,0,0,0           
         db        0,0,0,0,66h,66h,66h                     ; 230 ""
         db        66h,7ch,60h,60h,0c0h,0,0           
         db        0,0,0,0,76h,0dch,18h                    ; 231 ""
         db        18h,18h,18h,18h,0,0,0              
         db        0,0,7eh,18h,3ch,66h,66h                 ; 232 ""
         db        66h,3ch,18h,7eh,0,0,0              
         db        0,0,38h,6ch,0c6h,0c6h,0feh              ; 233 ""
         db        0c6h,0c6h,6ch,38h,0,0,0            
         db        0,0,38h,6ch,0c6h,0c6h,0c6h              ; 234 ""
         db        6ch,6ch,6ch,0eeh,0,0,0             
         db        0,0,1eh,30h,18h,0ch,3eh                 ; 235 ""
         db        66h,66h,66h,3ch,0,0,0              
         db        0,0,0,0,0,7eh,0dbh                      ; 236 ""
         db        0dbh,7eh,0,0,0,0,0                 
         db        0,0,3,6,7eh,0dbh,0dbh                   ; 237 ""
         db        0f3h,7eh,60h,0c0h,0,0,0            
         db        0,0,1ch,30h,60h,60h,7ch                 ; 238 ""
         db        60h,60h,30h,1ch,0,0,0              
         db        0,0,0,7ch,0c6h,0c6h,0c6h                ; 239 ""
         db        0c6h,0c6h,0c6h,0c6h,0,0,0          
         db        0,0,0,0feh,0,0,0feh                     ; 240 ""
         db        0,0,0feh,0,0,0,0                   
         db        0,0,0,18h,18h,7eh,18h                   ; 241 ""
         db        18h,0,0,0ffh,0,0,0                 
         db        0,0,30h,18h,0ch,6,0ch                   ; 242 ""
         db        18h,30h,0,7eh,0,0,0                
         db        0,0,0ch,18h,30h,60h,30h                 ; 243 ""
         db        18h,0ch,0,7eh,0,0,0                
         db        0,0,0eh,1bh,1bh,18h,18h                 ; 244 ""
         db        18h,18h,18h,18h,18h,18h,18h        
         db        18h,18h,18h,18h,18h,18h,18h             ; 245 ""
         db        18h,0d8h,0d8h,70h,0,0,0            
         db        0,0,0,18h,18h,0,7eh                     ; 246 ""
         db        0,18h,18h,0,0,0,0                  
         db        0,0,0,0,76h,0dch,0                      ; 247 ""
         db        76h,0dch,0,0,0,0,0                 
         db        0,38h,6ch,6ch,38h,0,0                   ; 248 ""
         db        0,0,0,0,0,0,0                      
         db        0,0,0,0,0,0,18h                         ; 249 ""
         db        18h,0,0,0,0,0,0                    
         db        0,0,0,0,0,0,0                           ; 250 ""
         db        18h,0,0,0,0,0,0                    
         db        0,0fh,0ch,0ch,0ch,0ch,0ch               ; 251 ""
         db        0ech,6ch,3ch,1ch,0,0,0             
         db        0,0d8h,6ch,6ch,6ch,6ch,6ch              ; 252 ""
         db        0,0,0,0,0,0,0                      
         db        0,70h,0d8h,30h,60h,0c8h,0f8h            ; 253 ""
         db        0,0,0,0,0,0,0                      
         db        0,0,0,0,7ch,7ch,7ch                     ; 254 ""
         db        7ch,7ch,7ch,0,0,0,0                
         db        0,0,0,0,0,0,0                           ; 255
         db        0,0,0,0,0,0,0

code     ENDS

         end       start
