;      *****  Textov driver karty ega pro program kontext.com  *****
;              po pekladu od adresy 0 m soubor jmno egatxt.ovl

code     SEGMENT   page
         ASSUME    cs:code,ds:code

start:                                      ; vstup do driveru

displej  proc      far
                                            ; vyvoln podprogramu,
                                            ;  jeho slo je v BX
         push      ds
         mov       dx,cs
         mov       ds,dx                    ; datov segment = program. segment
         shl       bx,1
         call      [bx+adrsub]              ; vyvoln podprogramu podle tabulky
         pop       ds
         ret
displej  endp


tabega   db        0,3,6,0deh,2ah,8,0deh,30h,0eh,0deh,38h
karta    db        'EGA'

invmsk   db        0                        ; maska znak (pro inverzi)
whide    db        0                        ; pznak dvojnsobnho znaku
mode     db        0                        ; reim obrazovky (1,2,3)
vyska    db        0                        ; poet linek na dek

normal   db        0 ;(1*16+11)             ; barva normlnho textu

invert   db        0 ;(11*16+1)             ; barva textu menu

cara     db        0 ;(6*16+11)             ; barva okraje (hnd)
zvyraz   db        0 ;(16+14)               ; zvraznn psmo (lut)
sikme    db        0 ;(16+10)               ; ikm psmo (zelen)
podtrz   db        0 ;(16+13)               ; podtren psmo (fialov)
jine     db        0 ;(16+15)               ; jin kombinace typ (bl)

                                            ; ADRESY PODPROGRAM
adrsub   dw        offset fnc00             ; funkce 00 - vstup znaku
         dw        offset fnc01             ; funkce 01 - kurzor, mazn
         dw        offset fnc02             ; funkce 02 - rolovn nahoru
         dw        offset fnc03             ; funkce 03 - rolovn dol
         dw        offset fnc04             ; funkce 04 - prav okraj (ra)
         dw        offset fnc05             ; funkce 05 - inicializace parametr
         dw        offset fnc06             ; funkce 06 - nastaven text. mdu
         dw        offset fnc07             ; funkce 07 - adr. npovdy (ES:SI)
         dw        offset fnc08             ; funkce 08 - adr. chybovch hlen
         dw        offset fnc09             ; funkce 09 - rozdlovn slov
         dw        offset fnc10             ; funkce 10 - dekdovn kdu klves
         dw        offset fnc11             ; funkce 11 - vpis kdu klvesy



                                            ; FUNKCE 00 - vstup znaku

                                            ; SS:BP = ukazatel parametr znaku
                                            ;   +4 = dek znaku
                                            ;   +6 = pozice znaku na dku
                                            ;   +8 = znak k vstupu
                                            ; AH = md znaku
                                            ;   01 = nadsazen psmo
                                            ;   02 = podsazen psmo
                                            ;   04 = ikm psmo
                                            ;   08 = podtren text
                                            ;   10 = zvraznn psmo
                                            ;   20 = inverzn psmo

fnc00:
         cld
         mov       ch,ah                    ; md znaku
         mov       ax,[bp+4]                ; dek znaku
         mov       bx,80
         mul       bx                       ; offset zatku dku
         mov       bx,[bp+6]                ; pozice znaku na dku
         dec       bx
         cmp       bx,0
         jl        fnc009                   ; je zporn pozice
         cmp       bx,80
         jnc       fnc009                   ; je velk pozice
         add       ax,bx                    ; poet znak od zatku obrazovky
         add       ax,ax                    ; offset znaku ve VRAM
         mov       di,ax
         push      es
         mov       ax,0b800h                ; segment VRAM
         mov       es,ax
         mov       ax,[bp+8]                ; znak k vstupu
         cmp       al,255                   ; je znak dvojnsobn ky ?
         jnz       fnc003                   ; nen
         mov       al,22                    ; znak silnho podtrhovtka
fnc003:  stosb                              ; uloen znaku k vstupu
         mov       al,ds:[invert]           ; inverzn psmo
         test      ch,20h                   ; inverzn psmo ?
         jnz       fnc001                   ; je inverzn psmo
;         cmp       bx,79
;         jnz       fnc002
;         cmp       word ptr [bp+4],0        ; je prvn dek ?
;         jz        fnc001                   ; je prvn dek
fnc002:  mov       al,ds:[zvyraz]           ; zvraznn psmo
         test      ch,10h
         jnz       fnc001                   ; je zvraznn psmo
         mov       al,ds:[sikme]            ; ikm psmo
         test      ch,4
         jnz       fnc001
         mov       al,ds:[podtrz]           ; podtren text
         test      ch,8
         jnz       fnc001
         mov       al,ds:[jine]
         or        ch,ch
         jnz       fnc001                   ; jsou njak atributy
         mov       al,ds:[normal]           ; barva normlnho textu
fnc001:  stosb                              ; nastaven atributu znaku
         pop       es
fnc009:  ret

                                            ; FUNKCE 01 - kurzor a mazn

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = parametr pro zpis okna
                                            ;          = 0 normln okno
                                            ;          = 1 invertovan okno
                                            ;          = 2 kurzor
                                            ;    + 6 = konen dek
                                            ;    + 8 = konen pozice
                                            ;    +10 = poten dek
                                            ;    +12 = poten pozice

fnc01:
         cld
         mov       ax,[bp+10]               ; poten dek okna
         mov       bx,[bp+6]                ; konen dek
         cmp       ax,bx                    ; konen dek
         jbe       fnc01d1
         cmp       byte ptr [bp+4],2
         jnz       fnc01d1
         dec       ax
         mov       bx,ax
fnc01d1: mov       di,ax
         shl       di,1
         shl       di,1
         add       di,ax                    ; DI = AX * 5
         shl       di,1
         shl       di,1
         shl       di,1
         shl       di,1                     ; DI = offset zatku dku
         sub       bx,ax
         inc       bx
         mov       ax,[bp+12]               ; poten pozice
         or        ax,ax
         jg        fnc01a1                  ; je kladn pozice
         mov       ax,1
fnc01a1: mov       cx,[bp+8]                ; konen pozice na dku
         cmp       cx,80
         jng       fnc010r
         mov       cx,80
fnc010r: dec       ax                       ; poten pozice
         sub       cx,ax                    ; ka okna (pozic)
         jng       fnc011                   ; ka okna nen kladn
         add       di,ax                    ; offset zatku okna
         add       di,di                    ; adresa zatku okna ve VRAM
fnc0103: push      es
         mov       ax,0b800h                ; segment VRAM
         mov       es,ax
;         mov       ah,2*16+1               ; zkladn barva textu
         cmp       byte ptr [bp+4],1        ; parametr
         ja        fnc0107                  ; je kurzor
         mov       ah,ds:[normal]           ; je normln text
         jc        fnc010a                  ; je inverzn text
         mov       ah,ds:[invert]           ; inverzn text
;         mov       ah,7
;         mov       cx,20
;         mov       bx,3
fnc010a: mov       al,32
fnc0104: push      di
         push      cx
         rep       stosw
         pop       cx
         pop       di
         add       di,160
         dec       bx
         jnz       fnc0104
         pop       es
         ret

fnc0107:
fnc010:  push      di
         push      cx                       ; ta znak na dek
fnc0102: inc       di
         mov       al,es:[di]               ; nastaven atribut
         not       al
         cmp       [mode],3                 ; reim 16 barev
         jz        fnc0106
         cmp       [mode],2                 ; reim 8 barev
         jz        fnc01e1
         not       al
         ror       al,1
         ror       al,1
         ror       al,1
         ror       al,1
fnc01e1: and       al,7fh
fnc0106: stosb
         dec       cx
         jnz       fnc0102
;         rep       stosw                    ; vymazn dku
         pop       cx
         pop       di
         add       di,160
         dec       bx                       ; ta dk
         jnz       fnc010                   ; dal dek
         pop       es
fnc011:  ret

                                            ; FUNKCE 02 - rolovn okna nahoru

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = konen pozice
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna

fnc02:   ; ret

         mov       ax,[bp+4]                ; konen dek k rolovn
         sub       ax,[bp+8]                ; poten dek k rol.-poet dk
         jz        fnc029                   ; nen dn dek - konec
         mov       bx,ax                    ; poet dk k rolovn
         mov       ax,[bp+8]                ; poten dek k rolovn
         mov       cx,160
         mul       cx                       ; poten adresa pot. dku
         mov       si,ax                    ; poten adresa pot. dku
         mov       di,ax                    ; adresa nsledujcho dku
         add       si,160
         mov       ax,[bp+10]               ; poten pozice okna
         dec       ax
         add       di,ax                    ; poten adresa
         add       di,ax
         add       si,ax
         add       si,ax
         mov       cx,[bp+6]                ; konen pozice
         sub       cx,ax                    ; poet pozic okna k rolovn
         add       cx,cx
         push      es
         push      ds
         mov       ax,0b800h                ; segment displeje
         mov       es,ax
         mov       ds,ax
         cld                                ; penos nahoru
fnc022:  push      si
         push      di
         push      cx
         repnz     movsb
         pop       cx
         pop       di
         pop       si
         add       di,160
         add       si,160
         dec       bx
         jnz       fnc022
         pop       ds
         pop       es
fnc029:  ret






                                            ; FUNKCE 03 - rolovn okna dol

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = konen dek rolovn
                                            ;    + 6 = konen pozice okna
                                            ;    + 8 = poten dek k rol.
                                            ;    +10 = poten pozice okna


fnc03:   ; ret

         mov       ax,[bp+4]                ; konen dek k rolovn
         sub       ax,[bp+8]                ; poten dek k rol.-poet dk
         jz        fnc039                   ; nen dn dek - konec
         mov       bx,ax                    ; poet dk k rolovn
         mov       ax,[bp+4]                ; konen dek k rolovn
         mov       cx,160
         mul       cx                       ; poten adresa konenho dku
         mov       si,ax                    ; poten adresa konenho dku
         mov       di,ax                    ; adresa nsledujcho dku
         add       di,160
         mov       ax,[bp+10]               ; poten pozice okna
         dec       ax
         add       di,ax                    ; poten adresa
         add       di,ax
         add       si,ax
         add       si,ax
         mov       cx,[bp+6]                ; konen pozice
         sub       cx,ax                    ; poet pozic okna k rolovn
         add       cx,cx
         push      es
         push      ds
         mov       ax,0b800h                ; segment displeje
         mov       es,ax
         mov       ds,ax
         cld                                ; penos nahoru
fnc032:  sub       di,160
         sub       si,160
         push      si
         push      di
         push      cx
         repnz     movsb
         pop       cx
         pop       di
         pop       si
         dec       bx
         jnz       fnc032
         pop       ds
         pop       es
fnc039:  ret





                                            ; FUNKCE 04 - prav okraj (ra)

                                            ; SS:BP = ukazatel parametr
                                            ;    + 4 = kd ry
                                            ;    + 6 = konen dek
                                            ;    + 8 = poten dek
                                            ;    +10 = pozice ry

fnc04:
         cld
         mov       si,[bp+10]               ; pozice ry
         dec       si
         jl        fnc042                   ; zporn pozice
         cmp       si,word ptr 79
         ja        fnc042
         mov       ax,[bp+6]                ; konen dek
         mov       di,[bp+8]                ; poten dek
         sub       ax,di
         inc       ax                       ; poet dk
         mov       cx,ax                    ; poet dk
         mov       ax,80
         mul       di
         mov       di,ax
         add       di,si
         add       di,di
         push      es
         mov       ax,0b800h
         mov       es,ax
         mov       dl,ds:[cara]             ; barva okraje
         mov       dh,ds:[normal]           ; barva normlnho textu
fnc041:  mov       al,es:[di+1]
         cmp       al,dl
         mov       al,dl
         jnz       fnc043
         mov       al,dh
fnc043:  mov       es:[di+1],al
         add       di,160
         loop      fnc041
         pop       es
fnc042:  ret


                                            ; FUNKCE 05 - inicializace parametr

                                            ; SS:BP = ukazatel parametr znaku
                                            ;   +4 = barva podkladu
                                            ;   +6 = barva psma
                                            ;   +8 = reim obrazovky (dkovn)

fnc05:
         mov       al,[bp+8]
         mov       [mode],al
         cld
         mov       ax,[bp+4]                ; barva podkladu
         mov       bx,[bp+6]                ; barva psma
         shl       al,1
         shl       al,1
         shl       al,1
         shl       al,1
         and       bl,0fh
         or        al,bl
         cmp       [mode],3                 ; 16 barev
         jz        fnc053
         cmp       [mode],2                 ; 8 barev
         jz        fnc056
         and       al,77h
fnc056:  and       al,7fh
fnc053:  mov       bl,al
         mov       [normal],al              ; nastaven barvy normlnho textu
         ror       al,1
         ror       al,1
         ror       al,1
         ror       al,1
         cmp       [mode],2                 ; displej CGA
         jnz       fnc054
         and       al,7fh
fnc054:  mov       [invert],al
         cmp       [mode],1                 ; displej MONO
         jnz       fnc055
         mov       [zvyraz],al
         mov       [sikme],al
         mov       [podtrz],al
         mov       [jine],al
         jmp       short fnc051
fnc055:  and       bl,0f0h
         mov       al,bl
         or        al,14
         mov       [zvyraz],al              ; zvraznn psmo
         mov       al,bl
         or        al,10
         mov       [sikme],al               ; ikm psmo
         mov       al,bl
         or        al,13
         mov       [podtrz],al              ; podtren psmo
         mov       al,bl
         or        al,15
         mov       [jine],al                ; jin psmo
         and       al,70h
         cmp       al,50h
         mov       al,7
         jnc       fnc051
         mov       al,70h
fnc051:  mov       [cara],al                ; barva ry okraje

         mov       ah,15
         int       10h                      ; poskytnut videomdu
         cmp       al,3
         jz        fnc052                   ; videomd je nastaven
         mov       ax,3
         int       10h                      ; nastaven videomdu
fnc052:  mov       bh,[bp+4]
         cmp       [mode],3                 ; 16 barev
         jz        fnc057
         and       bh,7
fnc057:  mov       ax,1001h
         int       10h                      ; nastaven okol obrazovky
         mov       ax,1003h
         mov       bl,0
         int       10h                      ; nastaven atributu s jasem
         mov       dx,25*256+80
         mov       ah,2
         mov       bh,0
         int       10h                      ; nastaven kurzoru mimo obrazovku
         mov       ax,80
         mov       si,offset karta
         mov       bx,1
         mov       cx,25
         ret


                                            ; FUNKCE 06 - nastaven tex. mdu
fnc06:   mov       ax,3
         int       10h                      ; nastaven textovho mdu 80x25
         ret

                                            ; slovnk 1
slov1    db        'ANA ANI ABE ALTR EINI DEST GEI INI INS '
         db        'NACHT UNIV ZEITEN ZEITU ',0ffh

                                            ; slovnk 2
slov2    db        'AB AN AUF AUS NACH UN VER VOR ',0ffh

                                            ; slovnk 3
slov3    db        'ALT ALP BETT BERG DES EIN ERD ERNST FETT FEST '
         db        'GELD HAUS KREUZ LANG LEIT MACHT MAUS MENSCH NORD '
         db        'NCHST NETZ OBER OST REIT RCK SCHUL SPIEL SD '
         db        'TEST TIEF VOLL WACHS WASCH WEIT WETT WEG WEST ',0ffh

                                            ; slovnk 4
slov4    db        'DURCH LETZTEND SPORT TRANS ',0ffh

                                            ; slovnk 5
slov5    db        'DORT HOCH ZEIT BER ',0ffh

                                            ; slovnk 6
slov6    db        'CHA CURS DAR EMPF ENT HIN HER KOMP MIT SYN ',0ffh

                                            ; slovnk 7
slov7    db        'ABL ABR ALLEIN ANEI ANER ANORD ANS AT BEEH BEEI '
         db        'BEEN BEERD BEIRR BEOB BEUN BEUR ER GE IN KOOR '
         db        'OKT UM UR ZUGABE ',0ffh

                                            ; slovnk 8
slov8    db        'AI AU AY EI EU EY U ',0ffh

                                            ; slovnk 9
slov9    db        'EA E E E II I I I OA OE UE UI UU ',0ffh

                                            ; slovnk 10
slov10   db        'BL BR CH DR FL FR GL GR KL KN KR PFL PH PF '
         db        'PL PR SCHL SCHM SCHN SCHR SCHW STR SPR SCH '
         db        'SP ST TH TR ZW ',0ffh

                                            ; slovnk 11
slov11   db        'BS B CHTS CHS CHT CKT CH CK D FF FS F GS G '
         db        'HRS HL HM HN HR HT H KT K LBST LSCH LCH LFS '
         db        'LKS LTS LB LD LF LG LK LL LP LS LT L '
         db        'MPF MTS MM MP MT M NSCH NGS NDS NST ND NN NF '
         db        'NG NK NS NT NZ N PF PP PT P '
         db        'RSCH RCH RKT RST RB RD RF RG RK RM RN RS RT '
         db        'RZ R SCH ST S TSCH TZT TS TT TZ T XT Z '
         db        ' ',0ffh

                                            ; slovnk 12
slov12   db        'EITS IONS LLGE NSGE UNGS ',0ffh

                                            ; slovnk 13
slov13   db        'HAUS HEIT LICH LADE LAND LER LIG LOS PHA PREIS '
         db        'PUNKT RAND RAUM RECHT RECHN REICH RIG ROUT '
         db        'RUF ',0ffh

                                            ; slovnk 14
slov14   db        'AUS AUF AUGE AUTO AMT ART AB ARZT ARBEIT AKT '
         db        'ALGO ANALY ANDER ANF ANGAB ANGEB ANL ANOR '
         db        'ANSA ANTEIL ANWA ANWEN ANZAHL ANZEIG ANTW '
         db        'APFEL AFRI AMERI ADR APP ARGU EBENE ECK EDITO '
         db        'EIN EFF EURO ELEM ENERG ENTW EIMER ERDA '
         db        'ERGEBN ERFA ERLEB ERFO ERHAL ERKENN ETW EXP '
         db        'INDU INF INH INS IMP OBER ORDN ORDEN OPER ORGA '
         db        'ORIENT ORT UHR UMBRU UNFALL UNTER UMSATZ '
         db        'URLAUB URSACH URTEIL RZT NDER MT FFN '
         db        'KO B ',0ffh

b0aa4    db        0                        ; povolen dlka dku
b0aa5    dw        0                        ; adresa pevodn tabulky znak
w0aa7    dw        0
                                            ; test, zda jde o oddlovac znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je oddlovac znak

tst04:   mov       ah,4
         jmp       short tst401

                                            ; test, zda jde o dc znak
                                            ; vstup:  DS:[BX+DI] = ukaz. textu
                                            ;         ES:[CS:[B0AA5]] pev.tab.
                                            ; vstup: ZF = 0 je dc znak

tst40:   mov       ah,40h
tst401:  mov       al,[bx+di]               ; znak z textu k otestovn
         push      bx
         mov       bx,cs:[b0aa5]            ; adresa tabulky oddlovacch znak
         db        26h
         xlat                               ; transformace podle tab. ES:BX
         test      ah,al
         pop       bx
         ret

                                            ; nalezen zatku slova v textu
                                            ; vstup:  DS:[BX+DI] = ukaz.textu

endwrd:  dec       bx                       ; ukazatel textu
endwrd1: inc       bx
         call      tst40                    ; test, zda jde o dc znak
         jnz       endwrd2                  ; je dc znak - konec
         test      al,4                     ; jde o oddlovac znak slova ?
         jnz       endwrd1                  ; je oddlovac znak slova - dal
endwrd2: ret

                                            ; nalezen slova ve slovnku

                                            ; vstup:  CS:[SI] = ukazatel tabulky
                                            ;         DS:[BX+DI] = ukaz. textu
                                            ; vstup: AX = dlka shodnho slova
                                            ;         (AX = 0,ZF = 0 nenalezeno)

srcwrd:  mov       ah,32                    ; oddlovac znak slov (mezera)
srcwrd1: mov       al,cs:[si]               ; prvn znak slova z tabulky
         cmp       al,[bx+di]               ; porovnn se znakem v textu
         ja        srcwrd5                  ; znak v tabulce vt - nenalezeno
         jc        srcwrd3                  ; znak v tabulce men - dal slovo
         push      bx                       ; (shoda prvnho znaku) ukaz. textu
srcwrd2: inc       bx                       ; ukazatel zkoumanho textu
         inc       si                       ; ukazatel slovnku
         mov       al,cs:[si]               ; dal znak ze slovnku
         cmp       al,ah                    ; je mezera (konec slova) ?
         jz        srcwrd4                  ; je mezera = konec slova
         cmp       al,[bx+di]               ; porovnn dalho znaku slova
         jz        srcwrd2                  ; shoda - dal znak
         pop       bx                       ; (nen shoda) ukazatel textu
srcwrd3: inc       si                       ; nalezen dalho slova v tabulce
         cmp       ah,cs:[si]               ; je oddlovac mezera ?
         jnz       srcwrd3                  ; jet ne - dal znak v tabulce
         inc       si
         jmp       short srcwrd1            ; test dalho slova
srcwrd4: mov       ax,bx                    ; slova se shoduj
         pop       bx                       ; adresa slova ve slovnku
         sub       ax,bx                    ; dlka nalezenho slova
         ret
srcwrd5: xor       ax,ax                    ; slovo nenalezeno - konec (dlka 0)
         ret


lab0af5: push      bx                       ; adresa textu
         add       bx,ax                    ; adresa konce slabiky (rozdlit)
         push      bx                       ; adresa konce slabiky
         call      endwrd                   ; nalezen konce slova v textu
         mov       ax,bx                    ; konec slova v textu
         pop       bx                       ; adresa konce slabiky
         jz        lab0af51                 ; je ji konec dku
         sub       ax,bx                    ; poet znak do konec slova
         cmp       al,1                     ; dlka zbyl sti slova
         jna       lab0af52                 ; nen ji dn znak
         push      ax                       ; dlka zbyl sti slova
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       si                       ; dlka zbyl sti slova
         cmp       ax,si                    ; nalezeno stejn dlouh slovo ?
         jz        lab0af52                 ; je cel slovo
         xor       ax,ax                    
lab0af51:pop       bx                       
         ret                                
lab0af52:pop       si                       
lab0af53:cmp       bl,cs:[b0aa4]             ; povolen dlka dku
         jnc       lab0af55                  ; pekroen okraj dku
         inc       dx                       
         cmp       dx,bx                    
         mov       dx,bx                    
         jz        lab0af54                 
         mov       cs:[w0aa7],bx
lab0af54:ret                                
lab0af55:jmp       fnc097

                                            ;
lab0b2f: mov       si,offset slov1          ; slovnk 1 - nelze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0b2f5                 ; slovo nalezeno - konec
lab0b2f1:mov       si,offset slov2          ; slovnk 2 - lze rozdlit
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f2                 ; slovo nenalezeno - slovnk 3
         call      lab0af5                 
         jnz       lab0b2f1                
lab0b2f2:mov       si,offset slov3          ; slovnk 3
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b2f3                
         mov       si,di                   
         add       si,ax                   
         cmp       byte ptr [bx+si],"E"     ; je znak "E" ?
         jnz       lab0b2f4                
lab0b2f3:mov       si,offset slov4          ; slovnk 4
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,5                    
         jnz       lab0b2f4                
         mov       si,offset slov5          ; slovnk 5
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,4                    
         jnz       lab0b2f4                
         mov       si,offset slov6          ; slovnk 6
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,3                    
         jnz       lab0b2f4                
         mov       si,offset slov7          ; slovnk 7
         call      srcwrd                   ; nalezen slova ve slovnku
         mov       ax,2                    
         jz        lab0b2f5                
lab0b2f4:call      lab0af5                 
lab0b2f5:ret

lab0b85: mov       ax,bx                   
         sub       ax,cx                   
         cmp       ax,2                    
         xchg      bx,cx                   
         jc        lab0b853                
         jz        lab0b851                
         mov       si,offset slov8          ; slovnk 8
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b851                
         inc       bx                      
         jmp       short lab0b852          
lab0b851:mov       si,offset slov9          ; slovnk 9
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0b853                
         cmp       byte ptr [bx+di-1],"Q"   ; je znak "Q" ?
         jz        lab0b853                
lab0b852:inc       bx                      
         call      lab0af53                
lab0b853:xchg      bx,cx                   
         ret       

lab0bb2: cmp       bx,cx
         jz        lab0bb27
         push      bx
         push      dx
         mov       dx,bx
         dec       dx
         mov       bx,cx
         dec       bx
lab0bb21:inc       bx
         cmp       bx,dx
         jz        lab0bb22
         mov       si,offset slov10         ; slovnk 10
         call      srcwrd                   ; nalezen slova ve slovnku
         jz        lab0bb21
         add       ax,bx
         dec       ax
         cmp       ax,dx
         jnz       lab0bb21
         cmp       byte ptr [bx+di-1],"C"   ; byl pedchoz znak "C" ?
         jz        lab0bb21
lab0bb22:xchg      bx,cx
         mov       si,offset slov11         ; slovnk 11
         call      srcwrd                   ; nalezen slova ve slovnku
         add       bx,ax
         xchg      bx,cx
         cmp       bx,cx
         jnc       lab0bb26
         mov       dx,bx
lab0bb23:mov       si,offset slov12         ; slovnk 12
         push      bx
         sub       bx,4
         call      srcwrd                   ; nalezen slova ve slovnku
         pop       bx
         jz        lab0bb24
         cmp       byte ptr cs:[w0aa7],0
         jnz       lab0bb26
lab0bb24:call      tst40                    ; test, zda jde o dc znak
         mov       si,offset slov14         ; slovnk 14
         jnz       lab0bb25
         mov       si,offset slov13         ; slovnk 13
lab0bb25:call      srcwrd                   ; nalezen slova ve slovnku
         jnz       lab0bb26
         inc       bx
         cmp       bx,cx
         jna       lab0bb23
         mov       bx,dx
lab0bb26:pop       dx
         call      lab0af53
         pop       bx
lab0bb27:ret

                                            ; FUNKCE 09 - rozdlovn slov
                                            ; vstup:  DS = datov segment textu
                                            ;         CX = pozice v dku

fnc09:   mov       [w0aa7],0
         mov       [b0aa4],al               ; povolen dlka dku
         mov       [b0aa5],si               ; adresa transforman tabulky znak
         pop       dx                       ; nvratov adresa programu
         pop       ds                       ; datov segment textu
         push      ds                       ; datov segment textu
         push      dx                       ; nvratov adresa programu
         push      bp                       
         mov       bp,sp                    
fnc091:  mov       bx,cx                    ; aktuln pozice v dku
         dec       bx                       
fnc092:  inc       bx                       ; dal znak
         cmp       bl,cs:[b0aa4]            ; povolen dlka dku
         jnc       fnc097                   ; pekroen okraj dku - konec
         call      tst04                    ; test, zda jde o oddlovac znak
         jz        fnc092                   ; nenalezeno - dal
         mov       cx,bx                    ; nov pozice rozdlen slova
         dec       bx                       
fnc093:  inc       bx                       
         call      tst04                    ; test, zda jde o oddlovac znak
         jnz       fnc093                   ; nalezeno - dal pokus
         xchg      bx,cx                    
         mov       ax,cx                    
         sub       ax,bx                    
         cmp       ax,4                     
         jc        fnc091                   
         mov       dx,bx                    
         call      lab0b2f                  
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc091                   
         push      cx                       
fnc094:  mov       cx,bx                    
         dec       bx                       
fnc095:  inc       bx                       
         call      tst40                    ; test, zda jde o dc znak
         jnz       fnc095                   
         call      lab0b85                  
         mov       cx,bx                    
         call      endwrd                   ; nalezen zatku slova v textu
         jz        fnc096                   
         call      lab0bb2                  
         jmp       short fnc094             
fnc096:  pop       cx                       
         jmp       short fnc091             
fnc097:  mov       ax,cs:[w0aa7]            
         mov       sp,bp                    
         pop       bp                       
         ret                                


                                            ; tabulka pro pekdovn klves

tabkey   db        0c1h,1eh                 ; ALT A
         db        0c2h,30h                 ; ALT B
         db        0c3h,2eh                 ; ALT C
         db        0c4h,20h                 ; ALT D
         db        0c5h,12h                 ; ALT E
         db        0c6h,21h                 ; ALT F
         db        0c7h,22h                 ; ALT G
         db        0c8h,23h                 ; ALT H
         db        0c9h,17h                 ; ALT I
         db        0cah,24h                 ; ALT J
         db        0cbh,25h                 ; ALT K
         db        0cch,26h                 ; ALT L
         db        0cdh,32h                 ; ALT M
         db        0ceh,31h                 ; ALT N
         db        0cfh,18h                 ; ALT O
         db        0d0h,19h                 ; ALT P
         db        0d1h,10h                 ; ALT Q
         db        0d2h,13h                 ; ALT R
         db        0d3h,1fh                 ; ALT S
         db        0d4h,14h                 ; ALT T
         db        0d5h,16h                 ; ALT U
         db        0d6h,2fh                 ; ALT V
         db        0d7h,11h                 ; ALT W
         db        0d8h,2dh                 ; ALT X
         db        0d9h,15h                 ; ALT Y
         db        0dah,2ch                 ; ALT Z
         db        0f0h,81h                 ; ALT 0
         db        0f1h,78h                 ; ALT 1
         db        0f2h,79h                 ; ALT 2
         db        0f3h,7ah                 ; ALT 3
         db        0f4h,7bh                 ; ALT 4
         db        0f5h,7ch                 ; ALT 5
         db        0f6h,7dh                 ; ALT 6
         db        0f7h,7eh                 ; ALT 7
         db        0f8h,7fh                 ; ALT 8
         db        0f9h,80h                 ; ALT 9
         db        1bh,3bh                  ; F1
         db        1ch,3ch                  ; F2
         db        1dh,3dh                  ; F3
         db        1eh,3eh                  ; F4
         db        1fh,3fh                  ; F5
         db        20h,40h                  ; F6
         db        21h,41h                  ; F7
         db        22h,42h                  ; F8
         db        23h,43h                  ; F9
         db        24h,44h                  ; F10
         db        5bh,54h                  ; SHIFT F1
         db        5ch,55h                  ; SHIFT F2
         db        5dh,56h                  ; SHIFT F3
         db        5eh,57h                  ; SHIFT F4
         db        5fh,58h                  ; SHIFT F5
         db        60h,59h                  ; SHIFT F6
         db        61h,5ah                  ; SHIFT F7
         db        62h,5bh                  ; SHIFT F8
         db        63h,5ch                  ; SHIFT F9
         db        64h,5dh                  ; SHIFT F10
         db        9bh,5eh                  ; CTRL F1
         db        9ch,5fh                  ; CTRL F2
         db        9dh,60h                  ; CTRL F3
         db        9eh,61h                  ; CTRL F4
         db        9fh,62h                  ; CTRL F5
         db        0a0h,63h                 ; CTRL F6
         db        0a1h,64h                 ; CTRL F7
         db        0a2h,65h                 ; CTRL F8
         db        0a3h,66h                 ; CTRL F9
         db        0a4h,67h                 ; CTRL F10
         db        0dbh,68h                 ; ALT F1
         db        0dch,69h                 ; ALT F2
         db        0ddh,6ah                 ; ALT F3
         db        0deh,6bh                 ; ALT F4
         db        0dfh,6ch                 ; ALT F5
         db        0e0h,6dh                 ; ALT F6
         db        0e1h,6eh                 ; ALT F7
         db        0e2h,6fh                 ; ALT F8
         db        0e3h,70h                 ; ALT F9
         db        0e4h,71h                 ; ALT F10
         db        0a5h,73h                 ; CTRL <-
         db        0a6h,74h                 ; CTRL ->
         db        0a7h,77h                 ; CTRL HOME
         db        0a8h,75h                 ; CTRL END
         db        0a9h,84h                 ; CTRL PGUP
         db        0aah,76h                 ; CTRL PGDN
         db        6bh,0fh                  ; SHIFT TAB
         db        0,0                      


tabshf   db        6                        ; dlka jedn poloky
         db        0,'     '                ; 00h
         db        5,'SHIFT'                ; 40h
         db        4,'CTRL '                ; 80h
         db        3,'ALT  '                ; C0h
         db        0ffh                     

tabhome  db        5                        ; dlka jedn poloky
         db        2,'<-  '                 ; 25h
         db        2,'->  '                 ; 26h
         db        4,'HOME'                 ; 27h
         db        3,'END '                 ; 28h
         db        4,'PGUP'                 ; 29h
         db        4,'PGDN'                 ; 2Ah
         db        3,'TAB '                 ; 2Bh
         db        0ffh                     

tabfn    db        4                        ; dlka jedn poloky
         db        2,'F1 '                  ; 1Bh
         db        2,'F2 '                  ; 1Ch
         db        2,'F3 '                  ; 1Dh
         db        2,'F4 '                  ; 1Eh
         db        2,'F5 '                  ; 1Fh
         db        2,'F6 '                  ; 20h
         db        2,'F7 '                  ; 21h
         db        2,'F8 '                  ; 22h
         db        2,'F9 '                  ; 23h
         db        3,'F10'                  ; 24h
         db        0ffh                     

                                            ; pevod textu na velk psmena

                                            ; vstup:  ES:SI = ukazatel na text
                                            ;         BL = nejmen znak
                                            ; vstup: ES:[BX+SI] = zatek textu
                                            ;         CX = poet znak textu
                                            ;         CF=0,ZF=0 je konec textu
                                            ;         CF=0,ZF=1 nen jet konec

upper:   xor       cx,cx                    ; vynulovn tae znak
upper1:  cmp       bl,es:[si]               ; porovnn znaku s BL
         ja        upper6                   ; znak je men ne BL - konec
         cmp       byte ptr es:[bx+si]," "  ; je mezera ?
         jnz       upper2                   ; nen - konec hledn
         inc       bx                       ; dal pozice
         jmp       short upper1             ; dal znak
upper2:  push      bx                       
upper3:  cmp       bl,es:[si]               ; kontrola koncovho znaku
         ja        upper5                   ; znak je men ne BL - konec
         mov       al,es:[bx+si]            ; peten znaku k pekdovn
         cmp       al," "                   ; je mezera ?
         jz        upper5                   ; je mezera - konec
         cmp       al,"|"                   ; "|"
         jz        upper5                   ; je znak "|" - konec
         cmp       al,"a"                   ; "a"
         jc        upper4                   ; je znak men ne "a"
         and       al,0dfh                  ; pevod na velk psmeno
         mov       es:[bx+si],al            ; uloen pevedenho znaku
upper4:  inc       bx                       ; dal znak
         inc       cx                       ; zven tae nalezench znak
         jmp       upper3                   ; pevod dalho znaku na velk
upper5:  pop       bx                       
upper6:  ret                                

                                            ; nalezen textov poloky v tabulce

                                            ; vstup:  ES:[BX+SI] ukazatel textu
                                            ;         DS:DI = ukazatel tabulky
                                            ;         CX = dlka hled. textu
                                            ; vstup: ES:[BX+SI] nov pozice
                                            ;         DL = poad. slo poloky
                                            ;         AX = dlka poloky tabulky

srctab:  mov       al,[di]                  ; peten dlky jedn poloky
         mov       ah,0                     
         inc       di                       ; ukazatel tabulky - prvn poloka
         xor       dl,dl                    ; ta poloek
srctab1: inc       dx                       ; zven tae poloek
         cmp       cl,[di]                  ; porovnn dlky textu
         jnz       srctab4                  ; nesouhlas - dal poloka
         push      ax                       ; dlka jedn poloky
         push      bx                       ; ukazatel textu
         push      cx                       ; dlka textu
         push      di                       ; ukazatel tabulky
         inc       di                       ; prvn znak poloky
srctab2: mov       al,es:[bx+si]            ; zkouman znak
         cmp       al,[di]                  ; porovnn se znakem z tabulky
         jnz       srctab3                  ; nesouhlas - dal poloka
         inc       bx                       ; zven ukazatele textu
         inc       di                       ; zven ukazatele tabulky
         loop      srctab2                  ; dal znak k testu
         pop       di                       ; ukazatel tabulky - nalezeno
         pop       cx                       ; dlka textu
         pop       ax                       ; zruen pvodn pozice textu BX
         pop       ax                       ; dlka jedn poloky
         or        dl,dl                    ; poadov slo poloky
         ret                                
srctab3: pop       di                       ; ukazatel tabulky
         pop       cx                       ; dlka textu
         pop       bx                       ; ukazatel zkoumanho textu
         pop       ax                       ; dlka jedn poloky
srctab4: add       di,ax                    ; adresa dal poloky
         cmp       byte ptr [di],0ffh       ; je koncov znak tabulky ?
         jnz       srctab1                  ; nen jet konec
         xor       dl,dl                    ; nenalezen - slo poloky = 0
         ret                                


                                            ; FUNKCE 10 - dekdovn klvesy

                                            ; vstup:  ES:SI = ukazatel textu
                                            ; vstup: ES:SI = nov pozice
                                            ;         AX = kd klvesy

fnc10:   mov       bx,1                     ; koncov znak = 00
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         mov       di,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      srctab                   ; nalezen textov poloky v tabulce
         mov       dh,dl                    ; poadov slo poloky - schova
         jz        fnc103                   ; text nebyl nalezen
         dec       dh                       ; poad. slo poloky - 1
         call      upper                    ; pevod textu na velk psmena
         jcxz      fnc106                   ; je ji konec textu
         cmp       cx,1                     ; je pouze jeden znak ?
         jnz       fnc102                   ; nen prv jeden znak
         mov       al,es:[bx+si]            ; znak k pekdovn
         cmp       al,"@"                   ; = "@"
         jc        fnc101                   ; men ne "@"
         cmp       al,"Z"                   ; = "Z"
         ja        fnc106                   ; vt ne "Z"
         sub       al,40h                   ; pevod na dc znak
fnc101:  mov       dl,al                    ; pekdovan znak
         jmp       short fnc104             
fnc102:  mov       di,offset tabhome        ; tabulka dcch klves HOME,...
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc103                   ; poloka nenalezena
         add       dl,24h                   ; korekce
         jmp       short fnc104
fnc103:  mov       di,offset tabfn          ; tabulka funknch klves Fn
         call      srctab                   ; nalezen textov poloky v tabulce
         jz        fnc106                   ; nenalezena
         add       dl,1ah                   ; korekce
fnc104:  ror       dh,1                     
         ror       dh,1                     
         or        dl,dh                    ; klvesy SHIFT,.. jako bity 6 a 7
         mov       di,offset tabkey         ; tabulka pro dekdovn kd klves
fnc105:  mov       al,[di]                  ; kd klvesy
         inc       di                       
         inc       di                       
         or        al,al                    ; je posledn kd ?
         jz        fnc106                   ; kd klvesy nenalezen
         cmp       al,dl                    ; porovnn s hledanm kdem
         jnz       fnc105                   ; dal pokus
         dec       di                       
         mov       al,[di]                  ; pekdovn kdu klvesy
         mov       ah,0                     
         ret                                
fnc106:  xor       ax,ax                    ; kd klvesy nenalezen
         ret                                

                                            ; vpis kdu klvesy

                                            ; vstup:  CS:SI tabulka klves
                                            ;         DL = poad. slo klvesy
                                            ;         DS:[BX+DI] = vst. buffer
                                            ;         CH = 0
                                            ; vstup: DS:[BX+DI] = nov pozice

outkey:  push      ax                       
         mov       al,cs:[si]               ; dlka jedn poloky v tabulce
         mul       dl                       ; rel. adresa poloky v tabulce
         add       si,ax                    ; adresa poloky v tabulce
         inc       si                       
         mov       cl,cs:[si]               ; dlka textu v poloce
         jcxz      outkey2                  
outkey1: inc       si                       ; znak poloky textu klvesy
         inc       bx                       ; ukazatel vstupnho textu
         mov       al,cs:[si]               ; peten znaku poloky
         mov       [bx+di],al               ; uloen do bufferu
         loop      outkey1                  ; dal znak
         inc       bx                       ; nsledujc pozice
         mov       byte ptr [bx+di]," "     ; oddlovac mezera
outkey2: pop       ax                       
         ret                                

adrtab   dw        offset tabkey            ; ukazatel dekdovac tabulky klves


                                            ; FUNKCE 11 - vpis kdu klvesy

                                            ; vstup:  DS:[BX+DI] = vst. buffer
                                            ;         AX = kd klvesy
                                            ; vstup: DS:[BX+DI] = nov adresa

fnc11:   mov       dx,ax                    ; kd klvesy
         xor       cx,cx                    ; ta znak
         mov       bx,[adrtab]              ; ukazatel dekdovac tabulky klves
         inc       bx                       ; dal klvesa
fnc111:  mov       al,[bx]                  ; kd klvesy
         or        al,al                    ; je ukonovac znak 00 ?
         jnz       fnc112                   ; nen jet konec
         mov       [adrtab],offset tabkey   ; nastav. za. dekd. tabulky klves
         mov       es,dx
         mov       es:[di],ch               ;
         ret       
fnc112:  push      si                       ; ukazatel tabulky klves
fnc113:  mov       ah,es:[si]               ; kd klvesy
         or        ah,ah
         jz        fnc114                   ; je ji posledn
         cmp       al,ah                    ; porovnn s hledanou klvesou
         jz        fnc115                   ; je nalezen kd klvesy
         inc       si                       ; dal klvesa
         mov       cl,es:[si]               ;
         inc       cx
         add       si,cx                    ; adresa nsledujcho textu
         jmp       short fnc113             ; nov pokus
fnc114:  pop       si
         inc       bx
         inc       bx
         jmp       short fnc111
fnc115:  inc       bx
         mov       [adrtab],bx              ; nov adresa ukazatele tabulky
         mov       al,[bx-2]                ; kd klvesy
         inc       si
         pop       bx
         push      si
         push      dx
         pop       ds
         xor       bx,bx
         mov       dl,al
         and       dl,0c0h
         rol       dl,1
         rol       dl,1
         mov       si,offset tabshf         ; tabulka klves SHIFT,CTRL,ALT
         call      outkey                   ; vpis kdu klvesy
         mov       dl,al
         and       dl,3fh
         cmp       dl,1ah
         ja        fnc116
         add       dl,40h
         inc       bx
         mov       [bx+di],dl
         jmp       short fnc119
fnc116:  cmp       dl,24h
         ja        fnc117
         sub       dl,1bh
         mov       si,offset tabfn          ; tabulka funknch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc117:  cmp       dl,2bh                   ; znak "+"
         ja        fnc118
         sub       dl,25h
         mov       si,offset tabhome        ; tabulka dcch klves
         call      outkey                   ; vpis kdu klvesy
         jmp       short fnc119
fnc118:  inc       bx
         mov       [bx+di],dl
fnc119:  cmp       bx,9
         ja        fnc11a
         inc       bx
         mov       byte ptr [bx+di]," "     ; oddlovac znak mezery
         jmp       short fnc119
fnc11a:  inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         pop       si
         mov       cl,es:[si]
fnc11b:  inc       si
         mov       al,es:[si]               ; peten znaku k vytitn
         inc       bx
         cmp       al," "
         jnc       fnc11c                   ; nen dc znak
         mov       byte ptr [bx+di],"^"     ; uloen znaku "^" (znak s CTRL-)
         inc       bx                       ; zven ukazatele
         or        al,40h                   ; pevod znaku na tisknuteln znak
fnc11c:  mov       [bx+di],al               ; uloen znaku
         loop      fnc11b                   ; pevod dalho znaku
         inc       bx
         mov       byte ptr [bx+di],"|"     ; znak "|"
         mov       [di],bl
         ret       

tab01    db        1,27
         db        1,'P',18,17,'$$',15
         db        ' Povely s CTRL- ',31
         db        2,'$Kurzor...$ '
         db        4,'$Obrazovka...$'
         db        5,'$Zvltn...$',31
         db        ' S vlevo',2,'(',0fbh,')'
         db        4,'C strnka dol'
         db        5,'B  formtuj',31
         db        ' X dol',3,'(',0f9h,')'
         db        6,'(PgDn)',13,'odstavec',31
         db        ' D vpravo (',0fah,')'
         db        4,'R strnka nahoru'
         db        3,'L pokrauj',31
         db        ' E nahoru (',0f8h,')'
         db        6,'(PgUp)',13,'v hledn',31
         db        ' A slovo vlevo'
         db        3,'Z dek dol'
         db        7,'M konec odstavce',31
         db        ' F slovo vpravo'
         db        2,'W dek nahoru'
         db        7,'<Enter>',31
         db        ' I na dal'
         db        25,'N vloen',31
         db        3,'tabeltor'
         db        6,'$Podmenu...$'
         db        8,'dku',31
         db        17,'J info/displej'
         db        5,'V vkldn',31
         db        2,'$Mazn...$'
         db        4,'K blok/soubor'
         db        8,'zap/vyp',31
         db        ' G znaku nad'
         db        5,'O formtovn/'
         db        7,'<Insert>',31
         db        3,'kurzorem'
         db        8,'nastavovn'
         db        6,'\ roz. znaky',31
         db        ' H znaku vlevo'
         db        3,'P typy psma'
         db        7,'- zmna dvou',31
         db        ' T slova vpravo'
         db        2,'Q pesuny kurzoru/'
         db        4,'znak',31
         db        ' Y dku'
         db        11,'hledn/zmna'
         db        3,'],6 text.buffer'
         db        0

tab02    db        0,58
         db        1,'P',16,11,' CTRL J ',31
         db        ' B',2,'dky displeje',31
         db        ' C',2,'barvy displeje',31
         db        ' F',2,'blikn zap/vyp',31
         db        ' H',2,'pomoc zap/vyp',31
         db        ' -------------------',31
         db        ' G',2,'graf.editor ',31
         db        ' I',2,'pracovn prostor',31
         db        ' D',2,'zpis data  ',31
         db        ' T',2,'zpis asu',31
         db        ' K',2,'kalend/hodiny',31
         db        ' -------------------',31
         db        ' R',2,'vpoty v textu',31
         db        ' S',2,'sloupc. souty',31
         db        ' M',2,'prmr      '
         db        0

tab03    db        0,35
         db        1,'P',14,14,'$$'
         db        17,' CTRL K ',31
         db        17,'$Blok....$',31
         db        ' B',2,'oznaen zatku'
         db        6,'C',2,'koprovn ',31
         db        ' K',2,'oznaen konce'
         db        8,'V',2,'pesunut',31
         db        ' N',2,'sloupcov blok'
         db        8,'Y',2,'mazn',31
         db        ' H',2,'zobrazen zap/vyp'
         db        5,'R',2,'ten',31
         db        ' T',2,'zmna psma'
         db        11,'W',2,'uloen',31
         db        ' G',2,'penos z'
         db        ' jinho prac.prostoru',31
         db        ' ------------------------------------------',31
         db        ' D',2,'menu soub.'
         db        12,'E',2,'mazn textu',31
         db        ' P',2,'menu tisku'
         db        12,'L',2,'ten textu',31
         db        '1-5 zmna prac.prostoru'
         db        3,'S',2,'uloen textu',31
         db        ' Q',2,'ukonen KonTextu'
         db        5,'X',2,'start programu'
         db        0

tab04    db        0,23
         db        1,'P',15,24,'$$'
         db        20,' CTRL O ',31
         db        3,'$Pepnae zap/vyp'
         db        8,'Formtovn$',31
         db        ' J',2,'zarovnvn'
         db        11,'B',2,'po konec textu',31
         db        ' H',2,'dlen slov'
         db        11,'C',2,'centrovn dku',31
         db        ' Q',2,'dlen s dotazem'
         db        6,'Z',2,'dvousloupcov formt.',31
         db        ' V',2,'autom.tabeltor',31
         db        ' M',2,'<Enter>=kon.odst.'
         db        9,'$Nastav.strnky$',31
         db        ' P',2,'zobrazen strnky'
         db        5,'I',2,'menu linelu dku',31
         db        ' T',2,'zobrazen linelu'
         db        5,'F',2,'prav okraj->konec dku',31
         db        ' N',2,'nedokumentn md'
         db        6,'L',2,'lev okraj ->pozice kurzoru',31
         db        26,'R',2,'prav okraj->pozice kurzoru',31
         db        26,'S',2,'poet dk na strnku',31
         db        ' A',2,'zatek odstavce',2,0f0h
         db        3,'E',2,'zobrazen zhlav/paty',31
         db        ' U',2,'neformtovat',6,0ffh
         db        3,'O',2,'blok jako zhlav/pata'
         db        0

tab05    db        0,59
         db        1,'P',9,10,' CTRL P ',31
         db        ' N=normln',31
         db        ' F=zvraznn',31
         db        ' U=podtren',31
         db        ' K=kurzva',31
         db        ' B=irok',31
         db        ' H=nadsazen',31
         db        ' T=podsazen'
         db        0,0,0,0,0,0,0,0

tab06    db        0,39
         db        1,'P',13,30,' CTRL Q ',31
         db        ' A',2,'hledn/zmna'
         db        4,'F',2,'hledn',31
         db        ' M',2,'nastav.znaky'
         db        5,'T',2,'makroklvesy',31
         db        ' L',2,'navrcen poslednch zmn   ',31
         db        10,'$Pozice kurzoru...$',31
         db        ' S',2,'zatek dku'
         db        6,'D',2,'konec dku',31
         db        ' E',2,'horn okraj'
         db        8,'X',2,'doln okraj',31
         db        ' R',2,'zat.textu'
         db        8,'C',2,'konec textu',31
         db        ' B',2,'zat.bloku'
         db        8,'K',2,'konec bloku',31
         db        ' P',2,'znaka'
         db        13,'Z',2,'pozice',31
         db        14,'$Mazn...$',31
         db        ' H',2,'po zatek dku'
         db        3,'Y',2,'po konec dku'
         db        0,0

tab07    db        1,52
         db        1,'P',10,16,' CTRL JC ',31,31
         db        2,'--- Nastaven barev ---',31
         db        ' Zadejte slo barvy nebo',31
         db        ' zvolte <Enter>=beze zmny',31,31
         db        ' Barva psma (0..15):',31
         db        ' Barva okol (0..15):'
         db        0

tab08    db        1,54
         db        1,'P',13,13,' CTRL JI ',31,31
         db        ' - Pracovn prostor : - ',31
         db        '$obsah             dk$',31
         db        31,31,31,31,31,31
         db        ' text :'
         db        7,'bajt vol.',31
         db        ' makra:'
         db        7,'bajt vol.'
         db        0

tab09    db        1,49
         db        1,'P',16,19,' CTRL JK ',31
         db        31,31,31
         db        2,'PO',2,'T',2,'ST',2,'T',2,'P',2,'SO',2,'NE',31
         db        ' ============================',31
         db        31,31,31,31,31,31
         db        ' ============================',31
         db        1,0fbh,2,'pedch.'
         db        2,0fah,' nsled.  msc',31
         db        1,0f9h,2,'pedch.',2,0f8h,' nsled.  rok '
         db        0

tab10    db        1,61
         db        1,'P',17,8,' CTRL KD ',31
         db        ' ti text  ',31
         db        ' ulo text     ',31
         db        ' ti blok   ',31
         db        ' ulo blok      ',31
         db        ' zru soubor  ',31
         db        ' pejmenuj soubor',31
         db        ' kopruj soubor',31
         db        ' start programu ',31
         db        ' ulo nastaven',31
         db        ' konec KonTextu ',31
         db        ' ----------------',31
         db        ' formt KonText',31
         db        ' formt Layout',31
         db        ' formt ASCII',31
         db        ' zloha BAK '
         db        0

tab11    db        0,52
         db        1,'P',3,'a'
         db        0

tab12    db        1,52
         db        1,'P',11,31
         db        4,'-- tisk textu   --',31
         db        2,'  Zadejte sla nebo     ',31
         db        '   <Enter> = dn zmna ',31,31
         db        ' prvn strnka:  ',5,'1',31
         db        ' konen strnka:',31
         db        ' prvn slo strany:',2,'1',31
         db        ' exempl:',11,'1'
         db        0

tab13    db        1,55
         db        1,'P',7,13,' CTRL KP ',31,31
         db        ' - probh tisk textu -',31,31
         db        9,'dle',31
         db        9,'peruen'
         db        0

tab14    db        1,25
         db        6,'6',14,16,' CTRL KQ ',31,31
         db        3,'Tmto povelem ukonte',31
         db        ' KonText a navrtte se zpt',31
         db        2,'do operanho systmu !!!',31,31
         db        2,'Stisknte <Enter> = konec',31
         db        3,'nebo <Esc> = pokrauj'
         ; db        0

tab15    db        0,58
         db        1,'P',7,10,' CTRL OE ',31
         db        '  ',31
         db        'Jako blok se zobraz:',31,31
         db        4,'K = zhlav',31
         db        4,'F = pata '
         db        0

tab16    db        0,53
         db        1,'P',15,14,' CTRL OI ',31
         db        2,'-- Tabeltory/okraje --',31,31
         db        2,0fah,3,'kurzor vpravo',31
         db        2,0fbh,3,'kurzor vlevo',31
         db        ' End',2,'...k pravmu okraji',31
         db        ' Home ...k levmu okraji',31
         db        2,'L',3,'lev okraj',31
         db        2,'R',3,'prav okraj',31
         db        ' Tab',2,'nastav/zru tabel.',31
         db        2,'#',3,'dekadick tabeltor',31
         db        ' Del',2,'ruen/nvrat tabel.',31
         db        ' Ret',2,'ukonen volby',31
         db        ' Esc',2,'peruen volby'
         db        0,0,0,0,0

tab17    db        0,58
         db        1,'P',7,10,' CTRL OO ',31,31
         db        ' Blok se ulo jako: ',31,31
         db        4,'K = zhlav ',31
         db        4,'F = pata   '
         db        0

tab18    db        1,46
         db        1,'P',11,22,' CTRL OS ',31,31
         db        '   Zadejte nov nastaven nebo  ',31
         db        2,'stisknte <Enter>=beze zmny: ',31,31
         db        ' dk na strnku (4..99):',31
         db        ' z toho: zhlav  (0..10):',31
         db        7,'  pata   ',2,'(0..10):',31,31
         db        ' rozte dk :',9,'cm'
         db        0

tab19    db        1,25
         db        4,'6',14,17,' CTRL OZ ',31,31
         db        3,'Tento povel zformtuje',31
         db        4,'text na tto stran',31
         db        4,'dvousloupcov. Nov',31
         db        3,'formtovn ji nadle',31
         db        7,'nebude mon !',31
         db        10,'Zvolte: ',31
         db        5,'<Enter> = potvrzen ',31
         db        2,'<Esc> = peruen povelu'
         db        0,0,0,0,0,0,0

tab20    db        0,58
         db        1,'P',9,10,' VOLBY ',31
         db        ' B',2,'zptn smr     ',31
         db        ' G',2,'v celm textu   ',31
         db        ' L',2,'v celm bloku   ',31
         db        ' W',2,'pouze cel slovo',31
         db        ' U',2,'nerozliuje velk',31
         db        4,'a mal psmena'
         db        0,0,0

tab21    db        1,27
         db        7,'6',13,31
         db        2,' Text v prac.prost.',31
         db        2,'nebude uloen na disk !',31,31
         db        3,'<Enter>=pokraovn',31
         db        5,'<Esc>=peruen'
         db        0

tab22    db        1,34
         db        1,'P',15,28,' Zvltn znaky'
         db        0

tab23    db        1,25
         db        4,'6',13,19,' SETUP ',31,31
         db        ' Tato volba zpsob, e pi',31
         db        '  dalm sputn KonTextu',31
         db        2,'bude opt pouito stejn',31
         db        3,'nastaven parametr.',31,31
         db        3,'Zvolte <Enter>=uloen',31
         db        4,'nebo <Esc>=peruen.'
         db        0

tab24    db        0,50
         db        1,'P',8,18,' CTRL KN ',31,31
         db        3,'Nastaven sloupc.bloku:',31,31
         db        ' B',2,'zatek (lev horn roh)',31
         db        ' K',2,'konec (prav doln roh) '
         db        0

tab25    db        1,50
         db        1,'P',10,31
         db        5,'--- Sriov tisk --',31
         db        ' Prosm, zadejte novou volbu',31
         db        ' nebo <Enter> = beze zmny:',31,31
         db        ' Dat. prostor',4,'(1..5):',31
         db        ' Peformtovn ',2,'(J/N):',31
         db        0

tab26    db        1,30
         db        7,'3',13,31
         db        ' Sriov tisk-pauza',31
         db        ' pro',2,'vmnu papru',31,31
         db        ' pokra. = <Enter>,',31
         db        2,'peru. = <ESC>'
         db        0

tab27    db        1,1
         db        1,21,12,31
         db        ' zatek textu',31
         db        ' konec textu',31
         db        ' zatek bloku',31
         db        ' konec bloku',31
         db        ' na znaku',31
         db        ' nastaven znaky',31
         db        ' na danou pozici',31
         db        ' vyhledn textu',31
         db        ' hledn/zmna',31
         db        ' pokra.hled./zm.'
         db        0

tab28    db        1,3
         db        1,21,9,31
         db        ' slova vpravo',31
         db        ' po kurzor',31
         db        ' od kurzoru',31
         db        ' mazn dku ',31
         db        ' mazn bloku ',31
         db        ' obnoven zmn',31
         db        ' celho textu   '
         db        0

tab29    db        1,12
         db        1,29,14,31
         db        ' zatek bloku',31
         db        ' konec bloku  ',31
         db        ' sloupc.blok ',0dah,0c4h,' ',31
         db        ' sloupc.blok',2,0c4h,0d9h,31
         db        ' mazn',31
         db        ' pemstn',31
         db        ' koprovn',31
         db        ' penos',31
         db        ' ten',31
         db        ' uloen',31
         db        ' zmna psma',31
         db        ' oznaen'
         db        0

tab30    db        1,19
         db        1,'%',9,31
         db        ' normln',31
         db        ' zvraznn',31
         db        ' podtren',31
         db        ' kurzva',31
         db        ' irok',31
         db        ' nadsazen',31
         db        ' podsazen'
         db        0

tab31    db        1,26
         db        1,'.',14,31
         db        ' po konec odst.',31
         db        ' po konec textu',31
         db        ' dvousloupcov',31
         db        ' centruj dek',31
         db        ' zarovnvn',31
         db        ' rozdlovn',31
         db        ' s dotazem',31
         db        ' auto-tabeltor',31
         db        ' <Enter>=odstavec',31
         db        ' za.odstavce',4,0f0h,31
         db        ' konec odstavce',2,0f1h,31
         db        ' neformtovat',4,0ffh
         db        0

tab32    db        1,32
         db        1,38h,14,31
         db        ' dk na strnku',31
         db        ' menu linelu dk',31
         db        ' lev okrajkurzor',31
         db        ' prav okrajkurzor',31
         db        ' prav okrajkonec d.',31
         db        ' zobrazen zhlav',31
         db        ' zobrazen paty',31
         db        ' blok jako zhlav',31
         db        ' blok jako pata',31
         db        ' zobraz.strnkovn',31
         db        ' zobr.linelu dku',31
         db        ' nedokumentn md '
         db        0

tab33    db        1,43
         db        1,'=',8,31
         db        ' 2 barvy',31
         db        ' 8/16 barev',31
         db        ' 16 barev',31
         db        ' zmna barev  ',31
         db        ' npovda',31
         db        ' blikn kurz.'
         db        0

tab34    db        1,51
         db        1,'E',14,31
         db        ' prac. prostor',31
         db        ' text do bufferu',31
         db        ' text z bufferu',31
         db        ' zpis asu',31
         db        ' zpis data  ',31
         db        ' kalend',31
         db        ' grafick editor',31
         db        ' zvltn znaky',31
         db        ' makroklvesy',31
         db        ' kalkultor',31
         db        ' sloupc. souet',31
         db        ' prmr    '
         db        0

tab35    db        1,59
         db        1,77,15,6,' CTRL KP ',31
         db        ' tisk textu',31
         db        ' sriov tisk',31
         db        ' ten instalace',31
         db        ' zmna instalace',31
         db        ' ---------------',31
         db        ' vy kvalita',31
         db        ' psmo Elite ',31
         db        ' zk psmo ',31
         db        ' proporcionln',31
         db        ' dvoj. petisk',31
         db        ' hust dkov.',31
         db        ' samostat.list',31
         db        ' vmna papru'
         db        0


tabhlp   dw        offset tab01
         dw        offset tab02
         dw        offset tab03
         dw        offset tab04
         dw        offset tab05
         dw        offset tab06
         dw        offset tab07
         dw        offset tab08
         dw        offset tab09
         dw        offset tab10
         dw        offset tab11
         dw        offset tab12
         dw        offset tab13
         dw        offset tab14
         dw        offset tab15
         dw        offset tab16
         dw        offset tab17
         dw        offset tab18
         dw        offset tab19
         dw        offset tab20
         dw        offset tab21
         dw        offset tab22
         dw        offset tab23
         dw        offset tab24
         dw        offset tab25
         dw        offset tab26
         dw        offset tab27
         dw        offset tab28
         dw        offset tab29
         dw        offset tab30
         dw        offset tab31
         dw        offset tab32
         dw        offset tab33
         dw        offset tab34
         dw        offset tab35

                                            ; funkce 07 - adresa npovdy ES:SI
fnc07:   mov       bx,[bp+4]
         shl       bx,1
         mov       si,[bx+tabhlp]
         push      ds
         pop       es
         ret

taberr   db        1,'Soubor nebyl nalezen',0
         db        2,'ten souboru nen mon.....',0
         db        3,'Zpis souboru nen mon.........',0
         db        4,'Poadovan adres nenalezen..',0
         db        5,'Nedostatek msta v pamti',0
         db        6,' Pekroen maximln poet dk ',0
         db        7,34,'  nebyl nalezen ',0
         db        8,' dek je moc dlouh ',0
         db        9,' Nepovolen zadn ',0
         db        10,'  Nen oznaen dn blok ',0
         db        11,' Pam makroklves je pln',0
         db        12,'    Tiskrna nen v provozu ',0
         db        13,'   Chybn formt dat',0
         db        15,'Soubor s tmto jmnem ji existuje v prac.pr.',0
         db        16,'Zdrojov a clov s. jsou identick',0
         db        17,'Prostor @ nen dosud vytistn.',0
         db        18,' Sloupcov blok neme bt zapsn do jednoho'
         db           ' souboru ',0
         db        19,'Nen oznaen dn sloupcov blok',0
         db        20,'   Kurzor se mus nachzet vpravo od pravho'
         db           ' okraje ',0
         db        21,' Nen soubor EXE ani COM ',0
         db        50,'Nepovolen mat.vraz ',0
         db        51,'Pete. des. teky',0
         db        52,'Dlen nulou       ',0
         db        53,'Chybn argum. ',0
         db        54,'Chyba argumen.',0
         db        99,'Intern chyba  ',0
         db        100,'Disketov mechanika nepracuje',0
         db        153,'Neoekvan konec soub',0
         db        196,'Pete. Integer',0
         db        240,' Disketa je peplnna',0
         db        241,'Nepovolen jmno soub.',0
         db        0,'Neznm chyba      ',0

                                            ; FUNKCE 08 - adresa chybovch hlen

fnc08:   mov       si,offset taberr         ; tabulka hlen
         push      ds                       ; nastaven ES = DS
         pop       es
         ret

code     ENDS

         end       start
