; ============================================================================
;
;                            VEGASLOT - Keys
;
; ============================================================================

SECTION		.text

; ------------- Key indexes

KEYTOSS		equ	0		; index of Toss key
KEYCREDIT	equ	1		; index if Credit key
KEYCASH		equ	2		; index of Cash key
KEYSTART	equ	3		; index of Start key
KEYBET		equ	4		; index of Bet key

KEYNUM		equ	5		; number of keys

; ------------- Structure of key descriptor

struc		KeyItem

key_src		resd	1		; source offset of key
key_dst		resd	1		; destination offset of key
key_width	resw	1		; width of key
key_enabled	resb	1		; 1=key is enabled
		resb	1		; ...align
endstruc

KEYITEM_SIZE	equ	12		; size of KeyItem structure

; ----------------------------------------------------------------------------
;                        Init key descriptors
; ----------------------------------------------------------------------------
; INPUT:	DS = data segment
; ----------------------------------------------------------------------------

; ------------- Push registers

KeyInit:	push	ax		; push AX
		push	bx		; push BX
		push	dx		; push DX
		push	si		; push SI
		push	di		; push DI

; ------------- Prepare height of key

		mov	ax,36		; height in 1280x960
		mul	word [ScreenH]	; height * height of screen
		mov	bx,960		; BX <- prototypal videomode Y
		div	bx		; calculate Y coordinate of key
		mov	[KeyHeight],ax	; store key height

; ------------- Prepare pointers

		mov	si,Keys		; SI <- table of key descriptors

; ------------- Toss key

		mov	ax,302		; X coordinate of key
		mov	bx,876		; Y coordinate of key
		mov	di,258		; width of key
		call	Key1Init	; init key descriptor

; ------------- Credit key

		mov	ax,568		; X coordinate of key
		mov	di,408		; width of key
		call	Key1Init	; init key descriptor

; ------------- Cash key

		mov	ax,306		; X coordinate of key
		mov	bx,912		; Y coordinate of key
		mov	di,172		; width of key
		call	Key1Init	; init key descriptor

; ------------- Start key

		mov	ax,486		; X coordinate of key
		mov	di,300		; width of key
		call	Key1Init	; init key descriptor

; ------------- Bet key

		mov	ax,792		; X coordinate of key
		mov	di,184		; width of key
		call	Key1Init	; init key descriptor

; ------------- Pop registers

		pop	di		; pop DI
		pop	si		; pop SI
		pop	dx		; pop DX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                       Init of one key descriptor
; ----------------------------------------------------------------------------
; INPUT:	AX = X coordinate of key in 1280x960
;		BX = Y coordinate of key in 1280x960
;		DI = width of key in 1280x960
;		DS:SI = key descriptor
; OUTPUT:	DS:SI = next key descriptor
; ----------------------------------------------------------------------------

; ------------- Push registers

Key1Init:	push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	dx		; push DX
		push	di		; push DI

; ------------- X coordinate of key

		mul	word [ScreenW]	; X coordinate * width of screen
		mov	cx,1280		; CX <- prototypal videomode X
		div	cx		; calculate X coordinate of key
		xchg	ax,bx		; BX <- X coordinate, AX <- Y coord.

; ------------- Y coordinate of key

		mul	word [ScreenH]	; Y coordinate * height of screen
		mov	cx,960		; CX <- prototypal videomode Y
		div	cx		; calculate Y coordinate of key
		xchg	ax,cx		; CX <- Y coordinate of key

; ------------- Width of key

		mov	ax,1280		; AX <- prototypal videomode X
		xchg	ax,di		; AX <- width of key, DI <- prot. X
		mul	word [ScreenW]	; width * width of screen
		div	di		; calculate width of key
		mov	[si+key_width],ax ; store width of key

; ------------- Calculate source offset

		push	si		; push SI
		call	CalcSrc		; calculate source offset
		mov	dx,si		; DX <- source offset LOW
		pop	si		; pop SI
		mov	[si+key_src],dx	; store source offset LOW
		mov	[si+key_src+2],ax ; store source offset HIGH

; ------------- Calculate destination offset

		call	CalcDest	; calculate destination offset
		mov	[si+key_dst],di	; store destination offset LOW
		mov	[si+key_dst+2],dx ; store destination offset HIGH

; ------------- Prepare flag - key enabled

		mov	byte [si+key_enabled],1 ; key is enabled

; ------------- Next key descriptor

		add	si,KEYITEM_SIZE	; SI <- address of next key descriptor

; ------------- Pop registers

		pop	di		; pop DI
		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                        Set state of all keys
; ----------------------------------------------------------------------------

; ------------- Push registers

SetKeys:	push	ax		; push AX
		push	bx		; push BX
		push	bp		; push BP

; ------------- Prepare registers

		mov	bp,Keys		; key descriptors

; ------------- Toss/Bank key

		mov	al,0		; state - key is disabled
		cmp	byte [cs:Turning],1 ; are reels turning?
		je	SetKeyToss	; reels are turning
		cmp	byte [cs:Risking],1 ; is risk now?
		jne	SetKeyToss4	; it is not risk
		test	byte [cs:AutoStartTime],20h ; is toss shining?
		jz	SetKeyToss	; toss is not shining
SetKeyToss4:	mov	al,1		; state - key is enabled
SetKeyToss:	call	SetKey		; set key state

; ------------- Credit key

		mov	al,0		; state - key is disabled
		cmp	byte [cs:Turning],1 ; are reels turning?
		je	SetKeyCredit	; reels are turning
		cmp	byte [cs:Tossing],1 ; is it tossing?
		je	SetKeyCredit	; it is tossing
		cmp	byte [cs:Risking],1 ; is risk now?
		jne	SetKeyCredit4	; it is not risk
		test	byte [cs:AutoStartTime],20h ; is credit shining?
		jnz	SetKeyCredit	; credit is not shining
SetKeyCredit4:	mov	al,1		; state - key is enabled
SetKeyCredit:	call	SetKey		; set key state

; ------------- Cash key

		mov	al,0		; state - key is disabled
		cmp	byte [cs:Turning],1 ; are reels turning?
		je	SetKeyCash	; reels are turning
		cmp	word [cs:Bank],0 ; is any bank to transfer?
		jne	SetKeyCash2	; is any bank to transfer
		cmp	word [cs:Credit],0 ; is any credit to cash?
		je	SetKeyCash	; there is no credit to cash	
SetKeyCash2:	cmp	byte [cs:Tossing],1 ; is it tossing?
		je	SetKeyCash	; it is tossing
		cmp	byte [cs:Risking],1 ; is risk now?
		je	SetKeyCash	; it is risk
		mov	al,1		; state - key is enabled
SetKeyCash:	call	SetKey		; set key state

; ------------- Start key

		mov	al,0		; state - key is disabled
		cmp	word [cs:Bonus],0 ; is it bonus game?
		jne	SetKeyStart2	; it is bonus game
		cmp	word [cs:Credit],0 ; is it any credit?
		je	SetKeyStart	; there is no credit
SetKeyStart2:	cmp	byte [cs:Risking],1 ; is risk now?
		jne	SetKeyStart4	; it is not risk
		cmp	byte [cs:RiskEnable],1 ; is risk enabled?
		jne	SetKeyStart	; risk is not enabled
		mov	ah,[cs:AutoStartTime] ; risk timer
		and	ah,30h		; AH <- timer value
		jz	SetKeyStart	; start is not shining
		cmp	ah,30h		; is start shining?
		je	SetKeyStart	; start is not shining
SetKeyStart4:	cmp	byte [cs:AutoStart],1 ; is it AutoStart?
		jne	SetKeyStart8	; it is not AutoStart
		test	byte [cs:AutoStartTime],10h ; test blink state
		jz	SetKeyStart	; it is dark state
SetKeyStart8:	mov	al,1		; state - key is enabled
SetKeyStart:	call	SetKey		; set key state

; ------------- Bet key

		mov	al,0		; state - key is disabled
		cmp	byte [cs:Turning],1 ; are reels turning?
		je	SetKeyBet	; reels are turning
		cmp	word [cs:Credit],1 ; is any credit?
		jbe	SetKeyBet	; too low credit		
		cmp	byte [cs:Tossing],1 ; is it tossing?
		je	SetKeyBet	; it is tossing
		cmp	byte [cs:Risking],1 ; is risk now?
		je	SetKeyBet	; it is risk
		mov	al,1		; state - key is enabled
SetKeyBet:	call	SetKey		; set key state

; ------------- Pop registers

		pop	bp		; pop BP
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                        Set state of one key
; ----------------------------------------------------------------------------
; INPUT:	AL = new state of key
;		CS:BP = key descriptor
; OUTPUT:	CS:BP = next key descriptor
; ----------------------------------------------------------------------------

SetKey:		cmp	al,[cs:bp+key_enabled] ; changes state?
		je	SetKey2		; state don't changes
		mov	[cs:bp+key_enabled],al ; store new key state
		call	DrawKey		; redraw key
SetKey2:	add	bp,KEYITEM_SIZE	; BP <- next key descriptor
		ret

; ----------------------------------------------------------------------------
;                             Display all keys
; ----------------------------------------------------------------------------

; ------------- Push registers

DrawKeys:	push	cx		; push CX
		push	bp		; push BP

; ------------- Draw one key

		mov	cx,KEYNUM	; CX <- number of keys
		mov	bp,Keys		; BP <- key descriptors
DrawKeys2:	call	DrawKey		; draw one key
		add	bp,KEYITEM_SIZE	; BP <- next key descriptor
		loop	DrawKeys2	; draw next key

; ------------- Pop registers

		pop	bp		; pop BP
		pop	cx		; pop CX
		ret

; ----------------------------------------------------------------------------
;                            Display one key
; ----------------------------------------------------------------------------
; INPUT:	CS:BP = key descriptor
; ----------------------------------------------------------------------------

; ------------- Push registers

DrawKey:	push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	dx		; push DX
		push	si		; push SI
		push	di		; push DI
		push	bp		; push BP

; ------------- Prepare registers

		mov	si,[cs:bp+key_src] ; source offset LOW
		mov	ax,[cs:bp+key_src+2] ; source offset HIGH
		mov	di,[cs:bp+key_dst] ; destination offset LOW
		mov	dx,[cs:bp+key_dst+2] ; destination offset HIGH
		mov	bx,[cs:bp+key_width] ; width of key
		mov	cx,[cs:KeyHeight] ; height of key

; ------------- Test, if it is enabled

		cmp	byte [cs:bp+key_enabled],1 ; is it enabled?
		jne	DrawKey4	; key is disabled

; ------------- Draw key enabled

DrawKey2:	call	DrawLine	; draw one line
		loop	DrawKey2	; draw next line
		jmp	short DrawKey6	; end

; ------------- Draw key disabled

DrawKey4:	mov	bp,DarkTab+3*256 ; dark table
DrawKey5:	call	DrawDark	; draw one dark line
		loop	DrawKey5	; draw next line

; ------------- Pop registers

DrawKey6:	pop	bp		; pop BP
		pop	di		; pop DI
		pop	si		; pop SI
		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

AutoStart:	db	0		; 1=autostart
AutoStartTime:	db	0		; autostart and risk blinking time

KeyHeight:	dw	0		; height of key help

; ------------- Cash key

KeyCashSrc:	dw	0		; source offset of Cash key
KeyCashDst:	dw	0		; destination offset of Cash key
KeyCashWidth:	dw	0		; width of Cash key
KeyCashEnable:	db	0		; 1=Cash key is enabled

; ------------- Toss key

KeyTossSrc:	dw	0		; source offset of Cash key
KeyTossDst:	dw	0		; destination offset of Cash key
KeyTossWidth:	dw	0		; width of Cash key
KeyTossEnable:	db	0		; 1=Cash key is enabled


; ----------------------------------------------------------------------------
;          Uninitialized data (60 KB area in place of VGA graphics)
; ----------------------------------------------------------------------------

SECTION		.bss

Keys:		resb	KEYNUM*KEYITEM_SIZE ; key descriptors
