//        >>>>>  T-I-N-Y  M-I-S-S-I-L-E for ATTINY85  GPL v3 <<<<<
//                    Programmer: Daniel C 2020-2021
//             Contact EMAIL: electro_l.i.b@tinyjoypad.com
//                    https://WWW.TINYJOYPAD.COM
//          https://sites.google.com/view/arduino-collection

//  tiny-Missile is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//for TINY JOYPAD rev2 (attiny85)
//the code work at 16MHZ internal
//Program the chip with an arduino uno in "Arduino as ISP" mode.

// -----------------------------------------
// Babypad adaptation: Miroslav Nemecek 2025
// -----------------------------------------

#include "../include.h"

const uint8_t DOME_ORDER_TMISSILE[] PROGMEM = {
	2,17,32,81,96,111
};

const uint8_t DOME_SPRITE_TMISSILE[] PROGMEM = {
	15,1,
	0x00,0x00,0x08,0x1C,0x1E,0x3E,0x3F,0x2F,0x3D,0x36,0x1A,0x14,0x08,0x00,0x00,0x00,0x00,0x08,0x1C,0x1E,
	0x3E,0x3E,0x2C,0x3C,0x36,0x1A,0x14,0x08,0x00,0x00,0x00,0x00,0x08,0x1C,0x1E,0x38,0x30,0x20,0x38,0x30,
	0x1A,0x14,0x08,0x00,0x00,0x00,0x00,0x0A,0x1D,0x11,0x20,0x21,0x00,0x21,0x20,0x11,0x15,0x0A,0x00,0x00,
	0x00,0x00,0x06,0x11,0x01,0x21,0x01,0x02,0x00,0x21,0x01,0x11,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
	0x00,0x03,0x28,0x03,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,
};

const uint8_t ROCKET_TMISSILE[] PROGMEM = {
	2,1,
	0b00000011,
	0b00000011,
};

const uint8_t CROSS_TMISSILE[] PROGMEM = {
	3,1,
	0b00000010,
	0b00000111,
	0b00000010,
};

const uint8_t police_TMISSILE[] PROGMEM = {
	4,1,
	0xF8,0x88,0xF8,0x00,0x00,0xF8,0x00,0x00,0xE8,0xA8,0xB8,0x00,0x88,0xA8,0xF8,0x00,0x38,0x20,0xF8,0x00,
	0xB8,0xA8,0xE8,0x00,0xF8,0xA8,0xE8,0x00,0x08,0xE8,0x18,0x00,0xF8,0xA8,0xF8,0x00,0xB8,0xA8,0xF8,0x00,
};

const uint8_t INTERCEPT_TMISSILE[] PROGMEM = {
	10,2,
	0x00,0x00,0x00,0x80,0x40,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x01,0x00,0x00,0x00,
	0x00,0x00,0xC0,0x20,0x20,0x20,0x20,0xC0,0x00,0x00,0x00,0x00,0x03,0x04,0x04,0x04,0x04,0x03,0x00,0x00,
	0x00,0xC0,0x20,0x10,0x10,0x10,0x10,0x20,0xC0,0x00,0x00,0x03,0x04,0x08,0x08,0x08,0x08,0x04,0x03,0x00,
	0xC0,0x20,0x10,0x88,0xC8,0xC8,0x88,0x10,0x20,0xC0,0x03,0x04,0x08,0x11,0x13,0x13,0x11,0x08,0x04,0x03,
	0xC0,0x20,0xD0,0xA8,0x68,0x68,0xA8,0xD0,0x20,0xC0,0x03,0x04,0x0B,0x15,0x16,0x16,0x15,0x0B,0x04,0x03,
	0xE0,0xF0,0x58,0x38,0x18,0x78,0xB8,0x58,0xF0,0xE0,0x07,0x0F,0x1B,0x1D,0x1C,0x1A,0x1C,0x1B,0x0F,0x07,
	0x48,0xA0,0x08,0x20,0x04,0x00,0x10,0x48,0x00,0x24,0x24,0x02,0x18,0x04,0x10,0x00,0x00,0x08,0x01,0x22,
};

const uint8_t TOP_PANEL_TMISSILE[] PROGMEM = {
	0xFE,0x07,0x03,0xEB,0x9B,0xB3,0xD3,0x9B,0xEB,0x03,0x03,0xEB,0x9B,0xB3,0xD3,0x9B,0xEB,0x03,0x03,0xEB,
	0x9B,0xB3,0xD3,0x9B,0xEB,0x03,0x03,0xEB,0x9B,0xB3,0xD3,0x9B,0xEB,0x03,0x07,0xFF,0xFF,0x03,0x01,0x01,
	0x01,0x99,0x7D,0x99,0x01,0x01,0x01,0x99,0x7D,0x99,0x01,0x01,0x01,0x99,0x7D,0x99,0x01,0x01,0x01,0x99,
	0x7D,0x99,0x01,0x01,0x01,0x99,0x7D,0x99,0x01,0x01,0x01,0x99,0x7D,0x99,0x01,0x01,0x01,0x99,0x7D,0x99,
	0x01,0x01,0x01,0x99,0x7D,0x99,0x01,0x01,0x01,0x99,0x7D,0x99,0x01,0x01,0x01,0x99,0x7D,0x99,0x01,0x01,
	0x01,0x03,0xFF,0xFF,0x07,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x03,0x03,0x03,0x07,0xFE,
};

const uint8_t intro_TMISSILE[] PROGMEM = {
	87,8,
	0x00,0xC0,0xFE,0xB6,0xDE,0xFA,0x6E,0xFA,0xD2,0x06,0x02,0x0A,0xC6,0x22,0xCA,0x26,0x96,0xC6,0x4E,0x16,
	0x44,0x04,0x0C,0x88,0x18,0x10,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF8,0xB8,0x38,0xB8,0xF8,
	0x58,0xF8,0x78,0xF8,0xF8,0xF8,0x38,0xF8,0x38,0xF8,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xF0,0x10,0x18,0x88,0x0C,0x04,0x44,0x16,0x4E,0xC6,0x96,0x26,0xCA,0x22,0xC6,0x0A,0x02,0x06,0xD2,0xFA,
	0x6E,0xFA,0xDE,0xB6,0xFE,0xC0,0x00,0xF0,0xDF,0x36,0xCB,0x12,0x6D,0x1B,0xEF,0xFF,0x00,0x90,0x01,0x90,
	0x41,0x80,0x41,0x10,0x81,0x10,0x91,0x00,0x20,0x02,0x00,0x00,0x00,0x7F,0xE0,0x00,0xF0,0xF8,0x18,0xB8,
	0x7C,0xBF,0x1F,0xFF,0x28,0xFF,0x1F,0x58,0x5F,0xF8,0x1E,0x58,0x5F,0xFF,0x28,0xFF,0x1F,0xFF,0xFC,0xF8,
	0x18,0x58,0xD8,0xF8,0xF0,0x00,0xE0,0x7F,0x00,0x00,0x00,0x02,0x20,0x00,0x91,0x10,0x81,0x10,0x41,0x80,
	0x41,0x90,0x01,0x90,0x00,0xFF,0xEF,0x1B,0x6D,0x12,0xCB,0x36,0xDF,0xF0,0xFF,0xBB,0xD5,0xAA,0x90,0x6A,
	0xA9,0xF6,0xFD,0xFF,0x00,0x0D,0xB2,0x5D,0xA2,0xDD,0x22,0xDD,0xA2,0x5C,0x22,0x48,0x21,0x84,0x10,0x00,
	0x21,0xFF,0x80,0x87,0x0F,0x0C,0x0F,0x0F,0x0F,0x0C,0x0F,0x0C,0x0F,0x0D,0x0D,0x0C,0x0F,0x0D,0x0D,0x0C,
	0x0F,0x0C,0x0F,0x0C,0x0D,0x0D,0x0F,0x0C,0x0D,0x0D,0x0F,0x87,0x80,0xFF,0x21,0x00,0x10,0x84,0x21,0x48,
	0x22,0x5C,0xA2,0xDD,0x22,0xDD,0xA2,0x5D,0xB2,0x0D,0x00,0xFF,0xFD,0xF6,0xA9,0x6A,0x90,0xAA,0xD5,0xBB,
	0xFF,0xFF,0xFF,0x00,0x83,0x83,0x66,0xB5,0x0F,0x0B,0xB7,0x1C,0x7E,0xBC,0xF0,0xE4,0x18,0x80,0x12,0x00,
	0x20,0x0A,0x08,0x06,0x20,0x06,0x00,0x22,0x04,0x80,0x01,0x01,0x03,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x03,0x01,0x01,0x80,
	0x04,0x22,0x00,0x06,0x20,0x06,0x08,0x0A,0x20,0x00,0x12,0x80,0x18,0xE4,0xF0,0xBC,0x7E,0x1C,0xB7,0x0B,
	0x0F,0xB5,0x66,0x83,0x83,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x80,0x10,0xA3,0x7A,0x27,0x00,0x4B,0x95,0x0E,
	0xF5,0x5F,0x07,0x00,0x00,0x00,0x10,0x01,0x00,0x20,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x1F,0x01,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x90,0x20,0x40,0x20,0x90,0x48,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x01,0x01,0x1F,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x01,0x10,0x00,0x00,0x00,
	0x07,0x5F,0xF5,0x0E,0x95,0x4B,0x00,0x27,0x7A,0xA3,0x10,0x80,0x00,0xFF,0xFF,0xFF,0xDA,0x60,0x86,0xD0,
	0x02,0x78,0x95,0x02,0xA8,0x32,0xC8,0xFF,0x00,0x80,0x00,0x00,0x00,0x00,0x01,0x04,0x00,0x00,0x02,0x00,
	0x00,0x00,0x00,0xE0,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x04,0x09,0x12,0x09,
	0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0xE0,0x00,0x00,0x00,0x00,0x02,0x00,
	0x00,0x04,0x01,0x00,0x00,0x00,0x00,0x80,0x00,0xFF,0xC8,0x32,0xA8,0x02,0x95,0x78,0x02,0xD0,0x86,0x60,
	0xDA,0xFF,0x00,0x01,0x02,0x06,0x09,0x17,0x2A,0x5D,0xAB,0x7C,0xA4,0xCA,0xFF,0x00,0x00,0x08,0x00,0x40,
	0x00,0x04,0x80,0x80,0x08,0x40,0x10,0x20,0x20,0x10,0x0F,0x00,0x00,0x00,0x00,0x1F,0x00,0x1F,0x02,0x84,
	0x9F,0x00,0x12,0x95,0x89,0x00,0x1F,0x95,0x11,0x80,0x1F,0x05,0x9A,0x01,0x1F,0x01,0x00,0x00,0x00,0x00,
	0x0F,0x10,0x20,0x20,0x10,0x40,0x08,0x80,0x80,0x04,0x00,0x40,0x00,0x08,0x00,0x00,0xFF,0xCA,0xA4,0x7C,
	0xAB,0x5D,0x2A,0x17,0x09,0x06,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,
	0x07,0x0B,0x00,0x06,0x00,0x02,0x02,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x03,0x04,0x04,0x00,0x03,0x04,0x04,0x03,0x00,0x07,0x00,0x07,0x01,0x02,0x07,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x02,
	0x00,0x06,0x00,0x0B,0x07,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

const uint8_t Y1_TMISSILE[] PROGMEM = {
	0xF1,0xFB,0x3E,0x0E,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
	0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x07,0x07,0x07,0x07,0x06,0x06,
	0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
	0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
	0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
	0x06,0x07,0x07,0x07,0x07,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
	0x06,0x06,0x06,0x0E,0x0E,0x3E,0xFB,0xF1,
};

const uint8_t CENTER_TMISSILE[] PROGMEM = {
	0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
};

const uint8_t Y6_TMISSILE[] PROGMEM = {
	0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xC0,0xE0,0xF0,0xF0,0xF8,
	0xF8,0xFC,0xE4,0xC0,0xC0,0xE4,0xFC,0xE8,0xF8,0xD0,0xB0,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
};

const uint8_t Y7_TMISSILE[] PROGMEM = {
	0x3F,0x7F,0xFC,0xF0,0xE0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xE0,0xF0,0xF8,0xF8,0xF0,0xE0,
	0xC0,0xC0,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xE0,0xF0,0xF8,0xF8,0xF0,0xE0,0xC0,0xC0,0x80,0x80,0x80,
	0x80,0x80,0xC0,0xC0,0xE0,0xF0,0xF8,0x98,0x8C,0xA4,0x92,0xCA,0xEC,0xE6,0xF7,0xF3,0x71,0xB1,0x41,0xA3,
	0x9F,0xCF,0xC7,0xE3,0xE3,0xC7,0xCF,0x9F,0xA3,0x41,0xB1,0x71,0xF3,0xF7,0xE6,0xEC,0xCA,0x92,0xA4,0x8C,
	0x98,0xF8,0xF0,0xE0,0xC0,0xC0,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xE0,0xF0,0xF8,0xF8,0xF0,0xE0,0xC0,
	0xC0,0x80,0x80,0x80,0x80,0x80,0xC0,0xC0,0xE0,0xF0,0xF8,0xF8,0xF0,0xE0,0xC0,0xC0,0x80,0x80,0x80,0x80,
	0x80,0xC0,0xC0,0xE0,0xF0,0xFC,0x7F,0x3F,
};
