// ***************************************************************************
//
//                             Main module
//
// ***************************************************************************

#include "include.h"
#include <stdio.h>

#pragma warning( disable : 4101) // unused variable

u8 pgm_read_byte(const u8* s) { return *s; }

// error code (ERR_*)
u8 ErrCode;

// soft error, can continue
jmp_buf exception_env;
void Error()
{
	if (ErrCode != ERR_FAULT) ErrCode = ERR_ERROR;
}

// fatal error, cannot continue
void Fatal()
{
	ErrCode = ERR_FAULT;
	longjmp(exception_env, 1);
}

// Edit buffer (terminated with 0)
char EditBuf[BUF_SIZE+1];

// parameters of edit buffer
Bool EditOn; // edit mode is on (entering number)
Bool PointOn; // decimal point was entered
Bool ExpOn; // entering exponent
Bool XValid; // register X is valid
u8 EditDig; // number of digits of mantissa in edit mode (including decimal point and sign)
u8 ExpDig; // number of digits of exponent in edit mode (including sign)

// clear text buffer (set to value '0')
void EditBufClear()
{
	int i;

	PointOn = False; // decimal point not entered
	EditDig = 2; // mantissa is 2 digits
	ExpDig = 0; // no exponent digits

	for (i = 0; i < BUF_SIZE-1; i++) EditBuf[i] = ' ';
	EditBuf[i] = '0';
	EditBuf[i+1] = 0;
}

int main(int argc, char* argv[])
{
	int i;
	real a, b, c;
	s32 aa, bb, cc;
	s16 x;
	double* res;
	double d;

	// exception handling
	if (setjmp(exception_env))
	{

	}

	// first initialize
	else
	{
		// initialize random generator (@TODO: use EEPROM)
		SetRndSeed(1234);

		Unit = UNIT_DEG;

		Fix = FIX_OFF;
		//EEMode = True;
		//EngMode = True;

		// initialize real numbers
		RealInit();




/*
		// test factorial
		for (i = 1; i < 1000; i++)
		{
			RealFactInt(&a, (u16)i);
			RealToEdit(&a);

			RealSetU16(&b, (u16)i);
			RealFact(&b);
			RealToEdit(&b);

			RealFactCheck(&c, (u16)i);
			x = RealGetS16(&c);

// here set breakpoint and watch x, i and EditBuf:
			x = x;
		}
		*/

		RealFromText(&a, "0.5", True);
		RealRound(&a, &a, NULL);



		RealToEdit(&a);
	}

	return 0;
}

