
// ****************************************************************************
//                                 
//                              Number editor
//
// ****************************************************************************

// numeric base
#define BASE_DEC	0	// decimal
#define BASE_BIN	1	// binary
#define BASE_OCT	2	// octal
#define BASE_HEX	3	// hexadecimal

extern u8 Base;		// numeric radix base

// text formating flags
extern Bool EEMode; // EE mode with exponent; not set together with Eng
extern Bool EngMode; // engineering technical mode, exponent is multiply of 3
extern s8 Fix; // fixed decimal places (0.. digits, or FIX_OFF=off)

#define FIX_OFF		-1	// fix decimals are off

#define MAX_DIG		(BUF_SIZE-2) // max. valid digits of mantissa for normal mode (-1.2345678901234)

// convert number into edit buffer
void RealToEdit(const real* num);

// load number from ASCIIZ text (from RAM or from ROM)
void RealFromText(real* num, const char* text, Bool rom);
