// ***************************************************************************
//
//                             Main module
//
// ***************************************************************************

#include "include.h"
#include <stdio.h>

#pragma warning( disable : 4101) // unused variable

u8 pgm_read_byte(const u8* s) { return *s; }

// error code (ERR_*)
u8 ErrCode;

// soft error, can continue
jmp_buf exception_env;
void Error()
{
	if (ErrCode != ERR_FAULT) ErrCode = ERR_ERROR;
}

// fatal error, cannot continue
void Fatal()
{
	ErrCode = ERR_FAULT;
	longjmp(exception_env, 1);
}

// Edit buffer (terminated with 0)
char EditBuf[BUF_SIZE+1];

// parameters of edit buffer
Bool EditOn; // edit mode is on (entering number)
Bool PointOn; // decimal point was entered
Bool ExpOn; // entering exponent
Bool XValid; // register X is valid
u8 EditDig; // number of digits of mantissa in edit mode (including decimal point and sign)
u8 ExpDig; // number of digits of exponent in edit mode (including sign)

// clear text buffer (set to value '0')
void EditBufClear()
{
	int i;

	PointOn = False; // decimal point not entered
	EditDig = 2; // mantissa is 2 digits
	ExpDig = 0; // no exponent digits

	for (i = 0; i < BUF_SIZE-1; i++) EditBuf[i] = ' ';
	EditBuf[i] = '0';
	EditBuf[i+1] = 0;
}

// test constant
void TestConst(real* num, const real* num2, const char* comment)
{
	real m;
	u16 dig;
	s16 dif;

	// print calculated constant
	RealToEdit(num);
	EditBuf[BUF_SIZE] = 0;
	printf("%s", EditBuf);

	// print pre-calculated constant from ROM
	RealConst(&m, num2);
	RealToEdit(&m);
	printf(" / %s", EditBuf);

	// m1/m2 - 1
	RealDiv(&m, num, &m);
	RealAdd(&m, &m, &RealConstM1);
	RealAbs(&m);
	
	// equals
	if (RealIsZero(&m))
	{
		printf(" = OK ... %s\n", comment);
		return;
	}

	// calculate number of equal digits
	RealLog10(&m);
	RealRound(&m);
	RealAbs(&m);

	// error digits
	dig = RealGetU16(&m);
	dif = R_MANT_DIG - dig;

	if (dif == 0)
		printf(" = OK 0 ... %s\n", comment);
	else
		printf(" = ERR %d ... %s\n", dif, comment);
}

int main(int argc, char* argv[])
{
	int i;

	// exception handling
	if (setjmp(exception_env))
	{

	}

	// first initialize
	else
	{
		// initialize random generator (@TODO: use EEPROM)
		SetRndSeed(1234);

		Unit = UNIT_DEG;

		Fix = FIX_OFF;
		//EEMode = True;
		//EngMode = True;

		// initialize real numbers
		RealInit();

		RealToEdit(&RealTempExp[R_DECEXP+2]);


		// test constants
		TestConst(&RealConstLn2, &RealTempLn2, "ln(2)");	// ln(2)
		TestConst(&RealConstRLn2, &RealTempRLn2, "1/ln(2)"); // 1/ln(2)
		TestConst(&RealConstLn10, &RealTempLn10, "ln(10)"); // ln(10)
		TestConst(&RealConstRLn10, &RealTempRLn10, "1/ln(10)"); // 1/ln(10)
		TestConst(&RealConstLog2, &RealTempLog2, "log(2)"); // log(2)
		TestConst(&RealConstExpMax, &RealTempExpMax, "max. exp(x)"); // max. exp(x)
		TestConst(&RealConstExpMin, &RealTempExpMin, "min. exp(x)"); // min. exp(x)
		TestConst(&RealConstEul, &RealTempEul, "Eul");	// Eul
		TestConst(&RealConstPi05, &RealTempPi05, "pi/2"); // pi/2
		TestConst(&RealConstPi, &RealTempPi, "pi"); // pi
		TestConst(&RealConstPi2, &RealTempPi2, "pi*2"); // pi*2
		TestConst(&RealConstLnPi22, &RealTempLnPi22, "ln(pi*2)/2"); // ln(pi*2)/2
		TestConst(&RealConst180Pi, &RealTemp180Pi, "180/pi"); // 180/pi
		TestConst(&RealConstPi180, &RealTempPi180, "pi/180"); // pi/180
		TestConst(&RealConst200Pi, &RealTemp200Pi, "200/pi"); // 200/pi
		TestConst(&RealConstPi200, &RealTempPi200, "pi/200"); // pi/200

		for (i = 0; i < R_DECEXP*2+1; i++)
			TestConst(&RealConstExp[i], &RealTempExp[i], "exp"); // decimal exponents (index R_DECEXP = number '1') (33)

		for (i = 0; i < R_MANT_DIG+2; i++)
			TestConst(&RealConstRound[i], &RealTempRound[i], "round"); // rounding corrections (0.5, 0.05,...) (double: 23)

		for (i = 0; i < FACT_COEFF; i++)
			TestConst(&RealConstFactA[i], &RealTempFactA[i], "fact"); // factorial coefficients (12)
	}

	return 0;
}

