// ***************************************************************************
//
//                                Includes
//
// ***************************************************************************

// ----------------------------------------------------------------------------
//                                Configuration
// ----------------------------------------------------------------------------

#define BASE_TYPE	1		// type of base integer number (1 = byte u8, 2 = word u16, 4 = dword u32)

// real number format (internal format of expression calculator)
//   xxx bits mantissa (with hidden bit "1")
//   yyy bits exponent (0=number is zero)
//   1 bits sign
#define R_BYTES		24		// size of number in bytes
#define R_EXP_BITS	24		// number of bits per exponent (2..32 bits)
//#define R_COMP_BIAS		// flag - uncomment this to use compatible exponent bias (0x7fff, or more optimal 0x8000 otherwise)

// memory number format (must not be larger than internal format)
#define M_BYTES		10		// size of number in bytes (19.3 digits)
#define M_EXP_BITS	16		// number of bits per exponent (1..32 bits) (exp. max. 9863)
//#define M_COMP_BIAS			// flag - uncomment this to use compatible exponent bias (0x7fff, or more optimal 0x8000 otherwise)

// variables
#define USER_NUM	100		// number of user variables

#define GENCONST			// uncomment this to generate constants instead of use tables

// ----------------------------------------------------------------------------
//                                Base data types
// ----------------------------------------------------------------------------

typedef signed char s8;
typedef unsigned char u8;
typedef signed short s16;
typedef unsigned short u16;
typedef signed long int s32;
typedef unsigned long int u32;
typedef signed long long int s64;
typedef unsigned long long int u64;

typedef unsigned char Bool;
#define True 1
#define False 0

// ----------------------------------------------------------------------------
//                               Constants
// ----------------------------------------------------------------------------

#define	B0 ((u8)1<<0)
#define	B1 ((u8)1<<1)
#define	B2 ((u8)1<<2)
#define	B3 ((u8)1<<3)
#define	B4 ((u8)1<<4)
#define	B5 ((u8)1<<5)
#define	B6 ((u8)1<<6)
#define	B7 ((u8)1<<7)
#define	B8 ((u16)1<<8)
#define	B9 ((u16)1<<9)
#define	B10 ((u16)1<<10)
#define	B11 ((u16)1<<11)
#define	B12 ((u16)1<<12)
#define	B13 ((u16)1<<13)
#define	B14 ((u16)1<<14)
#define	B15 ((u16)1<<15)
#define B16 ((u32)1<<16)
#define B17 ((u32)1<<17)
#define B18 ((u32)1<<18)
#define	B19 ((u32)1<<19)
#define B20 ((u32)1<<20)
#define B21 ((u32)1<<21)
#define B22 ((u32)1<<22)
#define B23 ((u32)1<<23)
#define B24 ((u32)1<<24)
#define B25 ((u32)1<<25)
#define B26 ((u32)1<<26)
#define B27 ((u32)1<<27)
#define B28 ((u32)1<<28)
#define B29 ((u32)1<<29)
#define B30 ((u32)1<<30)
#define B31 ((u32)1<<31)

#define BIT(pos) (1<<(pos))

// error type
#define ERR_OK		0	// no error
#define ERR_ERROR	1	// soft error
#define ERR_FAULT	2	// hard error

// error code (ERR_*)
extern u8 ErrCode;

// soft error, can continue
void Error();

// fatal error, cannot continue
void Fatal();

#define BUF_SIZE	16	// size of edit buffer

// Edit buffer (terminated with 0)
extern char EditBuf[BUF_SIZE+1];

// parameters of edit buffer
extern Bool EditOn; // edit mode is on (entering number)
extern Bool PointOn; // decimal point was entered
extern Bool ExpOn; // entering exponent
extern Bool XValid; // register X is valid
extern u8 EditDig; // number of digits of mantissa in edit mode (including decimal point and sign)
extern u8 ExpDig; // number of digits of exponent in edit mode (including sign)

// clear text buffer (set to value '0')
void EditBufClear();

// ----------------------------------------------------------------------------
//                                   Includes
// ----------------------------------------------------------------------------

u8 pgm_read_byte(const u8* s);

#define PROGMEM

#include <setjmp.h>	// exception long jump

#include "../lib/real.h"	// real numbers (floating-point)
#include "../lib/decnum.h"	// decode numbers
