
// ****************************************************************************
//
//                         Page PWM - function generator
//
// ****************************************************************************
// Output: PC5, Timer 2 channel 1 mapping 2
// Using PWM period 128. System clock = 48 MHz, sample rate = 48 MHz/128 = 375 kHz
// From a frequency of 10 kHz, signal amplitude attenuation must be taken into
// account due to the RC filter used. At a frequency of 30 kHz, the amplitude
// drops to approximately 50%.

#ifndef _PAGE_PWM_H
#define _PAGE_PWM_H

#ifdef __cplusplus
extern "C" {
#endif

#define PWM_GPIO	PC5		// PWM output pin
#define TONE_NUM_PWM	26		// number of PWM decimal tones (frequency 1Hz..30kHz)
#define PWM_LOOP	128		// length of PWM loop (minimal value is 110) ... hardcoded in page_asm.S

// PWM mode set
enum {
	PWMSET_TONE_SIN = 0,		// decimal tones, sine
	PWMSET_TONE_TRI,		// decimal tones, triangle
	PWMSET_TONE_SAW,		// decimal tones, saw
	PWMSET_NOTE_SIN,		// notes, sine
	PWMSET_NOTE_TRI,		// notes, triangle
	PWMSET_NOTE_SAW,		// notes, saw

	PWMSET_NUM			// number of sets
};

// PWM signal shape
enum {
	PWMSHAPE_SIN = 0,		// sine
	PWMSHAPE_TRI,			// triangle
	PWMSHAPE_SAW,			// saw
};

// PWM Timer 2 interrupt handler - Sine ... handler located at page_asm.S
HANDLER void PWM_Handler_Sine();

// PWM Timer 2 interrupt handler - Triangle ... handler located at page_asm.S
HANDLER void PWM_Handler_Tri();

// PWM Timer 2 interrupt handler - Saw ... handler located at page_asm.S
HANDLER void PWM_Handler_Saw();

// Page PWM (returns key PREV/NEXT)
u8 PagePWM();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_PWM_H
