
// ****************************************************************************
//
//                         Page NG - noise generator
//
// ****************************************************************************
// Output: PC4, Timer 1 channel 4 mapping 0
// Random widths of LOW and HIGH pulse levels can be set in the range from 2us to 50ms.
// The value of 2us cannot be set simultaneously for both LOW and HIGH levels.

#ifndef _PAGE_NG_H
#define _PAGE_NG_H

#ifdef __cplusplus
extern "C" {
#endif

#define NG_GPIO		PC4		// NG output pin

#define NG_DMA		4	// used DMA channel (with TIM1_CH4 data request)

// setup timer (shared with REP page)
//  reppage ... use REP page
void NG_SetupTimer(Bool reppage);

// Page NG (returns key PREV/NEXT)
u8 PageNG();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_NG_H
