
// ****************************************************************************
//
//                         Page LA - logic analyzer
//
// ****************************************************************************
// Inputs: PD2 channel 1, PD3 channel 2
// Using DMA transfer, DMA channel 2 (with TIM2_UP data request).
// Using Timer 2 update to clock DMA transfer.
// Control: Time base selector selects 1 or 2 channel mode.
// Hold button short press - switch free-running/hold mode.
// Hold button long press - activate Auto mode, waits for edge on the channel 1.

#ifndef _PAGE_LA_H
#define _PAGE_LA_H

#ifdef __cplusplus
extern "C" {
#endif

// LA time base
enum {
	LA_BASE1_1US = 0,	// 1 channel, time base 1us, sample rate 8 MHz, total time 128us
	LA_BASE1_10US,		// 1 channel, time base 10us, sample rate 800 kHz, total time 1.28ms
	LA_BASE1_100US,		// 1 channel, time base 100us, sample rate 80 kHz, total time 12.8ms
	LA_BASE1_1MS,		// 1 channel, time base 1ms, sample rate 8 kHz, total time 128ms
	LA_BASE1_10MS,		// 1 channel, time base 10ms, sample rate 800 Hz, total time 1.28s

	LA_BASE2_1US,		// 2 channels, time base 1us, sample rate 8 MHz, total time 64us
	LA_BASE2_10US,		// 2 channels, time base 10us, sample rate 800 kHz, total time 640us
	LA_BASE2_100US,		// 2 channels, time base 100us, sample rate 80 kHz, total time 6.4ms
	LA_BASE2_1MS,		// 2 channels, time base 1ms, sample rate 8 kHz, total time 64ms
	LA_BASE2_10MS,		// 2 channels, time base 10ms, sample rate 800 Hz, total time 640ms

	LA_BASE_NUM
};

#define LA_BASE_FIRST2	LA_BASE2_1US	// first base with 2 channels

// LA run mode
enum {
	LA_MODE_FREE = 0,	// free fast running
	LA_MODE_HOLD,		// hold last sample
	LA_MODE_AUTO,		// auto start

	LA_MODE_NUM
};

// LA input pins
#define LA_GPIO1	PD2		// LA input pin, channel 1
#define LA_GPIO2	PD3		// LA input pin, channel 2

#define LA_DMA	2	// used DMA channel (with TIM2_UP data request)

// Page LA (returns key PREV/NEXT)
u8 PageLA();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_LA_H
