
// ****************************************************************************
//
//                         Page I2C - I2C scanner
//
// ****************************************************************************
// Pins, software driver: PD3 I2C-SDA, PD2 I2C-SCL
// If you see too many detected I2C addresses, the SDA signal is probably shorted to GND.
// Note: I2C mapping 4-7 is not working, cannot use pins PD1 and PB3 with hardware I2C.

#ifndef _PAGE_I2C_H
#define _PAGE_I2C_H

#ifdef __cplusplus
extern "C" {
#endif

#define I2C_SDA_GPIO	PD3		// I2C SDA GPIO
#define I2C_SCL_GPIO	PD2		// I2C SCL GPIO

#define I2C_SDA_PORT	GPIO_PORT(I2C_SDA_GPIO)	// I2C port GPIO_t* with SDA
#define I2C_SCL_PORT	GPIO_PORT(I2C_SCL_GPIO)	// I2C port GPIO_t* with SCL
#define I2C_SDA_PIN	GPIO_PIN(I2C_SDA_GPIO)	// I2C pin index with SDA
#define I2C_SCL_PIN	GPIO_PIN(I2C_SCL_GPIO)	// I2C pin index with SCL

// Page I2C (returns key PREV/NEXT)
u8 PageI2C();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_I2C_H
