
// ****************************************************************************
//
//                          Page I - current meter
//
// ****************************************************************************
// I input: PD5, ADC5, input resistor: 1ohm/2W, input range 0..1A, minimal measured current 1mA, relative error 5%, absolute error 3mA
// ADC clock divider is set to 750kHz. One ADC clock cycle is 1.33us.
// I sampling time is (6) 71.5 cycles. One sample is 71.5+12.5=84 ADC clock cycles = 112us.

// Current measurement is performed against the GND conductor  therefore, it
// is not possible to measure current in any branch, but only to measure
// consumption in the ground branch ("low-side" current).

#ifndef _PAGE_I_H
#define _PAGE_I_H

#ifdef __cplusplus
extern "C" {
#endif

#define I_ADC	5		// I input ADC channel
#define I_GPIO	PD5		// I GPIO

#define I_R	1		// I resistor

#define I_SHIFT 12		// UI shift
#define I_K	((u32)(I_R<<I_SHIFT))	// I input multiplication ratio << 12

extern s32 IState;		// I current in mA
extern s32 ITare;		// I current tare in mA

// I update (takes 500ms)
void I_Update();

// I initialize (initializes BAT measure, too)
void I_Init();

// I terminate (terminates BAT measure, too)
void I_Term();

// I display tare ("tare 12mA")
void I_DispTare();

// I tare
void I_Tare();

// Page I (returns key PREV/NEXT)
u8 PageI();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_I_H
