
// ****************************************************************************
//
//                         Page GEN - frequency generator
//
// ****************************************************************************
// Output: PC4, MCO, Timer 1 channel 4 mapping 0
// Note: The device is sensitive to signal line routing. When generating
// high-frequency signals (16 MHz and above, especially at 5V), the processor
// may crash due to interference between signals on the PCB.

#ifndef _PAGE_GEN_H
#define _PAGE_GEN_H

#ifdef __cplusplus
extern "C" {
#endif

#define GEN_GPIO	PC4		// GEN output pin

// Generated tones:
// - 10 octaves with index 0..9
// - 12 tones in each octave: C, C#, D, D#, E, F, F#, G, G#, A, A#, B
// - total 120 tones
#define OCTAVE_NUM	10		// number of generated octaves
#define NOTE_NUM	(12*OCTAVE_NUM)	// total number of generated notes (=120, index 0..119)
#define NOTE_DEF	57		// default note (57 = A4, 440 Hz)
#define TONE_NUM	47		// number of decimal tones
#define TONE_DEF	16		// default tone (1 kHz)

// generator tone set
enum {
	GENSET_TONE = 0,	// decimal tones
	GENSET_NOTE,		// notes

	GENSET_NUM		// number of sets
};

// note frequencies in Hz * 65536
extern const u32 NoteFreq[NOTE_NUM];

// tone frequencies in Hz
extern const u32 ToneFreq[TONE_NUM];

// note name
extern const char* const NoteName[12];

// display GEN tone - used also by PWM page
void GEN_DispTone(int set, int tone);

// Page GEN (returns key PREV/NEXT)
u8 PageGEN();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_GEN_H
