
// ****************************************************************************
//
//                        Page FFT - spectrum analyzer
//
// ****************************************************************************
// Input: PD2 - A3, Timings: Timer 1
// For spectral analysis, 16 bands with logarithmic distribution are used,
//   with 2nd order IIR (biquad) filters.
// ADC sampling rate 44100 Hz (top frequency 16 kHz).
//
// 16-Band Logarithmic Spectrum Analyzer with peaks, attack and decay. Hold mode.
// Frequency range 16Hz - 16kHz. Display refresh 22FPS.
// 3 display modes: curve line, smooth bars, peak bars.

#ifndef _PAGE_FFT_H
#define _PAGE_FFT_H

#ifdef __cplusplus
extern "C" {
#endif

// FFT modes
enum {
	FFT_MODE_FILL = 0,	// filled line (smooth bars)
	FFT_MODE_BARS,		// bars + peaks
	FFT_MODE_LINE,		// simple line (curve)

	FFT_MODE_NUM		// number of modes
};

#define FFT_DMA	1	// used DMA channel (with ADC1 data request)

// Add samples to filters
void NOFLASH(FFT_AddSamples)();

// Page FFT (returns key PREV/NEXT)
u8 PageFFT();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_FFT_H
