
// ****************************************************************************
//
//                         Page DUT - duty cycle
//
// ****************************************************************************
// Input: PD2, Timer 1 channel 1 mapping 0
//   0 ... PC5:ETR, >>> PD2:CH1 <<<<, PA1:CH2, PC3:CH3, PC4:CH4, PC2:BKIN, PD0:CH1N, PA2:CH2N, PD1:CH3N
// Measure range: 4Hz .. 400kHz

#ifndef _PAGE_DUT_H
#define _PAGE_DUT_H

#ifdef __cplusplus
extern "C" {
#endif

// interrupt on signal edge ... handler located at page_asm.S
HANDLER void NOFLASH(DUT_Handler)();

// DUT initialize (shared with PH and REP pages)
//  page ... 0=DUT page, 1=PH page, 2=REP page falling, 3=REP page rising
void DUT_Init(int page);

// DUT terminate (shared with PH and REP pages; IN_GPIO stays in IN_PD mode)
void DUT_Term();

// Page DUT (returns key PREV/NEXT)
u8 PageDUT();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_DUT_H
