
// ****************************************************************************
//
//                         Page DAC - voltage regulator
//
// ****************************************************************************
// Output: PC5, Timer 2 channel 1 mapping 2
// Using PWM period 100. System clock = 48 MHz, sample rate = 48 MHz/100 = 480kHz

#ifndef _PAGE_DAC_H
#define _PAGE_DAC_H

#ifdef __cplusplus
extern "C" {
#endif

#define DAC_GPIO	PC5		// PWM output pin
#define DAC_LOOP	100		// DAC loop length
#define DAC_DEF		(DAC_LOOP/2)	// DAC default level

// DAC mode set
enum {
	DACSET_FAST,	// DAC 480kHz (fast speed, prescaler = 1, sample rate 480 kHz - voltage RC output)
	DACSET_MED,	// DAC 1kHz (medium speed, prescaler = 480, sample rate 1 kHz - engine control)
	DACSET_SLOW,	// DAC 50Hz (slow speed, prescaler = 9600, sample raze 50 Hz - dimmer control)

	DACSET_NUM	// number of sets
};

// Page DAC (returns key PREV/NEXT)
u8 PageDAC();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_DAC_H
