
// ****************************************************************************
//
//                         Page COM - UART communication
//
// ****************************************************************************
// Pins: PD3 USART2-RX, PD2 USART2-TX, mapping 3
//	3 ... PD2:TX, PD3:RX, PA0:CTS, PA1:RTS

#ifndef _PAGE_COM_H
#define _PAGE_COM_H

#ifdef __cplusplus
extern "C" {
#endif

#define COM_SCREENH	8	// number of rows of the screen buffer (must be power of 2)
#define COM_SCREENW	16	// number of positions per screen row

// screen buffer
// - The structure must match the definition in page_asm.S.
typedef struct {
	s32	row;			// 0x00: current row 
	union {
		u8	len[COM_SCREENH];	// 0x04: length of row (0xff = not initialized yet)
		u32	len32[COM_SCREENH/4];
	};
	char	buf[COM_SCREENW*COM_SCREENH]; // 0x0c (size 128 = 0x80): screen data
					// 0x8C
} sCOMScreen;
STATIC_ASSERT(sizeof(sCOMScreen) == 0x8C, "Incorrect sCOMScreen!");

// screen buffer
#define COMScreen	((sCOMScreen*)Buf)		// interrupt screen buffer
#define COMScreen2	((sCOMScreen*)&Buf[0x100])	// draw screen buffer (snapshot of interrupt screen buffer)

// USART2 interrupt on receive character ... handler located at page_asm.S
HANDLER void COM_Handler();

// Page COM (returns key PREV/NEXT)
u8 PageCOM();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_COM_H
