
// ****************************************************************************
//
//                        Page BAT - battery
//
// ****************************************************************************
// ADC clock divider is set to 64, 48MHz/64 = 750kHz. One ADC clock cycle is 1.33us.
// BAT sampling time is (6) 71.5 cycles. One sample is 71.5+12.5=84 ADC clock cycles = 112us.
// Reference internal voltage 1.2V; datasheet: Vrefint = 1.18..1.22, tolerance +-1.7%.
// Precision 2%.

#ifndef _PAGE_BAT_H
#define _PAGE_BAT_H

#ifdef __cplusplus
extern "C" {
#endif

#define REF_VOLTAGE	1200		// reference voltage in [mV]
#define REF_ADC		8		// ADC channel of reference voltage

#define SUPPLY_NUM	8		// size of supply voltage buffer

extern int Supply;		// supply voltage in [mV] (-1 = not yet measured)

// update battery supply voltage (takes 100ms)
void BAT_Update();

// BAT initialize, initialize ADC single conversion mode, set ADC clock to 750kHz
void BAT_Init();

// BAT terminate
void BAT_Term();

// Page BAT (returns key PREV/NEXT)
u8 PageBAT();

#ifdef __cplusplus
}
#endif

#endif // _PAGE_BAT_H
