
#ifdef __cplusplus
extern "C" {
#endif

#define VERTXT		"v1.0"		// firmware version

// - LA page requires 1024 bytes of the buffer.
// - OSC page requires 2048 bytes of the buffer.
// - FFT page requires 4096 bytes of the buffer.
// - NG page requires 4096 bytes of the buffer.
// - REP page requires 4096 bytes of the buffer.
#define BUF_SIZE	((4096 + 100)/4)	// size of common data buffer in u32 ... required minimum is 4096 bytes ... + some reserve
#define BUF_SIZE_MAX	(BUF_SIZE + FRAMESIZE/4) // max. size of common data buffer in u32, including display frame buffer

// common data buffer (including display graphics buffer FrameBuf)
//  In addition to space for data, the common data buffer also contains
//  the display's graphics buffer. In urgent situation, this can also be
//  used as a data buffer, but it is necessary to take into account that
//  the display content will need to be refreshed after use.
extern ALIGNED u32 Buf[BUF_SIZE_MAX];
#define FrameBuf ((u8*)&Buf[BUF_SIZE])	// pointer to display graphics buffer in common data buffer

#define IN_GPIO		PD2	// input 1 pin (OSC/LA/FT/FFT)
#define IN_ADC		3	// input 1 ADC (OSC/FFT)
#define IN2_GPIO	PD3	// input 2 pin (OSC/LA/FT/FFT)
#define IN2_ADC		4	// input 2 ADC (OSC/FFT)

#define TITLE_H		16	// title height (2 lines frame + 12 lines text + 2 lines frame)

#define ROW0_Y		2	// info row 0, height 12 lines + 4 lines frame
#define ROW1_Y		16	// row 1 ... top big row
#define ROW2_Y		(16+12)	// row 2 (= 28) ... middle big row
#define ROW3_Y		(16+2*12) // row 3 (= 40) ... bottom big row
#define ROW4_Y		(16+3*12) // row 4 (= 52)

#define SMALL_Y		10	// shift Y to print small text after big text

// pages
enum {
	PAGE_U = 0,	// page U - voltage meter
	PAGE_I,		// page I - current meter
	PAGE_P,		// page P - power meter
	PAGE_CH,	// page CH - charging meter
	PAGE_R,		// page R - resistance meter
	PAGE_C,		// page C - capacitance meter
	PAGE_L,		// page L - inductance meter
	PAGE_OSC,	// page OSC - oscilloscope
	PAGE_LA,	// page LA - logic analyzer
	PAGE_GEN,	// page GEN - frequency generator
	PAGE_PWM,	// page PWM - function generator
	PAGE_DAC,	// page DAC - voltage regulator
	PAGE_FT,	// page FT - frequency and period meter
	PAGE_FFT,	// page FFT - spectrum analyzer
	PAGE_CNT,	// page CNT - counter
	PAGE_TIM,	// page TIM - timer
	PAGE_TG,	// page TG - time gate
	PAGE_DUT,	// page DUT - duty cycle
	PAGE_COM,	// page COM - UART communication
	PAGE_I2C,	// page I2C - I2C scanner
	PAGE_NG,	// page NG - noise generator
	PAGE_NA,	// page NA - noise analog
	PAGE_PH,	// page PH - pulse histogram
	PAGE_REP,	// page REP - repeater
	PAGE_BAT,	// page BAT - battery

	PAGE_NUM	// number of pages
};

#define PAGE_DEF	PAGE_U	// default page
extern int Page;	// current selected page
extern int PageX;	// X coordinate of page title

// vector table in Flash
extern const void _vector_base;

// vector table in RAM
extern __attribute__((section(".ram_vectors"))) irq_handler_t VectorTab[IRQ_NUM];

// page function
typedef u8 (*pPageFnc)(void);

// select font 8x8
void SelFont8();

// select font 8x12
void SelFont12();

// display current page header
void PageHead();

// setup IRQ priorities to default state
void IrqPriorDef();

// Tare message
void TareMsg();

#ifdef __cplusplus
}
#endif
