
// ****************************************************************************
//                                 
//                        Project library configuration
//
// ****************************************************************************

#ifndef _CONFIG_H
#define _CONFIG_H

// Pre-set defines (use #if to check):
//	target MCU	MCU serie	MCU class	MCU subclass
//	CH32V002x4	CH32V002	CH32V0		CH32V00X
//	CH32V003x4	CH32V003	CH32V0
//	CH32V004x6	CH32V004	CH32V0		CH32V00X
//	CH32V005x6	CH32V005	CH32V0		CH32V00X
//	CH32V006x4	CH32V006	CH32V0		CH32V00X
//	CH32V006x8	CH32V006	CH32V0		CH32V00X
//	CH32V007x8	CH32V007	CH32V0		CH32V00X
//	CH32X033x8	CH32V033	CH32V0		CH32V03X
//	CH32X035x7	CH32V035	CH32V0		CH32V03X
//	CH32X035x8	CH32V035	CH32V0		CH32V03X
//	CH32V103x6	CH32V103	CH32V1
//	CH32V103x8	CH32V103	CH32V1
//	CH32L103x8	CH32L103	CH32V1

// FLASHSIZE ... Flash size in bytes
// RAMSIZE ... RAM size in bytes
// STACKSIZE ... Stack size in bytes

// ----------------------------------------------------------------------------
//                             Device setup
// ----------------------------------------------------------------------------

#define DISP_I2C_ADDR	0x3C	// display I2C address
#define DISP_SDA_GPIO	PC1	// display gpio with SDA
#define DISP_SCL_GPIO	PC2	// display gpio with SCL
#define DISP_I2C_MAP	0	// hardware display driver: I2C mapping
#define DISP_WAIT_CLK	5	// software display driver: number of I2C wait clock (0 or more) ... DispUpdate() takes 2:10ms, 3-4:11ms, 10:26 ms
#define DISP_SPEED_HZ	750000	// hardware display driver: I2C speed in Hz ... DispUpdate() takes 3M:4ms, 2M:6ms, 1M:11ms, 500K:20ms
#define USE_DISP	1	// 1=use software display driver, 2=use hardware display driver (0=no driver)

#define SYSTICK_KEYSCAN	1	// 1=call KeyScan() function from SysTick system timer

// ----------------------------------------------------------------------------
//                            Library modules
// ----------------------------------------------------------------------------

#define USE_CRC		1	// 1=use CRC library
#define USE_DECNUM	1	// 1=use decode number
#define USE_FAT		0	// 1=use FAT filesystem
#define USE_RAND	1	// 1=use random number generator

// ----------------------------------------------------------------------------
//                             SDK modules
// ----------------------------------------------------------------------------

#define USE_ADC		1	// 1=use ADC peripheral
#define USE_DMA		1	// 1=use DMA peripheral
#define USE_FLASH	1	// 1=use Flash programming
#define USE_I2C		1	// 1=use I2C peripheral
#define USE_IRQ		1	// 1=use IRQ interrupt support
#define USE_PWR		1	// 1=use power control
#define USE_SPI		1	// 1=use SPI peripheral
#define USE_TIM		1	// 1=use timers
#define USE_USART	1	// 1=use USART peripheral

// ----------------------------------------------------------------------------
//                            Clock Setup
// ----------------------------------------------------------------------------

// Frequency of HSE external oscillator
#define HSE_VALUE	24000000	// CH32V0, CH32L103: 4..25 MHz

// frequency of HSI internal oscillator 24MHz
#define HSI_VALUE	24000000

// System clock source: 1=HSI, 2=HSE, 3=HSE_Bypass, 4=PLL_HSI, 5=PLL_HSE, 6=PLL_HSE_Bypass, 7=PLL_HSI/2, 8=PLL_HSE/2, 9=PLL_HSE_Bypass/2
#define SYSCLK_SRC	5

// PLL multiplier
#define PLLCLK_MUL	2		// only *2 supported; 24 MHz * 2 = 48 MHz

// System clock divider: 1, 2, 3, 4, 5, 6, 7, 8, 16, 32, 64, 128, 256 (default 1)
#define SYSCLK_DIV	1

// ADC clock divider: (1,) 2, 4, 6, 8, 12, 16, 24, 32, 48, 64, 96, 128 (default 1 or 2)
#define ADCCLK_DIV	48		// CH32V0: max. 24 MHz (48 / 48 = 1 MHz)

// number of HCLK clock cycles per 1 us (used with Wait functions)
// - If you want to change frequency of system clock run-time, use a variable instead of constant.
#define HCLK_PER_US	48

// increment of system time in [ms] on SysTick interrupt (0=do not use SysTick interrupt)
#define SYSTICK_MS	20

// ----------------------------------------------------------------------------
//                          Peripheral clock enable
// ----------------------------------------------------------------------------

#define ENABLE_SRAM	1		// SRAM enable
#define ENABLE_FLASH	1		// FLASH enable
#define ENABLE_WWDG	0		// Window watchdog enable
#define ENABLE_PWR	1		// Power module enable
#define ENABLE_AFI	1		// I/O auxiliary function enable
#define ENABLE_PA	1		// PA port enable
#define ENABLE_PB	1		// PB port enable
#define ENABLE_PC	1		// PC port enable
#define ENABLE_PD	1		// PD port enable
#define ENABLE_ADC1	1		// ADC1 module enable
#define ENABLE_TIM1	1		// TIM1 module enable
#define ENABLE_TIM2	1		// TIM2 module enable
#define ENABLE_TIM3	0		// TIM3 module enable
#define ENABLE_SPI1	1		// SPI1 module enable
#define ENABLE_USART1	1		// USART1 module enable
#define ENABLE_USART2	1		// USART1 module enable
#define ENABLE_I2C1	1		// I2C1 module enable
#define ENABLE_DMA1	1		// DMA1 module enable

#endif // _CONFIG_H
