#include "../include.h"

// format: Attribute compressed 8x8/2 colors 8-bit paletted pixel graphics
// compression ratio: 15%
// required memory: 8320 B pixels, 2080 B attributes (10400 B total, unpacked 66560 B)
// image width: 320 pixels
// image height: 208 lines
// image pixels pitch: 40 bytes
// image attribute pitch: 80 bytes
const u16 ImgAttr5_Pal[256] __attribute__ ((aligned(4))) = {
	0xE861, 0xC041, 0x8821, 0x1041, 0x0020, 0x6412, 0x532E, 0x95D9, 0x0331, 0x028D, 0x9E3A, 0x465E, 0x2C75, 0x8556, 0x0497, 0x03F3, 
	0x09C8, 0x3EBF, 0x3DDB, 0x3538, 0x232F, 0x4EBF, 0x428A, 0x161E, 0x157A, 0x124A, 0x2BD1, 0x4EBE, 0x4EFF, 0x56FF, 0x3208, 0x3E3C, 
	0x4EBD, 0x3F1F, 0x0945, 0x4EFE, 0x575F, 0x2145, 0x08A2, 0x5FDF, 0x67FF, 0x5570, 0x12C7, 0x44EE, 0x0C4A, 0x164E, 0x1F30, 0x5611, 
	0x1B89, 0x442B, 0x0A44, 0x3CEB, 0x348A, 0x3389, 0x44AB, 0x4CEC, 0x55AD, 0x4D2C, 0x44EB, 0x4CAB, 0x19C4, 0x2B27, 0x2245, 0x1923, 
	0x55AB, 0x4469, 0x4CAA, 0x44E9, 0x44A9, 0x4D2A, 0x664D, 0x2AC5, 0x4CEA, 0x4408, 0x3BC8, 0x556A, 0x4CE9, 0x3366, 0x4CA9, 0x0861, 
	0x18E3, 0x4D29, 0x55AA, 0x7F0E, 0x65EB, 0x5DEA, 0x08A1, 0x5DAA, 0x65AB, 0x5D2A, 0x4D27, 0x764C, 0x5CEA, 0x652B, 0x4CC7, 0x6DEB, 
	0x4C48, 0x648B, 0x656A, 0x6DAB, 0x5CA9, 0x4466, 0x1141, 0x4BA7, 0x3303, 0xDF9A, 0x2A22, 0xD736, 0x42A4, 0xB5F2, 0x2985, 0xEFF7, 
	0xE7B6, 0xCEB5, 0xEFF6, 0x52A8, 0x844D, 0xAD71, 0x6329, 0x9CEF, 0x5B03, 0xEFB7, 0xC633, 0xE791, 0xEFB5, 0xEFB6, 0x3A06, 0xF7F8, 
	0xADE2, 0x6B83, 0xDF0F, 0x73AB, 0x9D22, 0x8423, 0xEF57, 0xDF15, 0xFFF2, 0xDED4, 0xFFD4, 0xFFFA, 0xCE4F, 0xB58E, 0x18A1, 0x49E1, 
	0xFE02, 0x6AA1, 0x5A21, 0xFE45, 0xEDE5, 0x6AA2, 0x2101, 0xCCA1, 0xF5A2, 0x8322, 0x7AE2, 0x9BA3, 0xEDA5, 0xD525, 0xA3A1, 0xE522, 
	0xBC22, 0xCCA2, 0xC462, 0x49A1, 0x9362, 0xED64, 0xFDE5, 0xA3C3, 0xCCC4, 0xF5A5, 0xE565, 0xBC64, 0xAC24, 0xD4A1, 0xB3E1, 0xFD82, 
	0xED22, 0xD4A2, 0x51E1, 0x72A1, 0x6A61, 0xED65, 0xCC21, 0xE4C2, 0x82C1, 0x9B61, 0xCC62, 0xCC63, 0xE4C4, 0xBC23, 0xED24, 0xFDA5, 
	0xF565, 0x9B01, 0x3920, 0x4161, 0xB360, 0xBB80, 0xCBC0, 0xDC40, 0xFCE1, 0xDC43, 0x6A21, 0xB3A2, 0x59A1, 0xAB62, 0x8261, 0xC361, 
	0x92A1, 0xB321, 0x30E0, 0x9260, 0x71E0, 0xAAC1, 0x8A61, 0x7A21, 0x8A20, 0x61A0, 0xB2C1, 0x4920, 0xBB21, 0xCB62, 0x28E1, 0xA260, 
	0x79E0, 0x9A61, 0x71E1, 0x9220, 0x81E0, 0x71A0, 0x5940, 0x38E0, 0x79E1, 0x28A0, 0x9A20, 0x89E0, 0x79A0, 0x9221, 0xA200, 0x91E0, 
	0x6140, 0x81A0, 0x91A0, 0x7140, 0x40C0, 0x30A0, 0x9160, 0x8940, 0x38A0, 0x58C0, 0x1840, 0x2040, 0x68A0, 0x3840, 0x4840, 0x5820, 
};

const u8 ImgAttr5_Attr[2080] __attribute__ ((aligned(4))) = {
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x35, 0x23, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x0C, 0x1C, 
	0x6E, 0x1C, 0xDB, 0x23, 0xE7, 0x95, 0xE7, 0xE0, 0xCC, 0x1C, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1C, 0x24, 0x2A, 0x2F, 0x19, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x35, 0x1C, 0x47, 0x45, 0x2A, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1A, 0x1C, 0x6E, 0x1C, 0xE6, 0x23, 0xE7, 0xB3, 
	0xF4, 0xE0, 0xF4, 0xE0, 0xF8, 0xE0, 0x00, 0xE0, 0xF4, 0xD7, 0x1E, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 
	0x14, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x31, 0x1C, 0x31, 0x3A, 0x47, 0x29, 0x2A, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x49, 0x20, 0x41, 0x43, 0x47, 0x29, 0x19, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 
	0x00, 0x1C, 0x13, 0x1C, 0xC3, 0x1C, 0xE6, 0x23, 0xF8, 0xD7, 0xF4, 0xE0, 0xFF, 0xE0, 0xF0, 0x89, 
	0xE5, 0x71, 0x00, 0xE0, 0xE7, 0xE4, 0xF4, 0xE0, 0xE7, 0xE0, 0xE5, 0x76, 0x7E, 0x1C, 0x31, 0x1C, 
	0x2A, 0x13, 0x14, 0x1C, 0x30, 0x1C, 0x3D, 0x39, 0x49, 0x3A, 0x3D, 0x3A, 0x3E, 0x1F, 0x15, 0x1C, 
	0x00, 0x1C, 0x0B, 0x1C, 0x4A, 0x23, 0x6A, 0x43, 0x41, 0x43, 0x4D, 0x43, 0x47, 0x23, 0x19, 0x1C, 
	0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0x7E, 0x1C, 
	0xDB, 0x23, 0xE7, 0x95, 0xE7, 0xD8, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xE5, 0x8D, 0x73, 0x79, 
	0x7E, 0x79, 0xF4, 0xD8, 0xF4, 0xE0, 0xE7, 0xE4, 0xE9, 0xE0, 0x00, 0xE0, 0xE5, 0x05, 0x3E, 0x29, 
	0x3E, 0x2B, 0x2A, 0x1C, 0x35, 0x23, 0x47, 0x37, 0x3D, 0x3A, 0x3D, 0x3A, 0x47, 0x39, 0x2A, 0x1C, 
	0x12, 0x1C, 0x47, 0x23, 0x3E, 0x45, 0x47, 0x43, 0x4A, 0x43, 0x41, 0x43, 0x47, 0x43, 0x3E, 0x1F, 
	0x0B, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x92, 0x1C, 0xD2, 0xD7, 
	0xE6, 0xCD, 0xF4, 0xD3, 0xDB, 0xD8, 0xE7, 0xE0, 0xE6, 0xE0, 0xF4, 0xE4, 0xE6, 0x82, 0x83, 0x7C, 
	0x76, 0x79, 0xD9, 0x8D, 0xFE, 0x01, 0xF9, 0xF2, 0xE7, 0xE4, 0x00, 0xE0, 0xF4, 0xE4, 0xCC, 0x2B, 
	0x3D, 0x2B, 0x47, 0x37, 0x3D, 0x3A, 0x36, 0x3A, 0x31, 0x3A, 0x35, 0x3A, 0x3E, 0x3A, 0x3E, 0x36, 
	0x00, 0x1C, 0x35, 0x1C, 0x47, 0x45, 0x47, 0x45, 0x3E, 0x43, 0x47, 0x43, 0x47, 0x43, 0x47, 0x48, 
	0x3D, 0x1C, 0x15, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x1E, 0x1C, 0xCC, 0x9D, 0xB4, 0xA5, 
	0xE7, 0xE4, 0xDB, 0xD3, 0xF4, 0xD0, 0xE9, 0xE0, 0xF4, 0xE4, 0xD2, 0xE0, 0xF4, 0xEB, 0x92, 0x82, 
	0x81, 0x84, 0xB2, 0x84, 0xDB, 0xE4, 0xDB, 0xE0, 0xE7, 0xE4, 0xE7, 0xE4, 0xD9, 0xAE, 0xF0, 0xD5, 
	0x8F, 0x2B, 0x3E, 0x2B, 0x47, 0x39, 0x31, 0x3A, 0x31, 0x3A, 0x3E, 0x3A, 0x47, 0x3A, 0x49, 0x3A, 
	0x0C, 0x1C, 0x49, 0x2F, 0x00, 0x43, 0x41, 0x43, 0x4A, 0x43, 0x49, 0x43, 0x41, 0x43, 0x00, 0x43, 
	0x47, 0x48, 0x47, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x12, 0x1C, 0xCC, 0x0D, 0x99, 0xA5, 0x9D, 0xA5, 
	0xA3, 0xBE, 0xE7, 0xE4, 0xDB, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xF9, 0xF6, 0xF4, 0xF2, 0xE5, 0x74, 
	0xA3, 0x84, 0xDB, 0x84, 0xE9, 0xE6, 0xDB, 0xE0, 0x00, 0xE0, 0xDB, 0xE0, 0xF4, 0xE4, 0xDB, 0xE1, 
	0xE6, 0x9B, 0x3E, 0x37, 0x00, 0x3A, 0x31, 0x3A, 0x00, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x3E, 0x29, 0x47, 0x43, 0x00, 0x43, 0x4D, 0x43, 0x3E, 0x43, 0x47, 0x43, 0x3E, 0x43, 0x3E, 0x48, 
	0x3E, 0x36, 0x19, 0x1C, 0x00, 0x1C, 0x15, 0x1C, 0xA3, 0x20, 0xB4, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0xA8, 0xA5, 0xA3, 0x9D, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0xF5, 0xE4, 0xDB, 0xE4, 0xF4, 0xD8, 
	0xE7, 0xE4, 0xE6, 0xE0, 0xE6, 0xE0, 0xE7, 0xE4, 0x00, 0xE0, 0x00, 0xE0, 0xE7, 0xE4, 0xD9, 0xD5, 
	0xF4, 0xE4, 0xA3, 0x60, 0x3E, 0x37, 0x3E, 0x3A, 0x3D, 0x3A, 0x36, 0x3A, 0x47, 0x3A, 0x47, 0x3A, 
	0x14, 0x1C, 0x47, 0x43, 0x47, 0x43, 0x3E, 0x43, 0x4A, 0x43, 0x41, 0x43, 0x3D, 0x43, 0x4A, 0x43, 
	0x3D, 0x43, 0x47, 0x2F, 0x19, 0x1C, 0x7E, 0x1C, 0xCC, 0x9D, 0x00, 0xA5, 0x00, 0xA5, 0xAC, 0xA5, 
	0x95, 0xA5, 0xBD, 0xA5, 0xE6, 0x9D, 0xE7, 0xE4, 0xF4, 0xE4, 0xE7, 0xE0, 0xF4, 0xD8, 0xE6, 0xD5, 
	0xE6, 0xD5, 0xDB, 0xE0, 0x00, 0xE0, 0xF5, 0xE0, 0xE7, 0xE0, 0xDB, 0xE4, 0xF4, 0xE4, 0xE7, 0xE4, 
	0x00, 0xE0, 0xF8, 0xE0, 0xB2, 0x37, 0x35, 0x3A, 0x31, 0x3A, 0x36, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x41, 0x2F, 0x00, 0x43, 0x41, 0x43, 0x41, 0x43, 0x41, 0x43, 0x41, 0x43, 0x41, 0x43, 0x00, 0x43, 
	0x49, 0x43, 0x3E, 0x43, 0x3C, 0x49, 0xA3, 0x8D, 0x9B, 0xA5, 0xEE, 0xA5, 0x01, 0xAA, 0x01, 0x9D, 
	0x02, 0x00, 0x9A, 0xA5, 0x9B, 0xA5, 0xE6, 0xBD, 0xE6, 0xE0, 0x00, 0xE0, 0xDB, 0xE4, 0xDB, 0xD3, 
	0xF4, 0xD3, 0xE7, 0xE4, 0xE7, 0xE4, 0xF4, 0xD8, 0xDB, 0xD3, 0xF0, 0xE0, 0x00, 0xE0, 0xF4, 0xE0, 
	0xF4, 0xE0, 0xE6, 0xE0, 0xF0, 0x60, 0x31, 0x3A, 0x00, 0x3A, 0x31, 0x3A, 0x35, 0x3A, 0x31, 0x3A, 
	0x3E, 0x43, 0x3E, 0x43, 0x4A, 0x43, 0x4A, 0x43, 0x4D, 0x43, 0x44, 0x43, 0x4A, 0x43, 0x47, 0x43, 
	0x47, 0x43, 0x3E, 0x43, 0xA3, 0x64, 0x9A, 0xA5, 0x00, 0xA5, 0xF6, 0xA5, 0x00, 0x9D, 0x00, 0x00, 
	0x01, 0xAA, 0x85, 0xA5, 0x00, 0xA5, 0xB3, 0xA5, 0xE7, 0xD8, 0x00, 0xE0, 0xDB, 0xE0, 0xE7, 0xE4, 
	0xE7, 0xE4, 0xE6, 0xE0, 0xDB, 0xD8, 0xD9, 0xD1, 0xDB, 0xD8, 0xE7, 0xE4, 0x00, 0xE0, 0xF4, 0xE0, 
	0xCC, 0xBA, 0xCC, 0xBA, 0x67, 0xAB, 0x36, 0x3A, 0x35, 0x3A, 0x31, 0x3A, 0x00, 0x3A, 0x00, 0x3A, 
	0x00, 0x43, 0x47, 0x45, 0x3E, 0x43, 0x3E, 0x43, 0x4D, 0x43, 0x41, 0x43, 0x00, 0x43, 0x41, 0x43, 
	0x41, 0x43, 0xA3, 0x43, 0xCC, 0x9D, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xE8, 0xA5, 0xF6, 0xA5, 
	0x99, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB2, 0xA5, 0xE7, 0xE4, 0xE7, 0xE0, 0xDB, 0xE0, 
	0xE7, 0xE4, 0x00, 0xE0, 0xE7, 0xE0, 0xE6, 0xD5, 0xDB, 0xE4, 0xE6, 0xA0, 0xCC, 0xBA, 0xA3, 0xBA, 
	0xC3, 0xAB, 0xDB, 0xBA, 0x78, 0xA1, 0x3D, 0x58, 0x3E, 0x58, 0x47, 0x58, 0x3D, 0x58, 0x47, 0x58, 
	0x00, 0x43, 0x41, 0x43, 0x41, 0x43, 0x41, 0x43, 0x41, 0x43, 0x44, 0x43, 0x44, 0x43, 0x4D, 0x43, 
	0x47, 0x43, 0xCC, 0xAC, 0xAB, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x9D, 0xA5, 0xE6, 0xA8, 0xF9, 0xF6, 0xFF, 0x01, 
	0xDB, 0xE0, 0xDB, 0xE0, 0xF4, 0xE4, 0xD9, 0xBA, 0xCA, 0xBA, 0xCC, 0xBA, 0xC2, 0x31, 0xDE, 0x14, 
	0x0F, 0x0E, 0xC3, 0xA2, 0x78, 0xBA, 0x58, 0x5B, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x41, 0x43, 0x4A, 0x43, 0x4D, 0x43, 0x41, 0x43, 0x4A, 0x43, 0x00, 0x43, 0x49, 0x43, 0x44, 0x43, 
	0xDB, 0x64, 0xB3, 0xA5, 0xAB, 0xA5, 0xB3, 0xA5, 0x9A, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0xCA, 0xA5, 0xD9, 0xA5, 0xD7, 0xA5, 0xCC, 0xA5, 0xE7, 0xD8, 0xF4, 0xE4, 
	0xD9, 0xAE, 0xDB, 0xA1, 0xDB, 0xBA, 0xDB, 0xAC, 0xB9, 0xBA, 0xDB, 0xBA, 0x25, 0x0F, 0xC3, 0x14, 
	0xDE, 0x1A, 0xDB, 0xA2, 0x9A, 0xBA, 0x40, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x47, 0x45, 0x47, 0x45, 0x47, 0x43, 0x47, 0x48, 0x3D, 0x7A, 0x47, 0x48, 0x3C, 0x43, 0x6E, 0x43, 
	0x8F, 0x9D, 0x8F, 0x8D, 0xA3, 0x18, 0xA3, 0x06, 0xB2, 0x18, 0xCA, 0xBE, 0x00, 0xA5, 0x00, 0xA5, 
	0x00, 0xA5, 0x00, 0xA5, 0x8F, 0x29, 0x7E, 0x18, 0x7E, 0x18, 0xB2, 0x2B, 0xCA, 0xB1, 0xB4, 0xBA, 
	0xE7, 0xAC, 0xDE, 0x0F, 0xC3, 0x0F, 0xDB, 0x0F, 0x99, 0xBA, 0xDB, 0xBA, 0xDB, 0x08, 0xDB, 0x14, 
	0x10, 0x0F, 0xC3, 0xBA, 0x9A, 0xBA, 0x4B, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x58, 0x5F, 0x67, 0x79, 0x73, 0x79, 0x74, 0x79, 0x70, 0x79, 0x7A, 0x79, 0x83, 0x79, 0x76, 0x79, 
	0xA8, 0x79, 0xB2, 0x77, 0xCC, 0x18, 0xCC, 0x1A, 0xA3, 0x0C, 0xCC, 0xBE, 0x00, 0xA5, 0x99, 0xA5, 
	0x99, 0xA5, 0x00, 0xA5, 0xA3, 0x8D, 0xA3, 0x0E, 0x8F, 0x0C, 0xC2, 0x95, 0xB8, 0xA1, 0x00, 0xBA, 
	0xC3, 0x31, 0x6E, 0x0F, 0xE7, 0x14, 0xDE, 0x16, 0xCC, 0xBA, 0xA3, 0xBA, 0xDE, 0x16, 0xDB, 0x83, 
	0xDB, 0xBA, 0xA3, 0xBA, 0x9A, 0xBA, 0x58, 0x46, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x67, 0x58, 0x77, 0x79, 0x73, 0x79, 0x50, 0x87, 0x96, 0x7A, 0x50, 0x87, 0x73, 0x86, 0x70, 0x79, 
	0xAB, 0x79, 0x8F, 0x9D, 0x09, 0x18, 0xC3, 0x06, 0x7E, 0x18, 0xCA, 0x9D, 0xD8, 0xBC, 0xF6, 0xD1, 
	0xD4, 0xD1, 0xCE, 0xA5, 0xA3, 0x77, 0xC3, 0x18, 0xA3, 0x18, 0xA3, 0x2B, 0xB8, 0xB1, 0x00, 0xBA, 
	0xDB, 0x83, 0x25, 0x0F, 0xC3, 0x0F, 0xD2, 0x14, 0xB8, 0xBA, 0xA2, 0xBA, 0xB2, 0xBA, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x99, 0xBA, 0x40, 0x58, 0x00, 0x58, 0x62, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x59, 0x6D, 0x06, 0x79, 0xC3, 0x0D, 0x50, 0x0D, 0x8F, 0x07, 0x8E, 0x0D, 0xC2, 0x0D, 0x7E, 0x6B, 
	0xAC, 0x79, 0xCC, 0x9C, 0xB2, 0xAB, 0xD9, 0x9D, 0xD9, 0x9D, 0xCA, 0xAA, 0xF0, 0xD1, 0x01, 0xD1, 
	0xD7, 0xD1, 0xCC, 0xD1, 0xCA, 0xA5, 0xD9, 0xBE, 0xD9, 0xBE, 0xB4, 0xA5, 0xB8, 0xBC, 0x00, 0xBA, 
	0xC3, 0x85, 0xC3, 0x3B, 0xE6, 0xBA, 0xCC, 0xBA, 0xA2, 0xBA, 0xB9, 0xBA, 0xA7, 0xBA, 0xB9, 0xBA, 
	0x00, 0xBA, 0xB3, 0xBA, 0x95, 0xAD, 0x49, 0x5F, 0x67, 0x58, 0x67, 0x58, 0x00, 0x58, 0x5C, 0x58, 
	0x5C, 0x6B, 0x3F, 0x6B, 0xDE, 0x95, 0x4F, 0x3F, 0xE7, 0xCA, 0x03, 0x25, 0xE9, 0xB4, 0x3F, 0x33, 
	0x83, 0x79, 0xA5, 0xA6, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xCC, 0xA5, 0xD1, 0xDD, 0x00, 0xD1, 
	0xD0, 0xD1, 0xD4, 0xD1, 0x9B, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB8, 0xBC, 0x00, 0xBA, 
	0xCA, 0xBA, 0xA0, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0x81, 0xA1, 0x81, 0xA1, 0x78, 0x84, 
	0x78, 0xAB, 0x81, 0xAB, 0x67, 0x63, 0x4D, 0x58, 0x60, 0x58, 0x62, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x5D, 0x79, 0x50, 0x87, 0x96, 0xCA, 0x56, 0x50, 0xC3, 0xD7, 0x8E, 0x50, 0x96, 0xCA, 0x50, 0x73, 
	0x74, 0x79, 0xAE, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xB8, 0xA5, 0xD5, 0xD1, 0x00, 0xD1, 
	0xDB, 0xD1, 0xE6, 0xD1, 0x99, 0xA5, 0x00, 0xA5, 0xA5, 0xA6, 0x00, 0xA5, 0xCB, 0xA5, 0x00, 0xBA, 
	0x00, 0xBA, 0x00, 0xBA, 0x00, 0xBA, 0xC1, 0xBA, 0xA4, 0xBA, 0x78, 0x84, 0x6C, 0x5F, 0x47, 0x58, 
	0x62, 0x58, 0x00, 0x58, 0x5C, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x5C, 0x79, 0x50, 0x6D, 0xE9, 0x95, 0x26, 0x1E, 0xE7, 0xCA, 0x03, 0x25, 0x96, 0x95, 0x26, 0x1E, 
	0x77, 0x79, 0xA4, 0xA5, 0x78, 0xA5, 0x81, 0xAA, 0xAB, 0xA5, 0xC3, 0xA5, 0xD6, 0xD1, 0x00, 0xD1, 
	0x00, 0xD1, 0xD9, 0xD1, 0x99, 0xA5, 0x67, 0x9C, 0x95, 0xAA, 0xBD, 0xA5, 0x9E, 0xA5, 0x00, 0xBA, 
	0x81, 0xBA, 0x78, 0xBA, 0x81, 0xA1, 0x78, 0x63, 0x6C, 0x58, 0x48, 0x58, 0x00, 0x58, 0x5C, 0x58, 
	0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x64, 0x58, 0x5C, 0x58, 
	0x76, 0x86, 0x3F, 0x0D, 0xC3, 0x0D, 0x26, 0x0D, 0xDB, 0x0D, 0x50, 0x0D, 0x7E, 0x07, 0x50, 0x07, 
	0x1E, 0x79, 0x81, 0xAA, 0x78, 0x63, 0x99, 0xA5, 0x92, 0x9C, 0x78, 0x9D, 0xD9, 0xD1, 0xDF, 0xD1, 
	0xDA, 0xD1, 0xD9, 0xDC, 0x99, 0xA5, 0x6C, 0x84, 0x6C, 0x84, 0xA4, 0xA5, 0xB9, 0xBE, 0x78, 0xA8, 
	0x78, 0x63, 0x6C, 0x58, 0x49, 0x58, 0x00, 0x58, 0x62, 0x58, 0x59, 0x58, 0x64, 0x58, 0x64, 0x58, 
	0x64, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x59, 0x58, 0x62, 0x58, 
	0x67, 0x5B, 0x3F, 0x58, 0xC3, 0x54, 0x3C, 0x58, 0x8F, 0x58, 0x3F, 0x58, 0xA3, 0x58, 0x50, 0x58, 
	0x5C, 0x6B, 0x6C, 0x63, 0x47, 0x58, 0x67, 0x58, 0x44, 0x58, 0x4E, 0x58, 0x4D, 0x58, 0x6C, 0x58, 
	0x78, 0x58, 0x78, 0x58, 0x67, 0x58, 0x59, 0x58, 0x59, 0x58, 0x67, 0x58, 0x67, 0x58, 0x3A, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 
	0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x5C, 0x58, 0x64, 0x58, 0x5C, 0x58, 0x64, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
	0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 0x00, 0x58, 
};

const u8 ImgAttr5[8320] __attribute__ ((aligned(4))) = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x01, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC2, 0x03, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x8F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x7F, 0x1F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x01, 0xA7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC0, 0x01, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xB3, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x3F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x01, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE0, 0x00, 0x7F, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x3C, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x01, 0x3C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 
	0x00, 0x00, 0xFF, 0xFF, 0x03, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0x7E, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x9C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x01, 0xF9, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBC, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x86, 
	0x7F, 0xF9, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xC7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x3C, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFC, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0xB3, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7E, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x01, 
	0xFF, 0xFE, 0x7F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFC, 0xF9, 0xE0, 0x3F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x7E, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 
	0x3F, 0xFF, 0xFF, 0xF8, 0x79, 0xF0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 
	0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xF0, 0xF9, 0xF0, 0x03, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 
	0x3F, 0xFF, 0xFF, 0xE0, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x9F, 
	0xFF, 0xFF, 0x9F, 0xFF, 0xFC, 0x03, 0xFF, 0xFF, 0x1F, 0xFF, 0xFE, 0xC0, 0xFF, 0xFC, 0x0F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x87, 0xFF, 0x00, 0x00, 0xFF, 0xCF, 0xFF, 0xF8, 0xD3, 0xFF, 0xFE, 
	0x1F, 0xFF, 0xFF, 0xDF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xCF, 0x83, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0x00, 
	0x00, 0xFF, 0xE7, 0xFF, 0xC3, 0x09, 0xFF, 0xFE, 0x4F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE, 0x3F, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xE4, 0x9F, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF0, 0xD0, 0x3F, 0xFF, 0x00, 0x00, 0xFF, 0xE7, 0xFE, 0x0F, 0x04, 0x7F, 0xFC, 
	0xCF, 0xFF, 0xFE, 0x7B, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x9F, 0xC1, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x19, 0xFF, 0xFF, 0x00, 
	0x00, 0xFF, 0xF3, 0xF8, 0x3F, 0x02, 0x3F, 0xFC, 0xE7, 0xFF, 0xF8, 0xF3, 0xFC, 0xFF, 0x80, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xC8, 0x9F, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFC, 0x00, 0x3D, 0xFF, 0xFF, 0x10, 0x00, 0xFF, 0xF1, 0x81, 0xFF, 0x01, 0x3F, 0xF8, 
	0xF3, 0xFF, 0xE1, 0x87, 0xFC, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFE, 0x90, 0x9F, 0xE0, 0x7F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xE0, 0x00, 0xFC, 0xFF, 0xFF, 0x03, 
	0xC0, 0xFF, 0xF8, 0x0F, 0xFF, 0x00, 0x1F, 0xF8, 0xB9, 0xFF, 0x00, 0x0F, 0xF8, 0x7F, 0xE3, 0x7F, 
	0xFF, 0xFF, 0xFD, 0x80, 0x3F, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEE, 0x00, 0x00, 0xFE, 0x7F, 0xFF, 0x1F, 0xE0, 0xFF, 0xF8, 0x3F, 0xFF, 0x00, 0x0F, 0xF0, 
	0xFC, 0x7F, 0x00, 0xCF, 0xF3, 0x3F, 0x07, 0xFF, 0xFF, 0xFF, 0xFB, 0x20, 0x39, 0xF0, 0x1F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0xFF, 0x3F, 0xFE, 0x7F, 
	0xE0, 0xFF, 0xE3, 0xBF, 0xFF, 0x00, 0x07, 0xE0, 0xF8, 0x0F, 0xFF, 0x9F, 0xE3, 0x80, 0x07, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x7F, 0xF9, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0xBF, 0x00, 0xFF, 0xF0, 0xFF, 0x8F, 0x9F, 0xFF, 0xFF, 0x07, 0xDF, 
	0xFC, 0x1F, 0xFF, 0x3F, 0xC7, 0xC0, 0xE3, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xF9, 0xF8, 0x0F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0x9F, 0x01, 0xFF, 
	0xF8, 0xFC, 0x1F, 0xCF, 0xFF, 0xFF, 0x03, 0x17, 0xFC, 0xFF, 0xFE, 0x7F, 0x0F, 0xBF, 0xE1, 0xFF, 
	0xFF, 0xFF, 0xF8, 0xFF, 0xF9, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFC, 0x19, 0x9F, 0xFF, 0xFF, 0xCF, 0x00, 0xFC, 0x38, 0xF0, 0x7F, 0xE7, 0xFF, 0xFF, 0x0B, 0x07, 
	0xBE, 0x3F, 0xF8, 0xF8, 0x3F, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xF9, 0xF8, 0x03, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xA3, 0xCF, 0xFF, 0xFF, 0xEF, 0x03, 0x78, 
	0x1C, 0x03, 0xFF, 0xF3, 0xFF, 0xFF, 0x01, 0xEF, 0x00, 0x1F, 0xE0, 0x00, 0xFF, 0xFF, 0xF8, 0x3F, 
	0xFF, 0xFF, 0xE0, 0xFF, 0xF9, 0xFC, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x80, 0x87, 0xE7, 0xFF, 0xFF, 0xE7, 0x03, 0x78, 0x1E, 0x0F, 0xFF, 0xF9, 0xFF, 0xFF, 0x04, 0xC8, 
	0x60, 0x0F, 0xE0, 0x07, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFE, 0xC0, 0xFF, 0xF9, 0xFE, 0x00, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x1E, 0x33, 0xFF, 0xFF, 0xF3, 0x03, 0x38, 
	0x0F, 0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0x02, 0xC1, 0xFF, 0x07, 0xE4, 0xFF, 0xFD, 0xFF, 0xFE, 0x03, 
	0xFF, 0xFB, 0x90, 0xFF, 0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xF0, 
	0x00, 0x7E, 0x9B, 0xFF, 0xFF, 0xFB, 0x03, 0x38, 0x0F, 0xBF, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x1F, 
	0xFF, 0x03, 0xC8, 0xFF, 0xFC, 0xFF, 0xFF, 0x01, 0xFF, 0xF6, 0x20, 0xFF, 0xFF, 0xFF, 0x80, 0x1F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x80, 0x00, 0xFD, 0xD9, 0xFF, 0xFF, 0xF9, 0x17, 0xBC, 
	0x0F, 0x9F, 0xFC, 0x1E, 0x7F, 0xFF, 0x01, 0x3F, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0xFF, 0xFC, 0x03, 
	0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFB, 0xC0, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x18, 
	0x08, 0xFD, 0xDC, 0xFF, 0xFF, 0xFC, 0x07, 0x9E, 0x0F, 0xC0, 0xF9, 0x8F, 0x3F, 0xFF, 0xFF, 0x3F, 
	0xFF, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xF9, 0xE7, 0xFF, 0xFF, 0xF9, 0xC0, 0x23, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x20, 0x03, 0xFD, 0x9C, 0xFF, 0xFF, 0xFC, 0x0F, 0x9E, 
	0x1F, 0xC0, 0xF3, 0xCF, 0x9F, 0xFF, 0xFF, 0x3F, 0xFF, 0xC4, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 
	0xFD, 0xE3, 0x8F, 0xF7, 0xFF, 0xF8, 0xE0, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x27, 
	0x80, 0xFD, 0xBE, 0x7F, 0xFF, 0xFE, 0x1F, 0xCF, 0xFF, 0xC0, 0x87, 0xCF, 0x9F, 0xFF, 0xFF, 0x1F, 
	0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xE2, 0xFE, 0x00, 0x0F, 0xEF, 0xF9, 0xFE, 0xF0, 0x10, 
	0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xB3, 0xBE, 0x7C, 0x3F, 0x3F, 0xFF, 0xFE, 0x3F, 0xCF, 
	0xFF, 0xC0, 0x7F, 0xCF, 0xCF, 0xFF, 0xFE, 0x07, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x8D, 
	0xFE, 0x00, 0xDF, 0x8F, 0xF9, 0xFE, 0x7C, 0x03, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x39, 
	0x1F, 0x3E, 0x7F, 0x3F, 0xFF, 0xF8, 0x1F, 0xE7, 0xFE, 0x20, 0x7F, 0xCF, 0xE7, 0xFF, 0xFC, 0x07, 
	0xBF, 0xE7, 0xFB, 0xFF, 0xFF, 0xFC, 0x00, 0x16, 0xFD, 0xFF, 0xBE, 0x0F, 0xF9, 0xFF, 0x8C, 0x0F, 
	0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7D, 0xC7, 0xA3, 0xFF, 0x9F, 0xFF, 0xE1, 0x0F, 0xE7, 
	0xF8, 0xE0, 0x7F, 0x9F, 0xF7, 0xFF, 0xF1, 0x03, 0xBF, 0x8F, 0xE3, 0xFF, 0xFF, 0xFE, 0x02, 0xE0, 
	0xFF, 0xFE, 0x60, 0x4F, 0xF1, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x4C, 
	0xA0, 0x4C, 0xF3, 0xDF, 0xFF, 0x07, 0x07, 0xF3, 0xE0, 0xF0, 0x7F, 0x9F, 0xF3, 0xFF, 0xE3, 0x01, 
	0x7C, 0x3F, 0x07, 0xFF, 0xF3, 0xFF, 0x99, 0xF1, 0xFF, 0xF8, 0x03, 0x9F, 0xF1, 0xFF, 0xF0, 0x03, 
	0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x66, 0x48, 0xCC, 0xC0, 0xCF, 0xF8, 0x3F, 0x03, 0xF0, 
	0x00, 0xF0, 0x00, 0x3F, 0xFB, 0xFF, 0x0F, 0x01, 0xE0, 0xC0, 0x0F, 0xDF, 0xF0, 0xFF, 0xE1, 0xF9, 
	0xFF, 0xF0, 0x1F, 0x9F, 0xE0, 0xFF, 0xF9, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x60, 
	0x7F, 0xCC, 0xDE, 0x6F, 0xC0, 0xFF, 0xF9, 0xFC, 0x3F, 0xF0, 0xC0, 0x7F, 0xF9, 0xFC, 0x10, 0x04, 
	0xF0, 0x00, 0x9F, 0x9F, 0xFC, 0x00, 0x07, 0xFC, 0xFF, 0xFF, 0x3F, 0x3F, 0xC0, 0x0F, 0x01, 0x81, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x70, 0x3F, 0xE1, 0xCF, 0xA7, 0x07, 0xFF, 0xFC, 0xFD, 
	0xFF, 0xF8, 0xFF, 0xFF, 0xF8, 0xE0, 0x40, 0x66, 0x7F, 0xFF, 0x3F, 0x3F, 0xFF, 0x00, 0x1F, 0xFE, 
	0xFF, 0xFE, 0x7E, 0x7E, 0x1C, 0x00, 0x0F, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xFE, 
	0x9F, 0xE7, 0xE3, 0x60, 0x7F, 0xFF, 0xFE, 0x7C, 0xFF, 0xF8, 0xFF, 0xFF, 0xF8, 0x07, 0x40, 0x74, 
	0x7F, 0xFE, 0x7C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0x78, 0xF0, 0x3F, 0xE1, 0xFF, 0xF0, 
	0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFE, 0x4F, 0xC3, 0xF0, 0x0F, 0x7F, 0xFF, 0xFF, 0x3C, 
	0xFF, 0xFC, 0x3F, 0xFF, 0xF3, 0x9F, 0x00, 0x75, 0x3F, 0xF9, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xF0, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFE, 
	0x4F, 0x9B, 0xFE, 0x3F, 0x3F, 0xFF, 0xFF, 0x3E, 0xFF, 0xFC, 0x1F, 0xFF, 0xC7, 0xCE, 0x60, 0x74, 
	0x1F, 0xE0, 0x03, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFC, 
	0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xFE, 0x67, 0xBB, 0xF0, 0xFF, 0x9F, 0xFF, 0x1F, 0x1E, 
	0xFF, 0xFE, 0x07, 0xFE, 0x1F, 0xEE, 0xF9, 0x20, 0x1F, 0xE0, 0x1F, 0xFE, 0x7F, 0xFF, 0xFF, 0xBF, 
	0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFE, 
	0x33, 0x33, 0xC3, 0xFF, 0xCF, 0xFE, 0x0F, 0x0E, 0xFF, 0xFE, 0x03, 0xF0, 0x7F, 0xE6, 0x78, 0x08, 
	0x0F, 0xFB, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x03, 0x7F, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFE, 0xB3, 0xB7, 0x0F, 0xFF, 0xCF, 0xF0, 0xE7, 0x06, 
	0x7F, 0xFF, 0x01, 0x81, 0xFF, 0xF3, 0x38, 0xF0, 0x07, 0xF7, 0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xC7, 
	0xFF, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFE, 
	0x80, 0xCC, 0x3F, 0xFF, 0xE7, 0xE0, 0xE7, 0x07, 0x7F, 0xFF, 0xB8, 0x1F, 0xFF, 0xF9, 0x83, 0x0F, 
	0x07, 0xE7, 0xFF, 0xE3, 0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xFF, 0x9F, 0xF9, 0xFF, 
	0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xC0, 0xF1, 0xFF, 0xFF, 0xF7, 0xCF, 0xE7, 0x13, 
	0x7F, 0xFF, 0xC0, 0x3F, 0xFF, 0xF8, 0xE6, 0x6F, 0x13, 0xCF, 0xFF, 0xCF, 0xFF, 0xFD, 0xFF, 0xFF, 
	0xFF, 0xC8, 0xFF, 0xFF, 0xFF, 0x3F, 0xFC, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 
	0xF0, 0x07, 0xFF, 0xFF, 0xF3, 0xDF, 0xEF, 0x03, 0x7F, 0xFF, 0x87, 0x1F, 0xFF, 0xFC, 0xFE, 0xE7, 
	0x09, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xC8, 0xFF, 0xFD, 0xFF, 0x3F, 0xFE, 0xFF, 
	0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xC1, 0x7F, 0xFF, 0xFC, 0xCF, 0xFF, 0xFF, 0xF9, 0xCF, 0xCF, 0x0B, 
	0x7F, 0xF0, 0x77, 0x0F, 0xFF, 0xFE, 0x7E, 0xE6, 0x20, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0x90, 0xFF, 0xF1, 0xFF, 0x3F, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFE, 0x87, 0xFF, 0xFF, 
	0xFC, 0xEF, 0xFF, 0xFF, 0xFD, 0xE0, 0x1F, 0x01, 0x7E, 0x00, 0xF3, 0x0F, 0xFF, 0xFE, 0x7E, 0x0C, 
	0x0C, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x20, 0xFF, 0xE3, 0xFE, 0x3F, 0xFF, 0xFF, 
	0xFF, 0x03, 0xFF, 0xFF, 0xFD, 0x83, 0xFF, 0xFF, 0xFC, 0xE7, 0xFF, 0xFF, 0xFC, 0xF0, 0x3F, 0x05, 
	0xF0, 0x00, 0xF9, 0x0F, 0xFF, 0xFF, 0x3F, 0x95, 0xE6, 0x7F, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x40, 0xFF, 0x8F, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFB, 0x03, 0xFF, 0xFF, 
	0xFE, 0x73, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x00, 0xC0, 0x00, 0xF9, 0x1F, 0xFF, 0xFF, 0xBF, 0x0C, 
	0xF2, 0x7F, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xC0, 0xFF, 0x3F, 0xFC, 0x3F, 0xFC, 0xFF, 
	0xFF, 0x0F, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xFE, 0x39, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x02, 
	0x00, 0x00, 0xFC, 0x3F, 0xFF, 0xFF, 0x9F, 0x6E, 0x79, 0x3F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFE, 0x7F, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 
	0xFC, 0x00, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xF8, 0x20, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xCE, 0x61, 
	0x33, 0x9F, 0xFF, 0x3F, 0xFF, 0xF9, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x1F, 
	0xF8, 0x7F, 0xFF, 0xFF, 0xFC, 0x03, 0xFF, 0xFF, 0xFE, 0x80, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xC1, 
	0x9F, 0x00, 0x02, 0x7F, 0xFF, 0xFF, 0xCE, 0xE0, 0xC7, 0x9F, 0xFE, 0x7F, 0xFF, 0xFC, 0xFF, 0xFE, 
	0xE7, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 
	0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0x9F, 0xFF, 0x0F, 0xCF, 0xF0, 0x07, 0x3F, 0xFF, 0xFF, 0xE6, 0xE0, 
	0xFF, 0x0F, 0xE0, 0xFF, 0xE7, 0xFE, 0x3F, 0xF8, 0xCF, 0xF7, 0xFF, 0xFF, 0xE4, 0x3F, 0xFF, 0xC0, 
	0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xDF, 0xF0, 0x3F, 
	0xEF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xF6, 0xE8, 0xFC, 0x08, 0x00, 0xFF, 0xCF, 0xFF, 0x00, 0x00, 
	0x9F, 0xC7, 0xFF, 0xFF, 0x90, 0x1F, 0xFF, 0xF0, 0x39, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xCF, 0xC0, 0xFF, 0xE7, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xF3, 0x00, 
	0xF0, 0xA6, 0x1D, 0xFF, 0x9F, 0xFF, 0xC0, 0x03, 0x3F, 0x0F, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFC, 
	0x24, 0x7F, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x9F, 0xFF, 0xFF, 0xE6, 0x0F, 0xCF, 
	0xF3, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xF9, 0x11, 0x83, 0x13, 0xF9, 0xFE, 0x3F, 0xCF, 0xFC, 0xFF, 
	0xF0, 0x0F, 0xFF, 0xF0, 0x0F, 0x00, 0x0F, 0xF0, 0xE2, 0x7F, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xCF, 0xFF, 0xFF, 0xC0, 0x3F, 0xA6, 0x33, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFC, 
	0x0F, 0x0B, 0xF3, 0xF8, 0x3F, 0xC7, 0xFF, 0xFF, 0x00, 0x9F, 0xFF, 0xC0, 0x3F, 0xE0, 0x00, 0x03, 
	0xF1, 0x3F, 0xFF, 0xFE, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x67, 0xFF, 0xFF, 0x98, 0xFF, 0x32, 
	0xD9, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0x01, 0xE0, 0x01, 0xFF, 0xE7, 0xFF, 0xFF, 
	0x07, 0x3F, 0xFE, 0x00, 0x7F, 0xFC, 0x00, 0x1F, 0xF0, 0x1F, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x00, 0xFF, 0xFC, 0x3E, 0x7F, 0x38, 0xC8, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xF3, 0x03, 
	0xFF, 0xFC, 0xE0, 0x07, 0xFF, 0xF7, 0xFF, 0xFF, 0xFE, 0x7F, 0xF0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x0F, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0xFF, 0xF0, 0xFE, 0x7F, 0x99, 
	0xC4, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xC3, 0x9F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x84, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x03, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE0, 0xFF, 0xC3, 0xFF, 0x3F, 0xC4, 0x92, 0x7F, 0xFF, 0xFD, 0xFF, 0xFF, 0x0F, 0x9F, 
	0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x01, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0x0F, 0xFF, 0x98, 0x66, 
	0x22, 0x3F, 0xFF, 0xFC, 0xFF, 0xFC, 0x3F, 0xCF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF0, 0xF8, 0x3F, 0xFF, 0x93, 0x3F, 0xCF, 0x3F, 0xFF, 0xFE, 0xFF, 0xE0, 0xFF, 0xEF, 
	0xFF, 0xFF, 0x1F, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xFF, 0x80, 0x3F, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0xD7, 0x90, 
	0x80, 0x9F, 0xFF, 0xFE, 0x7F, 0x03, 0xFF, 0xE7, 0xFF, 0xFF, 0x0F, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xE0, 0x1F, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF8, 0x8F, 0xFF, 0xFF, 0xCB, 0x86, 0x4E, 0x1F, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xF3, 
	0xFF, 0xFF, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 
	0xFF, 0xF0, 0x07, 0xF0, 0x3F, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0xDF, 0xFF, 0xFF, 0xE8, 0x26, 
	0x4F, 0x0F, 0xFF, 0xFC, 0x81, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x07, 0xF1, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF2, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0x9F, 0xFF, 0xFF, 0xF8, 0xE3, 0xE0, 0x1F, 0xFF, 0xFF, 0xFC, 
	0x07, 0xFF, 0xF8, 0x08, 0xFF, 0xFF, 0xE7, 0xF0, 0xE3, 0x2F, 0xFF, 0xF1, 0xCF, 0xFF, 0xFF, 0xF9, 
	0xFF, 0xFF, 0x17, 0xE3, 0xFF, 0xFE, 0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x78, 0xE0, 0x1F, 0xFF, 0xC1, 0xF0, 0xFB, 0xFF, 0xFE, 0x04, 0xFF, 0xFF, 0xF3, 0xF9, 
	0xF8, 0x67, 0xFF, 0x83, 0xE7, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 
	0xCC, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9E, 0x00, 0x3F, 0xFE, 0x00, 0x20, 
	0xFD, 0xFF, 0xFF, 0xC2, 0xFF, 0xFF, 0xF3, 0xE3, 0x8F, 0xF7, 0xFE, 0x0F, 0x27, 0xFF, 0xFF, 0xFC, 
	0xFF, 0xFF, 0x0B, 0xFF, 0xFF, 0xFF, 0x83, 0x7F, 0x98, 0xFF, 0xE7, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x01, 0x3F, 0xFC, 0x00, 0x00, 0xFE, 0x7F, 0xFF, 0xC0, 0xFF, 0xFF, 0xF9, 0xCB, 
	0x27, 0xF3, 0xF8, 0x7E, 0x13, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x0B, 0xFF, 0xFF, 0xFF, 0xE0, 0x07, 
	0x10, 0xFF, 0x87, 0xFE, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0x7F, 0xF8, 0x00, 0x00, 
	0xFE, 0x7F, 0xFF, 0xE1, 0xFF, 0xFF, 0xF9, 0xD9, 0x77, 0xF9, 0xC1, 0xFC, 0xD9, 0xFF, 0xFF, 0xFF, 
	0x3F, 0xFF, 0x23, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x20, 0xFF, 0x1F, 0xFC, 0xFF, 0xDF, 0xFF, 0xFF, 
	0xC0, 0xFF, 0x81, 0x1F, 0xFF, 0xF8, 0x00, 0x00, 0xFE, 0x7F, 0xFF, 0xE4, 0xFF, 0xFF, 0xFC, 0xD9, 
	0x3B, 0xF8, 0x0F, 0xFD, 0xD9, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xC0, 0xFF, 0x7F, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xE0, 0x00, 0x06, 0x1F, 0xFF, 0xF0, 0x00, 0x00, 
	0xFE, 0x7F, 0xFF, 0xF0, 0x7F, 0xFF, 0xFC, 0xCB, 0x9B, 0xE6, 0x3C, 0x3D, 0xDC, 0xFF, 0xFF, 0xFF, 
	0x9F, 0xFE, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 
	0xFF, 0x00, 0x7C, 0x1F, 0xFF, 0xF0, 0x00, 0x00, 0xFE, 0x7F, 0xFF, 0xF2, 0x7F, 0xFF, 0xFE, 0x63, 
	0xC7, 0x0F, 0x9B, 0x9D, 0xDE, 0x7F, 0xFF, 0xFF, 0xCF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xF8, 0x07, 0xFF, 0xF0, 0x00, 0xFF, 
	0x00, 0x7F, 0xFF, 0xE0, 0x3F, 0xFF, 0xFF, 0x3F, 0xFC, 0x1F, 0x93, 0xCC, 0x9E, 0x7F, 0xFF, 0xFF, 
	0x00, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 
	0xFF, 0xE1, 0xF8, 0x0F, 0xFF, 0xF8, 0x00, 0xFF, 0x00, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xBF, 
	0xF0, 0xFF, 0xCB, 0xE2, 0x3F, 0x3F, 0xFF, 0xFF, 0x00, 0x03, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xDF, 0xC1, 0xFF, 0xFF, 0xF8, 0xF0, 0x0F, 0xFF, 0xF8, 0x00, 0xFF, 
	0x01, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0x9F, 0xC7, 0xFF, 0xE4, 0xE1, 0xFF, 0x9F, 0xFF, 0xFF, 
	0x08, 0x1F, 0xF2, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xE7, 0x9F, 0xF0, 0x7F, 
	0xFF, 0xC3, 0xE4, 0x1F, 0xFF, 0xFC, 0x00, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xCE, 
	0x1F, 0xFF, 0xF2, 0x00, 0xFF, 0x9F, 0xFF, 0xFF, 0x0F, 0xFF, 0xF8, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xCF, 0x9F, 0xFC, 0x00, 0x20, 0x0F, 0xC0, 0x3F, 0xFF, 0xFE, 0x00, 0xFF, 
	0x03, 0xFF, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xC0, 0x7F, 0xFF, 0xF1, 0xA0, 0x3F, 0xCF, 0xFF, 0xFE, 
	0x1F, 0xFF, 0xF8, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0x8F, 0x9F, 0xFF, 0x00, 
	0x00, 0x7F, 0xC3, 0x7F, 0xFF, 0xFF, 0x80, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xA7, 0xFF, 0xFF, 0xDA, 
	0xFF, 0xFF, 0xF9, 0x09, 0xBC, 0x67, 0xFF, 0xF8, 0x3F, 0xFF, 0xF9, 0xFF, 0xC7, 0xFF, 0xFF, 0xFF, 
	0x00, 0x00, 0xFF, 0xFF, 0x1F, 0x9F, 0xFF, 0xF8, 0x07, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 
	0x0F, 0xFF, 0xFF, 0xFF, 0x93, 0xFF, 0xFF, 0x1E, 0x7F, 0xFF, 0xFC, 0x89, 0x39, 0x37, 0xFF, 0xC1, 
	0xFF, 0xFF, 0xF9, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0x00, 0x0D, 0xFF, 0xF8, 0x7F, 0x9F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xDB, 0xFF, 0xFC, 0x3F, 
	0x3F, 0xFF, 0xFC, 0x04, 0x7B, 0xD3, 0xFF, 0x0F, 0xFF, 0xFF, 0xF9, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xF3, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 
	0x3F, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xF0, 0xFF, 0x9F, 0xFF, 0xFE, 0x4D, 0xFB, 0xC0, 0x00, 0x1F, 
	0xFF, 0xFF, 0xF9, 0xFF, 0xF8, 0x00, 0x7F, 0xFA, 0xFF, 0xE7, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xC3, 0xFF, 
	0x9F, 0xFF, 0xFF, 0x28, 0xFD, 0xC8, 0x00, 0x7F, 0xFF, 0x9F, 0xF9, 0xFF, 0xF0, 0x00, 0x00, 0x00, 
	0xFF, 0xC0, 0x00, 0x07, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7E, 0x0F, 0xFF, 0xCF, 0xFF, 0xFF, 0x32, 0x7E, 0x00, 0x03, 0xFF, 
	0xFC, 0x0F, 0xF8, 0x00, 0x03, 0xE0, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x7F, 0xFF, 0xF9, 0xFF, 0xFF, 
	0x9F, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 
	0xEF, 0xFF, 0xFF, 0x97, 0x7F, 0x13, 0x1F, 0xFF, 0xF0, 0x07, 0xF8, 0x00, 0x0F, 0xFF, 0x80, 0x0F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0x83, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x83, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0x97, 0x3F, 0x43, 0xFF, 0xFF, 
	0x80, 0x07, 0xFC, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF3, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xDF, 0xFF, 0xFF, 
	0xF7, 0xFF, 0xFF, 0x47, 0x3F, 0x0F, 0xFF, 0xFC, 0x00, 0x07, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x4F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x43, 0x7E, 0x1F, 0xFF, 0xE0, 
	0x00, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x7F, 
	0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2F, 0xFF, 0xC3, 
	0xF9, 0xFF, 0xFF, 0x20, 0xF0, 0x7F, 0xFF, 0x00, 0x0F, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC, 0xFF, 0x3F, 0xFF, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0xFF, 0x81, 0xF9, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFC, 0x1C, 
	0x31, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xF9, 0xFF, 0xFF, 0x9F, 
	0xFF, 0x80, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0x3C, 
	0xFC, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0xF0, 0xF5, 0xC1, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xFF, 0xF9, 0xFF, 0xFF, 0xCF, 0xFF, 0x81, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xF0, 0x7E, 0xFC, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xC0, 0x09, 
	0x01, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE3, 
	0xFF, 0x01, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xE6, 0x7E, 
	0xFC, 0xFF, 0xFF, 0x07, 0xFF, 0xFE, 0x00, 0xE1, 0x01, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xF1, 0xFE, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xCF, 0xFC, 0xFE, 0x7F, 0xFE, 0x0F, 0xFF, 0xFC, 0x07, 0xE1, 
	0x01, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFC, 
	0x7E, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xDF, 0xFC, 
	0xFE, 0x7F, 0xF8, 0x3F, 0xFF, 0xFC, 0x1F, 0xE1, 0x01, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x4F, 0xF9, 0xFF, 0x3F, 0xC3, 0xFF, 0xFF, 0xF8, 0x3F, 0xE1, 
	0x01, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xCF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0x88, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x67, 0xFB, 
	0xFF, 0x3E, 0x0F, 0xFF, 0xFF, 0xF8, 0x3F, 0xE1, 0x02, 0x07, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x7F, 0xFF, 0x3F, 0xFF, 0xFF, 0xCF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x30, 0x13, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFC, 0x3F, 0xE1, 
	0xFE, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xE7, 0xFF, 
	0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3E, 0x07, 
	0x01, 0x00, 0xFF, 0xFB, 0xFF, 0xFC, 0x3F, 0xE1, 0xF0, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xE7, 0xFF, 0xF1, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xF7, 0x02, 0x3F, 0xFF, 0x81, 0xFF, 0xFC, 0x3F, 0xE9, 
	0x82, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0xFF, 0xF3, 0xFF, 
	0xE2, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0xFF, 
	0x08, 0x7F, 0xFC, 0x00, 0x7F, 0xFC, 0x3F, 0xEC, 0x0C, 0x07, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF1, 0xFF, 0xFC, 0xFF, 0xF9, 0xFF, 0xC8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0x41, 0xFF, 0xE0, 0x00, 0x7F, 0xFC, 0x3F, 0xCB, 
	0x60, 0x07, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xF9, 0xFF, 0xFD, 0xFE, 
	0xC1, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xC0, 0x7F, 0xA7, 0xFF, 
	0x07, 0xFF, 0x00, 0x00, 0x7F, 0xFC, 0x3F, 0x91, 0x83, 0x07, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC7, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xD3, 0xF0, 0x1F, 0xFC, 0x00, 0x00, 0x7F, 0xFC, 0x3E, 0x10, 
	0x1F, 0x07, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 
	0x07, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xC0, 0x01, 
	0xFF, 0xE0, 0x00, 0xF0, 0x7F, 0xFC, 0x00, 0x62, 0x7F, 0x07, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x1F, 0xFF, 0x62, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC8, 0x00, 0x00, 0x03, 0x80, 0x07, 0xFF, 0x86, 0x07, 0xF0, 0x7F, 0xFC, 0x03, 0x10, 
	0xFF, 0x07, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xC4, 0xFF, 0xFF, 0xFE, 
	0x07, 0xE0, 0x00, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x09, 0xDF, 0xFF, 
	0xF8, 0x00, 0x1F, 0xF0, 0x7F, 0xFC, 0x18, 0x00, 0x7F, 0x07, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE0, 0x3F, 0xFF, 0x83, 0xFF, 0xFF, 0xFC, 0x07, 0xC0, 0x00, 0x00, 0x01, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x87, 0xF8, 0x1F, 0xC1, 0xDF, 0xFF, 0xE0, 0x00, 0x1F, 0xF0, 0x7F, 0xFC, 0x01, 0xE8, 
	0x7F, 0x07, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0x00, 0xFF, 0xFF, 0xF8, 
	0x07, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xF8, 0x1F, 0xC1, 0xDF, 0xFF, 
	0xC0, 0x1E, 0x1F, 0xF0, 0x7F, 0xFC, 0x07, 0xE2, 0x7F, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x80, 0x05, 0xFF, 0xFC, 0x00, 0x1F, 0xFF, 0xF8, 0x0F, 0xC0, 0xFC, 0x4F, 0xF8, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x87, 0xF8, 0x1F, 0xC1, 0xDF, 0xFF, 0x80, 0xFE, 0x1F, 0xF0, 0x7F, 0xFC, 0x1F, 0xE2, 
	0x7F, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x39, 0xFF, 0xF0, 0x30, 0x07, 0xFF, 0xEC, 
	0x6F, 0x81, 0xFC, 0x8F, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFC, 0x1F, 0xC1, 0xDF, 0xFF, 
	0x83, 0xFE, 0x1F, 0xF0, 0x7F, 0xFC, 0x1F, 0xE2, 0x7E, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x07, 0xE7, 0xFF, 0xC0, 0xFE, 0x00, 0x7F, 0xF0, 0x07, 0x83, 0xFC, 0xAF, 0xF8, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x83, 0xFC, 0x1F, 0xC9, 0xDF, 0xFF, 0x87, 0xFE, 0x1F, 0xF0, 0x7F, 0xFC, 0x1F, 0xE2, 
	0x78, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFC, 0x03, 0xFF, 0xF0, 0x00, 0x03, 
	0x07, 0xC3, 0xFE, 0xAF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFC, 0x1F, 0xC1, 0xDF, 0xFF, 
	0x87, 0xFE, 0x1F, 0xE0, 0x7F, 0xFC, 0x1F, 0xE0, 0x00, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x01, 0x00, 0x00, 0x0F, 0x7F, 0xFE, 0x00, 0x03, 0xF0, 0xC3, 0xFE, 0x07, 0xF9, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC3, 0xFC, 0x9F, 0xD9, 0xCF, 0xFF, 0x87, 0xFE, 0x1F, 0xCA, 0x7F, 0xFC, 0x9F, 0xE0, 
	0x00, 0x0F, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0xC3, 0xFE, 0x07, 0xFD, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xF9, 0x9F, 0x9D, 0xCF, 0xFF, 
	0x87, 0xFE, 0x1F, 0x12, 0x7F, 0xFC, 0x9F, 0xE0, 0x00, 0x1F, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xC3, 0xFE, 0x0F, 0xF9, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x3D, 0xCF, 0xFF, 0x87, 0xFE, 0x1C, 0x72, 0x7F, 0xFC, 0x9F, 0x80, 
	0x00, 0x7F, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0xC3, 0xFE, 0x27, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0xFD, 0xCF, 0xFF, 
	0x87, 0xFE, 0x41, 0xCA, 0x7F, 0xFC, 0x9E, 0x00, 0x03, 0xFF, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x01, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xC1, 0xE0, 0x90, 0x00, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC2, 0x0C, 0x30, 0xFD, 0xCF, 0xFF, 0x87, 0xFC, 0xA6, 0x26, 0x7F, 0xFC, 0xC0, 0x00, 
	0x1F, 0xFF, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0xC0, 0x00, 0x08, 0x18, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x40, 0x3D, 0xCF, 0xFF, 
	0xC7, 0xF8, 0x10, 0xF6, 0x7F, 0xFC, 0xA3, 0x03, 0xFF, 0xFF, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x01, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xC0, 0x00, 0x0C, 0x00, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC0, 0xF8, 0x87, 0x9D, 0xCF, 0xFF, 0xC7, 0xE0, 0x23, 0xF6, 0x7F, 0xFC, 0x9C, 0x1F, 
	0xFF, 0xFF, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0xC0, 0x00, 0x10, 0x02, 0x0F, 0xFF, 0x80, 0x07, 0xFF, 0xC3, 0xFC, 0x9F, 0xCD, 0xCF, 0xFF, 
	0xC3, 0x00, 0x4F, 0xF2, 0x7F, 0xFE, 0x01, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xE0, 0x00, 0xA3, 0xF8, 0x0F, 0xFF, 0x83, 
	0x01, 0xFF, 0xC3, 0xFC, 0x1F, 0xC1, 0xCF, 0xFF, 0xC0, 0x00, 0x0F, 0xF2, 0x7F, 0xFE, 0x03, 0xFF, 
	0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 
	0xF8, 0xE0, 0x3E, 0x67, 0xF8, 0x0F, 0xF8, 0x7F, 0xF8, 0x7F, 0xC3, 0xFC, 0x1F, 0xC1, 0x4F, 0xFF, 
	0xC0, 0x1C, 0x0F, 0xF2, 0x7F, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x7F, 0xFF, 0xE0, 0x00, 0x0F, 0xFF, 0xFF, 0xF8, 0xE0, 0x7E, 0x47, 0xF8, 0x0F, 0xE1, 0xFF, 
	0xFF, 0x3F, 0xC3, 0xFC, 0x1F, 0xC1, 0xCF, 0xFF, 0xC0, 0x7C, 0x0F, 0xF2, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, 0x78, 0x00, 0x2F, 0xFF, 
	0xF8, 0xE1, 0xFE, 0x57, 0xF8, 0x0F, 0xC4, 0xFF, 0xFF, 0x1F, 0xC3, 0xFC, 0x1F, 0xC9, 0xCF, 0xFF, 
	0xC3, 0xFC, 0x0F, 0xF2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x7F, 0xFE, 0x00, 0xFC, 0x00, 0x07, 0x7F, 0xF8, 0xE1, 0xFF, 0x13, 0xF8, 0x0F, 0x93, 0xF8, 
	0xFF, 0x0F, 0xC3, 0xFC, 0x1F, 0xC9, 0xCF, 0xFF, 0xC3, 0xFC, 0x0F, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xC0, 0x00, 0xDC, 0x01, 0xBB, 0xFF, 
	0xF8, 0xE0, 0xFF, 0x33, 0xFC, 0x0F, 0x22, 0x00, 0x7F, 0x07, 0xC3, 0xFC, 0x1F, 0xC9, 0xCF, 0xFF, 
	0xC3, 0xFC, 0x0F, 0xE4, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFC, 0xFF, 0x8C, 0x00, 0xF8, 0x01, 0x31, 0xBF, 0xF8, 0xE0, 0xFF, 0xB3, 0xF8, 0x1E, 0x44, 0x00, 
	0x3F, 0x03, 0xE1, 0xF8, 0x1F, 0xC1, 0xCF, 0xFF, 0xC3, 0xFC, 0x0F, 0x8C, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0x00, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 
	0xF8, 0xE1, 0xFF, 0x33, 0x80, 0x1E, 0x44, 0x00, 0x3F, 0x03, 0xE0, 0x00, 0x00, 0x19, 0xCF, 0xFF, 
	0xC3, 0xFC, 0x08, 0x21, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFE, 0x00, 0x00, 
	0x05, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0xE0, 0xF0, 0x00, 0x00, 0x1E, 0xFC, 0x00, 
	0x7F, 0xF9, 0xE0, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0xC1, 0xFC, 0x00, 0x03, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x05, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3F, 
	0xF8, 0xE0, 0x00, 0x00, 0x00, 0x1C, 0xFC, 0x00, 0x7F, 0xF9, 0xF0, 0x00, 0x00, 0x00, 0xCF, 0xFF, 
	0xC3, 0xF8, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x01, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0xF0, 0x00, 0x00, 0x00, 0x1C, 0xFE, 0x00, 
	0xFF, 0xF9, 0xF8, 0x00, 0x00, 0x01, 0xCF, 0xFF, 0xC3, 0xE0, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x79, 0xFF, 0xFF, 0xFF, 0xFF, 0x09, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0xFC, 0xF0, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0x01, 0xBF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xC3, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x71, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x09, 0xF0, 0x00, 0x0C, 0x00, 0xFF, 0xFF, 0xE9, 0xFC, 0xF8, 0x00, 0x00, 0x07, 0xFC, 0xFF, 0xC3, 
	0x7F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xC0, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE4, 0x61, 0xFF, 0xFF, 0xFF, 0xFF, 0x09, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 
	0x7C, 0xFC, 0x1F, 0xFF, 0xFF, 0xF8, 0xFF, 0xE3, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xF7, 0xC4, 0x69, 0xFF, 0xEF, 0xFF, 0x80, 
	0x0B, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x84, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xE0, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0xFD, 0xB9, 
	0xFF, 0xF1, 0xC4, 0x4D, 0xC0, 0x1F, 0xFF, 0x80, 0x0B, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
	0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xF8, 0xFE, 0x79, 0xFF, 0xF8, 0xC4, 0x64, 0x00, 0x1F, 0xFF, 0xFF, 
	0x03, 0xF7, 0xFF, 0xFF, 0x7E, 0xFF, 0xFF, 0x95, 0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 
	0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF, 0xF9, 0xFE, 0x79, 
	0xEF, 0xFC, 0xC4, 0x04, 0x3F, 0xEF, 0xFF, 0xFF, 0x03, 0xF0, 0x00, 0x00, 0x28, 0x00, 0x00, 0x81, 
	0xFC, 0x80, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x3E, 0xEF, 0xFC, 0x08, 0x05, 0xFF, 0xFC, 0xFF, 0xFF, 
	0x03, 0xF0, 0x1E, 0x7E, 0x7E, 0x7C, 0xF8, 0x80, 0x7C, 0x80, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 
	0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x36, 
	0xC7, 0xFC, 0x23, 0x7F, 0xFF, 0xFC, 0x00, 0x00, 0x13, 0xE0, 0x3E, 0x7E, 0x7E, 0x7C, 0xF8, 0x6F, 
	0x3C, 0x80, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x7E, 0x36, 0xC7, 0xFC, 0x33, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 
	0x13, 0xE0, 0x1E, 0x7E, 0x7E, 0x7C, 0xF8, 0x77, 0x3C, 0x80, 0xFF, 0xFF, 0xFF, 0xF8, 0x80, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7C, 0x36, 
	0x8F, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x13, 0xE0, 0x1E, 0x7E, 0x7E, 0x7C, 0xF8, 0x73, 
	0x3E, 0x80, 0xFF, 0xFF, 0xFF, 0xFC, 0x80, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x3C, 0x25, 0x2C, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x07, 0xE0, 0x1E, 0x7E, 0x7E, 0x7C, 0xF8, 0x3A, 0x7E, 0xC0, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x39, 0x6C, 
	0x60, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xE0, 0x1E, 0x7E, 0x7E, 0x7C, 0xF8, 0x0E, 
	0x7E, 0x40, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0xFF, 0xEE, 0x3E, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x33, 0x1C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x07, 0xE0, 0x1E, 0x7E, 0x7C, 0x7C, 0xF8, 0x41, 0x7C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF8, 0x0E, 0x3F, 0xFF, 0x00, 0xFF, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x93, 0x1C, 
	0x9F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x1E, 0x7E, 0x7C, 0x7C, 0xF8, 0x11, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF0, 0x0E, 0x3F, 0xFF, 0x00, 0xFF, 0xC8, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x06, 0xD7, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 
	0x07, 0xE0, 0x1E, 0x7E, 0x7C, 0x7C, 0xF8, 0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF0, 0x0E, 0x3F, 0xFF, 0x00, 0xFF, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x30, 0x46, 0x7F, 
	0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xE0, 0x1E, 0x7E, 0x7C, 0x7C, 0xF8, 0x01, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF0, 0x1E, 0x3F, 0xFF, 0x00, 0xFF, 0xC8, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1C, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0xE0, 0x1E, 0x7E, 0x3C, 0x7C, 0xF8, 0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF2, 0x7E, 0x3F, 0xFF, 0x00, 0xFF, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCE, 0x6F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xE0, 0x1E, 0x7E, 0x7C, 0x7C, 0xF8, 0x01, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF0, 0xFE, 0x3F, 0xFF, 0x00, 0xFF, 0xC8, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x06, 0x00, 0x27, 0xFF, 
	0x0F, 0xC0, 0x1E, 0x7E, 0x3C, 0x7C, 0xF8, 0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF8, 0xFE, 0x3F, 0xFF, 0x00, 0xFF, 0xEC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xE7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFC, 0x00, 0x04, 0x00, 0x23, 0xFF, 0x0F, 0xC0, 0x1E, 0x7E, 0x3C, 0x3D, 0xF8, 0x01, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0x3F, 0xFF, 0xE4, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF9, 0x22, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xC0, 0x1E, 0x40, 0x7E, 0x3C, 0xF8, 0x00, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xF3, 0xFF, 0xE4, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x3D, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x1F, 0xC0, 0x1E, 0x40, 0x7E, 0x3C, 0xF8, 0x00, 
	0x7E, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0x81, 0xFF, 0xE4, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xE0, 0x91, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 
	0x1F, 0xC0, 0x1E, 0x42, 0x7E, 0x7C, 0xF8, 0x00, 0x7E, 0x7F, 0xFF, 0xF8, 0xFF, 0xF8, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFE, 0x03, 0xFF, 0xE4, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0xBF, 0xFF, 0xFF, 0xF0, 
	0x00, 0x18, 0x00, 0xC0, 0x06, 0x00, 0x67, 0xFF, 0x1F, 0xC0, 0x1E, 0x42, 0x7E, 0x3C, 0xF8, 0x00, 
	0x7E, 0x7F, 0xF1, 0xE0, 0x7F, 0xF8, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFC, 0x87, 0xFF, 0xE4, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xDB, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x18, 0x00, 0xC0, 0x04, 0x00, 0x27, 0xFF, 
	0x1F, 0xC0, 0x1E, 0x40, 0x7E, 0x3C, 0xF8, 0x00, 0x7F, 0x3F, 0xE1, 0x80, 0x7F, 0xF8, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xF9, 0x0F, 0xFF, 0xE4, 0xFF, 0xFF, 0x3F, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xC0, 0x3E, 0x42, 0x7E, 0x3C, 0xF8, 0x86, 
	0x7F, 0x3F, 0x83, 0x23, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0x1F, 0xFF, 0xE4, 0xFF, 
	0xFC, 0x26, 0x78, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x3F, 0x86, 0x47, 0xFF, 0xF8, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xF2, 0x3F, 0xFF, 0xE4, 0xFF, 0x9C, 0x40, 0x40, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0x3F, 0x0C, 0x8F, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF0, 0x78, 0x3F, 0xE4, 0xFF, 
	0x98, 0x02, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 
	0x3E, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x3F, 0x4D, 0x1F, 0xFF, 0xFE, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xF4, 0xF0, 0x7F, 0xE4, 0xFF, 0x9A, 0x26, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x3C, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0x3E, 0x5B, 0x1F, 0xFF, 0xCF, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF4, 0xC3, 0xFF, 0xE4, 0xF3, 
	0x82, 0x67, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x3C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x3E, 0x93, 0x3F, 0xFF, 0x8E, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3C, 0x74, 0x87, 0x1F, 0xF4, 0xF0, 0x83, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7C, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0x3E, 0xB6, 0x7F, 0x8F, 0x1E, 0x7F, 0xFF, 0xFF, 0xFE, 0x38, 0x15, 0xA6, 0x0F, 0xF6, 0xFC, 
	0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x08, 0x00, 0xC0, 0x1C, 0x03, 0xFF, 0xFF, 
	0x7E, 0x7F, 0xFF, 0xFF, 0xFF, 0xCC, 0x00, 0x00, 0x0F, 0xA6, 0xAE, 0x7F, 0x82, 0x18, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3C, 0x45, 0x69, 0x1F, 0xF6, 0xFC, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFE, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x7F, 0xA2, 0x8E, 0x7F, 0xE0, 0x83, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0x24, 0x43, 0x3F, 0xF2, 0xF8, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xB0, 0x0C, 0xFF, 0xF4, 0x83, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xB4, 0xC6, 0x7F, 0xF3, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x7F, 0xB0, 0x9C, 0xC0, 0x02, 0xD0, 0x00, 0x00, 0x0F, 0xFE, 0x3C, 0x32, 0xEE, 0x01, 0xF4, 0x0F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0xC1, 0xFF, 0xFF, 0xE0, 0x01, 
	0xE9, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xB0, 0x9C, 0x00, 0x02, 0x70, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x7B, 0x4E, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x20, 0x01, 
	0xF0, 0x00, 0x00, 0x40, 0xE0, 0x00, 0x60, 0x01, 0xE9, 0x24, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 
	0x7F, 0xA4, 0x9C, 0x7F, 0xFD, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 0x1F, 0xED, 0xBD, 0xFF, 0x83, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xCC, 0x6C, 0x00, 0x0A, 0x00, 0x18, 0x00, 0x00, 0x20, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0A, 0x7F, 0xFF, 0xFE, 0x41, 0xFE, 0xFF, 0xFF, 
	0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x0F, 0xFF, 
	0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x0F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
