#include "../include.h"

// format: Attribute compressed 4x4/4 colors 4-bit paletted pixel graphics
// compression ratio: 75%
// required memory: 16640 B pixels, 8320 B attributes (24960 B total, unpacked 33280 B)
// image width: 320 pixels
// image height: 208 lines
// image pixels pitch: 80 bytes
// image attribute pitch: 160 bytes
const u16 ImgAttr4_Pal[16] __attribute__ ((aligned(4))) = {
	0xED64, 0xCC62, 0x79E0, 0x65AB, 0x4EFF, 0x44EB, 0x44E9, 0x0BF3, 0x1D9B, 0x95B6, 0x2AE7, 0x644A, 0xEFB7, 0xDCE2, 0x28E1, 0xBA61, 
};

const u8 ImgAttr4_Attr[8320] __attribute__ ((aligned(4))) = {
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x70, 0x84, 0xE8, 0xA4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0xA0, 0x84, 0xE8, 0xA4, 0xE7, 0x24, 0x02, 0xE7, 0x00, 0xE2, 0x02, 0xEF, 
	0xE0, 0xA4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0xE8, 0xA3, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0xA8, 0x54, 0xE5, 0xA9, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0xA4, 
	0xE0, 0xA4, 0x0A, 0xE4, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x02, 0xE2, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x84, 
	0xA5, 0x78, 0xE5, 0xA4, 0x00, 0xE4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x84, 
	0xE6, 0x73, 0xE0, 0xA6, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0xE8, 0x74, 0x0A, 0xE4, 0x00, 0xE2, 
	0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0xE7, 0x28, 0xE0, 0x84, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xA0, 0x74, 
	0xA5, 0x63, 0x00, 0x05, 0xE5, 0xA8, 0xE0, 0xA4, 0xA0, 0x84, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE3, 0x54, 
	0x06, 0xA5, 0x00, 0xA6, 0xE7, 0xA4, 0x00, 0x84, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0xE0, 0x84, 0xE0, 0xA4, 0x0A, 0xE4, 0x00, 0xE2, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x2F, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0xE0, 0x2F, 0xE5, 0x24, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0xE8, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0xE5, 0xA3, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0xA5, 0x0A, 0xE7, 0xE8, 0x74, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0xE6, 0xA5, 
	0x00, 0x06, 0x00, 0x06, 0xE0, 0xA6, 0xE8, 0xA4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0xE0, 0xA4, 
	0x02, 0xE5, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x02, 0xEF, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0xE2, 
	0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 0xE7, 0x28, 0xE0, 0x84, 0x00, 0x04, 0x00, 0x04, 0xA0, 0x84, 
	0xE5, 0xA3, 0x00, 0xA4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xA0, 0x74, 0xE5, 0x79, 0x00, 0xA5, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0xA5, 0xE7, 0xA4, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE5, 0xA4, 0x00, 0x63, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xEA, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0xE8, 0xA4, 0x02, 0xE8, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0xEF, 0x2C, 0xE9, 0xAC, 
	0xE0, 0x2C, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0xEF, 0x24, 0x00, 0x74, 0x00, 0xA4, 0x05, 0xA3, 
	0x00, 0x53, 0xE5, 0xA4, 0xE0, 0x74, 0x00, 0x04, 0xE8, 0x74, 0xE3, 0xA4, 0xE7, 0xA4, 0x00, 0x53, 
	0x00, 0x05, 0x00, 0xA5, 0xE0, 0xA5, 0xE0, 0xA5, 0xE5, 0xA3, 0xE8, 0xA4, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE6, 0x74, 0x06, 0xE3, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA5, 0x0A, 0xE4, 0x00, 0xE4, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x74, 0xE8, 0xA4, 0xE7, 0x24, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0xE0, 0x2B, 0x00, 0x9C, 0xE9, 0xAC, 
	0xA0, 0x9C, 0xE3, 0x2C, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0xE5, 0xA4, 0xE5, 0xA4, 0xA0, 0x53, 
	0xE5, 0xA3, 0xE5, 0xA3, 0xE8, 0xA4, 0x00, 0x04, 0x00, 0x84, 0xE0, 0xA4, 0xE5, 0xA3, 0xE0, 0xA5, 
	0xE5, 0xA3, 0x05, 0xA3, 0x05, 0xA3, 0x05, 0xA3, 0x05, 0xA3, 0xE5, 0xA4, 0xE0, 0x74, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x84, 0xE3, 0xA4, 0x00, 0xE6, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x0A, 0xE4, 0xE0, 0x74, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x84, 0xE0, 0xA4, 
	0x02, 0xE7, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xE0, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0x2F, 0xE9, 0x2C, 0xA0, 0xBC, 0xE9, 0xAC, 
	0xEB, 0xA9, 0x00, 0xEC, 0xEB, 0x2C, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0xEA, 0x2F, 0xE5, 0xA4, 0xE5, 0xA3, 
	0x05, 0xA3, 0xE5, 0xA3, 0x0A, 0xE5, 0xE0, 0xA4, 0xE0, 0x74, 0xE5, 0xA3, 0xE5, 0xA3, 0x00, 0x53, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0xE0, 0xA5, 0x0A, 0xE5, 0xE8, 0x74, 
	0x00, 0x04, 0x00, 0x74, 0xA0, 0x74, 0xE5, 0xA9, 0xE7, 0xA5, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA5, 0x00, 0x0A, 0x00, 0xEA, 0xE7, 0xA4, 
	0x00, 0x84, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x54, 0x02, 0xEF, 0x02, 0xEF, 
	0x02, 0xE1, 0xEF, 0x21, 0x00, 0x02, 0x02, 0xE1, 0xE1, 0x20, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0xEB, 0x2C, 0x00, 0xAC, 0xB0, 0x9C, 0xE0, 0x9C, 
	0xE0, 0xAC, 0x00, 0x0C, 0xE0, 0x2C, 0x00, 0x02, 0x02, 0xEF, 0xE0, 0x2F, 0xE0, 0x2F, 0x00, 0x02, 
	0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x2F, 0xE5, 0x23, 0x70, 0x53, 
	0x00, 0x05, 0x00, 0x05, 0x05, 0xA3, 0x0A, 0xE5, 0xE5, 0xA3, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x05, 0xA3, 0x0A, 0xE5, 0xE5, 0xA4, 
	0x00, 0x04, 0x00, 0x74, 0xE0, 0xA4, 0xE8, 0xA4, 0xE5, 0xA3, 0xE5, 0xA3, 0xE5, 0xA3, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0xE6, 0xA3, 0xE6, 0xA3, 0x00, 0xEA, 0xE0, 0x74, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x84, 0x02, 0xE5, 0x02, 0xE1, 0x02, 0xEF, 
	0x02, 0xE1, 0xED, 0x20, 0x02, 0xEF, 0xEF, 0x20, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xE9, 0x00, 0xEC, 0xA0, 0xBC, 0xE0, 0x3C, 
	0xE0, 0xBC, 0xED, 0xAC, 0xE1, 0xBD, 0x00, 0xE2, 0xE0, 0x2F, 0xE0, 0x2F, 0x02, 0xEF, 0x00, 0x02, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0xE5, 0x23, 
	0x00, 0x53, 0xE5, 0xA3, 0xE5, 0xA3, 0xE5, 0xA3, 0xE0, 0xA5, 0x05, 0xA3, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0xA5, 0x00, 0x05, 0x05, 0xE3, 0xE6, 0xA3, 0x0A, 0xE5, 0xE5, 0xA3, 0x00, 0xA5, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xA0, 0x84, 0xE6, 0xA3, 0xE6, 0xA3, 0xE5, 0xA3, 0xE0, 0xA6, 
	0xE5, 0xA3, 0xE6, 0xA3, 0xE5, 0xA3, 0xE0, 0xA6, 0x05, 0xA3, 0xE6, 0xA3, 0x00, 0xA6, 0x0A, 0xE8, 
	0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE7, 0x24, 0xEF, 0x21, 0x2D, 0x10, 0xE1, 0x20, 
	0x02, 0xEF, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 0xE1, 0x20, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xE1, 0xE0, 0xAC, 0x29, 0xBC, 
	0x21, 0xBD, 0x00, 0x01, 0x00, 0x01, 0xEB, 0x2D, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 
	0x00, 0x2F, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0xE1, 0x20, 0x00, 0xE2, 
	0xE5, 0x23, 0x05, 0xA3, 0x05, 0xA3, 0x05, 0xA3, 0x05, 0xA3, 0xE0, 0xA5, 0x05, 0xA3, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0xA5, 0xE5, 0xA3, 0x05, 0xA3, 0xE0, 0xA5, 0x05, 0xA3, 0x00, 0x05, 0x00, 0xA5, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE5, 0xA4, 0x05, 0x63, 0xE6, 0xA3, 0xE0, 0xA6, 0xE0, 0xA6, 
	0x05, 0x63, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 
	0xE7, 0xA4, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0xA4, 0x02, 0xE1, 0x10, 0xD0, 0x00, 0x00, 0x2D, 0x10, 
	0x02, 0xEF, 0x02, 0xEF, 0xE1, 0x20, 0x02, 0xEF, 0x00, 0xE2, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 
	0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0xE2, 0xE9, 0x2C, 0xA0, 0x9C, 
	0x01, 0xBD, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x2D, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0xE1, 0x20, 0xE0, 0x20, 0xEF, 0x2D, 0x00, 0xE2, 
	0x02, 0xEB, 0xA0, 0x53, 0x05, 0xA3, 0xE5, 0xA3, 0xE5, 0xA3, 0xA0, 0x53, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0xE6, 0xA3, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0xA6, 0xE7, 0xA8, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0x02, 0xEB, 0xE1, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0, 
	0xE1, 0x20, 0x02, 0xED, 0x00, 0xE2, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0xE2, 0x02, 0xEF, 0x02, 0xEF, 0xE0, 0x2F, 0xE0, 0x2F, 0x00, 0xE2, 0x00, 0x02, 0xE9, 0xBC, 
	0xE1, 0x2D, 0x00, 0x1D, 0x21, 0xAD, 0xE1, 0x2D, 0x02, 0xED, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0xEF, 0x20, 0x00, 0x02, 
	0x00, 0xE2, 0xEA, 0x25, 0xE5, 0xA3, 0x05, 0xA3, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x04, 0xE0, 0x74, 0xE6, 0xA3, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 
	0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0xA6, 0x0A, 0xE5, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x74, 0x02, 0xE8, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xED, 0x20, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0xE2, 0x2B, 
	0xE1, 0x2D, 0x02, 0xE1, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0x02, 0x02, 0xE1, 0x00, 0xE2, 
	0xE1, 0x20, 0x02, 0xEF, 0xE5, 0xA3, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0xE0, 0xA4, 0xE6, 0x74, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0xA6, 0x00, 0xA6, 0x00, 0xA5, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0xE0, 0xA5, 0xE0, 0xA5, 
	0xE0, 0xA5, 0xE5, 0xA4, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0xEB, 0xA4, 0x02, 0xEF, 0x2D, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x10, 0xD0, 0xE1, 0x20, 0x02, 0xED, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0xE1, 0x20, 0x00, 0x02, 
	0x02, 0xEF, 0x00, 0xE2, 0x02, 0xEB, 0xE0, 0xA5, 0xE0, 0xA5, 0xE0, 0xA5, 0x05, 0xA3, 0x00, 0x05, 
	0x00, 0xA5, 0x00, 0x05, 0x00, 0x05, 0x00, 0x53, 0xE0, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0xE0, 0xA5, 
	0xE6, 0xA5, 0xE7, 0xA5, 0xE7, 0xA5, 0x06, 0xA5, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0xE0, 0xA6, 
	0x0A, 0xE3, 0xE6, 0xA3, 0xE5, 0xA3, 0xE0, 0xA6, 0xE0, 0xA6, 0x00, 0xE6, 0xE6, 0xA3, 0xE5, 0xA3, 
	0xE5, 0xA3, 0x0A, 0xE8, 0x00, 0xE4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0xE8, 0xA4, 0x02, 0xE1, 0xF0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x02, 0xEF, 0x00, 0x2F, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x2F, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0xE2, 0x02, 0xED, 0x00, 0xE2, 
	0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0xE2, 
	0x02, 0xEF, 0x02, 0xEF, 0x00, 0x2F, 0xE5, 0xA3, 0xE5, 0xA3, 0xE5, 0xA3, 0xE0, 0xA5, 0xE0, 0xA5, 
	0xE5, 0xA3, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x05, 0xA3, 0x00, 0xE5, 0xE0, 0xA5, 0xA0, 0x53, 
	0x00, 0x84, 0xE8, 0xA4, 0xE5, 0xA3, 0x00, 0xE6, 0xE0, 0xA6, 0xE0, 0xA6, 0xE5, 0xA3, 0xE6, 0xA3, 
	0x06, 0xA5, 0x00, 0x06, 0x00, 0x06, 0x05, 0x63, 0x06, 0xA3, 0x06, 0xA3, 0x00, 0xA6, 0x05, 0x63, 
	0x00, 0x06, 0x00, 0xA5, 0x0A, 0xE8, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 
	0x02, 0xEB, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x10, 0xEF, 0x20, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x2F, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0xED, 0x20, 0x00, 0xE2, 
	0xE1, 0x20, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0xE5, 0xA3, 0x05, 0xA3, 0x05, 0xA3, 0x00, 0x53, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x04, 0xA3, 0x54, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xEA, 0xE0, 0xA4, 0x00, 0x74, 0x00, 0x04, 0xE7, 0x24, 
	0xE1, 0x20, 0x00, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
	0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x02, 0xE1, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0xEF, 0x20, 0x02, 0xE1, 0xEF, 0x20, 
	0x00, 0xE2, 0xEF, 0x20, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 
	0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEB, 0x05, 0xE3, 0x00, 0x05, 0x00, 0xA5, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0xE0, 0x74, 0xE6, 0xA3, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0xE0, 0xA6, 0x0A, 0xE8, 0xE8, 0xA4, 0x02, 0xE1, 
	0xE1, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x10, 0x2B, 0xF0, 0x20, 0xF0, 0xEB, 0xF0, 0xEF, 0x21, 
	0x00, 0x2F, 0xEF, 0x20, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0xED, 0xF0, 0x02, 0xED, 0x00, 0xE2, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 0x02, 0xEF, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 
	0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x2F, 0xEF, 0xA5, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0x05, 
	0xE0, 0x76, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0xA5, 0xE0, 0xA5, 0xE0, 0xA5, 0x0A, 0xE6, 0x0A, 0xE5, 0x02, 0xEF, 0xE1, 0x20, 
	0x00, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF0, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x00, 0x2F, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x02, 0xEF, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xE1, 0xE0, 0x20, 
	0xE1, 0x20, 0x00, 0xE2, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xE1, 0x00, 0xE2, 0x02, 0xEF, 
	0xE1, 0x20, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xE1, 0xE5, 0xA3, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0xE6, 0xA3, 0xE0, 0xA6, 0x06, 0xA3, 0x02, 0xEB, 0xEF, 0x21, 0x00, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0xF0, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0xEF, 0x21, 0x00, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xE1, 0xF0, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0x02, 
	0x00, 0xE2, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0xE2, 0xEF, 0x20, 0xEF, 0x20, 0x00, 0xE2, 
	0x02, 0xE1, 0x00, 0x02, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x02, 0xEF, 0xEF, 0x21, 0xEF, 0x21, 0xE1, 0x2D, 0x0D, 0x10, 0xA5, 0xF3, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0xE0, 0xA6, 0x00, 0xA6, 0xE0, 0xA6, 0xE0, 0xA6, 0xE6, 0xA3, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 
	0xE0, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0xE6, 0xA3, 0xE0, 0xA5, 
	0xE0, 0xA5, 0xE6, 0xA3, 0xE6, 0xA3, 0x00, 0x63, 0xE5, 0x23, 0xEF, 0x21, 0xF0, 0x10, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xE1, 0xF0, 0x00, 0xEF, 0x00, 0x0F, 0x00, 0x0F, 
	0xEF, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0, 
	0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0xE0, 0x2F, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x00, 0x02, 0x02, 0xED, 
	0x02, 0xEF, 0xE1, 0x20, 0x02, 0xE1, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 
	0xE1, 0x2D, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0xE5, 0x2D, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0xA5, 0xE0, 0xA5, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x05, 0x63, 0x00, 0x06, 0xE5, 0xA3, 0xE6, 0xA3, 0x00, 0xA5, 0xE0, 0xA5, 0xE6, 0xA3, 0xE5, 0xA3, 
	0x06, 0xA3, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0xE6, 0x23, 0x00, 0xE2, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0xEF, 0x21, 0xEF, 0x20, 
	0xE0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x2D, 0x10, 0x02, 0xED, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 0xE1, 0x20, 
	0x00, 0xE2, 0x02, 0xE0, 0xEF, 0x20, 0x02, 0xEF, 0x02, 0xEF, 0xE1, 0x2D, 0xE1, 0x2D, 0x00, 0x1D, 
	0x01, 0x20, 0xE1, 0x2D, 0xEF, 0x2D, 0x21, 0xFD, 0x00, 0x01, 0xE3, 0x2D, 0x00, 0xE5, 0x00, 0xE5, 
	0xE0, 0xA5, 0xEB, 0xA3, 0xEB, 0xA3, 0xE6, 0xA3, 0xE0, 0xA5, 0x0A, 0xE5, 0x0A, 0xE5, 0xE5, 0xA3, 
	0x00, 0x06, 0x00, 0x06, 0x05, 0x63, 0x00, 0x06, 0x00, 0x06, 0x05, 0x63, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0xE6, 0xA3, 0x02, 0xE3, 0xE1, 0x20, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xE1, 0x20, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 0xEF, 0x2D, 
	0x00, 0xE2, 0x00, 0xE2, 0xEF, 0x21, 0xE1, 0x2D, 0x00, 0x01, 0x0D, 0x10, 0xE1, 0x20, 0xE1, 0x2D, 
	0x02, 0xEB, 0x02, 0xE7, 0x02, 0xE7, 0xE1, 0x2D, 0x00, 0x01, 0x25, 0xA1, 0x00, 0xA3, 0xA0, 0x63, 
	0x00, 0x63, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 
	0x00, 0x06, 0x05, 0x63, 0xE5, 0x23, 0x02, 0xE1, 0x10, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0xD0, 0xEF, 0x20, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0xE0, 0x2F, 0xE0, 0x2F, 
	0x00, 0x02, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0xEF, 0x2D, 
	0xEF, 0x21, 0xE1, 0xFD, 0x00, 0x1D, 0x01, 0x2D, 0xE1, 0x2D, 0x02, 0xE1, 0x02, 0xE7, 0x02, 0xE7, 
	0x00, 0xE7, 0x00, 0x07, 0x02, 0xE7, 0xE1, 0xFD, 0x00, 0x01, 0x01, 0x2D, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 
	0x00, 0xA6, 0xE6, 0x23, 0x02, 0xEF, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xED, 0xF0, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x2F, 0x00, 0x0F, 0x02, 0xEF, 
	0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0x02, 0x00, 0xE2, 0xEF, 0x21, 0xE1, 0x2D, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x2D, 0x02, 0xE7, 0x00, 0xA7, 0x00, 0xE7, 0x02, 0xE7, 
	0x00, 0x07, 0x00, 0x07, 0x02, 0xE7, 0xE1, 0x2D, 0x00, 0x01, 0xA1, 0xFD, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 
	0xE5, 0xA3, 0x00, 0xE2, 0xEF, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x02, 0xEF, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 
	0x00, 0x02, 0x02, 0xEF, 0xE1, 0x2D, 0xE1, 0x2D, 0xE1, 0x2D, 0xE1, 0x2D, 0xEF, 0x2D, 0xED, 0x20, 
	0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x2D, 0xE0, 0xA7, 0x00, 0x07, 0x00, 0xE7, 0x02, 0xE7, 
	0xEA, 0x27, 0x02, 0xE7, 0x00, 0x02, 0xE1, 0xFD, 0x00, 0x01, 0xA1, 0xFD, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x05, 0x63, 
	0xEA, 0x23, 0xEF, 0x21, 0x2D, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0xD0, 0x20, 0xF0, 0x00, 0x20, 
	0xE1, 0x20, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xF0, 0xE0, 0x20, 0xE0, 0x20, 0xE1, 0x20, 
	0xE1, 0x20, 0xE1, 0x20, 0xE1, 0x20, 0x01, 0xE0, 0x02, 0xED, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 
	0xE0, 0x21, 0xE1, 0x2D, 0x21, 0xFD, 0xE1, 0x20, 0xE1, 0x2D, 0x02, 0xE7, 0x02, 0xE7, 0x00, 0xE2, 
	0x01, 0xFD, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x2D, 0x07, 0xE8, 0xE0, 0xA7, 0x02, 0xE7, 0x00, 0xE2, 
	0x02, 0xE7, 0xE0, 0xA7, 0x00, 0xE2, 0xE1, 0xFD, 0x00, 0x01, 0x00, 0xA1, 0x00, 0x53, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 0xE0, 0xA5, 0xE5, 0xA3, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0xE0, 0xA5, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0xE6, 0xA3, 
	0x00, 0xE2, 0xE1, 0x20, 0xE0, 0x20, 0xEF, 0x20, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xE7, 
	0x02, 0xE7, 0x00, 0xE2, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF, 0x20, 0xE7, 0x2B, 0xE0, 0x78, 0xE7, 0x28, 
	0x02, 0xE7, 0x20, 0x78, 0xEA, 0x28, 0xE0, 0x21, 0xE1, 0x20, 0xE1, 0x20, 0xE1, 0x2D, 0x00, 0x1D, 
	0xE1, 0x2D, 0xE1, 0x2D, 0x02, 0xE7, 0x02, 0xE7, 0x02, 0xE7, 0x00, 0xA7, 0x00, 0x07, 0x00, 0xE2, 
	0x01, 0xFD, 0x00, 0x01, 0x00, 0x01, 0x01, 0xED, 0x00, 0xE2, 0x02, 0xE7, 0x02, 0xE7, 0x00, 0xE2, 
	0x00, 0x07, 0x00, 0x07, 0x00, 0xE2, 0x01, 0xED, 0x00, 0x01, 0xE1, 0xAD, 0x00, 0x53, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0xE6, 0xA3, 0xE6, 0xA3, 0xEB, 0xA3, 0xE6, 0xA3, 0x05, 0x63, 0x00, 0xA6, 0xE0, 0xA6, 0xE5, 0xA9, 
	0xE9, 0xAC, 0xE0, 0xAC, 0xE6, 0xA9, 0xE0, 0xA6, 0x00, 0xE6, 0xE0, 0xA6, 0x00, 0xA6, 0x0A, 0xEB, 
	0x0A, 0xE3, 0x20, 0xF0, 0xE0, 0x20, 0xE7, 0xA8, 0x00, 0x78, 0xE0, 0xA8, 0x00, 0xE2, 0x00, 0x78, 
	0x00, 0x08, 0xE7, 0x28, 0xEF, 0x21, 0x10, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x20, 0xE0, 0x78, 0x00, 0x08, 0xE7, 0x28, 
	0xE7, 0x28, 0x00, 0x08, 0xE0, 0x28, 0xEF, 0x21, 0x01, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1D, 
	0xE0, 0x21, 0x02, 0xE7, 0x00, 0x07, 0x00, 0xA7, 0x00, 0x27, 0x00, 0x07, 0x00, 0xA7, 0x00, 0xE2, 
	0x21, 0xF0, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x2D, 0x02, 0xE7, 0x00, 0x07, 0x00, 0xE7, 0x00, 0xE2, 
	0xE7, 0xA8, 0xE0, 0x27, 0x00, 0xE2, 0x01, 0x2D, 0x00, 0x01, 0xA1, 0xFD, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0xE3, 0xBC, 0xA0, 0xBC, 0xA0, 0xBC, 0xE9, 0xBC, 0xB0, 0x9C, 0x00, 0x0C, 
	0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x9C, 0xB0, 0x9C, 0xA0, 0xBC, 0x00, 0xAC, 0xB0, 0x9C, 
	0x00, 0x0C, 0x2D, 0x10, 0xE1, 0x20, 0xE0, 0xA8, 0x00, 0x08, 0xE0, 0x78, 0x00, 0xE2, 0xE0, 0x78, 
	0x00, 0x78, 0xE7, 0x28, 0x00, 0xE2, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0xE7, 0x28, 0xE0, 0xA8, 0x02, 0xE7, 
	0xE7, 0x28, 0xE0, 0x28, 0xE7, 0x28, 0x02, 0xEF, 0x01, 0x20, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 
	0xE1, 0x2D, 0x00, 0xE7, 0x00, 0x07, 0xE0, 0xA7, 0x02, 0xE7, 0xE0, 0x27, 0x02, 0xE7, 0x00, 0xE2, 
	0x01, 0x2D, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x2D, 0x02, 0xE7, 0x00, 0xA7, 0x02, 0xE7, 0x00, 0x02, 
	0x00, 0xE2, 0x02, 0xE1, 0xE1, 0x2D, 0x0D, 0x10, 0x00, 0x01, 0xA1, 0xFD, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0xA0, 0x9C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 
	0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 
	0x00, 0x0C, 0x20, 0xFC, 0xE0, 0x20, 0x02, 0xE7, 0x02, 0xE7, 0x02, 0xEA, 0x00, 0x02, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x10, 0x00, 0x20, 
	0x20, 0xF0, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x02, 0xE5, 0xE7, 0x28, 0xE7, 0x28, 
	0x02, 0xE7, 0xE7, 0x28, 0x02, 0xE7, 0x00, 0xE2, 0x21, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0xED, 0x20, 0xE0, 0xA7, 0xE0, 0xA7, 0x02, 0xE7, 0x00, 0xE2, 0x02, 0xE7, 0xE0, 0xA7, 0x00, 0xE2, 
	0x01, 0x2D, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x2D, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xE1, 0xE1, 0x20, 
	0xE1, 0x2D, 0x0D, 0x10, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0xA1, 0xFD, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0xA0, 0x63, 0xB0, 0x9C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0xE0, 0x9C, 0xE9, 0xAC, 
	0x09, 0xEC, 0xEB, 0xAC, 0x09, 0xEC, 0xE0, 0x3C, 0xA0, 0x9C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 
	0x00, 0x0C, 0xB0, 0x1C, 0xE1, 0xF0, 0x02, 0xE7, 0xA0, 0x78, 0xE0, 0xA8, 0x00, 0xE2, 0x07, 0xE8, 
	0x00, 0x78, 0xE7, 0x28, 0x00, 0xE2, 0x00, 0x10, 0xE0, 0xF0, 0x21, 0xF0, 0x0F, 0x21, 0x20, 0xF1, 
	0x0F, 0x21, 0xEF, 0x21, 0xE1, 0x20, 0x00, 0x00, 0xE0, 0x20, 0xE7, 0x28, 0x00, 0x08, 0x20, 0xA8, 
	0xE7, 0x28, 0x00, 0x08, 0x20, 0x78, 0x02, 0xEF, 0x21, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0xED, 0x20, 0x02, 0xE7, 0x0A, 0xE7, 0x02, 0xE7, 0x00, 0xE2, 0x00, 0x07, 0x00, 0x07, 0x00, 0xE2, 
	0x01, 0x2D, 0x00, 0x01, 0x00, 0x01, 0x00, 0x1D, 0xE1, 0x2D, 0x21, 0xF0, 0x0D, 0x10, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0xA1, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0xA0, 0xB3, 0x00, 0x9C, 0x00, 0x0C, 0xE9, 0xBC, 0xE3, 0xAC, 0x00, 0x0E, 0x00, 0xEA, 
	0xE9, 0xBC, 0xE3, 0xAC, 0x00, 0x0E, 0x0A, 0xEC, 0xE9, 0xBC, 0xE9, 0xAC, 0x00, 0x0C, 0x00, 0x0C, 
	0x00, 0x0C, 0x20, 0xBC, 0xE0, 0x20, 0x02, 0xE7, 0x00, 0x08, 0x00, 0x08, 0x02, 0xEA, 0xE7, 0x28, 
	0x00, 0x78, 0xE7, 0x28, 0x02, 0xEF, 0x20, 0x10, 0xEF, 0x21, 0xEF, 0x21, 0xEF, 0x21, 0xE0, 0x2F, 
	0xEF, 0x21, 0x00, 0x0F, 0x20, 0xF1, 0xE1, 0x20, 0xE1, 0x20, 0xE7, 0x28, 0xE0, 0x78, 0xE7, 0x28, 
	0xE7, 0x28, 0x00, 0xE8, 0xE7, 0x28, 0x02, 0xEF, 0x21, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0xE1, 0x2D, 0x02, 0xE7, 0x00, 0x07, 0x00, 0xE7, 0x00, 0xE2, 0xE7, 0xA8, 0x02, 0xE7, 0x02, 0xE1, 
	0x0D, 0x10, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x20, 0xA1, 0x00, 0x53, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0x03, 0xA3, 0xB9, 0x00, 0x0C, 0x00, 0xBC, 0x02, 0xEB, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0xE2, 0x00, 0xE2, 0xE0, 0xAC, 0xA0, 0x9C, 
	0x00, 0x0C, 0x20, 0xDC, 0x20, 0x10, 0x02, 0xE7, 0xE7, 0x28, 0x02, 0xE7, 0x00, 0xE2, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0xE2, 0xEF, 0x21, 0x21, 0xF0, 0x00, 0xF1, 0xEF, 0x21, 0xE0, 0x2F, 0xE0, 0x2F, 
	0x0F, 0xE1, 0x00, 0x0F, 0x00, 0x0F, 0xEF, 0x2D, 0xE0, 0x10, 0xE1, 0x2D, 0xE0, 0x21, 0xE0, 0x21, 
	0xE0, 0x21, 0xE0, 0x21, 0xEF, 0x21, 0xE1, 0x2D, 0x21, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0x01, 0xED, 0x02, 0xE7, 0xE0, 0xA7, 0x02, 0xE7, 0x00, 0xE2, 0x02, 0xED, 0xE1, 0x2D, 0x01, 0x2D, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x2D, 0x00, 0x53, 0xA0, 0xB3, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0xA9, 0x3C, 0x00, 0x9C, 0xEB, 0xA9, 0x00, 0xA9, 0x00, 0xA9, 0x00, 0xA9, 0xA0, 0xB9, 
	0xA0, 0xB9, 0x00, 0xB9, 0x00, 0xB9, 0x00, 0xB9, 0x00, 0xB9, 0x00, 0xB9, 0xEB, 0xA9, 0xEB, 0xA9, 
	0x00, 0x9C, 0xF0, 0xBC, 0x00, 0x00, 0xED, 0x20, 0xE1, 0x20, 0xE1, 0xF0, 0x01, 0x20, 0x01, 0x20, 
	0x01, 0x20, 0x20, 0x10, 0x00, 0x10, 0x02, 0xED, 0x00, 0x0F, 0x00, 0x0F, 0xEF, 0x21, 0xEF, 0x21, 
	0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0xEF, 0x21, 0x10, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0xE1, 0x2D, 0x00, 0xE2, 0x02, 0xE1, 0xE1, 0x20, 0xE1, 0x2D, 0x00, 0x10, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0xED, 0x00, 0x01, 0x01, 0xFD, 0x01, 0x2D, 0x01, 0x2D, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0xE1, 0x20, 0xE1, 0xAD, 0xEF, 0x20, 0x06, 0xA3, 0x06, 0xA3, 
	0xA0, 0xB3, 0x06, 0xA3, 0xA0, 0x63, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0x03, 0xA0, 0x6C, 0xB0, 0x9C, 0x0A, 0xEB, 0x02, 0xE9, 0x02, 0xEB, 0x00, 0xEA, 0x00, 0x0E, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xEA, 0x00, 0xEA, 0x00, 0xE2, 0x02, 0xEA, 0x0A, 0xEB, 0x0A, 0xE5, 
	0xA0, 0x9C, 0x20, 0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE2, 0x00, 0xF1, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x2F, 0xFD, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0x01, 0xFD, 0xE1, 0x2D, 0x0D, 0x10, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0xE3, 0x2D, 0x01, 0xFD, 0x01, 0xFD, 0xE1, 0x2D, 0x25, 0xF1, 
	0x21, 0xAD, 0x01, 0xFD, 0x00, 0x1D, 0xA1, 0x5D, 0xE5, 0x23, 0xA5, 0xF3, 0xE6, 0xA3, 0xA0, 0xB3, 
	0xA0, 0xB3, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0x63, 0xA0, 0x9C, 0xE0, 0xAC, 0x00, 0x0E, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x02, 0x00, 0xE2, 0xE0, 0xA5, 0xE0, 0xA5, 
	0xA0, 0x9C, 0x20, 0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x00, 0xF1, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x0F, 0x21, 0x0F, 0x21, 0x0F, 0x21, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x23, 0x6D, 0x21, 0xBD, 0xA1, 0x5D, 0x26, 0xFD, 0xE6, 0x23, 
	0xE5, 0x23, 0x23, 0xAD, 0xA5, 0xF3, 0x20, 0x53, 0x00, 0x63, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0xA3, 0xB0, 0x9C, 0xE9, 0xBC, 0x00, 0x0E, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x02, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0xEB, 
	0x00, 0x0C, 0x20, 0xBC, 0x10, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0xF1, 0x02, 0xEF, 0x02, 0xEF, 0x0F, 0x21, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0xE1, 0x2D, 0x25, 0xF1, 0xA5, 0xF1, 0xEB, 0x23, 0x20, 0x63, 0xE5, 0xA3, 0xE0, 0xA3, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0xA3, 0xB9, 0x00, 0x0C, 0xE0, 0xAC, 0x00, 0x0E, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x02, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0xEA, 
	0x00, 0x0C, 0xB0, 0x9C, 0x20, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x02, 0xEF, 0x0F, 0x21, 0x00, 0x2F, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF0, 0x00, 0x1D, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x21, 0xFD, 
	0x01, 0x2D, 0xE1, 0xFD, 0xA1, 0xF0, 0xE0, 0x63, 0xE0, 0xA3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0x03, 0x00, 0x03, 
	0x60, 0x3C, 0x00, 0x0C, 0x09, 0xEC, 0x00, 0x0E, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x02, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0x0E, 
	0x00, 0x9C, 0x00, 0x9C, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x10, 0x20, 0x10, 0xE1, 0xA0, 
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x0F, 0x21, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 
	0x25, 0x20, 0x21, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x21, 0xFD, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x0D, 0x10, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x21, 0xFD, 0xEF, 0x23, 
	0xE5, 0x23, 0xE5, 0xA3, 0x00, 0x53, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0xA9, 0x3C, 0x00, 0x9C, 0xEB, 0xAC, 0x00, 0xEA, 0x02, 0xEB, 0xE0, 0x2B, 0x0A, 0xEB, 0x00, 0xEA, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xEA, 0x00, 0xEA, 0xE0, 0x2B, 0x02, 0xEB, 0x00, 0xEA, 0x0A, 0xEB, 
	0xA0, 0x9C, 0x00, 0x0C, 0xBD, 0x10, 0x00, 0x00, 0xA1, 0xB0, 0xE1, 0x20, 0xA5, 0xF3, 0x21, 0xB0, 
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x0F, 0x21, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x20, 0xF1, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0xA3, 0xF0, 
	0xE1, 0xF0, 0xE0, 0xF0, 0x00, 0x10, 0x00, 0x00, 0x20, 0xF0, 0x01, 0x2D, 0x00, 0x01, 0x00, 0x01, 
	0xE1, 0xFD, 0x21, 0xBD, 0x25, 0xF0, 0xE6, 0x21, 0x21, 0xFD, 0x23, 0xBD, 0xE0, 0xA3, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0x03, 0x00, 0x03, 
	0xA9, 0xBC, 0xB0, 0x9C, 0xE0, 0xB9, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 
	0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0xB9, 
	0xEB, 0xA9, 0x00, 0x9C, 0xF1, 0xB0, 0x2D, 0xF0, 0xE6, 0xA1, 0xA3, 0x50, 0xA1, 0xF0, 0x00, 0x00, 
	0x20, 0xF0, 0x10, 0xD0, 0xE1, 0x20, 0x20, 0x10, 0x0F, 0x21, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x20, 0xF1, 0x01, 0x20, 0xE0, 0x10, 0xE1, 0xF0, 0x2B, 0xA3, 
	0xA1, 0xF0, 0x21, 0xF0, 0xE1, 0xF0, 0x00, 0xD0, 0xF0, 0x10, 0x01, 0x2D, 0x00, 0x01, 0xE1, 0x2D, 
	0x25, 0x2D, 0xEB, 0x23, 0xE6, 0x23, 0xE0, 0xA3, 0xA0, 0x53, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0xA9, 0xBC, 0xA0, 0x9C, 0x0B, 0xE9, 0x00, 0xE9, 0x02, 0xE9, 0xE0, 0x29, 0x00, 0xE9, 0x0A, 0xE9, 
	0x02, 0xE3, 0x02, 0xEB, 0x00, 0xEB, 0x00, 0xEB, 0xE0, 0x2B, 0x02, 0xEB, 0x00, 0xEA, 0x00, 0xEA, 
	0xE9, 0xAC, 0x00, 0x0C, 0x01, 0x20, 0xEB, 0xAD, 0x0B, 0x23, 0xE5, 0xA3, 0x20, 0x10, 0x00, 0xF0, 
	0xE1, 0x20, 0xE3, 0x20, 0xE5, 0xA3, 0xEF, 0x21, 0xEF, 0x21, 0x00, 0x2F, 0x00, 0x0F, 0x00, 0x0F, 
	0x00, 0x0F, 0x00, 0xF1, 0x00, 0xF1, 0x20, 0xF1, 0xE1, 0x20, 0x2D, 0x10, 0xE5, 0xA3, 0xE0, 0xA3, 
	0xE5, 0xA3, 0xA5, 0xF3, 0xE1, 0x20, 0x10, 0xD0, 0x10, 0xD0, 0x21, 0xFD, 0x21, 0xBD, 0xA5, 0xF3, 
	0xE0, 0xB3, 0x00, 0x53, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0xA9, 0xBC, 0xE3, 0x69, 0xEB, 0xA3, 0x06, 0xE3, 0x0A, 0xE3, 0xE0, 0x23, 0x0A, 0xE3, 0xEB, 0xA3, 
	0x02, 0xE6, 0xE0, 0x26, 0x06, 0xE3, 0x0A, 0xE3, 0x02, 0xE5, 0x02, 0xE3, 0x00, 0xE3, 0x00, 0xE3, 
	0xE9, 0x6C, 0x00, 0xBC, 0xA3, 0xF9, 0xE5, 0xA3, 0xE0, 0xA3, 0xE0, 0x63, 0xA0, 0x53, 0xA0, 0x63, 
	0xA0, 0x53, 0x00, 0xA3, 0x00, 0x03, 0xA0, 0x53, 0xA0, 0x63, 0x00, 0xA3, 0x00, 0xA3, 0x20, 0xA3, 
	0xE5, 0x23, 0x05, 0x23, 0x06, 0x23, 0xE6, 0x23, 0xE5, 0x23, 0x20, 0xA3, 0x00, 0x53, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0xA3, 0x00, 0xA3, 0x00, 0xA3, 0x25, 0xA3, 0xE5, 0xA3, 0x00, 0x53, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0x63, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
};

const u8 ImgAttr4[16640] __attribute__ ((aligned(4))) = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0xEA, 0xA9, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x58, 0x95, 0xBE, 0x57, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x68, 0x00, 0xAA, 0xFF, 0x55, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6C, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE0, 0x02, 0x88, 0xA9, 0xFF, 0x55, 0xA3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6D, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF5, 0xA9, 0x56, 0x9D, 0xFF, 0xFF, 0xFF, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC5, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x6A, 0xAA, 0xAA, 0x55, 0xFF, 0xFF, 0xFF, 0x5E, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x52, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x51, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA0, 0x96, 0x9A, 0xA5, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x52, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8, 
	0x02, 0xAA, 0x77, 0x6D, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x15, 0x55, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xAA, 
	0x9A, 0xAB, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x35, 0xFF, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC5, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x6A, 0xFE, 
	0x75, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x95, 0xFF, 0x58, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xFE, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xA5, 0xAA, 
	0x55, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0x5A, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x35, 0xFE, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8, 0x00, 0xAA, 0xAF, 
	0x55, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0xFF, 0x56, 0xA0, 0x2F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xB5, 0xFE, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0xAB, 0x66, 0xB5, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAA, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xAA, 0xA7, 0xA7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x6A, 0xFE, 0xAD, 0x95, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAB, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xFF, 0xFF, 0xFF, 0xAA, 0x55, 0x07, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xD5, 0xFF, 0xA1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA0, 0xAA, 0xAA, 0x55, 0x65, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAA, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x15, 0xFF, 0xFF, 0xFF, 0xEA, 0x56, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x55, 0xFF, 0x68, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x08, 0x95, 0xFF, 0x55, 0x69, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAA, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xB8, 0x26, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x55, 0xFF, 0xFF, 0xFF, 0xFA, 0x69, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC5, 0xFF, 0xFF, 0xE8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA5, 0xFA, 0xFF, 0xFF, 0xFF, 0x59, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0xD5, 0xFF, 0xFF, 0x57, 0xEA, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFE, 
	0x9B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0xFF, 0xFF, 0xEA, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0x9A, 0xAB, 0xFF, 0xFF, 0xFF, 0x7A, 0xD5, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x55, 0xFF, 0xFF, 0x56, 0xAF, 0xFF, 0xA3, 0xFF, 0xFF, 0xFF, 0xFC, 
	0xB2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x35, 0xFF, 0xFF, 0xFA, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0x59, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0x56, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x95, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xA8, 0xBF, 0xFF, 0xFF, 0xF8, 
	0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0xFE, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x55, 0xFF, 0xFF, 0xFA, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x2A, 0x67, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x95, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAD, 0xFF, 0xEA, 0x95, 0xFF, 0xFF, 0xAA, 0x2F, 0xFF, 0xFF, 0xF0, 
	0xDC, 0xBF, 0xFF, 0xFF, 0xFF, 0xE0, 0xD5, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x68, 0x22, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xEA, 0xFF, 0xFF, 0xFA, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xA5, 0xFA, 0xBF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0x00, 
	0x0A, 0xFF, 0xFF, 0xFF, 0x55, 0x65, 0x56, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xDB, 
	0xAB, 0x2F, 0xFF, 0xFF, 0xFE, 0xA5, 0x68, 0xAA, 0xFF, 0xFB, 0xFF, 0xFF, 0x5A, 0x8B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xAA, 0xFF, 0xFF, 0xFE, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAA, 0xAA, 0xAA, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x98, 0x29, 
	0xE2, 0xFF, 0xFF, 0xFF, 0x55, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0xFF, 0xFF, 0xE7, 
	0xAB, 0x4B, 0xFF, 0xFF, 0x80, 0xA0, 0x20, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0x76, 0x2F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC5, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x56, 0xB5, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 
	0xF8, 0xFF, 0xFF, 0xFF, 0x57, 0x69, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x92, 0xFF, 0xFF, 0xAD, 
	0xAA, 0x50, 0xBF, 0xFF, 0x6A, 0xAA, 0x79, 0xAA, 0xFF, 0xEF, 0xAF, 0xFF, 0x60, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xE8, 0x0A, 0x5A, 0x55, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 
	0xFE, 0xBF, 0xFF, 0xFF, 0x56, 0x9F, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4, 0xBF, 0xFE, 0xB5, 
	0xAA, 0x66, 0x0B, 0xFF, 0xFF, 0xFF, 0xDB, 0xAA, 0xFF, 0xBF, 0xF0, 0xA8, 0x22, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x5B, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFD, 0x6A, 0x96, 0xA9, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 
	0xFF, 0x2A, 0xFF, 0xFF, 0xEA, 0xFF, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xD1, 0xEA, 
	0x55, 0x52, 0x81, 0xFF, 0xFF, 0xFF, 0x85, 0xFF, 0x74, 0xB5, 0x56, 0xAA, 0x76, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x5A, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x60, 0x5A, 0xA9, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0xFF, 0xFF, 0xA3, 0xFF, 0xFD, 
	0xBF, 0x4A, 0xFF, 0xFE, 0xAF, 0xFF, 0x76, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8D, 0xA9, 0x2A, 
	0x75, 0x70, 0x7F, 0xFF, 0xFF, 0xFE, 0x15, 0xFF, 0xA2, 0x55, 0x57, 0xFD, 0x56, 0x8B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x56, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0x0A, 0x6B, 0xD9, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFF, 0xFF, 0xA2, 0xFF, 0xD0, 
	0x0F, 0xD2, 0xFF, 0xEA, 0xFF, 0xFF, 0x5E, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0x28, 0x3B, 
	0x67, 0xFE, 0xAF, 0xFF, 0xFF, 0xEA, 0xD5, 0xE8, 0x27, 0x55, 0x55, 0x55, 0x55, 0xA2, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x55, 0xAF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x82, 0xAA, 0xA5, 0x76, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xFF, 0xFF, 0xAF, 0xBF, 0xE2, 
	0x03, 0xF8, 0xEA, 0xAF, 0xFF, 0xFF, 0x55, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0xFE, 0xBE, 
	0x02, 0xAA, 0x83, 0xFF, 0xFE, 0x0A, 0xAA, 0x0A, 0x75, 0x55, 0x55, 0x55, 0x55, 0x68, 0x2F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0x6B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFA, 0x95, 0xFA, 0xBF, 0x56, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0xAA, 0x8B, 0xBF, 0xC2, 
	0xA3, 0xFE, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0xFA, 0xE8, 
	0xB6, 0xA8, 0x9B, 0xFF, 0xFE, 0x28, 0x0A, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x67, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0x5A, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 
	0xA5, 0xAA, 0xAB, 0xFF, 0x95, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0xAA, 0x87, 0xAF, 0xE2, 
	0x9A, 0xFF, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAC, 0x62, 0x09, 
	0xD7, 0xFD, 0x76, 0xBF, 0xFE, 0xB5, 0x5F, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x5A, 0xA7, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x56, 0x2F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 
	0x56, 0x9A, 0xFF, 0xFE, 0x55, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xAA, 0x8F, 0xAF, 0xD2, 
	0x5A, 0xFF, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x5D, 
	0x55, 0x55, 0x55, 0x2F, 0xF8, 0xD5, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD7, 0x0B, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x55, 0x8B, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x2A, 
	0x5A, 0x75, 0xFF, 0xFB, 0xD9, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 0xAB, 0x2F, 0xCF, 0xF8, 
	0x56, 0xFF, 0xCA, 0xFF, 0xFF, 0xFA, 0xAF, 0x55, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x05, 0x55, 
	0x55, 0x55, 0xD5, 0x8B, 0xE2, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x96, 0x2F, 
	0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFA, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x69, 0x56, 
	0xA9, 0x6A, 0xFF, 0x5B, 0xE2, 0x59, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xA8, 0xBF, 0xCB, 0xFC, 
	0x22, 0xFF, 0xE2, 0xFF, 0x55, 0x83, 0xE2, 0xFF, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAD, 0xAA, 
	0xFF, 0xFF, 0xDA, 0x5A, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xA9, 0xA7, 
	0xFF, 0xFF, 0xFF, 0x6B, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFE, 0x1F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA6, 0xAA, 
	0x95, 0xAA, 0xFF, 0x5B, 0xEA, 0x56, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x90, 0xFF, 0xE3, 0xFE, 
	0x8B, 0xFF, 0xF2, 0xFF, 0x55, 0x2F, 0xF8, 0xFF, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x8F, 0xAA, 
	0xFF, 0xFF, 0x5A, 0x76, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xD5, 0x22, 
	0xFF, 0xFF, 0xFA, 0x1D, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x80, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x6E, 0x95, 
	0xD9, 0x82, 0xFF, 0x5B, 0x4A, 0x5E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x2B, 0xFF, 0xF2, 0xFF, 
	0xFF, 0xFF, 0xF2, 0xFF, 0x6A, 0x3F, 0xF8, 0xFF, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x81, 0xEA, 
	0xFF, 0xFF, 0x56, 0x5B, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFE, 0x26, 
	0xFF, 0xFE, 0x00, 0x60, 0x12, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x65, 0xAD, 
	0x6F, 0xF8, 0xFF, 0x5A, 0x2A, 0x55, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x07, 0xFF, 0xF0, 0xFF, 
	0xFF, 0xFF, 0xE2, 0xFF, 0xBF, 0xFF, 0xF8, 0xFF, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xAE, 0x28, 0x3A, 
	0xFF, 0xFF, 0x5D, 0xAF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xDA, 0xAA, 
	0xFF, 0xFE, 0x2A, 0xAA, 0xDB, 0x55, 0x60, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x97, 0xDA, 0xFF, 0x0B, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0xA5, 0x69, 
	0x5B, 0xDD, 0x95, 0xA8, 0xFF, 0xFF, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x5B, 0xFF, 0xFC, 0xBF, 
	0xFF, 0xFD, 0x84, 0xFE, 0xBF, 0xFF, 0xFA, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0x55, 0xFE, 0xFF, 0x1D, 
	0xAA, 0x55, 0x76, 0x95, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xAA, 0x6A, 0x2A, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x45, 0x56, 0x2A, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0x62, 0x5A, 0xEA, 0xBF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0xA9, 0x59, 
	0x56, 0x97, 0x6D, 0x09, 0xFF, 0xFF, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0x56, 0xFF, 0xFE, 0xBF, 
	0xFF, 0xD8, 0xBC, 0xBE, 0xBF, 0xFF, 0xD9, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0x57, 0xEB, 0xFF, 0x8F, 
	0xAA, 0x5F, 0x62, 0xD5, 0xFF, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x0A, 0x5D, 0x76, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xB6, 0x82, 0xBA, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0x58, 0x28, 0xBE, 0xBF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0xBA, 0x5A, 
	0x55, 0x08, 0x96, 0xA2, 0xFF, 0xFF, 0x59, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0x56, 0xBF, 0xFF, 0x2F, 
	0xFA, 0x89, 0xDE, 0xBF, 0x3F, 0xFF, 0xE5, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0x76, 0xAF, 0xFF, 0x89, 
	0xAA, 0xD6, 0xA7, 0x55, 0xE0, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0x69, 0xD7, 0x55, 0xAA, 
	0xFF, 0xFF, 0xFF, 0x60, 0xA0, 0xA7, 0xE1, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0x5E, 0x2A, 0xFF, 0x2F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x56, 0xB6, 0x5E, 
	0x95, 0xAA, 0x59, 0xF8, 0xFE, 0xFA, 0x7A, 0xFF, 0xFF, 0xFA, 0xAF, 0xFF, 0x55, 0xAF, 0xFF, 0x8A, 
	0xA0, 0x95, 0x57, 0xEF, 0x80, 0x02, 0x95, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0x6A, 0xFF, 0xFB, 0xA1, 
	0xEE, 0x02, 0x5A, 0xA0, 0xA2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0x55, 0xF6, 0xA7, 0x55, 0xEA, 
	0xFF, 0xFF, 0xFF, 0x82, 0x85, 0xF5, 0x49, 0xFF, 0x56, 0x29, 0x55, 0xFF, 0x57, 0x41, 0xEA, 0x6F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xA8, 0x2C, 0x00, 
	0x95, 0xFF, 0xFE, 0xD9, 0xFB, 0xD4, 0x96, 0xFF, 0xFF, 0xAB, 0xFF, 0xFF, 0xFF, 0x6B, 0xFF, 0xD0, 
	0x2F, 0xFF, 0xFF, 0x4A, 0xFA, 0xAA, 0xBF, 0xFF, 0xAA, 0x67, 0xFF, 0xFE, 0xAF, 0xFF, 0x88, 0xFF, 
	0xD5, 0xAA, 0xAA, 0xAA, 0xEB, 0xFF, 0x55, 0xFF, 0xFF, 0xFE, 0x0A, 0xAA, 0xA2, 0x9D, 0xFF, 0xFA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 0x55, 0x2D, 0xFF, 0x50, 0x20, 0x29, 0xFF, 0xAA, 0xA5, 0xEA, 0x5B, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xA2, 0xBF, 0x68, 
	0xA5, 0xFF, 0xFF, 0xA5, 0xFA, 0x7F, 0x6E, 0xBF, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0xFF, 0xD1, 
	0xD5, 0xFF, 0xFF, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xE9, 0xFF, 0xAA, 0xFF, 0xFF, 0x1E, 0xBE, 
	0xB5, 0xFF, 0x5F, 0xFF, 0xAD, 0xFF, 0x95, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAF, 0xD5, 0xFF, 0xFE, 
	0xFF, 0xFF, 0xFF, 0xFC, 0x35, 0x74, 0x95, 0xFE, 0x01, 0xD6, 0xA0, 0x00, 0xAA, 0x75, 0xFA, 0x56, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0x0B, 0x7F, 0xF4, 
	0x6B, 0xFF, 0xFF, 0x75, 0xFE, 0x29, 0x96, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xBF, 0xF8, 
	0xD5, 0xFF, 0xFF, 0xD2, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x6A, 0xAA, 0xBF, 0xFF, 0xFF, 0x1E, 0xBF, 
	0x1D, 0x55, 0x55, 0x76, 0xB5, 0xF8, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0x55, 0x6A, 0xD5, 0xA0, 0xAD, 0x55, 0xD6, 0xAB, 0x5D, 0x55, 0xFF, 0x55, 
	0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xF4, 
	0x59, 0xFF, 0xFA, 0x95, 0xFF, 0x80, 0x5A, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x2F, 0xF8, 
	0xD5, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xAE, 0x9D, 0xFB, 0xFF, 0xEB, 0xFF, 0x9E, 0xBF, 
	0x8D, 0x55, 0x55, 0xE9, 0xD6, 0x8A, 0x55, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0xE9, 0x8A, 0xA8, 0x2B, 0xDA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 
	0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x5B, 0x0F, 0xFF, 0xF4, 
	0x9A, 0x55, 0xA1, 0xE5, 0xFF, 0x75, 0xA7, 0xFF, 0x65, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0x87, 0xF8, 
	0xD5, 0xFF, 0xFF, 0x78, 0xEF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0x7A, 0xFF, 0x28, 0x2A, 0x3E, 0xBF, 
	0xE7, 0xAA, 0x56, 0x0A, 0x80, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF1, 0x6A, 0x6A, 0xAF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 
	0xA1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x59, 0xFF, 0xFF, 0xF4, 
	0x96, 0xB5, 0x8B, 0xE5, 0xFF, 0x6A, 0x55, 0xFF, 0xEB, 0xFF, 0xFF, 0x55, 0xA9, 0xFF, 0xA3, 0xF8, 
	0x55, 0xFF, 0xFF, 0x74, 0xFA, 0xFF, 0xFF, 0xFF, 0xAB, 0xFF, 0x56, 0xFE, 0xBF, 0x8A, 0x24, 0xFF, 
	0x5B, 0xEA, 0x5E, 0x82, 0xA5, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xE9, 0xAA, 0x5D, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x6B, 0xBF, 0xFF, 0xFE, 
	0x95, 0x95, 0x87, 0x65, 0xFE, 0x95, 0x55, 0xFF, 0x59, 0xFF, 0xFF, 0x5E, 0xB6, 0xFF, 0xA2, 0xF8, 
	0x55, 0xFF, 0xFF, 0x5E, 0xBF, 0xBF, 0xFF, 0xEA, 0xBF, 0xFF, 0x55, 0xBF, 0x1D, 0xE2, 0x82, 0xFF, 
	0x56, 0xEA, 0x57, 0x47, 0xF5, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x85, 0xAA, 0x55, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x6A, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x67, 0xFF, 0xFF, 0xFE, 
	0x67, 0x65, 0x8A, 0x9D, 0xAB, 0x55, 0x55, 0xFF, 0x56, 0xFF, 0xFF, 0xAA, 0xFE, 0xBF, 0xA8, 0xBC, 
	0x95, 0xFF, 0xFF, 0x5D, 0xAF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0x55, 0xAF, 0x89, 0xE2, 0x96, 0xFF, 
	0x5E, 0x3A, 0x57, 0x1D, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFA, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0x05, 0xFF, 0xFF, 0xFE, 
	0x60, 0x69, 0xFA, 0x5A, 0x95, 0xFF, 0xFF, 0xFF, 0xFE, 0xB5, 0x56, 0x22, 0xFE, 0xBF, 0xFF, 0x3E, 
	0xB5, 0xAA, 0x55, 0x57, 0x65, 0xEA, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xFA, 0xAF, 0x02, 0xFF, 
	0xFF, 0x1F, 0x5E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFC, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xA1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x96, 0x27, 0xFF, 0xFF, 0xFF, 
	0x58, 0xAA, 0xFF, 0xA9, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0x59, 0xFF, 0xFC, 0xBF, 0xFF, 0x2E, 
	0xB5, 0xAA, 0x55, 0x5F, 0xEA, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFF, 0xFE, 0x18, 0xFF, 
	0xFF, 0x87, 0x74, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x5A, 0x9F, 0xFF, 0xFF, 0xFF, 
	0xD5, 0x5A, 0xAA, 0x9D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x5B, 0xFF, 0xFC, 0xFF, 0xFF, 0x8D, 
	0x35, 0xAA, 0x7F, 0xDA, 0xAA, 0xBF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0xFF, 0xFE, 0xFE, 0xFF, 
	0xFF, 0x43, 0xD1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE2, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xDA, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xA7, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF9, 0xFB, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x5A, 0xFF, 0xF0, 0xFF, 0xFF, 0x89, 
	0x35, 0xAF, 0xD2, 0x00, 0x96, 0xBF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xFF, 0xFE, 0x74, 0xFF, 
	0xBF, 0xA1, 0x4B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC5, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x69, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0xFE, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0x56, 0xAA, 0xAB, 0xFF, 0xFF, 0xAB, 
	0xB5, 0xFD, 0xAA, 0xBF, 0xFF, 0xAF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0xFF, 0x99, 0xFE, 
	0x82, 0x56, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0xFE, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0xD5, 0xEA, 0xAF, 0xFF, 0xFF, 0xA3, 
	0xFD, 0x6A, 0xBF, 0xFF, 0xFF, 0xEB, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0xFF, 0x67, 0xFB, 
	0xD8, 0x9E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xD6, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD4, 0xBF, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 
	0xD8, 0xA5, 0xFF, 0xFF, 0xFF, 0xEB, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xFF, 0x69, 0xFA, 
	0x7D, 0x95, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF6, 0xBF, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4, 
	0x00, 0x59, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 0xFF, 0xBE, 0xFE, 
	0x1F, 0xE5, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 
	0xFF, 0x56, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x56, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x82, 0x59, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 
	0xAF, 0xFE, 0xAB, 0xFF, 0xFF, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFE, 0xB4, 0xFF, 
	0x67, 0xBF, 0xE7, 0xFF, 0xFF, 0xFF, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 0xFE, 
	0xEA, 0xA0, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x5A, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x60, 0xAA, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xFF, 0xFF, 0xFF, 0xFE, 0xAB, 
	0xEB, 0xFF, 0xFF, 0xAA, 0xAA, 0xA5, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xFE, 0xB6, 0xFF, 
	0x5A, 0xFF, 0xDB, 0xFF, 0xFF, 0xFC, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xC0, 0xAA, 
	0xA8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0x6B, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xD6, 0x5A, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 
	0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0x57, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xBE, 0xB4, 0xFF, 
	0x55, 0xFF, 0xA9, 0xAF, 0xFE, 0x80, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAF, 0xFF, 0xFF, 0xF8, 
	0xF8, 0x55, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0A, 
	0xAA, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x9F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF9, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 
	0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xBE, 0xB8, 0xFF, 
	0x55, 0xFA, 0x96, 0xE0, 0x00, 0xA2, 0xD5, 0xFF, 0xFA, 0xFF, 0xFF, 0xAB, 0x80, 0xAA, 0xAA, 0x02, 
	0xC3, 0xFF, 0xFE, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x82, 0xA9, 0xFF, 0xFF, 0xFF, 0x5D, 0x82, 
	0xAA, 0x5B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xA9, 0x2B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD2, 0x65, 0xAA, 0xFF, 0xFF, 0xFF, 0xAA, 0x5A, 0xD5, 0x56, 0xAF, 0x55, 0xFF, 
	0x56, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0x99, 0xFF, 
	0x5D, 0xA9, 0xAA, 0xBA, 0xA9, 0xD1, 0xFF, 0xFF, 0x69, 0xFF, 0xFF, 0xFF, 0x5A, 0xAA, 0x0A, 0x2F, 
	0x1D, 0xFF, 0xC2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFE, 0x56, 0x28, 0x0A, 0xBF, 0xFF, 0xFF, 0x57, 0xD8, 
	0x2A, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x5B, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD8, 0xE9, 0xAA, 0xFF, 0xFF, 0xFF, 0xAA, 0x56, 0x95, 0xA9, 0xFF, 0x59, 0xFF, 
	0x55, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x67, 0x65, 0xFF, 
	0x5A, 0x95, 0xAB, 0x2F, 0xF7, 0xCB, 0xFF, 0xFF, 0x25, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xEA, 
	0x55, 0xE8, 0x13, 0xD5, 0xFF, 0xFF, 0xFF, 0xEA, 0x59, 0x7D, 0xA0, 0x0A, 0xBF, 0xFF, 0x56, 0xAA, 
	0x7A, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x59, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD8, 0x5A, 0xEA, 0xFF, 0xFF, 0xFF, 0xAA, 0x76, 0xAA, 0x95, 0xFF, 0x66, 0xBF, 
	0xA7, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0xF5, 0xFE, 
	0xA9, 0xD5, 0xAA, 0x8B, 0x55, 0xAD, 0xFF, 0xE0, 0x15, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xAA, 
	0x80, 0x01, 0xDF, 0x55, 0xFF, 0xFF, 0xFA, 0xA8, 0xA7, 0x55, 0x76, 0x80, 0x00, 0xAA, 0x00, 0xA5, 
	0x56, 0x55, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x6B, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF4, 0xB6, 0xAA, 0xFF, 0xFF, 0xFF, 0xAB, 0x69, 0x59, 0xD5, 0xFF, 0xAF, 0xBE, 
	0xD9, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x95, 0xAA, 
	0x5D, 0x55, 0xAA, 0xA1, 0xD4, 0x2A, 0xA0, 0x0B, 0xD5, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xAA, 
	0xAA, 0x7F, 0x6D, 0xFF, 0xFF, 0xFF, 0xAA, 0x02, 0xBD, 0xFF, 0xFF, 0xDA, 0xAA, 0xAA, 0xAF, 0xD6, 
	0xFF, 0xAA, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0x0A, 0xBF, 0xFF, 0xAA, 0xFF, 0xFE, 0xAF, 0xFE, 0xFF, 0xFF, 0x87, 0xEF, 
	0xD2, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xAF, 0xAA, 0xBF, 
	0xFF, 0xFF, 0xFF, 0x56, 0xD6, 0xAA, 0xAA, 0xAE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xB5, 0xFF, 0xFF, 0xEA, 0x80, 0xA7, 0xD5, 0xFF, 0xFF, 0xA9, 0x75, 0xF7, 0xFF, 0xAA, 
	0xFF, 0xEA, 0x5A, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6D, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0xBF, 0xFF, 0xAA, 0xFF, 0xEA, 0xFF, 0xFF, 0xBF, 0xFF, 0x8B, 0xFB, 
	0xD2, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0xFF, 0xFF, 0xFF, 0x55, 0xFE, 0xBF, 0x67, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0xB5, 0xFD, 0x5F, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE0, 0x69, 0xFF, 0xAA, 0x00, 0xA9, 0xD5, 0x55, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0xFF, 0xAA, 
	0xFF, 0xFA, 0x55, 0x2F, 0xFF, 0xFF, 0xFF, 0xFE, 0xB6, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0xAF, 0xFF, 0xAA, 0xFE, 0xBF, 0xFF, 0xFF, 0xAF, 0xFF, 0xA0, 0xBE, 
	0x4A, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFF, 0xFF, 0xFF, 0x55, 0xEB, 0xFF, 0x59, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x55, 0x1D, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF4, 0x00, 0xAA, 0x08, 0xAB, 0x75, 0x55, 0x55, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0xFF, 0xAA, 
	0xFF, 0xFE, 0x55, 0x8B, 0xFF, 0xFF, 0xFF, 0xFC, 0x69, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xEB, 0xFF, 0xAE, 0xAB, 0xFF, 0xFF, 0xFF, 0xEF, 0xFA, 0x2A, 0xFF, 
	0x2A, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xFF, 0xFF, 0xFF, 0xDA, 0xAF, 0xFF, 0x7A, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x55, 0x85, 0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xFA, 0xFF, 0xFF, 0xFF, 0xF8, 0x25, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x9A, 0x75, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xEB, 0x89, 0x65, 0xAA, 
	0xFF, 0xA9, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x55, 0xFF, 0xFF, 0xAB, 0xFF, 0xFF, 0xFE, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xEA, 0xFE, 0x2F, 0xFF, 0xFF, 0xD2, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x66, 0xA6, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0x2F, 0xE7, 0x82, 
	0xFF, 0x02, 0xE5, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x95, 0xFF, 0xEA, 0xBF, 0xFF, 0xFF, 0xFF, 0xBF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x79, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xFF, 0x8B, 0xFF, 0xFF, 0x4A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0x89, 0x65, 0x16, 
	0xFE, 0xB8, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xA5, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x75, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0xBF, 0xFF, 0x2A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xD9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xA0, 0x95, 0xBE, 
	0xBE, 0x7F, 0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0x7A, 0xEA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xB5, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEA, 0xA8, 0x9F, 0xFE, 0x95, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 
	0xBA, 0x1F, 0xFF, 0xFF, 0xFF, 0xD8, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xB5, 0xFF, 0xA6, 
	0xFF, 0xAF, 0xBE, 0x55, 0xFF, 0xFF, 0x5D, 0xEB, 0x7A, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0x69, 0x74, 0x56, 0x17, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x7F, 0x05, 
	0xFF, 0x4B, 0xFF, 0xFF, 0xFF, 0xFE, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0xFF, 0x59, 
	0xFF, 0xFA, 0xFE, 0x95, 0xFF, 0xFF, 0xDA, 0xBF, 0x56, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x56, 0x22, 0x5A, 0x5F, 0xFF, 0xFF, 0xFE, 0x02, 0xA8, 0x04, 0x95, 
	0xFF, 0x52, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0xFE, 0x9D, 
	0xFB, 0xFF, 0xFF, 0x95, 0xFF, 0xFF, 0xA9, 0xFF, 0x5D, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xE2, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x55, 0x0A, 0xA7, 0x9F, 0xFF, 0xFF, 0xF8, 0xAA, 0xAA, 0xA0, 0x55, 
	0xFF, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xFA, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xFA, 0xE5, 
	0xAE, 0xFF, 0xFF, 0xAD, 0xFF, 0xEA, 0x9D, 0xFE, 0xA5, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAF, 0xFF, 
	0x8F, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x5A, 0xAA, 0x26, 0xBF, 0xFF, 0xFF, 0xD2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xD8, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x5B, 0xCA, 
	0x1E, 0xBF, 0x55, 0x67, 0xDA, 0xA5, 0xFF, 0x56, 0xE2, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xBF, 0xFF, 0xFF, 0xFF, 0x55, 0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x3F, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xA7, 0x99, 0x57, 0xFF, 0xFF, 0xFF, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xD4, 0xBA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x59, 0xCA, 
	0x0F, 0xEF, 0x57, 0x6A, 0xAA, 0x55, 0xFF, 0x55, 0xD2, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEF, 0xFF, 0xFF, 0xFF, 0xDA, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEA, 0x08, 0x00, 0xAA, 0x7E, 0x5B, 0x7F, 0xFF, 0xFF, 0xFF, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xF6, 0x96, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x56, 0x8A, 
	0x81, 0xEF, 0x56, 0x96, 0xAD, 0x56, 0xBF, 0x59, 0xD2, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEB, 0xFF, 0xFF, 0xFF, 0xA9, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x02, 0xAA, 0x5F, 0xF6, 0x59, 0x7F, 0xFF, 0xFF, 0xFF, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xF5, 0xAD, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0x2A, 
	0xA0, 0xBF, 0x6A, 0x55, 0xE5, 0x57, 0xEB, 0x5B, 0xD2, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFB, 0xFF, 0xFF, 0xFA, 0x9F, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE0, 0xAF, 0x55, 0xD9, 0x83, 0xBF, 0xFF, 0xFF, 0xFF, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0x82, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0xFF, 
	0xFF, 0xDA, 0xA7, 0xFF, 0xFB, 0x8F, 0xF0, 0xFF, 0xE5, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x56, 0x9A, 0xA8, 0x0A, 0xAB, 0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x76, 0x0B, 0x55, 0xE5, 0x85, 0xBF, 0xFF, 0xFF, 0xFF, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x54, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0xFF, 
	0xFF, 0xA9, 0x55, 0xFF, 0xFA, 0x4B, 0xFC, 0xFE, 0x95, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x56, 0x08, 0x00, 0xA5, 0x59, 0x8D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5F, 0xC2, 0x57, 0x95, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x53, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 
	0xFA, 0x95, 0x55, 0xFF, 0xFE, 0xA0, 0x58, 0xFF, 0x55, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x79, 0x40, 0x27, 0x5D, 0xA9, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x58, 0x2F, 0x5E, 0x76, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xFF, 
	0xAB, 0x55, 0x55, 0xFF, 0xFF, 0x26, 0x02, 0xFF, 0x55, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE9, 0xFF, 0xFF, 0xD5, 0xAA, 0xC5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x25, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0A, 0xBF, 
	0xFF, 0x68, 0x0A, 0xBA, 0x78, 0x82, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2A, 0xFF, 0xFF, 0xFF, 
	0x55, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA6, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x76, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0x5A, 0x95, 0xAA, 0x5A, 0xD5, 0xFF, 0xFF, 0xFF, 0x5D, 
	0x09, 0xAF, 0xFF, 0xFF, 0xFF, 0xC5, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xA8, 0xB5, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x00, 
	0x00, 0x0A, 0x9D, 0xAA, 0x50, 0x27, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xFF, 0xFF, 0xFF, 
	0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x6E, 0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0x59, 0xFE, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0x67, 0xE5, 0xA8, 0x56, 0x55, 0xFF, 0xFF, 0xFF, 0x5A, 
	0x25, 0xAA, 0xFF, 0xFF, 0xFF, 0xE9, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2A, 0xAA, 0x80, 0x20, 0xD5, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x75, 0xEA, 
	0xAA, 0x97, 0x55, 0xAA, 0xEA, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0xFF, 0xFF, 0xFF, 
	0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xBF, 0xFF, 0xFF, 0xFF, 0xAB, 0x69, 0xFF, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0x67, 0x65, 0xA2, 0xA5, 0x95, 0xFF, 0xFF, 0xFE, 0xA9, 
	0x5D, 0xAA, 0xFF, 0xFF, 0xFF, 0xE9, 0xFF, 0xFF, 0xFE, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0xAA, 0xFB, 0x55, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 
	0xFF, 0x55, 0x55, 0xAB, 0x8A, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 
	0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0xEF, 0xFF, 0xFF, 0xFF, 0xB8, 0x95, 0xFF, 
	0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0x56, 0x95, 0x87, 0xDB, 0xA5, 0xFF, 0xFF, 0xEA, 0x7F, 
	0xF5, 0xAA, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xDA, 0xFF, 0x57, 0x45, 0xFF, 0xFF, 0x55, 0x60, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x55, 0xBF, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x42, 0x55, 0x55, 
	0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x69, 0xFF, 0xFF, 0x55, 0xEA, 0xFF, 0xFF, 
	0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0xA9, 0xFF, 0x67, 0xF8, 0x65, 0x55, 0xA0, 0x09, 0xAF, 
	0x55, 0x55, 0xFF, 0x55, 0xFF, 0xE9, 0xFF, 0xFF, 0xFF, 0x60, 0x29, 0x69, 0xFF, 0xFF, 0xFF, 0x56, 
	0xAA, 0xFF, 0x5D, 0x9D, 0xFF, 0xFF, 0xA8, 0x09, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5C, 0xFE, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x95, 0x58, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xAA, 0xFF, 0xFF, 0xDA, 0xAF, 0xFF, 0xFF, 
	0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0x80, 0xFF, 0x59, 0x78, 0xE9, 0x55, 0x02, 0x95, 0xFA, 
	0x55, 0x7F, 0x69, 0xD5, 0xFF, 0xE9, 0xFF, 0xFF, 0xFF, 0xA2, 0x80, 0x2A, 0xAA, 0x55, 0x55, 0xA0, 
	0xAA, 0xFF, 0x58, 0xAA, 0xAA, 0x80, 0x0A, 0x9D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x78, 0xFE, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x4B, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDA, 0xBF, 0xFF, 0xA9, 0xFF, 0xFF, 0xFF, 
	0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x2E, 0xBF, 0x56, 0x02, 0x6A, 0xAA, 0x25, 0x7D, 0xAA, 
	0x57, 0xD8, 0x00, 0xB5, 0xFF, 0xE9, 0xFF, 0xFF, 0xE8, 0x07, 0xF6, 0xAA, 0x80, 0xAA, 0xAA, 0x2B, 
	0xAA, 0xFF, 0x5A, 0xAA, 0xAA, 0xAA, 0x57, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x52, 0xFB, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x2F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0xAA, 0xAA, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x67, 0x1D, 0xBF, 0x55, 0xA9, 0xAD, 0x57, 0x57, 0x55, 0xAA, 
	0xF6, 0x00, 0xA8, 0x35, 0xFF, 0xD0, 0xAA, 0xAA, 0x02, 0x7F, 0xFF, 0xFD, 0xEA, 0x55, 0x55, 0x7F, 
	0xFF, 0xFF, 0xA7, 0xFF, 0xFF, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0xE5, 0x09, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x69, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x9F, 0xFF, 0xFF, 0x98, 0x27, 0xFF, 0x6A, 0x55, 0x7F, 
	0xDA, 0x95, 0x56, 0xB5, 0xFF, 0xF2, 0xAA, 0x08, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x57, 0x6A, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0xDB, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x9F, 0xBF, 0xFF, 0x80, 0x95, 0xFF, 0xAA, 0x5F, 0xD8, 
	0xA9, 0x6A, 0x56, 0x15, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5E, 0x99, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0xBA, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x8E, 0xBF, 0xFE, 0x09, 0x55, 0xFF, 0xAA, 0xF6, 0x00, 
	0x56, 0x9F, 0x96, 0x1D, 0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x54, 0x59, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xA6, 0x55, 0xFF, 0xFF, 0xFE, 0xAF, 
	0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA0, 0xFF, 0xEA, 0xBF, 0xD5, 0xFF, 0x9E, 0xA0, 0x2A, 
	0xAB, 0xFF, 0xE5, 0x1D, 0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 
	0xFF, 0xAA, 0x72, 0x59, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0xBF, 0xFF, 0x55, 0x82, 0x82, 
	0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x15, 0xA0, 0x0A, 0xAE, 0x55, 0x57, 0xF6, 0xA5, 0x56, 
	0xBF, 0xFF, 0xE5, 0x1D, 0xFF, 0x79, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 
	0xFF, 0xAA, 0xE2, 0x59, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0xBF, 0xFF, 0x55, 0x0F, 0xF8, 
	0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x00, 0x02, 0x95, 0xEA, 0x55, 0xFE, 0xA9, 0x55, 0x5B, 
	0xFF, 0xFF, 0xE5, 0x1D, 0xFF, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 
	0xFF, 0xA9, 0x4A, 0x59, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xEF, 0xFF, 0xAA, 0x3F, 0xFE, 
	0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x2A, 0x9F, 0x5D, 0xAA, 0x57, 0x60, 0x96, 0xA9, 0x5B, 
	0xFF, 0xFF, 0xE5, 0x2D, 0xFF, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 
	0xFF, 0xAB, 0x2A, 0x67, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xEB, 0xFE, 0x7D, 0xBF, 0xFE, 
	0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xBF, 0xFF, 0x55, 0xAA, 0x5E, 0x02, 0x69, 0xFE, 0x5B, 
	0xFF, 0xFF, 0xE5, 0x2D, 0xFF, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 
	0xFF, 0x5E, 0xB5, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x59, 0x59, 0xFF, 0xFF, 0xF6, 
	0xFF, 0xFE, 0x55, 0xFF, 0xFF, 0xAA, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x5A, 0xBF, 0xFE, 0x5B, 
	0xFF, 0xFF, 0xE5, 0x2D, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 
	0xFF, 0x54, 0x9A, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x96, 0x57, 0xFF, 0xFF, 0xFA, 
	0xFF, 0xFF, 0x95, 0xFF, 0xFF, 0xA0, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0x50, 0x67, 0xFF, 0xFE, 0x5B, 
	0xFF, 0xFF, 0xE5, 0x2D, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xAB, 0x72, 0xA7, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x9E, 0xB9, 0xFF, 0xFF, 0xD9, 
	0xFF, 0xFF, 0x95, 0xFF, 0xFE, 0x09, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x6F, 0xFF, 0xFE, 0x57, 
	0xFF, 0xFF, 0x65, 0x2D, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEA, 0x62, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x67, 0x96, 0xBF, 0xFF, 0xE5, 
	0xFF, 0xFF, 0x6D, 0xFF, 0xEA, 0x9F, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xBF, 0xFF, 0xFE, 0x57, 
	0xFF, 0xFF, 0x95, 0x2D, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x56, 0xEF, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xAD, 0xBF, 0x57, 0xEF, 
	0xFF, 0x55, 0x82, 0x80, 0x29, 0x5D, 0xFF, 0xF5, 0xAA, 0xFF, 0xFF, 0xD2, 0x3F, 0xFF, 0xFE, 0x57, 
	0xFF, 0xFE, 0xFF, 0x2D, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 
	0x55, 0xBF, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xA5, 0xFE, 0xAA, 0xBF, 
	0xFF, 0x57, 0x88, 0x02, 0x95, 0xD5, 0xFD, 0x89, 0xAA, 0xFF, 0xFF, 0xD2, 0x3F, 0xFF, 0xFE, 0x57, 
	0xFF, 0xE9, 0xFF, 0x2D, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 
	0x5E, 0xBF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xA9, 0xFF, 0x55, 0xFF, 
	0xFF, 0x56, 0x2F, 0x55, 0x7D, 0x7F, 0x60, 0x02, 0xEA, 0xFF, 0xFF, 0xD2, 0x3F, 0xFF, 0xFE, 0x5B, 
	0xF4, 0x95, 0xFF, 0x2D, 0xFF, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 
	0x54, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x99, 0xFF, 0x55, 0xFF, 
	0xFF, 0xDA, 0x95, 0xFF, 0x5F, 0xD8, 0x02, 0xA8, 0xBA, 0xFF, 0xFF, 0xD2, 0x2F, 0xFF, 0xFE, 0x56, 
	0x02, 0x55, 0xFF, 0x2D, 0xFF, 0x54, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xF6, 0x60, 0x2B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x66, 0x55, 0xFF, 0xFF, 
	0xAA, 0x02, 0x75, 0x57, 0xF6, 0xAA, 0x55, 0xFE, 0xB5, 0xFF, 0xFF, 0xD2, 0x95, 0xFF, 0xF5, 0xFF, 
	0x55, 0x00, 0xFF, 0x2D, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xD0, 0x02, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0x55, 0xFF, 0x66, 0xB5, 0xFF, 0xFF, 
	0x80, 0x25, 0xD5, 0x7D, 0x80, 0x95, 0x59, 0xFE, 0xB5, 0xFF, 0xFF, 0xD2, 0x95, 0xFF, 0xD9, 0xFF, 
	0x5A, 0xBF, 0xBF, 0x1D, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 
	0xC8, 0x1F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xD9, 0x9D, 0xFF, 0xEA, 
	0x0B, 0x5D, 0x5F, 0x68, 0x0A, 0x56, 0x96, 0xBE, 0xB5, 0xFF, 0xFF, 0xD2, 0x9D, 0xFF, 0xA5, 0xFF, 
	0xAF, 0xFF, 0xBF, 0x1D, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 
	0x2A, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, 0xA0, 0xAA, 0x80, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x02, 0x02, 0xAA, 0xAA, 0xAA, 0xAA, 0xA7, 0xFA, 0xA9, 0xEA, 0xAF, 
	0xFF, 0xD7, 0xF8, 0x02, 0xAA, 0xAB, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0xD2, 0xA5, 0x80, 0x55, 0xFE, 
	0xBF, 0xFF, 0xBF, 0x1D, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xA9, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 
	0xBF, 0x27, 0xFF, 0xF5, 0xD6, 0xAA, 0xAA, 0xA5, 0x55, 0xFA, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xE0, 0x00, 0x2A, 0x55, 0x00, 0x2A, 0x8B, 0xD9, 0x80, 0x0A, 0xAA, 
	0x75, 0xFD, 0x6A, 0x95, 0x5A, 0xBF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0xDA, 0xFA, 0x95, 0x55, 0xFE, 
	0xFF, 0xFF, 0xFF, 0x9D, 0xFF, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEA, 0x05, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x54, 
	0xFF, 0x27, 0xFE, 0xA0, 0xA5, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x15, 0xAA, 0x6A, 0x59, 0x00, 0x42, 0x8B, 0xDB, 0xFD, 0x55, 0xFA, 
	0x5F, 0x60, 0xA5, 0x69, 0x5B, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0x5A, 0xFF, 0x5A, 0xA9, 0xFE, 
	0xFF, 0xFF, 0xEE, 0x9D, 0xFF, 0x54, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xA8, 0x25, 0xFF, 0xFF, 0xFF, 0xEA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x72, 
	0xFE, 0x97, 0xF0, 0x2A, 0x55, 0xFF, 0xFF, 0x5A, 0xAA, 0xFF, 0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x15, 0xFF, 0xD2, 0x6F, 0xBF, 0xF2, 0x8B, 0xD3, 0x55, 0xF5, 0xAA, 
	0x74, 0x02, 0x5A, 0xB6, 0x57, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0x5A, 0xFF, 0xA7, 0xFE, 0xFE, 
	0xFF, 0xFF, 0xEE, 0x95, 0xFF, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0x28, 0xB5, 0xFF, 0xFF, 0xFF, 0xA2, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x61, 
	0xFA, 0x9F, 0xE2, 0xA0, 0xA9, 0xEF, 0xFE, 0xBF, 0xFF, 0xBF, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x17, 0xFF, 0xD2, 0x6F, 0xFF, 0xF2, 0x8B, 0xD1, 0x55, 0x55, 0xAA, 
	0xE0, 0xA8, 0xAF, 0xFE, 0x57, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0x5A, 0xFA, 0xFF, 0xFE, 0xFE, 
	0xFF, 0xFF, 0xEE, 0xB5, 0xFF, 0x76, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x65, 0x6A, 0x02, 0x99, 0xEA, 0xFF, 0xFF, 0x5A, 0x88, 0x2A, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 
	0xA5, 0xBF, 0xE2, 0x25, 0xAB, 0xE2, 0xFE, 0xAF, 0xFF, 0x4A, 0x8B, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x2F, 0xFF, 0xD2, 0x87, 0xFF, 0xF2, 0x8B, 0xF9, 0xFF, 0xFF, 0xAB, 
	0xC2, 0x69, 0xFF, 0xFE, 0xAB, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0x70, 0x5B, 0xFF, 0xFE, 0xFE, 
	0x55, 0xFF, 0xBE, 0xB5, 0xFF, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x02, 0xA7, 0xEB, 0xAA, 0xFF, 0xFF, 0xA8, 0x2F, 0x80, 0xAA, 0xFF, 0xFF, 0xFF, 0xFE, 0x75, 
	0x7D, 0xBF, 0xE2, 0x17, 0xFF, 0xFA, 0xFE, 0xAF, 0xFF, 0xCA, 0x8B, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x2F, 0xFF, 0xD2, 0x87, 0xFF, 0xFA, 0x8B, 0xF9, 0xFF, 0xFF, 0xAB, 
	0xCA, 0xAF, 0xFF, 0xFE, 0xAB, 0xFF, 0xFF, 0xBE, 0x35, 0xFF, 0xFF, 0x78, 0x5B, 0xFF, 0xFE, 0xFE, 
	0x55, 0xFF, 0xBE, 0xB5, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x9F, 0xFE, 0x1D, 0xAA, 0xFF, 0xFE, 0x82, 0x7F, 0xFA, 0x00, 0x0A, 0xFF, 0xFF, 0xFF, 0x65, 
	0x56, 0x3F, 0xE2, 0x1F, 0xFF, 0xFA, 0xFE, 0xBF, 0xFF, 0xEA, 0xA1, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x2F, 0xFF, 0xD2, 0x87, 0xFF, 0xFA, 0x83, 0x79, 0xFF, 0xFF, 0xAB, 
	0xCA, 0xBF, 0xFF, 0xFE, 0xAB, 0xFF, 0xFF, 0xBE, 0x35, 0xFF, 0xFF, 0x78, 0x5B, 0xFF, 0xFE, 0xFE, 
	0xB5, 0xF0, 0xFE, 0xB5, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x6A, 0x75, 0x55, 0xFE, 0xA0, 0x9F, 0xFF, 0xFF, 0xFD, 0xF8, 0xAA, 0x0A, 0xAA, 0xAF, 
	0x56, 0x3F, 0xE2, 0x1F, 0xFF, 0xF8, 0xFE, 0xBF, 0xFF, 0xDA, 0xA1, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x2F, 0xFF, 0xD2, 0x87, 0xFF, 0xF2, 0xA1, 0x79, 0xFF, 0xFF, 0xAB, 
	0xCA, 0xBF, 0xFF, 0xFE, 0xAB, 0xFF, 0xFE, 0xBE, 0x35, 0xFF, 0xFF, 0x78, 0x5B, 0xFF, 0xFE, 0xFF, 
	0x16, 0x0A, 0xFE, 0x75, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA0, 0xA0, 0xAA, 0x2F, 
	0xFF, 0x3F, 0xD2, 0x2F, 0xFF, 0xF8, 0xFE, 0xBF, 0xFF, 0xDA, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xF9, 0x87, 0xFF, 0xF2, 0x5B, 0x79, 0xFF, 0xFF, 0xFF, 
	0x4A, 0xBF, 0xFF, 0xFE, 0x57, 0xFF, 0xF6, 0xFE, 0xB5, 0xFF, 0xFF, 0x78, 0x5B, 0xFF, 0xFE, 0xFF, 
	0xEA, 0x55, 0x82, 0xEA, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x49, 0xAA, 0xAA, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x1F, 0xD2, 0x2F, 0xFF, 0xF8, 0xFE, 0xBF, 0xFF, 0xD2, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x1F, 0xFF, 0xF9, 0x87, 0xFF, 0xD2, 0x59, 0x79, 0xFF, 0xFF, 0xFF, 
	0x42, 0xBF, 0xFF, 0xFC, 0x5B, 0xFF, 0x69, 0xFE, 0xB5, 0xFF, 0xFF, 0x78, 0x5B, 0xFF, 0xFE, 0xFF, 
	0xFF, 0x56, 0x0B, 0x6A, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAF, 0xD2, 0x2F, 0xFF, 0xFC, 0xFE, 0xBF, 0xFF, 0xD2, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x85, 0xA8, 0xA5, 0xA1, 0x80, 0x0A, 0x59, 0x79, 0xFF, 0xFF, 0xFF, 
	0xC2, 0xBF, 0xFF, 0xFC, 0x5B, 0xF8, 0x95, 0xFE, 0xB5, 0xFF, 0xFF, 0x78, 0x5B, 0xFF, 0xFA, 0xFF, 
	0xFF, 0xAA, 0x9F, 0xAA, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAF, 0xD2, 0xAF, 0xFF, 0xF8, 0xFF, 0x2F, 0xAA, 0x4A, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0xA0, 0xAA, 0x55, 0xAA, 0xAA, 0xAA, 0x59, 0x79, 0xFF, 0xFF, 0xFF, 
	0xE2, 0xBF, 0xFF, 0xFC, 0x5A, 0x0A, 0x5A, 0xFE, 0xB5, 0xFF, 0xFF, 0x78, 0x5B, 0xFE, 0xA5, 0xFF, 
	0xAA, 0x9F, 0xD5, 0xAA, 0xFF, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xA5, 0xF2, 0x6F, 0xFF, 0xF9, 0xFF, 0xEA, 0xAA, 0xBF, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x5D, 0xAA, 0xAA, 0x55, 0xAA, 0x55, 0xFB, 0x72, 0xEA, 0xFF, 0xFF, 
	0x62, 0x3F, 0xFF, 0xF6, 0xFF, 0x56, 0x0E, 0xBE, 0xB5, 0xFF, 0xFF, 0x78, 0xFA, 0xEA, 0x55, 0x80, 
	0x09, 0x76, 0xFF, 0xFF, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x45, 0xF8, 0x5A, 0xAA, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x5A, 0x00, 0x0A, 0x56, 0x00, 0xA5, 0xFB, 0x72, 0xEA, 0xFF, 0xFF, 
	0xE2, 0x3F, 0xFF, 0xD9, 0xFF, 0x69, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0x78, 0xFF, 0xBF, 0x5A, 0x09, 
	0x7F, 0xAA, 0xFF, 0xFF, 0xFF, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x45, 0xF8, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x67, 0x55, 0x52, 0x5B, 0x55, 0xF9, 0xFB, 0x72, 0xEA, 0xFF, 0xFF, 
	0xE2, 0x3F, 0xFE, 0xA5, 0xFE, 0x9F, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0x74, 0xFF, 0xFA, 0xA9, 0x9F, 
	0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC5, 0xF8, 0x55, 0x55, 0x55, 0xFF, 0xEA, 0xAB, 0xAF, 0xFB, 0xBF, 0xFF, 0xFF, 0xE8, 0xAA, 
	0x02, 0xBF, 0xFF, 0xFF, 0xD2, 0x5F, 0xFF, 0xF6, 0x6F, 0xFF, 0xF9, 0xFB, 0x72, 0xEA, 0xFF, 0xFF, 
	0xE2, 0x2F, 0xE0, 0x55, 0xFA, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0x5C, 0xAA, 0xAB, 0x7F, 0xD5, 
	0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC9, 0xF8, 0x56, 0x00, 0x80, 0xFF, 0x95, 0xAB, 0xCA, 0xFB, 0xBF, 0xFF, 0xFD, 0xAA, 0x0A, 
	0xAA, 0xAB, 0xFF, 0xFF, 0xF2, 0x87, 0xFF, 0xF8, 0x87, 0xFF, 0xF0, 0x59, 0x72, 0xEA, 0xFF, 0xFF, 
	0xE2, 0x6A, 0xAA, 0xA9, 0xFB, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0xAE, 0x82, 0x27, 0xDA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xAA, 0x0A, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC9, 0xF4, 0x5B, 0xAF, 0xFE, 0xFF, 0x97, 0xFF, 0xEA, 0xFB, 0xBF, 0xFF, 0x40, 0x97, 0xAA, 
	0x57, 0x68, 0x9F, 0xFF, 0xFA, 0x87, 0xFF, 0xF8, 0x87, 0xFF, 0xF0, 0x59, 0x72, 0xEA, 0xFF, 0xFF, 
	0xE2, 0x56, 0xA7, 0xF9, 0xFF, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0xAB, 0xDF, 0xF5, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xAA, 0x00, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC9, 0xF4, 0x57, 0xBF, 0xFE, 0xBF, 0x9F, 0xFF, 0xDA, 0xFB, 0xBF, 0xFE, 0x09, 0x55, 0xAA, 
	0x55, 0x5D, 0x07, 0xFF, 0xFA, 0x87, 0xFF, 0xF8, 0x8B, 0xFF, 0xF8, 0x59, 0x72, 0xEA, 0xFF, 0xFF, 
	0x62, 0x5A, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x95, 0x40, 0xAA, 0x00, 0x2A, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC1, 0xF4, 0x57, 0xFF, 0xFE, 0xBF, 0x9F, 0xFF, 0xDA, 0xFB, 0xBF, 0xE0, 0x9A, 0x55, 0xBF, 
	0x55, 0x55, 0x61, 0xFF, 0xF8, 0x87, 0xFF, 0xF8, 0xAB, 0xFF, 0xF8, 0x5B, 0x72, 0xEA, 0xFF, 0xFF, 
	0x62, 0x6F, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xBE, 0xB5, 0xFF, 0xFF, 0xAA, 0x55, 0x55, 0xAA, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFE, 0xFF, 0xAA, 0xF5, 0xF8, 0xFF, 0xAA, 0x96, 0x9F, 0xFF, 0xFF, 
	0xFF, 0xE1, 0xFC, 0x5B, 0xFF, 0xFF, 0x95, 0x1F, 0xFF, 0xD2, 0x59, 0xBF, 0xCB, 0x55, 0xA7, 0xE2, 
	0x55, 0xFF, 0xB0, 0x7F, 0xF8, 0x87, 0xFF, 0xFA, 0xAB, 0xFF, 0xF6, 0x5B, 0x72, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x6F, 0xFF, 0xFE, 0xFB, 0x55, 0xFF, 0x96, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xFF, 0xFF, 0xF8, 0x90, 0xFF, 0xAB, 0xE1, 0xD0, 0xFF, 0xAB, 0xD7, 0xC7, 0xFF, 0xFF, 
	0xFF, 0xE1, 0xFE, 0x5B, 0xFF, 0xFF, 0xD5, 0x2F, 0xFF, 0xD2, 0x5B, 0xBF, 0x1D, 0x56, 0x28, 0x28, 
	0x15, 0xFF, 0xAC, 0x3F, 0xF8, 0x87, 0xFF, 0xF2, 0xAB, 0xFF, 0xF6, 0x5B, 0x71, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x6F, 0xFF, 0xFE, 0xFB, 0x55, 0xFE, 0x56, 0x9A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFA, 0xFF, 0xFF, 0xC0, 0x70, 0xFF, 0xAA, 0x55, 0x40, 0xFF, 0xA7, 0xA7, 0x8B, 0xFF, 0xFF, 
	0xFF, 0xD1, 0xFE, 0x9B, 0xFF, 0xFF, 0xE5, 0xAF, 0xFF, 0xD2, 0x5B, 0xBC, 0xB5, 0x78, 0x54, 0xBF, 
	0xAD, 0xFF, 0xAB, 0x2F, 0xF8, 0x87, 0xAA, 0xD2, 0xA1, 0xFF, 0xD2, 0x5B, 0x71, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x6F, 0xFF, 0xFE, 0xFB, 0xD5, 0xE9, 0x5A, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF2, 0xFF, 0xFF, 0xA6, 0x50, 0xFF, 0xAA, 0x28, 0x00, 0xFF, 0xA9, 0x80, 0x02, 0xFF, 0xFF, 
	0xFF, 0xD1, 0xFE, 0x9B, 0xFF, 0xFF, 0xD5, 0x85, 0xAA, 0x8A, 0x6B, 0xBC, 0x55, 0x71, 0x55, 0xFF, 
	0xAD, 0xFF, 0xAB, 0x87, 0xF4, 0xA0, 0x00, 0x0A, 0xA8, 0xAA, 0x0A, 0x5B, 0xF1, 0xEA, 0xFF, 0xFF, 
	0xD2, 0x6F, 0xFF, 0xFE, 0xFE, 0x58, 0x95, 0xAB, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFF, 0x53, 0xFF, 0xFF, 0xED, 0xAA, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xBF, 0xEA, 0xBF, 0xFF, 
	0xFF, 0xE2, 0xFC, 0x9B, 0xFD, 0xF6, 0xBF, 0xFA, 0xAF, 0xFF, 0x8B, 0x74, 0xAA, 0x72, 0xFF, 0xFF, 
	0x95, 0xFF, 0xFF, 0x6B, 0xFC, 0x2A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x89, 0x71, 0xAA, 0xFF, 0xFF, 
	0x5A, 0x6F, 0xFF, 0xF5, 0xFE, 0xA5, 0x80, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x53, 0xFF, 0xFF, 0xE9, 0xFA, 0xFF, 0xFF, 0xBF, 0xFA, 0xFF, 0xFF, 0xFF, 0xEA, 0x2F, 0xFF, 
	0xFF, 0xF2, 0xFC, 0x96, 0x00, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 0xF8, 0xEA, 0x58, 0xFF, 0xFE, 
	0xB5, 0xFF, 0xFF, 0xE3, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0xF2, 0xEA, 0xFF, 0xFF, 
	0x5A, 0x6F, 0xFF, 0xD9, 0xFF, 0x5A, 0x09, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x53, 0xFF, 0xFF, 0x65, 0xFA, 0xFF, 0xFF, 0xBF, 0xFA, 0xFF, 0xFF, 0xFF, 0xEA, 0x0B, 0xFF, 
	0xFF, 0xF2, 0xFE, 0x95, 0xAA, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x27, 0xF0, 0xEA, 0x5E, 0x3F, 0xFC, 
	0x55, 0xFF, 0xFF, 0x63, 0xFF, 0xDA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA5, 0x5B, 0xF2, 0xEA, 0xFF, 0xFF, 
	0x5A, 0x6F, 0xFE, 0xA5, 0xFF, 0xA9, 0x7F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xBF, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x6B, 0xFF, 0xFE, 0xA9, 0xFA, 0xFF, 0xFF, 0xAE, 0xEA, 0xFF, 0xFF, 0xAA, 0xAA, 0x02, 0x0B, 
	0xFF, 0xF2, 0xFF, 0x65, 0xAA, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x97, 0xF0, 0xAA, 0x55, 0x8F, 0xF2, 
	0xD5, 0xFF, 0xFF, 0x51, 0xFF, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xF0, 0xEA, 0xFF, 0xFF, 
	0x7A, 0x6F, 0xC0, 0x55, 0xEA, 0x5F, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0xBF, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8B, 0xFF, 0x54, 0xAA, 0xAA, 0xAA, 0xA0, 0x0A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAB, 0xFD, 0xD3, 
	0xFF, 0xFA, 0xFF, 0x40, 0x00, 0x0A, 0xAA, 0xAA, 0xAA, 0x0A, 0xAF, 0xF5, 0xFF, 0xFF, 0xE0, 0x8B, 
	0xFF, 0xFF, 0xFF, 0x5A, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xEA, 0xFF, 0xFF, 
	0x70, 0xEA, 0x95, 0xA0, 0x09, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0x55, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0xF5, 0x54, 0x7A, 0x7E, 0x5B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8B, 0xFE, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFA, 
	0xFF, 0xF8, 0xFF, 0xDA, 0xAA, 0xA9, 0x55, 0x55, 0x55, 0xAB, 0xFF, 0xE9, 0xFF, 0xFF, 0x5E, 0x2D, 
	0xFF, 0xFF, 0xFF, 0x78, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xEA, 0xFF, 0xFF, 
	0x78, 0xFF, 0x55, 0x02, 0x7F, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0xFF, 0x55, 0x55, 0x7D, 
	0xFF, 0xFF, 0xFF, 0x5D, 0x76, 0x70, 0x7E, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 
	0xFF, 0x87, 0xFE, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x36, 
	0xBF, 0xF8, 0xFF, 0xFD, 0x55, 0x55, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0xFF, 0xFF, 0x55, 0xD5, 
	0xFF, 0xFF, 0xFF, 0x78, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xEA, 0xFF, 0xFF, 
	0x78, 0xFF, 0x6A, 0x1F, 0xD5, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x75, 0xFF, 0x57, 0xD5, 0xD7, 
	0xFF, 0xFF, 0xFF, 0x87, 0x7A, 0xB4, 0x76, 0xFB, 0xFA, 0x5A, 0x0B, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 
	0xFF, 0x87, 0xFE, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xA1, 
	0xBF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0xFF, 0x58, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xEA, 0xFF, 0xFF, 
	0x74, 0xAA, 0xA7, 0xF5, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0xFF, 0x5E, 0xB5, 0xEB, 
	0xFF, 0xFF, 0xFF, 0xE1, 0xDA, 0x74, 0xBE, 0x79, 0x00, 0xAA, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8F, 0xFE, 0xFF, 0xFF, 0xF5, 0xFE, 0xFF, 0xBF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0x69, 0x57, 
	0xBF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xEA, 0xFF, 0xFF, 
	0x5E, 0x0A, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x55, 0x5E, 0x15, 0xC3, 
	0x54, 0x55, 0xAA, 0x70, 0xF9, 0xB4, 0x34, 0x30, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8F, 0xFF, 0x95, 0xAA, 0xAA, 0xAA, 0xFF, 0xBF, 0xFA, 0xAA, 0xAA, 0xBF, 0xAA, 0xEA, 0xA5, 
	0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xEA, 0xFF, 0xFF, 
	0x57, 0xFF, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xD5, 0x57, 0x2F, 0x96, 
	0xF4, 0x75, 0xAA, 0x74, 0xA5, 0xE5, 0x25, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8F, 0xFE, 0xAA, 0xA5, 0x56, 0xAA, 0xFF, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0x6A, 0xEA, 0xA6, 
	0x3F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xEA, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6, 0x55, 0x5D, 0x2F, 0x94, 
	0xF2, 0x75, 0xAA, 0x72, 0xAD, 0x0F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAF, 0xFF, 
	0xFF, 0x2F, 0xFC, 0xAA, 0xA5, 0x56, 0xAA, 0xFF, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0x6A, 0xBD, 0xFF, 
	0x2F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xEA, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6, 0xB5, 0x5E, 0xAF, 0x14, 
	0xDA, 0xB5, 0xAF, 0xF2, 0x2F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xAA, 0xAA, 
	0xFF, 0x2F, 0xFE, 0xFF, 0xAF, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xBF, 0x3F, 
	0x0F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x55, 0x55, 0x56, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0x35, 0x74, 0x6F, 0xB6, 
	0xE6, 0x7F, 0xFA, 0x02, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x2F, 0xFC, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0x3F, 0x2F, 
	0x2F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x55, 0x55, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x15, 0x72, 0x6C, 0x7A, 
	0xAE, 0xD0, 0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x2F, 0xFC, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0x2F, 0xEE, 
	0x2F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x55, 0x55, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x2D, 0xC1, 0x2C, 0xF6, 
	0xB6, 0x29, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x3F, 0xFC, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0x02, 0xFC, 
	0xBF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAA, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x76, 0x97, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x8F, 0x45, 0x63, 0xF8, 
	0xFC, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x3F, 0xF4, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAB, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xEA, 0xA9, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xF1, 0xEB, 0x2F, 0x87, 0xF2, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFE, 0x3F, 0xF4, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAB, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAB, 0xA5, 0x56, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x00, 0xBC, 0xFB, 0x3F, 0x2F, 0xFB, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xFE, 0xBF, 0xF4, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAB, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x95, 0xAA, 0x5E, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x78, 0x1D, 0x4A, 0xBA, 0xBE, 0x3F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xFF, 0xF8, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAB, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x96, 0x97, 0x56, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x83, 0xF0, 0xB4, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5A, 0xFF, 0xF8, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAB, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x96, 0xB5, 0xFE, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x57, 0xF8, 0xFE, 0x3E, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x52, 0xFF, 0xF8, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAB, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0x55, 0xFE, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xD5, 0x5D, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 0xAA, 0xBE, 0xAA, 0xAA, 0xBF, 0xBF, 0xFF, 0xFF, 
	0x53, 0xFF, 0xF8, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAB, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE9, 0x55, 0xFE, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0x77, 0x57, 0xD6, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xBE, 0xAA, 0xAA, 0xAE, 0xBF, 0xFF, 0xFF, 
	0x53, 0xFF, 0xF8, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xAA, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0xFE, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x5E, 0x1E, 0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA3, 0xFF, 0xFA, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x56, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x0D, 0xFF, 0xFF, 0xFE, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0x5D, 0x49, 0x89, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 
	0x83, 0xFF, 0xDA, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x56, 0x9F, 0xFF, 0xFF, 0xFF, 0xE2, 0x09, 0xFF, 0xFF, 0xFE, 0xB5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0x5C, 0x66, 0x47, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAF, 
	0x83, 0xFF, 0xDA, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x9F, 0xFF, 0xFF, 0xFE, 0x98, 0xA7, 0xFF, 0xFF, 0xFE, 0x35, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0x78, 0xCB, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xEF, 0xEF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xBE, 0xFF, 0xFF, 0xFF, 
	0x83, 0xFF, 0xDA, 0xFF, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 
	0xBF, 0xFF, 0xBF, 0xFF, 0xFF, 0x83, 0xF8, 0xA0, 0xBF, 0xFF, 0xFF, 0x48, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x5E, 0x9F, 0xFF, 0xFF, 0xF0, 0x52, 0x7F, 0xFF, 0xFF, 0xFE, 0x35, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xDA, 0xFF, 0xFF, 0xFF, 0xF1, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xAA, 0xAA, 0xAF, 0xEA, 0xAA, 0xAA, 0xFA, 0xAA, 0xAA, 0xBE, 0xAA, 0xAA, 0xBE, 0xBF, 0xFF, 0xFF, 
	0x87, 0xFF, 0xD0, 0xAA, 0xA5, 0xA8, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xAA, 0x6A, 0xAA, 0xAA, 
	0xBF, 0xFF, 0x1F, 0xFF, 0xF4, 0x87, 0xF1, 0x81, 0xBF, 0xFF, 0xFF, 0x48, 0x55, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xFF, 0xFF, 0xD1, 0x49, 0xFF, 0xFF, 0xFF, 0xFE, 0xB5, 0xFF, 0xFF, 
	0x55, 0x5D, 0x0F, 0xFF, 0x55, 0x7D, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x87, 0xFF, 0xD0, 0xAA, 0xA5, 0xA8, 0xAA, 0xAA, 0xBF, 0xFF, 0xAA, 0xAA, 0xAA, 0x6A, 0xAA, 0xAA, 
	0xBF, 0xFF, 0x2F, 0xFF, 0xD2, 0x9F, 0x8C, 0x27, 0xFF, 0xFF, 0xFF, 0xC8, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xFF, 0xFF, 0xC5, 0x2B, 0xFF, 0xFF, 0xFF, 0xFC, 0xB5, 0xFF, 0xFF, 
	0x5D, 0x74, 0x2C, 0x3C, 0x3F, 0x60, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0xFF, 0xC0, 0xAA, 0xAA, 0xA0, 0xAA, 0xAA, 0xAF, 0xFA, 0xAA, 0xAA, 0x0A, 0xAA, 0xAA, 0xAA, 
	0x2B, 0xFF, 0x2F, 0xFF, 0xC4, 0xBE, 0x30, 0x5F, 0xFF, 0xFF, 0xFF, 0xC0, 0xB5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xFF, 0xFF, 0x84, 0x97, 0xFE, 0xFF, 0xFF, 0xFE, 0xB5, 0xFF, 0xFF, 
	0x57, 0x72, 0x70, 0xB6, 0xB8, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0xFE, 0x62, 0xFF, 0x5F, 0xFF, 0xD5, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xBF, 0xF5, 0xFF, 0x57, 
	0x02, 0xFF, 0x2F, 0xFF, 0xA4, 0x7A, 0xD2, 0x7F, 0xFF, 0xFF, 0xFF, 0xD0, 0xB5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xFF, 0xFF, 0x14, 0x9F, 0xE0, 0xAF, 0xFF, 0xFE, 0xB5, 0xFF, 0xFF, 
	0xE3, 0xEA, 0xA5, 0xAE, 0x82, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xEA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 
	0x2F, 0xF8, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xB6, 0xFF, 0x9F, 0xFF, 0xBA, 0xD1, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xB5, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xFF, 0xFD, 0xB4, 0x7D, 0x02, 0x5F, 0xFF, 0xFC, 0xB5, 0xFF, 0xF5, 
	0xE3, 0xED, 0xAC, 0x3E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2F, 0xF8, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0x26, 0xFF, 0x8F, 0xFE, 0x73, 0xC5, 0x07, 0xFF, 0xFF, 0xFF, 0xF6, 0xFE, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xFF, 0xFD, 0xB8, 0x78, 0x27, 0xFF, 0xFF, 0xFE, 0xB5, 0xFF, 0xA7, 
	0xCA, 0xEE, 0x3D, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2F, 0xF8, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0x1C, 0xBF, 0x8F, 0xFC, 0x5B, 0x25, 0x2F, 0xFF, 0xFF, 0xFF, 0x62, 0xFE, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xFA, 0x9D, 0xB9, 0xE0, 0x1F, 0x59, 0xBF, 0xFE, 0x95, 0xFF, 0x62, 
	0xC6, 0x9F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xF8, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA8, 0xFF, 0x8F, 0xF4, 0xEF, 0x14, 0x1F, 0xFF, 0xE2, 0x3E, 0xAB, 0xFA, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xAC, 0x9F, 0xE0, 0x02, 0xBB, 0x44, 0xB4, 0x82, 0xBF, 0xFE, 0x95, 0xFF, 0xF9, 
	0x05, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0xAA, 0xAB, 0xEA, 0xAA, 0xAA, 0xFA, 0xAA, 0xAB, 0xFA, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xFC, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 
	0x29, 0xFF, 0xEE, 0x3E, 0xEE, 0xFE, 0x3F, 0xFF, 0xE0, 0xAE, 0x6F, 0xC1, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0xAA, 0xAC, 0x9F, 0xF8, 0x58, 0xB3, 0x94, 0xE3, 0xA7, 0xFF, 0xFC, 0x15, 0x55, 0xF8, 
	0xCB, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x92, 0xBF, 0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x02, 0xAA, 0xAA, 0xAA, 
	0x1F, 0xFF, 0xEE, 0x1D, 0x66, 0xF4, 0xBF, 0xFF, 0xF6, 0xAA, 0xEA, 0x8F, 0x95, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0xAA, 0xAC, 0x9F, 0xFF, 0x9C, 0xBA, 0xB6, 0x0D, 0x1F, 0xFF, 0xFC, 0x15, 0x5F, 0xE0, 
	0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xB0, 0x2F, 0x6A, 0xAA, 0xA9, 0xA0, 0xAA, 0xAA, 0xA5, 0x56, 0xAA, 0xAA, 0xAA, 0x5A, 0xAA, 0xAA, 
	0x3F, 0xFF, 0xED, 0xA9, 0x65, 0xFA, 0xFF, 0xFF, 0xFF, 0x98, 0xE1, 0x6F, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAA, 0xAA, 0xAC, 0x1F, 0xFF, 0xED, 0x38, 0xF4, 0x3C, 0xBF, 0xFF, 0xFE, 0x1F, 0xD8, 0x07, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xBA, 0x2B, 0x6A, 0xAA, 0xA9, 0xA8, 0xAA, 0xA9, 0xA5, 0x56, 0xAA, 0xAA, 0x2A, 0x5A, 0xAA, 0xAA, 
	0x1F, 0xFF, 0xEF, 0xA1, 0x6B, 0xFA, 0xFA, 0xAA, 0xA9, 0x94, 0xD3, 0x86, 0x2A, 0xAB, 0xFF, 0xFF, 
	0xFF, 0xAE, 0xAE, 0xFC, 0x9F, 0x58, 0xAF, 0xAC, 0xF4, 0xFC, 0x95, 0x02, 0xFE, 0x36, 0x02, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x76, 0x4B, 0x4A, 0xAA, 0xA9, 0xA8, 0xA5, 0x0A, 0xA5, 0xAA, 0xAA, 0x96, 0x95, 0x5A, 0xAA, 0xAA, 
	0x1F, 0xFF, 0xCF, 0x91, 0xCB, 0xF0, 0x00, 0x2A, 0xA8, 0xBF, 0xFF, 0xC2, 0x80, 0xAA, 0xAA, 0xA0, 
	0xA0, 0xAA, 0xAA, 0xA8, 0x2A, 0x2A, 0xBF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xA0, 0x2A, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAE, 0xAA, 0xAA, 0xAB, 
	0xFF, 0xEA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFA, 0xAB, 0xFE, 0xAA, 0xAA, 0xAA, 0xFE, 0xAA, 0xAA, 0xAF, 
	0xFC, 0x53, 0x8C, 0x9A, 0xA9, 0xA8, 0xA9, 0x84, 0xA5, 0xAA, 0xA7, 0x9A, 0x95, 0x6A, 0xAA, 0xAA, 
	0x1F, 0xFF, 0xC6, 0x3A, 0xEB, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0x55, 0x55, 0x59, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0x9F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x58, 0x3C, 0xFA, 0x65, 0xAA, 0xAA, 0xE4, 0xA9, 0xA0, 0xAB, 0xFA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x06, 0xAA, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x02, 0x56, 0xBF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFD, 0x7D, 0xFF, 0x57, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x6A, 0xAA, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFE, 0xAA, 0xAA, 0xAB, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
