#include "../include.h"

// format: Attribute compressed 8x8/4 colors 4-bit paletted pixel graphics
// compression ratio: 56%
// required memory: 16640 B pixels, 2080 B attributes (18720 B total, unpacked 33280 B)
// image width: 320 pixels
// image height: 208 lines
// image pixels pitch: 80 bytes
// image attribute pitch: 80 bytes
const u16 ImgAttr3_Pal[16] __attribute__ ((aligned(4))) = {
	0xED64, 0xCC62, 0x79E0, 0x65AB, 0x4EFF, 0x44EB, 0x44E9, 0x0BF3, 0x1D9B, 0x95B6, 0x2AE7, 0x644A, 0xEFB7, 0xDCE2, 0x28E1, 0xBA61, 
};

const u8 ImgAttr3_Attr[2080] __attribute__ ((aligned(4))) = {
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE8, 0xA4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0xA4, 
	0xE0, 0xA4, 0xEB, 0x24, 0x02, 0xE8, 0x00, 0xE2, 0xE0, 0x24, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x84, 0xE5, 0xA4, 0x00, 0xE4, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x74, 0xE6, 0xA3, 0xE0, 0xA4, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0x84, 0xE0, 0xA4, 0xE7, 0x24, 0x02, 0xE8, 
	0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0xE2, 0x28, 0xE0, 0xB4, 0x00, 0x04, 0x00, 0x04, 
	0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0xA0, 0x54, 0xA0, 0x65, 0xE5, 0xA4, 0xE8, 0xA4, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xA3, 0x64, 0x00, 0x06, 0xE6, 0xA4, 0xE0, 0x74, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 
	0x00, 0x04, 0xE0, 0x74, 0xE8, 0xA4, 0xE7, 0x24, 0x02, 0xEB, 0x00, 0xE2, 0x00, 0xE2, 0xEB, 0x2C, 
	0xEB, 0x2C, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0xE7, 0x28, 0xE0, 0xA4, 0xA0, 0x54, 
	0xA3, 0x54, 0xE0, 0x74, 0xE3, 0xA4, 0xE5, 0xA8, 0x00, 0xA5, 0xE0, 0xA5, 0xE5, 0xA4, 0x00, 0x04, 
	0x00, 0x04, 0x00, 0x84, 0xE3, 0x54, 0x00, 0xE6, 0x00, 0x06, 0x00, 0xA6, 0xE6, 0xA4, 0xE0, 0x74, 
	0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0xA4, 
	0xE8, 0x24, 0x02, 0xE8, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0xEB, 0x2C, 0xE0, 0x9C, 
	0xE9, 0xAC, 0x02, 0xE9, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 0xEB, 0x24, 0xE5, 0xA3, 
	0xE5, 0xA3, 0xE8, 0xA4, 0xA5, 0x54, 0xE5, 0xA3, 0xE5, 0xA3, 0x05, 0xA3, 0xE5, 0xA4, 0xE8, 0xA4, 
	0x00, 0x74, 0xE8, 0xA4, 0xE6, 0xA3, 0xE6, 0xA5, 0x00, 0xA6, 0x00, 0x06, 0xE6, 0xA3, 0xE7, 0xA4, 
	0x00, 0x84, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0xA4, 0x02, 0xEF, 
	0xEF, 0x2D, 0x02, 0xE1, 0x02, 0xE1, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0xE9, 0x2C, 0xA0, 0x9C, 
	0xE0, 0xBC, 0xE1, 0x2C, 0xE0, 0x2F, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0x02, 0x02, 0xEF, 0xE5, 0x23, 
	0xE5, 0xA3, 0xE5, 0xA3, 0xE5, 0xA3, 0x00, 0x05, 0x00, 0xA5, 0x06, 0xE5, 0xE5, 0xA3, 0xE5, 0xA3, 
	0x00, 0x04, 0xA0, 0x74, 0xE6, 0xA3, 0xE6, 0xA5, 0xE6, 0xA5, 0xE0, 0xA6, 0xE6, 0xA5, 0xE6, 0xA5, 
	0xE0, 0xA4, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xE0, 0xA4, 0xE1, 0x20, 0xED, 0x10, 
	0x02, 0xEF, 0x02, 0xE1, 0x02, 0xE1, 0x02, 0xEF, 0x02, 0xEF, 0x00, 0xE2, 0x02, 0xEF, 0xE9, 0x2C, 
	0x21, 0xBD, 0xE1, 0x2D, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0x00, 0xE2, 0xE1, 0x20, 0xEF, 0x2D, 
	0xE5, 0x23, 0xE5, 0xA3, 0xE5, 0xA3, 0x00, 0xA5, 0x00, 0xA5, 0xE5, 0xA3, 0xE6, 0xA5, 0x00, 0xA5, 
	0xE0, 0x74, 0xA3, 0x64, 0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 
	0xE6, 0xA5, 0xE0, 0x54, 0x00, 0x04, 0x00, 0x04, 0x00, 0x74, 0xE1, 0x24, 0xE0, 0x10, 0x00, 0xD0, 
	0xE1, 0x20, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0x02, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xEF, 0xEB, 0x2C, 
	0xE1, 0x2D, 0xE1, 0x2D, 0x02, 0xED, 0x00, 0xE2, 0x00, 0x02, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xE1, 
	0xEB, 0x2D, 0xE5, 0xA3, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0xE5, 0xA4, 0xE6, 0xA5, 0x00, 0x06, 0xE0, 0xA6, 0xE6, 0xA3, 0xE0, 0xA6, 0xE0, 0xA6, 0xE5, 0xA3, 
	0xE6, 0xA8, 0xE0, 0x74, 0x00, 0x04, 0x00, 0x04, 0xE3, 0x24, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0xD0, 0xE1, 0x20, 0x02, 0xEF, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0x02, 0xED, 
	0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0x02, 0x00, 0x02, 0x02, 0xEF, 0xE1, 0x20, 
	0x02, 0xEF, 0xEB, 0x23, 0xE5, 0xA3, 0xE6, 0xA5, 0xE0, 0xA5, 0x00, 0x05, 0xE6, 0xA5, 0xE5, 0xA3, 
	0xE0, 0x74, 0xE6, 0xA5, 0xE0, 0xA6, 0xE6, 0xA5, 0x00, 0xA6, 0x00, 0x06, 0x06, 0xA3, 0x00, 0xA6, 
	0x00, 0xA6, 0xE5, 0xA4, 0xE0, 0xA4, 0xE0, 0xA4, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
	0x00, 0x20, 0xF0, 0x10, 0xE1, 0x20, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xE1, 0x02, 0xED, 
	0xE1, 0x20, 0x00, 0xE2, 0x00, 0x02, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 
	0x00, 0x02, 0x00, 0xE2, 0xE5, 0x23, 0x05, 0xA3, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0xE6, 0x74, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0xA6, 0xE0, 0xA6, 0x0A, 0xE5, 0xEB, 0x29, 0x20, 0x10, 0xE0, 0xF0, 0x2B, 0xF0, 0xEF, 0x2D, 
	0xEF, 0x2D, 0x20, 0x10, 0x20, 0x10, 0xE1, 0x20, 0x00, 0xE2, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xE1, 
	0x02, 0xED, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xEF, 0x02, 0xE1, 0x00, 0x02, 0x00, 0x02, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0xE2, 0xEB, 0x21, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0xA5, 0x00, 0xA5, 
	0xE0, 0xA6, 0xE0, 0xA6, 0xE0, 0xA6, 0x00, 0xA6, 0xE0, 0xA6, 0x00, 0x06, 0x00, 0xA6, 0xE0, 0xA6, 
	0xE0, 0xA6, 0xE6, 0xA3, 0xEB, 0x21, 0xED, 0x10, 0x00, 0x00, 0xE0, 0xF0, 0xEF, 0x2D, 0x00, 0x0F, 
	0x2B, 0xF0, 0x00, 0xB0, 0x00, 0x00, 0xED, 0x10, 0x02, 0xEF, 0x00, 0x02, 0x00, 0xE2, 0x02, 0xEF, 
	0x00, 0xE2, 0x00, 0xE2, 0x02, 0xE1, 0xE1, 0x20, 0x02, 0xE1, 0x02, 0xEF, 0x00, 0x02, 0x02, 0xEF, 
	0xEF, 0x21, 0xE1, 0x2D, 0xA1, 0xBD, 0x00, 0x05, 0xE0, 0xA5, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 
	0x00, 0x06, 0xE6, 0xA3, 0xE0, 0xA6, 0xE6, 0xA5, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 0x00, 0x06, 
	0x00, 0x06, 0xE6, 0x23, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x10, 0xE1, 0xF0, 
	0xE0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x02, 0xEF, 0x00, 0xE2, 0x00, 0xE2, 
	0x00, 0xE2, 0x00, 0x02, 0x00, 0xE2, 0xEF, 0x2D, 0x02, 0xE0, 0xEF, 0x21, 0xE1, 0x2D, 0xE1, 0x2D, 
	0xE1, 0xA0, 0xE1, 0x2D, 0xA1, 0xBD, 0xE5, 0xA3, 0xE5, 0xA3, 0xE6, 0xA3, 0xE5, 0xA3, 0xE5, 0xA3, 
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0xA6, 
	0xE6, 0xA5, 0xE1, 0x20, 0x10, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0, 0xEF, 0x20, 0xE0, 0x2F, 0xE0, 0x2F, 
	0x00, 0xE2, 0x00, 0xE2, 0x02, 0xEF, 0xEF, 0x21, 0xE0, 0x21, 0xE1, 0x2D, 0xE7, 0x2D, 0x02, 0xE7, 
	0x00, 0xE7, 0xEB, 0x21, 0xA1, 0xFD, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x06, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0xA6, 0x00, 0x06, 0x00, 0xA6, 0x00, 0x06, 
	0xEB, 0x21, 0x2D, 0x10, 0x10, 0xD0, 0x20, 0xF0, 0xED, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xE0, 0x20, 0xE1, 0x20, 0xE1, 0x20, 0xE1, 0x20, 0x02, 0xE1, 0x00, 0xE2, 
	0xEF, 0x21, 0xE1, 0x2D, 0xE1, 0x2D, 0xE5, 0x2D, 0x01, 0xFD, 0xE1, 0x2D, 0xE0, 0xA7, 0x02, 0xE7, 
	0x02, 0xE7, 0xEF, 0x21, 0xA0, 0xF1, 0x00, 0x53, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0xE6, 0xA3, 0xE6, 0xA3, 0xE6, 0xA5, 0xE6, 0xA9, 0xA5, 0x6C, 0xE6, 0xA9, 0xE0, 0xA6, 0xEF, 0xA6, 
	0xE1, 0x20, 0xE5, 0xA0, 0xE7, 0x28, 0xE7, 0x28, 0xE7, 0x28, 0xE1, 0x20, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xE7, 0x23, 0xE0, 0xA8, 0xE0, 0xA8, 0xE8, 0x21, 0xE1, 0x20, 0xE1, 0x2D, 
	0xE7, 0x2D, 0xEA, 0x27, 0xE0, 0x27, 0x02, 0xE7, 0x21, 0xFD, 0xE1, 0x2D, 0x02, 0xE7, 0x02, 0xE7, 
	0xE0, 0x27, 0xE1, 0x2D, 0xA1, 0xFD, 0x00, 0x53, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0xA0, 0xBC, 0xE0, 0xBC, 0xB0, 0x9C, 0x00, 0x0C, 0x00, 0x9C, 0xB0, 0x9C, 0xA0, 0x3C, 
	0x20, 0x0C, 0xE5, 0x20, 0xE7, 0x28, 0xE7, 0x28, 0xE7, 0x28, 0xE1, 0x20, 0x00, 0x00, 0x20, 0x10, 
	0x20, 0xF0, 0x00, 0x00, 0xE7, 0x21, 0xE7, 0x28, 0xE7, 0x28, 0x02, 0xE7, 0x21, 0xF0, 0x00, 0x01, 
	0xE7, 0x2D, 0xE0, 0x27, 0x02, 0xE7, 0x02, 0xE7, 0x01, 0x2D, 0xE1, 0x2D, 0x02, 0xE7, 0xE7, 0x2D, 
	0xE1, 0x2D, 0xE1, 0x2D, 0xA1, 0xFD, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0xA0, 0x63, 0xB0, 0x9C, 0xE0, 0xBC, 0xE9, 0xAC, 0xE9, 0xAC, 0xE9, 0xAC, 0xE0, 0x9C, 0x00, 0x0C, 
	0xB0, 0x0C, 0xE1, 0xA0, 0xE0, 0xA8, 0xE7, 0x28, 0x20, 0x78, 0xE1, 0x20, 0x21, 0xF0, 0xEF, 0x21, 
	0xEF, 0x21, 0xE1, 0xF0, 0xE8, 0xA0, 0xE0, 0xA8, 0xE0, 0x28, 0xEB, 0x28, 0x21, 0xFD, 0x00, 0x01, 
	0xE7, 0x2D, 0xE0, 0x27, 0xE7, 0x28, 0x02, 0xE7, 0x01, 0x2D, 0x00, 0x01, 0xE1, 0x2D, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x20, 0xA1, 0x00, 0x53, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 
	0xA3, 0xBC, 0xE0, 0x3C, 0xEB, 0x29, 0xEB, 0xA9, 0xEB, 0x29, 0x0B, 0xE9, 0xEB, 0x29, 0xE9, 0xAC, 
	0xB0, 0x0C, 0xED, 0x20, 0xE5, 0x2D, 0xE1, 0x20, 0xE1, 0x20, 0xE1, 0x20, 0xEF, 0x21, 0xEF, 0x21, 
	0x0F, 0xE1, 0xEF, 0x21, 0xED, 0x10, 0xE1, 0x20, 0xE1, 0x20, 0xE1, 0x20, 0x21, 0xF0, 0x00, 0x01, 
	0xE7, 0x21, 0xE7, 0x2D, 0xE1, 0x20, 0xE1, 0x2D, 0x00, 0x01, 0x00, 0xE1, 0x00, 0xF1, 0x01, 0x2D, 
	0x00, 0x01, 0xE1, 0x2D, 0xE1, 0x20, 0xA0, 0x63, 0xA0, 0x63, 0xA0, 0x63, 0x00, 0x03, 0x00, 0xB3, 
	0xA9, 0x3C, 0xE9, 0xAC, 0x02, 0xE3, 0x00, 0xEA, 0x00, 0xE2, 0x00, 0xEA, 0x00, 0xE2, 0xE0, 0xA5, 
	0x20, 0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE1, 0x20, 0x00, 0xF1, 0x00, 0x0F, 
	0x00, 0x2F, 0xEF, 0x21, 0x20, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF0, 0x00, 0x01, 
	0xE1, 0x2D, 0x0D, 0x10, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x21, 0xBD, 0xA1, 0xFD, 0x26, 0xF1, 
	0xA1, 0xBD, 0xA1, 0xBD, 0xA0, 0xB3, 0xA0, 0xB3, 0xA0, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0xA0, 0x3C, 0xE3, 0xAC, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0xE2, 0x00, 0x0E, 0x00, 0xE2, 0x0A, 0xEB, 
	0x20, 0xBC, 0xF0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x10, 0x00, 0x0F, 0x00, 0x0F, 
	0xEF, 0x21, 0xEF, 0x21, 0xE0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xF0, 0x00, 0x01, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x20, 0xF1, 0xE1, 0x2D, 0xA5, 0xF1, 0xA0, 0xB3, 0xE0, 0xA3, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0xA0, 0x3C, 0x0A, 0xEC, 0x02, 0xEB, 0x0A, 0xEB, 0x00, 0xE2, 0x00, 0xEA, 0x02, 0xEB, 0x0A, 0xEB, 
	0xA0, 0x9C, 0x20, 0x10, 0xE1, 0x20, 0xA1, 0xB0, 0x00, 0x10, 0xE1, 0x20, 0x0F, 0x21, 0x00, 0x0F, 
	0x00, 0x0F, 0x0F, 0x21, 0xE0, 0x10, 0xA0, 0x30, 0x21, 0xF0, 0x00, 0x10, 0x21, 0xF0, 0x00, 0x01, 
	0xE1, 0xBD, 0x21, 0xBD, 0x21, 0xBD, 0x23, 0xAD, 0xE0, 0x53, 0x00, 0x53, 0x00, 0x03, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0xA9, 0xBC, 0xEB, 0xA9, 0xE0, 0x29, 0xE0, 0xA9, 0xEB, 0x29, 0x0B, 0xE9, 0xEB, 0x29, 0xEB, 0xA9, 
	0xA0, 0x9C, 0x21, 0xB0, 0x25, 0xA3, 0x2D, 0xF0, 0xE1, 0x20, 0xE1, 0x20, 0xEF, 0x21, 0x00, 0x0F, 
	0x00, 0x0F, 0x20, 0xF1, 0x2D, 0x10, 0xE3, 0xA0, 0x23, 0xA0, 0x2D, 0x10, 0x2D, 0x10, 0x21, 0xBD, 
	0x23, 0xB0, 0xE0, 0x63, 0xA0, 0x53, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0x03, 0x00, 0x03, 
	0xA3, 0x6C, 0xE6, 0xA3, 0xE0, 0x23, 0xEB, 0xA3, 0xE6, 0x23, 0xE6, 0xA3, 0xE5, 0x23, 0x00, 0xE3, 
	0x69, 0x3C, 0xA3, 0xB9, 0xE0, 0xA3, 0xA0, 0x63, 0xA0, 0x53, 0xA0, 0x53, 0xA0, 0x63, 0x20, 0xA3, 
	0x20, 0x53, 0x20, 0x63, 0x20, 0x53, 0x00, 0x53, 0x00, 0xA3, 0x00, 0xA3, 0xA0, 0x53, 0x00, 0x53, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
	0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 
};

const u8 ImgAttr3[16640] __attribute__ ((aligned(4))) = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0xEA, 0xAB, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x95, 0xBE, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x62, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x68, 0xAA, 0xAA, 0xFF, 0xFF, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6C, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xDA, 0x02, 0x66, 0xA9, 0xFF, 0xFF, 0xA3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6D, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFA, 0x02, 0xA8, 0x9D, 0x55, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x4B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x80, 0x00, 0x00, 0x55, 0x55, 0xFF, 0xFF, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0x52, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xA1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA0, 0x28, 0x20, 0x0A, 0x55, 0x55, 0xFF, 0xFF, 0xAA, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8, 
	0x02, 0x00, 0x99, 0x86, 0x55, 0x55, 0xFF, 0xFF, 0xAA, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0x55, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x58, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xBA, 0xAB, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC5, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xEA, 0x56, 
	0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0x58, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xA5, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x5A, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x35, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x00, 0xAA, 0xA5, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xFF, 0xFF, 0x56, 0xA0, 0x9F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x95, 0x56, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x02, 0x88, 0xB5, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC2, 0xFF, 0xFF, 0x55, 0xAA, 0x0A, 0xA7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0x55, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0xA8, 0x06, 0x95, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0A, 0xFF, 0xFF, 0x55, 0xAA, 0xAA, 0x07, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0x55, 0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA0, 0x00, 0x00, 0xAA, 0x65, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x2A, 0xFF, 0xFF, 0x55, 0x6A, 0xA8, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x55, 0x55, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x08, 0x2A, 0xAA, 0xAA, 0x69, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xAA, 0x98, 0x2A, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xAA, 0xFF, 0xFF, 0x55, 0x5A, 0x82, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0xFF, 0xFF, 0x68, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA5, 0xFA, 0xFF, 0xFF, 0xFF, 0xA2, 0xAA, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x7A, 0xD5, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0x87, 0xFF, 0xFF, 0xFF, 0xFE, 
	0x23, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x27, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0A, 0xFF, 0xFF, 0x6A, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAA, 0x9A, 0xAB, 0xFF, 0xFF, 0xFF, 0x90, 0x6A, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x56, 0x55, 0xFF, 0xFF, 0xFE, 0xAF, 0xAA, 0xA3, 0xFF, 0xFF, 0xFF, 0xFC, 
	0x12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1A, 0xFF, 0xFF, 0x5A, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x80, 0x59, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xA8, 0xAA, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x55, 0x95, 0xFF, 0xFF, 0xAA, 0xFF, 0xAA, 0xA8, 0xBF, 0xFF, 0xFF, 0xF8, 
	0x98, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x42, 0xFD, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xAA, 0xFF, 0xFF, 0x5A, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50, 0x2A, 0x67, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x2A, 
	0xAA, 0xAA, 0xFF, 0xFF, 0x55, 0xAD, 0xFF, 0xEA, 0xBF, 0xFF, 0xAA, 0xAA, 0x2F, 0xFF, 0xFF, 0xF0, 
	0x64, 0x3F, 0xFF, 0xFF, 0xFF, 0xEA, 0xD5, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x68, 0x22, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x6A, 0xFF, 0xFF, 0x5A, 0xA0, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x0A, 0xA0, 0x95, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0x00, 
	0x0A, 0xAA, 0xFF, 0xFF, 0x55, 0x65, 0xFE, 0xAF, 0xFF, 0xFF, 0xAA, 0xAA, 0x8F, 0xFF, 0xFF, 0xE2, 
	0xA9, 0x0F, 0xFF, 0xFF, 0xFE, 0xA5, 0x68, 0x55, 0xFF, 0xFB, 0xFF, 0xFF, 0x5A, 0x8B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xAA, 0xFF, 0xFF, 0x56, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x55, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0x98, 0x25, 
	0xD2, 0xAA, 0xFF, 0xFF, 0x55, 0xEA, 0xAA, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xA3, 0xFF, 0xFF, 0xCA, 
	0xA9, 0x83, 0xFF, 0xFF, 0x80, 0xA0, 0x20, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x2F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0xAA, 0xFF, 0xFF, 0x55, 0xAA, 0x2F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0xA8, 0x1A, 0xAA, 0x55, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 
	0xF4, 0xAA, 0xFF, 0xFF, 0x57, 0x69, 0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xA2, 0xFF, 0xFF, 0x0A, 
	0xAA, 0x50, 0xBF, 0xFF, 0xAA, 0xAA, 0xF9, 0x55, 0xFF, 0xEF, 0xAF, 0xFF, 0x60, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x06, 0xAA, 0xFF, 0xFF, 0x55, 0xAA, 0x8B, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xE8, 0x0A, 0xA0, 0xAA, 0xAA, 0x55, 0x55, 0xBF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 
	0xFE, 0x2A, 0xFF, 0xFF, 0x56, 0x9F, 0xEF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xA8, 0xBF, 0xFC, 0x2A, 
	0xAA, 0x88, 0x0B, 0xFF, 0xFF, 0xFF, 0xEB, 0x55, 0xFF, 0xBF, 0xF0, 0xA8, 0x22, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA3, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x6A, 0x96, 0xA9, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0x2A, 0x55, 0x55, 0xEA, 0xFF, 0x59, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x3F, 0xD1, 0xD5, 
	0x55, 0x52, 0x81, 0xFF, 0xFF, 0xFF, 0x85, 0x55, 0x74, 0xB5, 0x56, 0xAA, 0x76, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xA0, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xDA, 0x5A, 0xA9, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0x55, 0xAA, 0xA1, 0xFF, 0xFE, 
	0x7F, 0x4A, 0x55, 0x56, 0xAF, 0xFF, 0x76, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x8F, 0xA9, 0x95, 
	0x75, 0x70, 0x7F, 0xFF, 0xFF, 0xFC, 0x15, 0x55, 0xA2, 0x55, 0x57, 0xFD, 0x56, 0x8B, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xA8, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0xA5, 0x6B, 0xD9, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0x55, 0xAA, 0xA2, 0xFF, 0xE0, 
	0x2F, 0xE2, 0x55, 0x6A, 0xFF, 0xFF, 0x5E, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x45, 0x28, 0xB7, 
	0x67, 0xFE, 0xAF, 0xFF, 0xFF, 0xE0, 0xD5, 0x68, 0x27, 0x55, 0x55, 0x55, 0x55, 0xA2, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x82, 0x55, 0xA5, 0x76, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x55, 0xAA, 0xA5, 0xBF, 0xC0, 
	0x8B, 0xF8, 0x6A, 0xA5, 0xFF, 0xFF, 0x55, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA3, 0xFE, 0x7D, 
	0x02, 0xAA, 0x83, 0xFF, 0xFD, 0x02, 0xAA, 0x0A, 0x75, 0x55, 0x55, 0x55, 0x55, 0x68, 0x2F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0x83, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x60, 0x2A, 0x5A, 0x95, 0x56, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x95, 0xAA, 0x87, 0xBF, 0xC0, 
	0xA1, 0xFC, 0x95, 0x55, 0xFF, 0xFF, 0x55, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xFA, 0xE8, 
	0xB6, 0xA8, 0x22, 0xFF, 0xFE, 0x00, 0x0A, 0x5F, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0x8A, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xA0, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 
	0x0A, 0x00, 0xA9, 0x55, 0x95, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x95, 0xAA, 0x87, 0xAF, 0xC0, 
	0xAA, 0xFF, 0x95, 0x55, 0xFF, 0xFF, 0x55, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA4, 0x62, 0x09, 
	0xD7, 0xFD, 0xA8, 0xBF, 0xFE, 0x1A, 0x5F, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x56, 0xA0, 0xA7, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA8, 0x2F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 
	0xA8, 0x20, 0x55, 0x56, 0x55, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x65, 0xAA, 0x8F, 0xAF, 0xE0, 
	0xAA, 0xFF, 0xE5, 0x55, 0xFF, 0xFF, 0x55, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xA9, 0x5D, 
	0x55, 0x55, 0xAA, 0x2F, 0xF8, 0x6A, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xAA, 0x0B, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x06, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6A, 0xAA, 0x8B, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8, 0x2A, 
	0xA0, 0xAA, 0x55, 0x59, 0xD9, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x6B, 0xA9, 0x1F, 0xCF, 0xF0, 
	0xAA, 0xFF, 0xE5, 0x55, 0xFF, 0xFA, 0xA5, 0x55, 0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0xA9, 0x0F, 0x55, 
	0x55, 0x55, 0xAA, 0x8B, 0xE2, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x54, 0x28, 0x2F, 
	0xFF, 0xFF, 0xFF, 0xF8, 0x75, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x6A, 0xAA, 0xA0, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x69, 0x56, 
	0x02, 0x6A, 0x55, 0x5B, 0xD9, 0x59, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFB, 0xA8, 0xBF, 0xCB, 0xFC, 
	0x02, 0xFF, 0xD2, 0xAA, 0xAA, 0x83, 0xD9, 0x55, 0xAD, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xAD, 0x55, 
	0x55, 0x55, 0xDA, 0xA0, 0xA5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0x02, 0xA7, 
	0xFF, 0xFF, 0xFF, 0x69, 0x56, 0x95, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xAA, 0xA8, 0x1F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA6, 0xAA, 
	0x2A, 0xAA, 0x55, 0x5B, 0xD5, 0x56, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0xA0, 0xFF, 0xE3, 0xFE, 
	0x0B, 0xFF, 0xF2, 0xAA, 0xAA, 0x2F, 0xF6, 0x55, 0x65, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x8F, 0x55, 
	0x55, 0x55, 0x5A, 0x98, 0x35, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0x6A, 0x22, 
	0xFF, 0xFF, 0xF6, 0x26, 0x60, 0x55, 0x5D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0xAA, 0xAA, 0x80, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x6E, 0x95, 
	0x62, 0x82, 0x55, 0x5B, 0xE5, 0x5E, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x2B, 0xFF, 0xF2, 0xFF, 
	0xFF, 0xFF, 0xF2, 0xAA, 0x80, 0x3F, 0xF6, 0x55, 0x59, 0x55, 0xFF, 0xFF, 0x55, 0x57, 0x81, 0xD5, 
	0x55, 0x55, 0x56, 0xA1, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x7C, 0x26, 
	0xFF, 0xFE, 0xA2, 0xA0, 0x22, 0x55, 0xF6, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAA, 0xAA, 0x80, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x65, 0xAD, 
	0x87, 0xD8, 0x55, 0x5A, 0x95, 0x55, 0x95, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x07, 0xFF, 0xF0, 0xFF, 
	0xFF, 0xFF, 0xD2, 0xAA, 0x3F, 0xFF, 0xF6, 0x55, 0x7A, 0x55, 0xFF, 0xFF, 0x55, 0x5D, 0x28, 0x75, 
	0x55, 0x55, 0x5D, 0x07, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x60, 0xAA, 
	0xFF, 0xFE, 0x2A, 0xAA, 0xEB, 0x55, 0x60, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x97, 0xDA, 0xAA, 0x27, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xA5, 0x69, 
	0xA1, 0xFF, 0x95, 0x56, 0x55, 0x55, 0x65, 0x55, 0xFF, 0xFF, 0xFF, 0xFA, 0xA1, 0xFF, 0xFC, 0xBF, 
	0xFF, 0xFE, 0xA4, 0xA8, 0xBF, 0xFF, 0xFA, 0x55, 0x56, 0x95, 0xFF, 0xFF, 0x55, 0x56, 0xAA, 0x1D, 
	0x55, 0x55, 0x76, 0x95, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAA, 0x80, 0x2A, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x56, 0x2A, 0xD5, 0xFF, 0xEF, 0xFF, 0xFF, 0x62, 0x5A, 0x80, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8A, 0xA9, 0x59, 
	0xA8, 0x9F, 0x6D, 0xA7, 0x55, 0x55, 0x6B, 0x55, 0xFF, 0xFF, 0xFF, 0xAF, 0xA8, 0xFF, 0xFC, 0x3F, 
	0xFF, 0xE0, 0x54, 0x28, 0xBF, 0xFF, 0xD9, 0x55, 0x55, 0x95, 0xFF, 0xFF, 0x57, 0x69, 0xAA, 0x8F, 
	0x55, 0x5F, 0x62, 0xD5, 0x55, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0A, 0xA6, 0x76, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xB6, 0x82, 0xBA, 0xD5, 0xFF, 0xEF, 0xFF, 0xFF, 0x58, 0x28, 0x28, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2A, 0xBA, 0x5A, 
	0xAA, 0x08, 0x96, 0x59, 0x55, 0x55, 0x59, 0x55, 0xFF, 0xFF, 0xEA, 0xFF, 0xA8, 0x3F, 0xFF, 0x2F, 
	0xFA, 0x02, 0x55, 0x2A, 0x3F, 0xFF, 0xE5, 0x55, 0x55, 0xA5, 0xFF, 0xFF, 0x76, 0xA5, 0xAA, 0x89, 
	0x55, 0xD6, 0xA7, 0x55, 0x60, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x69, 0x6B, 0x55, 0xAA, 
	0xFF, 0xFF, 0xFF, 0x60, 0xA0, 0xA7, 0xE3, 0x55, 0xFF, 0xAF, 0xFF, 0xFF, 0x5E, 0x2A, 0xAA, 0x1F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA8, 0xB6, 0x5E, 
	0x2A, 0xAA, 0x59, 0xF6, 0x56, 0x5A, 0x7A, 0x55, 0xFF, 0xFA, 0xAF, 0xFF, 0xAA, 0x0F, 0xFF, 0x80, 
	0xA0, 0xAA, 0x55, 0x8A, 0x80, 0x02, 0x95, 0x55, 0x55, 0x65, 0xFF, 0xFF, 0x6A, 0x55, 0xA2, 0xA1, 
	0xDD, 0x02, 0x5A, 0xA0, 0xA2, 0xD5, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xF6, 0x09, 0x55, 0x6A, 
	0xFF, 0xFF, 0xFF, 0x8A, 0x85, 0xF5, 0xCB, 0x55, 0x7E, 0x29, 0xFF, 0xFF, 0xFF, 0x43, 0x6A, 0x8B, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xA8, 0xAC, 0x00, 
	0x95, 0x55, 0x56, 0xD9, 0x59, 0xFE, 0x96, 0x55, 0x55, 0xA9, 0xFF, 0xFF, 0x55, 0x6B, 0xFF, 0xD2, 
	0x2F, 0x55, 0x57, 0x8A, 0xFA, 0xAA, 0xBF, 0xFF, 0x55, 0x67, 0xFF, 0xFE, 0x0A, 0xAA, 0x88, 0xAA, 
	0xD5, 0xAA, 0xAA, 0xAA, 0xEB, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 0x0A, 0xAA, 0xA2, 0xBF, 0xFF, 0xFA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 0x55, 0x2D, 0x57, 0xD0, 0x20, 0x2B, 0xFF, 0xAA, 0xA7, 0xEA, 0xA2, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xA2, 0xBF, 0x80, 
	0xA5, 0x55, 0x55, 0xA5, 0x5A, 0xFF, 0x6E, 0x95, 0x6A, 0x55, 0xFF, 0xFF, 0x55, 0x7A, 0xFF, 0xD9, 
	0xD5, 0x55, 0x55, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE9, 0xFF, 0xAA, 0xAA, 0xAA, 0x3E, 0x28, 
	0xB5, 0xFF, 0x5F, 0xFF, 0xAD, 0x55, 0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xA7, 0xFF, 0xFF, 0xFE, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x35, 0x74, 0xBF, 0xFE, 0x01, 0xD6, 0xA0, 0x00, 0xAA, 0x7D, 0x7A, 0xA8, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0x09, 0x7F, 0xF4, 
	0x6B, 0x55, 0x55, 0x75, 0x56, 0x97, 0x96, 0xAA, 0x95, 0x55, 0xFF, 0xFF, 0x55, 0x5E, 0xBF, 0xFA, 
	0xD5, 0x55, 0x55, 0xE2, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x6A, 0xAA, 0xBF, 0xAA, 0xAA, 0x3E, 0x2A, 
	0x1D, 0x55, 0x55, 0x76, 0xB5, 0x58, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0x55, 0x6A, 0xF5, 0xA0, 0xAF, 0x5F, 0xFE, 0xAB, 0xFF, 0x55, 0x5D, 0xAA, 
	0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x17, 0xFF, 0xF8, 
	0x59, 0x55, 0x5A, 0x95, 0x55, 0x6A, 0x5A, 0x55, 0x95, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x2F, 0xFA, 
	0xD5, 0x55, 0x55, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0x9D, 0xFB, 0xFF, 0x82, 0xAA, 0xBE, 0x2A, 
	0x8D, 0x55, 0x55, 0xE9, 0xD6, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0x8A, 0xA8, 0x29, 0xF5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x57, 0x6A, 
	0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA1, 0x5F, 0xFF, 0xF4, 
	0x9A, 0x55, 0x5B, 0xE5, 0x55, 0x75, 0xA7, 0x55, 0x65, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x87, 0xF4, 
	0xD5, 0x55, 0x55, 0x78, 0xEF, 0xFF, 0xFF, 0xFF, 0x5A, 0x55, 0xFA, 0xFF, 0x28, 0x2A, 0x3E, 0x2A, 
	0x8B, 0x55, 0x56, 0x0A, 0x80, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0x6A, 0xA5, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0xDA, 
	0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xA2, 0xFF, 0xFF, 0xF4, 
	0x96, 0xB5, 0x67, 0xE5, 0x55, 0x6A, 0x55, 0x55, 0xEB, 0x55, 0xFF, 0xFF, 0xA9, 0x55, 0xA3, 0xF6, 
	0x55, 0x55, 0x55, 0x74, 0xFA, 0xFF, 0xFF, 0xFF, 0xA9, 0x55, 0xFE, 0xFE, 0xBF, 0x8A, 0x24, 0xAA, 
	0xA1, 0xD5, 0x5E, 0x82, 0xA5, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xC2, 0x55, 0x5D, 0xFD, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x5D, 
	0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x81, 0xFF, 0xFF, 0xFE, 
	0x95, 0x95, 0x6F, 0x65, 0x56, 0x95, 0x55, 0x55, 0x59, 0x55, 0xFF, 0xFE, 0xB6, 0x55, 0xA2, 0xF6, 
	0x55, 0x55, 0x55, 0x5E, 0xBF, 0xBF, 0xFF, 0xEA, 0x95, 0x55, 0xFF, 0xBF, 0x1F, 0xE2, 0x82, 0xAA, 
	0xA8, 0xD5, 0x57, 0x47, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x8A, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x57, 
	0xAA, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x89, 0xFF, 0xFF, 0xFE, 
	0x67, 0x65, 0x65, 0x9D, 0xA9, 0x55, 0x55, 0x55, 0x56, 0x55, 0xFF, 0xAA, 0xFE, 0x95, 0xA8, 0xBE, 
	0x95, 0x55, 0x55, 0x5D, 0xAF, 0xFF, 0xFA, 0xBF, 0x55, 0x55, 0xFF, 0xAF, 0x85, 0xE2, 0x96, 0xAA, 
	0xA8, 0xB5, 0x57, 0x1D, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFA, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8A, 0x0A, 0xFF, 0xFF, 0xFE, 
	0x60, 0x82, 0x5A, 0x5A, 0xBF, 0xFF, 0xFF, 0xFF, 0x56, 0xB5, 0x56, 0x99, 0xFD, 0x95, 0xAA, 0x3D, 
	0xB5, 0x55, 0x55, 0x57, 0x65, 0x6A, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFA, 0xAF, 0xA9, 0x55, 
	0xAA, 0x15, 0x5E, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFC, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x5E, 0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x28, 0x2B, 0xFF, 0xFF, 0xFF, 
	0x58, 0x00, 0x55, 0xA9, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x95, 0x59, 0xFF, 0xFE, 0x95, 0xAA, 0x2D, 
	0xB5, 0x55, 0x55, 0x5F, 0xEA, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFE, 0xB6, 0x55, 
	0xAA, 0x89, 0x74, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF0, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x57, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA0, 0xAF, 0xFF, 0xFF, 0xFF, 
	0xD5, 0xA0, 0xAA, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x65, 0x5B, 0xFF, 0xFE, 0x55, 0xAA, 0x8F, 
	0x35, 0x55, 0x7F, 0xDA, 0xAA, 0x95, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFE, 0xFD, 0x55, 
	0xAA, 0x41, 0xD1, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xD2, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xDA, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x09, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD2, 0x59, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x65, 0x5A, 0xFF, 0xFA, 0x55, 0xAA, 0x87, 
	0x35, 0x5F, 0xDA, 0x00, 0x96, 0x95, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFE, 0x55, 
	0x2A, 0xA2, 0x4B, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xCA, 0xAA, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x76, 0x82, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0x56, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x59, 0x56, 0xAA, 0xA9, 0x55, 0xAA, 0xA9, 
	0xB5, 0xF6, 0x00, 0x2A, 0x55, 0xA5, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0x99, 0x56, 
	0x82, 0xA8, 0x2D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x06, 0xAA, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x5D, 0xA8, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD8, 0x56, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7A, 0xD5, 0x6A, 0xA5, 0x55, 0xAA, 0xA1, 
	0xFD, 0x80, 0x2A, 0xAA, 0x55, 0x69, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0x67, 0x59, 
	0xF8, 0x24, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x1A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x57, 0xA8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xD4, 0x95, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 
	0xD8, 0x0A, 0xAA, 0xAA, 0x55, 0x69, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0x69, 0x5A, 
	0xFF, 0x2A, 0x1D, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0x6A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0xFF, 0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF6, 0x95, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x95, 0x55, 0x55, 0x55, 0xAA, 0xA4, 
	0x00, 0xA2, 0xAA, 0xAA, 0x55, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xBE, 0x56, 
	0x3F, 0x4A, 0x85, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE1, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5A, 0xBF, 0xFF, 0xFF, 0xFE, 0x95, 0x55, 
	0x55, 0x56, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xA8, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x82, 0xA2, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xA5, 0x55, 0xFF, 0xFF, 0x55, 0x5A, 
	0xA5, 0x56, 0xAB, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0x56, 0xB4, 0xAA, 
	0x67, 0x95, 0x4B, 0x55, 0x55, 0x55, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0x85, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x6A, 0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0x56, 
	0x6A, 0xA0, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xA0, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x60, 0x00, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x55, 0xFF, 0xFF, 0x56, 0xA9, 
	0x69, 0x55, 0xFF, 0xAA, 0xAA, 0xAF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x56, 0xB6, 0xAA, 
	0x5A, 0x55, 0x63, 0x55, 0x55, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFE, 0x15, 0x57, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0x40, 0xAA, 
	0xA8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0x82, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xD6, 0xA0, 0xB5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0x55, 0xFF, 0xFF, 0xAA, 0x55, 
	0x59, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5E, 0x96, 0xB4, 0xAA, 
	0x55, 0x55, 0x02, 0xA5, 0x56, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0x55, 0x58, 
	0xF8, 0x55, 0x5D, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0x58, 0x0A, 
	0xAA, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x29, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF5, 0xD2, 0x95, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0x55, 0xFF, 0xFA, 0x95, 0x55, 
	0x56, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x96, 0xB8, 0xAA, 
	0x55, 0x5A, 0x28, 0x60, 0x00, 0xA2, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0x80, 0xAA, 0xAA, 0x02, 
	0x43, 0x55, 0xF6, 0xB5, 0xFF, 0xFF, 0xFF, 0xFF, 0x6A, 0x82, 0xAB, 0xFF, 0xFF, 0xFF, 0x5D, 0x82, 
	0xAA, 0xA3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x02, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD2, 0x65, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xD5, 0xFE, 0xAF, 0x55, 0x55, 
	0x56, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xAD, 0x22, 0xAA, 
	0x5D, 0xA9, 0xAA, 0xBA, 0xA9, 0xD1, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 0x0A, 0x9F, 
	0x1D, 0x55, 0x42, 0xD5, 0xFF, 0xFF, 0xFF, 0xFE, 0xA8, 0x28, 0x0A, 0xBF, 0xFF, 0xFF, 0x57, 0xD8, 
	0x2A, 0xA0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA1, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD8, 0xE9, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x95, 0xAB, 0xFF, 0x59, 0x55, 
	0x55, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x67, 0x8A, 0xAA, 
	0x5A, 0x95, 0xA9, 0x2F, 0xF7, 0xCB, 0xFF, 0xFD, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x55, 0xD5, 
	0x55, 0x68, 0x21, 0xD5, 0xFF, 0xFF, 0xFF, 0xEA, 0xA2, 0x7D, 0xA0, 0x0A, 0xBF, 0xFF, 0x56, 0xAA, 
	0x7A, 0xA8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD8, 0x5A, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0x76, 0xAA, 0xBF, 0xFF, 0x66, 0x95, 
	0xA7, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD9, 0x5A, 0xA8, 
	0xA9, 0xD5, 0xAA, 0x8B, 0x55, 0xAD, 0xFF, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0x80, 0x02, 0xE7, 0x55, 0xFF, 0xFF, 0xFA, 0xA8, 0x0B, 0x55, 0xFE, 0x80, 0x00, 0x00, 0x00, 0xA5, 
	0x56, 0xAA, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x81, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD4, 0xB6, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x69, 0x59, 0xFF, 0xFF, 0xAF, 0x96, 
	0xD9, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xDA, 0x2A, 0x00, 
	0x5D, 0x55, 0xAA, 0xA1, 0xD4, 0x2A, 0xA0, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xAA, 0xBF, 0xAD, 0x55, 0xFF, 0xFF, 0xAA, 0x02, 0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAF, 0xFF, 
	0xFF, 0xAA, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCA, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0x0A, 0x2A, 0x55, 0x55, 0xFF, 0xFE, 0xAF, 0xFE, 0x55, 0x55, 0x6F, 0x65, 
	0xD2, 0xA2, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xAA, 0x95, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xD6, 0xAA, 0xAA, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xEA, 0x80, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEA, 0xA0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x8A, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x2A, 0x55, 0x55, 0xFF, 0xEA, 0xFF, 0xFF, 0x95, 0x55, 0x67, 0x59, 
	0xD2, 0xA8, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0x67, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFE, 0xB5, 0xFD, 0x5F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE0, 0x69, 0x55, 0xAA, 0x00, 0xA9, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFA, 0xAA, 0x1F, 0xFF, 0xFF, 0xFF, 0xFE, 0x28, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0x0A, 0x55, 0x55, 0xFE, 0xBF, 0xFF, 0xFF, 0xA5, 0x55, 0x5A, 0x96, 
	0x4A, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0x55, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0x59, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x1D, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0x00, 0x00, 0x08, 0xAB, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFE, 0xAA, 0x8B, 0xFF, 0xFF, 0xFF, 0xFC, 0x82, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x82, 0x55, 0x5D, 0xAB, 0xFF, 0xFF, 0xFF, 0x65, 0x5A, 0x95, 0x55, 
	0x2A, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0x55, 0x5A, 0xFF, 0xFF, 0xFF, 0xFA, 0xAF, 0xFF, 0x7A, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x85, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x75, 0x6A, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xA0, 0xFF, 0xFF, 0xFF, 0xF8, 0x25, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x20, 0x75, 0x5A, 0xBF, 0xFF, 0xFF, 0xFF, 0xEB, 0x67, 0x65, 0x55, 
	0xAA, 0xA9, 0xAF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0xFF, 0xFF, 0xFF, 0xAB, 0xFF, 0xFF, 0x56, 0x55, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF0, 0xD7, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x6A, 0xA8, 0x2F, 0xFF, 0xFF, 0xE2, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x88, 0xA6, 0xA9, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0x9F, 0xE7, 0x69, 
	0xAA, 0x02, 0xEF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0xBF, 0xFF, 0xEA, 0xBF, 0xFF, 0xFF, 0x55, 0x95, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x92, 0xD5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE2, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x56, 0xAA, 0x8B, 0xFF, 0xFF, 0x8A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0x69, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0x67, 0x65, 0xBD, 
	0xA8, 0x98, 0xFB, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0xAF, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 0x55, 0x95, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x75, 0x55, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCA, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0xAA, 0xA0, 0xBF, 0xFF, 0x2A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0xD9, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x5A, 0x95, 0x7D, 
	0x28, 0x7F, 0xBB, 0xFF, 0xFF, 0xFF, 0x55, 0x7A, 0xEA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x65, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x35, 0x55, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xEA, 0x56, 0x9F, 0xFD, 0x2A, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 
	0x9A, 0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x20, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0x55, 0xA6, 
	0x55, 0xA5, 0x96, 0x55, 0x55, 0x55, 0x5D, 0x69, 0x7A, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA9, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFA, 0x55, 0x69, 0x74, 0xA8, 0x2B, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0xFF, 0x05, 
	0x55, 0x4B, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0x55, 0x59, 
	0x55, 0x5A, 0x56, 0x95, 0x55, 0x55, 0xDA, 0x95, 0x56, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0x12, 0xA0, 0xAF, 0xFF, 0xFF, 0xFE, 0x02, 0xA8, 0x0C, 0x95, 
	0x55, 0x52, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0x56, 0x9D, 
	0x59, 0x55, 0x55, 0x95, 0x55, 0x55, 0xA9, 0x55, 0x5D, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 
	0xE1, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x55, 0x0A, 0x09, 0x2F, 0xFF, 0xFF, 0xF8, 0xAA, 0xAA, 0x50, 0x55, 
	0x55, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xF0, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x5A, 0xE5, 
	0xA6, 0x55, 0x55, 0xAD, 0x55, 0x6A, 0x9D, 0x56, 0xA5, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0x49, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAF, 0xFF, 
	0x85, 0x55, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x5A, 0x00, 0x25, 0xBF, 0xFF, 0xFF, 0xE2, 0xAA, 0xAA, 0x55, 0x55, 
	0x55, 0x56, 0x3F, 0xFF, 0xFF, 0xFF, 0xD8, 0x82, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x5B, 0xE5, 
	0xBD, 0x95, 0x55, 0x67, 0xDA, 0xA5, 0x55, 0x56, 0xD9, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xAA, 0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x15, 0x55, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0xA7, 0x22, 0x57, 0xFF, 0xFF, 0xFF, 0xC2, 0xAA, 0xAA, 0x55, 0x55, 
	0x55, 0x55, 0x3F, 0xFF, 0xFF, 0xFF, 0xF4, 0x10, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x59, 0xE5, 
	0xAF, 0x65, 0x57, 0x6A, 0xAA, 0x55, 0x55, 0x55, 0xF9, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEF, 0xFF, 0xFF, 0xFF, 0x60, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xEA, 0x08, 0x00, 0xAA, 0x7E, 0xA1, 0x7F, 0xFF, 0xFF, 0xFF, 0x8A, 0xAA, 0xAA, 0x55, 0x55, 
	0x55, 0x55, 0x3F, 0xFF, 0xFF, 0xFF, 0xF6, 0x28, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x56, 0x65, 
	0x6B, 0x65, 0x56, 0x96, 0xAD, 0x56, 0x95, 0x59, 0xF9, 0x7A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xEB, 0xFF, 0xFF, 0xFF, 0x02, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x02, 0xAA, 0x5F, 0xF6, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0x8A, 0xAA, 0xAA, 0x55, 0x55, 
	0x55, 0x55, 0x3F, 0xFF, 0xFF, 0xFF, 0xFD, 0x06, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0x95, 
	0x5A, 0x95, 0x6A, 0x55, 0xE5, 0x57, 0x69, 0x5B, 0xF9, 0x56, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFB, 0xFF, 0xFF, 0xFA, 0x2F, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE0, 0xA5, 0x55, 0xE2, 0x02, 0xBF, 0xFF, 0xFF, 0xFF, 0x8A, 0x55, 0x55, 0xFF, 0xFF, 
	0xAA, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0x95, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x95, 0x55, 
	0xFF, 0xFA, 0xAF, 0xFF, 0x59, 0x6F, 0xF0, 0xAA, 0xE5, 0x55, 0x95, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0xA8, 0x9A, 0xA8, 0x0A, 0x57, 0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x76, 0x09, 0x55, 0x4A, 0x0A, 0xBF, 0xFF, 0xFF, 0xFF, 0xCA, 0x55, 0x55, 0xFF, 0xFF, 
	0xAA, 0xA8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xA5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x55, 
	0xFF, 0xAB, 0xFF, 0xFF, 0x5A, 0xE7, 0xFC, 0xA8, 0x95, 0x55, 0xA5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0xA8, 0x08, 0x00, 0xA5, 0xF7, 0x86, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5F, 0x42, 0x57, 0x2A, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x55, 0x55, 0xFF, 0xFF, 
	0xAA, 0xA1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xA9, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0x55, 
	0xFA, 0xBF, 0xFF, 0xFF, 0x56, 0x5A, 0x58, 0xAA, 0x55, 0x55, 0x65, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0x92, 0x40, 0x29, 0x5D, 0x57, 0x8A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x58, 0x25, 0x5E, 0x98, 0x29, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x55, 0x55, 0xFF, 0xFF, 
	0xAA, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x99, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x5A, 0x55, 
	0xAB, 0xFF, 0xFF, 0xFF, 0x55, 0x9D, 0x02, 0xAA, 0x55, 0x55, 0x59, 0x55, 0xFF, 0xFF, 0x55, 0x55, 
	0x42, 0xFF, 0x57, 0xD5, 0x55, 0x4A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x2F, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0A, 0xBF, 
	0xFF, 0xE8, 0x0A, 0x75, 0x78, 0x82, 0xA7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x15, 0x55, 0xFF, 0xFF, 
	0xAA, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xA6, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x76, 0xAA, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x65, 0xAA, 0xA0, 0x95, 0x55, 0x5A, 0xD5, 0xFF, 0xFF, 0x55, 0x5D, 
	0x0B, 0xFF, 0xD5, 0x55, 0x55, 0x4A, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xA8, 0xBF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x00, 
	0x00, 0x0A, 0x9D, 0x55, 0x50, 0x27, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC5, 0x55, 0xFF, 0xFF, 
	0xA8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x6E, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x59, 0x56, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x69, 0xAA, 0x8B, 0xE5, 0x56, 0x56, 0x55, 0xFF, 0xFF, 0x55, 0x5A, 
	0x2F, 0xFF, 0x55, 0x55, 0x55, 0xC2, 0xFF, 0xFF, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2A, 0xAA, 0x80, 0x20, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 
	0xAA, 0xBF, 0x55, 0x55, 0xEA, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x55, 0xFF, 0xFF, 
	0xA0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0x69, 0x55, 
	0xBF, 0xFF, 0xFF, 0xFF, 0x55, 0x59, 0xAA, 0x89, 0x65, 0x59, 0xA5, 0x95, 0xFF, 0xFF, 0x56, 0xA9, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0xC2, 0xFF, 0xFF, 0xFE, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0xAA, 0xFB, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x57, 0x8A, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x15, 0xFF, 0xFF, 
	0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD9, 0x65, 0xFF, 0xFF, 0xFF, 0xFE, 0x95, 0x55, 
	0xAF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0xAA, 0xA8, 0x95, 0x6F, 0xDB, 0xA5, 0xFF, 0xFF, 0x6A, 0x7F, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0xC1, 0xFF, 0xFF, 0xFF, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x57, 0x45, 0xFF, 0xFF, 0xD5, 0x60, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0x2A, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x82, 0xAA, 0xAA, 
	0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x82, 0x55, 0x55, 0xFF, 0xEA, 0xFF, 0xFF, 
	0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2A, 0xA9, 0x55, 0x67, 0xF8, 0x8A, 0xAA, 0xA0, 0x09, 0x5F, 
	0x55, 0x55, 0xFF, 0x55, 0x55, 0xE1, 0x55, 0x55, 0x55, 0x60, 0x29, 0x69, 0x55, 0x55, 0x55, 0x56, 
	0xFF, 0xFF, 0x5D, 0x9D, 0xFF, 0xFF, 0xA8, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5C, 0xA8, 0x17, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x2A, 0xA0, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0x55, 0x55, 0xFA, 0xAF, 0xFF, 0xFF, 
	0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2A, 0x80, 0x55, 0x59, 0xF8, 0x42, 0xAA, 0x02, 0x95, 0xF5, 
	0x55, 0x7F, 0x69, 0xD5, 0x55, 0xE1, 0x55, 0x55, 0x55, 0xA2, 0x80, 0x2A, 0xAA, 0xAA, 0xAA, 0xA0, 
	0xFF, 0xFF, 0x58, 0xAA, 0xAA, 0x80, 0x0A, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x78, 0xA8, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x82, 0x83, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x60, 0x95, 0x55, 0xAB, 0xFF, 0xFF, 0xFF, 
	0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8A, 0x2E, 0x95, 0x56, 0x02, 0x80, 0x00, 0x25, 0x7D, 0x55, 
	0x57, 0xD8, 0x00, 0x75, 0x55, 0xE2, 0x55, 0x55, 0x68, 0x07, 0xF6, 0xAA, 0x80, 0x00, 0x00, 0x2B, 
	0xFF, 0xFF, 0x5A, 0xAA, 0xAA, 0xAA, 0x5F, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x52, 0xA2, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xAA, 0xAA, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0x3F, 0x95, 0x55, 0xA9, 0x0E, 0xAA, 0x57, 0x55, 0x55, 
	0xF6, 0x00, 0xA8, 0xB5, 0x55, 0xD0, 0x00, 0x00, 0x02, 0x7F, 0xFF, 0xFD, 0x6A, 0xAA, 0xAA, 0x7F, 
	0xFF, 0xFF, 0x57, 0x55, 0xFF, 0xFF, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0xCA, 0x09, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x69, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0x9F, 0x55, 0x55, 0x98, 0x2F, 0x55, 0xD5, 0x55, 0x7F, 
	0x60, 0x2A, 0xA8, 0xB5, 0x55, 0xD2, 0xAA, 0xA6, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x57, 0x80, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0xDB, 0xD5, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x9F, 0x95, 0x55, 0x80, 0xBF, 0x55, 0x55, 0x5F, 0xD8, 
	0x02, 0x80, 0xA8, 0x15, 0x55, 0x51, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x5E, 0x22, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0xBA, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0x8E, 0x95, 0x56, 0x09, 0xFF, 0x55, 0x55, 0xF6, 0x00, 
	0xA8, 0x2A, 0x28, 0x1D, 0x55, 0x52, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x54, 0xA2, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xA6, 0x55, 0xFF, 0xFF, 0xFE, 0xAF, 
	0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA8, 0xA0, 0x55, 0x6A, 0xBF, 0xFF, 0x55, 0x7D, 0xA0, 0x2A, 
	0x02, 0xA9, 0x8A, 0x1D, 0x55, 0x72, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 
	0x55, 0x55, 0x52, 0xA2, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x2A, 0xAA, 0xAA, 0x82, 0x82, 
	0xFF, 0xEB, 0xFF, 0xFF, 0x55, 0x55, 0xAA, 0x15, 0xA0, 0x0A, 0x5D, 0x55, 0xFF, 0xF8, 0xA5, 0x56, 
	0xBF, 0xFF, 0x4A, 0x3F, 0x55, 0x72, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 
	0x55, 0x55, 0x62, 0xA2, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0x2A, 0xAA, 0xAA, 0x0F, 0xF8, 
	0xFF, 0xFB, 0xFF, 0xFF, 0x55, 0x55, 0xAA, 0x00, 0x02, 0xBF, 0xD5, 0x55, 0xFE, 0x02, 0x55, 0x5B, 
	0xFF, 0xFF, 0x4A, 0x3F, 0x55, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xFF, 
	0x55, 0x57, 0x4A, 0xA2, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x8A, 0xAA, 0x00, 0x3F, 0xFE, 
	0xFF, 0xFA, 0xFF, 0xFF, 0x55, 0x55, 0xA4, 0x2A, 0xAF, 0xFF, 0x55, 0x57, 0xE0, 0x28, 0xA9, 0x5B, 
	0xFF, 0xFF, 0x4A, 0x1F, 0x55, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 
	0x55, 0x57, 0x2A, 0x89, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x82, 0xA8, 0xBE, 0xBF, 0xFE, 
	0xFF, 0xFE, 0xFF, 0xFF, 0x55, 0x55, 0x60, 0xBF, 0xFF, 0xFF, 0x55, 0x5E, 0x02, 0x82, 0xFE, 0x5B, 
	0xFF, 0xFF, 0x4A, 0x1F, 0x55, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 
	0xD5, 0x5E, 0x1A, 0x25, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xA2, 0xA2, 0xFF, 0xFF, 0xF8, 
	0xFF, 0xFE, 0xFF, 0xFF, 0x55, 0x55, 0x02, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0xA0, 0x95, 0xFE, 0x5B, 
	0xFF, 0xFF, 0x4A, 0x1F, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 
	0x7D, 0x74, 0x20, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x28, 0xAB, 0xFF, 0xFF, 0xF0, 
	0xFF, 0xFF, 0xBF, 0xFF, 0x55, 0x5A, 0x2F, 0xFF, 0xFF, 0xFF, 0x55, 0x50, 0x89, 0x55, 0xFE, 0x5B, 
	0xFF, 0xFF, 0x4A, 0x2F, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 
	0xA9, 0xF2, 0x09, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x24, 0x32, 0xFF, 0xFF, 0xE2, 
	0xFF, 0xFF, 0xBF, 0xFF, 0x56, 0xA7, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD2, 0x85, 0x55, 0xFE, 0x57, 
	0xFF, 0xFF, 0x8A, 0x2F, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x6A, 0x62, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x89, 0x28, 0xBF, 0xFF, 0xCA, 
	0xFF, 0xFF, 0xEF, 0xFF, 0x6A, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD2, 0x15, 0x55, 0xFE, 0x57, 
	0xFF, 0xFF, 0x2A, 0x2F, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x56, 0x8A, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xAD, 0x95, 0xFF, 0xEF, 
	0xAA, 0xAA, 0x82, 0x80, 0x29, 0x5D, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0xD2, 0x3F, 0xFF, 0xFE, 0x57, 
	0xFF, 0xFE, 0xAA, 0x2F, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 
	0x55, 0x2A, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xA5, 0x56, 0xAA, 0xBF, 
	0xAA, 0xA9, 0x88, 0x02, 0x55, 0xD5, 0xFD, 0x8B, 0x55, 0x55, 0x55, 0xD2, 0x3F, 0xFF, 0xFE, 0x57, 
	0xFF, 0xE9, 0xAA, 0x1F, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 
	0x5E, 0x2A, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xA9, 0x55, 0xFF, 0xFF, 
	0xAA, 0xA8, 0x2F, 0x55, 0x7D, 0x7F, 0x60, 0x02, 0xD5, 0x55, 0x55, 0xD2, 0x3F, 0xFF, 0xFE, 0x5B, 
	0xF6, 0x95, 0xAA, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 
	0x54, 0xAA, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x99, 0x55, 0xFF, 0xFF, 
	0xAA, 0x60, 0x95, 0xFF, 0x5F, 0xD8, 0x02, 0xA8, 0x75, 0x55, 0x55, 0xD2, 0x2F, 0xFF, 0xFE, 0x56, 
	0xA9, 0x55, 0xAA, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x7A, 0x60, 0x2B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x66, 0x55, 0xFF, 0xFF, 
	0xAA, 0x01, 0x75, 0x57, 0xF6, 0x00, 0xAA, 0xA8, 0xB5, 0x55, 0x55, 0xD2, 0x3F, 0xFF, 0xF5, 0x55, 
	0x55, 0xAA, 0xAA, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE0, 0x02, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x55, 0x55, 0x55, 0xFF, 0xE6, 0xB5, 0xFF, 0xFF, 
	0x80, 0x2F, 0xD5, 0x7D, 0x80, 0x2A, 0xA2, 0xA8, 0xB5, 0x55, 0x55, 0xD2, 0x3F, 0xFF, 0xD9, 0x55, 
	0x5A, 0x7F, 0x2A, 0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x48, 0x1F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6A, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xD9, 0x9D, 0xFF, 0xEA, 
	0x0B, 0xFF, 0x5F, 0x68, 0x0A, 0xA8, 0x28, 0x28, 0xB5, 0x55, 0x55, 0xD2, 0x3F, 0xFF, 0xA5, 0x55, 
	0xAF, 0xFF, 0x2A, 0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2A, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, 0xA0, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x02, 0x02, 0xAA, 0xAA, 0xAA, 0xAA, 0x07, 0xFA, 0xA9, 0xEA, 0xAF, 
	0xFF, 0xFF, 0xFA, 0x02, 0xAA, 0x02, 0x55, 0x28, 0xB5, 0x55, 0x55, 0xD2, 0x0F, 0x80, 0x55, 0x56, 
	0xBF, 0xFF, 0x2A, 0x3F, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x56, 0xAB, 0xD5, 0x55, 0x55, 0x94, 0x26, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFE, 
	0x2A, 0x27, 0xFF, 0xF5, 0x68, 0x00, 0x00, 0x0A, 0xAA, 0xA0, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x60, 0x00, 0x2A, 0xAA, 0xAA, 0x2A, 0x8B, 0xD9, 0x80, 0x0A, 0x55, 
	0xFF, 0xFF, 0x80, 0x2A, 0xA0, 0xBF, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0xD0, 0x5A, 0x95, 0x55, 0x56, 
	0xFF, 0xFF, 0xAA, 0x1D, 0x55, 0x54, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x6A, 0x0F, 0x55, 0x55, 0x55, 0x50, 0x1A, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFC, 
	0xAA, 0x17, 0xFE, 0xA0, 0x0A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x25, 0xAA, 0xAA, 0xA2, 0xAA, 0x82, 0x8B, 0xDB, 0xFD, 0x55, 0xF5, 
	0xFF, 0xE0, 0x0A, 0x82, 0xA3, 0xFF, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0x50, 0x55, 0x5A, 0xA9, 0x56, 
	0xFF, 0xFF, 0x88, 0x1D, 0x55, 0x54, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x56, 0xA8, 0x2D, 0x55, 0x55, 0x55, 0x40, 0x25, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xF2, 
	0xA8, 0x97, 0xF0, 0x2A, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0xAA, 0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x15, 0xFF, 0xE2, 0x8A, 0xBF, 0x52, 0x8B, 0xD3, 0x55, 0xF5, 0x55, 
	0xFC, 0x02, 0xA0, 0x34, 0xAB, 0xFF, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0x50, 0x55, 0xA7, 0xFE, 0x56, 
	0xFF, 0xFF, 0x88, 0x15, 0x55, 0x54, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0x28, 0xB5, 0x55, 0x55, 0x55, 0x00, 0x02, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xE1, 
	0xA0, 0x9F, 0xD2, 0xA0, 0x02, 0x8A, 0xA8, 0x15, 0x55, 0x2A, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x17, 0xFF, 0xE2, 0x8A, 0xFF, 0x52, 0x8B, 0xD1, 0x55, 0x55, 0x55, 
	0xE0, 0xA8, 0x0F, 0xFC, 0xAB, 0xFF, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0x50, 0x5A, 0xFF, 0xFE, 0x56, 
	0xFF, 0xFF, 0x88, 0x35, 0x55, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x65, 0x6A, 0x02, 0x99, 0xD5, 0x55, 0x55, 0x5A, 0x00, 0x00, 0xA5, 0x55, 0xFF, 0xFF, 0xFF, 0xC2, 
	0x0A, 0x7F, 0xE2, 0x2A, 0x57, 0xD2, 0xA8, 0x5F, 0xFF, 0x4A, 0x89, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xE2, 0x8B, 0xFF, 0x52, 0x8B, 0xF9, 0x55, 0x55, 0x57, 
	0xC2, 0x82, 0xFF, 0xFD, 0xAB, 0xFF, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0x70, 0x5B, 0xFF, 0xFE, 0x56, 
	0xFF, 0xFF, 0x28, 0xB5, 0x55, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x02, 0xA7, 0xEB, 0x55, 0x55, 0x55, 0xA8, 0x2F, 0x80, 0xAA, 0x55, 0xFF, 0xFF, 0xFE, 0xBA, 
	0x96, 0x7F, 0xE2, 0x29, 0xFF, 0xFA, 0xA8, 0x5F, 0xFF, 0xCA, 0x89, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xE2, 0x8B, 0xFF, 0x5A, 0x8B, 0xF9, 0x55, 0x55, 0x57, 
	0xCA, 0x05, 0xFF, 0xFD, 0xAB, 0xFF, 0xFF, 0x96, 0x35, 0x55, 0x55, 0x78, 0x5B, 0xFF, 0xFE, 0x56, 
	0xFF, 0xFF, 0x28, 0xB5, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x9F, 0xFE, 0x1D, 0x55, 0xFF, 0x56, 0x82, 0x7F, 0xF8, 0x00, 0x0A, 0xFF, 0xFF, 0xFF, 0x8A, 
	0xA8, 0xBF, 0xE2, 0x25, 0xFF, 0xF6, 0xA8, 0x7F, 0xFF, 0xEA, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xE2, 0x8B, 0xFF, 0x5A, 0x83, 0x79, 0x55, 0x55, 0x57, 
	0xCA, 0x15, 0xFF, 0xFD, 0xAB, 0xFF, 0xFF, 0x96, 0x35, 0x55, 0x55, 0x78, 0x5B, 0xFF, 0xFE, 0x56, 
	0xBF, 0xF0, 0xA8, 0xB5, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x6A, 0x75, 0xFF, 0x56, 0xA0, 0x9F, 0xFF, 0xFF, 0xFD, 0x58, 0x00, 0x0A, 0xAA, 0x0F, 
	0xA8, 0xBF, 0xE2, 0x25, 0xFF, 0xF4, 0xA8, 0x7F, 0xFF, 0xDA, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xE2, 0x8B, 0xFF, 0x52, 0xA1, 0x79, 0x55, 0x55, 0x57, 
	0xCA, 0x15, 0xFF, 0xFD, 0xAB, 0xFF, 0xFD, 0x96, 0x35, 0x55, 0x55, 0x78, 0x5B, 0xFF, 0xFE, 0x55, 
	0x3E, 0x0A, 0xA8, 0x75, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA0, 0x00, 0x00, 0xAF, 
	0xFF, 0x2A, 0xD2, 0x25, 0xFF, 0xF4, 0xA8, 0x7F, 0xFF, 0xDA, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x1F, 0xFF, 0xD2, 0x87, 0xFF, 0xF9, 0x5B, 0x71, 0x55, 0xFF, 0xFF, 
	0xCA, 0x15, 0xFF, 0xFE, 0x57, 0xFF, 0xF6, 0x56, 0xB5, 0x55, 0x55, 0x78, 0x5B, 0xFF, 0x54, 0xAA, 
	0x80, 0xAA, 0x82, 0xD5, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x8A, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x2A, 0xD2, 0x25, 0xFF, 0xF4, 0xA8, 0x7F, 0xFF, 0xD2, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x1F, 0xFF, 0xD2, 0x87, 0xFF, 0xF9, 0x59, 0x71, 0x55, 0xFF, 0xFF, 
	0xC2, 0x15, 0xFF, 0xFC, 0x5B, 0xFF, 0x69, 0x56, 0xB5, 0x55, 0x55, 0x78, 0x5B, 0xFF, 0x54, 0xAA, 
	0xAA, 0xA8, 0x0B, 0xD5, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x0A, 0xD2, 0x25, 0xFF, 0xFC, 0xA8, 0x7F, 0xFF, 0xD2, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x85, 0x58, 0x0A, 0xA2, 0x80, 0xA5, 0x59, 0x71, 0x55, 0xFF, 0xFF, 
	0xC2, 0x15, 0xFF, 0xFC, 0x5B, 0xF6, 0x95, 0x56, 0xB5, 0x55, 0x55, 0x78, 0x5B, 0xFF, 0x50, 0xAA, 
	0xAA, 0x00, 0x9F, 0x55, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x0A, 0xD2, 0xA5, 0xFF, 0xF4, 0xAA, 0x1F, 0x55, 0x4A, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xA0, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x59, 0x71, 0x55, 0xFF, 0xFF, 
	0xE2, 0x15, 0xFF, 0xFC, 0x5A, 0xA5, 0x5A, 0x56, 0xB5, 0x55, 0x55, 0x78, 0x5B, 0xFD, 0x0A, 0xAA, 
	0x00, 0x27, 0xD5, 0x55, 0x55, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x0A, 0xF2, 0x89, 0x55, 0x62, 0xAA, 0x80, 0x00, 0x2A, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xA6, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x59, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0x15, 0xFF, 0xF8, 0x55, 0x56, 0xAD, 0x96, 0xB5, 0x55, 0x55, 0x78, 0x5A, 0x6A, 0xAA, 0x80, 
	0x09, 0xFD, 0x55, 0x55, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8A, 0xF8, 0xA0, 0x00, 0x2A, 0xAA, 0xAA, 0xAA, 0xAA, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xA0, 0x00, 0x0A, 0xA8, 0x00, 0xA5, 0x59, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0x15, 0xFF, 0xE2, 0x55, 0x69, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0x78, 0x55, 0x95, 0xA0, 0x09, 
	0x7F, 0x55, 0x55, 0x55, 0x55, 0x78, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x8A, 0xF8, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x89, 0x55, 0x52, 0xA1, 0x55, 0xF9, 0x59, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0x15, 0xFE, 0x0A, 0x56, 0x9F, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0x74, 0x55, 0x5A, 0x02, 0xBF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCA, 0xF8, 0xAA, 0xAA, 0xAA, 0xAA, 0x80, 0x02, 0x0A, 0xA2, 0x7F, 0xFF, 0xFF, 0xEA, 0x00, 
	0x02, 0xBF, 0xFF, 0xFF, 0xF2, 0xA5, 0xFF, 0xFA, 0x85, 0xFF, 0xF9, 0x59, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0x25, 0xE0, 0xAA, 0x5A, 0xFF, 0xFF, 0x96, 0xB5, 0x55, 0x55, 0x5C, 0xAA, 0xA9, 0x9F, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x74, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCA, 0xF4, 0xA8, 0xAA, 0x80, 0xAA, 0x15, 0xAB, 0xC0, 0xA2, 0x7F, 0xFF, 0xFD, 0xAA, 0xA5, 
	0xAA, 0xAB, 0xFF, 0xFF, 0xF2, 0x89, 0xFF, 0xFA, 0x8B, 0xFF, 0xFA, 0xA2, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0x80, 0x00, 0x02, 0xA2, 0x55, 0xFF, 0x96, 0xB5, 0x55, 0xFF, 0xFF, 0x82, 0xA7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x56, 0x00, 0x0A, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCA, 0xF4, 0xA2, 0xAF, 0xFE, 0xAA, 0x17, 0xFF, 0xE0, 0xA2, 0x7F, 0xFF, 0x40, 0x97, 0x55, 
	0x57, 0x68, 0x9F, 0xFF, 0xFA, 0x89, 0xFF, 0xFA, 0x8B, 0xFF, 0xFA, 0xA2, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0xA8, 0x0B, 0xF2, 0xAA, 0x55, 0xFF, 0x96, 0xB5, 0x55, 0xFF, 0xFF, 0xDF, 0xF5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xCA, 0xF4, 0xAA, 0xBF, 0xFE, 0x2A, 0x1F, 0xFF, 0xE0, 0xA2, 0x7F, 0xFC, 0x09, 0x55, 0x55, 
	0x55, 0x5D, 0x07, 0xFF, 0xFA, 0x89, 0xFF, 0xFA, 0x8B, 0xFF, 0xF6, 0xA2, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0xA0, 0xFF, 0xF8, 0xAA, 0x55, 0xFF, 0x96, 0xB5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0x60, 0x00, 0x15, 0x40, 0x00, 0x00, 0x2A, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC2, 0xF4, 0xAA, 0xFF, 0xFE, 0x2A, 0x1F, 0xFF, 0xE0, 0xA2, 0x7F, 0xD0, 0x9A, 0x55, 0x7F, 
	0x55, 0x55, 0x61, 0xFF, 0xF8, 0x89, 0xFF, 0xFA, 0xAB, 0xFF, 0xF6, 0xA1, 0x72, 0xD5, 0xFF, 0xFF, 
	0xE2, 0x85, 0xFF, 0xFC, 0xAA, 0x55, 0xFF, 0x96, 0xB5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0xF5, 0xF8, 0x00, 0x00, 0x2A, 0xAF, 0xFF, 0xFF, 
	0xFF, 0xC2, 0xFC, 0xA2, 0xFF, 0xFF, 0x2A, 0x1F, 0xFF, 0xE0, 0xA2, 0x7F, 0x41, 0xAA, 0xA7, 0x62, 
	0x55, 0x55, 0x98, 0x7F, 0xF8, 0x89, 0xFF, 0xFA, 0xAB, 0xFF, 0xF6, 0xA1, 0x72, 0xD5, 0xFF, 0xFF, 
	0xD2, 0x85, 0xFF, 0xFC, 0xA2, 0x55, 0xFF, 0x96, 0x75, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xFF, 0xFF, 0xF8, 0x20, 0x00, 0x02, 0xD1, 0xD0, 0x00, 0x03, 0xEB, 0xCB, 0xFF, 0xFF, 
	0xFF, 0xC2, 0xFE, 0xA2, 0xFF, 0xFF, 0xAA, 0x2F, 0xFF, 0xE0, 0xA2, 0x7F, 0x26, 0xA8, 0x28, 0x28, 
	0x15, 0x55, 0xA6, 0x3F, 0xF8, 0x89, 0xFF, 0xF2, 0xAB, 0xFF, 0xF6, 0xA1, 0x71, 0xD5, 0xFF, 0xFF, 
	0xF2, 0x85, 0xFF, 0xFC, 0xA2, 0x55, 0xFE, 0x56, 0x75, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFA, 0xFF, 0xFF, 0xC0, 0xB0, 0x00, 0x00, 0x55, 0x40, 0x00, 0x0B, 0x8B, 0x83, 0xFF, 0xFF, 
	0xFF, 0xE2, 0xFE, 0x22, 0xFF, 0xFF, 0x4A, 0xAF, 0xFF, 0xE0, 0xA2, 0x7E, 0x1A, 0x90, 0x54, 0x95, 
	0xAD, 0x55, 0xA9, 0x2F, 0xF4, 0x89, 0xAA, 0xE2, 0xA2, 0xFF, 0xD2, 0xA1, 0x71, 0xD5, 0xFF, 0xFF, 
	0xF2, 0x85, 0xFF, 0xFC, 0xA2, 0xD5, 0xE9, 0x5A, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF2, 0xFF, 0xFF, 0xAA, 0xA0, 0x00, 0x00, 0x24, 0x00, 0x00, 0x02, 0x80, 0x00, 0xFF, 0xFF, 
	0xFF, 0xE2, 0xFE, 0x22, 0xFF, 0xFF, 0xAA, 0x85, 0xAA, 0x80, 0x82, 0x7E, 0xAA, 0x92, 0x55, 0x55, 
	0xAD, 0x55, 0xA9, 0x87, 0xF4, 0xA0, 0x00, 0x0A, 0xA8, 0x00, 0x0A, 0xA3, 0xF1, 0xD5, 0xFF, 0xFF, 
	0xF2, 0x85, 0xFF, 0xFC, 0xA8, 0x58, 0x95, 0xAB, 0xD5, 0x55, 0xFF, 0xFF, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 
	0x55, 0x53, 0xFF, 0xFF, 0x46, 0x00, 0x00, 0x00, 0xAA, 0xA0, 0xAA, 0xAA, 0x2A, 0x80, 0xBF, 0xFF, 
	0xFF, 0xE2, 0xFE, 0x22, 0x55, 0x58, 0x2A, 0xA0, 0x0A, 0xAA, 0x89, 0x76, 0x55, 0x72, 0x55, 0x55, 
	0x95, 0x55, 0x55, 0x6B, 0xFC, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x89, 0xF1, 0x55, 0xFF, 0xFF, 
	0xF0, 0x85, 0x55, 0x5A, 0xA8, 0x0A, 0x80, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x53, 0xFF, 0xFF, 0x42, 0xA0, 0x00, 0x00, 0x2A, 0xA0, 0xAA, 0xAA, 0xAA, 0x80, 0x2F, 0xFF, 
	0xFF, 0xF2, 0xFE, 0x28, 0x00, 0x2A, 0xAA, 0xAA, 0xAA, 0xAA, 0x89, 0xFA, 0xD5, 0x58, 0x55, 0x56, 
	0xB5, 0x55, 0x55, 0xE3, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF0, 0x85, 0x55, 0x62, 0xAA, 0xA0, 0x09, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x56, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x53, 0xFF, 0xFF, 0x8A, 0xA0, 0x00, 0x00, 0x2A, 0xA0, 0xAA, 0xAA, 0xAA, 0x80, 0x0B, 0xFF, 
	0xFF, 0xF2, 0xFD, 0x2A, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xA8, 0x29, 0xFA, 0xD5, 0x5E, 0x15, 0x54, 
	0x55, 0x55, 0x55, 0x63, 0xFF, 0x60, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x59, 0xF2, 0xD5, 0xFF, 0xFF, 
	0xF0, 0x85, 0x56, 0x0A, 0xAA, 0x02, 0x7F, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x57, 0x5E, 0xBF, 0xCB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x6B, 0xFF, 0xFE, 0x02, 0xA0, 0x00, 0x00, 0x08, 0x80, 0xAA, 0xAA, 0x00, 0x00, 0x02, 0xA7, 
	0xFF, 0xF2, 0xFF, 0x8A, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAB, 0xFA, 0x55, 0x55, 0x85, 0x52, 
	0xD5, 0x55, 0x55, 0x51, 0xFF, 0xDA, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5F, 0xF0, 0xD5, 0xFF, 0xFF, 
	0xF0, 0x85, 0x40, 0xAA, 0x80, 0xA7, 0xD5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0x55, 0x55, 0x5E, 0xBF, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x4B, 0xFF, 0xA8, 0xAA, 0xAA, 0xAA, 0x5A, 0xA5, 0x55, 0x55, 0x55, 0x55, 0x57, 0x56, 0x61, 
	0xFF, 0xF2, 0xFF, 0x40, 0x00, 0x0A, 0xAA, 0xAA, 0xAA, 0x95, 0x5F, 0xFA, 0x55, 0x55, 0xE0, 0x8B, 
	0x55, 0x55, 0x55, 0x5A, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0xF0, 0x80, 0x2A, 0xA0, 0x09, 0xF5, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 
	0xFF, 0xFF, 0x55, 0xF5, 0x54, 0x9A, 0xBC, 0xA3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x4B, 0xFE, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x58, 0x7A, 
	0xFF, 0xF0, 0xFF, 0xDA, 0xAA, 0x57, 0x55, 0x55, 0x55, 0x57, 0xFF, 0x42, 0x55, 0x55, 0x5E, 0x2D, 
	0x55, 0x55, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0xF8, 0xAA, 0xAA, 0x02, 0x7F, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x7D, 
	0xFF, 0xFF, 0x55, 0x5D, 0x76, 0xB0, 0xBC, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 
	0x55, 0x4F, 0xFE, 0x82, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x1A, 
	0xBF, 0xF0, 0xFF, 0xFD, 0xFF, 0xFF, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0x55, 0x55, 0x55, 0xD5, 
	0x55, 0x55, 0x55, 0x78, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0xF8, 0xAA, 0x80, 0x1F, 0xD5, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0xD7, 
	0xFF, 0xFF, 0x57, 0x87, 0x7A, 0xB8, 0xB8, 0xF3, 0xFA, 0xA0, 0x0B, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 
	0x55, 0x4F, 0xFE, 0x82, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0xA2, 
	0xBF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0x55, 0x55, 0x55, 0x55, 
	0x55, 0x55, 0x55, 0x58, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0xFC, 0x00, 0x0B, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFE, 0xB5, 0xEB, 
	0xFF, 0xFF, 0x55, 0xE1, 0xDA, 0xB8, 0x3C, 0xB2, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x8F, 0xFD, 0xA9, 0xFF, 0xF5, 0xFE, 0xAA, 0xBF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0x82, 0xAB, 
	0xBF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x22, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x58, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0x5E, 0x0A, 0x9D, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xC3, 0x55, 0x5E, 0x3F, 0xC3, 
	0x54, 0x55, 0x55, 0x70, 0xF2, 0xB8, 0x38, 0x30, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x0F, 0xFF, 0x2A, 0xAA, 0xAA, 0xAA, 0xAA, 0xBF, 0xFA, 0xAA, 0xAA, 0xBF, 0xAA, 0xC0, 0x0A, 
	0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x54, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0x57, 0xFF, 0x6A, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE2, 0xD5, 0x57, 0x0F, 0x96, 
	0xF4, 0x75, 0x55, 0x74, 0x2A, 0xEA, 0x0A, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x0F, 0xFD, 0x00, 0xA5, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0xEA, 0xC0, 0x08, 
	0xBF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x54, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE8, 0x55, 0x5D, 0x0F, 0x94, 
	0xF0, 0x75, 0x55, 0x72, 0x0E, 0x0F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAF, 0xFF, 
	0xAA, 0x0F, 0xFE, 0x00, 0xA5, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0xEA, 0x3E, 0xFF, 
	0x2F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x82, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xC4, 0xB5, 0x5E, 0x2F, 0x14, 
	0xD2, 0xB5, 0x5F, 0xF2, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0x0F, 0xFE, 0x00, 0xA5, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0xEA, 0xBF, 0x3F, 
	0x2F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xEA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xCA, 0x35, 0x74, 0x6F, 0x34, 
	0xC8, 0x7F, 0x5A, 0x02, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x1F, 0xFC, 0x00, 0xA9, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0xEA, 0x3F, 0x2F, 
	0x2F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE9, 0x15, 0x72, 0x6C, 0x72, 
	0x84, 0xD0, 0x00, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0x1F, 0xFC, 0x00, 0xA9, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0xEA, 0x2F, 0xEE, 
	0x2F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE9, 0x2D, 0xC1, 0x2C, 0xF4, 
	0x18, 0x02, 0x95, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA8, 0x3F, 0xFC, 0x00, 0xA9, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0xFF, 0xEA, 0x02, 0xFC, 
	0xBF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xAA, 0xAA, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x97, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xE1, 0x8F, 0x45, 0x63, 0xF0, 
	0x54, 0x15, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA8, 0x3F, 0xF4, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xAB, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x40, 0x02, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x5F, 0xFF, 0xF1, 0xCB, 0x2F, 0x8B, 0xF2, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xA8, 0x3F, 0xF4, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xAB, 
	0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x57, 0x0A, 0xA8, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xD5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x56, 0x00, 0xBC, 0xF3, 0x3F, 0x2F, 0xFB, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xA8, 0xBF, 0xF4, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xAB, 
	0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x2A, 0x00, 0x5E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x78, 0x1D, 0x4A, 0x30, 0xBE, 0x3F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA8, 0xFF, 0xF4, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xAB, 
	0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x28, 0x29, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x83, 0xF0, 0x38, 0xBF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA0, 0xFF, 0xF4, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xA9, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x28, 0xB5, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xD5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x57, 0xF8, 0xFD, 0x3C, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA0, 0xFF, 0xF4, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xA9, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x00, 0x55, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xD5, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xD5, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 0xAA, 0xBE, 0xAA, 0xAA, 0xBF, 0xBF, 0xFF, 0xFF, 
	0xA2, 0xFF, 0xF8, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xA9, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x42, 0x55, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x57, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xBE, 0xAA, 0xAA, 0xAE, 0xBF, 0xFF, 0xFF, 
	0xA2, 0xFF, 0xF8, 0x00, 0xAB, 0xFE, 0xFF, 0xFF, 0xBF, 0xFE, 0xFF, 0xFF, 0xFF, 0xEA, 0xAA, 0xAA, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x5E, 0x1E, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xA3, 0xFF, 0xFA, 0xAA, 0xA9, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0x55, 0x6A, 0xAA, 0xAA, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0xFD, 0x0D, 0xFF, 0xFF, 0xFC, 0x55, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5D, 0x82, 0x02, 0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAA, 
	0x83, 0xFF, 0xFA, 0xAA, 0xA9, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0x55, 0x6A, 0xAA, 0xAA, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x56, 0x2F, 0xFF, 0xFF, 0xFF, 0x60, 0x09, 0xFF, 0xFF, 0xFC, 0x95, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5C, 0x8A, 0x8B, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0xAA, 0xAF, 
	0x83, 0xFF, 0xFA, 0xAA, 0xA9, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0x55, 0x6A, 0xAA, 0xAA, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0xFF, 0xFF, 0xFF, 0xC0, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0xFE, 0x20, 0xA7, 0xFF, 0xFF, 0xFC, 0x15, 0xFF, 0xFF, 
	0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x7A, 0x49, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xEF, 0xEF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xBE, 0xFF, 0xFF, 0xFF, 
	0x83, 0xFF, 0xDA, 0xAA, 0xA9, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0x55, 0x6A, 0xAA, 0xAA, 
	0xBF, 0xFF, 0x3F, 0xFF, 0xFF, 0x4B, 0xF4, 0x80, 0xBF, 0xFF, 0xFF, 0x48, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0xF0, 0x62, 0x5F, 0xFF, 0xFF, 0xFC, 0x15, 0xFF, 0xFF, 
	0x55, 0x55, 0xF5, 0xD5, 0x55, 0x55, 0xF1, 0x85, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 
	0xAA, 0xAA, 0xAF, 0xEA, 0xAA, 0xAA, 0xFA, 0xAA, 0xAA, 0xBE, 0xAA, 0xAA, 0xBE, 0xBF, 0xFF, 0xFF, 
	0x8B, 0xFF, 0xDA, 0xAA, 0xA5, 0x56, 0xAA, 0xAA, 0xBF, 0xFE, 0xAA, 0xAA, 0x55, 0x6A, 0xAA, 0xAA, 
	0xBF, 0xFF, 0x2F, 0xFF, 0xF6, 0x87, 0xD2, 0x81, 0xBF, 0xFF, 0xFF, 0x48, 0x55, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0xE2, 0x89, 0xFF, 0xFF, 0xFF, 0xFE, 0x15, 0xFF, 0xFF, 
	0x55, 0x5D, 0x0F, 0x5F, 0x55, 0x7D, 0x41, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8B, 0xFF, 0xDA, 0xAA, 0xA5, 0x56, 0xAA, 0xAA, 0xBF, 0xFF, 0xAA, 0xAA, 0x55, 0x6A, 0xAA, 0xAA, 
	0xBF, 0xFF, 0xAF, 0xFF, 0xDA, 0x9F, 0x84, 0x27, 0xFF, 0xFF, 0xFF, 0x48, 0x95, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0xCA, 0x29, 0xFF, 0xFF, 0xFF, 0xFC, 0x15, 0xFF, 0xFF, 
	0x5D, 0x74, 0x2C, 0x14, 0x3F, 0x60, 0xA5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x8F, 0xFF, 0xEA, 0xAA, 0xAA, 0x5A, 0xAA, 0xAA, 0xAF, 0xFA, 0xAA, 0xAA, 0xA5, 0xAA, 0xAA, 0xAA, 
	0x2B, 0xFF, 0xAF, 0xFF, 0xE6, 0xBE, 0x10, 0x5F, 0xFF, 0xFF, 0xFF, 0xC0, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0x08, 0x17, 0xFD, 0xFF, 0xFF, 0xFE, 0x15, 0xFF, 0xFF, 
	0x57, 0x72, 0xB0, 0x18, 0xB8, 0x0A, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0xFE, 0x59, 0x55, 0x5F, 0xFF, 0xD5, 0x55, 0xFF, 0xFF, 0xBF, 0xFF, 0x7F, 0xF5, 0x55, 0x57, 
	0x02, 0xFF, 0xAF, 0xFF, 0xA4, 0x7A, 0x62, 0x7F, 0xFF, 0xFF, 0xFF, 0xD0, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x55, 0x5E, 0x2F, 0xFF, 0xFF, 0x28, 0x1F, 0xC0, 0xAF, 0xFF, 0xFE, 0x15, 0xFF, 0xFF, 
	0xE3, 0xEA, 0xAA, 0x04, 0x82, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xEA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 
	0x2F, 0xF4, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x28, 0xFF, 0x9F, 0xFF, 0xB8, 0xFB, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0xB5, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAC, 0x2F, 0xFF, 0xFF, 0x96, 0x7D, 0x82, 0x9F, 0xFF, 0xFC, 0x1A, 0x55, 0xF5, 
	0xE1, 0xC6, 0x2C, 0x3E, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2F, 0xF6, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 
	0x08, 0xFF, 0xAF, 0xFE, 0x73, 0xEF, 0x0B, 0xFF, 0xFF, 0xFF, 0xF6, 0xFD, 0x95, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAC, 0x2F, 0xFF, 0xFD, 0x9A, 0x7A, 0xA7, 0xFF, 0xFF, 0xFE, 0x1A, 0x55, 0x07, 
	0xC2, 0x44, 0x3E, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x2F, 0xF6, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 
	0x28, 0xBF, 0xAF, 0xFC, 0x53, 0x1F, 0x2F, 0xFF, 0xFF, 0xFF, 0x62, 0xFD, 0x95, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAC, 0x2F, 0xF8, 0x9D, 0x9A, 0xEA, 0x1F, 0xA1, 0x7F, 0xFE, 0x2A, 0x55, 0x40, 
	0x48, 0x25, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xF6, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0xFF, 0x8F, 0xF4, 0xEF, 0xBE, 0x1F, 0xFF, 0xEA, 0x7D, 0xAB, 0xF5, 0x95, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAC, 0x2F, 0xE0, 0x8A, 0x99, 0x66, 0xB4, 0x80, 0x7F, 0xFE, 0x2A, 0x55, 0xF2, 
	0x0A, 0x15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0xAA, 0xAB, 0xEA, 0xAA, 0xAA, 0xFA, 0xAA, 0xAB, 0xFA, 0xAA, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xFC, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x5D, 0x55, 0x55, 0x55, 0x55, 0xAA, 0x80, 
	0x02, 0xFF, 0xCC, 0x34, 0xEE, 0xFE, 0x3F, 0xFF, 0xE0, 0xAE, 0x67, 0x42, 0x95, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAC, 0x2F, 0xF8, 0x58, 0x91, 0x94, 0x69, 0x0B, 0xFF, 0xFE, 0x2A, 0x55, 0x78, 
	0x49, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x92, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0x02, 0x00, 0x00, 0x00, 
	0x2F, 0xFF, 0xCC, 0x26, 0x4A, 0xF4, 0xBF, 0xFF, 0xF6, 0xAA, 0x6A, 0x85, 0x95, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAC, 0x2F, 0xFF, 0x94, 0x9A, 0x94, 0x25, 0x2F, 0xFF, 0xFE, 0x2A, 0x5F, 0x60, 
	0x65, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xB0, 0x1F, 0x40, 0x00, 0x02, 0xA0, 0x00, 0x00, 0x0A, 0xA8, 0xAA, 0xAA, 0xAA, 0xA0, 0x00, 0x00, 
	0x3F, 0xFF, 0xCD, 0x02, 0x49, 0xF8, 0xFF, 0xFF, 0xFF, 0x98, 0x61, 0xAD, 0x3F, 0x55, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAA, 0xAC, 0x2F, 0xFF, 0xE5, 0x18, 0x54, 0x96, 0x3F, 0xFF, 0xFD, 0x25, 0xD8, 0x09, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xBA, 0x27, 0x40, 0x00, 0x02, 0xA8, 0x00, 0x02, 0x0A, 0xA8, 0xAA, 0xAA, 0x2A, 0xA0, 0x00, 0x00, 
	0x2F, 0xFF, 0xCF, 0x02, 0x43, 0xFA, 0xFA, 0xAA, 0xA9, 0xA4, 0x61, 0x8A, 0x2A, 0xA9, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xAE, 0xFC, 0x2F, 0x58, 0xA5, 0xA4, 0x54, 0x56, 0x2A, 0xA9, 0xFD, 0x18, 0x02, 0x55, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x4B, 0x4A, 0x00, 0x02, 0xA8, 0x09, 0x0A, 0x0A, 0xAA, 0x00, 0x28, 0x2A, 0xA0, 0xAA, 0xAA, 
	0x1F, 0xFF, 0xCF, 0x22, 0xCB, 0xF8, 0x00, 0x2A, 0xA8, 0x3F, 0xFF, 0xC2, 0x80, 0x00, 0xAA, 0xA0, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0xFF, 0xFE, 0xAA, 0xAA, 0x00, 0x00, 0xBF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAE, 0xAA, 0xAA, 0xAB, 
	0xFF, 0xEA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFA, 0xAB, 0xFE, 0xAA, 0xAA, 0xAA, 0xFE, 0xAA, 0xAA, 0xAF, 
	0xFC, 0x63, 0x8C, 0x10, 0x02, 0xA8, 0x02, 0x84, 0x0A, 0xAA, 0x0B, 0x20, 0x2A, 0x80, 0xAA, 0xAA, 
	0x1F, 0xFF, 0xC6, 0x10, 0xEB, 0xFA, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xAA, 0xAA, 0xA2, 0xAB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8, 0x2F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x58, 0x3C, 0xF0, 0x8A, 0xAA, 0x00, 0xE4, 0x02, 0xA0, 0x03, 0xD0, 0x00, 0x00, 0xAA, 0xAA, 
	0x04, 0x00, 0x00, 0x95, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x01, 0x54, 0xBF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFD, 0x96, 0x55, 0x57, 0xF6, 0x55, 0x7F, 0xFF, 0xFF, 
	0x80, 0x00, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x95, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFE, 0xAA, 0xAA, 0xAB, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xAA, 0xAA, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
