#include "../include.h"

// format: Attribute compressed 8x8/2 colors 4-bit paletted pixel graphics
// compression ratio: 28%
// required memory: 8320 B pixels, 1040 B attributes (9360 B total, unpacked 33280 B)
// image width: 320 pixels
// image height: 208 lines
// image pixels pitch: 40 bytes
// image attribute pitch: 40 bytes
const u16 ImgAttr1_Pal[16] __attribute__ ((aligned(4))) = {
	0xED64, 0xCC62, 0x79E0, 0x65AB, 0x4EFF, 0x44EB, 0x44E9, 0x0BF3, 0x1D9B, 0x95B6, 0x2AE7, 0x644A, 0xEFB7, 0xDCE2, 0x28E1, 0xBA61, 
};

const u8 ImgAttr1_Attr[1040] __attribute__ ((aligned(4))) = {
	0x04, 0x04, 0x04, 0x04, 0xA4, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA4, 0xE4, 0xE4, 0xE2, 0xE2, 0x24, 0x04, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x84, 0xA8, 0xE4, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA4, 0xA5, 0xA4, 0x04, 0x04, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x74, 0xE4, 0xE4, 0xE2, 
	0xE2, 0xE2, 0xE2, 0x02, 0x2B, 0xA4, 0x04, 0x04, 0x74, 0x04, 0x04, 0x54, 0xA5, 0xA5, 0xA4, 0x04, 
	0x04, 0x04, 0x04, 0x64, 0x06, 0xA5, 0xA4, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
	0x04, 0x74, 0xE4, 0x24, 0xE2, 0xE2, 0xE2, 0x29, 0x2C, 0x02, 0xE2, 0xE2, 0xE2, 0x28, 0xA4, 0x54, 
	0xA4, 0x74, 0xA4, 0xA5, 0xA5, 0xA5, 0xA4, 0x04, 0x04, 0x84, 0xA4, 0xE6, 0x06, 0xA6, 0xA4, 0xA4, 
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA4, 0xE4, 0xE2, 0xE2, 0x02, 0x02, 0xE2, 0x29, 0xAC, 
	0xAC, 0xE2, 0xE2, 0xE2, 0xE2, 0x02, 0x25, 0xA5, 0xA5, 0xA4, 0xA4, 0xA5, 0xA5, 0xA5, 0xA5, 0xA4, 
	0x74, 0xA4, 0xA5, 0xA6, 0xA6, 0x06, 0xA5, 0xA4, 0x84, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA4, 0xE2, 
	0x21, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0x2C, 0xBC, 0xBC, 0x20, 0xEF, 0xE2, 0xE2, 0x02, 0xE2, 0x25, 
	0xE5, 0xA5, 0xA5, 0x05, 0xA5, 0xE5, 0xA5, 0xA5, 0x04, 0xA4, 0xA6, 0xA6, 0xE6, 0xA6, 0xA6, 0xA5, 
	0xA4, 0x04, 0x04, 0x04, 0x04, 0xA4, 0xED, 0x20, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0x2C, 
	0xB1, 0xE1, 0xE2, 0xE2, 0xE2, 0xE2, 0x2D, 0x21, 0x25, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 
	0xA4, 0x64, 0x06, 0xA6, 0xA6, 0xA6, 0x06, 0x06, 0xA6, 0xA4, 0x04, 0x04, 0x74, 0xE9, 0xF0, 0xD0, 
	0xE0, 0xE2, 0xE2, 0x02, 0xE2, 0xE2, 0xE2, 0x29, 0xE1, 0x21, 0xE2, 0xE2, 0x02, 0xE2, 0xE2, 0xE2, 
	0x21, 0xE5, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xA5, 0xA6, 0x06, 0xA6, 0xA6, 0xA6, 0xE6, 0xA5, 
	0xA5, 0xA4, 0x04, 0x04, 0xE4, 0x20, 0x00, 0x00, 0x10, 0xED, 0xE2, 0x02, 0x02, 0xE2, 0xE2, 0xE2, 
	0xE2, 0xE2, 0xE2, 0xE2, 0x02, 0x02, 0xE2, 0x21, 0xE2, 0x2B, 0xA5, 0xA5, 0xA5, 0x05, 0xA5, 0xA5, 
	0x54, 0xA6, 0xA6, 0xA6, 0xA6, 0x06, 0xA6, 0xA6, 0xA6, 0xA8, 0xA4, 0xA4, 0x2D, 0x00, 0x00, 0x20, 
	0x20, 0x10, 0xED, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0x21, 0xE2, 0x02, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 
	0x02, 0xE2, 0xE5, 0xA5, 0x05, 0x05, 0x05, 0x05, 0xA5, 0x06, 0xA6, 0x06, 0x06, 0x06, 0x06, 0x06, 
	0xA6, 0xA6, 0xEA, 0xE3, 0x10, 0x20, 0xF0, 0xEF, 0x2F, 0x20, 0xF0, 0xED, 0xE2, 0x02, 0xE2, 0xE2, 
	0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0x02, 0x02, 0xE2, 0xE2, 0xE2, 0x2B, 0x05, 0x05, 0x05, 0xA5, 0xA5, 
	0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0x06, 0xA6, 0xA6, 0xA6, 0xA6, 0xEB, 0x20, 0x00, 0x20, 0xEF, 0x0F, 
	0xF0, 0xB0, 0x00, 0x20, 0xE2, 0x02, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0x2D, 0xE2, 0xE2, 0x02, 0xE2, 
	0x21, 0x21, 0xA1, 0x05, 0xA5, 0x05, 0x05, 0x05, 0x06, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0x06, 0x06, 
	0x06, 0xE6, 0x2D, 0x00, 0x00, 0x00, 0x20, 0x20, 0xB0, 0x00, 0x00, 0x00, 0x20, 0xE2, 0xE2, 0xE2, 
	0xE2, 0x02, 0xE2, 0x21, 0xE2, 0xE1, 0x21, 0x21, 0xE1, 0x21, 0xA1, 0xE5, 0xE3, 0xA3, 0xA3, 0xA3, 
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xA6, 0xA6, 0x21, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xD0, 0x2D, 0x2F, 0xEF, 0xE2, 0xE2, 0xE2, 0x21, 0x21, 0xE1, 0xE5, 0xEA, 
	0xE7, 0x21, 0x21, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0xA6, 0xA6, 0xA6, 0xA6, 0x06, 0xA6, 0x06, 
	0x2B, 0x20, 0x10, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0xE0, 0xE0, 0xE2, 0xE2, 
	0x21, 0x2D, 0xE1, 0x21, 0xF1, 0xE1, 0xE7, 0xEA, 0xEA, 0x21, 0xA1, 0x53, 0x03, 0x03, 0x03, 0x03, 
	0xA6, 0xA5, 0xA6, 0xA6, 0xA9, 0xA5, 0xE6, 0xA6, 0x2D, 0xED, 0x28, 0x28, 0x28, 0x20, 0x00, 0x00, 
	0x00, 0x00, 0xEB, 0xA8, 0xA8, 0x23, 0x21, 0xE1, 0xE1, 0xE7, 0x27, 0xEA, 0xF1, 0xE1, 0xEA, 0xEA, 
	0xE7, 0x21, 0x21, 0x53, 0x03, 0x03, 0x03, 0x03, 0x03, 0xBC, 0xAC, 0xBC, 0x0C, 0x9C, 0xBC, 0xBC, 
	0x1C, 0x23, 0x28, 0x28, 0x28, 0x20, 0x00, 0xF0, 0xF0, 0x00, 0x2B, 0x28, 0x28, 0xE2, 0x21, 0x01, 
	0xE5, 0xE7, 0xEA, 0xEA, 0x21, 0xE1, 0xEA, 0x2B, 0x21, 0xE1, 0x21, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x63, 0xBC, 0xAC, 0xEC, 0xE9, 0xEC, 0xBC, 0x0C, 0x1C, 0xA0, 0xA8, 0x27, 0xA8, 0x2D, 0x2D, 0x2F, 
	0x2F, 0x20, 0xA3, 0xA8, 0xE8, 0x27, 0x21, 0x01, 0x2B, 0xE7, 0x27, 0xEA, 0x21, 0x01, 0x21, 0x01, 
	0x01, 0x01, 0xA1, 0x53, 0x03, 0x03, 0xB3, 0xB3, 0xA3, 0xBC, 0xE9, 0xE9, 0x29, 0xE9, 0xE9, 0xAC, 
	0xBC, 0x20, 0x21, 0x2D, 0x2D, 0x20, 0x2F, 0xEF, 0xEF, 0x2F, 0x20, 0x20, 0x20, 0x20, 0x2D, 0x01, 
	0xEB, 0xEB, 0x21, 0xE1, 0x01, 0xE1, 0xF1, 0x21, 0x01, 0x21, 0x21, 0x63, 0xA3, 0xA3, 0x03, 0xB3, 
	0x5C, 0xEC, 0xE2, 0xEA, 0xE2, 0xEA, 0xE2, 0xE5, 0xBC, 0x00, 0x00, 0x00, 0x00, 0x20, 0xF1, 0x0F, 
	0x2F, 0x2F, 0xF0, 0x00, 0x00, 0x00, 0x2D, 0x01, 0x21, 0x1D, 0x01, 0x01, 0x01, 0x21, 0x21, 0x2B, 
	0xA1, 0xA1, 0xA3, 0xA3, 0xA3, 0xB3, 0xB3, 0xB3, 0xBC, 0xEC, 0xE2, 0x0E, 0xE2, 0x0E, 0xE2, 0xEB, 
	0xBC, 0xF0, 0x00, 0x00, 0x00, 0xF0, 0x0F, 0x0F, 0xEF, 0x2F, 0x20, 0x00, 0x00, 0x00, 0x2D, 0x01, 
	0x01, 0x01, 0x01, 0x21, 0x21, 0x23, 0xA3, 0xA3, 0x03, 0x03, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 
	0xBC, 0xE9, 0xE2, 0xEA, 0xE2, 0xEA, 0xE2, 0xEA, 0x9C, 0xF0, 0xA0, 0xAD, 0x10, 0xE0, 0x2F, 0x0F, 
	0x0F, 0x2F, 0x20, 0xB0, 0x2D, 0x10, 0x2D, 0x01, 0xA1, 0x21, 0x21, 0x23, 0xA3, 0x53, 0x03, 0xB3, 
	0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xAC, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 0xE9, 
	0xAC, 0x20, 0xA3, 0xF0, 0x20, 0x2D, 0x2F, 0x0F, 0x0F, 0xF1, 0xF0, 0xA3, 0x23, 0xF0, 0x10, 0x21, 
	0xA3, 0xA3, 0x63, 0x03, 0x03, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0x03, 0x03, 
	0xA3, 0xE3, 0xE3, 0xE3, 0x23, 0xE3, 0xE3, 0xE3, 0x3C, 0xA3, 0xA3, 0xA3, 0x63, 0xA3, 0xA3, 0xA3, 
	0xA3, 0xA3, 0xA3, 0x53, 0xA3, 0xA3, 0xA3, 0x53, 0x03, 0x03, 0x03, 0x03, 0xB3, 0xB3, 0xB3, 0xB3, 
	0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
};

const u8 ImgAttr1[8320] __attribute__ ((aligned(4))) = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x81, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE7, 0x6F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xA7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC0, 0xA1, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB3, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xB9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE0, 0x00, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3C, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 
	0x00, 0x52, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x9C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x41, 0xFB, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8E, 
	0xFF, 0xFD, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xC7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x30, 0xFF, 0xFC, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7E, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 
	0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xE0, 0x7F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFE, 0x7E, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFF, 0x7F, 0xFF, 0x01, 0x3F, 0xFF, 0xFF, 
	0x3F, 0xFF, 0xFF, 0xF8, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x02, 0x7F, 
	0xFF, 0xFF, 0x3F, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xF0, 0xFF, 0xF0, 0x03, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xBF, 0xFF, 0xFF, 0xBF, 0xFF, 0x01, 0x07, 0xFF, 0xFF, 
	0x3F, 0xFF, 0xFF, 0xE0, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x07, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x9F, 
	0xFF, 0xFF, 0xDF, 0xFF, 0x04, 0x03, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xC0, 0xFF, 0xFC, 0x0F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xCF, 0xFF, 0x00, 0x00, 0xFF, 0xCF, 0xFF, 0xF8, 0x03, 0xFF, 0xFE, 
	0x1F, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0x83, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x04, 0x1F, 0xFF, 0x48, 
	0x00, 0xFF, 0xEF, 0xFF, 0xE3, 0x01, 0xFF, 0xFE, 0x4F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0x3F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xE4, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF0, 0xD0, 0x7F, 0xFF, 0x00, 0x00, 0xFF, 0xF7, 0xFF, 0x0F, 0x00, 0x7F, 0xFC, 
	0x4F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xC1, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xBB, 0xFF, 0xFF, 0x00, 
	0x00, 0xFF, 0xF3, 0xF8, 0x7F, 0x00, 0x3F, 0xFC, 0xA7, 0xFF, 0xF8, 0xF7, 0xFF, 0xFF, 0x80, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xC8, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFC, 0x00, 0x7D, 0xFF, 0xFF, 0x10, 0x00, 0xFF, 0xFB, 0xE3, 0xFF, 0x00, 0x3F, 0xF8, 
	0x13, 0xFF, 0xE3, 0x8F, 0xFD, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0xFF, 0xE0, 0x7F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0xFE, 0xFF, 0xFF, 0x43, 
	0xC0, 0xFF, 0xF8, 0x0F, 0xFF, 0x00, 0x1F, 0xF8, 0x11, 0xFF, 0x00, 0x0F, 0xFF, 0xFF, 0xE3, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x80, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x00, 0x40, 0xFE, 0x7F, 0xFF, 0x1F, 0xE0, 0xFF, 0xF9, 0x7F, 0xFF, 0x00, 0x0F, 0xF0, 
	0x0C, 0x7F, 0x00, 0xDF, 0xFB, 0x3F, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0xFF, 0xF0, 0x1F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0xFF, 0x7F, 0xFE, 0x7F, 
	0xE0, 0xFF, 0xE7, 0xBF, 0xFF, 0x00, 0x07, 0xE0, 0x00, 0x1F, 0xFF, 0x9F, 0xF7, 0xC0, 0x07, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0x61, 0xFF, 0xFF, 0xBF, 0x00, 0xFF, 0xF0, 0xFF, 0x8F, 0xDF, 0xFF, 0xFF, 0x07, 0xDF, 
	0xFC, 0x1F, 0xFF, 0x3F, 0xE7, 0xE0, 0xE3, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x17, 0xFF, 0xFF, 0x9F, 0x01, 0xFE, 
	0xF8, 0xFE, 0x3F, 0xEF, 0xFF, 0xFF, 0x03, 0x17, 0xFC, 0xFF, 0xFE, 0x7F, 0x0F, 0xFF, 0xE1, 0xFF, 
	0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFC, 0x39, 0xDF, 0xFF, 0xFF, 0xDF, 0x00, 0xF8, 0x38, 0xF8, 0xFF, 0xE7, 0xFF, 0xFF, 0x0B, 0x07, 
	0xBE, 0x3F, 0xF8, 0xF8, 0x3F, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFC, 0x03, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xF3, 0xEF, 0xFF, 0xFF, 0xEF, 0x03, 0x78, 
	0x1C, 0x83, 0xFF, 0xF3, 0xFF, 0xFF, 0x01, 0xEF, 0x00, 0x1F, 0xF0, 0x00, 0xFF, 0xFF, 0xF8, 0x3F, 
	0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x80, 0xC7, 0xE7, 0xFF, 0xFF, 0xE7, 0x03, 0x78, 0x1E, 0x7F, 0xFF, 0xF9, 0xFF, 0xFF, 0x00, 0xC8, 
	0x60, 0x0F, 0xE0, 0x0F, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x1F, 0x77, 0xFF, 0xFF, 0xF7, 0x03, 0x38, 
	0x0F, 0x7F, 0xFF, 0xFD, 0xFF, 0xFF, 0x02, 0x81, 0xFF, 0x07, 0xE4, 0xFF, 0xFF, 0xFF, 0xFE, 0x03, 
	0xFF, 0xFF, 0x90, 0xFF, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 
	0x00, 0xFE, 0xFB, 0xFF, 0xFF, 0xFB, 0x03, 0x38, 0x0F, 0xBF, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0x1F, 
	0xFF, 0x03, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFF, 0xFE, 0x20, 0xFF, 0xFF, 0xFF, 0x80, 0x1F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0xFD, 0xD9, 0xFF, 0xFF, 0xF9, 0x17, 0xBC, 
	0x0F, 0xBF, 0xFC, 0x3F, 0x7F, 0xFF, 0x01, 0x3F, 0xFF, 0x01, 0x80, 0xFF, 0xFF, 0xFF, 0xFE, 0x03, 
	0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9E, 
	0x08, 0xFD, 0xDD, 0xFF, 0xFF, 0xFD, 0x07, 0x9E, 0x0F, 0xC0, 0x01, 0xDF, 0x3F, 0xFF, 0xFF, 0x3F, 
	0xFF, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xF9, 0xE7, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x20, 0x00, 0xFD, 0xFE, 0xFF, 0xFF, 0xFE, 0x0F, 0x9E, 
	0x1F, 0xC0, 0x03, 0xEF, 0xBF, 0xFF, 0xFF, 0x3F, 0xFF, 0xC4, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 
	0xFF, 0xE2, 0x8F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xA7, 
	0x80, 0xFD, 0xBE, 0x7F, 0xFF, 0xFE, 0x1F, 0xCF, 0xFF, 0xC0, 0x07, 0xEF, 0xDF, 0xFF, 0xFF, 0x1F, 
	0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0xFE, 0x00, 0x0F, 0xEF, 0xFF, 0xFF, 0xF0, 0x00, 
	0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xB3, 0x3C, 0xFC, 0x7F, 0x7F, 0xFF, 0xFE, 0x3F, 0xCF, 
	0xFF, 0xC0, 0x7F, 0xEF, 0xCF, 0xFF, 0xFF, 0x0F, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 
	0xFE, 0x00, 0x9F, 0x8F, 0xFF, 0xFF, 0x7C, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x39, 
	0x1F, 0x7E, 0xFF, 0xBF, 0xFF, 0xFC, 0x1F, 0xE7, 0xFE, 0x20, 0x7F, 0xCF, 0xE7, 0xFF, 0xFE, 0x07, 
	0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0x3E, 0x0F, 0xFB, 0xFF, 0x8C, 0x0F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1D, 0x07, 0xB3, 0xFF, 0x9F, 0xFF, 0xF3, 0x0F, 0xE7, 
	0xF8, 0xE0, 0x7F, 0xDF, 0xF7, 0xFF, 0xF9, 0x03, 0xFF, 0x8F, 0xF7, 0xFF, 0xFF, 0xFE, 0x02, 0xE0, 
	0xFF, 0xFE, 0x60, 0x4F, 0xFB, 0xFF, 0xC0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x4C, 
	0x00, 0x6D, 0xFF, 0xDF, 0xFF, 0x8F, 0x07, 0xF3, 0xC0, 0xF0, 0x7F, 0xBF, 0xF3, 0xFF, 0xE3, 0x01, 
	0xFE, 0x3F, 0x8F, 0xFF, 0xFF, 0xFF, 0x99, 0xF0, 0xFF, 0xF8, 0x03, 0x9F, 0xF3, 0xFF, 0xE0, 0x07, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x6E, 0x00, 0xDE, 0xEC, 0xCF, 0xFC, 0x3F, 0x03, 0xF0, 
	0x00, 0xF0, 0x00, 0x7F, 0xFB, 0xFF, 0x8F, 0x01, 0xF0, 0xC0, 0x0F, 0xFF, 0xFD, 0xFF, 0xE1, 0xF8, 
	0xFF, 0xF0, 0x3F, 0x9F, 0xE1, 0xFF, 0xF9, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x20, 
	0x7F, 0xED, 0xDE, 0x6F, 0xF1, 0xFF, 0xF9, 0xFC, 0x3F, 0xF0, 0xC0, 0x7F, 0xFB, 0xFE, 0x00, 0x00, 
	0xF0, 0x00, 0x9F, 0xFF, 0xFE, 0x00, 0x07, 0xFC, 0xFF, 0xFF, 0x7F, 0x3F, 0xC0, 0x1F, 0x03, 0x80, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x70, 0x3F, 0xF3, 0xCF, 0xA7, 0x8F, 0xFF, 0xFC, 0xFD, 
	0xFF, 0xF8, 0xFF, 0xFF, 0xF9, 0xF0, 0x00, 0x60, 0x7F, 0xFF, 0x3F, 0x7F, 0xFF, 0x00, 0x3F, 0xFE, 
	0xFF, 0xFE, 0x7E, 0x7E, 0x1E, 0x00, 0x0F, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xFE, 
	0x9F, 0xFF, 0xE7, 0x60, 0x7F, 0xFF, 0xFE, 0x7C, 0xFF, 0xF8, 0xFF, 0xFF, 0xF8, 0x07, 0x00, 0x60, 
	0x7F, 0xFE, 0x7C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xF8, 0xF0, 0x3F, 0xE1, 0xFF, 0xF0, 
	0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFC, 0xDF, 0xC7, 0xF8, 0xCF, 0x7F, 0xFF, 0xFF, 0x3C, 
	0xFF, 0xFC, 0xFF, 0xFF, 0xF7, 0xDF, 0x00, 0x60, 0x3F, 0xF9, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xF0, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFE, 
	0x4F, 0xDB, 0xFF, 0x3F, 0xBF, 0xFF, 0xFF, 0x3E, 0xFF, 0xFC, 0xBF, 0xFF, 0xCF, 0xCF, 0x00, 0x60, 
	0x1F, 0xE0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFC, 
	0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xFE, 0x67, 0xBB, 0xF8, 0xFF, 0x9F, 0xFF, 0x1F, 0x1E, 
	0xFF, 0xFE, 0xCF, 0xFF, 0x1F, 0xEE, 0x70, 0x20, 0x1F, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFE, 
	0x77, 0xBB, 0xE7, 0xFF, 0xDF, 0xFE, 0x6F, 0x0E, 0xFF, 0xFE, 0x77, 0xF8, 0x7F, 0xF7, 0x78, 0x00, 
	0x0F, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFE, 0xBB, 0xB7, 0x1F, 0xFF, 0xEF, 0xF0, 0xE7, 0x06, 
	0x7F, 0xFF, 0x3F, 0xC7, 0xFF, 0xF3, 0x38, 0x60, 0x07, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFE, 
	0x80, 0xCC, 0x7F, 0xFF, 0xE7, 0xE5, 0xF7, 0x07, 0x7F, 0xFF, 0xB8, 0x1F, 0xFF, 0xFB, 0xC3, 0x1F, 
	0x07, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xC0, 0xF1, 0xFF, 0xFF, 0xF7, 0xDF, 0xE7, 0x03, 
	0x7F, 0xFF, 0x80, 0x7F, 0xFF, 0xFD, 0xFE, 0x6F, 0x01, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 
	0xF0, 0x07, 0xFF, 0xFF, 0xFB, 0xDF, 0xEF, 0x03, 0x7F, 0xFC, 0x07, 0x9F, 0xFF, 0xFC, 0xFE, 0xFF, 
	0x09, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 
	0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xC1, 0x7F, 0xFF, 0xFC, 0xDF, 0xFF, 0xFF, 0xFB, 0xCF, 0xCF, 0x03, 
	0x7F, 0xC0, 0x67, 0xDF, 0xFF, 0xFE, 0xFE, 0xEF, 0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x80, 0xFF, 0xFB, 0xFF, 0x7F, 0xFF, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 
	0xFC, 0xEF, 0xFF, 0xFF, 0xFD, 0xE0, 0x1F, 0x01, 0x7E, 0x00, 0xF3, 0xDF, 0xFF, 0xFF, 0x7F, 0x5E, 
	0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0xFF, 0xF7, 0xFF, 0x7F, 0xFF, 0xFF, 
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFC, 0xE7, 0xFF, 0xFF, 0xFC, 0xF8, 0x3F, 0x01, 
	0xF0, 0x00, 0xF9, 0xDF, 0xFF, 0xFF, 0x3F, 0xBD, 0xC2, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x40, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 
	0xFE, 0x73, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x00, 0xC0, 0x00, 0xF9, 0xBF, 0xFF, 0xFF, 0xBF, 0x9C, 
	0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x80, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 
	0xFF, 0x0F, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xFE, 0x7B, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0x02, 
	0x00, 0x00, 0xFC, 0xFF, 0xFF, 0xFF, 0x9F, 0x6E, 0x78, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF9, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFE, 0x7F, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 
	0xFE, 0x00, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC, 0x3E, 0x1F, 0xFE, 0xFF, 0xFF, 0xFF, 0xDE, 0x60, 
	0xB7, 0x9F, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x1E, 
	0x80, 0x7F, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFE, 0x80, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xE1, 
	0x9F, 0xF0, 0x03, 0x7F, 0xFF, 0xFF, 0xEE, 0x60, 0xCF, 0x9F, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE7, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0x9F, 0xFF, 0x0F, 0xDF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xE6, 0x60, 
	0xFF, 0x03, 0xE0, 0xFF, 0xFF, 0xFF, 0x3F, 0xFC, 0xCF, 0xF7, 0xFF, 0xFF, 0xC0, 0x3F, 0xFF, 0xC0, 
	0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xDF, 0xFC, 0x7F, 
	0xEF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xF6, 0x40, 0xFC, 0x08, 0x00, 0xFF, 0xCF, 0xFF, 0x00, 0x00, 
	0x9F, 0xE7, 0xFF, 0xFF, 0x80, 0x1F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xBF, 0xFF, 0xFF, 0xCF, 0xE3, 0xFF, 0xE7, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xF3, 0x00, 
	0xF1, 0x04, 0x1D, 0xFF, 0x9F, 0xFF, 0xC0, 0x07, 0x7F, 0x8F, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFC, 
	0x00, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x9F, 0xFF, 0xFF, 0xE7, 0x1F, 0xDF, 
	0xF7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFB, 0x00, 0xC7, 0x13, 0xF9, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x1F, 0xFF, 0xF8, 0x0F, 0x00, 0x7F, 0xE0, 0xC0, 0x7F, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xCF, 0xFF, 0xFF, 0xE0, 0x7F, 0xA7, 0x3B, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFD, 0xC0, 
	0x1F, 0x01, 0xF3, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0xBF, 0xFF, 0xC0, 0x1F, 0xE0, 0x00, 0x03, 
	0xE0, 0x3F, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x6F, 0xFF, 0xFF, 0x9D, 0xFF, 0x36, 
	0xD9, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFC, 0x00, 0xFF, 0x01, 0xE0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x07, 0x3F, 0xFF, 0x00, 0x7F, 0xFF, 0x00, 0x3F, 0xF0, 0x1F, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x00, 0xFF, 0xFE, 0x3E, 0xFF, 0xBB, 0xC0, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xF3, 0x07, 
	0xFF, 0xFE, 0xE0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xF8, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x0F, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0xFF, 0xF8, 0xFF, 0x7F, 0xBD, 
	0xC0, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE7, 0xBF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0x9F, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE0, 0xFF, 0xE7, 0xFF, 0x3F, 0xC6, 0x80, 0x7F, 0xFF, 0xFD, 0xFF, 0xFF, 0x9F, 0xDF, 
	0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x01, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0x1F, 0xFF, 0xBC, 0x7F, 
	0x00, 0x7F, 0xFF, 0xFC, 0xFF, 0xFC, 0x3F, 0xCF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF0, 0xFC, 0x7F, 0xFF, 0x9B, 0xBF, 0x01, 0x3F, 0xFF, 0xFE, 0xFF, 0xF1, 0xFF, 0xEF, 
	0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x80, 0x3F, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x21, 0xFF, 0xFF, 0xD7, 0xB9, 
	0x00, 0xBF, 0xFF, 0xFE, 0x7F, 0x87, 0xFF, 0xF7, 0xFF, 0xFF, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF9, 0x9F, 0xFF, 0xFF, 0xCB, 0xB7, 0x04, 0xDF, 0xFF, 0xFE, 0x30, 0x7F, 0xFF, 0xF7, 
	0xFF, 0xFF, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF0, 0x07, 0xF0, 0x3F, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xFC, 0xDF, 0xFF, 0xFF, 0xEC, 0x7F, 
	0x0F, 0x5F, 0xFF, 0xFC, 0x83, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0x07, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xE7, 0xF0, 0x1F, 0xFF, 0xFF, 0xFC, 
	0x47, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xE7, 0xF2, 0xF3, 0x6F, 0xFF, 0xF9, 0xCF, 0xFF, 0xFF, 0xF9, 
	0xFF, 0xFF, 0x13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0xF9, 0xE0, 0x1F, 0xFF, 0xC0, 0xF3, 0xF9, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xF7, 0xFD, 
	0xFC, 0xE7, 0xFF, 0xC7, 0xEF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 
	0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x3F, 0xFE, 0x00, 0x27, 
	0xFC, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xF3, 0xE7, 0xDF, 0xF7, 0xFF, 0x1F, 0xF7, 0xFF, 0xFF, 0xFE, 
	0xFF, 0xFF, 0x09, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0x01, 0x3F, 0xFC, 0x00, 0xCF, 0xFE, 0x7F, 0xFF, 0xC0, 0xFF, 0xFF, 0xFB, 0xCB, 
	0x2F, 0xF3, 0xF8, 0x7E, 0x33, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x09, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 
	0x3F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x03, 0x7F, 0xF8, 0x00, 0xFF, 
	0xFE, 0x7F, 0xFF, 0xC0, 0xFF, 0xFF, 0xFD, 0xDB, 0x77, 0xFB, 0xC3, 0xFE, 0xDB, 0xFF, 0xFF, 0xFF, 
	0x7F, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC3, 0x0F, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x7F, 0xFF, 0xE4, 0xFF, 0xFF, 0xFD, 0xDB, 
	0x3B, 0xF8, 0x0F, 0xFF, 0xDD, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x0E, 0x1F, 0xFF, 0xF0, 0x00, 0xFF, 
	0xFF, 0x7F, 0xFF, 0xE0, 0xFF, 0xFF, 0xFE, 0xEB, 0x9B, 0xE6, 0x3E, 0x7D, 0xDC, 0xFF, 0xFF, 0xFF, 
	0x9F, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x00, 0xFE, 0x0F, 0xFF, 0xF0, 0x00, 0xFF, 0xFF, 0x7F, 0xFF, 0xF2, 0x7F, 0xFF, 0xFE, 0x77, 
	0xC7, 0x8F, 0xBF, 0x9D, 0xDE, 0xFF, 0xFF, 0xFF, 0xDF, 0xFC, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xF8, 0x07, 0xFF, 0xF0, 0xFF, 0xFF, 
	0x00, 0x7F, 0xFF, 0xE0, 0x7F, 0xFF, 0xFF, 0x7F, 0xFC, 0x3F, 0xDB, 0xC0, 0xBF, 0x7F, 0xFF, 0xFF, 
	0x04, 0x00, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 
	0xFF, 0xE1, 0xF8, 0x07, 0xFF, 0xF8, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xBF, 
	0xF1, 0xFF, 0xCB, 0xE0, 0x7F, 0x3F, 0xFF, 0xFF, 0x00, 0x03, 0xF2, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xF8, 0xF0, 0x0F, 0xFF, 0xF8, 0xFF, 0xFF, 
	0x01, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0x9F, 0xC7, 0xFF, 0xEC, 0xC0, 0xFF, 0xBF, 0xFF, 0xFF, 
	0x48, 0x1F, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 
	0xFF, 0xC3, 0xE4, 0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 0xFF, 0xCF, 
	0x1F, 0xFF, 0xF7, 0x00, 0xFF, 0xDF, 0xFF, 0xFF, 0x8F, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xEF, 0xFF, 0xFE, 0x07, 0xF8, 0x0F, 0xC0, 0x3F, 0xFF, 0xFE, 0x7F, 0xFF, 
	0x03, 0xFF, 0xFF, 0xFF, 0x2F, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFB, 0x00, 0x7F, 0xCF, 0xFF, 0xFF, 
	0x1F, 0xFF, 0xF8, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0x00, 
	0x00, 0x7F, 0xC3, 0x7F, 0xFF, 0xFF, 0xBF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xA7, 0xFF, 0xFF, 0xDE, 
	0xFF, 0xFF, 0xF9, 0x01, 0xBE, 0xEF, 0xFF, 0xFC, 0x3F, 0xFF, 0xF8, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x00, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0x0F, 0xFF, 0xFF, 0xFF, 0x97, 0xFF, 0xFF, 0x9F, 0x7F, 0xFF, 0xFD, 0x01, 0xBD, 0x37, 0xFF, 0xE1, 
	0xFF, 0xFF, 0xF8, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0x00, 0x0D, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xDB, 0xFF, 0xFE, 0x7F, 
	0x3F, 0xFF, 0xFE, 0x00, 0x7B, 0xD3, 0xFF, 0x8F, 0xFF, 0xFF, 0xF9, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFB, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 
	0x3F, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xF8, 0xFF, 0xBF, 0xFF, 0xFE, 0x01, 0xFB, 0xC0, 0x00, 0x1F, 
	0xFF, 0xFF, 0xF9, 0xFF, 0xF8, 0x19, 0xFF, 0xFE, 0xFF, 0xF7, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xC3, 0xFF, 
	0xDF, 0xFF, 0xFF, 0x00, 0xFD, 0xC8, 0x00, 0x7F, 0xFF, 0x9F, 0xF9, 0xFF, 0xF0, 0x00, 0x00, 0x00, 
	0xFF, 0xC0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7F, 0x1F, 0xFF, 0xCF, 0xFF, 0xFF, 0x02, 0x7E, 0x00, 0x03, 0xFF, 
	0xFC, 0x0F, 0xF8, 0xFF, 0x83, 0xE0, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 
	0xEF, 0xFF, 0xFF, 0x17, 0x7F, 0x12, 0x0F, 0xFF, 0xE0, 0x07, 0xFC, 0x00, 0x0F, 0xFF, 0x80, 0x0F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x93, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0x07, 0xFF, 0x43, 0xFF, 0xFF, 
	0x80, 0x07, 0xFC, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 
	0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xDF, 0xFF, 0xFF, 
	0xF7, 0xFF, 0xFF, 0x07, 0x7F, 0x07, 0xFF, 0xFC, 0x00, 0x07, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x4F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x02, 0x7E, 0x1F, 0xFF, 0xE0, 
	0x00, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x2F, 0xFF, 0xE3, 
	0xFB, 0xFF, 0xFF, 0x00, 0xF8, 0x7F, 0xFF, 0x00, 0x01, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x80, 0x00, 0x00, 0xF9, 0xFF, 0xFF, 0x07, 0x00, 0xFF, 0xFC, 0x3E, 
	0x7F, 0x87, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9F, 
	0xFF, 0x80, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x3C, 
	0xFD, 0xFF, 0xFF, 0x00, 0x07, 0xFF, 0xE0, 0xFD, 0xFF, 0x87, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0x80, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x7E, 0xFC, 0xFF, 0xFF, 0x20, 0x3F, 0xFF, 0x80, 0x1D, 
	0xFF, 0x87, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 
	0xFF, 0x01, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x06, 0x7E, 
	0xFE, 0xFF, 0xFF, 0x87, 0xFF, 0xFE, 0x00, 0xED, 0xFF, 0x87, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFE, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x0F, 0xFC, 0xFE, 0xFF, 0xFF, 0x0F, 0xFF, 0xFC, 0x07, 0xED, 
	0xFF, 0x87, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 
	0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xFC, 
	0xFF, 0x7F, 0xFC, 0x3F, 0xFF, 0xFC, 0x1F, 0xED, 0xFF, 0x83, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x4F, 0xF8, 0xFF, 0x7F, 0xE3, 0xFF, 0xFF, 0xFC, 0x3F, 0xEF, 
	0xFF, 0x03, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x88, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x07, 0xF8, 
	0xFF, 0xBF, 0x8F, 0xFF, 0xFF, 0xFC, 0x7F, 0xEF, 0xFF, 0x03, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x37, 0xFB, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFC, 0x7F, 0xEF, 
	0xFE, 0x03, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xEF, 0xFF, 
	0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3E, 0x07, 
	0x01, 0x00, 0xFF, 0xF1, 0xFF, 0xFC, 0x7F, 0xEF, 0xF9, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xE0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0x00, 0x3F, 0xFF, 0x80, 0xFF, 0xFC, 0x7F, 0xED, 
	0xE7, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 
	0xE0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5F, 0xFF, 
	0x08, 0x7F, 0xFC, 0x00, 0xFF, 0xFC, 0x3F, 0xEE, 0x1F, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAF, 0xFF, 0x01, 0xFF, 0xE0, 0x00, 0x7F, 0xFC, 0x7F, 0xFF, 
	0xF0, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 
	0x80, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA7, 0xFF, 
	0x03, 0xFF, 0x00, 0x00, 0x7F, 0xFC, 0x7F, 0xDF, 0xCF, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC7, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xD7, 0xF8, 0x1F, 0xF8, 0x00, 0x00, 0x7F, 0xFC, 0x7F, 0x3F, 
	0x3F, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 
	0x07, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xC1, 0x83, 
	0xFF, 0xC0, 0x00, 0xF0, 0x7F, 0xFC, 0x30, 0xFE, 0x7F, 0x07, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x1F, 0xFF, 0x62, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC8, 0x00, 0x00, 0x01, 0xD0, 0x0F, 0xFF, 0x00, 0x07, 0xF6, 0x7F, 0xFC, 0xC7, 0xFE, 
	0xFF, 0x07, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xC4, 0xFF, 0xFF, 0xFE, 
	0x07, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xD3, 0x00, 0x00, 0x01, 0xDF, 0xFF, 
	0xF8, 0x00, 0x1F, 0xF6, 0x7F, 0xFC, 0xFC, 0x1E, 0xFF, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xE0, 0x3F, 0xFF, 0x83, 0xFF, 0xFF, 0xFC, 0x07, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x87, 0xF8, 0x07, 0xC1, 0xDF, 0xFF, 0xE0, 0x06, 0x1F, 0xF6, 0x7F, 0xFC, 0xF3, 0xEE, 
	0xFF, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0x00, 0xFF, 0xFF, 0xF9, 
	0x07, 0xC0, 0x00, 0x07, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xF8, 0x0F, 0xC1, 0xDF, 0xFF, 
	0x80, 0x3E, 0x1F, 0xF6, 0x7F, 0xFC, 0xCF, 0xEE, 0xFF, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xB8, 0x05, 0xFF, 0xFC, 0x00, 0x3F, 0xFF, 0xF8, 0x0F, 0x80, 0xFC, 0x0F, 0xF8, 0x1F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x87, 0xF8, 0x1F, 0xC1, 0xDF, 0xFF, 0x80, 0xFF, 0x1F, 0xF6, 0x7F, 0xFC, 0xDF, 0xEE, 
	0xFF, 0x07, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x39, 0xFF, 0xF0, 0x30, 0x0F, 0xFF, 0xE4, 
	0x6F, 0x81, 0xFC, 0x0F, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xF8, 0x1F, 0xC1, 0xDF, 0xFF, 
	0x83, 0xFF, 0x1F, 0xF6, 0x7F, 0xFC, 0xDF, 0xEE, 0xFF, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x07, 0xE7, 0xFF, 0xE0, 0xFC, 0x00, 0xFF, 0xF0, 0x07, 0x83, 0xFE, 0x0F, 0xF8, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x87, 0xF8, 0x1F, 0xC1, 0xDF, 0xFF, 0x87, 0xFF, 0x1F, 0xF6, 0x7F, 0xFC, 0xDF, 0xEE, 
	0x7C, 0x07, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8F, 0xFE, 0x07, 0xFF, 0xFC, 0x00, 0x03, 
	0x07, 0x83, 0xFE, 0x0F, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xF8, 0x1F, 0xC1, 0xDF, 0xFF, 
	0x87, 0xFF, 0x1F, 0xF6, 0x7F, 0xFC, 0xDF, 0xEF, 0x60, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x00, 0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x03, 0xF0, 0xC3, 0xFE, 0x0F, 0xFC, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0x87, 0xFC, 0x3F, 0xDD, 0xDF, 0xFF, 0x87, 0xFE, 0xFF, 0xEE, 0x7F, 0xFC, 0xDF, 0xE0, 
	0x00, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0xC3, 0xFE, 0x0F, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0xFC, 0x3F, 0xDD, 0xDF, 0xFF, 
	0x87, 0xFE, 0xDF, 0x9E, 0x7F, 0xFC, 0xDF, 0xE0, 0x00, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xC3, 0xFE, 0x0F, 0xFC, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC3, 0xC0, 0x00, 0x3D, 0xDF, 0xFF, 0x87, 0xFE, 0xDE, 0x7E, 0x7F, 0xFC, 0xDF, 0xC0, 
	0x00, 0x7F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0xC3, 0xFE, 0x07, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0xFD, 0xDF, 0xFF, 
	0x87, 0xFE, 0xC3, 0xCE, 0x7F, 0xFC, 0xDF, 0x00, 0x03, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xC1, 0xF8, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC2, 0x00, 0x00, 0xFD, 0xCF, 0xFF, 0x87, 0xFC, 0xFE, 0x36, 0x7F, 0xFC, 0xC8, 0x00, 
	0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF0, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x3D, 0xCF, 0xFF, 
	0x87, 0xF8, 0xF9, 0xF6, 0x7F, 0xFC, 0xF7, 0x01, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xC1, 0xFC, 0x1F, 0xDD, 0xCF, 0xFF, 0x87, 0xE0, 0xE7, 0xF6, 0x7F, 0xFE, 0xFC, 0x07, 
	0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF8, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x07, 0xFF, 0xC3, 0xFC, 0x3F, 0xDD, 0xCF, 0xFF, 
	0x83, 0x80, 0xCF, 0xF6, 0x7F, 0xFE, 0x01, 0x7F, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xE0, 0x00, 0x07, 0x18, 0x0F, 0xFF, 0x03, 
	0x01, 0xFF, 0xC1, 0xFC, 0x1F, 0xC0, 0xCF, 0xFF, 0x80, 0x00, 0x0F, 0xF6, 0x7F, 0xFF, 0x03, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFE, 0x00, 0xFF, 0xFF, 0xFF, 
	0xF8, 0xE0, 0x3E, 0x07, 0xF8, 0x0F, 0xF8, 0x7F, 0xF8, 0x7F, 0xC1, 0xFC, 0x1F, 0xC0, 0xCF, 0xFF, 
	0x80, 0x1C, 0x0F, 0xF6, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x7F, 0xFF, 0xE0, 0x00, 0x0F, 0xFF, 0xFF, 0xF8, 0xE0, 0x7E, 0x07, 0xF8, 0x0F, 0xE1, 0xFF, 
	0xFF, 0x3F, 0xC1, 0xFC, 0x1F, 0xE0, 0xCF, 0xFF, 0x80, 0xFC, 0x0F, 0xF6, 0x7F, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, 0x78, 0x00, 0x0F, 0xFF, 
	0xF8, 0xE0, 0xFE, 0x07, 0xF8, 0x0F, 0xC4, 0xFF, 0xFF, 0x9F, 0xC1, 0xFC, 0x1F, 0xE1, 0xCF, 0xFF, 
	0x83, 0xFE, 0x0F, 0xF6, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFE, 0x7F, 0xFE, 0x00, 0xFC, 0x00, 0x03, 0xFF, 0xF8, 0xE0, 0xFF, 0x07, 0xF8, 0x0F, 0x90, 0x38, 
	0xFF, 0x4F, 0xC1, 0xFC, 0x1F, 0xE1, 0xCF, 0xFF, 0xC3, 0xFE, 0x0F, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xC0, 0x00, 0xDC, 0x01, 0x99, 0xFF, 
	0xF8, 0xE0, 0xFF, 0x03, 0xF8, 0x0F, 0x20, 0x00, 0x7F, 0x27, 0xC1, 0xFC, 0x1F, 0xE1, 0xDF, 0xFF, 
	0xC3, 0xFE, 0x0F, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFC, 0xFF, 0x84, 0x00, 0xF8, 0x01, 0x11, 0xFF, 0xF8, 0xE0, 0xFF, 0x83, 0xF8, 0x0E, 0x44, 0xE7, 
	0x3F, 0x13, 0xE1, 0x08, 0x0F, 0xC1, 0xDF, 0xFF, 0xC3, 0xFE, 0x0F, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0x00, 0x00, 0x20, 0x00, 0x00, 0xFF, 
	0xF8, 0xE0, 0xFF, 0x03, 0x00, 0x0E, 0x04, 0xFF, 0x3F, 0x13, 0xE0, 0x00, 0x00, 0x01, 0xDF, 0xFF, 
	0xC3, 0xFE, 0x0C, 0x71, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0x00, 0x00, 
	0xFD, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0xE0, 0xFC, 0x00, 0x00, 0x1E, 0xFC, 0xFF, 
	0x7F, 0xF9, 0xE0, 0x00, 0x00, 0x01, 0xDF, 0xFF, 0xC3, 0xFC, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3F, 
	0xFC, 0xE0, 0x00, 0x00, 0x00, 0x1C, 0xFC, 0xFE, 0x7F, 0xF9, 0xE0, 0x00, 0x00, 0x00, 0xCF, 0xFF, 
	0xC3, 0xF8, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFD, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0xF0, 0x00, 0x00, 0x00, 0x1C, 0xFE, 0x7E, 
	0xFF, 0xF9, 0xF8, 0x00, 0x00, 0x0D, 0xCF, 0xFF, 0xC3, 0xE0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x79, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
	0xFC, 0xF0, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0x3C, 0xFF, 0xFD, 0xFC, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xC3, 0x80, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x71, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xF9, 0xF0, 0x00, 0x0C, 0x3F, 0xFF, 0xFF, 0xE9, 0xFC, 0xF8, 0x00, 0x00, 0x07, 0xFC, 0xFF, 0x81, 
	0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xC0, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xE4, 0x61, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 
	0xFC, 0xFC, 0x0F, 0xFF, 0xFF, 0xF8, 0xFF, 0xE3, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE4, 0x69, 0xFF, 0xFF, 0xFF, 0xC0, 
	0xFB, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x84, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 
	0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xF3, 0xC4, 0x4D, 0xC0, 0x1F, 0xFF, 0x80, 0xFB, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
	0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xE0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFD, 0xFE, 0x79, 0xFF, 0xF9, 0xC4, 0x64, 0x00, 0x1F, 0xFF, 0xFF, 
	0x03, 0xF1, 0xFF, 0xE0, 0x7E, 0x7F, 0xFF, 0x01, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 
	0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xE0, 0x70, 0xFF, 0xFF, 0xFF, 0xF9, 0xFE, 0x79, 
	0xEF, 0xFC, 0xC4, 0x44, 0x3F, 0xFF, 0xFF, 0xFF, 0x03, 0xF0, 0x00, 0x00, 0x7C, 0x00, 0x70, 0x80, 
	0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x36, 0xEF, 0xFE, 0x08, 0x05, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x03, 0xF0, 0x3E, 0x00, 0x7E, 0x00, 0xF8, 0x80, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0x36, 
	0xCF, 0xFC, 0x23, 0x7F, 0xFF, 0xFE, 0x00, 0x3F, 0x03, 0xE0, 0x3E, 0x00, 0x7E, 0x00, 0xF8, 0x6F, 
	0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x80, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFA, 0x7E, 0x36, 0xC7, 0xFC, 0x33, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 
	0x03, 0xE0, 0x3E, 0x00, 0x7E, 0x00, 0xF8, 0x77, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x80, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xF8, 0x7E, 0xB6, 
	0x8F, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xE0, 0x1E, 0x00, 0x7E, 0x00, 0xF8, 0x73, 
	0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xF9, 0x7C, 0xAC, 0x2C, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x07, 0xE0, 0x1E, 0x00, 0x7E, 0x00, 0xF8, 0x3A, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xF9, 0x39, 0x2E, 
	0x40, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xE0, 0x1E, 0x00, 0x7E, 0x00, 0xF8, 0x0E, 
	0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0xFF, 0xFE, 0x7E, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xF9, 0x3B, 0x9C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x07, 0xE0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF8, 0x0E, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x93, 0x1C, 
	0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x01, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF0, 0x0E, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x06, 0xD7, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 
	0x07, 0xE0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF0, 0x0E, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x78, 0x46, 0x7F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xE0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x01, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF0, 0x1E, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1C, 0x47, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0xE0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF0, 0x7E, 0x3F, 0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x6F, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xE0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x01, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF0, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x06, 0x00, 0x77, 0xFF, 
	0x0F, 0xC0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 
	0xF8, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFE, 0x00, 0x06, 0x00, 0x27, 0xFF, 0x0F, 0xC0, 0x1E, 0xFF, 0x7E, 0xFF, 0xF8, 0x00, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xF9, 0xE6, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x1F, 0xC0, 0x1E, 0x00, 0x7E, 0x00, 0xF8, 0x00, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFF, 0xF3, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x1F, 0xC0, 0x1E, 0x00, 0x7E, 0x00, 0xF8, 0x00, 
	0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0x81, 0xFF, 0xE7, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xE0, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x03, 
	0x1F, 0xC0, 0x1E, 0x00, 0x7E, 0x00, 0xF8, 0x00, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xFE, 0x03, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0xBF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xBB, 0xFF, 0xDF, 0xFE, 0xFF, 0x6F, 0xFF, 0x1F, 0xC0, 0x1E, 0x00, 0x7E, 0x00, 0xF8, 0x00, 
	0x7F, 0x7F, 0xF9, 0xE0, 0x7F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFC, 0x8F, 0xFF, 0xE7, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xD3, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x38, 0x00, 0xC0, 0x06, 0x00, 0x67, 0xFF, 
	0x1F, 0xC0, 0x3E, 0x00, 0x7E, 0x00, 0xF8, 0x00, 0x7F, 0x3F, 0xE3, 0xC1, 0x7F, 0xF8, 0xFF, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xF8, 0x1F, 0xFF, 0xE7, 0xFF, 0xFF, 0x3F, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xC0, 0x3E, 0x00, 0x7F, 0x00, 0xF8, 0x00, 
	0x7F, 0x3F, 0xC7, 0x23, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0x1F, 0xFF, 0xE7, 0xFF, 
	0xFE, 0x26, 0x78, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x3F, 0x80, 0x0C, 0x00, 0x3C, 0x00, 0x30, 0x00, 0x1F, 0x3F, 0xA6, 0x4F, 0xFF, 0xF8, 0x7F, 0xFF, 
	0xFF, 0xFE, 0x3F, 0xF0, 0x7F, 0xFF, 0xE7, 0xFF, 0xFC, 0x44, 0x40, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0xDF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 
	0x0F, 0x3F, 0x2C, 0x8F, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF0, 0x78, 0x3F, 0xE7, 0xFF, 
	0x98, 0x02, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 
	0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x7F, 0x4D, 0x1F, 0xFF, 0xFE, 0x7F, 0xFF, 
	0xFF, 0x02, 0x3F, 0xF6, 0xF0, 0x7F, 0xE4, 0xFF, 0x9A, 0x26, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0x3E, 0xDB, 0x1F, 0xFF, 0xEF, 0x7F, 0xFF, 0xFF, 0x02, 0x3F, 0xF4, 0xC3, 0xFF, 0xE4, 0xF3, 
	0x8A, 0x67, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x3E, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x3E, 0xD7, 0x3F, 0xFF, 0x8F, 0x7F, 0xFF, 
	0xFF, 0x02, 0x3C, 0x74, 0x87, 0x1F, 0xE0, 0xF8, 0x83, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x0F, 0x3E, 0xB6, 0x7F, 0x8F, 0x1F, 0x7F, 0xFF, 0xFF, 0x02, 0x38, 0x05, 0xA6, 0x0F, 0xE0, 0xFC, 
	0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x18, 0x00, 0xC0, 0x1C, 0x03, 0xFF, 0xFF, 
	0x7E, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0xA6, 0xAE, 0x7F, 0x82, 0xB8, 0x7F, 0xFF, 
	0xFF, 0x02, 0x3C, 0xC5, 0x69, 0x1F, 0xE0, 0xFC, 0x97, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x4F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x3F, 0xA2, 0x8E, 0x7F, 0xE0, 0x83, 0x7F, 0xFF, 0xFF, 0x02, 0x3F, 0x64, 0x63, 0x3F, 0xE0, 0xF8, 
	0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x47, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xB0, 0x9C, 0xFF, 0xF4, 0x93, 0x7F, 0xFF, 
	0xFF, 0x02, 0x3F, 0xB4, 0xE6, 0x7F, 0xF3, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x43, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x3F, 0xB0, 0x9C, 0xC0, 0x12, 0x90, 0x01, 0xFF, 0xFF, 0x2E, 0x3C, 0x32, 0xEE, 0x01, 0xF4, 0x0F, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xE9, 0x80, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xB0, 0x9C, 0x00, 0x07, 0xF8, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x20, 0x01, 
	0xF8, 0x00, 0x00, 0xC1, 0xE0, 0x00, 0xE0, 0x03, 0xE9, 0x24, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 
	0x7F, 0xA4, 0x9C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xCC, 0x6C, 0x00, 0x0A, 0x00, 0x1C, 0x00, 0x00, 0x20, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0x7F, 0xFF, 0xFF, 0x6F, 0xFE, 0xFF, 0xFF, 
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
};
