#include "../include.h"

// format: 6-bit paletted pixel graphics (5 pixels per u32)
// image width: 214 pixels
// image height: 160 lines
// image pitch: 172 bytes
const u16 Img6b_Pal[64] __attribute__ ((aligned(4))) = {
	0x0000, 0x000A, 0x0015, 0x001F, 0x02A0, 0x02AA, 0x02B5, 0x02BF, 0x0540, 0x054A, 0x0555, 0x055F, 0x07E0, 0x07EA, 0x07F5, 0x07FF, 
	0x5000, 0x500A, 0x5015, 0x501F, 0x52A0, 0x52AA, 0x52B5, 0x52BF, 0x5540, 0x554A, 0x5555, 0x555F, 0x57E0, 0x57EA, 0x57F5, 0x57FF, 
	0xA800, 0xA80A, 0xA815, 0xA81F, 0xAAA0, 0xAAAA, 0xAAB5, 0xAABF, 0xAD40, 0xAD4A, 0xAD55, 0xAD5F, 0xAFE0, 0xAFEA, 0xAFF5, 0xAFFF, 
	0xF800, 0xF80A, 0xF815, 0xF81F, 0xFAA0, 0xFAAA, 0xFAB5, 0xFABF, 0xFD40, 0xFD4A, 0xFD55, 0xFD5F, 0xFFE0, 0xFFEA, 0xFFF5, 0xFFFF, 
};

const u32 Img6b[6880] __attribute__ ((aligned(4))) = {
	0x15954455, 0x15565565, 0x1E565521, 0x1055055A, 0x25415415, 0x3DF65915, 0x3DF7DF7D, 0x3CF7DF7D, 
	0x3CE3DE3D, 0x39E38E39, 0x39E39E38, 0x14454854, 0x11511511, 0x10450464, 0x11411415, 0x10454450, 
	0x15411511, 0x25550560, 0x3FEAAAAA, 0x3AABAFBB, 0x3AEBBFBF, 0x3AEBAFFF, 0x1496AAAA, 0x20564950, 
	0x15911915, 0x24464560, 0x15411911, 0x24560550, 0x11911925, 0x14854454, 0x11511511, 0x11925410, 
	0x10414454, 0x10410415, 0x25965950, 0x25965965, 0x24965965, 0x24965925, 0x39E75965, 0x39E79E79, 
	0x39E79E79, 0x39E79E79, 0x34E79E79, 0x21511564, 0x14854464, 0x19454455, 0x1445469E, 0x20551511, 
	0x39F79915, 0x39F7DF7D, 0x3CE7CE7C, 0x38F78F39, 0x38E7CE7C, 0x38E78E39, 0x11521429, 0x14450850, 
	0x11511911, 0x14410950, 0x11521411, 0x10454450, 0x2A425425, 0x00FEAEA5, 0x3AABAFC0, 0x2AEBE03F, 
	0x3EFFF03F, 0x25AA9EBA, 0x15921550, 0x14864560, 0x11915825, 0x10424464, 0x25425425, 0x24464950, 
	0x21511911, 0x14454854, 0x15815411, 0x11511520, 0x10450550, 0x24964950, 0x25925925, 0x11964964, 
	0x24964964, 0x39E79925, 0x39E79E79, 0x39E79E79, 0x39E79E79, 0x3FE79E79, 0x25464465, 0x25521955, 
	0x11521521, 0x1151A399, 0x15414454, 0x3DF7DA64, 0x3DF79F7D, 0x3DF3DF7D, 0x38F39F7C, 0x3CE38E3D, 
	0x39E38E78, 0x10854978, 0x11911515, 0x10454464, 0x11415415, 0x10454454, 0x11511815, 0x25454864, 
	0x3F03FAAA, 0x3AEBAFFA, 0x3FFBF03F, 0x3F03FFFA, 0x15A7AEAA, 0x24464810, 0x21511911, 0x24460550, 
	0x15415911, 0x20560550, 0x11911925, 0x14854464, 0x11911521, 0x11925414, 0x10464454, 0x11510415, 
	0x25965910, 0x25964965, 0x24965965, 0x11925815, 0x39E79964, 0x39E79E79, 0x39E79E79, 0x39E79E79, 
	0x20E79E79, 0x15911511, 0x10954864, 0x10565415, 0x1564E655, 0x25454450, 0x3DF79F65, 0x3DF7DF79, 
	0x38F78F78, 0x3DE3CE3D, 0x38E7CE38, 0x38E78E39, 0x15421E39, 0x10454450, 0x15411521, 0x25450550, 
	0x15411415, 0x14454450, 0x2A511521, 0x0003AAAA, 0x3FFFAFC0, 0x3B00003E, 0x0003F03F, 0x25AA9EBF, 
	0x24565550, 0x25911911, 0x20564854, 0x10411915, 0x25815815, 0x24464854, 0x21521511, 0x14464454, 
	0x14864450, 0x14411911, 0x10450450, 0x24965950, 0x24965925, 0x15925925, 0x24964960, 0x39E79D65, 
	0x39E79E79, 0x39E79E79, 0x39E79E79, 0x20E79E79, 0x25465425, 0x25455911, 0x15421560, 0x1539A550, 
	0x20550550, 0x39F7DE69, 0x39F7DF7D, 0x3DF3DF7D, 0x38F78F78, 0x38E38F78, 0x38E39E38, 0x10564E78, 
	0x21511815, 0x10550454, 0x2AEAA951, 0x10454465, 0x20450950, 0x26565425, 0x3A03FAA9, 0x0003F03F, 
	0x00FBF03F, 0x3E03E03E, 0x10A6AEBA, 0x21520950, 0x10854854, 0x25521525, 0x15410950, 0x24560560, 
	0x11911921, 0x14854464, 0x11511521, 0x11525410, 0x10454424, 0x10414415, 0x25925911, 0x25925965, 
	0x20964965, 0x25925925, 0x39E79E65, 0x39E79E79, 0x39E79E79, 0x39E79E79, 0x20E79E79, 0x25514815, 
	0x10564464, 0x10565425, 0x1A395411, 0x25454454, 0x3DF7DF78, 0x3DF7DF7D, 0x3DE3DE3D, 0x3DE39F38, 
	0x39F39E38, 0x39E78E38, 0x20478E78, 0x14450550, 0x10411521, 0x25ABAEA5, 0x11510425, 0x10454450, 
	0x2A911425, 0x3F03AEA6, 0x3FFFF03A, 0x00FFF03F, 0x3F03F03F, 0x25AAAEAF, 0x15825550, 0x24560560, 
	0x11911911, 0x11424464, 0x15825414, 0x14854964, 0x11911911, 0x14854854, 0x15825411, 0x11520550, 
	0x10450450, 0x24965950, 0x24965925, 0x15925965, 0x24964864, 0x39E79E65, 0x39E79E79, 0x39E79E79, 
	0x39E79D79, 0x20E79E79, 0x20966DB6, 0x15815955, 0x15815565, 0x0E694454, 0x24415415, 0x39F79F7D, 
	0x3EFBEF7D, 0x39F3DF7D, 0x38F3CE7C, 0x38E38F39, 0x39E78E39, 0x14978E79, 0x11814411, 0x11950854, 
	0x11425EAA, 0x10450450, 0x15411815, 0x25554960, 0x00FABAAA, 0x3AEBAFC0, 0x3F00003F, 0x00FBF03B, 
	0x25A7AEBA, 0x24560910, 0x11915815, 0x24464464, 0x20411911, 0x24454855, 0x11911911, 0x24454464, 
	0x11511911, 0x11925414, 0x14854464, 0x11510511, 0x25964950, 0x25925964, 0x20965925, 0x25925925, 
	0x39E79E79, 0x39E79E79, 0x39E79E79, 0x39E79E79, 0x20E65E79, 0x36DB6DFA, 0x10560965, 0x10560425, 
	0x1E251511, 0x25415411, 0x3DF7DE7D, 0x3DFBEFBD, 0x3CE7CE7D, 0x38E78F39, 0x38E39E3C, 0x39E78E38, 
	0x11939E79, 0x25450550, 0x35DB5961, 0x25D76DB6, 0x14415825, 0x10550450, 0x26811521, 0x3EAFAAA9, 
	0x3AABAFBB, 0x3BFFEFFA, 0x3BBFAFEE, 0x15AA9EBE, 0x21915850, 0x24854950, 0x11911911, 0x15414864, 
	0x20950510, 0x25425925, 0x10950950, 0x25425425, 0x24464450, 0x10550511, 0x10450454, 0x24965950, 
	0x25964965, 0x15925964, 0x25964964, 0x39E79E79, 0x39EB9E79, 0x35E79E79, 0x39E79E79, 0x20E79D69, 
	0x36DF7EB7, 0x15865DB7, 0x15465560, 0x0E554450, 0x25550454, 0x3DE7DF7C, 0x3DFBEFBD, 0x39F39F79, 
	0x3CE3DE3C, 0x38E38E38, 0x39E79E38, 0x14978E79, 0x36D65850, 0x36DB6DB6, 0x32DB6D76, 0x11865C76, 
	0x11411910, 0x14464464, 0x2AEAAA66, 0x3AA6AEAA, 0x3AEBAEBA, 0x3AEBAEBA, 0x2096AAAA, 0x24464950, 
	0x11911815, 0x24464864, 0x11411911, 0x15825464, 0x10560464, 0x15815425, 0x10550560, 0x11525411, 
	0x10854854, 0x10414411, 0x25964955, 0x25925964, 0x20964965, 0x35921925, 0x39E79E79, 0x39E79E79, 
	0x39E79E79, 0x39E79D79, 0x20E79E75, 0x37DBADF6, 0x259B6DF6, 0x20564454, 0x1E651415, 0x29411511, 
	0x39F7DF39, 0x3DFBEFBD, 0x3CE7CF7D, 0x39E38F39, 0x38E38E38, 0x39E78E38, 0x11E39E79, 0x35DB6D65, 
	0x36D76D76, 0x35DB5DB6, 0x35D72DB2, 0x10414461, 0x21511425, 0x26AA9994, 0x25AAAAAA, 0x29AAAAAA, 
	0x2AAAAAAA, 0x1596A979, 0x21521510, 0x24464954, 0x11921511, 0x14414464, 0x20950911, 0x15815925, 
	0x20560560, 0x15815815, 0x15825410, 0x15511510, 0x10450450, 0x25925950, 0x24965925, 0x15925965, 
	0x39964960, 0x39E79E79, 0x39E79E79, 0x35E79E79, 0x35979A79, 0x20E79E79, 0x36DF6DBB, 0x36DB6DB7, 
	0x11521525, 0x0E555415, 0x24454454, 0x3DF78F7D, 0x39F7DF7D, 0x39F39E7D, 0x38F39E3C, 0x38E38E38, 
	0x39E38E38, 0x35E39E79, 0x36D75DB5, 0x35DB5DB5, 0x36C76DB5, 0x32CB5C76, 0x11521975, 0x14464950, 
	0x259A5521, 0x25926A69, 0x2AAA9AA9, 0x29A6AAA5, 0x24925A6A, 0x25425811, 0x10950850, 0x25415825, 
	0x20450950, 0x25425415, 0x10950950, 0x15815425, 0x10560560, 0x21525415, 0x10854854, 0x10511511, 
	0x25965911, 0x25925964, 0x24965925, 0x39965925, 0x39E79E79, 0x39E79E79, 0x39E79E79, 0x39E75E79, 
	0x20E79E79, 0x36DBBDB6, 0x36DF6EFA, 0x15854876, 0x1E650550, 0x29559659, 0x39F7DE3D, 0x3DE7DE7D, 
	0x3CE7CF79, 0x38E3CE78, 0x38E38E38, 0x38E38E38, 0x36E38E39, 0x36DB5DB5, 0x35DB5DB6, 0x36DB1DB6, 
	0x35872D71, 0x10875CA1, 0x20411425, 0x15521415, 0x10965951, 0x24951925, 0x25425965, 0x11925960, 
	0x24950950, 0x15815911, 0x10960560, 0x15410964, 0x14950950, 0x25425825, 0x24950950, 0x25415815, 
	0x24465410, 0x11511511, 0x11410414, 0x24964964, 0x25964965, 0x11925964, 0x39964964, 0x39E79E79, 
	0x39E79E79, 0x39D79E79, 0x39E79E79, 0x20E79E79, 0x3ADB6DFA, 0x369BAEBF, 0x105259B6, 0x1D759415, 
	0x1D75D75D, 0x3DE3DF78, 0x39F79F7C, 0x38F39E3C, 0x38E38F39, 0x38E38E38, 0x38E38E38, 0x35E78E38, 
	0x3ADB6C76, 0x32D76EBA, 0x31D76C75, 0x36EB58B6, 0x25D61D71, 0x11550950, 0x10450560, 0x25924950, 
	0x25964464, 0x24964950, 0x34D70925, 0x11825834, 0x20564464, 0x15815815, 0x20411521, 0x25825415, 
	0x10950560, 0x21425425, 0x10950954, 0x15425511, 0x14854850, 0x10415411, 0x25965955, 0x25925964, 
	0x24964965, 0x39D65825, 0x39E79E79, 0x39E79E79, 0x39E75E79, 0x39E79E79, 0x20E79E79, 0x3BDB6EB6, 
	0x26DBAFFE, 0x11965DB6, 0x1D75D650, 0x0D74D74D, 0x39F7DE3D, 0x3DE3DE3D, 0x3CE78F39, 0x38E38E38, 
	0x38E38E38, 0x38E38E38, 0x35D78E38, 0x3EFB6DB1, 0x35D76EBE, 0x35DB1D76, 0x3AEBADB1, 0x35871C66, 
	0x24411425, 0x15425411, 0x21925950, 0x25921925, 0x34960964, 0x35D34D75, 0x24D34D74, 0x11911910, 
	0x20564464, 0x14454854, 0x11911521, 0x14854964, 0x15921511, 0x14560560, 0x14864450, 0x11511511, 
	0x10450454, 0x24964960, 0x24965925, 0x11925965, 0x39E64964, 0x39E75E79, 0x39E79E79, 0x39D79E79, 
	0x39E79E79, 0x20D79E79, 0x3ADBADF6, 0x369AAEBA, 0x14976DB6, 0x1D75D759, 0x0D35D35D, 0x3CE7CF68, 
	0x38F78F79, 0x38E3CE7C, 0x38E38E38, 0x38E38E38, 0x38E38E38, 0x31D78E38, 0x3FEBAD76, 0x32D61EAA, 
	0x36876D75, 0x3EFFEDB5, 0x318759BA, 0x10464961, 0x10950425, 0x14965910, 0x24854964, 0x35D35921, 
	0x34D74D74, 0x30D75D35, 0x24854835, 0x15811911, 0x11410960, 0x24464454, 0x21521815, 0x20954864, 
	0x25415815, 0x21525410, 0x10854814, 0x11414411, 0x25965954, 0x25925965, 0x24965925, 0x39E65925, 
	0x39E79E79, 0x39E79E79, 0x39E65E79, 0x39E79E79, 0x20E69E79, 0x36DB6DB6, 0x36DB6DB6, 0x159769B6, 
	0x1E75D79D, 0x0D34D74D, 0x38F79F1D, 0x3CE3DE3D, 0x38E38E39, 0x38E38E38, 0x38E38E38, 0x38E38E38, 
	0x36D78E38, 0x2AEB6D75, 0x35DB5C75, 0x35D75CB5, 0x3AEBA971, 0x25C6196A, 0x24421971, 0x11425411, 
	0x25925954, 0x25921521, 0x34D75D64, 0x35D35D35, 0x34D35D74, 0x11921C34, 0x21525814, 0x24450954, 
	0x24854811, 0x21515921, 0x14854454, 0x11911921, 0x15825450, 0x15411550, 0x10450550, 0x25925964, 
	0x25964964, 0x11925964, 0x39E65964, 0x39D79E79, 0x39E79E79, 0x39E79D79, 0x39E79E79, 0x20D79D79, 
	0x36DB6DB6, 0x32DB6DB6, 0x199B6CA6, 0x2FB8D75E, 0x0C74D35D, 0x3CE7CA4D, 0x38F78F39, 0x38E38F38, 
	0x38E38E38, 0x38E38E38, 0x38E38E38, 0x35875E38, 0x35D75DB5, 0x35D75DB5, 0x35DA1D66, 0x2A9B5C66, 
	0x3187196A, 0x11425961, 0x10511414, 0x10964950, 0x21525925, 0x35D35D35, 0x34D30D35, 0x34D75D75, 
	0x10834C30, 0x14854465, 0x15410921, 0x21521550, 0x10950854, 0x21925425, 0x14464454, 0x21521510, 
	0x10454854, 0x10411410, 0x24964965, 0x25925965, 0x24964965, 0x39E65825, 0x39E79E79, 0x39D79E75, 
	0x39E79E65, 0x39E79E79, 0x20975A79, 0x36DB6DB6, 0x36DB6DB6, 0x1E9B29B6, 0x1E79D75D, 0x0D34D35D, 
	0x39F3974D, 0x3CE38E7C, 0x38E38E38, 0x38E38E38, 0x38E38E38, 0x38E34E38, 0x36C75E38, 0x32D76D75, 
	0x31876D75, 0x21860875, 0x35C75C75, 0x21971871, 0x20975871, 0x14460511, 0x25925950, 0x34960464, 
	0x35D75D75, 0x34C30D34, 0x34D75D75, 0x20C30C34, 0x15815814, 0x20410560, 0x24854815, 0x15825521, 
	0x24560560, 0x11911521, 0x14464450, 0x10950411, 0x10454415, 0x25965964, 0x24965964, 0x11925965, 
	0x39E65964, 0x35E79E79, 0x35D69D79, 0x39E79E79, 0x35E79E79, 0x20D29D79, 0x36DB7EB7, 0x36CB6DB6, 
	0x1E9B6CA2, 0x0D74D35E, 0x0D34D34D, 0x3CE5D34D, 0x38E7CE39, 0x38E38E38, 0x38E38E38, 0x38E38E38, 
	0x38E38E34, 0x35D61D78, 0x35D71D76, 0x21D75D72, 0x21971861, 0x21C61D61, 0x219A69B5, 0x25861861, 
	0x11415410, 0x10964950, 0x34964965, 0x35D75D75, 0x34C34C30, 0x35D75E74, 0x20C30D30, 0x20560560, 
	0x15411915, 0x11911510, 0x20550964, 0x25815815, 0x15424854, 0x21525410, 0x10550954, 0x10411411, 
	0x24964965, 0x25925925, 0x24965925, 0x39E65925, 0x39E79E79, 0x39E75E79, 0x39E79E79, 0x39E79E79, 
	0x20975E65, 0x36DB6DB6, 0x26DB6DB6, 0x1E6A2DB2, 0x0D35D34D, 0x0D34D34D, 0x39B4D34D, 0x38E39F39, 
	0x38E38E38, 0x38E38E38, 0x38E38E38, 0x38E38E38, 0x36D61C79, 0x36D76D75, 0x35DB5D75, 0x31D75D75, 
	0x1BAA69B5, 0x1B6DB6DB, 0x21D6599A, 0x14450550, 0x24965910, 0x35D50925, 0x34D74D74, 0x34D34C34, 
	0x35D75D75, 0x20C30C35, 0x11910825, 0x11410864, 0x24464464, 0x15825425, 0x14960560, 0x11511921, 
	0x14854855, 0x11415411, 0x10454414, 0x25925925, 0x25964964, 0x21525964, 0x39E65925, 0x39E79E79, 
	0x39E79E79, 0x39E79E79, 0x35E75E79, 0x20E65D39, 0x36DB6DB6, 0x32CB6DB6, 0x1E6B28A2, 0x0D34D78D, 
	0x0D34D34D, 0x1D34D34D, 0x38E38E78, 0x38E38E38, 0x38E38E38, 0x34E38E38, 0x35E38E38, 0x35D75861, 
	0x35D71DB1, 0x21D61DA5, 0x26875875, 0x1F7DF6E6, 0x1F7DF7DF, 0x2559B7DB, 0x10910421, 0x15824951, 
	0x34D65560, 0x30D34D34, 0x38D34D30, 0x35E75E75, 0x30830C35, 0x24425520, 0x20550511, 0x11921511, 
	0x20564464, 0x21525415, 0x2F994454, 0x1142569F, 0x10550464, 0x10411411, 0x25964965, 0x25925965, 
	0x24864965, 0x39E65964, 0x39E79D79, 0x39E79E79, 0x39E79E79, 0x39979E79, 0x20E79E65, 0x36DB6DF6, 
	0x329B2DB6, 0x1E5B28B6, 0x0D34D34D, 0x0D34D34D, 0x0E34D34D, 0x38E7DE59, 0x38E38E39, 0x38E38E38, 
	0x38E38E38, 0x35D78E38, 0x35DA1871, 0x35CB5D75, 0x35D76D71, 0x1ADA1D75, 0x1F7DF7DF, 0x0F7CF7DF, 
	0x1A6DF6DF, 0x10450566, 0x25925950, 0x35E69825, 0x34D30D34, 0x38E78D34, 0x34D79D78, 0x20C30C34, 
	0x10550860, 0x15410865, 0x24854460, 0x11911911, 0x24864464, 0x2FBD5921, 0x1569F6DF, 0x14421510, 
	0x10450511, 0x25925965, 0x24965964, 0x25925925, 0x39E65925, 0x39E79E79, 0x39E79E79, 0x39E79E79, 
	0x35E75A75, 0x20E79E79, 0x36DB6DB6, 0x22DB2DB6, 0x0E9B28B2, 0x0D34D39E, 0x0D34D34D, 0x0E34D34D, 
	0x39E68419, 0x38E38E78, 0x38E38E38, 0x38E38D38, 0x31D75E78, 0x31D61C61, 0x35975C76, 0x31971976, 
	0x1F6E6C65, 0x1F7DF7DF, 0x1F7DF7DF, 0x1B7CB7CF, 0x1441599B, 0x20564950, 0x39E79954, 0x34C34D34, 
	0x39E39E38, 0x34D35E39, 0x30C20C30, 0x24420520, 0x11410550, 0x11911910, 0x14854864, 0x21521521, 
	0x2F7E6554, 0x2A6DF7DF, 0x11510455, 0x10415410, 0x24964964, 0x25925925, 0x21525965, 0x39D64964, 
	0x39E75E79, 0x39E79E79, 0x39D79E79, 0x39E75E79, 0x20E79E79, 0x36DB6DB6, 0x328B6CB6, 0x1E9728B2, 
	0x0D34D34E, 0x0D34D34D, 0x0E38D34D, 0x28950555, 0x38E79E39, 0x38E38E39, 0x39E38E38, 0x21D76D75, 
	0x35D61875, 0x31DB1971, 0x35D75C65, 0x1F7DB9B1, 0x1F7DF7DF, 0x1F3DF7DF, 0x0B7CF7CF, 0x105666CA, 
	0x24864950, 0x3DE79425, 0x38E34E79, 0x38E78E79, 0x34D34E78, 0x24C30C30, 0x10550874, 0x10550815, 
	0x24464464, 0x11911521, 0x14964464, 0x1F6D5825, 0x1F2DF7DF, 0x1045441A, 0x11410454, 0x25965925, 
	0x25964964, 0x24864964, 0x39965925, 0x39E79E79, 0x39E79E79, 0x39E79E79, 0x39E79E75, 0x20979E79, 
	0x32DB6DB6, 0x22CB29B2, 0x19476CB2, 0x0D38D38E, 0x0D34D34D, 0x1E38E38D, 0x11425415, 0x39E29964, 
	0x38E39E78, 0x21D75D38, 0x35C75DB1, 0x32D61861, 0x25C75C75, 0x21D61D75, 0x1F7DFAE5, 0x1F7DF7DF, 
	0x1F7DF7DF, 0x1B28F6CF, 0x1099B68B, 0x20564950, 0x3DE79815, 0x39F79F79, 0x39E39E3D, 0x30D38E38, 
	0x34D30D30, 0x11814824, 0x25410560, 0x10950550, 0x15825425, 0x20960560, 0x1F555415, 0x0B7DF7DF, 
	0x1541155F, 0x10415410, 0x24964965, 0x25925965, 0x25525925, 0x39964864, 0x39D79E79, 0x39E79E75, 
	0x39E75E79, 0x39E79E79, 0x20925E79, 0x36DB6DB6, 0x32DA2CB2, 0x15525DA2, 0x0D34E39E, 0x0D34D34D, 
	0x1538E34E, 0x11511425, 0x10420950, 0x3A950515, 0x35C75E79, 0x31976D61, 0x35D61871, 0x35C65C61, 
	0x31971D61, 0x1F7DF7E6, 0x1F7EF7DF, 0x0F7CF7DF, 0x0A7DB3DF, 0x1668B29B, 0x15920950, 0x3DE64560, 
	0x39F79F79, 0x38E78F79, 0x34D38E39, 0x34D34D34, 0x10510464, 0x10450815, 0x25815421, 0x10950950, 
	0x25425425, 0x1F450960, 0x0F3CF7DF, 0x1055069B, 0x10450411, 0x25925965, 0x24964964, 0x25825965, 
	0x35925925, 0x35E79E79, 0x39D79D79, 0x39E79E75, 0x39E79E79, 0x20D64925, 0x36CB6CB6, 0x328B2DA2, 
	0x10951976, 0x0E39E799, 0x0D38D38D, 0x1068E38E, 0x25425415, 0x11525550, 0x3A411410, 0x32976E7A, 
	0x35CB59B1, 0x31961861, 0x31971C75, 0x25C65C75, 0x1F7DF7DB, 0x1FBFFBDF, 0x1F3DF7DF, 0x2FFEF7CF, 
	0x2A6DA2CA, 0x20565911, 0x38E65815, 0x3DE3DE39, 0x38E39E38, 0x38E38E38, 0x34D34D34, 0x10450825, 
	0x15410550, 0x10550910, 0x15825425, 0x20960560, 0x1F695815, 0x0B3CB3CF, 0x15410A9F, 0x11511510, 
	0x25964964, 0x25925964, 0x25525925, 0x25964864, 0x39E79E79, 0x35E75E79, 0x39E79D79, 0x35E79E79, 
	0x20E75924, 0x32DB2DB6, 0x36DA2CB6, 0x15825865, 0x0D78E650, 0x0E38E34E, 0x1051A78E, 0x15415825, 
	0x10464950, 0x29414450, 0x31C79EBE, 0x39D76C65, 0x35860875, 0x31C65861, 0x26871961, 0x1F7DF7DB, 
	0x1AFFFFEF, 0x0B7DF3CA, 0x2FFFFA96, 0x1A2CA6DA, 0x11824855, 0x3DE24464, 0x38E78F78, 0x38E38E78, 
	0x34E38E38, 0x34D34D34, 0x10511424, 0x10450425, 0x24811464, 0x21521521, 0x10954854, 0x1F7DA565, 
	0x0B3CB2CF, 0x1055169F, 0x10411411, 0x24965925, 0x25964965, 0x24864964, 0x24865925, 0x39E79E79, 
	0x39D79E79, 0x39E79E79, 0x24935E79, 0x20E79E65, 0x26DB6CB6, 0x25DB69B2, 0x10954525, 0x1E795425, 
	0x1E79E79E, 0x2445055A, 0x11911511, 0x15421964, 0x25411510, 0x319B9EBA, 0x39E75961, 0x21861879, 
	0x25871C71, 0x2B861C71, 0x1F7DF7DF, 0x10AFFFEF, 0x157DF680, 0x2ABFF680, 0x1B68B2AB, 0x24454966, 
	0x39951911, 0x38E38E78, 0x38E38E38, 0x38D38E38, 0x25D34D34, 0x10410410, 0x21510450, 0x11560510, 
	0x14854854, 0x1A561521, 0x0F7DF6DB, 0x1F2CB3CB, 0x1041045F, 0x15414454, 0x24964965, 0x25925925, 
	0x25525925, 0x25924964, 0x39E79E65, 0x39E79E79, 0x39E79E79, 0x35964925, 0x20A75E79, 0x36DB6DB6, 
	0x20965DB6, 0x15425855, 0x15410550, 0x15659659, 0x11414954, 0x14464464, 0x10425911, 0x10450411, 
	0x21D7AFBA, 0x39F79871, 0x21821D79, 0x21C61861, 0x1B971861, 0x1F7DF7DF, 0x1A6AFFEF, 0x1A7DF7DA, 
	0x2EBDF69A, 0x0A2CA6DA, 0x1052095A, 0x39424425, 0x39E39E38, 0x38E38924, 0x34D38E38, 0x24D74D38, 
	0x14465950, 0x14450510, 0x25814451, 0x11911910, 0x1F6DA454, 0x0F6CF7DF, 0x0B2CF2DF, 0x1151155A, 
	0x10411410, 0x25925925, 0x24925964, 0x24960965, 0x24865825, 0x39E79965, 0x39E79E79, 0x24975E79, 
	0x39E75964, 0x20D65E65, 0x35DB6DB6, 0x15825965, 0x10955925, 0x10550465, 0x24850450, 0x14855811, 
	0x21511521, 0x15465550, 0x25925910, 0x25DBAEA9, 0x39E7DD61, 0x20861E79, 0x21861861, 0x1B9A1871, 
	0x1F7DF6DF, 0x1F7DF7DF, 0x1F7D67DF, 0x1B6DA7DF, 0x1A29B28B, 0x1191195B, 0x10911424, 0x25E38E79, 
	0x38E38410, 0x34E34E38, 0x10978D34, 0x21D76D91, 0x10410450, 0x14411910, 0x20560561, 0x1B7DB6D5, 
	0x1F7DF6DF, 0x0B3CB3CB, 0x1045668B, 0x10454411, 0x24965965, 0x25964965, 0x25829A24, 0x20964964, 
	0x39E65925, 0x39E79E79, 0x24924975, 0x25D69D25, 0x20974975, 0x25425965, 0x24560565, 0x11921521, 
	0x14454425, 0x14950511, 0x10521521, 0x15815425, 0x34925950, 0x39E79E79, 0x35E79E79, 0x39E7DE65, 
	0x21861E39, 0x21861860, 0x1F9A1861, 0x1F7DF7DF, 0x1F7DF7DF, 0x1F69A69B, 0x0E7CB69A, 0x0B28B68B, 
	0x1442499A, 0x11424450, 0x25E78924, 0x34E38510, 0x38D38D38, 0x10425A74, 0x25DB6DA5, 0x11510414, 
	0x21510454, 0x15425414, 0x1F7DF6DB, 0x0F6DFBDF, 0x0B3DF7DF, 0x1569A6DB, 0x14411410, 0x25925925, 
	0x2DA25925, 0x25A7CF7C, 0x25925825, 0x25964964, 0x35E79E79, 0x25924925, 0x35935974, 0x20925924, 
	0x25550479, 0x21525950, 0x10954955, 0x11911454, 0x11911454, 0x25464464, 0x10560550, 0x3DE79915, 
	0x39F79F79, 0x39E79E79, 0x39E79E79, 0x21861E38, 0x21861821, 0x1B9A1861, 0x1F7DF6DF, 0x1F7DFBDF, 
	0x1A6DF7DA, 0x1B29F7DA, 0x0A68B28F, 0x2045059A, 0x20511815, 0x25D65950, 0x38D38910, 0x25E34E34, 
	0x10410925, 0x36EB6DB6, 0x25865D66, 0x26955410, 0x1B550966, 0x1F2DF7DF, 0x1F7EFFEF, 0x1F7CB3DB, 
	0x1A69B6AF, 0x25414411, 0x24964965, 0x3CF78965, 0x28F2DB2D, 0x25825925, 0x24921925, 0x24925925, 
	0x24924924, 0x24964925, 0x20964925, 0x25425579, 0x14961525, 0x15961921, 0x10450521, 0x24950521, 
	0x11511911, 0x25415425, 0x3DF7DE65, 0x3DE7DE7D, 0x39E39F79, 0x38E79E79, 0x21865D38, 0x21821861, 
	0x1B9A1861, 0x1F7DF7DF, 0x1F7EFBDF, 0x1F7DF7DF, 0x0A7DF6DF, 0x1B28B29B, 0x1041499A, 0x14460550, 
	0x25D60810, 0x24E38910, 0x24974978, 0x11410410, 0x3ADBAEB5, 0x36DB6DB6, 0x3AEB6976, 0x1B6919BA, 
	0x1F7DF2DF, 0x0F6EFFFF, 0x2F2CF7DB, 0x1A2DABFF, 0x10411416, 0x24965925, 0x2CF7D925, 0x3DB7CF7C, 
	0x24964964, 0x20964965, 0x10464425, 0x24964411, 0x24924964, 0x20924D64, 0x10550979, 0x25425965, 
	0x25E79E65, 0x10950965, 0x15811415, 0x14864464, 0x39521521, 0x39F79F7D, 0x39F79F7D, 0x38E79E7D, 
	0x39E78E79, 0x21821D34, 0x21861861, 0x1A961860, 0x1F6DF6DB, 0x1FBDF7DF, 0x1B7DF7DF, 0x0B7CA7DF, 
	0x0A29B28F, 0x1446059A, 0x20415421, 0x30C34D25, 0x25925920, 0x10424924, 0x36961410, 0x3AEBADBA, 
	0x36DBAEBA, 0x36EB6DB6, 0x1F6D59BA, 0x2F7DB7DF, 0x1F7DABFF, 0x2B3DB2CA, 0x1A2DABEE, 0x2445055B, 
	0x25925965, 0x3DB3DE64, 0x2CF6CF6C, 0x25825925, 0x14964964, 0x25415925, 0x24810454, 0x35974925, 
	0x20964964, 0x2541547A, 0x39954865, 0x39E7DE7D, 0x11511979, 0x25964454, 0x11521521, 0x39E54454, 
	0x3DF7DE7D, 0x3DE7DE7D, 0x39E7DE79, 0x39E79E39, 0x21860939, 0x25865861, 0x1A861861, 0x1F7DB7DB, 
	0x1B7DF7DB, 0x0F6DF6DF, 0x0A2DF2DF, 0x1A28A6CA, 0x1052599A, 0x35810510, 0x34C34D35, 0x10420D70, 
	0x10410450, 0x3AEB6951, 0x3ADBAEB6, 0x36DB6EB6, 0x36DB6DB6, 0x1B7DA976, 0x1F7DF6CF, 0x1F7DF6DF, 
	0x0F6CF6DF, 0x0B69B69B, 0x2441169A, 0x24964965, 0x3CB7DF25, 0x29F2DB28, 0x24964964, 0x25921925, 
	0x25420560, 0x10410410, 0x24925920, 0x20924925, 0x2151193A, 0x3A925564, 0x3DE79E7D, 0x10978E79, 
	0x39E79E65, 0x14464979, 0x3DF75521, 0x3DE7DF7D, 0x3DE7DF79, 0x39E79F79, 0x39E39E79, 0x21821979, 
	0x35861861, 0x16861875, 0x1F6DF2DB, 0x1F7DB7DF, 0x1A3DF7DF, 0x1B38B68F, 0x1A6CA28B, 0x119A6696, 
	0x39D64454, 0x30D35D35, 0x10425D30, 0x25450510, 0x3AEBADB5, 0x3AEB6DBA, 0x36EB6EBA, 0x36DB6DB6, 
	0x0F6DB566, 0x1F6DF7DB, 0x0B7DF7DF, 0x1B2DF29B, 0x0A6CA6CA, 0x2541569B, 0x25965925, 0x2DF3DE64, 
	0x24964965, 0x25921925, 0x24964965, 0x20555815, 0x10415815, 0x24410410, 0x20420920, 0x1445497A, 
	0x39965825, 0x38E38F7E, 0x25E79F79, 0x3DF7DF79, 0x11829E79, 0x39F79954, 0x3DF7DE7D, 0x3DE7DE7D, 
	0x3EFBFF79, 0x38E79E39, 0x20865E79, 0x3DD61861, 0x1B9A1E79, 0x0B7CB6DF, 0x1B7DB7DB, 0x0F7CA6CE, 
	0x0A2DA3DB, 0x1A68A6CA, 0x26AAA69A, 0x35D75911, 0x34D34D35, 0x10D70C34, 0x36410411, 0x26EBAEB6, 
	0x3AEBADBA, 0x36DBAEBA, 0x36D76DB6, 0x1B7DB5B6, 0x1B7DF2DF, 0x1A6DB7DF, 0x0B7CB69B, 0x1B29B29B, 
	0x244166CA, 0x25924965, 0x38B3DA25, 0x25964964, 0x24964964, 0x21525925, 0x25420564, 0x10560550, 
	0x10410410, 0x20410410, 0x1191197A, 0x25525565, 0x39E3DF79, 0x39E39E38, 0x39E7DE7D, 0x24979F7D, 
	0x3DE7DE51, 0x39F79FBD, 0x39F79F7D, 0x3EFBEEB9, 0x39E39E7A, 0x21975E78, 0x3DFA5821, 0x1FAB9F7D, 
	0x1F6DF7DF, 0x1F28F6DF, 0x2AB9E7DB, 0x0B69F69E, 0x1B6DB69B, 0x2AA9A6DA, 0x35D35D65, 0x34D35D74, 
	0x35C30C30, 0x36D90550, 0x2197AEB6, 0x36EBAEBA, 0x36EB6850, 0x35DB6DB6, 0x0F6DB9B6, 0x1F7DB7DB, 
	0x1B7DF7DB, 0x1A69B6DF, 0x0A6CA6CB, 0x2445A29B, 0x24965925, 0x29F7DA25, 0x25425925, 0x24864964, 
	0x25964865, 0x10554864, 0x15414825, 0x10410550, 0x20410410, 0x1152197A, 0x24864964, 0x38E79FA5, 
	0x39E78E78, 0x3DF79F79, 0x25E7DE79, 0x39F79F65, 0x39F7EFBE, 0x3DE7DE7D, 0x3AEBAF79, 0x38E78E79, 
	0x21D79E79, 0x3DFB9860, 0x2AF79F79, 0x2F7DB6DB, 0x1B6CA7DB, 0x3DF7EFAE, 0x1B6DE6EA, 0x1A69F6DE, 
	0x266AA69B, 0x35D74D79, 0x34D34D74, 0x30C30D30, 0x3ADB5474, 0x3AEBADB6, 0x3AEBAEBA, 0x36EB6D76, 
	0x36DBAEBA, 0x1B2EADA5, 0x1B7DB7DB, 0x1F6DF7DF, 0x0B6CF6DF, 0x1A2DB29B, 0x2545A68B, 0x24965964, 
	0x28F2D925, 0x25921925, 0x25925921, 0x24965925, 0x24854560, 0x10951911, 0x10550424, 0x20410410, 
	0x2445497A, 0x15955865, 0x38E39F65, 0x38E38E39, 0x39F79E39, 0x39E79E7D, 0x3EF7DE79, 0x39E7EFFF, 
	0x39F79F7D, 0x39E79E79, 0x39E39E79, 0x25A78E78, 0x3DF7EA61, 0x3AE7DE7D, 0x1F6CA6DA, 0x3E79F6DF, 
	0x39E7DF7E, 0x1E69A7A9, 0x1B69B69B, 0x35A9A69A, 0x35D75D79, 0x30C34D34, 0x30D30C30, 0x36DBAD70, 
	0x35C71D76, 0x36DBAEB6, 0x36DBAEB6, 0x25DBAFBA, 0x1F6E6972, 0x1F6DF6CB, 0x1B7DB7DB, 0x1E6DF6DF, 
	0x0B68B69B, 0x2455B29A, 0x21925925, 0x2CF6C964, 0x24954965, 0x24960964, 0x25425925, 0x11911915, 
	0x15814964, 0x10410950, 0x20411410, 0x1152197A, 0x24964964, 0x38E7DE65, 0x38E39E38, 0x3DE79E79, 
	0x38E78F79, 0x3EF79F79, 0x39E7AFFE, 0x39E7DE7D, 0x39E79E7D, 0x39E79E39, 0x35E79D78, 0x3AF7EF65, 
	0x2EBAEABD, 0x1B6ABBAA, 0x3EFAA6DA, 0x38E7DFBD, 0x165962AA, 0x1A69A69A, 0x35D56596, 0x3AEB9D75, 
	0x30D34D75, 0x30C30C34, 0x34D76970, 0x30C34D30, 0x3AEB6DA1, 0x36DB6DB6, 0x359BAEBA, 0x1B6A6DB6, 
	0x1B7DB7DA, 0x1F7DF6DF, 0x36A9B7DB, 0x1B6AADB6, 0x2544A68A, 0x29965964, 0x3DB3DA29, 0x25925A28, 
	0x25925925, 0x24964864, 0x25521521, 0x20560950, 0x15815815, 0x20414410, 0x1055097A, 0x15825565, 
	0x39F79F65, 0x38E78E39, 0x39E38E38, 0x39E39E7D, 0x3EE7DE7D, 0x3DE79EBE, 0x39E79F79, 0x39E79E79, 
	0x39E39E79, 0x39E34E39, 0x2EABEFB9, 0x1F7DF7DF, 0x2ABDF7DF, 0x3DF7EAAE, 0x39E39F7E, 0x30C34D59, 
	0x16596970, 0x35E55455, 0x39EB5D75, 0x34C34D75, 0x30C30C30, 0x34D75971, 0x30D34D34, 0x3ADBADB0, 
	0x36DB6DBA, 0x31DB6DB6, 0x1B6A6C65, 0x1F6CB68B, 0x1F6DF7DB, 0x36DBA6DF, 0x1A9B6DB6, 0x2441A2DA, 
	0x3CF69A25, 0x2DF3DF7D, 0x25A6CF7C, 0x24854964, 0x15925925, 0x10854964, 0x14815925, 0x10560560, 
	0x20421410, 0x1095597E, 0x24564865, 0x38E7DE65, 0x39E38E38, 0x38E79E78, 0x39E39E79, 0x3DE7DE7D, 
	0x3DE7DE79, 0x39E39E79, 0x39E79E79, 0x38E78E79, 0x25E79D39, 0x1F7DFAB9, 0x1F7DF7DF, 0x1F7DF7DF, 
	0x3DEAAAAF, 0x39E38E7D, 0x30C34DA5, 0x25D70C30, 0x38E64455, 0x28E28E39, 0x38A38B38, 0x31D74D78, 
	0x34D65D65, 0x30C30C34, 0x36DB6D70, 0x36DB6DB6, 0x25C75DB6, 0x0B9A6972, 0x1B7DB6DA, 0x1B7DB7DB, 
	0x36DB6A9F, 0x26DB5DB6, 0x2955A69A, 0x3DF3DF7D, 0x3CB7CB3D, 0x2CF2DB3D, 0x25921969, 0x21915825, 
	0x24550464, 0x21521521, 0x21521915, 0x20515414, 0x1542597A, 0x25865925, 0x39E79E54, 0x38E79E39, 
	0x38E78E79, 0x39E79E39, 0x39F79F79, 0x39F79F7D, 0x39E79E7D, 0x39E79E79, 0x39E79E39, 0x2AD64E78, 
	0x1FBDF7DF, 0x1F7DF7DF, 0x1A7DF7DF, 0x3AAAE69F, 0x29E38E39, 0x34D35E75, 0x24C30C30, 0x2CB2CF28, 
	0x2CB2CB2C, 0x2CB2CB2C, 0x38A2CB2C, 0x349A5979, 0x30C30C30, 0x36DB6C60, 0x39DB6DB6, 0x359B6DB9, 
	0x1BAA2D66, 0x1B6DE2DB, 0x1F7DF6DF, 0x3AEB699F, 0x35D76D76, 0x3DF6A696, 0x3DF7DF3D, 0x3DF3DF7C, 
	0x3DA3CF2C, 0x24968B28, 0x15825925, 0x14864564, 0x15825925, 0x14854864, 0x20860950, 0x1081597E, 
	0x20564965, 0x38E79965, 0x24979E79, 0x39E65550, 0x39E78E78, 0x3DE7DE7D, 0x39F79F79, 0x3DE7DE7D, 
	0x39E79E79, 0x38E78E79, 0x1FAA9E35, 0x2F7EF7EF, 0x1F7DFBDF, 0x1F7DF7DF, 0x2AA9B7DF, 0x29E34E3A, 
	0x34D75D35, 0x2CF24C30, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x35979A2C, 0x20C30C20, 
	0x36DB6970, 0x3DF79DB6, 0x25CB5E79, 0x1A6A69B2, 0x1B28B69B, 0x1F6DB7DB, 0x35DB6A9F, 0x258B5D76, 
	0x3CF7DA66, 0x3CF7CF7D, 0x3CB3DF3D, 0x2CB3DB3D, 0x24A68A3C, 0x25925425, 0x24854850, 0x21911911, 
	0x21520954, 0x20915510, 0x15560A7A, 0x15925950, 0x39E65925, 0x11524E79, 0x39910415, 0x39E39E39, 
	0x39F79F79, 0x3DE7DE7D, 0x39E79F79, 0x39E79E79, 0x39E39E79, 0x1F7EBE78, 0x1FBDFBDF, 0x1ABDF7EF, 
	0x1F7DF695, 0x1A7DE6DE, 0x38E38A6A, 0x35D75D35, 0x2CB39D74, 0x3CB2CF3C, 0x2CB2CF2C, 0x2CB2CB2C, 
	0x2CB2CB2C, 0x39B2CB2C, 0x30830824, 0x36DB6C60, 0x3DF7DEB6, 0x36DB5F7D, 0x2A6E6866, 0x0F6EADA6, 
	0x1B3DB2DB, 0x36D76ADB, 0x21D65CB5, 0x3DF6CF69, 0x3DF7DF7C, 0x2DF7CF7C, 0x3CF2CF3C, 0x29A2CF2C, 
	0x24464964, 0x11911525, 0x24564864, 0x14965425, 0x20464850, 0x10465E7A, 0x25864965, 0x24964560, 
	0x21411925, 0x25950454, 0x39E39E79, 0x3DE7DE7D, 0x39F79F79, 0x39F79E79, 0x39E79E79, 0x34E78E78, 
	0x2F7DFAB9, 0x2FBEFBEF, 0x1056F7EF, 0x1B7D5410, 0x1A6DE6DF, 0x28E29AAA, 0x35E74D75, 0x3DB2CEB9, 
	0x2CB2CB3E, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x20C20D6D, 0x39DB6D60, 0x3DF7DF79, 
	0x2AAA9E7D, 0x369A6AA6, 0x1BAB6DB6, 0x1F7DF7DF, 0x25CB5A9F, 0x298B5971, 0x3CF7DF7D, 0x3CF7CF7D, 
	0x3CF7CF7D, 0x2CF7CB7C, 0x2CB28B28, 0x25911925, 0x15814854, 0x14854964, 0x10911921, 0x20911911, 
	0x21510ABE, 0x14955964, 0x11521925, 0x14454454, 0x14815411, 0x39E78E65, 0x39F79E79, 0x39E79E79, 
	0x39E79E7D, 0x39E79E79, 0x39E39E39, 0x1499F7EA, 0x1FBDFBD5, 0x1051F7EF, 0x1E7D5410, 0x1B69F69F, 
	0x38E6AA9A, 0x39D70D35, 0x2CF3DF69, 0x2CB3CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CF2CF2C, 0x2CB2CB3C, 
	0x20839F28, 0x3DE76D60, 0x29F7DFBE, 0x1F79F7AE, 0x2A79E79E, 0x1BDB6DAA, 0x2B6DF7DF, 0x36D76DB6, 
	0x3DD62976, 0x3DF3DF3D, 0x3DF7DF3D, 0x3DF3DF7C, 0x38B2CF3D, 0x2CA2CF2C, 0x10964968, 0x10950425, 
	0x25925425, 0x14864564, 0x20464950, 0x14561E7A, 0x21921911, 0x20965954, 0x25415815, 0x21950454, 
	0x39E79954, 0x3DE79F79, 0x39F79F79, 0x39E79E79, 0x38E79E79, 0x29D78E79, 0x1042ABEF, 0x2F7EFBD4, 
	0x1095FBDF, 0x1B7D5410, 0x1A7DA6DF, 0x39A6A69B, 0x3EE74D75, 0x3DF7DF7D, 0x3DF6CF2C, 0x2CB2CB2C, 
	0x38F2CB2C, 0x3DF7DF7D, 0x2CB3EF7C, 0x20A7DA6C, 0x39E76DA0, 0x1F7AEF7D, 0x0F7CF7DF, 0x0E3CF3CF, 
	0x2B9AA79E, 0x36DAB6DF, 0x35DB5DB6, 0x3CF65DA6, 0x3CF7CF7D, 0x3CF7CF7D, 0x3CF3DF3D, 0x3CB3CF6C, 
	0x28B28B28, 0x24564A6C, 0x28A28950, 0x11911525, 0x10954864, 0x20911911, 0x3AFA9EBA, 0x15954965, 
	0x25521521, 0x10464454, 0x24454415, 0x39E54825, 0x39E7DE79, 0x39E79E79, 0x39E79E79, 0x39E79E79, 
	0x2AE39E39, 0x109697DF, 0x1F7EFBD5, 0x1969FBDF, 0x1F7DF695, 0x1A6DE7DA, 0x29A9A69A, 0x3DE79D70, 
	0x3DF7DF7D, 0x2DF6CF6C, 0x2CB2DF6C, 0x3DF38B2C, 0x3DF7DF7D, 0x2CB3DF3D, 0x2AF79B2D, 0x39D76DA0, 
	0x0E7DEBB9, 0x1F3DF39F, 0x0F3DE3DF, 0x1B78E3CF, 0x36DB6A9B, 0x36DB6DB6, 0x3DF698B5, 0x3DF3DF3D, 
	0x3DF3DF7C, 0x3DF7CF7D, 0x2CE6CF3D, 0x2CA3CA3C, 0x15825A2C, 0x2DB6DA24, 0x25425924, 0x10960964, 
	0x20964454, 0x3AFFEFBA, 0x25965969, 0x11964964, 0x24454850, 0x25911411, 0x25411511, 0x39E79E79, 
	0x39E7DE7D, 0x39E79E79, 0x39E39E79, 0x2FA78E78, 0x1A55ABDF, 0x2FBEFBEF, 0x1F7EFBEF, 0x1A7DF7DF, 
	0x0B69B79F, 0x2AA9A6DA, 0x3DF69E70, 0x3DF7DF7D, 0x3DB2CB3C, 0x2CB2CB6C, 0x3DF7CB2C, 0x3DF7DF7D, 
	0x28B3DF7D, 0x3DE7DA2C, 0x3ADB5DAA, 0x1F7DF7DE, 0x1F3DF7CF, 0x0E3CF38F, 0x1E3DE38F, 0x35DB6DAA, 
	0x36EB6DB6, 0x3CF7DDA6, 0x3DF3DF3D, 0x3CF7DFBE, 0x3CF7DF3D, 0x3CB38B3C, 0x2CA2CB28, 0x24568B28, 
	0x2DF2DB6C, 0x24950564, 0x10915815, 0x20425911, 0x3AEBEFFE, 0x29EBAA7A, 0x1481597A, 0x11511525, 
	0x25454454, 0x14854864, 0x3DE7DE79, 0x39E79E79, 0x39E79E79, 0x39E79E79, 0x2FAB5E39, 0x2FBDFBDF, 
	0x2F96FBEF, 0x2F7DABEF, 0x1F69F7DF, 0x1A7CA6DB, 0x2A69A68A, 0x3DF7DA79, 0x3DF7DF7D, 0x3CF7DF7D, 
	0x2CB2CB2C, 0x3DF7DE2C, 0x3DF7DF7D, 0x3DF7DF7D, 0x3DF79F38, 0x1EEB6AB9, 0x1F3DE7DF, 0x1FBDA7DF, 
	0x0F38F7CE, 0x0A7AF7CE, 0x3697669E, 0x3EFBEFBA, 0x3DF3DE7A, 0x3DF7CF7C, 0x3DF3DFFE, 0x3DF3CF7C, 
	0x39B3CE6C, 0x28B28E2C, 0x28968A2C, 0x28A68B2D, 0x25425825, 0x10560960, 0x20964464, 0x3AFBAFBA, 
	0x3AEBAEBA, 0x21565EBA, 0x3A950950, 0x2191097A, 0x10560554, 0x39E79E79, 0x39E79E79, 0x39E79E79, 
	0x39E39E39, 0x1FBF9E78, 0x2FBEFBDF, 0x2B96BBEF, 0x1F7EAAEF, 0x1F7DF7DF, 0x0A2DA7DE, 0x2A69A29B, 
	0x3DF7DF69, 0x3DF7DF7D, 0x3DF7DF7D, 0x3CF3CF3C, 0x3DF7DF7D, 0x3DF7DF7D, 0x3DE7DF7D, 0x3DE7DF7D, 
	0x1F7B5EBD, 0x0E7DF7DE, 0x3F51055F, 0x0E3CF3DF, 0x1556ABCF, 0x3AD9A68E, 0x3EFBEFBE, 0x3DF79EBE, 
	0x3FF7DF3D, 0x3CF7DFBE, 0x38F3DF3D, 0x3EF78B3C, 0x2CA2CB3A, 0x2CA68B28, 0x10950929, 0x15921515, 
	0x10864564, 0x20911911, 0x3EEBEFFE, 0x3AEBAFBA, 0x2AEA9EBA, 0x3AFBAAA5, 0x24450A7E, 0x15415825, 
	0x39F79E65, 0x39E7DE7D, 0x39E79E79, 0x39E79E79, 0x2F7E9E39, 0x2FBDF7DF, 0x2ABEA69B, 0x1FBDFAA6, 
	0x1F6DF7EF, 0x0B68F29B, 0x2968A2CA, 0x3DF7DF7D, 0x3DF7DF7D, 0x3DF7EF7D, 0x3DF7DF7D, 0x3DF7DF7D, 
	0x3DF7DF7D, 0x3DF7DF7D, 0x39F7DE7D, 0x1E7BAF7D, 0x1F7DF7DF, 0x3F41051A, 0x0F39F7BF, 0x1043AFCE, 
	0x3EA8E6D5, 0x3EFBEFBE, 0x3DE7AFBE, 0x3EF7DF7C, 0x3DF38FBE, 0x3CF7CF7D, 0x3EFACE3D, 0x28B28E7E, 
	0x2DA2CA2C, 0x24950568, 0x25815921, 0x14950960, 0x20564950, 0x3AFBAFBA, 0x3AEBAFBE, 0x3AEBAEAA, 
	0x3EEBEEBA, 0x2551197A, 0x10950560, 0x39E79E65, 0x39E79E79, 0x39E79E79, 0x39E39E79, 0x1F7EAE78, 
	0x2FBEFBDF, 0x2F7EFBEF, 0x1F7DF7DF, 0x1F79F7DF, 0x0A2DA3DA, 0x39A5A28A, 0x3DF7DF7D, 0x3DF7DF7D, 
	0x3DF7DF7D, 0x3DF7DF7E, 0x3DF7DF7D, 0x39E68E7D, 0x3DE7DE7D, 0x3DE7DF79, 0x1FAAEE7D, 0x1F7DF79F, 
	0x3FA9041A, 0x0E38E7BF, 0x10ABFFDE, 0x2E29E250, 0x3EFBEFBE, 0x39EB9FBA, 0x3DF7CF7D, 0x3DF7DE3D, 
	0x3DF3DF7D, 0x3EEBCB38, 0x2CA2CE7A, 0x29B28B28, 0x11910854, 0x14960564, 0x10925425, 0x20815911, 
	0x3FEBEEBE, 0x3AABAEBE, 0x2AEBEFBA, 0x3AEBAEBE, 0x2485597A, 0x15415815, 0x39E79E64, 0x39E79E79, 
	0x39E79E79, 0x38E79E39, 0x1F7DFD79, 0x1FBDF7DF, 0x1FBDFBDF, 0x1F7DF7DF, 0x0B6DF6DF, 0x0B28B28F, 
	0x3DA5A2CA, 0x3DF7DF7D, 0x24510929, 0x3DFBDF79, 0x3DF7DF7D, 0x28F7DF7D, 0x14410414, 0x3DF7DF79, 
	0x3DE7DE7D, 0x1EEBEF79, 0x1F7DF7DF, 0x3EFAAA9E, 0x1B79FBEE, 0x25BBEBDE, 0x1E2CA680, 0x3EFBEFBE, 
	0x3AE7EEBE, 0x3DF7DF39, 0x3DF7DF7D, 0x3CF78F7D, 0x3AF78F3D, 0x28B28A7A, 0x29A2CA2C, 0x24951520, 
	0x25815911, 0x10560960, 0x20560964, 0x3AFBAFBA, 0x3EEBAEBE, 0x3AEBAEBA, 0x2AEAAEBA, 0x2155596A, 
	0x25960564, 0x39E79EB5, 0x39E79E79, 0x39E79E79, 0x39E78E79, 0x1F7DFFFA, 0x1F7DF7DF, 0x1F7DF7DF, 
	0x1F7DF7DF, 0x0B78F79F, 0x0A2CA3CA, 0x3DE6928A, 0x39F7DF7D, 0x10510514, 0x3DF7DA54, 0x3DF7DF7D, 
	0x1093DF7D, 0x10410410, 0x39E7CE54, 0x39F79F7D, 0x2EABDE7D, 0x1F7EF7DE, 0x2EFEFB9F, 0x1969F7AF, 
	0x2EBAA79F, 0x0A28E2AA, 0x3EFBEFBE, 0x39E7AE7E, 0x3DF7CF79, 0x38F7DF7D, 0x3DE28F7D, 0x3CA3CA38, 
	0x2CA2CE29, 0x29B28B28, 0x14854815, 0x25525825, 0x10864564, 0x20825911, 0x3EFBEEBE, 0x3AFBAFBA, 
	0x3EEBAFBA, 0x25969EBE, 0x24455565, 0x36EBA951, 0x39DB6D76, 0x39E79E79, 0x39E79E79, 0x3AE79E78, 
	0x1F7DFBEF, 0x1F7DF7DF, 0x1F7DF7DF, 0x1F7DF7DF, 0x0F2DB3DB, 0x0A2CA2CB, 0x3DF6968B, 0x24F7DF7D, 
	0x14414814, 0x3DF7D950, 0x3DF7DF7D, 0x2493DF79, 0x10410510, 0x3CF79E10, 0x39F79F79, 0x2AA7DE7D, 
	0x1F7DF7DE, 0x1F79F7DF, 0x1565F7DA, 0x1E68A7DE, 0x0E2CA39A, 0x3EFBEF9A, 0x39EB9FBA, 0x3DF39E79, 
	0x3DF7DF7C, 0x28E3DE38, 0x28F28A38, 0x28A28A3C, 0x28A2CA2C, 0x25911521, 0x14864560, 0x10521921, 
	0x00564464, 0x3AEBEFFA, 0x3AFBAEBA, 0x26AAAEAA, 0x15555565, 0x25451455, 0x35D75EA5, 0x35D75DB5, 
	0x39E79E75, 0x39E79E79, 0x3FEB8E79, 0x1F7DFBEF, 0x1F7DF7DF, 0x1F7DF7DF, 0x1B7DF7DF, 0x0A3CA7CE, 
	0x0B28B28B, 0x3DF69A8A, 0x10F7DF7E, 0x10969A65, 0x3EFBDA50, 0x3DE7DF7D, 0x1093DF3D, 0x10510410, 
	0x39E3DE00, 0x3DE7DE7D, 0x39B69F79, 0x1E7CE7DA, 0x1F7DE7DF, 0x1F69969E, 0x0B38A69A, 0x0E28E2CE, 
	0x39FBEF9A, 0x39E7AE7E, 0x3DF7CE75, 0x3CF7DF7D, 0x3DF3DF7D, 0x2CE3CF2C, 0x2CF2CA38, 0x29B28A28, 
	0x20950564, 0x21921915, 0x10950964, 0x00815911, 0x3AABAEBE, 0x259A9AAA, 0x15955565, 0x11455455, 
	0x24954450, 0x31C71D75, 0x35D7AD75, 0x39E79D75, 0x38E79E79, 0x2FFF5E39, 0x0F7EFFEF, 0x1F7DF3DF, 
	0x1F7DF7DF, 0x1F2DF7DF, 0x0B28F2CF, 0x0B28B2CA, 0x3DF69A4A, 0x10F7EF7D, 0x10525924, 0x3EFBEF64, 
	0x3CF78E3D, 0x14E39F79, 0x10410510, 0x38F78E54, 0x39E79E39, 0x29B6CA7D, 0x1F3DF3AE, 0x1E3DF78F, 
	0x0E79F7CF, 0x0E38E38E, 0x0E28E28E, 0x3AFB9F8B, 0x39E79E79, 0x3DF2DE79, 0x3DF7CF7C, 0x3CB7CF3D, 
	0x38B78B78, 0x28A38B2C, 0x28A6CA2C, 0x15925415, 0x14954960, 0x10425425, 0x00521925, 0x15965965, 
	0x15565565, 0x11451451, 0x10410411, 0x25551410, 0x31C71C75, 0x31EB6D71, 0x39E75D75, 0x39E79E79, 
	0x2FAF8E78, 0x0F6EFBEF, 0x1F7DF7DF, 0x1F7DF7DF, 0x0F7DF7DF, 0x1A965A9B, 0x0A2CB78B, 0x3EF79A4B, 
	0x39FB9F7D, 0x29914424, 0x3EFBDFBD, 0x3DF7DF7E, 0x38F7DE7C, 0x24510524, 0x3CE78E78, 0x39F79F79, 
	0x2DB28B28, 0x0F78E6A9, 0x0F7DE3DE, 0x1F3CF39E, 0x0E2CE3CE, 0x0A38A38E, 0x3DE7DA8E, 0x39E79E7A, 
	0x3DA3DD75, 0x3DF3DF6D, 0x2CF7CB7C, 0x28F2CF3D, 0x28A2CA38, 0x29B28B28, 0x20951424, 0x25825815, 
	0x10950960, 0x00854950, 0x15455555, 0x10451451, 0x10410411, 0x10410410, 0x35850411, 0x35C75C75, 
	0x35DB5C71, 0x39E75C75, 0x39E39E79, 0x2BFB5E39, 0x0F7EFBEF, 0x1F7DF3CB, 0x25BEFBEF, 0x1F7DA965, 
	0x30C34D6A, 0x0B7CA6E5, 0x3DF7DA5A, 0x39E7AE7E, 0x3DFBDF7E, 0x3EF65F7E, 0x3DE3993D, 0x3DF7D939, 
	0x39E39F79, 0x39E39E38, 0x3DE39E38, 0x28B2CB29, 0x0A39AA6D, 0x1E38F38F, 0x0E39E3CF, 0x0E38E38E, 
	0x0E28E38A, 0x39E7AB8E, 0x1A7AABB9, 0x2CB6D69E, 0x2CF6CF78, 0x3DE3DF3D, 0x3CA3DA3C, 0x2CA28B2C, 
	0x28B68A28, 0x25520551, 0x14950964, 0x10425425, 0x00521925, 0x10850461, 0x10410410, 0x10410410, 
	0x11411410, 0x35550550, 0x31C75D71, 0x35D75D71, 0x39E71D71, 0x39E78E78, 0x2FEB8D78, 0x0B7EFBEF, 
	0x1F7CF3CB, 0x35D5F7DF, 0x1B970C30, 0x30C34E75, 0x1F2DB970, 0x3EF7EE5A, 0x39F79F79, 0x3EF7EF7D, 
	0x39929FBD, 0x38A24A64, 0x39F7DE54, 0x38E7CE7D, 0x28E38E39, 0x39A78A78, 0x2CA28B28, 0x1F7ADA2C, 
	0x0F38A38E, 0x0E3CE38A, 0x0E38E38F, 0x0E38A38E, 0x1E7AAA8E, 0x0F38E3DE, 0x1E38E38E, 0x3DF3DB6D, 
	0x3CB7CB7C, 0x2CE2CF68, 0x28B28A28, 0x24A6CB28, 0x21950425, 0x24964464, 0x10521521, 0x3F525425, 
	0x10420410, 0x20420420, 0x11811811, 0x10510450, 0x35951410, 0x35D71D75, 0x3AD75C75, 0x39D31C75, 
	0x34E39E79, 0x2AE74E39, 0x1F6EFBEF, 0x1F3DF2CF, 0x35D757DF, 0x35C30C34, 0x30C30E75, 0x1F6A4C30, 
	0x2CA2CE69, 0x3DE7DE6C, 0x3DFBDF7D, 0x39E7EF7E, 0x25E7DF7D, 0x3DE7DF79, 0x39E3DE7D, 0x28A28E38, 
	0x28A28A28, 0x2C72C628, 0x1DA6CB69, 0x0A38F38A, 0x0E38E38E, 0x0E28E38E, 0x0A38E38A, 0x1F39E79E, 
	0x0E3CF38F, 0x0E38F38F, 0x2CE5D38E, 0x2CF39F3D, 0x2CA3CA3D, 0x28A28B38, 0x1592DA2C, 0x14925550, 
	0x25425921, 0x11414854, 0x00850964, 0x25815865, 0x11911951, 0x20510414, 0x11411410, 0x35950410, 
	0x35D71D75, 0x36D71C75, 0x38D71C75, 0x38E79E39, 0x35D34E74, 0x1B7DFAAA, 0x1F3CB3DB, 0x3AD35A9F, 
	0x30C30C34, 0x30C30D30, 0x29970C20, 0x28B28B39, 0x3DF6CF6C, 0x3DF7DF7D, 0x3DF7DFBD, 0x3DF7DF7D, 
	0x39F7DF7D, 0x2CE3DE3D, 0x2CB2CB28, 0x2CA2CB2C, 0x2CA28B18, 0x2DB2DA2C, 0x0E38E28E, 0x0E38A38A, 
	0x0E38E38E, 0x1E78A38E, 0x0E38F3CF, 0x0E3CE38F, 0x0F38F38F, 0x2D38E38E, 0x38B7CB78, 0x28F28F6C, 
	0x2CA2CA2C, 0x24868A68, 0x20951411, 0x21925815, 0x10425424, 0x00525425, 0x20560960, 0x10460424, 
	0x10460460, 0x10410411, 0x36950450, 0x35D75D75, 0x35D71D75, 0x39C31D75, 0x35E38E78, 0x38D38D38, 
	0x2FBDAAB4, 0x0B2CB2DF, 0x35D74D5F, 0x30C30C35, 0x30C30C30, 0x39D20830, 0x2CB2CA28, 0x3DA2CB2C, 
	0x3EF7DF79, 0x3DFBDF7D, 0x3DF7DF7D, 0x3DE7DE7D, 0x2CB2CE7D, 0x2CB2CB2C, 0x28B2CB2C, 0x2C62CA2C, 
	0x29B28B28, 0x0E28E29E, 0x0E38E38E, 0x0E38E38A, 0x0F79E38E, 0x0F3CE78E, 0x0F38F3CE, 0x0E3CE3CE, 
	0x0E38E3CE, 0x3DF3DF2D, 0x2DA3DB38, 0x28A28A38, 0x10560968, 0x25524425, 0x14950964, 0x10560561, 
	0x00464950, 0x24864465, 0x20511811, 0x10410411, 0x10450410, 0x35950411, 0x35C75D75, 0x36D75C75, 
	0x39D31C75, 0x38D78E79, 0x34D34E74, 0x2FBEBA74, 0x0F2DF7EF, 0x39D74D66, 0x30C30C34, 0x20C30C20, 
	0x39E74820, 0x2CB2CB28, 0x2CB2CB2C, 0x3DF7DF6C, 0x3DF7DF7D, 0x3DE6CB7D, 0x3DF79F79, 0x2CB2CB39, 
	0x2CB2CB2C, 0x2CB2CB2C, 0x28B2DB2C, 0x2CA2CA1C, 0x2094A399, 0x0A38A2A5, 0x0E38A38E, 0x0E3CE78E, 
	0x0E38F3CF, 0x0E3CE38F, 0x0E3CE3CE, 0x0E38E38F, 0x2DE2DA4E, 0x38B38B7C, 0x2CA2CA2C, 0x24554968, 
	0x20951511, 0x21925425, 0x10425424, 0x00511925, 0x10410820, 0x10810420, 0x10810810, 0x10411421, 
	0x35411414, 0x35D75D75, 0x3AD75C75, 0x39D70C75, 0x34E35E38, 0x34E34D39, 0x2F7EFAA5, 0x1A7DFBDF, 
	0x35D34D35, 0x30C30C35, 0x20C30830, 0x39E79820, 0x2CB2CB2C, 0x2CB2CB2C, 0x3DE7DB2C, 0x2CB3DF7D, 
	0x28B2CB2C, 0x38F79F7D, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB69B2C, 0x18618B28, 0x30C20659, 
	0x0E28E560, 0x0E38E38E, 0x0F38F39E, 0x0F3CE38E, 0x0F38F3CE, 0x0F38F38F, 0x0E38E38E, 0x3CF6D38A, 
	0x2DE2DF29, 0x29A28A28, 0x15825429, 0x14964460, 0x25425921, 0x15410950, 0x00560560, 0x10860950, 
	0x21411921, 0x10450450, 0x10450410, 0x25454411, 0x35D75C75, 0x3ADB5D75, 0x39D31C75, 0x34E78E79, 
	0x34D34E34, 0x1FBDFAF4, 0x2A7EFBEF, 0x35D34D30, 0x30C30D34, 0x30C30C30, 0x39A39A20, 0x2CB2CB2C, 
	0x2CB2CB2C, 0x39F7DB2C, 0x3DB2CB7D, 0x2CB2CB2D, 0x3DA38A28, 0x2CB2CFBE, 0x2CB2CB2C, 0x2CB2CB2C, 
	0x29B6DB6C, 0x18A2C62D, 0x30970828, 0x0A299970, 0x1E38E28E, 0x0E3CF38E, 0x0F38E3CF, 0x0E38F38E, 
	0x1FB95515, 0x0E38E38E, 0x3DB4A28E, 0x3CA7CA7C, 0x28A28B29, 0x21511929, 0x25825414, 0x10964854, 
	0x10425425, 0x00814425, 0x25815825, 0x10824450, 0x11810814, 0x10410450, 0x25410450, 0x36D71D75, 
	0x3AEB6DB5, 0x39E70D71, 0x38E39E39, 0x34D34D38, 0x2B7DBAA4, 0x2AAA596A, 0x39C30C34, 0x20C30C35, 
	0x30830C30, 0x28E68E64, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 
	0x2CB2CB3E, 0x2CB2CB2C, 0x2CB2CB2C, 0x29A6DB2C, 0x14618A2D, 0x30C20820, 0x19821860, 0x1E28E38A, 
	0x0E3CE38E, 0x0E3CF38F, 0x0E3CE3CF, 0x3E950410, 0x0E38E39F, 0x2C69A38E, 0x28F29F2D, 0x28A28A78, 
	0x14854964, 0x14950465, 0x25815921, 0x10454814, 0x00560964, 0x10960560, 0x10450921, 0x10411421, 
	0x11410420, 0x25411410, 0x35DB5D75, 0x35EBAEBA, 0x39E65C71, 0x34E39E78, 0x34934D34, 0x267EBAA5, 
	0x34C30C35, 0x35D30C30, 0x30C30C30, 0x30820C30, 0x2CA2CA34, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 
	0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x20D20A2C, 0x20A28B64, 
	0x30830820, 0x20865820, 0x0E68A795, 0x0E3CE3CE, 0x0F38F38F, 0x1A3CE3CE, 0x3FA90514, 0x0E38A3AA, 
	0x196AE28E, 0x28F6CE7C, 0x28A68A2D, 0x24560565, 0x20564411, 0x15921525, 0x10425460, 0x00415425, 
	0x10811825, 0x24420464, 0x11420410, 0x10411410, 0x25910450, 0x36D75E79, 0x31D7AEB6, 0x39D64975, 
	0x38D38E79, 0x34D34D38, 0x35A9BAA5, 0x30C30C3A, 0x35C30C30, 0x34D35D75, 0x20830834, 0x2CA28A28, 
	0x2CF7DB2C, 0x3DFBEF2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 
	0x2CB2CB2C, 0x30D7AC28, 0x20428830, 0x20C30820, 0x21860820, 0x0E29AAA0, 0x0F38F38E, 0x0F3CE3CE, 
	0x1A38F38F, 0x2EF94414, 0x0A38E2AE, 0x1ABBF28E, 0x2CA38B29, 0x29A28A38, 0x15815424, 0x15825520, 
	0x24854864, 0x15410911, 0x00520560, 0x21521911, 0x11815810, 0x10410460, 0x11410410, 0x25411410, 
	0x35D79965, 0x35D71D75, 0x39925978, 0x34E39E79, 0x35934E34, 0x35D6BAA5, 0x30C30C3A, 0x34D75D30, 
	0x35D75D35, 0x20D34D35, 0x2CA2CA28, 0x2CB3FB6C, 0x3EFBFFAC, 0x2CB2CB3E, 0x2CB2CB2C, 0x2CB2CB2C, 
	0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x28A2CB2C, 0x30D35D34, 0x20970C30, 0x30820820, 0x20960820, 
	0x0A259960, 0x0F38E38A, 0x1F39F7CF, 0x0F3CF7CE, 0x2AFE5415, 0x0E38E2AE, 0x1AFAE38A, 0x28E6CF59, 
	0x29A29A29, 0x15911925, 0x21925411, 0x20560954, 0x10414854, 0x00415425, 0x10864464, 0x10420425, 
	0x10850410, 0x10410450, 0x25410410, 0x39E64964, 0x38D79D79, 0x38965E79, 0x38E78E79, 0x24D34D38, 
	0x34D6AAA5, 0x34C30C35, 0x35D74D75, 0x35D35D75, 0x34D35D74, 0x2CB28A28, 0x2CB3EFEC, 0x2CB3EFBD, 
	0x2CB2CB2C, 0x2CB2CB3C, 0x2CB7CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CFBDB2C, 0x34D28B2C, 0x34C34EB6, 
	0x35C30D30, 0x20834D20, 0x21820820, 0x09259960, 0x0E38E28E, 0x0F7CF38F, 0x0F78F39F, 0x2EFAEA9F, 
	0x0A28E29E, 0x2EBAA28E, 0x38B28A0A, 0x24A28A2C, 0x20564454, 0x15911424, 0x24854960, 0x14450911, 
	0x00560520, 0x24421811, 0x20450850, 0x10410811, 0x10450410, 0x25411410, 0x39965965, 0x39E39E39, 
	0x25925E39, 0x34D35D35, 0x25E24D35, 0x30C75AA5, 0x35D70C75, 0x34D75D75, 0x35D35D35, 0x35D34D74, 
	0x2CA28E34, 0x2CB2CF6C, 0x2CB2CF7E, 0x3CB2CB2C, 0x2CB2CF6D, 0x2CF7EB2C, 0x2CB2CB2C, 0x2CB2CB2C, 
	0x2CB7EB2C, 0x35D34B2C, 0x34D74D75, 0x35C30C30, 0x20820975, 0x21820820, 0x09255820, 0x0F38E28A, 
	0x1E7DF3CF, 0x0E3DE7DF, 0x2EAAF78F, 0x0A28E28A, 0x2EA8A28A, 0x29F2DB5A, 0x25A2DA28, 0x14854815, 
	0x20964455, 0x15921525, 0x20411520, 0x00415815, 0x10950960, 0x10420421, 0x10411410, 0x10410410, 
	0x25410450, 0x25925965, 0x38E79E64, 0x35D75E79, 0x31C30D75, 0x24D74C30, 0x30C30995, 0x35D75C31, 
	0x35D75D75, 0x35D35D75, 0x34D75D34, 0x2CA38D74, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CF6CB2C, 0x2CB2CB2C, 
	0x2CB6DB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x35D74A2C, 0x34D35D35, 0x20D30C30, 0x20820975, 
	0x20820820, 0x09155820, 0x0F38E28A, 0x1F7CE7CE, 0x1F3DFBEF, 0x0E38E38E, 0x2AB8A38E, 0x2A68A299, 
	0x28A2864E, 0x25A28A6C, 0x21511964, 0x25425410, 0x24854854, 0x15410911, 0x00910560, 0x21420811, 
	0x10850850, 0x10410420, 0x10410411, 0x25850410, 0x25965964, 0x39D65925, 0x35D75D78, 0x30C30C70, 
	0x24D30C30, 0x30D70965, 0x35D75D70, 0x35D75D75, 0x34D75D35, 0x35D34D35, 0x28E34D34, 0x2CB2CB28, 
	0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CA2CB2C, 0x35D74D28, 
	0x30D34D7A, 0x30C30C34, 0x20825975, 0x28924820, 0x19B69A29, 0x0E38A299, 0x2F7DE3CE, 0x0F39EBEF, 
	0x0E38E38E, 0x2EFDE38A, 0x0A38966A, 0x29F2878E, 0x25A2DA28, 0x14925924, 0x11925425, 0x21520964, 
	0x10414454, 0x00411815, 0x10854864, 0x10410424, 0x10410811, 0x10410410, 0x25510410, 0x24925925, 
	0x25964965, 0x3AEB5D75, 0x31C30C35, 0x20C30C75, 0x30C30865, 0x35D75D70, 0x35E79E75, 0x35D35D75, 
	0x34D31D30, 0x28E34D34, 0x28B28A28, 0x3DF2CB2C, 0x3DF7DF7D, 0x2CB2CF3D, 0x2CB2CB2C, 0x2CB2CB2C, 
	0x28B2CB2C, 0x18B18A2C, 0x39D75D28, 0x30D35D7A, 0x20C30C34, 0x20821975, 0x2CB28A24, 0x2DB2CB2C, 
	0x0A7ADB6C, 0x1E38E38E, 0x0E7DF7AF, 0x0E38E38F, 0x2E69E38A, 0x0E28E6AE, 0x28A2D38A, 0x24A68A2C, 
	0x25964965, 0x24964964, 0x14855911, 0x14411920, 0x00510520, 0x20421421, 0x20460450, 0x10410410, 
	0x10410410, 0x25810410, 0x25964964, 0x25965925, 0x3EFFAD75, 0x30C30C75, 0x30C30C75, 0x30C30C35, 
	0x35D75935, 0x35E7AEB9, 0x31D35D35, 0x30D30D74, 0x38D34D34, 0x2CA2C628, 0x3DF7DF6C, 0x3DF7DF7D, 
	0x3CF7DF7D, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CA2CA2C, 0x39A69B18, 0x3AD75D79, 0x30D35D75, 0x30C30C34, 
	0x28920820, 0x2CB2CB2C, 0x2CB2CB2C, 0x2EB6CB2C, 0x0F38E39E, 0x0E38E3DE, 0x0E38E38E, 0x1A78E699, 
	0x0E28E79A, 0x2CE2938E, 0x2592DA28, 0x24964964, 0x11925925, 0x21520964, 0x21410454, 0x00454454, 
	0x11810950, 0x10410420, 0x10410410, 0x10410410, 0x24951410, 0x24965925, 0x35925965, 0x36FBAD75, 
	0x30C30C31, 0x30C30C30, 0x34C30C30, 0x35D64824, 0x35D79EB5, 0x34C74D75, 0x34C34C30, 0x34D34D34, 
	0x3DA18A38, 0x3DF7DF7D, 0x3DF7DF7D, 0x39F7DF7D, 0x28A28A3D, 0x28A28A28, 0x29B18B28, 0x36DB6DBA, 
	0x36DB6DB6, 0x30C34D76, 0x30830C30, 0x2CB24820, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x0E38E6AD, 
	0x0E38E38E, 0x0E38E38E, 0x1455954A, 0x0E38955A, 0x29B2838A, 0x24968A68, 0x25925925, 0x24464964, 
	0x14925425, 0x14410521, 0x00910811, 0x10421420, 0x10810811, 0x10410410, 0x10410410, 0x25950410, 
	0x25964964, 0x35965964, 0x35D75D71, 0x30C30C31, 0x30C30C30, 0x35C30C30, 0x35D75420, 0x20E75E75, 
	0x30C34820, 0x30C30C34, 0x34D34D30, 0x3DF68A34, 0x3DF7DF7D, 0x3DF7DF7D, 0x3DF7CF7C, 0x2CA3CF7D, 
	0x28728B18, 0x36EA9A18, 0x36DB6DB6, 0x36CB6DB6, 0x30D76CB2, 0x20C20C30, 0x2CB28920, 0x2CB2CB2C, 
	0x2CB2CB2C, 0x2CB2CB2C, 0x0A39AB2C, 0x0E38E38E, 0x0E38E38E, 0x0D38938E, 0x0E28E249, 0x2CA3938E, 
	0x25929B28, 0x24964964, 0x11925925, 0x14850964, 0x11410460, 0x00450554, 0x20464421, 0x11411410, 
	0x10410410, 0x10410410, 0x24911410, 0x24965925, 0x34D64965, 0x35C75C75, 0x30C30C30, 0x30C30C30, 
	0x35C20C30, 0x35D75820, 0x20835D75, 0x30C30820, 0x30C30C30, 0x34D34C34, 0x3DF7DE34, 0x3DF7DF7D, 
	0x3DF7DF7D, 0x38F7DF7D, 0x28A7DE7D, 0x28A18A28, 0x36DB6EA8, 0x36DB6DB6, 0x32DB2DB6, 0x36CB2CB2, 
	0x20820835, 0x2CB2CA20, 0x2CB2CB2C, 0x2CB2CB2C, 0x2CB2CB2C, 0x0E6ACB2C, 0x0E38E28E, 0x0E38E38E, 
	0x0E38E38E, 0x0E38E38E, 0x28A6C78E, 0x24968A68, 0x25925925, 0x24964964, 0x20564921, 0x14410915, 
	0x00510420, 0x10811810, 0x10420411, 0x10410410, 0x10410410, 0x21924410, 0x14911915, 0x35D65825, 
	0x30C31D71, 0x30C30C30, 0x30C30C30, 0x35D30830, 0x3AFBAE60, 0x10835D79, 0x30C30420, 0x30C30C30, 
	0x34D34C30, 0x3DF7DF74, 0x3DF7DF7D, 0x3DF7DF7D, 0x3DF3DF3D, 0x28E79F39, 0x29628618, 0x36DB6DBA, 
	0x32DB6DB6, 0x32CB2CB6, 0x36DB2CB2, 0x20820D76, 0x2CB2CB28, 0x2CB2CB2C, 0x2CB2CB2C, 0x1CB2CB2C, 
	0x19B6CB2C, 0x0A38E38A, 0x0E34E38E, 0x0E38E38E, 0x0E38E38E, 0x2CA2974E, 0x25925B28, 0x24964964, 
	0x25925925, 0x25925964, 0x11410464, 0x00454454, 0x10410460, 0x10410420, 0x10410410, 0x10410410, 
	0x14454450, 0x21964464, 0x30D64564, 0x30C30C30, 0x30C30C30, 0x30C30C30, 0x35D70830, 0x3EEBAFB5, 
	0x20935EBE, 0x30C30810, 0x30C30C30, 0x34D30C30, 0x3DF7DF7D, 0x3DF7EFBD, 0x3DF7DF7D, 0x3CE7CF7C, 
	0x39F79E7C, 0x3AA18628, 0x32DB6DB6, 0x36CB6CB6, 0x32CB2DB2, 0x36CB1CB2, 0x20821DB6, 0x2CB2CB28, 
	0x2CB2CB2C, 0x2CB2CB2C, 0x00518B2C, 0x29B2C714, 0x0E24E24D, 0x0E38D38D, 0x0E38E38D, 0x0E38E38E, 
	0x28B28A4E, 0x24965A29, 0x25925925, 0x24964964, 0x25925925, 0x24454964, 0x00910510, 0x10850810, 
	0x10410410, 0x10410410, 0x10410410, 0x25424410, 0x24511910, 0x31D25921, 0x30C30C30, 0x30C30C30, 
	0x20C30C30, 0x35D35970, 0x3AD75EB5, 0x35D75EBE, 0x30C30C34, 0x30C30C30, 0x39D30C30, 0x3DF7DF7D, 
	0x3DF7D929, 0x28E3DF7D, 0x39F3DF7D, 0x38E78E3C, 0x36DA8638, 0x36DB2DB6, 0x36DA2972, 0x32CB2CB2, 
	0x25410832, 0x24876D76, 0x2CB2CA2C, 0x2CB2CB2C, 0x2C600418, 0x1051CB2C, 0x29B1C500, 0x0D389349, 
	0x0E34E34A, 0x0E34E34E, 0x0E38E38D, 0x28A6CA5E, 0x25964A6C, 0x24964964, 0x25925925, 0x24964964, 
	0x25925925, 0x00415825, 0x10410411, 0x10410410, 0x10410410, 0x10410410, 0x10511410, 0x14864425, 
	0x30D65925, 0x30C30C30, 0x30C30C30, 0x30C30C30, 0x34D75D70, 0x3EC35D75, 0x35D75D7A, 0x30C30D35, 
	0x30C30C30, 0x3DD30C30, 0x29F7DF7D, 0x3DF64524, 0x10528F7D, 0x3CF7CF24, 0x39E39F39, 0x36DA9939, 
	0x25CB6CB2, 0x32860820, 0x32CB2DB6, 0x10410831, 0x28D76DBA, 0x2CB2CB18, 0x2CB3EF6C, 0x1C414514, 
	0x10618B18, 0x2DB18500, 0x0D24D259, 0x0D38938D, 0x0E38D38D, 0x0E38E38E, 0x2DB28A15, 0x24925928, 
	0x25925925, 0x24964964, 0x25925925, 0x25925964, 0x00964964, 0x10420420, 0x10410410, 0x10410410, 
	0x10410410, 0x25814454, 0x25925910, 0x30C25964, 0x30C30C30, 0x30C30C30, 0x20C20C30, 0x35D35FB4, 
	0x30D75D35, 0x35D75D75, 0x30C30C30, 0x30C30C30, 0x3DD30C30, 0x24F7DF7D, 0x3EF64424, 0x10924F7D, 
	0x38F39E14, 0x38E78E3C, 0x36DB5E38, 0x21EB6DB2, 0x36410820, 0x32CB2CB2, 0x10410832, 0x25D61EB9, 
	0x2CB2CA28, 0x2CF7EFAC, 0x28000515, 0x18F69FAD, 0x2DA1C614, 0x09349359, 0x0D34D24E, 0x0E34E34E, 
	0x1A38E38D, 0x28B6C964, 0x25825929, 0x25825921, 0x24964864, 0x25925925, 0x24964964, 0x00965925, 
	0x10410410, 0x10410410, 0x10410410, 0x11410410, 0x24560910, 0x25964965, 0x30D65965, 0x30C30C30, 
	0x30C30C30, 0x30C30830, 0x34D75FBA, 0x35D75D75, 0x30D35D75, 0x30C30C30, 0x30C30C30, 0x3DF70C30, 
	0x24F7DF7D, 0x3EF7D910, 0x14424F7E, 0x3CF3CF50, 0x39E38E38, 0x32DB1D38, 0x25EFBCB2, 0x32410421, 
	0x3ADB2DB2, 0x10410876, 0x35C71ABA, 0x2CB2CA18, 0x2CFBEB6C, 0x2C614518, 0x29B7DFBE, 0x2D728618, 
	0x0D249269, 0x0E24E349, 0x0D38D38D, 0x2478E38E, 0x2CB28915, 0x24510964, 0x14950954, 0x25825521, 
	0x24964964, 0x25925925, 0x00964964, 0x10410410, 0x10410410, 0x10410410, 0x24815410, 0x25925925, 
	0x25965964, 0x30D65965, 0x30C30C30, 0x30C30C30, 0x35820C30, 0x30D35FBE, 0x34D74D34, 0x34C35D35, 
	0x30C30C30, 0x30C30C30, 0x3DF70C30, 0x3DF7DF7D, 0x3D93EF79, 0x24938FBE, 0x38F39F38, 0x38E38E3C, 
	0x32CB1D38, 0x35FFEDB6, 0x32860420, 0x3AEBAFB6, 0x21871DBA, 0x35C62975, 0x2CB28628, 0x2DFBEB2C, 
	0x18B2CB2C, 0x28F69B69, 0x2DA18618, 0x09249269, 0x0934D24D, 0x0E34E34D, 0x2455A38E, 0x28B68A20, 
	0x25425928, 0x24814910, 0x20564964, 0x25921925, 0x24964964, 0x00925925, 0x10410410, 0x10410410, 
	0x15410410, 0x25924864, 0x25965964, 0x25D65965, 0x35965D65, 0x30C30C30, 0x24C30C30, 0x39875D60, 
	0x30D35FBE, 0x31C30C30, 0x30C30C34, 0x30C30C30, 0x30C30C30, 0x3DF74C30, 0x3DFBDF7D, 0x35E39E7D, 
	0x3DF79E7D, 0x3CE3CF7C, 0x38E38E38, 0x32CB1D38, 0x3AEFEDB2, 0x36CB6CB6, 0x3AFBAEBA, 0x32C72ABA, 
	0x31871CA1, 0x2CA18625, 0x2DFBEB2C, 0x2CB2CB2C, 0x14529A14, 0x18728728, 0x0924866D, 0x09349249, 
	0x0E34D24D, 0x2591464E, 0x2CA2CA28, 0x24928A28, 0x15911915, 0x25921520, 0x24964960, 0x25925925, 
	0x00964964, 0x10410410, 0x10410410, 0x24964550, 0x25965925, 0x25965965, 0x25965D65, 0x25D69979, 
	0x30C30C30, 0x24930C30, 0x39965920, 0x30D3AFBE, 0x30D30C30, 0x30C30C30, 0x30C30C30, 0x30C30C30, 
	0x3DE74C30, 0x3DF7DF7D, 0x3DF7DF7E, 0x3CF7DE78, 0x3CF38F3D, 0x38E38E38, 0x32CA1D34, 0x3AEB6DB2, 
	0x35CB6DB6, 0x3AEBAFBA, 0x31C7187A, 0x31861C61, 0x2CA18A25, 0x2CB6CB2C, 0x2CB2CB2C, 0x18618A2C, 
	0x2C618A18, 0x28A69A69, 0x0D259759, 0x1938D349, 0x28964964, 0x28A28B28, 0x28A28A28, 0x20954828, 
	0x24964964, 0x25925925, 0x25964964, 0x00965925, 0x21510410, 0x25964954, 0x25925925, 0x25965965, 
	0x35975975, 0x29D65965, 0x25965D65, 0x30C30D35, 0x25975C30, 0x29965965, 0x30D3EFBE, 0x30C30C30, 
	0x30C30C30, 0x30C30C30, 0x30C30C30, 0x3DF74C30, 0x3EF7DF7D, 0x3DFBDFBD, 0x3DF7DF7D, 0x38E3CE3C, 
	0x38E38E38, 0x32CB1D34, 0x3ADB6DB2, 0x31CB2DB6, 0x25EBAEB5, 0x21872C61, 0x21C61871, 0x1CA18635, 
	0x2CB2CB28, 0x2CB2CB2C, 0x2CA18B18, 0x2CB18718, 0x2AF7AFA9, 0x29F69A7E, 0x24969A69, 0x28925925, 
	0x28B28A28, 0x2CB28B2C, 0x25925968, 0x25925925, 0x24964964, 0x24925925, 0x00925965, 0x25965965, 
	0x24965965, 0x25965965, 0x25D65D65, 0x25965969, 0x35979975, 0x25975965, 0x30D35965, 0x25E74C30, 
	0x3F965975, 0x34E7EFBE, 0x30C30C30, 0x30C30C30, 0x30C30C30, 0x30C30C30, 0x3DF74C30, 0x3DF7DF7D, 
	0x3DF7EF7D, 0x3CF7DF7D, 0x38F38F3D, 0x34E38E38, 0x32CB1874, 0x36DB6DB2, 0x32CB2CB6, 0x32C61C72, 
	0x21C71C71, 0x21861C61, 0x28618921, 0x2CB2CB2C, 0x2CB2CB2C, 0x1862C62C, 0x2C62C628, 0x3EABEA69, 
	0x3EFBEFBA, 0x2596AFBE, 0x25965965, 0x28965965, 0x29A29A25, 0x24964968, 0x25965965, 0x25965925, 
	0x25964965, 0x00965924, 0x25965965, 0x25965964, 0x25D65965, 0x35A65975, 0x29D65D65, 0x25A75A65, 
	0x25D65975, 0x25965975, 0x25965965, 0x3EA65965, 0x35EBEFFE, 0x30C34D34, 0x30C30C30, 0x30C30C30, 
	0x30C30C30, 0x38F74C30, 0x3DF7DF7D, 0x3DF7DF7D, 0x39F3DF7D, 0x3CE3CE3C, 0x38E38E38, 0x32CA1C34, 
	0x32DB2CB2, 0x32CB2CB2, 0x32CB2CB2, 0x31861CB1, 0x31861861, 0x18618925, 0x2CB28B18, 0x1CA2CB2C, 
	0x28B18B28, 0x2CA1CA1C, 0x3AFB9E6D, 0x3BFBBFBE, 0x2497EEBE, 0x25925925, 0x25964964, 0x25965965, 
	0x25965965, 0x24964964, 0x24964965, 0x24965925, 0x00964965, 0x25965D65, 0x25964965, 0x35975975, 
	0x25D79969, 0x25E65975, 0x35965D79, 0x25975965, 0x35975965, 0x25D65D65, 0x3F965975, 0x39FBEFBE, 
	0x34D34D35, 0x30C34D34, 0x30C30C30, 0x30C30C30, 0x3DE34C30, 0x3DF7DF7D, 0x3DF7DF7D, 0x3CF7CF7D, 
	0x38E3CE3C, 0x34E38E38, 0x32CB1874, 0x32CB2CB2, 0x32CB2CB2, 0x21CB2CB2, 0x21C61871, 0x21861861, 
	0x18618921, 0x2CB18A18, 0x2CB28B28, 0x18A18B18, 0x2DB28728, 0x3EEBEEB9, 0x3AFBEFBF, 0x2596AEBA, 
	0x25964965, 0x25925925, 0x25925924, 0x24964964, 0x25965965, 0x25965965, 0x25925965, 0x00965925, 
	0x25965965, 0x25D65D65, 0x29D69D69, 0x25965D75, 0x35979D69, 0x25D65965, 0x35965D65, 0x25965D65, 
	0x25975965, 0x3F975965, 0x3EFBEFBE, 0x34D34D79, 0x30C30D30, 0x30C30C30, 0x30C30C30, 0x3DF79D30, 
	0x3DF7DF7C, 0x3DF7DF7D, 0x38F38F7C, 0x38E38F38, 0x34E38E38, 0x32CA1834, 0x32CB2CB2, 0x32CB2CB2, 
	0x31871C72, 0x21861C61, 0x21861861, 0x18618935, 0x2CA2C628, 0x18A1CB2C, 0x1CA1CA2C, 0x3AA6C628, 
	0x3EFBFFBE, 0x3AEBAEBA, 0x24979ABA, 0x24925925, 0x24964965, 0x24964965, 0x25965965, 0x25925925, 
	0x24965964, 0x25965925, 0x00925965, 0x35965965, 0x39979965, 0x35965D65, 0x35A75969, 0x25A75A69, 
	0x35965975, 0x25965965, 0x25D65965, 0x25D65975, 0x3F965A75, 0x3EFBEFFF, 0x35E7AFBE, 0x30D34D34, 
	0x30C30C30, 0x39E75D75, 0x39F39E79, 0x3DF7DF3D, 0x3CF7CF7D, 0x3CE3CF39, 0x38E3CE38, 0x34D38E38, 
	0x32CA1C74, 0x32CB2CB2, 0x31CB2CB2, 0x21C718B2, 0x21861871, 0x21861861, 0x18A24961, 0x18B18A18, 
	0x2CB2CA2C, 0x28B28B18, 0x3EFA9B2C, 0x3AEBEEBE, 0x29EB9EBE, 0x2596AEBA, 0x25965964, 0x24964964, 
	0x25964964, 0x25925924, 0x25965964, 0x25965925, 0x25925965, 0x00965964, 0x29D65965, 0x25D65E75, 
	0x25979965, 0x29D65E65, 0x25D65D75, 0x25975965, 0x35979975, 0x25965D65, 0x39965D65, 0x3EE65D65, 
	0x3EFFFFBE, 0x3EFBEFBE, 0x3DEBEFBE, 0x3EFBEF7A, 0x3EFBEFB9, 0x3CF7EFBE, 0x3CF7CE7D, 0x3DE3DF3D, 
	0x38F38F3C, 0x38E38E3C, 0x24E38E38, 0x328B1834, 0x32CB2CB2, 0x32CB2CB2, 0x21C61C71, 0x21861861, 
	0x31861861, 0x39A65861, 0x2DA79A79, 0x2CB2CB6C, 0x2CB2CB2C, 0x3AFB9B28, 0x3AFBAEBA, 0x3AEBAEB9, 
	0x2593AE6A, 0x24924964, 0x25925925, 0x24925925, 0x24964965, 0x24964965, 0x24964965, 0x25965965, 
	0x00965925, 0x35A75E65, 0x35965965, 0x39965E65, 0x35A75A75, 0x25965965, 0x35965D65, 0x25965D65, 
	0x25D65965, 0x25E65975, 0x3F965A75, 0x3FFBFFFE, 0x3EFBEFFF, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 
	0x3DFBEFBE, 0x3DF7DF3D, 0x3CF78F78, 0x38E3CE38, 0x38E38E38, 0x34D38E38, 0x32CB2875, 0x32CB2CB2, 
	0x21CB1CB2, 0x218718B1, 0x21861871, 0x21C61C61, 0x3AF79C72, 0x3EFBEFBE, 0x2CB2CB79, 0x28B2CB2C, 
	0x3AEB9B2C, 0x39EB9FBA, 0x3AE6AEBA, 0x2592AEB9, 0x25964964, 0x25964964, 0x25964964, 0x25925925, 
	0x25965925, 0x25965925, 0x35965925, 0x00965965, 0x25D65975, 0x25E65D65, 0x25E75979, 0x25D65D69, 
	0x25D65D65, 0x29D65975, 0x25D65965, 0x29D69D79, 0x25975E65, 0x3EA75965, 0x3EFFEFBF, 0x3FFFFFBF, 
	0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x38F3DFBE, 0x38F3DF3D, 0x3CE38F3C, 0x38E38E38, 
	0x39E34E38, 0x36DB2CB5, 0x32CB2CB2, 0x31CB2CB2, 0x21C61C62, 0x31871861, 0x328B1861, 0x3EFBEEB6, 
	0x3FFBFFBE, 0x2DE7EFBF, 0x28B28B2C, 0x39EB9A6C, 0x3AEBAEBA, 0x2AEBAE7A, 0x2493AABA, 0x24925925, 
	0x24925925, 0x25925965, 0x24964964, 0x24964965, 0x25925965, 0x25925965, 0x00965D65, 0x35965D65, 
	0x25D65D69, 0x35E65E65, 0x35979965, 0x25965965, 0x35965D65, 0x35965D65, 0x35975965, 0x25D69965, 
	0x3EE65975, 0x3EFFEFFE, 0x3EFFEFFF, 0x3FFBFFFF, 0x3EFBEFFE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 
	0x3CF7DF7D, 0x38E3CE38, 0x39E38E38, 0x39EB9E79, 0x32CB2DBA, 0x36DB6EBA, 0x328B2C76, 0x318718B1, 
	0x21C61C61, 0x3ADB1871, 0x3FFFFFBE, 0x3EFBEFBF, 0x39FBAFBA, 0x1CA2CB28, 0x3EEBAE68, 0x29EBAE7A, 
	0x3AE7AEBA, 0x1497AEB9, 0x24964960, 0x24965925, 0x24965925, 0x25925965, 0x25965964, 0x24965964, 
	0x25965925, 0x00965964, 0x35A75A65, 0x39965E65, 0x25975A75, 0x25965D65, 0x39975975, 0x25975965, 
	0x29D65965, 0x29D65A75, 0x25965D79, 0x3F965D65, 0x3FFBFFBE, 0x3FFBFFBE, 0x3FFFFFBF, 0x3FFBFFBF, 
	0x3EFBEFFF, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x36DBAFBE, 
	0x36EBAEB6, 0x36DB6DB6, 0x32CB6DB6, 0x32872872, 0x3EFB2CB1, 0x3AFBEFBE, 0x3AEBEEBE, 0x3EEBEEBE, 
	0x28B28B39, 0x39EB9A68, 0x3AEBAEBA, 0x2AEAAE7A, 0x2593AABA, 0x25925524, 0x24964964, 0x25925925, 
	0x24965924, 0x25925925, 0x25964965, 0x25965965, 0x00965965, 0x25D65D65, 0x39D65975, 0x25D65D65, 
	0x35965975, 0x25D65A65, 0x35965965, 0x35A75E65, 0x35A75965, 0x25D65965, 0x3EE65975, 0x3FFBEFFE, 
	0x3FFBFFFE, 0x3EFFEFFE, 0x3FFFFFFE, 0x3FFFFFBF, 0x3EFBEFFE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 
	0x3EFBEFBE, 0x3EFBEFBE, 0x3AFBEFBE, 0x3ADB2DB6, 0x36DB6DBA, 0x35D76D76, 0x31D75D75, 0x3AE71D76, 
	0x3EEBEEBE, 0x3EEBEEBE, 0x3AFBAFBA, 0x2C62CA7A, 0x2AEBAEA8, 0x3AE6AEBA, 0x39EBAEAA, 0x1097AE7A, 
	0x24920964, 0x25924925, 0x24964964, 0x25925965, 0x24964965, 0x35965925, 0x25D25925, 0x00965925, 
	0x35A75A75, 0x25979D69, 0x25965965, 0x25975965, 0x25975975, 0x39975975, 0x25D65D65, 0x25D65E79, 
	0x35965D65, 0x3FA75965, 0x3EFFFFBE, 0x3EFFEFBF, 0x3FFBFFBF, 0x3EFFEFBF, 0x3EFFEFFF, 0x3FFFFFFF, 
	0x3FFFFFFF, 0x3FFBFFBF, 0x3EFFEFFE, 0x3EFBFFBF, 0x3FFBFFBF, 0x3EFFEFFE, 0x32DBAFBE, 0x35DB5DB6, 
	0x32DB5DB6, 0x318B2CB2, 0x3AEA5C61, 0x3EEBEEBE, 0x3AFBAFBA, 0x3EEBAEBA, 0x2CA2CE7A, 0x3AE7AE69, 
	0x3AEBAE7A, 0x2AEA9EB9, 0x2493AABA, 0x21525925, 0x24964964, 0x25925925, 0x25925925, 0x25965964, 
	0x25925964, 0x25965965, 0x00965965, 0x29D65D65, 0x25D65A75, 0x35975979, 0x25D65965, 0x25965965, 
	0x35965D65, 0x39969D69, 0x35975965, 0x25A75965, 0x3EE65975, 0x3FFBEFBF, 0x3EFFEFFE, 0x3EFBFFBF, 
	0x3EFFEFFE, 0x3EFFEFFE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFFE, 0x3EFBEFBE, 0x3EFFEFBE, 0x3EFBEFBE, 
	0x3EFBEFBE, 0x36FBEFBF, 0x32DB2EB2, 0x32C72CB2, 0x21C61C61, 0x3AE75871, 0x39FBAFBA, 0x3EEBDEBE, 
	0x3AFBAFBA, 0x28B2CE7E, 0x39EAAE69, 0x2AE7AEBA, 0x3AE7AEBA, 0x10969EB9, 0x24964464, 0x25925910, 
	0x24964964, 0x24964965, 0x25925925, 0x24965925, 0x25964D65, 0x00965974, 0x25E69D65, 0x35A75975, 
	0x25965D65, 0x35979975, 0x25E65D65, 0x29D79979, 0x25E75975, 0x25E65975, 0x29D65D65, 0x3EAFEEB9, 
	0x3EFFEFFE, 0x3FFBFFBF, 0x3EFFEFFE, 0x3EFBFFBF, 0x3FFBFFBE, 0x3FFBFFFE, 0x3FFBFFBF, 0x3EFFEFBE, 
	0x3EFBEFFE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3AFBEFBE, 0x32CB2CB2, 0x31871CB2, 0x31861C61, 
	0x39EB9C61, 0x3EEBEE7E, 0x39EBAFBA, 0x3AEBAEBE, 0x2CB28EBA, 0x3AEB9EA9, 0x3AEAAE6A, 0x3AABAE7A, 
	0x24925EAA, 0x24960925, 0x24824965, 0x24964964, 0x25965925, 0x24964965, 0x25964965, 0x25925964, 
	0x00965D65, 0x35975A79, 0x25D65E65, 0x35965975, 0x25965D69, 0x25D65A65, 0x25A75975, 0x25979A75, 
	0x35975969, 0x3AEB9E65, 0x3E6EAFBA, 0x3FFBFFBF, 0x3EFFEFFE, 0x3EFBEFBF, 0x3EEBEFBE, 0x3EFFEFFF, 
	0x3EFFEFBF, 0x3EFBEFFE, 0x3EFBEFFE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EEBEFBE, 0x3EEBEEBE, 0x3EFBAFBA, 
	0x31C72DB2, 0x20C60831, 0x21C60820, 0x3AE79976, 0x3AFBAFBA, 0x3EEBEEBE, 0x3AFBAEBA, 0x2CB2CEBE, 
	0x3AABAE69, 0x2AE7AEB9, 0x3AE6AEB9, 0x38E28EB9, 0x38925E38, 0x24964E78, 0x25925925, 0x24964964, 
	0x25925925, 0x24965925, 0x25D64965, 0x00965965, 0x25E65D65, 0x25A75979, 0x25E75965, 0x25D65965, 
	0x25E65D75, 0x39D65E69, 0x35965D65, 0x38F65D65, 0x39F79F79, 0x3E6DBABD, 0x3EFFEFBE, 0x3FFBFFBF, 
	0x3EFFEFFE, 0x3EFBAFBF, 0x3FFBFFBE, 0x3FFBEFFE, 0x3EFFEFBE, 0x3EFBEFBE, 0x3EEBEFBE, 0x3AFBEEBE, 
	0x3EFBAFBE, 0x3EFBEFBA, 0x3AFBEFBE, 0x31CBAEB6, 0x20821C20, 0x31861831, 0x3AEB9D76, 0x3DEBAEBD, 
	0x3AFB9EBA, 0x3AEBAFBA, 0x2CA2CEB9, 0x3AE6AE69, 0x3AAB9EAA, 0x2AEBAABA, 0x28E38EBA, 0x38E38E38, 
	0x25929E79, 0x25925924, 0x25925925, 0x24965965, 0x25925965, 0x24965925, 0x00D65935, 0x39975A75, 
	0x25D65E65, 0x35965A75, 0x35A65D65, 0x39975969, 0x35969D65, 0x25975969, 0x3CF79A75, 0x39E7DE38, 
	0x3B6DBAB9, 0x3FFBFFBE, 0x3EFFEFFE, 0x3EFBFFBE, 0x3FFBAFBE, 0x3FFBFFBF, 0x3EFBFFBE, 0x3FFBEFBF, 
	0x3EFBFFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3AFBAFBE, 0x3EFBEEBE, 0x31CBAEB2, 0x20871C61, 
	0x21871860, 0x3AE79D65, 0x3AFB9FBA, 0x3EEBEEBE, 0x3EEBEEBA, 0x28B2CEBA, 0x39EBAE69, 0x3AE7AABA, 
	0x39EB9EB9, 0x38D24EAA, 0x38E38E24, 0x20938E78, 0x24964925, 0x24965964, 0x25965925, 0x24965924, 
	0x25964965, 0x00965965, 0x25E65D65, 0x39975975, 0x29D65D65, 0x39975A75, 0x25E69D65, 0x25E75A75, 
	0x39D65975, 0x3DE7DEBA, 0x39F38E3D, 0x2F69B6EA, 0x3EFFEFFA, 0x3EFFEFBF, 0x3EFFEFFF, 0x3EFFEFBE, 
	0x3EFFEFFE, 0x3FFBFFBF, 0x3EFBFFBE, 0x3FFBEFBE, 0x3AFBAFBE, 0x3EFBAFBE, 0x3EFBEEBE, 0x3EFBEFBA, 
	0x3EEBEFBE, 0x31C76EB6, 0x21C61C71, 0x31861830, 0x3AE79971, 0x3AEBEEB9, 0x39EBAFB9, 0x3AEBAEBE, 
	0x2CB28EBE, 0x2AEA9E69, 0x3AE69EB9, 0x3AABAEAA, 0x28934EB9, 0x38E38A34, 0x24969E39, 0x24925925, 
	0x25924925, 0x25925964, 0x25964965, 0x24965964, 0x00965925, 0x25979979, 0x25E65D65, 0x35A75975, 
	0x25E65D65, 0x35975A75, 0x25965D69, 0x3FFBAD65, 0x3CF7DFBE, 0x3AE79F39, 0x2A6DAAFA, 0x3EFFEFBF, 
	0x3FFBFFBF, 0x3EFBEFBE, 0x3EFBEEBE, 0x3FFBFFBF, 0x3EFBEFFE, 0x3FFBEFFE, 0x3EFBEFBE, 0x3EFBEEBE, 
	0x3AFBEFBE, 0x3AFBEFBE, 0x3EEBEFBE, 0x3EFBAFBA, 0x31CB6DB2, 0x308718B1, 0x21C61820, 0x39E79971, 
	0x3AFB9FBA, 0x3EEBAEBE, 0x3EEBDEBA, 0x2CB2CEBA, 0x39EBAE69, 0x3AEB9EBA, 0x3AE6AE7A, 0x34924E6A, 
	0x39E38E24, 0x25924E38, 0x25924960, 0x24965925, 0x25964965, 0x24965964, 0x25925965, 0x00965965, 
	0x35D65D65, 0x35969D69, 0x25D69D69, 0x39979A79, 0x25E69D65, 0x35D65975, 0x3AEBEFB9, 0x39F79FBA, 
	0x37AAEE7D, 0x2A2D6DBB, 0x3FFBFFBF, 0x3EFFEFFE, 0x3EFFFFBF, 0x3FFFEDB6, 0x3EFFEFFE, 0x3FFBFFBF, 
	0x3EFBEFBE, 0x3AFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EEBEFBE, 0x3AFBEEBE, 0x3AEBEEBE, 0x21C71CB6, 
	0x20C21C71, 0x31C61C21, 0x3AE79976, 0x3EEBAE7E, 0x3AFB9FBA, 0x3AEBAFBA, 0x28B29EB9, 0x2AE6AE69, 
	0x39AB9A7A, 0x2AEBAEAA, 0x28D24E79, 0x38E28E38, 0x24965E39, 0x24965925, 0x25924964, 0x25925964, 
	0x25964965, 0x25964964, 0x00964964, 0x35A75965, 0x39975965, 0x25E65E65, 0x25E65D75, 0x25975979, 
	0x3EE69D65, 0x3FFBBFBB, 0x3DF7DEBE, 0x1B6DB6F9, 0x2A9AA6DB, 0x3FFBFFBF, 0x3EFFEFFE, 0x3EFFEFBF, 
	0x3FFBEDBB, 0x3FFBEFFE, 0x3EFFEFBE, 0x3EFFEFBF, 0x3EFBFFBE, 0x3EFBEFBE, 0x3EFBEEBE, 0x3EFBEFBA, 
	0x3EEBAFBE, 0x3EFBAFBA, 0x31C71CBA, 0x31871C61, 0x21870860, 0x39E79D71, 0x3AE7AFBA, 0x3EEBEEB9, 
	0x3EEBEEBA, 0x28B3AEBA, 0x39EBAE79, 0x3AEBAEBA, 0x3AEA9EB9, 0x24924E6A, 0x38E38E24, 0x24964E39, 
	0x25924965, 0x25925964, 0x24965924, 0x25965965, 0x25965965, 0x00965965, 0x25D65E75, 0x25E65E75, 
	0x39975975, 0x35979979, 0x29D65E65, 0x3EEFAA75, 0x3AFBAFBA, 0x3AE7DFBB, 0x1B6DB6EA, 0x3A6DB6DB, 
	0x3EFFEFFE, 0x3FFBFFBF, 0x3FFBFFFE, 0x3EFFECBE, 0x3EFFFFBF, 0x3EFBEFFE, 0x3EFBEFFE, 0x3EEBEFBE, 
	0x3EFBAFBE, 0x3EFBEFBE, 0x3AFBEFBE, 0x3AFBEEBA, 0x3EEBEEBE, 0x35C72EBE, 0x21C71875, 0x31C61C71, 
	0x3AE79E65, 0x3EEBEE7A, 0x39EBAFBA, 0x3AEB9EBE, 0x39EBAEBE, 0x2AEA9EAA, 0x3AE6AE7A, 0x39EBAEAA, 
	0x24D24A7A, 0x38A38938, 0x25929E78, 0x24965924, 0x24964925, 0x25925925, 0x24964964, 0x24964965, 
	0x00965925, 0x25975965, 0x39979979, 0x39E79E65, 0x29D79D65, 0x25965979, 0x3AFBEEB9, 0x3FEBFEBF, 
	0x36ABAFBE, 0x1B6DB6EB, 0x1B6DB6DB, 0x3FFBEFBF, 0x3EFFEFFE, 0x3EFFEFBF, 0x3EFFECBF, 0x3EFBFFBF, 
	0x3FFBFFBF, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EEBEFBE, 0x3AEBEEBE, 0x3EEBEFBE, 0x3EFBAFBE, 
	0x3AEBEFBA, 0x21C61D75, 0x25D65871, 0x3AE79E79, 0x3AE7AFB9, 0x3EEB9EBE, 0x39FBAEBA, 0x3AEBAEBA, 
	0x3AEBAE7A, 0x2AEBAEB9, 0x3AA7AE7A, 0x24924D2A, 0x38E28D24, 0x25AA9A78, 0x24964965, 0x24965925, 
	0x25925925, 0x25965925, 0x25975975, 0x00965964, 0x39979975, 0x25D75975, 0x25D65D79, 0x35A75A75, 
	0x3AD79D65, 0x3EEFAFFE, 0x3AFBAFBA, 0x1B6FBFFA, 0x1B6DB6DB, 0x1B2DB2DB, 0x3EFFEEAA, 0x3FFBFFBF, 
	0x3FFBFFFE, 0x3FFBACBE, 0x3FFFEFFE, 0x3EFBEFBE, 0x3FFBEFFE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEEBE, 
	0x3EEBEFBE, 0x3AFBEEBE, 0x3AEBEEBE, 0x3AFBAEBE, 0x31871D7A, 0x39E79CA1, 0x3AEBAE79, 0x3AFBAEBE, 
	0x3AFBAFB9, 0x3AEBAFBA, 0x3AEB9EBA, 0x3AE7AEB9, 0x3AE7AEAA, 0x3AEAAE7A, 0x24924939, 0x28D38938, 
	0x3AEBAA79, 0x25965925, 0x25924964, 0x24964964, 0x25925965, 0x35965964, 0x00964965, 0x25E65D65, 
	0x39E69D79, 0x39979E65, 0x29D65E75, 0x3EEA5975, 0x3EEBEFBA, 0x3FFBBFBB, 0x1B6EBFBA, 0x1B6BAADB, 
	0x2A68B69B, 0x3EEBAEAA, 0x3FFBFFBF, 0x3FFBFFBF, 0x3EFFADBF, 0x3EFBFFBF, 0x3FFBFFBF, 0x3EFBEFBE, 
	0x3EFBEFBE, 0x3EFBEFBE, 0x3AFBEFBE, 0x3AFBAFBE, 0x3EFBAFBE, 0x3EFBEFBA, 0x3AFBAFBA, 0x21C72EBE, 
	0x3AE79971, 0x39EB9EB9, 0x3EEB9FBA, 0x3EE7EEBA, 0x3AEBAE7A, 0x3AEBAEBA, 0x39EAAE7A, 0x3AEAAE7A, 
	0x2AE7AE6A, 0x24924939, 0x39E69E24, 0x2AEAAEAA, 0x2592593A, 0x24965925, 0x25925925, 0x25964964, 
	0x24975925, 0x00925D65, 0x29D79A75, 0x25D79975, 0x29D79975, 0x35979979, 0x3BFBAE65, 0x3AFFAEFE, 
	0x3EEBEEBE, 0x1B6DBFBB, 0x1A5A1D9B, 0x3669B2CB, 0x3EEB9EA2, 0x3EFFEFFE, 0x3EFFEFFE, 0x3EFFACBE, 
	0x3FFBFFBF, 0x3EFBEFFE, 0x3EFBFFBE, 0x3EFBEFBE, 0x3EEBEFBE, 0x3EFBEFBE, 0x3EEBEFBE, 0x3EEBEFBA, 
	0x3AFBAFBE, 0x3EEBEEBE, 0x31C72A7A, 0x3AE69D66, 0x3EEBEEBA, 0x3EEBEEBA, 0x3AEBAF7A, 0x39FBAFBA, 
	0x3AE7AEBA, 0x3AEB9EBA, 0x3AEBAEBA, 0x3AEBAEB9, 0x25924829, 0x3AA69A69, 0x2AEAAEA9, 0x2496497A, 
	0x25925965, 0x24964964, 0x24965925, 0x35964965, 0x00975965, 0x35A75979, 0x35975E79, 0x35A75E69, 
	0x39975975, 0x3EEFEE65, 0x3EEBEEBE, 0x3BFBBFBB, 0x1B6DBFBE, 0x072D669B, 0x2A6AAA9B, 0x3AE75AA6, 
	0x3FFBFFBF, 0x3FFBFFBF, 0x3FFB6DBA, 0x3EFFEFFE, 0x3EFFEFBF, 0x3EFBEFBF, 0x3EFBEFBE, 0x3EFBEFBE, 
	0x3EFBAFBE, 0x3EEBEFBA, 0x3AFBAFBE, 0x3EEBEEBE, 0x3AFBAFBA, 0x22C76EBA, 0x3EEB9E71, 0x3AFBAFBA, 
	0x3AFBAFBA, 0x3AFBAEB9, 0x3AEBAEBD, 0x3AEBAE7A, 0x3AEBAEB9, 0x39EB9EB9, 0x29E6AEBA, 0x29965925, 
	0x29EA9E69, 0x3AABAABA, 0x25925EAA, 0x25964965, 0x24964964, 0x25925925, 0x24965975, 0x00965925, 
	0x35E65E65, 0x29E79965, 0x25D69E75, 0x25D69D69, 0x3AFBBFB9, 0x3AFFAFBB, 0x3EEBEEBE, 0x1A6DBFFA, 
	0x0A58B1DB, 0x1A5B6DB6, 0x3EE75A9A, 0x3EFFEFFE, 0x3FFFEFFE, 0x3EFF5DBE, 0x3FFBFFBF, 0x3EFBFFBE, 
	0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3AFBAFBE, 0x3EFBEEBE, 0x3AFBEFBA, 0x3EEBEEBE, 
	0x31CB6FBA, 0x3AEBAE72, 0x3EEBEEBE, 0x3DEB9FB9, 0x39EB9FBA, 0x3AEB9EBA, 0x3AEBAEBA, 0x39EB9EBA, 
	0x3AEBAEBA, 0x25A7AE7A, 0x29A65965, 0x2AA6AA65, 0x3AABAABA, 0x24965EBE, 0x24965925, 0x25925925, 
	0x24964964, 0x25975925, 0x00975975, 0x39979975, 0x39D65E75, 0x35A75979, 0x35A75A75, 0x3EEBEFFA, 
	0x3AFBAFBA, 0x3FEBFEBF, 0x176DBEBE, 0x071CA5CA, 0x066E6D9A, 0x3AE6559A, 0x31D7AFBE, 0x3FFBEEB5, 
	0x3FFBAD7F, 0x3EFFEFFE, 0x3EFFEFBF, 0x3EFBEFBF, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EEBEFBA, 0x3EEBEFBE, 
	0x3EFBAFBE, 0x3EFBAEBE, 0x3AFBAFBA, 0x31CB6EBA, 0x3AFBAE75, 0x3AFBAFBA, 0x3AE7EEBE, 0x3EE7EEB9, 
	0x39EBEEBA, 0x39EB9EBA, 0x3AEB9EBA, 0x2AE7AE7A, 0x25E69E7A, 0x29969964, 0x3AAB9A69, 0x2AEAAEAA, 
	0x25965FBA, 0x25D65965, 0x24965925, 0x25925925, 0x25964964, 0x00965925, 0x25D75E69, 0x25E79975, 
	0x39975A65, 0x25D69D65, 0x3BFBBFBA, 0x3EEBFEBE, 0x3AFBAFBA, 0x1B6F9F7A, 0x066876D7, 0x0B68B6DB, 
	0x3AE66686, 0x30C71DBE, 0x3EEB9D70, 0x3EFFEFBF, 0x3FFBFFBF, 0x3EFBEFFE, 0x3EFBFFBE, 0x3EFBEFBE, 
	0x3EFBEFBE, 0x3EFBEFBE, 0x3AFBEFBA, 0x3EEBEFBA, 0x3AEBEFBA, 0x3AEBEEBE, 0x32CBAEBE, 0x3AEB9EB5, 
	0x3DEBEEBE, 0x29FA9E7A, 0x3AA7AA79, 0x3AEB9EA9, 0x3AEBAEBA, 0x39EB9EB9, 0x3AEBAEBA, 0x24975979, 
	0x29E69965, 0x3AEBAA7A, 0x3EEBAABE, 0x24929EAA, 0x25925925, 0x25924975, 0x25964965, 0x34965925, 
	0x00975965, 0x35A65D75, 0x25979E69, 0x35E65D79, 0x25D65E65, 0x3EEBEFFE, 0x3BFBAFBA, 0x3EEFEEFE, 
	0x16E7DF7D, 0x2B6C619A, 0x062DA2DB, 0x3AAA518A, 0x30D71C76, 0x3AE75C30, 0x3FFBFFBA, 0x3EFFEFFE, 
	0x3EFFEFBF, 0x3EFBEFBF, 0x3EFBEEBA, 0x3EFBEFBE, 0x3EFBEEBE, 0x3EEBEFBE, 0x3AFBAFBE, 0x3EFBAFBE, 
	0x3EEBAFBA, 0x32CBAEBA, 0x3EFBAE75, 0x2AE7AFBA, 0x29A79A79, 0x39E79E69, 0x39EAAE7A, 0x3AE7AE7A, 
	0x3AE79EBA, 0x29E6AE7A, 0x25925965, 0x3AEB9A69, 0x3EEBEEBA, 0x2AFBAEBA, 0x25965FBA, 0x35965964, 
	0x24965D65, 0x24965925, 0x25925964, 0x00964D65, 0x39D75E65, 0x39D65979, 0x25979D65, 0x35A75979, 
	0x3AFBAFFE, 0x3EEBEEFE, 0x3AFBAFBA, 0x2AE3CF7D, 0x1B6DB6DB, 0x0A1866CA, 0x2AE56586, 0x30D75D75, 
	0x39D30C30, 0x3EFFEFBA, 0x3FFBFFBF, 0x3EFBFFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EEBEFBE, 
	0x3AFBEEBE, 0x3EFBEEBE, 0x3AEBEEBA, 0x3AFBAEBA, 0x31CBAE7A, 0x3AEBAEB5, 0x39B79E7E, 0x28A18A29, 
	0x29A68628, 0x3AEB9AB9, 0x3AEBAEBA, 0x2AEBAEB9, 0x35979E79, 0x29964D64, 0x3DEB9A79, 0x3AABAF7A, 
	0x3AFAAFAA, 0x24925ABE, 0x29D64965, 0x25979965, 0x25925964, 0x25925925, 0x00965964, 0x25A79A75, 
	0x25D69D65, 0x39D79979, 0x25D65D65, 0x3FEBFFFE, 0x3AFBAFBA, 0x3EEBFEBF, 0x2BE7DE7E, 0x0B6CB6DB, 
	0x0618B29B, 0x35955186, 0x30C35D75, 0x34C30C30, 0x3EFFEEB9, 0x3EFBFFBF, 0x3EFBEFBF, 0x3EFBEFBE, 
	0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EEBAFBA, 0x3AFBAEBE, 0x39EBAEBE, 0x32CB9EBA, 
	0x3EEBEE75, 0x28A79BBA, 0x2CB2CA18, 0x28A28A2C, 0x39A79E69, 0x3AE7AE7A, 0x29E7AA7A, 0x25939979, 
	0x39A65935, 0x3AA79E69, 0x3EEBEEAA, 0x3BFBAFBA, 0x25925EBA, 0x35965964, 0x25D65D69, 0x24965925, 
	0x24964965, 0x00975925, 0x24979D69, 0x35A75979, 0x25E65D69, 0x35A75A75, 0x3EFFEFFA, 0x3AFFAFBA, 
	0x3FEBEEBE, 0x1AFBEFFA, 0x0768B69B, 0x061861CA, 0x31D55186, 0x30D71C35, 0x34C30C30, 0x3FFBAEB5, 
	0x3FFFEFFE, 0x3EFFEFFE, 0x3EFBEFFE, 0x3EFFEFBF, 0x3EFBEFBE, 0x3EFBEFBA, 0x3EFBAFBE, 0x3AFBEEBE, 
	0x3AEBAFBA, 0x3AEB9EBA, 0x31CBAE79, 0x3AE7AE75, 0x28629E79, 0x2CB2CB2C, 0x28B2CB2C, 0x2AE69A68, 
	0x39EB9AB9, 0x24969E7A, 0x24D65E65, 0x39A79964, 0x3AEAAEAA, 0x3ABBAABE, 0x2EEBFEBE, 0x24924A7A, 
	0x25925925, 0x39979965, 0x25964975, 0x25965925, 0x00964965, 0x39964979, 0x25D69D65, 0x25975975, 
	0x35975975, 0x3AFFFFA9, 0x3EEBEEFE, 0x3AFFAFFA, 0x1BFFAFBE, 0x0A1DB1DB, 0x06186187, 0x30C25186, 
	0x30D75C35, 0x30C30C30, 0x3EFBAE74, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBEFBE, 
	0x3AFBEFBE, 0x3EFBEFBE, 0x3AEBEEBA, 0x39EBAEBE, 0x39EBAD64, 0x32CA5E7A, 0x29E69E65, 0x2CA18A79, 
	0x2CB2CB2C, 0x2CA2CB2C, 0x39E79A69, 0x39ABAE7A, 0x25D25969, 0x25924E75, 0x2AEA9E69, 0x2EEBEABA, 
	0x3EEBEFBA, 0x3AFBAFFE, 0x2582596A, 0x35965964, 0x35965E65, 0x25965D65, 0x34975975, 0x00965D65, 
	0x35D75965, 0x39975A75, 0x35E65E65, 0x25D65E65, 0x3FFBFFA5, 0x3AFBAFBA, 0x3EEBEEBF, 0x2AEBFEBB, 
	0x0728669B, 0x06186186, 0x35C30556, 0x30C30C30, 0x30C30C30, 0x3AFB9D74, 0x3EFBFFBE, 0x3EFBEFBF, 
	0x3FFBEFBE, 0x3EFBFFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x3AFBEFBE, 0x3EEBAFBE, 0x35C35E7A, 0x39E74D75, 
	0x21861865, 0x29E69C61, 0x2CB28A39, 0x2CB2CB2C, 0x2CB2CB2C, 0x39A69A6D, 0x25D69E69, 0x35974935, 
	0x39A65929, 0x3AABAAB9, 0x3AFBAFBA, 0x3BFBFEBE, 0x2AEAEEBE, 0x24524929, 0x25925925, 0x25E75979, 
	0x24D79979, 0x25965925, 0x00965925, 0x25E65E75, 0x25D65D75, 0x35979D75, 0x35D69D65, 0x3FFFFE75, 
	0x3AFBBFBF, 0x3EEBFEBE, 0x3AFFAFFE, 0x161D66D7, 0x16586586, 0x30C30855, 0x30C30C30, 0x30C30C30, 
	0x3EEB9D30, 0x3EFBEFBA, 0x3EFBFFBE, 0x3EFBFFBF, 0x3FFBEFBE, 0x3EFBEFBE, 0x3EFBAFBE, 0x3AFBEEBE, 
	0x35EBEEBA, 0x3AEB5D70, 0x21E70D7A, 0x21C61871, 0x29971871, 0x2DB28628, 0x2CB2CB3E, 0x18B28B2C, 
	0x25E69A6D, 0x25924D65, 0x25E65D65, 0x3AA79979, 0x2EEBAEAA, 0x3EFBAFBA, 0x3EFBAFBB, 0x39ABAEBB, 
	0x24960560, 0x25964964, 0x29D65D64, 0x35E65D75, 0x35E65D65, 0x00964D65, 0x39975E65, 0x35E65E65, 
	0x25E65979, 0x39964D79, 0x3EFFA965, 0x3EEFEFFF, 0x3BFBAFBB, 0x3EEBEEBA, 0x165965EA, 0x16596596, 
	0x30C30C55, 0x30C30C30, 0x30C30C30, 0x3AFBFEB0, 0x3AFBAEBA, 0x3FFBEFBE, 0x3EFBAD79, 0x3EFBFFBF, 
	0x3EFBFFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x35D35EBE, 0x39E7AE75, 0x31C30D79, 0x31861861, 0x24C61C61, 
	0x2CA18A28, 0x2CB2CB6D, 0x2CA2CB2C, 0x24928B18, 0x38964964, 0x3DE64935, 0x3AEA9EBE, 0x3AEBEABA, 
	0x3AFFEEBE, 0x3EEFEFFE, 0x15A7AABA, 0x24924924, 0x25D25925, 0x25D69975, 0x25979979, 0x25935979, 
	0x00975979, 0x25E65D79, 0x25E75975, 0x39979D65, 0x25D75975, 0x3FEB5E75, 0x3FFBFFBF, 0x3EEFEEBE, 
	0x3AFFAFFE, 0x165DAEAB, 0x25556596, 0x30C30C25, 0x30C30C30, 0x30C30C30, 0x3AFBAFFA, 0x3EEBEEBA, 
	0x3EFBEEBE, 0x3FEBDEBE, 0x3EFBEFBE, 0x3EEBEFBF, 0x3EFBEFBE, 0x3AEBEFBE, 0x35D75D7A, 0x36D75E79, 
	0x21C30D75, 0x21C65D61, 0x25871872, 0x2CB18614, 0x2CB2DFAD, 0x18B28B2C, 0x25929A2C, 0x24925E64, 
	0x3AA79A65, 0x2AEBAEBA, 0x3EEBAFBA, 0x3EEBFFBA, 0x3AABEEBF, 0x20925E6A, 0x25911920, 0x35964964, 
	0x39975A65, 0x39D65E65, 0x35965E65, 0x00965E65, 0x35D79975, 0x35979D69, 0x25E75979, 0x39D69D65, 
	0x3AA75979, 0x3FFFFFFE, 0x3BFBAFFA, 0x3FEBFFBA, 0x2AEBAFFA, 0x259659AA, 0x30C30C25, 0x30C30C30, 
	0x3EC30C30, 0x3AEBEFBF, 0x39E79EBA, 0x3EEBEFBA, 0x3EEBEFBE, 0x3EFBEFFE, 0x3FFBEFBE, 0x3AFBEFBE, 
	0x3EEBEEBE, 0x3AE79D70, 0x39D75D75, 0x20C30C79, 0x32C65AB1, 0x21861C61, 0x28A18624, 0x28B2DB6C, 
	0x1CA1CA2C, 0x25928628, 0x29964A64, 0x3AEAAEB9, 0x3AFBAFBA, 0x3EFBEEBE, 0x3FFBEEBF, 0x29EBAABA, 
	0x14814979, 0x24964525, 0x24965924, 0x25E65D79, 0x35979975, 0x25D79979, 0x00E65D65, 0x25E65D75, 
	0x35A75979, 0x35965E65, 0x35A75975, 0x25D65E75, 0x3FFBFFB9, 0x3EEBFFFF, 0x3AEBEEBF, 0x3BEBFABF, 
	0x3AFBBFBA, 0x30C30C7A, 0x30C30C30, 0x3FEB0C30, 0x3AFBEEFE, 0x39EBAEBA, 0x3AFB9E79, 0x3EFBEFBE, 
	0x3EFBFFBE, 0x3EFBEFBE, 0x3EFBEFBE, 0x35FBEFBE, 0x35D75D75, 0x3AD75C30, 0x20C30C35, 0x21871860, 
	0x21871871, 0x18618525, 0x2CB2CA2C, 0x28728B18, 0x24929A1C, 0x3AE79965, 0x3AFBAEAA, 0x3EEBEEAA, 
	0x3AFBAFBA, 0x2AEBAFFE, 0x25EA9EBA, 0x20520414, 0x25924854, 0x25965925, 0x29D65D65, 0x25A75A75, 
	0x35E65D75, 0x00975965, 0x35D79979, 0x35975E65, 0x35975979, 0x39D79D69, 0x35979D69, 0x3EFFA965, 
	0x3FFFFFBF, 0x3EFFAFFA, 0x3AFFAFFA, 0x3EEFEEBF, 0x30C30EBA, 0x30C30C30, 0x3AFFAC30, 0x3EEBEFBF, 
	0x35EBAEBA, 0x3DE75D74, 0x3AEBAE7A, 0x3EFBEFBE, 0x3EFBEFBE, 0x3EFBAFBE, 0x30FBAFBA, 0x30D75D75, 
	0x3AD75E75, 0x20C30D35, 0x21861820, 0x21861861, 0x18618521, 0x18B28728, 0x1CA1CA2C, 0x29968628, 
	0x3AABAA79, 0x3AEBAEBA, 0x3AFBAFBE, 0x3FEBFFBE, 0x3AEAEEBE, 0x20929EA9, 0x24814910, 0x24960524, 
	0x25D25924, 0x35979974, 0x35D65D65, 0x29D69D69, 0x00965E75, 0x25975D65, 0x39E65D79, 0x29D69D65, 
	0x29D65E75, 0x24D65D75, 0x3A965D25, 0x3EFFFFFF, 0x3AFBFFBF, 0x3EEBEEBF, 0x3AEBBEBA, 0x30D7AEBE, 
	0x30C30C30, 0x3FEBAD70, 0x3AFBBFBF, 0x3AEBAEBE, 0x3AE79D25, 0x39E79D75, 0x3AEBEFB9, 0x3AEBAEB9, 
	0x3AFBAEBA, 0x30FBEFBE, 0x34D35D75, 0x3AEB5D75, 0x20C30C35, 0x21860820, 0x21861861, 0x18614525, 
	0x2CB2CA1C, 0x2CB2872C, 0x39A68728, 0x3AEBAEAA, 0x3EFBEEAE, 0x3FFBEEBE, 0x3AFBAFFA, 0x3AA7AABA, 
	0x10410969, 0x14920424, 0x24925921, 0x25964965, 0x35975A75, 0x29D69D69, 0x35A75A75, 0x00D65E65, 
	0x35E65E75, 0x25975E65, 0x39D75975, 0x35E79975, 0x35935979, 0x24964965, 0x3FFFEEB9, 0x3FEFFFFF, 
	0x3BEBBFBA, 0x3FEBEEFE, 0x3EEBEEBA, 0x35D75EBA, 0x3EFFAEB5, 0x3EEBEEBE, 0x3AEBAEBA, 0x39E74D79, 
	0x39E79E79, 0x39D7AFB9, 0x39E79E75, 0x39E79E79, 0x39E79E7A, 0x35D75D7D, 0x35EBAD75, 0x20830C31, 
	0x21860820, 0x21861861, 0x18618520, 0x2CB2CB28, 0x28B2CB2C, 0x3AA68B2C, 0x3EFBEEBA, 0x3EEBEFBA, 
	0x3EEBFFBB, 0x2AEAAEBE, 0x24969E7A, 0x24524410, 0x25814910, 0x25964924, 0x24D65964, 0x25E65D69, 
	0x35975975, 0x29D65D69, 0x00979975, 0x39975D65, 0x25D79975, 0x29D69D79, 0x39975E75, 0x25D65D65, 
	0x25964974, 0x3EEB9964, 0x3FFBFFBF, 0x3AFBEFFF, 0x3AEBAFBA, 0x3AEBAEBE, 0x3AEBAEBA, 0x3AEBADBA, 
	0x3AFBAFBA, 0x3AEBAEBA, 0x39D2593A, 0x39E79E75, 0x39E79E79, 0x39E79E79, 0x39D79D79, 0x3DF79E79, 
	0x35D75E7D, 0x35D7AD75, 0x20830C30, 0x21860820, 0x20821861, 0x18614524, 0x2DB6DB18, 0x2CB2CB2C, 
	0x3EEBEA69, 0x3AFBAFBE, 0x3FFBFEBF, 0x2AEBEEBE, 0x3AA7AABA, 0x10424969, 0x14810424, 0x20520920, 
	0x25924964, 0x35965925, 0x29D65E65, 0x35A75A75, 0x35D79A75, 0x00E65D69, 0x25E65E79, 0x35A65D79, 
	0x35E75E65, 0x35E79979, 0x35975935, 0x25925D65, 0x25964964, 0x3FFFEFFA, 0x3FFFFFFE, 0x3AFBBFBF, 
	0x3AFBAFBB, 0x3EEBEEBE, 0x3AEB6DFA, 0x3AEBAEBA, 0x36EAAEBA, 0x39E79D62, 0x39E79E79, 0x39E79E79, 
	0x39E79E79, 0x39E79E79, 0x3DFBDD79, 0x39EB9F3D, 0x31D79EB5, 0x25C30C34, 0x24860924, 0x24924A28, 
	0x28A68A24, 0x2CB2CB29, 0x3EAADB6C, 0x3AFFEFBE, 0x3EFFEEFE, 0x3AFBAFFE, 0x3AEAAEBA, 0x25A79EA9, 
	0x14810420, 0x10914910, 0x25924424, 0x24964920, 0x25935975, 0x35A75974, 0x29D65D65, 0x25A75D65, 
	0x00979979, 0x35D79975, 0x35D75975, 0x39D69D79, 0x25D75E65, 0x35939979, 0x24D64964, 0x24925925, 
	0x3AFAA964, 0x3FFBFFBF, 0x3BFBFFFE, 0x3AEBAEBE, 0x3BFBAFBA, 0x36CB6EBE, 0x36DB6DB6, 0x21CB2DB6, 
	0x3AEBADB1, 0x3AEBAEBA, 0x3AE7AEBA, 0x39E7AE79, 0x39E79E79, 0x3DF7EF79, 0x36D79E3D, 0x30C35DBA, 
	0x24970C30, 0x2CB28965, 0x2CB2CB2C, 0x3AABAA68, 0x3EEFEEBE, 0x3EFBBFBB, 0x3EEBFEBF, 0x3FEBFFBF, 
	0x2AEBAEBA, 0x39AB9ABA, 0x10414969, 0x10520510, 0x24420520, 0x24824924, 0x25925924, 0x35975965, 
	0x35D69D65, 0x35A75A79, 0x35D69D75, 0x00D65E75, 0x29965E65, 0x29D69D65, 0x25E75A75, 0x35969D79, 
	0x25D65D65, 0x25925D25, 0x24964935, 0x25920925, 0x3FEBFEBA, 0x3FFFEFFF, 0x3BFBFFFE, 0x3EEBBEBE, 
	0x3AEFAFFA, 0x32CB2DB6, 0x32CB2CB2, 0x3EFBAEB6, 0x3EEBEFBE, 0x3AEBAFBA, 0x3AEBAEBA, 0x39E79E7A, 
	0x3DF7DF7D, 0x35D74F39, 0x30C31D75, 0x25964C30, 0x3DB2CA25, 0x2CB2CB3D, 0x3EFBAB2C, 0x3FFBEFFA, 
	0x3AFFEFFE, 0x3FFBFFBF, 0x3AABAEBA, 0x29EAAEAA, 0x10965A7A, 0x14810410, 0x14814420, 0x24924424, 
	0x25925910, 0x35965964, 0x24E65E65, 0x39975A75, 0x25D75D65, 0x35A75969, 0x00979969, 0x35D75E75, 
	0x35E75D79, 0x39D79D79, 0x29D75D65, 0x34975975, 0x34975965, 0x24924965, 0x24925924, 0x3AEA5924, 
	0x3FFBFEBE, 0x3EFFFFBF, 0x3EEFEFBF, 0x3FEBEFBA, 0x3AEBEEBE, 0x3EFBAEBA, 0x3EEBEFBE, 0x3AFBAFBA, 
	0x3EFBEEBE, 0x3EEBEFBE, 0x3DF7DF79, 0x3DF79F78, 0x30C38E38, 0x30C30C34, 0x25925C30, 0x2CB29A79, 
	0x2DB2CB2C, 0x3EEFEEBD, 0x3FEBFEBF, 0x3EFFAFFA, 0x3AEBAFBA, 0x29EBAEAA, 0x25A79A7A, 0x10410424, 
	0x10410410, 0x10814814, 0x25910924, 0x24924924, 0x39975925, 0x29D65D65, 0x35975935, 0x35A75A79, 
	0x29D65E75, 0x00E65D75, 0x35965979, 0x29D65E65, 0x35A75A75, 0x35979979, 0x25D65E65, 0x25D64D75, 
	0x25965D25, 0x24964964, 0x24924925, 0x3AEBAA65, 0x3FFFEEFE, 0x3FFBFFFF, 0x3AFFFEFF, 0x3EFFEFFE, 
	0x3AFBEFBE, 0x3FFBFEBE, 0x3EFBEEFE, 0x3EEBEFBE, 0x39FBEEBA, 0x3DF7DE7D, 0x39E78F7D, 0x35EB9E7D, 
	0x35C35D75, 0x3AEBAD75, 0x3AFBAFBA, 0x3AFBEFBE, 0x3AFFEFFE, 0x3FFBFFBF, 0x3AEBEEBE, 0x3AABAEBA, 
	0x39AA9EBA, 0x10414965, 0x10410410, 0x14814814, 0x24520520, 0x24824910, 0x25925925, 0x25D69965, 
	0x35979979, 0x25E65D65, 0x29D79D65, 0x35979975, 0x00979979, 0x25E75965, 0x35E75D79, 0x35D79D79, 
	0x39975D65, 0x35974975, 0x25D65E64, 0x24964974, 0x24924964, 0x20920920, 0x25924924, 0x3EEBEEAA, 
	0x3FFFEFFA, 0x3FFBFFBF, 0x3EEFEEFF, 0x3FEBFEFF, 0x3EEBEFFE, 0x3EEFEFBA, 0x3FFBBFBB, 0x3EEFEFFE, 
	0x39E7DF7E, 0x3EFF9E79, 0x3EFBFFBB, 0x3EEBAFBA, 0x3EEBEEBA, 0x3EFFEEFE, 0x3FFFBFBF, 0x3EEFEEFF, 
	0x3AEBAEBE, 0x3AABAABA, 0x39EA9EAA, 0x10925969, 0x10410410, 0x14814410, 0x20410420, 0x20914814, 
	0x25925924, 0x25964964, 0x29D75D78, 0x39D65D75, 0x35935A75, 0x35A75A75, 0x35D65E75, 0x00D65D65, 
	0x35D65E75, 0x29D79A75, 0x29975A75, 0x25E75A75, 0x25D65D65, 0x34975D79, 0x35975965, 0x25925925, 
	0x24925924, 0x24825824, 0x29965410, 0x3AEBAEBA, 0x3EEFEEFE, 0x3FFBFFBF, 0x3EFFEFBE, 0x3FFFBFBB, 
	0x3FFBAFFE, 0x3AFFEFBE, 0x3EFFEEFE, 0x3FFBFEBF, 0x3EFFEFFE, 0x3AFFAFBF, 0x3BFBFFBF, 0x3EFFAFFE, 
	0x3FEBFFBB, 0x3AEBEFFA, 0x2AEBAFBA, 0x3AABAABA, 0x29EB9EAA, 0x10925979, 0x10410410, 0x14410410, 
	0x10410410, 0x20520510, 0x24824814, 0x24924825, 0x39D75965, 0x35969965, 0x35A75E65, 0x25E65D65, 
	0x39D69D79, 0x25A75D65, 0x00979979, 0x39A79D65, 0x39D69D75, 0x35D69D75, 0x35D65D65, 0x35975E65, 
	0x25D65D65, 0x25D65935, 0x24964975, 0x25824925, 0x10924924, 0x20924910, 0x25965924, 0x3AFBAEAA, 
	0x3EEFEEFE, 0x3EFFAFFB, 0x3BFBEFBF, 0x3EEBFFFE, 0x3FFBBFBB, 0x3BFBBFBE, 0x3EFFEFFE, 0x3FEBFFBF, 
	0x3FEBEFFA, 0x3AFBAEBA, 0x3AEBEEBA, 0x3AEBAEBA, 0x3AEBAEBA, 0x3AEAAEAA, 0x29E69EBA, 0x10925969, 
	0x10410410, 0x10410410, 0x10814410, 0x24424424, 0x14814810, 0x24924920, 0x25964964, 0x35A65A75, 
	0x35E75D79, 0x29D79979, 0x35979D79, 0x35A75D65, 0x35D79979, 0x00E65D65, 0x25D75A75, 0x35A75E79, 
	0x29D65D69, 0x24E65E75, 0x39D69D75, 0x35935A75, 0x35A75D65, 0x24964D65, 0x20925924, 0x10920925, 
	0x24924924, 0x24920920, 0x25964920, 0x3AEAAA65, 0x3AEBEEBE, 0x3EEFEEFE, 0x3EFFEEBE, 0x3AFBEEFE, 
	0x3EEBEEBF, 0x3AEBAEBE, 0x3AFBAEBA, 0x3AEBAEBE, 0x3AEBAFBA, 0x3AEBAEBA, 0x3AEBAEBA, 0x3AABAABA, 
	0x29A79EBA, 0x10425925, 0x10410410, 0x10410410, 0x14424414, 0x10510410, 0x10410410, 0x20520520, 
	0x24964424, 0x39965925, 0x29D79D65, 0x39979A75, 0x35E65D65, 0x29D75A75, 0x29D65974, 0x29D65E75, 
	0x00975A75, 0x39A75D69, 0x25E75979, 0x35A75975, 0x25D75975, 0x35D75979, 0x35A75D65, 0x25D69D65, 
	0x24975939, 0x24924965, 0x24424824, 0x20920964, 0x20924924, 0x20910924, 0x24824824, 0x2AA65964, 
	0x3AFBAEBA, 0x3AEBAFBA, 0x3AEBEEBA, 0x3EEBEEBE, 0x3AFBEEBA, 0x3AEBEEBE, 0x3AFBAEBA, 0x3AEBAEBA, 
	0x3AABAABA, 0x29EAAEAA, 0x24965A69, 0x10410524, 0x10410410, 0x10410410, 0x14414410, 0x10410410, 
	0x24410420, 0x10910910, 0x24824424, 0x25925920, 0x25D25D65, 0x39979E75, 0x25E75E75, 0x39D79E75, 
	0x35A75D65, 0x35979D65, 0x35E75A75, 0x00D65D69, 0x35D79A75, 0x35979E65, 0x25D69D69, 0x35A75979, 
	0x39979D65, 0x25D65D65, 0x39975D79, 0x35925D65, 0x25925924, 0x25910924, 0x25924924, 0x24824824, 
	0x24824824, 0x10910910, 0x24814824, 0x25964910, 0x29A65965, 0x3AEBAEBA, 0x3AEBAEBA, 0x3AEBAEBA, 
	0x3AABAEBA, 0x3AABAABA, 0x29A69AA9, 0x24965965, 0x10420524, 0x10410410, 0x10410410, 0x10510410, 
	0x14414414, 0x20410510, 0x10910910, 0x20410414, 0x24814814, 0x24920910, 0x35965925, 0x35A75E65, 
	0x35E75979, 0x39D69D69, 0x29D65E65, 0x35D79A75, 0x29D75979, 0x35A75E75, 0x00A75A75, 0x39E65E75, 
	0x35975979, 0x35E75975, 0x35D65E65, 0x25E75979, 0x39975A75, 0x35E75E65, 0x35975964, 0x24964D65, 
	0x24924425, 0x24924925, 0x24964964, 0x24924925, 0x24920520, 0x10920910, 0x24410410, 0x10810910, 
	0x10510410, 0x14914914, 0x24524524, 0x14924914, 0x10410910, 0x10410410, 0x10410410, 0x10410410, 
	0x10410410, 0x14414410, 0x10410510, 0x20410420, 0x14414810, 0x24424410, 0x14410920, 0x20520920, 
	0x25925924, 0x39974964, 0x25E75A75, 0x39D69E75, 0x35A75E79, 0x35D79979, 0x25E65D79, 0x25D65E75, 
	0x29D69D65, 0x00D69D75, 0x25D79D69, 0x39D65E75, 0x39975E65, 0x25E65D65, 0x35975E75, 0x35E65D75, 
	0x25E65E75, 0x25D25D75, 0x25D35975, 0x25965910, 0x25925924, 0x24924924, 0x10960964, 0x20924824, 
	0x10424424, 0x10924924, 0x24424424, 0x20424424, 0x10410410, 0x10410410, 0x10410410, 0x20520410, 
	0x10410414, 0x10414410, 0x14414410, 0x10510510, 0x10810414, 0x14814810, 0x10520510, 0x20520414, 
	0x10910910, 0x10424424, 0x24924524, 0x24964925, 0x25D25975, 0x39D69D79, 0x29E75D69, 0x29E75A75, 
	0x39975E75, 0x39979E65, 0x35A75975, 0x35E75979, 0x00975979, 0x39979975, 0x25E75975, 0x25E65D75, 
	0x35D79975, 0x35D65D69, 0x35E75969, 0x35979D69, 0x39D79975, 0x24975E65, 0x24D65D64, 0x24924964, 
	0x24964964, 0x24924925, 0x24824964, 0x24424920, 0x14810824, 0x20520520, 0x10420510, 0x24424424, 
	0x10910910, 0x10414424, 0x10414810, 0x14414810, 0x14420510, 0x10810510, 0x20420410, 0x14424410, 
	0x10410520, 0x20510814, 0x10814814, 0x20520524, 0x10924924, 0x25965925, 0x35965964, 0x25D75935, 
	0x39E75A75, 0x35E69D79, 0x39D79D79, 0x35E65E75, 0x35D65D79, 0x35D79D69, 0x39979965, 0x00E65E65, 
	0x25E75E79, 0x35965E65, 0x35979D69, 0x29D65E65, 0x35979975, 0x39979D75, 0x29D65E75, 0x25D65E75, 
	0x25925D79, 0x25975E75, 0x24965935, 0x24925925, 0x24825924, 0x24924920, 0x24410914, 0x20524910, 
	0x14814814, 0x14914824, 0x10810520, 0x10410414, 0x14420410, 0x14810510, 0x10810520, 0x20510810, 
	0x10510810, 0x14414424, 0x20510910, 0x20524414, 0x14824424, 0x24520520, 0x24924920, 0x10964964, 
	0x25D25964, 0x25D74975, 0x39969D79, 0x35E79E75, 0x39D79D79, 0x39E65E69, 0x29D75E65, 0x25E75A75, 
	0x39975A75, 0x25D65D65, 0x00979D79, 0x35D65D65, 0x35D79975, 0x39975979, 0x35D79D75, 0x29D65D79, 
	0x35E75A75, 0x35D75D79, 0x39D79D65, 0x39964E65, 0x39E79979, 0x24964D65, 0x24965925, 0x24964925, 
	0x20925925, 0x24910824, 0x24824824, 0x20924920, 0x14810814, 0x20514820, 0x20520520, 0x10814414, 
	0x20414810, 0x24414414, 0x14420510, 0x24420510, 0x10910910, 0x14424424, 0x10520520, 0x20524424, 
	0x14824814, 0x25964964, 0x25D65925, 0x29D65D60, 0x34975974, 0x25D75E65, 0x39E75979, 0x35E65E79, 
	0x39979D79, 0x35D79979, 0x39E65E65, 0x35979D65, 0x35A75979, 0x00E65E65, 0x25975A75, 0x29D65D69, 
	0x35975975, 0x25E65E65, 0x35975A75, 0x39979D79, 0x39979979, 0x39975A75, 0x35E65935, 0x35E75E79, 
	0x35E75E79, 0x25925975, 0x25924964, 0x24964924, 0x20964425, 0x24914964, 0x24560525, 0x20914920, 
	0x14820514, 0x14424424, 0x10520520, 0x14824410, 0x10910820, 0x20510910, 0x10914814, 0x24424424, 
	0x20910910, 0x24814814, 0x24920924, 0x25925924, 0x25925964, 0x39979975, 0x35E75924, 0x29D79D69, 
	0x35E69D75, 0x29D69D75, 0x35A79E75, 0x39E75E69, 0x39A75E75, 0x35979D75, 0x35E65D79, 0x25D65E65, 
	0x00D79975, 0x39D65D65, 0x35E75975, 0x29D69D65, 0x35975E75, 0x39D65D65, 0x39E75A75, 0x35D65D65, 
	0x35E75D69, 0x39E79965, 0x39E79E79, 0x39E69D79, 0x35D79E79, 0x24964965, 0x24925925, 0x24925424, 
	0x20960925, 0x20924824, 0x14824464, 0x14910920, 0x24424420, 0x10910910, 0x14424910, 0x14814520, 
	0x10920520, 0x24424424, 0x20910910, 0x24924424, 0x24924924, 0x25964964, 0x35965965, 0x35D75D65, 
	0x39D65E79, 0x39979825, 0x35A75975, 0x35D79E75, 0x39D75E69, 0x35E75E79, 0x25E79D79, 0x39D79A79, 
	0x29D65E65, 0x25E75A75, 0x24E75979, 0x00975A75, 0x25A75A75, 0x25D69E75, 0x35975979, 0x25E75979, 
	0x25E79979, 0x25D79D79, 0x29E75E75, 0x25D69E75, 0x39D79E64, 0x39D79E79, 0x35E79E75, 0x39E75E79, 
	0x35975D65, 0x25964964, 0x24964920, 0x24925924, 0x25925925, 0x24964924, 0x24824924, 0x20920924, 
	0x14424424, 0x20910910, 0x14824824, 0x24424920, 0x24920920, 0x24964924, 0x25825924, 0x25964964, 
	0x35965965, 0x25E65D64, 0x39A75A79, 0x25E79E65, 0x35E65939, 0x39D75E79, 0x39E65D65, 0x35E69D75, 
	0x39E79D79, 0x39979E65, 0x35A75E75, 0x39D79D79, 0x39975E65, 0x35979975, 0x00E65D65, 0x39D65D65, 
	0x35A75D65, 0x25E65E65, 0x35D65E75, 0x35E65D65, 0x35A75E69, 0x35D69D65, 0x24979D79, 0x39E79E79, 
	0x39E79E79, 0x39E79E79, 0x35E79D79, 0x25E79E79, 0x25D65D79, 0x25925964, 0x24964925, 0x24924964, 
	0x25924925, 0x24964864, 0x15915921, 0x20924924, 0x24924910, 0x20924525, 0x24924814, 0x24864914, 
	0x25924825, 0x24964964, 0x35965965, 0x39A75E65, 0x35E75A79, 0x39D79E75, 0x39E65E75, 0x29D64979, 
	0x35E65E75, 0x29D79D79, 0x35A75D79, 0x39D79E79, 0x35E79979, 0x29E79D69, 0x39975A75, 0x25D79975, 
	0x25E65D79, 0x00975939, 0x25D69D69, 0x25D65E75, 0x35E75975, 0x25D65D69, 0x39979D79, 0x35D79D75, 
	0x29D79D79, 0x35975A75, 0x39E79E79, 0x35E79D79, 0x39E79E79, 0x35E79E79, 0x39E75E79, 0x24E79E75, 
	0x35E75E75, 0x25925D65, 0x25965925, 0x24965964, 0x25924925, 0x24924924, 0x24964964, 0x24964950, 
	0x24964964, 0x24964964, 0x25925925, 0x25965964, 0x35965965, 0x29D79D69, 0x25E79979, 0x29D69D79, 
	0x35A75979, 0x35E79E69, 0x35925E79, 0x39979D79, 0x35E65E65, 0x39D79979, 0x35E69D65, 0x39D65E79, 
	0x35E65E75, 0x25D79D79, 0x35E65E79, 0x35975E65, 0x00965D65, 0x29D65D65, 0x35975979, 0x25D69D69, 
	0x35A75975, 0x35E65E65, 0x29D65E69, 0x35A75A75, 0x39D65D79, 0x39E79E79, 0x39E79E79, 0x39E79E79, 
	0x39D79E75, 0x35A79E79, 0x25979979, 0x29E79A79, 0x39D79E79, 0x35D75E79, 0x25925D65, 0x25965964, 
	0x25965964, 0x25925925, 0x25925D64, 0x25925925, 0x25965965, 0x35965975, 0x39D69D69, 0x39D79D79, 
	0x39979979, 0x39979E75, 0x39E79A79, 0x39E79E75, 0x39E79D79, 0x39935E69, 0x35E75E69, 0x29D79D79, 
	0x29D75E75, 0x39D79E75, 0x29E75E79, 0x29D79979, 0x39979979, 0x35A75975, 0x39D69D69, 0x00D65E65, 
};
